// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteArchitectureParams creates a new DeleteArchitectureParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteArchitectureParams() *DeleteArchitectureParams {
	return &DeleteArchitectureParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteArchitectureParamsWithTimeout creates a new DeleteArchitectureParams object
// with the ability to set a timeout on a request.
func NewDeleteArchitectureParamsWithTimeout(timeout time.Duration) *DeleteArchitectureParams {
	return &DeleteArchitectureParams{
		timeout: timeout,
	}
}

// NewDeleteArchitectureParamsWithContext creates a new DeleteArchitectureParams object
// with the ability to set a context for a request.
func NewDeleteArchitectureParamsWithContext(ctx context.Context) *DeleteArchitectureParams {
	return &DeleteArchitectureParams{
		Context: ctx,
	}
}

// NewDeleteArchitectureParamsWithHTTPClient creates a new DeleteArchitectureParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteArchitectureParamsWithHTTPClient(client *http.Client) *DeleteArchitectureParams {
	return &DeleteArchitectureParams{
		HTTPClient: client,
	}
}

/*
DeleteArchitectureParams contains all the parameters to send to the API endpoint

	for the delete architecture operation.

	Typically these are written to a http.Request.
*/
type DeleteArchitectureParams struct {

	/* Architecture.

	   The name of the Architecture.
	*/
	Architecture string

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteArchitectureParams) WithDefaults() *DeleteArchitectureParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteArchitectureParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete architecture params
func (o *DeleteArchitectureParams) WithTimeout(timeout time.Duration) *DeleteArchitectureParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete architecture params
func (o *DeleteArchitectureParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete architecture params
func (o *DeleteArchitectureParams) WithContext(ctx context.Context) *DeleteArchitectureParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete architecture params
func (o *DeleteArchitectureParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete architecture params
func (o *DeleteArchitectureParams) WithHTTPClient(client *http.Client) *DeleteArchitectureParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete architecture params
func (o *DeleteArchitectureParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitecture adds the architecture to the delete architecture params
func (o *DeleteArchitectureParams) WithArchitecture(architecture string) *DeleteArchitectureParams {
	o.SetArchitecture(architecture)
	return o
}

// SetArchitecture adds the architecture to the delete architecture params
func (o *DeleteArchitectureParams) SetArchitecture(architecture string) {
	o.Architecture = architecture
}

// WithBox adds the box to the delete architecture params
func (o *DeleteArchitectureParams) WithBox(box string) *DeleteArchitectureParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the delete architecture params
func (o *DeleteArchitectureParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the delete architecture params
func (o *DeleteArchitectureParams) WithProvider(provider string) *DeleteArchitectureParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the delete architecture params
func (o *DeleteArchitectureParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the delete architecture params
func (o *DeleteArchitectureParams) WithRegistry(registry string) *DeleteArchitectureParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the delete architecture params
func (o *DeleteArchitectureParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the delete architecture params
func (o *DeleteArchitectureParams) WithVersion(version string) *DeleteArchitectureParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the delete architecture params
func (o *DeleteArchitectureParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteArchitectureParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param architecture
	if err := r.SetPathParam("architecture", o.Architecture); err != nil {
		return err
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
