// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceListChannelAssignmentHistoryReader is a Reader for the PackerServiceListChannelAssignmentHistory structure.
type PackerServiceListChannelAssignmentHistoryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceListChannelAssignmentHistoryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceListChannelAssignmentHistoryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceListChannelAssignmentHistoryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceListChannelAssignmentHistoryOK creates a PackerServiceListChannelAssignmentHistoryOK with default headers values
func NewPackerServiceListChannelAssignmentHistoryOK() *PackerServiceListChannelAssignmentHistoryOK {
	return &PackerServiceListChannelAssignmentHistoryOK{}
}

/*
PackerServiceListChannelAssignmentHistoryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceListChannelAssignmentHistoryOK struct {
	Payload *models.HashicorpCloudPacker20230101ListChannelAssignmentHistoryResponse
}

// IsSuccess returns true when this packer service list channel assignment history o k response has a 2xx status code
func (o *PackerServiceListChannelAssignmentHistoryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service list channel assignment history o k response has a 3xx status code
func (o *PackerServiceListChannelAssignmentHistoryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service list channel assignment history o k response has a 4xx status code
func (o *PackerServiceListChannelAssignmentHistoryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service list channel assignment history o k response has a 5xx status code
func (o *PackerServiceListChannelAssignmentHistoryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service list channel assignment history o k response a status code equal to that given
func (o *PackerServiceListChannelAssignmentHistoryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service list channel assignment history o k response
func (o *PackerServiceListChannelAssignmentHistoryOK) Code() int {
	return 200
}

func (o *PackerServiceListChannelAssignmentHistoryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}/history][%d] packerServiceListChannelAssignmentHistoryOK %s", 200, payload)
}

func (o *PackerServiceListChannelAssignmentHistoryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}/history][%d] packerServiceListChannelAssignmentHistoryOK %s", 200, payload)
}

func (o *PackerServiceListChannelAssignmentHistoryOK) GetPayload() *models.HashicorpCloudPacker20230101ListChannelAssignmentHistoryResponse {
	return o.Payload
}

func (o *PackerServiceListChannelAssignmentHistoryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101ListChannelAssignmentHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceListChannelAssignmentHistoryDefault creates a PackerServiceListChannelAssignmentHistoryDefault with default headers values
func NewPackerServiceListChannelAssignmentHistoryDefault(code int) *PackerServiceListChannelAssignmentHistoryDefault {
	return &PackerServiceListChannelAssignmentHistoryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceListChannelAssignmentHistoryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceListChannelAssignmentHistoryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service list channel assignment history default response has a 2xx status code
func (o *PackerServiceListChannelAssignmentHistoryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service list channel assignment history default response has a 3xx status code
func (o *PackerServiceListChannelAssignmentHistoryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service list channel assignment history default response has a 4xx status code
func (o *PackerServiceListChannelAssignmentHistoryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service list channel assignment history default response has a 5xx status code
func (o *PackerServiceListChannelAssignmentHistoryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service list channel assignment history default response a status code equal to that given
func (o *PackerServiceListChannelAssignmentHistoryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service list channel assignment history default response
func (o *PackerServiceListChannelAssignmentHistoryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceListChannelAssignmentHistoryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}/history][%d] PackerService_ListChannelAssignmentHistory default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelAssignmentHistoryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}/history][%d] PackerService_ListChannelAssignmentHistory default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelAssignmentHistoryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceListChannelAssignmentHistoryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
