// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceGetChannelParams creates a new PackerServiceGetChannelParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetChannelParams() *PackerServiceGetChannelParams {
	return &PackerServiceGetChannelParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetChannelParamsWithTimeout creates a new PackerServiceGetChannelParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetChannelParamsWithTimeout(timeout time.Duration) *PackerServiceGetChannelParams {
	return &PackerServiceGetChannelParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetChannelParamsWithContext creates a new PackerServiceGetChannelParams object
// with the ability to set a context for a request.
func NewPackerServiceGetChannelParamsWithContext(ctx context.Context) *PackerServiceGetChannelParams {
	return &PackerServiceGetChannelParams{
		Context: ctx,
	}
}

// NewPackerServiceGetChannelParamsWithHTTPClient creates a new PackerServiceGetChannelParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetChannelParamsWithHTTPClient(client *http.Client) *PackerServiceGetChannelParams {
	return &PackerServiceGetChannelParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetChannelParams contains all the parameters to send to the API endpoint

	for the packer service get channel operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetChannelParams struct {

	// BucketName.
	BucketName string

	// ChannelName.
	ChannelName string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get channel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetChannelParams) WithDefaults() *PackerServiceGetChannelParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get channel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetChannelParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithTimeout(timeout time.Duration) *PackerServiceGetChannelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithContext(ctx context.Context) *PackerServiceGetChannelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithHTTPClient(client *http.Client) *PackerServiceGetChannelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketName adds the bucketName to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithBucketName(bucketName string) *PackerServiceGetChannelParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetBucketName(bucketName string) {
	o.BucketName = bucketName
}

// WithChannelName adds the channelName to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithChannelName(channelName string) *PackerServiceGetChannelParams {
	o.SetChannelName(channelName)
	return o
}

// SetChannelName adds the channelName to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetChannelName(channelName string) {
	o.ChannelName = channelName
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetChannelParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetChannelParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetChannelParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get channel params
func (o *PackerServiceGetChannelParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetChannelParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get channel params
func (o *PackerServiceGetChannelParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetChannelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param bucket_name
	if err := r.SetPathParam("bucket_name", o.BucketName); err != nil {
		return err
	}

	// path param channel_name
	if err := r.SetPathParam("channel_name", o.ChannelName); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
