// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907HVNRouteTarget HVNRouteTarget is a wrapper around HVN Route target that allows us to
// add more types of targets in the future.
//
// swagger:model hashicorp.cloud.network_20200907.HVNRouteTarget
type HashicorpCloudNetwork20200907HVNRouteTarget struct {

	// hvn_connection is a link-type target for HVN connections (peerings and TGW attachments)
	HvnConnection *cloud.HashicorpCloudLocationLink `json:"hvn_connection,omitempty"`
}

// Validate validates this hashicorp cloud network 20200907 h v n route target
func (m *HashicorpCloudNetwork20200907HVNRouteTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHvnConnection(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRouteTarget) validateHvnConnection(formats strfmt.Registry) error {
	if swag.IsZero(m.HvnConnection) { // not required
		return nil
	}

	if m.HvnConnection != nil {
		if err := m.HvnConnection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn_connection")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn_connection")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 h v n route target based on the context it is used
func (m *HashicorpCloudNetwork20200907HVNRouteTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHvnConnection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907HVNRouteTarget) contextValidateHvnConnection(ctx context.Context, formats strfmt.Registry) error {

	if m.HvnConnection != nil {

		if swag.IsZero(m.HvnConnection) { // not required
			return nil
		}

		if err := m.HvnConnection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn_connection")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn_connection")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907HVNRouteTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907HVNRouteTarget) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907HVNRouteTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
