// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/stable/2020-09-07/models"
)

// NewCreateTokenParams creates a new CreateTokenParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateTokenParams() *CreateTokenParams {
	return &CreateTokenParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateTokenParamsWithTimeout creates a new CreateTokenParams object
// with the ability to set a timeout on a request.
func NewCreateTokenParamsWithTimeout(timeout time.Duration) *CreateTokenParams {
	return &CreateTokenParams{
		timeout: timeout,
	}
}

// NewCreateTokenParamsWithContext creates a new CreateTokenParams object
// with the ability to set a context for a request.
func NewCreateTokenParamsWithContext(ctx context.Context) *CreateTokenParams {
	return &CreateTokenParams{
		Context: ctx,
	}
}

// NewCreateTokenParamsWithHTTPClient creates a new CreateTokenParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateTokenParamsWithHTTPClient(client *http.Client) *CreateTokenParams {
	return &CreateTokenParams{
		HTTPClient: client,
	}
}

/*
CreateTokenParams contains all the parameters to send to the API endpoint

	for the create token operation.

	Typically these are written to a http.Request.
*/
type CreateTokenParams struct {

	// Body.
	Body *models.HashicorpCloudNetwork20200907CreateTokenRequest

	/* ID.

	   id the id of the HVN we are creating a token for.
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create token params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTokenParams) WithDefaults() *CreateTokenParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create token params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTokenParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create token params
func (o *CreateTokenParams) WithTimeout(timeout time.Duration) *CreateTokenParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create token params
func (o *CreateTokenParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create token params
func (o *CreateTokenParams) WithContext(ctx context.Context) *CreateTokenParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create token params
func (o *CreateTokenParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create token params
func (o *CreateTokenParams) WithHTTPClient(client *http.Client) *CreateTokenParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create token params
func (o *CreateTokenParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create token params
func (o *CreateTokenParams) WithBody(body *models.HashicorpCloudNetwork20200907CreateTokenRequest) *CreateTokenParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create token params
func (o *CreateTokenParams) SetBody(body *models.HashicorpCloudNetwork20200907CreateTokenRequest) {
	o.Body = body
}

// WithID adds the id to the create token params
func (o *CreateTokenParams) WithID(id string) *CreateTokenParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the create token params
func (o *CreateTokenParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the create token params
func (o *CreateTokenParams) WithLocationOrganizationID(locationOrganizationID string) *CreateTokenParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the create token params
func (o *CreateTokenParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the create token params
func (o *CreateTokenParams) WithLocationProjectID(locationProjectID string) *CreateTokenParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the create token params
func (o *CreateTokenParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateTokenParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
