// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/stable/2020-09-07/models"
)

// NewCreateHVNRouteParams creates a new CreateHVNRouteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateHVNRouteParams() *CreateHVNRouteParams {
	return &CreateHVNRouteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateHVNRouteParamsWithTimeout creates a new CreateHVNRouteParams object
// with the ability to set a timeout on a request.
func NewCreateHVNRouteParamsWithTimeout(timeout time.Duration) *CreateHVNRouteParams {
	return &CreateHVNRouteParams{
		timeout: timeout,
	}
}

// NewCreateHVNRouteParamsWithContext creates a new CreateHVNRouteParams object
// with the ability to set a context for a request.
func NewCreateHVNRouteParamsWithContext(ctx context.Context) *CreateHVNRouteParams {
	return &CreateHVNRouteParams{
		Context: ctx,
	}
}

// NewCreateHVNRouteParamsWithHTTPClient creates a new CreateHVNRouteParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateHVNRouteParamsWithHTTPClient(client *http.Client) *CreateHVNRouteParams {
	return &CreateHVNRouteParams{
		HTTPClient: client,
	}
}

/*
CreateHVNRouteParams contains all the parameters to send to the API endpoint

	for the create h v n route operation.

	Typically these are written to a http.Request.
*/
type CreateHVNRouteParams struct {

	// Body.
	Body *models.HashicorpCloudNetwork20200907CreateHVNRouteRequest

	/* HvnID.

	   id is the identifier for this resource.
	*/
	HvnID string

	/* HvnLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	HvnLocationOrganizationID string

	/* HvnLocationProjectID.

	   project_id is the projects id.
	*/
	HvnLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create h v n route params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateHVNRouteParams) WithDefaults() *CreateHVNRouteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create h v n route params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateHVNRouteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create h v n route params
func (o *CreateHVNRouteParams) WithTimeout(timeout time.Duration) *CreateHVNRouteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create h v n route params
func (o *CreateHVNRouteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create h v n route params
func (o *CreateHVNRouteParams) WithContext(ctx context.Context) *CreateHVNRouteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create h v n route params
func (o *CreateHVNRouteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create h v n route params
func (o *CreateHVNRouteParams) WithHTTPClient(client *http.Client) *CreateHVNRouteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create h v n route params
func (o *CreateHVNRouteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create h v n route params
func (o *CreateHVNRouteParams) WithBody(body *models.HashicorpCloudNetwork20200907CreateHVNRouteRequest) *CreateHVNRouteParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create h v n route params
func (o *CreateHVNRouteParams) SetBody(body *models.HashicorpCloudNetwork20200907CreateHVNRouteRequest) {
	o.Body = body
}

// WithHvnID adds the hvnID to the create h v n route params
func (o *CreateHVNRouteParams) WithHvnID(hvnID string) *CreateHVNRouteParams {
	o.SetHvnID(hvnID)
	return o
}

// SetHvnID adds the hvnId to the create h v n route params
func (o *CreateHVNRouteParams) SetHvnID(hvnID string) {
	o.HvnID = hvnID
}

// WithHvnLocationOrganizationID adds the hvnLocationOrganizationID to the create h v n route params
func (o *CreateHVNRouteParams) WithHvnLocationOrganizationID(hvnLocationOrganizationID string) *CreateHVNRouteParams {
	o.SetHvnLocationOrganizationID(hvnLocationOrganizationID)
	return o
}

// SetHvnLocationOrganizationID adds the hvnLocationOrganizationId to the create h v n route params
func (o *CreateHVNRouteParams) SetHvnLocationOrganizationID(hvnLocationOrganizationID string) {
	o.HvnLocationOrganizationID = hvnLocationOrganizationID
}

// WithHvnLocationProjectID adds the hvnLocationProjectID to the create h v n route params
func (o *CreateHVNRouteParams) WithHvnLocationProjectID(hvnLocationProjectID string) *CreateHVNRouteParams {
	o.SetHvnLocationProjectID(hvnLocationProjectID)
	return o
}

// SetHvnLocationProjectID adds the hvnLocationProjectId to the create h v n route params
func (o *CreateHVNRouteParams) SetHvnLocationProjectID(hvnLocationProjectID string) {
	o.HvnLocationProjectID = hvnLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateHVNRouteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param hvn.id
	if err := r.SetPathParam("hvn.id", o.HvnID); err != nil {
		return err
	}

	// path param hvn.location.organization_id
	if err := r.SetPathParam("hvn.location.organization_id", o.HvnLocationOrganizationID); err != nil {
		return err
	}

	// path param hvn.location.project_id
	if err := r.SetPathParam("hvn.location.project_id", o.HvnLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
