// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogService20210330CreateArchiveRequest ArchiveRequest represents a request to create an archive for a given resource.
//
// swagger:model log_service_20210330CreateArchiveRequest
type LogService20210330CreateArchiveRequest struct {

	// end defines the latest point in time from which to retrieve log entries.
	// Format: date-time
	ArchiveEndTime strfmt.DateTime `json:"archive_end_time,omitempty"`

	// start defines the earliest point in time from which to retrieve log entries.
	// Format: date-time
	ArchiveStartTime strfmt.DateTime `json:"archive_start_time,omitempty"`

	// resource identifies the resource related to the log entry if one exists.
	Resource *LocationLink `json:"resource,omitempty"`
}

// Validate validates this log service 20210330 create archive request
func (m *LogService20210330CreateArchiveRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchiveEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateArchiveStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330CreateArchiveRequest) validateArchiveEndTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveEndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("archive_end_time", "body", "date-time", m.ArchiveEndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogService20210330CreateArchiveRequest) validateArchiveStartTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("archive_start_time", "body", "date-time", m.ArchiveStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogService20210330CreateArchiveRequest) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 create archive request based on the context it is used
func (m *LogService20210330CreateArchiveRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330CreateArchiveRequest) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {

		if swag.IsZero(m.Resource) { // not required
			return nil
		}

		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330CreateArchiveRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330CreateArchiveRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330CreateArchiveRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
