// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// StreamingServiceCreateDestinationReader is a Reader for the StreamingServiceCreateDestination structure.
type StreamingServiceCreateDestinationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StreamingServiceCreateDestinationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStreamingServiceCreateDestinationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStreamingServiceCreateDestinationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStreamingServiceCreateDestinationOK creates a StreamingServiceCreateDestinationOK with default headers values
func NewStreamingServiceCreateDestinationOK() *StreamingServiceCreateDestinationOK {
	return &StreamingServiceCreateDestinationOK{}
}

/*
StreamingServiceCreateDestinationOK describes a response with status code 200, with default header values.

A successful response.
*/
type StreamingServiceCreateDestinationOK struct {
	Payload *models.LogService20210330CreateDestinationResponse
}

// IsSuccess returns true when this streaming service create destination o k response has a 2xx status code
func (o *StreamingServiceCreateDestinationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this streaming service create destination o k response has a 3xx status code
func (o *StreamingServiceCreateDestinationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this streaming service create destination o k response has a 4xx status code
func (o *StreamingServiceCreateDestinationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this streaming service create destination o k response has a 5xx status code
func (o *StreamingServiceCreateDestinationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this streaming service create destination o k response a status code equal to that given
func (o *StreamingServiceCreateDestinationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the streaming service create destination o k response
func (o *StreamingServiceCreateDestinationOK) Code() int {
	return 200
}

func (o *StreamingServiceCreateDestinationOK) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations][%d] streamingServiceCreateDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceCreateDestinationOK) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations][%d] streamingServiceCreateDestinationOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceCreateDestinationOK) GetPayload() *models.LogService20210330CreateDestinationResponse {
	return o.Payload
}

func (o *StreamingServiceCreateDestinationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330CreateDestinationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStreamingServiceCreateDestinationDefault creates a StreamingServiceCreateDestinationDefault with default headers values
func NewStreamingServiceCreateDestinationDefault(code int) *StreamingServiceCreateDestinationDefault {
	return &StreamingServiceCreateDestinationDefault{
		_statusCode: code,
	}
}

/*
StreamingServiceCreateDestinationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type StreamingServiceCreateDestinationDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this streaming service create destination default response has a 2xx status code
func (o *StreamingServiceCreateDestinationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this streaming service create destination default response has a 3xx status code
func (o *StreamingServiceCreateDestinationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this streaming service create destination default response has a 4xx status code
func (o *StreamingServiceCreateDestinationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this streaming service create destination default response has a 5xx status code
func (o *StreamingServiceCreateDestinationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this streaming service create destination default response a status code equal to that given
func (o *StreamingServiceCreateDestinationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the streaming service create destination default response
func (o *StreamingServiceCreateDestinationDefault) Code() int {
	return o._statusCode
}

func (o *StreamingServiceCreateDestinationDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations][%d] StreamingService_CreateDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceCreateDestinationDefault) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{organization_id}/destinations][%d] StreamingService_CreateDestination default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceCreateDestinationDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *StreamingServiceCreateDestinationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
