// Code generated by go-swagger; DO NOT EDIT.

package invitations_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// InvitationsServiceAcceptOrganizationInvitationReader is a Reader for the InvitationsServiceAcceptOrganizationInvitation structure.
type InvitationsServiceAcceptOrganizationInvitationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InvitationsServiceAcceptOrganizationInvitationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInvitationsServiceAcceptOrganizationInvitationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInvitationsServiceAcceptOrganizationInvitationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInvitationsServiceAcceptOrganizationInvitationOK creates a InvitationsServiceAcceptOrganizationInvitationOK with default headers values
func NewInvitationsServiceAcceptOrganizationInvitationOK() *InvitationsServiceAcceptOrganizationInvitationOK {
	return &InvitationsServiceAcceptOrganizationInvitationOK{}
}

/*
InvitationsServiceAcceptOrganizationInvitationOK describes a response with status code 200, with default header values.

A successful response.
*/
type InvitationsServiceAcceptOrganizationInvitationOK struct {
	Payload *models.HashicorpCloudIamAcceptOrganizationInvitationResponse
}

// IsSuccess returns true when this invitations service accept organization invitation o k response has a 2xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this invitations service accept organization invitation o k response has a 3xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this invitations service accept organization invitation o k response has a 4xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this invitations service accept organization invitation o k response has a 5xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this invitations service accept organization invitation o k response a status code equal to that given
func (o *InvitationsServiceAcceptOrganizationInvitationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the invitations service accept organization invitation o k response
func (o *InvitationsServiceAcceptOrganizationInvitationOK) Code() int {
	return 200
}

func (o *InvitationsServiceAcceptOrganizationInvitationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/accept-invitation][%d] invitationsServiceAcceptOrganizationInvitationOK %s", 200, payload)
}

func (o *InvitationsServiceAcceptOrganizationInvitationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/accept-invitation][%d] invitationsServiceAcceptOrganizationInvitationOK %s", 200, payload)
}

func (o *InvitationsServiceAcceptOrganizationInvitationOK) GetPayload() *models.HashicorpCloudIamAcceptOrganizationInvitationResponse {
	return o.Payload
}

func (o *InvitationsServiceAcceptOrganizationInvitationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamAcceptOrganizationInvitationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInvitationsServiceAcceptOrganizationInvitationDefault creates a InvitationsServiceAcceptOrganizationInvitationDefault with default headers values
func NewInvitationsServiceAcceptOrganizationInvitationDefault(code int) *InvitationsServiceAcceptOrganizationInvitationDefault {
	return &InvitationsServiceAcceptOrganizationInvitationDefault{
		_statusCode: code,
	}
}

/*
InvitationsServiceAcceptOrganizationInvitationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type InvitationsServiceAcceptOrganizationInvitationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this invitations service accept organization invitation default response has a 2xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this invitations service accept organization invitation default response has a 3xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this invitations service accept organization invitation default response has a 4xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this invitations service accept organization invitation default response has a 5xx status code
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this invitations service accept organization invitation default response a status code equal to that given
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the invitations service accept organization invitation default response
func (o *InvitationsServiceAcceptOrganizationInvitationDefault) Code() int {
	return o._statusCode
}

func (o *InvitationsServiceAcceptOrganizationInvitationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/accept-invitation][%d] InvitationsService_AcceptOrganizationInvitation default %s", o._statusCode, payload)
}

func (o *InvitationsServiceAcceptOrganizationInvitationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/accept-invitation][%d] InvitationsService_AcceptOrganizationInvitation default %s", o._statusCode, payload)
}

func (o *InvitationsServiceAcceptOrganizationInvitationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *InvitationsServiceAcceptOrganizationInvitationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
