// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceUpdateGroupMembersReader is a Reader for the GroupsServiceUpdateGroupMembers structure.
type GroupsServiceUpdateGroupMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceUpdateGroupMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceUpdateGroupMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceUpdateGroupMembersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceUpdateGroupMembersOK creates a GroupsServiceUpdateGroupMembersOK with default headers values
func NewGroupsServiceUpdateGroupMembersOK() *GroupsServiceUpdateGroupMembersOK {
	return &GroupsServiceUpdateGroupMembersOK{}
}

/*
GroupsServiceUpdateGroupMembersOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceUpdateGroupMembersOK struct {
	Payload interface{}
}

// IsSuccess returns true when this groups service update group members o k response has a 2xx status code
func (o *GroupsServiceUpdateGroupMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service update group members o k response has a 3xx status code
func (o *GroupsServiceUpdateGroupMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service update group members o k response has a 4xx status code
func (o *GroupsServiceUpdateGroupMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service update group members o k response has a 5xx status code
func (o *GroupsServiceUpdateGroupMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service update group members o k response a status code equal to that given
func (o *GroupsServiceUpdateGroupMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service update group members o k response
func (o *GroupsServiceUpdateGroupMembersOK) Code() int {
	return 200
}

func (o *GroupsServiceUpdateGroupMembersOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /iam/2019-12-10/{resource_name}/members][%d] groupsServiceUpdateGroupMembersOK %s", 200, payload)
}

func (o *GroupsServiceUpdateGroupMembersOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /iam/2019-12-10/{resource_name}/members][%d] groupsServiceUpdateGroupMembersOK %s", 200, payload)
}

func (o *GroupsServiceUpdateGroupMembersOK) GetPayload() interface{} {
	return o.Payload
}

func (o *GroupsServiceUpdateGroupMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceUpdateGroupMembersDefault creates a GroupsServiceUpdateGroupMembersDefault with default headers values
func NewGroupsServiceUpdateGroupMembersDefault(code int) *GroupsServiceUpdateGroupMembersDefault {
	return &GroupsServiceUpdateGroupMembersDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceUpdateGroupMembersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceUpdateGroupMembersDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service update group members default response has a 2xx status code
func (o *GroupsServiceUpdateGroupMembersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service update group members default response has a 3xx status code
func (o *GroupsServiceUpdateGroupMembersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service update group members default response has a 4xx status code
func (o *GroupsServiceUpdateGroupMembersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service update group members default response has a 5xx status code
func (o *GroupsServiceUpdateGroupMembersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service update group members default response a status code equal to that given
func (o *GroupsServiceUpdateGroupMembersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service update group members default response
func (o *GroupsServiceUpdateGroupMembersDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceUpdateGroupMembersDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /iam/2019-12-10/{resource_name}/members][%d] GroupsService_UpdateGroupMembers default %s", o._statusCode, payload)
}

func (o *GroupsServiceUpdateGroupMembersDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /iam/2019-12-10/{resource_name}/members][%d] GroupsService_UpdateGroupMembers default %s", o._statusCode, payload)
}

func (o *GroupsServiceUpdateGroupMembersDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceUpdateGroupMembersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupsServiceUpdateGroupMembersBody groups service update group members body
swagger:model GroupsServiceUpdateGroupMembersBody
*/
type GroupsServiceUpdateGroupMembersBody struct {

	// member_principal_ids_to_add is a list of the principal IDs which should be added
	// to the group.
	MemberPrincipalIdsToAdd []string `json:"member_principal_ids_to_add"`

	// member_principal_ids_to_remove is a list of the principal IDs which should be removed
	// from the group.
	MemberPrincipalIdsToRemove []string `json:"member_principal_ids_to_remove"`
}

// Validate validates this groups service update group members body
func (o *GroupsServiceUpdateGroupMembersBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this groups service update group members body based on context it is used
func (o *GroupsServiceUpdateGroupMembersBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *GroupsServiceUpdateGroupMembersBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupsServiceUpdateGroupMembersBody) UnmarshalBinary(b []byte) error {
	var res GroupsServiceUpdateGroupMembersBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
