// Code generated by go-swagger; DO NOT EDIT.

package consul_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListVersionsParams creates a new ListVersionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListVersionsParams() *ListVersionsParams {
	return &ListVersionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListVersionsParamsWithTimeout creates a new ListVersionsParams object
// with the ability to set a timeout on a request.
func NewListVersionsParamsWithTimeout(timeout time.Duration) *ListVersionsParams {
	return &ListVersionsParams{
		timeout: timeout,
	}
}

// NewListVersionsParamsWithContext creates a new ListVersionsParams object
// with the ability to set a context for a request.
func NewListVersionsParamsWithContext(ctx context.Context) *ListVersionsParams {
	return &ListVersionsParams{
		Context: ctx,
	}
}

// NewListVersionsParamsWithHTTPClient creates a new ListVersionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListVersionsParamsWithHTTPClient(client *http.Client) *ListVersionsParams {
	return &ListVersionsParams{
		HTTPClient: client,
	}
}

/*
ListVersionsParams contains all the parameters to send to the API endpoint

	for the list versions operation.

	Typically these are written to a http.Request.
*/
type ListVersionsParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	/* PlatformType.

	     PlatformType is an optional field specifying the platform (HCS, HCP or NOTSET)
	NOTSET, the default, will return the list of versions available for HCP.

	     Default: "NOTSET"
	*/
	PlatformType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list versions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListVersionsParams) WithDefaults() *ListVersionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list versions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListVersionsParams) SetDefaults() {
	var (
		platformTypeDefault = string("NOTSET")
	)

	val := ListVersionsParams{
		PlatformType: &platformTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the list versions params
func (o *ListVersionsParams) WithTimeout(timeout time.Duration) *ListVersionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list versions params
func (o *ListVersionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list versions params
func (o *ListVersionsParams) WithContext(ctx context.Context) *ListVersionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list versions params
func (o *ListVersionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list versions params
func (o *ListVersionsParams) WithHTTPClient(client *http.Client) *ListVersionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list versions params
func (o *ListVersionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the list versions params
func (o *ListVersionsParams) WithLocationOrganizationID(locationOrganizationID string) *ListVersionsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list versions params
func (o *ListVersionsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list versions params
func (o *ListVersionsParams) WithLocationProjectID(locationProjectID string) *ListVersionsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list versions params
func (o *ListVersionsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list versions params
func (o *ListVersionsParams) WithLocationRegionProvider(locationRegionProvider *string) *ListVersionsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list versions params
func (o *ListVersionsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list versions params
func (o *ListVersionsParams) WithLocationRegionRegion(locationRegionRegion *string) *ListVersionsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list versions params
func (o *ListVersionsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithPlatformType adds the platformType to the list versions params
func (o *ListVersionsParams) WithPlatformType(platformType *string) *ListVersionsParams {
	o.SetPlatformType(platformType)
	return o
}

// SetPlatformType adds the platformType to the list versions params
func (o *ListVersionsParams) SetPlatformType(platformType *string) {
	o.PlatformType = platformType
}

// WriteToRequest writes these params to a swagger request
func (o *ListVersionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PlatformType != nil {

		// query param platform_type
		var qrPlatformType string

		if o.PlatformType != nil {
			qrPlatformType = *o.PlatformType
		}
		qPlatformType := qrPlatformType
		if qPlatformType != "" {

			if err := r.SetQueryParam("platform_type", qPlatformType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
