// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// Billing20201105PackageItemType Type is a list of all possible types a PackageItem can have.
//
//   - UNSET: UNSET is not a valid type and will not be accepted by the service.
//   - SELECTION: SELECTION means that the value for this item must be supplied by the caller
//
// when registering a new resource (unless it's an optional item).
//   - COST: COST means that the value of this item will always be implicitly set by the billing
//
// service, depending on the available options of the package item.
// Items of this type are never selected by the user, but are a consequence of the
// `SELECTION` items they chose.
// The internal process to select a COST item follows these steps: (This applies only for Type COST)
//
//  1. If the item options have `dependencies`
//     1.a. It will assign the option key for the item with the option that matches
//     the dependencies.
//     There should never be more than one option with the same dependencies.
//     1.b. If there's no matching dependency, but the item also has an option
//     without dependency, that option will be assigned to it.
//  2. When there's no dependency at all, the existing option for the item will
//     be assigned for it.
//     There should never be more than 1 option per item without dependency.
//
// swagger:model billing_20201105PackageItemType
type Billing20201105PackageItemType string

func NewBilling20201105PackageItemType(value Billing20201105PackageItemType) *Billing20201105PackageItemType {
	return &value
}

// Pointer returns a pointer to a freshly-allocated Billing20201105PackageItemType.
func (m Billing20201105PackageItemType) Pointer() *Billing20201105PackageItemType {
	return &m
}

const (

	// Billing20201105PackageItemTypeUNSET captures enum value "UNSET"
	Billing20201105PackageItemTypeUNSET Billing20201105PackageItemType = "UNSET"

	// Billing20201105PackageItemTypeSELECTION captures enum value "SELECTION"
	Billing20201105PackageItemTypeSELECTION Billing20201105PackageItemType = "SELECTION"

	// Billing20201105PackageItemTypeCOST captures enum value "COST"
	Billing20201105PackageItemTypeCOST Billing20201105PackageItemType = "COST"
)

// for schema
var billing20201105PackageItemTypeEnum []interface{}

func init() {
	var res []Billing20201105PackageItemType
	if err := json.Unmarshal([]byte(`["UNSET","SELECTION","COST"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		billing20201105PackageItemTypeEnum = append(billing20201105PackageItemTypeEnum, v)
	}
}

func (m Billing20201105PackageItemType) validateBilling20201105PackageItemTypeEnum(path, location string, value Billing20201105PackageItemType) error {
	if err := validate.EnumCase(path, location, value, billing20201105PackageItemTypeEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this billing 20201105 package item type
func (m Billing20201105PackageItemType) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateBilling20201105PackageItemTypeEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this billing 20201105 package item type based on context it is used
func (m Billing20201105PackageItemType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
