// Code generated by go-swagger; DO NOT EDIT.

package f_c_p_management_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// FCPManagementServiceGetConsumptionPoolReader is a Reader for the FCPManagementServiceGetConsumptionPool structure.
type FCPManagementServiceGetConsumptionPoolReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FCPManagementServiceGetConsumptionPoolReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFCPManagementServiceGetConsumptionPoolOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFCPManagementServiceGetConsumptionPoolDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFCPManagementServiceGetConsumptionPoolOK creates a FCPManagementServiceGetConsumptionPoolOK with default headers values
func NewFCPManagementServiceGetConsumptionPoolOK() *FCPManagementServiceGetConsumptionPoolOK {
	return &FCPManagementServiceGetConsumptionPoolOK{}
}

/*
FCPManagementServiceGetConsumptionPoolOK describes a response with status code 200, with default header values.

A successful response.
*/
type FCPManagementServiceGetConsumptionPoolOK struct {
	Payload *models.Billing20201105GetConsumptionPoolResponse
}

// IsSuccess returns true when this f c p management service get consumption pool o k response has a 2xx status code
func (o *FCPManagementServiceGetConsumptionPoolOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this f c p management service get consumption pool o k response has a 3xx status code
func (o *FCPManagementServiceGetConsumptionPoolOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this f c p management service get consumption pool o k response has a 4xx status code
func (o *FCPManagementServiceGetConsumptionPoolOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this f c p management service get consumption pool o k response has a 5xx status code
func (o *FCPManagementServiceGetConsumptionPoolOK) IsServerError() bool {
	return false
}

// IsCode returns true when this f c p management service get consumption pool o k response a status code equal to that given
func (o *FCPManagementServiceGetConsumptionPoolOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the f c p management service get consumption pool o k response
func (o *FCPManagementServiceGetConsumptionPoolOK) Code() int {
	return 200
}

func (o *FCPManagementServiceGetConsumptionPoolOK) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/fcp-consumption-pools/{consumption_pool_id}][%d] fCPManagementServiceGetConsumptionPoolOK  %+v", 200, o.Payload)
}

func (o *FCPManagementServiceGetConsumptionPoolOK) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/fcp-consumption-pools/{consumption_pool_id}][%d] fCPManagementServiceGetConsumptionPoolOK  %+v", 200, o.Payload)
}

func (o *FCPManagementServiceGetConsumptionPoolOK) GetPayload() *models.Billing20201105GetConsumptionPoolResponse {
	return o.Payload
}

func (o *FCPManagementServiceGetConsumptionPoolOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Billing20201105GetConsumptionPoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFCPManagementServiceGetConsumptionPoolDefault creates a FCPManagementServiceGetConsumptionPoolDefault with default headers values
func NewFCPManagementServiceGetConsumptionPoolDefault(code int) *FCPManagementServiceGetConsumptionPoolDefault {
	return &FCPManagementServiceGetConsumptionPoolDefault{
		_statusCode: code,
	}
}

/*
FCPManagementServiceGetConsumptionPoolDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type FCPManagementServiceGetConsumptionPoolDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this f c p management service get consumption pool default response has a 2xx status code
func (o *FCPManagementServiceGetConsumptionPoolDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this f c p management service get consumption pool default response has a 3xx status code
func (o *FCPManagementServiceGetConsumptionPoolDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this f c p management service get consumption pool default response has a 4xx status code
func (o *FCPManagementServiceGetConsumptionPoolDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this f c p management service get consumption pool default response has a 5xx status code
func (o *FCPManagementServiceGetConsumptionPoolDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this f c p management service get consumption pool default response a status code equal to that given
func (o *FCPManagementServiceGetConsumptionPoolDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the f c p management service get consumption pool default response
func (o *FCPManagementServiceGetConsumptionPoolDefault) Code() int {
	return o._statusCode
}

func (o *FCPManagementServiceGetConsumptionPoolDefault) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/fcp-consumption-pools/{consumption_pool_id}][%d] FCPManagementService_GetConsumptionPool default  %+v", o._statusCode, o.Payload)
}

func (o *FCPManagementServiceGetConsumptionPoolDefault) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/fcp-consumption-pools/{consumption_pool_id}][%d] FCPManagementService_GetConsumptionPool default  %+v", o._statusCode, o.Payload)
}

func (o *FCPManagementServiceGetConsumptionPoolDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *FCPManagementServiceGetConsumptionPoolDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
