// Code generated by go-swagger; DO NOT EDIT.

package modelscapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RegisterRequest register request
//
// # Register request model
//
// swagger:model RegisterRequest
type RegisterRequest struct {

	// machine_id is a (username) generated by crowdsec
	// Required: true
	// Pattern: ^[a-zA-Z0-9]+$
	MachineID *string `json:"machine_id"`

	// Password, should respect the password policy (link to add)
	// Required: true
	Password *string `json:"password"`
}

// Validate validates this register request
func (m *RegisterRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMachineID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RegisterRequest) validateMachineID(formats strfmt.Registry) error {

	if err := validate.Required("machine_id", "body", m.MachineID); err != nil {
		return err
	}

	if err := validate.Pattern("machine_id", "body", *m.MachineID, `^[a-zA-Z0-9]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RegisterRequest) validatePassword(formats strfmt.Registry) error {

	if err := validate.Required("password", "body", m.Password); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this register request based on context it is used
func (m *RegisterRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *RegisterRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RegisterRequest) UnmarshalBinary(b []byte) error {
	var res RegisterRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
