// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourceexplorer2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateDefaultView = "AssociateDefaultView"

// AssociateDefaultViewRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDefaultView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDefaultView for more information on using the AssociateDefaultView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateDefaultViewRequest method.
//	req, resp := client.AssociateDefaultViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView
func (c *ResourceExplorer2) AssociateDefaultViewRequest(input *AssociateDefaultViewInput) (req *request.Request, output *AssociateDefaultViewOutput) {
	op := &request.Operation{
		Name:       opAssociateDefaultView,
		HTTPMethod: "POST",
		HTTPPath:   "/AssociateDefaultView",
	}

	if input == nil {
		input = &AssociateDefaultViewInput{}
	}

	output = &AssociateDefaultViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateDefaultView API operation for AWS Resource Explorer.
//
// Sets the specified view as the default for the Amazon Web Services Region
// in which you call this operation. When a user performs a Search that doesn't
// explicitly specify which view to use, then Amazon Web Services Resource Explorer
// automatically chooses this default view for searches performed in this Amazon
// Web Services Region.
//
// If an Amazon Web Services Region doesn't have a default view configured,
// then users must explicitly specify a view with every Search operation performed
// in that Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation AssociateDefaultView for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView
func (c *ResourceExplorer2) AssociateDefaultView(input *AssociateDefaultViewInput) (*AssociateDefaultViewOutput, error) {
	req, out := c.AssociateDefaultViewRequest(input)
	return out, req.Send()
}

// AssociateDefaultViewWithContext is the same as AssociateDefaultView with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDefaultView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) AssociateDefaultViewWithContext(ctx aws.Context, input *AssociateDefaultViewInput, opts ...request.Option) (*AssociateDefaultViewOutput, error) {
	req, out := c.AssociateDefaultViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetView = "BatchGetView"

// BatchGetViewRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetView for more information on using the BatchGetView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetViewRequest method.
//	req, resp := client.BatchGetViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView
func (c *ResourceExplorer2) BatchGetViewRequest(input *BatchGetViewInput) (req *request.Request, output *BatchGetViewOutput) {
	op := &request.Operation{
		Name:       opBatchGetView,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetView",
	}

	if input == nil {
		input = &BatchGetViewInput{}
	}

	output = &BatchGetViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetView API operation for AWS Resource Explorer.
//
// Retrieves details about a list of views.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation BatchGetView for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView
func (c *ResourceExplorer2) BatchGetView(input *BatchGetViewInput) (*BatchGetViewOutput, error) {
	req, out := c.BatchGetViewRequest(input)
	return out, req.Send()
}

// BatchGetViewWithContext is the same as BatchGetView with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) BatchGetViewWithContext(ctx aws.Context, input *BatchGetViewInput, opts ...request.Option) (*BatchGetViewOutput, error) {
	req, out := c.BatchGetViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIndex for more information on using the CreateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIndexRequest method.
//	req, resp := client.CreateIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex
func (c *ResourceExplorer2) CreateIndexRequest(input *CreateIndexInput) (req *request.Request, output *CreateIndexOutput) {
	op := &request.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateIndex",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	output = &CreateIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIndex API operation for AWS Resource Explorer.
//
// Turns on Amazon Web Services Resource Explorer in the Amazon Web Services
// Region in which you called this operation by creating an index. Resource
// Explorer begins discovering the resources in this Region and stores the details
// about the resources in the index so that they can be queried by using the
// Search operation. You can create only one index in a Region.
//
// This operation creates only a local index. To promote the local index in
// one Amazon Web Services Region into the aggregator index for the Amazon Web
// Services account, use the UpdateIndexType operation. For more information,
// see Turning on cross-Region search by creating an aggregator index (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html)
// in the Amazon Web Services Resource Explorer User Guide.
//
// For more details about what happens when you turn on Resource Explorer in
// an Amazon Web Services Region, see Turn on Resource Explorer to index your
// resources in an Amazon Web Services Region (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html)
// in the Amazon Web Services Resource Explorer User Guide.
//
// If this is the first Amazon Web Services Region in which you've created an
// index for Resource Explorer, then this operation also creates a service-linked
// role (https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html)
// in your Amazon Web Services account that allows Resource Explorer to enumerate
// your resources to populate the index.
//
//   - Action: resource-explorer-2:CreateIndex Resource: The ARN of the index
//     (as it will exist after the operation completes) in the Amazon Web Services
//     Region and account in which you're trying to create the index. Use the
//     wildcard character (*) at the end of the string to match the eventual
//     UUID. For example, the following Resource element restricts the role or
//     user to creating an index in only the us-east-2 Region of the specified
//     account. "Resource": "arn:aws:resource-explorer-2:us-west-2:<account-id>:index/*"
//     Alternatively, you can use "Resource": "*" to allow the role or user to
//     create an index in any Region.
//
//   - Action: iam:CreateServiceLinkedRole Resource: No specific resource (*).
//     This permission is required only the first time you create an index to
//     turn on Resource Explorer in the account. Resource Explorer uses this
//     to create the service-linked role needed to index the resources in your
//     account (https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html).
//     Resource Explorer uses the same service-linked role for all additional
//     indexes you create afterwards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation CreateIndex for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ConflictException
//     If you attempted to create a view, then the request failed because either
//     you specified parameters that didn’t match the original request, or you
//     attempted to create a view with a name that already exists in this Amazon
//     Web Services Region.
//
//     If you attempted to create an index, then the request failed because either
//     you specified parameters that didn't match the original request, or an index
//     already exists in the current Amazon Web Services Region.
//
//     If you attempted to update an index type to AGGREGATOR, then the request
//     failed because you already have an AGGREGATOR index in a different Amazon
//     Web Services Region.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex
func (c *ResourceExplorer2) CreateIndex(input *CreateIndexInput) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	return out, req.Send()
}

// CreateIndexWithContext is the same as CreateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) CreateIndexWithContext(ctx aws.Context, input *CreateIndexInput, opts ...request.Option) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateView = "CreateView"

// CreateViewRequest generates a "aws/request.Request" representing the
// client's request for the CreateView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateView for more information on using the CreateView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateViewRequest method.
//	req, resp := client.CreateViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView
func (c *ResourceExplorer2) CreateViewRequest(input *CreateViewInput) (req *request.Request, output *CreateViewOutput) {
	op := &request.Operation{
		Name:       opCreateView,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateView",
	}

	if input == nil {
		input = &CreateViewInput{}
	}

	output = &CreateViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateView API operation for AWS Resource Explorer.
//
// Creates a view that users can query by using the Search operation. Results
// from queries that you make using this view include only resources that match
// the view's Filters. For more information about Amazon Web Services Resource
// Explorer views, see Managing views (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html)
// in the Amazon Web Services Resource Explorer User Guide.
//
// Only the principals with an IAM identity-based policy that grants Allow to
// the Search action on a Resource with the Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// of this view can Search using views you create with this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation CreateView for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ConflictException
//     If you attempted to create a view, then the request failed because either
//     you specified parameters that didn’t match the original request, or you
//     attempted to create a view with a name that already exists in this Amazon
//     Web Services Region.
//
//     If you attempted to create an index, then the request failed because either
//     you specified parameters that didn't match the original request, or an index
//     already exists in the current Amazon Web Services Region.
//
//     If you attempted to update an index type to AGGREGATOR, then the request
//     failed because you already have an AGGREGATOR index in a different Amazon
//     Web Services Region.
//
//   - ServiceQuotaExceededException
//     The request failed because it exceeds a service quota.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView
func (c *ResourceExplorer2) CreateView(input *CreateViewInput) (*CreateViewOutput, error) {
	req, out := c.CreateViewRequest(input)
	return out, req.Send()
}

// CreateViewWithContext is the same as CreateView with the addition of
// the ability to pass a context and additional request options.
//
// See CreateView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) CreateViewWithContext(ctx aws.Context, input *CreateViewInput, opts ...request.Option) (*CreateViewOutput, error) {
	req, out := c.CreateViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIndex = "DeleteIndex"

// DeleteIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIndex for more information on using the DeleteIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIndexRequest method.
//	req, resp := client.DeleteIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex
func (c *ResourceExplorer2) DeleteIndexRequest(input *DeleteIndexInput) (req *request.Request, output *DeleteIndexOutput) {
	op := &request.Operation{
		Name:       opDeleteIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteIndex",
	}

	if input == nil {
		input = &DeleteIndexInput{}
	}

	output = &DeleteIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIndex API operation for AWS Resource Explorer.
//
// Deletes the specified index and turns off Amazon Web Services Resource Explorer
// in the specified Amazon Web Services Region. When you delete an index, Resource
// Explorer stops discovering and indexing resources in that Region. Resource
// Explorer also deletes all views in that Region. These actions occur as asynchronous
// background tasks. You can check to see when the actions are complete by using
// the GetIndex operation and checking the Status response value.
//
// If the index you delete is the aggregator index for the Amazon Web Services
// account, you must wait 24 hours before you can promote another local index
// to be the aggregator index for the account. Users can't perform account-wide
// searches using Resource Explorer until another aggregator index is configured.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation DeleteIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex
func (c *ResourceExplorer2) DeleteIndex(input *DeleteIndexInput) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	return out, req.Send()
}

// DeleteIndexWithContext is the same as DeleteIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) DeleteIndexWithContext(ctx aws.Context, input *DeleteIndexInput, opts ...request.Option) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteView = "DeleteView"

// DeleteViewRequest generates a "aws/request.Request" representing the
// client's request for the DeleteView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteView for more information on using the DeleteView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteViewRequest method.
//	req, resp := client.DeleteViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView
func (c *ResourceExplorer2) DeleteViewRequest(input *DeleteViewInput) (req *request.Request, output *DeleteViewOutput) {
	op := &request.Operation{
		Name:       opDeleteView,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteView",
	}

	if input == nil {
		input = &DeleteViewInput{}
	}

	output = &DeleteViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteView API operation for AWS Resource Explorer.
//
// Deletes the specified view.
//
// If the specified view is the default view for its Amazon Web Services Region,
// then all Search operations in that Region must explicitly specify the view
// to use until you configure a new default by calling the AssociateDefaultView
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation DeleteView for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView
func (c *ResourceExplorer2) DeleteView(input *DeleteViewInput) (*DeleteViewOutput, error) {
	req, out := c.DeleteViewRequest(input)
	return out, req.Send()
}

// DeleteViewWithContext is the same as DeleteView with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) DeleteViewWithContext(ctx aws.Context, input *DeleteViewInput, opts ...request.Option) (*DeleteViewOutput, error) {
	req, out := c.DeleteViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDefaultView = "DisassociateDefaultView"

// DisassociateDefaultViewRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDefaultView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDefaultView for more information on using the DisassociateDefaultView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateDefaultViewRequest method.
//	req, resp := client.DisassociateDefaultViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView
func (c *ResourceExplorer2) DisassociateDefaultViewRequest(input *DisassociateDefaultViewInput) (req *request.Request, output *DisassociateDefaultViewOutput) {
	op := &request.Operation{
		Name:       opDisassociateDefaultView,
		HTTPMethod: "POST",
		HTTPPath:   "/DisassociateDefaultView",
	}

	if input == nil {
		input = &DisassociateDefaultViewInput{}
	}

	output = &DisassociateDefaultViewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateDefaultView API operation for AWS Resource Explorer.
//
// After you call this operation, the affected Amazon Web Services Region no
// longer has a default view. All Search operations in that Region must explicitly
// specify a view or the operation fails. You can configure a new default by
// calling the AssociateDefaultView operation.
//
// If an Amazon Web Services Region doesn't have a default view configured,
// then users must explicitly specify a view with every Search operation performed
// in that Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation DisassociateDefaultView for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView
func (c *ResourceExplorer2) DisassociateDefaultView(input *DisassociateDefaultViewInput) (*DisassociateDefaultViewOutput, error) {
	req, out := c.DisassociateDefaultViewRequest(input)
	return out, req.Send()
}

// DisassociateDefaultViewWithContext is the same as DisassociateDefaultView with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDefaultView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) DisassociateDefaultViewWithContext(ctx aws.Context, input *DisassociateDefaultViewInput, opts ...request.Option) (*DisassociateDefaultViewOutput, error) {
	req, out := c.DisassociateDefaultViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountLevelServiceConfiguration = "GetAccountLevelServiceConfiguration"

// GetAccountLevelServiceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountLevelServiceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountLevelServiceConfiguration for more information on using the GetAccountLevelServiceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountLevelServiceConfigurationRequest method.
//	req, resp := client.GetAccountLevelServiceConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetAccountLevelServiceConfiguration
func (c *ResourceExplorer2) GetAccountLevelServiceConfigurationRequest(input *GetAccountLevelServiceConfigurationInput) (req *request.Request, output *GetAccountLevelServiceConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetAccountLevelServiceConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetAccountLevelServiceConfiguration",
	}

	if input == nil {
		input = &GetAccountLevelServiceConfigurationInput{}
	}

	output = &GetAccountLevelServiceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountLevelServiceConfiguration API operation for AWS Resource Explorer.
//
// Retrieves the status of your account's Amazon Web Services service access,
// and validates the service linked role required to access the multi-account
// search feature. Only the management account or a delegated administrator
// with service access enabled can invoke this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation GetAccountLevelServiceConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetAccountLevelServiceConfiguration
func (c *ResourceExplorer2) GetAccountLevelServiceConfiguration(input *GetAccountLevelServiceConfigurationInput) (*GetAccountLevelServiceConfigurationOutput, error) {
	req, out := c.GetAccountLevelServiceConfigurationRequest(input)
	return out, req.Send()
}

// GetAccountLevelServiceConfigurationWithContext is the same as GetAccountLevelServiceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountLevelServiceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) GetAccountLevelServiceConfigurationWithContext(ctx aws.Context, input *GetAccountLevelServiceConfigurationInput, opts ...request.Option) (*GetAccountLevelServiceConfigurationOutput, error) {
	req, out := c.GetAccountLevelServiceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDefaultView = "GetDefaultView"

// GetDefaultViewRequest generates a "aws/request.Request" representing the
// client's request for the GetDefaultView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDefaultView for more information on using the GetDefaultView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDefaultViewRequest method.
//	req, resp := client.GetDefaultViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView
func (c *ResourceExplorer2) GetDefaultViewRequest(input *GetDefaultViewInput) (req *request.Request, output *GetDefaultViewOutput) {
	op := &request.Operation{
		Name:       opGetDefaultView,
		HTTPMethod: "POST",
		HTTPPath:   "/GetDefaultView",
	}

	if input == nil {
		input = &GetDefaultViewInput{}
	}

	output = &GetDefaultViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDefaultView API operation for AWS Resource Explorer.
//
// Retrieves the Amazon Resource Name (ARN) of the view that is the default
// for the Amazon Web Services Region in which you call this operation. You
// can then call GetView to retrieve the details of that view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation GetDefaultView for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView
func (c *ResourceExplorer2) GetDefaultView(input *GetDefaultViewInput) (*GetDefaultViewOutput, error) {
	req, out := c.GetDefaultViewRequest(input)
	return out, req.Send()
}

// GetDefaultViewWithContext is the same as GetDefaultView with the addition of
// the ability to pass a context and additional request options.
//
// See GetDefaultView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) GetDefaultViewWithContext(ctx aws.Context, input *GetDefaultViewInput, opts ...request.Option) (*GetDefaultViewOutput, error) {
	req, out := c.GetDefaultViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIndex = "GetIndex"

// GetIndexRequest generates a "aws/request.Request" representing the
// client's request for the GetIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIndex for more information on using the GetIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIndexRequest method.
//	req, resp := client.GetIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex
func (c *ResourceExplorer2) GetIndexRequest(input *GetIndexInput) (req *request.Request, output *GetIndexOutput) {
	op := &request.Operation{
		Name:       opGetIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/GetIndex",
	}

	if input == nil {
		input = &GetIndexInput{}
	}

	output = &GetIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIndex API operation for AWS Resource Explorer.
//
// Retrieves details about the Amazon Web Services Resource Explorer index in
// the Amazon Web Services Region in which you invoked the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation GetIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex
func (c *ResourceExplorer2) GetIndex(input *GetIndexInput) (*GetIndexOutput, error) {
	req, out := c.GetIndexRequest(input)
	return out, req.Send()
}

// GetIndexWithContext is the same as GetIndex with the addition of
// the ability to pass a context and additional request options.
//
// See GetIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) GetIndexWithContext(ctx aws.Context, input *GetIndexInput, opts ...request.Option) (*GetIndexOutput, error) {
	req, out := c.GetIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetView = "GetView"

// GetViewRequest generates a "aws/request.Request" representing the
// client's request for the GetView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetView for more information on using the GetView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetViewRequest method.
//	req, resp := client.GetViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView
func (c *ResourceExplorer2) GetViewRequest(input *GetViewInput) (req *request.Request, output *GetViewOutput) {
	op := &request.Operation{
		Name:       opGetView,
		HTTPMethod: "POST",
		HTTPPath:   "/GetView",
	}

	if input == nil {
		input = &GetViewInput{}
	}

	output = &GetViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetView API operation for AWS Resource Explorer.
//
// Retrieves details of the specified view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation GetView for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView
func (c *ResourceExplorer2) GetView(input *GetViewInput) (*GetViewOutput, error) {
	req, out := c.GetViewRequest(input)
	return out, req.Send()
}

// GetViewWithContext is the same as GetView with the addition of
// the ability to pass a context and additional request options.
//
// See GetView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) GetViewWithContext(ctx aws.Context, input *GetViewInput, opts ...request.Option) (*GetViewOutput, error) {
	req, out := c.GetViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIndexes = "ListIndexes"

// ListIndexesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndexes for more information on using the ListIndexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIndexesRequest method.
//	req, resp := client.ListIndexesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes
func (c *ResourceExplorer2) ListIndexesRequest(input *ListIndexesInput) (req *request.Request, output *ListIndexesOutput) {
	op := &request.Operation{
		Name:       opListIndexes,
		HTTPMethod: "POST",
		HTTPPath:   "/ListIndexes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndexesInput{}
	}

	output = &ListIndexesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndexes API operation for AWS Resource Explorer.
//
// Retrieves a list of all of the indexes in Amazon Web Services Regions that
// are currently collecting resource information for Amazon Web Services Resource
// Explorer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation ListIndexes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes
func (c *ResourceExplorer2) ListIndexes(input *ListIndexesInput) (*ListIndexesOutput, error) {
	req, out := c.ListIndexesRequest(input)
	return out, req.Send()
}

// ListIndexesWithContext is the same as ListIndexes with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListIndexesWithContext(ctx aws.Context, input *ListIndexesInput, opts ...request.Option) (*ListIndexesOutput, error) {
	req, out := c.ListIndexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndexesPages iterates over the pages of a ListIndexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIndexes operation.
//	pageNum := 0
//	err := client.ListIndexesPages(params,
//	    func(page *resourceexplorer2.ListIndexesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResourceExplorer2) ListIndexesPages(input *ListIndexesInput, fn func(*ListIndexesOutput, bool) bool) error {
	return c.ListIndexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndexesPagesWithContext same as ListIndexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListIndexesPagesWithContext(ctx aws.Context, input *ListIndexesInput, fn func(*ListIndexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIndexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIndexesForMembers = "ListIndexesForMembers"

// ListIndexesForMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListIndexesForMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndexesForMembers for more information on using the ListIndexesForMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIndexesForMembersRequest method.
//	req, resp := client.ListIndexesForMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers
func (c *ResourceExplorer2) ListIndexesForMembersRequest(input *ListIndexesForMembersInput) (req *request.Request, output *ListIndexesForMembersOutput) {
	op := &request.Operation{
		Name:       opListIndexesForMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/ListIndexesForMembers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndexesForMembersInput{}
	}

	output = &ListIndexesForMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndexesForMembers API operation for AWS Resource Explorer.
//
// Retrieves a list of a member's indexes in all Amazon Web Services Regions
// that are currently collecting resource information for Amazon Web Services
// Resource Explorer. Only the management account or a delegated administrator
// with service access enabled can invoke this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation ListIndexesForMembers for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers
func (c *ResourceExplorer2) ListIndexesForMembers(input *ListIndexesForMembersInput) (*ListIndexesForMembersOutput, error) {
	req, out := c.ListIndexesForMembersRequest(input)
	return out, req.Send()
}

// ListIndexesForMembersWithContext is the same as ListIndexesForMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndexesForMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListIndexesForMembersWithContext(ctx aws.Context, input *ListIndexesForMembersInput, opts ...request.Option) (*ListIndexesForMembersOutput, error) {
	req, out := c.ListIndexesForMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndexesForMembersPages iterates over the pages of a ListIndexesForMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndexesForMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIndexesForMembers operation.
//	pageNum := 0
//	err := client.ListIndexesForMembersPages(params,
//	    func(page *resourceexplorer2.ListIndexesForMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResourceExplorer2) ListIndexesForMembersPages(input *ListIndexesForMembersInput, fn func(*ListIndexesForMembersOutput, bool) bool) error {
	return c.ListIndexesForMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndexesForMembersPagesWithContext same as ListIndexesForMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListIndexesForMembersPagesWithContext(ctx aws.Context, input *ListIndexesForMembersInput, fn func(*ListIndexesForMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndexesForMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndexesForMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIndexesForMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSupportedResourceTypes = "ListSupportedResourceTypes"

// ListSupportedResourceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListSupportedResourceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSupportedResourceTypes for more information on using the ListSupportedResourceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSupportedResourceTypesRequest method.
//	req, resp := client.ListSupportedResourceTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes
func (c *ResourceExplorer2) ListSupportedResourceTypesRequest(input *ListSupportedResourceTypesInput) (req *request.Request, output *ListSupportedResourceTypesOutput) {
	op := &request.Operation{
		Name:       opListSupportedResourceTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/ListSupportedResourceTypes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSupportedResourceTypesInput{}
	}

	output = &ListSupportedResourceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSupportedResourceTypes API operation for AWS Resource Explorer.
//
// Retrieves a list of all resource types currently supported by Amazon Web
// Services Resource Explorer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation ListSupportedResourceTypes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes
func (c *ResourceExplorer2) ListSupportedResourceTypes(input *ListSupportedResourceTypesInput) (*ListSupportedResourceTypesOutput, error) {
	req, out := c.ListSupportedResourceTypesRequest(input)
	return out, req.Send()
}

// ListSupportedResourceTypesWithContext is the same as ListSupportedResourceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListSupportedResourceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListSupportedResourceTypesWithContext(ctx aws.Context, input *ListSupportedResourceTypesInput, opts ...request.Option) (*ListSupportedResourceTypesOutput, error) {
	req, out := c.ListSupportedResourceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSupportedResourceTypesPages iterates over the pages of a ListSupportedResourceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSupportedResourceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSupportedResourceTypes operation.
//	pageNum := 0
//	err := client.ListSupportedResourceTypesPages(params,
//	    func(page *resourceexplorer2.ListSupportedResourceTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResourceExplorer2) ListSupportedResourceTypesPages(input *ListSupportedResourceTypesInput, fn func(*ListSupportedResourceTypesOutput, bool) bool) error {
	return c.ListSupportedResourceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSupportedResourceTypesPagesWithContext same as ListSupportedResourceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListSupportedResourceTypesPagesWithContext(ctx aws.Context, input *ListSupportedResourceTypesInput, fn func(*ListSupportedResourceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSupportedResourceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSupportedResourceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSupportedResourceTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource
func (c *ResourceExplorer2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Resource Explorer.
//
// Lists the tags that are attached to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource
func (c *ResourceExplorer2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListViews = "ListViews"

// ListViewsRequest generates a "aws/request.Request" representing the
// client's request for the ListViews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListViews for more information on using the ListViews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListViewsRequest method.
//	req, resp := client.ListViewsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews
func (c *ResourceExplorer2) ListViewsRequest(input *ListViewsInput) (req *request.Request, output *ListViewsOutput) {
	op := &request.Operation{
		Name:       opListViews,
		HTTPMethod: "POST",
		HTTPPath:   "/ListViews",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListViewsInput{}
	}

	output = &ListViewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListViews API operation for AWS Resource Explorer.
//
// Lists the Amazon resource names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// of the views available in the Amazon Web Services Region in which you call
// this operation.
//
// Always check the NextToken response parameter for a null value when calling
// a paginated operation. These operations can occasionally return an empty
// set of results even when there are more results available. The NextToken
// response parameter value is null only when there are no more results to display.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation ListViews for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews
func (c *ResourceExplorer2) ListViews(input *ListViewsInput) (*ListViewsOutput, error) {
	req, out := c.ListViewsRequest(input)
	return out, req.Send()
}

// ListViewsWithContext is the same as ListViews with the addition of
// the ability to pass a context and additional request options.
//
// See ListViews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListViewsWithContext(ctx aws.Context, input *ListViewsInput, opts ...request.Option) (*ListViewsOutput, error) {
	req, out := c.ListViewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListViewsPages iterates over the pages of a ListViews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListViews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListViews operation.
//	pageNum := 0
//	err := client.ListViewsPages(params,
//	    func(page *resourceexplorer2.ListViewsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResourceExplorer2) ListViewsPages(input *ListViewsInput, fn func(*ListViewsOutput, bool) bool) error {
	return c.ListViewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListViewsPagesWithContext same as ListViewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) ListViewsPagesWithContext(ctx aws.Context, input *ListViewsInput, fn func(*ListViewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListViewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListViewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListViewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearch = "Search"

// SearchRequest generates a "aws/request.Request" representing the
// client's request for the Search operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Search for more information on using the Search
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchRequest method.
//	req, resp := client.SearchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search
func (c *ResourceExplorer2) SearchRequest(input *SearchInput) (req *request.Request, output *SearchOutput) {
	op := &request.Operation{
		Name:       opSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/Search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInput{}
	}

	output = &SearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Search API operation for AWS Resource Explorer.
//
// Searches for resources and displays details about all resources that match
// the specified criteria. You must specify a query string.
//
// All search queries must use a view. If you don't explicitly specify a view,
// then Amazon Web Services Resource Explorer uses the default view for the
// Amazon Web Services Region in which you call this operation. The results
// are the logical intersection of the results that match both the QueryString
// parameter supplied to this operation and the SearchFilter parameter attached
// to the view.
//
// For the complete syntax supported by the QueryString parameter, see Search
// query syntax reference for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html).
//
// If your search results are empty, or are missing results that you think should
// be there, see Troubleshooting Resource Explorer search (https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation Search for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search
func (c *ResourceExplorer2) Search(input *SearchInput) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	return out, req.Send()
}

// SearchWithContext is the same as Search with the addition of
// the ability to pass a context and additional request options.
//
// See Search for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) SearchWithContext(ctx aws.Context, input *SearchInput, opts ...request.Option) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchPages iterates over the pages of a Search operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Search method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a Search operation.
//	pageNum := 0
//	err := client.SearchPages(params,
//	    func(page *resourceexplorer2.SearchOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ResourceExplorer2) SearchPages(input *SearchInput, fn func(*SearchOutput, bool) bool) error {
	return c.SearchPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchPagesWithContext same as SearchPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) SearchPagesWithContext(ctx aws.Context, input *SearchInput, fn func(*SearchOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource
func (c *ResourceExplorer2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Resource Explorer.
//
// Adds one or more tag key and value pairs to an Amazon Web Services Resource
// Explorer view or index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ConflictException
//     If you attempted to create a view, then the request failed because either
//     you specified parameters that didn’t match the original request, or you
//     attempted to create a view with a name that already exists in this Amazon
//     Web Services Region.
//
//     If you attempted to create an index, then the request failed because either
//     you specified parameters that didn't match the original request, or an index
//     already exists in the current Amazon Web Services Region.
//
//     If you attempted to update an index type to AGGREGATOR, then the request
//     failed because you already have an AGGREGATOR index in a different Amazon
//     Web Services Region.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource
func (c *ResourceExplorer2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource
func (c *ResourceExplorer2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Resource Explorer.
//
// Removes one or more tag key and value pairs from an Amazon Web Services Resource
// Explorer view or index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource
func (c *ResourceExplorer2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndexType = "UpdateIndexType"

// UpdateIndexTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndexType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndexType for more information on using the UpdateIndexType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIndexTypeRequest method.
//	req, resp := client.UpdateIndexTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType
func (c *ResourceExplorer2) UpdateIndexTypeRequest(input *UpdateIndexTypeInput) (req *request.Request, output *UpdateIndexTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateIndexType,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateIndexType",
	}

	if input == nil {
		input = &UpdateIndexTypeInput{}
	}

	output = &UpdateIndexTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIndexType API operation for AWS Resource Explorer.
//
// Changes the type of the index from one of the following types to the other.
// For more information about indexes and the role they perform in Amazon Web
// Services Resource Explorer, see Turning on cross-Region search by creating
// an aggregator index (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html)
// in the Amazon Web Services Resource Explorer User Guide.
//
//   - AGGREGATOR index type The index contains information about resources
//     from all Amazon Web Services Regions in the Amazon Web Services account
//     in which you've created a Resource Explorer index. Resource information
//     from all other Regions is replicated to this Region's index. When you
//     change the index type to AGGREGATOR, Resource Explorer turns on replication
//     of all discovered resource information from the other Amazon Web Services
//     Regions in your account to this index. You can then, from this Region
//     only, perform resource search queries that span all Amazon Web Services
//     Regions in the Amazon Web Services account. Turning on replication from
//     all other Regions is performed by asynchronous background tasks. You can
//     check the status of the asynchronous tasks by using the GetIndex operation.
//     When the asynchronous tasks complete, the Status response of that operation
//     changes from UPDATING to ACTIVE. After that, you can start to see results
//     from other Amazon Web Services Regions in query results. However, it can
//     take several hours for replication from all other Regions to complete.
//     You can have only one aggregator index per Amazon Web Services account.
//     Before you can promote a different index to be the aggregator index for
//     the account, you must first demote the existing aggregator index to type
//     LOCAL.
//
//   - LOCAL index type The index contains information about resources in only
//     the Amazon Web Services Region in which the index exists. If an aggregator
//     index in another Region exists, then information in this local index is
//     replicated to the aggregator index. When you change the index type to
//     LOCAL, Resource Explorer turns off the replication of resource information
//     from all other Amazon Web Services Regions in the Amazon Web Services
//     account to this Region. The aggregator index remains in the UPDATING state
//     until all replication with other Regions successfully stops. You can check
//     the status of the asynchronous task by using the GetIndex operation. When
//     Resource Explorer successfully stops all replication with other Regions,
//     the Status response of that operation changes from UPDATING to ACTIVE.
//     Separately, the resource information from other Regions that was previously
//     stored in the index is deleted within 30 days by another background task.
//     Until that asynchronous task completes, some results from other Regions
//     can continue to appear in search results. After you demote an aggregator
//     index to a local index, you must wait 24 hours before you can promote
//     another index to be the new aggregator index for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation UpdateIndexType for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You specified a resource that doesn't exist. Check the ID or ARN that you
//     used to identity the resource, and try again.
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ConflictException
//     If you attempted to create a view, then the request failed because either
//     you specified parameters that didn’t match the original request, or you
//     attempted to create a view with a name that already exists in this Amazon
//     Web Services Region.
//
//     If you attempted to create an index, then the request failed because either
//     you specified parameters that didn't match the original request, or an index
//     already exists in the current Amazon Web Services Region.
//
//     If you attempted to update an index type to AGGREGATOR, then the request
//     failed because you already have an AGGREGATOR index in a different Amazon
//     Web Services Region.
//
//   - ServiceQuotaExceededException
//     The request failed because it exceeds a service quota.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType
func (c *ResourceExplorer2) UpdateIndexType(input *UpdateIndexTypeInput) (*UpdateIndexTypeOutput, error) {
	req, out := c.UpdateIndexTypeRequest(input)
	return out, req.Send()
}

// UpdateIndexTypeWithContext is the same as UpdateIndexType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndexType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) UpdateIndexTypeWithContext(ctx aws.Context, input *UpdateIndexTypeInput, opts ...request.Option) (*UpdateIndexTypeOutput, error) {
	req, out := c.UpdateIndexTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateView = "UpdateView"

// UpdateViewRequest generates a "aws/request.Request" representing the
// client's request for the UpdateView operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateView for more information on using the UpdateView
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateViewRequest method.
//	req, resp := client.UpdateViewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView
func (c *ResourceExplorer2) UpdateViewRequest(input *UpdateViewInput) (req *request.Request, output *UpdateViewOutput) {
	op := &request.Operation{
		Name:       opUpdateView,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateView",
	}

	if input == nil {
		input = &UpdateViewInput{}
	}

	output = &UpdateViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateView API operation for AWS Resource Explorer.
//
// Modifies some of the details of a view. You can change the filter string
// and the list of included properties. You can't change the name of the view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Explorer's
// API operation UpdateView for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request failed because of internal service error. Try your request again
//     later.
//
//   - ValidationException
//     You provided an invalid value for one of the operation's parameters. Check
//     the syntax for the operation, and try again.
//
//   - ServiceQuotaExceededException
//     The request failed because it exceeds a service quota.
//
//   - UnauthorizedException
//     The principal making the request isn't permitted to perform the operation.
//
//   - ThrottlingException
//     The request failed because you exceeded a rate limit for this operation.
//     For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
//
//   - AccessDeniedException
//     The credentials that you used to call this operation don't have the minimum
//     required permissions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView
func (c *ResourceExplorer2) UpdateView(input *UpdateViewInput) (*UpdateViewOutput, error) {
	req, out := c.UpdateViewRequest(input)
	return out, req.Send()
}

// UpdateViewWithContext is the same as UpdateView with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceExplorer2) UpdateViewWithContext(ctx aws.Context, input *UpdateViewInput, opts ...request.Option) (*UpdateViewOutput, error) {
	req, out := c.UpdateViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The credentials that you used to call this operation don't have the minimum
// required permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateDefaultViewInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view to set as the default for the Amazon Web Services Region and
	// Amazon Web Services account in which you call this operation. The specified
	// view must already exist in the called Region.
	//
	// ViewArn is a required field
	ViewArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDefaultViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDefaultViewInput"}
	if s.ViewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewArn"))
	}
	if s.ViewArn != nil && len(*s.ViewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetViewArn sets the ViewArn field's value.
func (s *AssociateDefaultViewInput) SetViewArn(v string) *AssociateDefaultViewInput {
	s.ViewArn = &v
	return s
}

type AssociateDefaultViewOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that the operation set as the default for queries made in the
	// Amazon Web Services Region and Amazon Web Services account in which you called
	// this operation.
	ViewArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultViewOutput) GoString() string {
	return s.String()
}

// SetViewArn sets the ViewArn field's value.
func (s *AssociateDefaultViewOutput) SetViewArn(v string) *AssociateDefaultViewOutput {
	s.ViewArn = &v
	return s
}

// A collection of error messages for any views that Amazon Web Services Resource
// Explorer couldn't retrieve details.
type BatchGetViewError struct {
	_ struct{} `type:"structure"`

	// The description of the error for the specified view.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view for which Resource Explorer failed to retrieve details.
	//
	// ViewArn is a required field
	ViewArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewError) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetViewError) SetErrorMessage(v string) *BatchGetViewError {
	s.ErrorMessage = &v
	return s
}

// SetViewArn sets the ViewArn field's value.
func (s *BatchGetViewError) SetViewArn(v string) *BatchGetViewError {
	s.ViewArn = &v
	return s
}

type BatchGetViewInput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon resource names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// that identify the views you want details for.
	ViewArns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetViewInput"}
	if s.ViewArns != nil && len(s.ViewArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetViewArns sets the ViewArns field's value.
func (s *BatchGetViewInput) SetViewArns(v []*string) *BatchGetViewInput {
	s.ViewArns = v
	return s
}

type BatchGetViewOutput struct {
	_ struct{} `type:"structure"`

	// If any of the specified ARNs result in an error, then this structure describes
	// the error.
	Errors []*BatchGetViewError `type:"list"`

	// A structure with a list of objects with details for each of the specified
	// views.
	Views []*View `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetViewOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetViewOutput) SetErrors(v []*BatchGetViewError) *BatchGetViewOutput {
	s.Errors = v
	return s
}

// SetViews sets the Views field's value.
func (s *BatchGetViewOutput) SetViews(v []*View) *BatchGetViewOutput {
	s.Views = v
	return s
}

// If you attempted to create a view, then the request failed because either
// you specified parameters that didn’t match the original request, or you
// attempted to create a view with a name that already exists in this Amazon
// Web Services Region.
//
// If you attempted to create an index, then the request failed because either
// you specified parameters that didn't match the original request, or an index
// already exists in the current Amazon Web Services Region.
//
// If you attempted to update an index type to AGGREGATOR, then the request
// failed because you already have an AGGREGATOR index in a different Amazon
// Web Services Region.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// This value helps ensure idempotency. Resource Explorer uses this value to
	// prevent the accidental creation of duplicate versions. We recommend that
	// you generate a UUID-type value (https://wikipedia.org/wiki/Universally_unique_identifier)
	// to ensure the uniqueness of your index.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The specified tags are attached only to the index created in this Amazon
	// Web Services Region. The tags aren't attached to any of the resources listed
	// in the index.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateIndexInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIndexInput) SetClientToken(v string) *CreateIndexInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIndexInput) SetTags(v map[string]*string) *CreateIndexInput {
	s.Tags = v
	return s
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new local index for the Region. You can reference this ARN
	// in IAM permission policies to authorize the following operations: DeleteIndex
	// | GetIndex | UpdateIndexType | CreateView
	Arn *string `type:"string"`

	// The date and timestamp when the index was created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the current state of the index. You can check for changes to the
	// state for asynchronous operations by calling the GetIndex operation.
	//
	// The state can remain in the CREATING or UPDATING state for several hours
	// as Resource Explorer discovers the information about your resources and populates
	// the index.
	State *string `type:"string" enum:"IndexState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateIndexOutput) SetArn(v string) *CreateIndexOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateIndexOutput) SetCreatedAt(v time.Time) *CreateIndexOutput {
	s.CreatedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateIndexOutput) SetState(v string) *CreateIndexOutput {
	s.State = &v
	return s
}

type CreateViewInput struct {
	_ struct{} `type:"structure"`

	// This value helps ensure idempotency. Resource Explorer uses this value to
	// prevent the accidental creation of duplicate versions. We recommend that
	// you generate a UUID-type value (https://wikipedia.org/wiki/Universally_unique_identifier)
	// to ensure the uniqueness of your views.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// An array of strings that specify which resources are included in the results
	// of queries made using this view. When you use this view in a Search operation,
	// the filter string is combined with the search's QueryString parameter using
	// a logical AND operator.
	//
	// For information about the supported syntax, see Search query reference for
	// Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html)
	// in the Amazon Web Services Resource Explorer User Guide.
	//
	// This query string in the context of this operation supports only filter prefixes
	// (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters)
	// with optional operators (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators).
	// It doesn't support free-form text. For example, the string region:us* service:ec2
	// -tag:stage=prod includes all Amazon EC2 resources in any Amazon Web Services
	// Region that begins with the letters us and is not tagged with a key Stage
	// that has the value prod.
	//
	// Filters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateViewInput's
	// String and GoString methods.
	Filters *SearchFilter `type:"structure" sensitive:"true"`

	// Specifies optional fields that you want included in search results from this
	// view. It is a list of objects that each describe a field to include.
	//
	// The default is an empty list, with no optional fields included in the results.
	IncludedProperties []*IncludedProperty `type:"list"`

	// The root ARN of the account, an organizational unit (OU), or an organization
	// ARN. If left empty, the default is account.
	Scope *string `min:"1" type:"string"`

	// Tag key and value pairs that are attached to the view.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateViewInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The name of the new view. This name appears in the list of views in Resource
	// Explorer.
	//
	// The name must be no more than 64 characters long, and can include letters,
	// digits, and the dash (-) character. The name must be unique within its Amazon
	// Web Services Region.
	//
	// ViewName is a required field
	ViewName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateViewInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Scope != nil && len(*s.Scope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Scope", 1))
	}
	if s.ViewName == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewName"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}
	if s.IncludedProperties != nil {
		for i, v := range s.IncludedProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IncludedProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateViewInput) SetClientToken(v string) *CreateViewInput {
	s.ClientToken = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *CreateViewInput) SetFilters(v *SearchFilter) *CreateViewInput {
	s.Filters = v
	return s
}

// SetIncludedProperties sets the IncludedProperties field's value.
func (s *CreateViewInput) SetIncludedProperties(v []*IncludedProperty) *CreateViewInput {
	s.IncludedProperties = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateViewInput) SetScope(v string) *CreateViewInput {
	s.Scope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateViewInput) SetTags(v map[string]*string) *CreateViewInput {
	s.Tags = v
	return s
}

// SetViewName sets the ViewName field's value.
func (s *CreateViewInput) SetViewName(v string) *CreateViewInput {
	s.ViewName = &v
	return s
}

type CreateViewOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the details about the new view.
	View *View `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateViewOutput) GoString() string {
	return s.String()
}

// SetView sets the View field's value.
func (s *CreateViewOutput) SetView(v *View) *CreateViewOutput {
	s.View = v
	return s
}

type DeleteIndexInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index that you want to delete.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIndexInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteIndexInput) SetArn(v string) *DeleteIndexInput {
	s.Arn = &v
	return s
}

type DeleteIndexOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index that you successfully started the deletion process.
	//
	// This operation is asynchronous. To check its status, call the GetIndex operation.
	Arn *string `type:"string"`

	// The date and time when you last updated this index.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the current state of the index.
	State *string `type:"string" enum:"IndexState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteIndexOutput) SetArn(v string) *DeleteIndexOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DeleteIndexOutput) SetLastUpdatedAt(v time.Time) *DeleteIndexOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteIndexOutput) SetState(v string) *DeleteIndexOutput {
	s.State = &v
	return s
}

type DeleteViewInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that you want to delete.
	//
	// ViewArn is a required field
	ViewArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteViewInput"}
	if s.ViewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewArn"))
	}
	if s.ViewArn != nil && len(*s.ViewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetViewArn sets the ViewArn field's value.
func (s *DeleteViewInput) SetViewArn(v string) *DeleteViewInput {
	s.ViewArn = &v
	return s
}

type DeleteViewOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that you successfully deleted.
	ViewArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteViewOutput) GoString() string {
	return s.String()
}

// SetViewArn sets the ViewArn field's value.
func (s *DeleteViewOutput) SetViewArn(v string) *DeleteViewOutput {
	s.ViewArn = &v
	return s
}

type DisassociateDefaultViewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDefaultViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDefaultViewInput) GoString() string {
	return s.String()
}

type DisassociateDefaultViewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDefaultViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDefaultViewOutput) GoString() string {
	return s.String()
}

type GetAccountLevelServiceConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLevelServiceConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLevelServiceConfigurationInput) GoString() string {
	return s.String()
}

type GetAccountLevelServiceConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Details about the organization, and whether configuration is ENABLED or DISABLED.
	OrgConfiguration *OrgConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLevelServiceConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLevelServiceConfigurationOutput) GoString() string {
	return s.String()
}

// SetOrgConfiguration sets the OrgConfiguration field's value.
func (s *GetAccountLevelServiceConfigurationOutput) SetOrgConfiguration(v *OrgConfiguration) *GetAccountLevelServiceConfigurationOutput {
	s.OrgConfiguration = v
	return s
}

type GetDefaultViewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDefaultViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDefaultViewInput) GoString() string {
	return s.String()
}

type GetDefaultViewOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that is the current default for the Amazon Web Services Region
	// in which you called this operation.
	ViewArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDefaultViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDefaultViewOutput) GoString() string {
	return s.String()
}

// SetViewArn sets the ViewArn field's value.
func (s *GetDefaultViewOutput) SetViewArn(v string) *GetDefaultViewOutput {
	s.ViewArn = &v
	return s
}

type GetIndexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexInput) GoString() string {
	return s.String()
}

type GetIndexOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index.
	Arn *string `type:"string"`

	// The date and time when the index was originally created.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date and time when the index was last updated.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This response value is present only if this index is Type=AGGREGATOR.
	//
	// A list of the Amazon Web Services Regions that replicate their content to
	// the index in this Region.
	ReplicatingFrom []*string `type:"list"`

	// This response value is present only if this index is Type=LOCAL.
	//
	// The Amazon Web Services Region that contains the aggregator index, if one
	// exists. If an aggregator index does exist then the Region in which you called
	// this operation replicates its index information to the Region specified in
	// this response value.
	ReplicatingTo []*string `type:"list"`

	// The current state of the index in this Amazon Web Services Region.
	State *string `type:"string" enum:"IndexState"`

	// Tag key and value pairs that are attached to the index.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetIndexOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The type of the index in this Region. For information about the aggregator
	// index and how it differs from a local index, see Turning on cross-Region
	// search by creating an aggregator index (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html).
	Type *string `type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetIndexOutput) SetArn(v string) *GetIndexOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIndexOutput) SetCreatedAt(v time.Time) *GetIndexOutput {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetIndexOutput) SetLastUpdatedAt(v time.Time) *GetIndexOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetReplicatingFrom sets the ReplicatingFrom field's value.
func (s *GetIndexOutput) SetReplicatingFrom(v []*string) *GetIndexOutput {
	s.ReplicatingFrom = v
	return s
}

// SetReplicatingTo sets the ReplicatingTo field's value.
func (s *GetIndexOutput) SetReplicatingTo(v []*string) *GetIndexOutput {
	s.ReplicatingTo = v
	return s
}

// SetState sets the State field's value.
func (s *GetIndexOutput) SetState(v string) *GetIndexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIndexOutput) SetTags(v map[string]*string) *GetIndexOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetIndexOutput) SetType(v string) *GetIndexOutput {
	s.Type = &v
	return s
}

type GetViewInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that you want information about.
	//
	// ViewArn is a required field
	ViewArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetViewInput"}
	if s.ViewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewArn"))
	}
	if s.ViewArn != nil && len(*s.ViewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetViewArn sets the ViewArn field's value.
func (s *GetViewInput) SetViewArn(v string) *GetViewInput {
	s.ViewArn = &v
	return s
}

type GetViewOutput struct {
	_ struct{} `type:"structure"`

	// Tag key and value pairs that are attached to the view.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetViewOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// A structure that contains the details for the requested view.
	View *View `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetViewOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetViewOutput) SetTags(v map[string]*string) *GetViewOutput {
	s.Tags = v
	return s
}

// SetView sets the View field's value.
func (s *GetViewOutput) SetView(v *View) *GetViewOutput {
	s.View = v
	return s
}

// Information about an additional property that describes a resource, that
// you can optionally include in the view. This lets you view that property
// in search results, and filter your search results based on the value of the
// property.
type IncludedProperty struct {
	_ struct{} `type:"structure"`

	// The name of the property that is included in this view.
	//
	// You can specify the following property names for this field:
	//
	//    * Tags
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncludedProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncludedProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncludedProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncludedProperty"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IncludedProperty) SetName(v string) *IncludedProperty {
	s.Name = &v
	return s
}

// An index is the data store used by Amazon Web Services Resource Explorer
// to hold information about your Amazon Web Services resources that the service
// discovers. Creating an index in an Amazon Web Services Region turns on Resource
// Explorer and lets it discover your resources.
//
// By default, an index is local, meaning that it contains information about
// resources in only the same Region as the index. However, you can promote
// the index of one Region in the account by calling UpdateIndexType to convert
// it into an aggregator index. The aggregator index receives a replicated copy
// of the index information from all other Regions where Resource Explorer is
// turned on. This allows search operations in that Region to return results
// from all Regions in the account.
type Index struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index.
	Arn *string `type:"string"`

	// The Amazon Web Services Region in which the index exists.
	Region *string `type:"string"`

	// The type of index. It can be one of the following values:
	//
	//    * LOCAL – The index contains information about resources from only the
	//    same Amazon Web Services Region.
	//
	//    * AGGREGATOR – Resource Explorer replicates copies of the indexed information
	//    about resources in all other Amazon Web Services Regions to the aggregator
	//    index. This lets search results in the Region with the aggregator index
	//    to include resources from all Regions in the account where Resource Explorer
	//    is turned on.
	Type *string `type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Index) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Index) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Index) SetArn(v string) *Index {
	s.Arn = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Index) SetRegion(v string) *Index {
	s.Region = &v
	return s
}

// SetType sets the Type field's value.
func (s *Index) SetType(v string) *Index {
	s.Type = &v
	return s
}

// The request failed because of internal service error. Try your request again
// later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListIndexesForMembersInput struct {
	_ struct{} `type:"structure"`

	// The account IDs will limit the output to only indexes from these accounts.
	//
	// AccountIdList is a required field
	AccountIdList []*string `min:"1" type:"list" required:"true"`

	// The maximum number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value appropriate
	// to the operation. If additional items exist beyond those included in the
	// current response, the NextToken response element is present and has a value
	// (is not null). Include that value as the NextToken request parameter in the
	// next call to the operation to get the next part of the results.
	//
	// An API operation can return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from. The
	// pagination tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesForMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesForMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndexesForMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndexesForMembersInput"}
	if s.AccountIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIdList"))
	}
	if s.AccountIdList != nil && len(s.AccountIdList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIdList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIdList sets the AccountIdList field's value.
func (s *ListIndexesForMembersInput) SetAccountIdList(v []*string) *ListIndexesForMembersInput {
	s.AccountIdList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndexesForMembersInput) SetMaxResults(v int64) *ListIndexesForMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexesForMembersInput) SetNextToken(v string) *ListIndexesForMembersInput {
	s.NextToken = &v
	return s
}

type ListIndexesForMembersOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the details and status of each index.
	Indexes []*MemberIndex `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	// The pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesForMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesForMembersOutput) GoString() string {
	return s.String()
}

// SetIndexes sets the Indexes field's value.
func (s *ListIndexesForMembersOutput) SetIndexes(v []*MemberIndex) *ListIndexesForMembersOutput {
	s.Indexes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexesForMembersOutput) SetNextToken(v string) *ListIndexesForMembersOutput {
	s.NextToken = &v
	return s
}

type ListIndexesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value appropriate
	// to the operation. If additional items exist beyond those included in the
	// current response, the NextToken response element is present and has a value
	// (is not null). Include that value as the NextToken request parameter in the
	// next call to the operation to get the next part of the results.
	//
	// An API operation can return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from. The
	// pagination tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`

	// If specified, limits the response to only information about the index in
	// the specified list of Amazon Web Services Regions.
	Regions []*string `type:"list"`

	// If specified, limits the output to only indexes of the specified Type, either
	// LOCAL or AGGREGATOR.
	//
	// Use this option to discover the aggregator index for your account.
	Type *string `type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndexesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndexesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndexesInput) SetMaxResults(v int64) *ListIndexesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexesInput) SetNextToken(v string) *ListIndexesInput {
	s.NextToken = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *ListIndexesInput) SetRegions(v []*string) *ListIndexesInput {
	s.Regions = v
	return s
}

// SetType sets the Type field's value.
func (s *ListIndexesInput) SetType(v string) *ListIndexesInput {
	s.Type = &v
	return s
}

type ListIndexesOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the details and status of each index.
	Indexes []*Index `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	// The pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndexesOutput) GoString() string {
	return s.String()
}

// SetIndexes sets the Indexes field's value.
func (s *ListIndexesOutput) SetIndexes(v []*Index) *ListIndexesOutput {
	s.Indexes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndexesOutput) SetNextToken(v string) *ListIndexesOutput {
	s.NextToken = &v
	return s
}

type ListSupportedResourceTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value appropriate
	// to the operation. If additional items exist beyond those included in the
	// current response, the NextToken response element is present and has a value
	// (is not null). Include that value as the NextToken request parameter in the
	// next call to the operation to get the next part of the results.
	//
	// An API operation can return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from. The
	// pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedResourceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedResourceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSupportedResourceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSupportedResourceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSupportedResourceTypesInput) SetMaxResults(v int64) *ListSupportedResourceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSupportedResourceTypesInput) SetNextToken(v string) *ListSupportedResourceTypesInput {
	s.NextToken = &v
	return s
}

type ListSupportedResourceTypesOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	// The pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`

	// The list of resource types supported by Resource Explorer.
	ResourceTypes []*SupportedResourceType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedResourceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSupportedResourceTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSupportedResourceTypesOutput) SetNextToken(v string) *ListSupportedResourceTypesOutput {
	s.NextToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *ListSupportedResourceTypesOutput) SetResourceTypes(v []*SupportedResourceType) *ListSupportedResourceTypesOutput {
	s.ResourceTypes = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view or index that you want to attach tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag key and value pairs that you want to attach to the specified view
	// or index.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListViewsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value appropriate
	// to the operation. If additional items exist beyond those included in the
	// current response, the NextToken response element is present and has a value
	// (is not null). Include that value as the NextToken request parameter in the
	// next call to the operation to get the next part of the results.
	//
	// An API operation can return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from. The
	// pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListViewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListViewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListViewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListViewsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListViewsInput) SetMaxResults(v int64) *ListViewsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListViewsInput) SetNextToken(v string) *ListViewsInput {
	s.NextToken = &v
	return s
}

type ListViewsOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	// The pagination tokens expire after 24 hours.
	NextToken *string `type:"string"`

	// The list of views available in the Amazon Web Services Region in which you
	// called this operation.
	Views []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListViewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListViewsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListViewsOutput) SetNextToken(v string) *ListViewsOutput {
	s.NextToken = &v
	return s
}

// SetViews sets the Views field's value.
func (s *ListViewsOutput) SetViews(v []*string) *ListViewsOutput {
	s.Views = v
	return s
}

// An index is the data store used by Amazon Web Services Resource Explorer
// to hold information about your Amazon Web Services resources that the service
// discovers.
type MemberIndex struct {
	_ struct{} `type:"structure"`

	// The account ID for the index.
	AccountId *string `type:"string"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index.
	Arn *string `type:"string"`

	// The Amazon Web Services Region in which the index exists.
	Region *string `type:"string"`

	// The type of index. It can be one of the following values:
	//
	//    * LOCAL – The index contains information about resources from only the
	//    same Amazon Web Services Region.
	//
	//    * AGGREGATOR – Resource Explorer replicates copies of the indexed information
	//    about resources in all other Amazon Web Services Regions to the aggregator
	//    index. This lets search results in the Region with the aggregator index
	//    to include resources from all Regions in the account where Resource Explorer
	//    is turned on.
	Type *string `type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberIndex) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberIndex) SetAccountId(v string) *MemberIndex {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *MemberIndex) SetArn(v string) *MemberIndex {
	s.Arn = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MemberIndex) SetRegion(v string) *MemberIndex {
	s.Region = &v
	return s
}

// SetType sets the Type field's value.
func (s *MemberIndex) SetType(v string) *MemberIndex {
	s.Type = &v
	return s
}

// This is a structure that contains the status of Amazon Web Services service
// access, and whether you have a valid service-linked role to enable multi-account
// search for your organization.
type OrgConfiguration struct {
	_ struct{} `type:"structure"`

	// This value displays whether your Amazon Web Services service access is ENABLED
	// or DISABLED.
	//
	// AWSServiceAccessStatus is a required field
	AWSServiceAccessStatus *string `type:"string" required:"true" enum:"AWSServiceAccessStatus"`

	// This value shows whether or not you have a valid a service-linked role required
	// to start the multi-account search feature.
	ServiceLinkedRole *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrgConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrgConfiguration) GoString() string {
	return s.String()
}

// SetAWSServiceAccessStatus sets the AWSServiceAccessStatus field's value.
func (s *OrgConfiguration) SetAWSServiceAccessStatus(v string) *OrgConfiguration {
	s.AWSServiceAccessStatus = &v
	return s
}

// SetServiceLinkedRole sets the ServiceLinkedRole field's value.
func (s *OrgConfiguration) SetServiceLinkedRole(v string) *OrgConfiguration {
	s.ServiceLinkedRole = &v
	return s
}

// A resource in Amazon Web Services that Amazon Web Services Resource Explorer
// has discovered, and for which it has stored information in the index of the
// Amazon Web Services Region that contains the resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource.
	Arn *string `type:"string"`

	// The date and time that Resource Explorer last queried this resource and updated
	// the index with the latest information about the resource.
	LastReportedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Web Services account that owns the resource.
	OwningAccountId *string `type:"string"`

	// A structure with additional type-specific details about the resource. These
	// properties can be added by turning on integration between Resource Explorer
	// and other Amazon Web Services services.
	Properties []*ResourceProperty `type:"list"`

	// The Amazon Web Services Region in which the resource was created and exists.
	Region *string `type:"string"`

	// The type of the resource.
	ResourceType *string `type:"string"`

	// The Amazon Web Service that owns the resource and is responsible for creating
	// and updating it.
	Service *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetLastReportedAt sets the LastReportedAt field's value.
func (s *Resource) SetLastReportedAt(v time.Time) *Resource {
	s.LastReportedAt = &v
	return s
}

// SetOwningAccountId sets the OwningAccountId field's value.
func (s *Resource) SetOwningAccountId(v string) *Resource {
	s.OwningAccountId = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Resource) SetProperties(v []*ResourceProperty) *Resource {
	s.Properties = v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Resource) SetResourceType(v string) *Resource {
	s.ResourceType = &v
	return s
}

// SetService sets the Service field's value.
func (s *Resource) SetService(v string) *Resource {
	s.Service = &v
	return s
}

// Information about the number of results that match the query. At this time,
// Amazon Web Services Resource Explorer doesn't count more than 1,000 matches
// for any query. This structure provides information about whether the query
// exceeded this limit.
//
// This field is included in every page when you paginate the results.
type ResourceCount struct {
	_ struct{} `type:"structure"`

	// Indicates whether the TotalResources value represents an exhaustive count
	// of search results.
	//
	//    * If True, it indicates that the search was exhaustive. Every resource
	//    that matches the query was counted.
	//
	//    * If False, then the search reached the limit of 1,000 matching results,
	//    and stopped counting.
	Complete *bool `type:"boolean"`

	// The number of resources that match the search query. This value can't exceed
	// 1,000. If there are more than 1,000 resources that match the query, then
	// only 1,000 are counted and the Complete field is set to false. We recommend
	// that you refine your query to return a smaller number of results.
	TotalResources *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCount) GoString() string {
	return s.String()
}

// SetComplete sets the Complete field's value.
func (s *ResourceCount) SetComplete(v bool) *ResourceCount {
	s.Complete = &v
	return s
}

// SetTotalResources sets the TotalResources field's value.
func (s *ResourceCount) SetTotalResources(v int64) *ResourceCount {
	s.TotalResources = &v
	return s
}

// You specified a resource that doesn't exist. Check the ID or ARN that you
// used to identity the resource, and try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that describes a property of a resource.
type ResourceProperty struct {
	_ struct{} `type:"structure"`

	// The date and time that the information about this resource property was last
	// updated.
	LastReportedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of this property of the resource.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceProperty) GoString() string {
	return s.String()
}

// SetLastReportedAt sets the LastReportedAt field's value.
func (s *ResourceProperty) SetLastReportedAt(v time.Time) *ResourceProperty {
	s.LastReportedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceProperty) SetName(v string) *ResourceProperty {
	s.Name = &v
	return s
}

// A search filter defines which resources can be part of a search query result
// set.
type SearchFilter struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The string that contains the search keywords, prefixes, and operators to
	// control the results that can be returned by a Search operation. For more
	// details, see Search query syntax (https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html).
	//
	// FilterString is a required field
	FilterString *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFilter"}
	if s.FilterString == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterString sets the FilterString field's value.
func (s *SearchFilter) SetFilterString(v string) *SearchFilter {
	s.FilterString = &v
	return s
}

type SearchInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value appropriate
	// to the operation. If additional items exist beyond those included in the
	// current response, the NextToken response element is present and has a value
	// (is not null). Include that value as the NextToken request parameter in the
	// next call to the operation to get the next part of the results.
	//
	// An API operation can return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from. The
	// pagination tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`

	// A string that includes keywords and filters that specify the resources that
	// you want to include in the results.
	//
	// For the complete syntax supported by the QueryString parameter, see Search
	// query syntax reference for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
	//
	// The search is completely case insensitive. You can specify an empty string
	// to return all results up to the limit of 1,000 total results.
	//
	// The operation can return only the first 1,000 results. If the resource you
	// want is not included, then use a different value for QueryString to refine
	// the results.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `type:"string" required:"true" sensitive:"true"`

	// Specifies the Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view to use for the query. If you don't specify a value for this parameter,
	// then the operation automatically uses the default view for the Amazon Web
	// Services Region in which you called this operation. If the Region either
	// doesn't have a default view or if you don't have permission to use the default
	// view, then the operation fails with a 401 Unauthorized exception.
	ViewArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchInput) SetMaxResults(v int64) *SearchInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInput) SetNextToken(v string) *SearchInput {
	s.NextToken = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *SearchInput) SetQueryString(v string) *SearchInput {
	s.QueryString = &v
	return s
}

// SetViewArn sets the ViewArn field's value.
func (s *SearchInput) SetViewArn(v string) *SearchInput {
	s.ViewArn = &v
	return s
}

type SearchOutput struct {
	_ struct{} `type:"structure"`

	// The number of resources that match the query.
	Count *ResourceCount `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	// The pagination tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`

	// The list of structures that describe the resources that match the query.
	Resources []*Resource `type:"list"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that this operation used to perform the search.
	ViewArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *SearchOutput) SetCount(v *ResourceCount) *SearchOutput {
	s.Count = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchOutput) SetNextToken(v string) *SearchOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *SearchOutput) SetResources(v []*Resource) *SearchOutput {
	s.Resources = v
	return s
}

// SetViewArn sets the ViewArn field's value.
func (s *SearchOutput) SetViewArn(v string) *SearchOutput {
	s.ViewArn = &v
	return s
}

// The request failed because it exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the service quota that was exceeded by the request.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The current value for the quota that the request tried to exceed.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that describes a resource type supported by Amazon Web Services
// Resource Explorer.
type SupportedResourceType struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the resource type.
	ResourceType *string `type:"string"`

	// The Amazon Web Service that is associated with the resource type. This is
	// the primary service that lets you create and interact with resources of this
	// type.
	Service *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SupportedResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SupportedResourceType) GoString() string {
	return s.String()
}

// SetResourceType sets the ResourceType field's value.
func (s *SupportedResourceType) SetResourceType(v string) *SupportedResourceType {
	s.ResourceType = &v
	return s
}

// SetService sets the Service field's value.
func (s *SupportedResourceType) SetService(v string) *SupportedResourceType {
	s.Service = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the view or index that you want to attach
	// tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of tag key and value pairs that you want to attach to the specified
	// view or index.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request failed because you exceeded a rate limit for this operation.
// For more information, see Quotas for Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html).
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The principal making the request isn't permitted to perform the operation.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the view or index that you want to remove
	// tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of the keys for the tags that you want to remove from the specified
	// view or index.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateIndexTypeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index that you want to update.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The type of the index. To understand the difference between LOCAL and AGGREGATOR,
	// see Turning on cross-Region search (https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html)
	// in the Amazon Web Services Resource Explorer User Guide.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIndexTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIndexTypeInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateIndexTypeInput) SetArn(v string) *UpdateIndexTypeInput {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateIndexTypeInput) SetType(v string) *UpdateIndexTypeInput {
	s.Type = &v
	return s
}

type UpdateIndexTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the index that you updated.
	Arn *string `type:"string"`

	// The date and timestamp when the index was last updated.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the state of the request to update the index. This operation is
	// asynchronous. Call the GetIndex operation to check for changes.
	State *string `type:"string" enum:"IndexState"`

	// Specifies the type of the specified index after the operation completes.
	Type *string `type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateIndexTypeOutput) SetArn(v string) *UpdateIndexTypeOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateIndexTypeOutput) SetLastUpdatedAt(v time.Time) *UpdateIndexTypeOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateIndexTypeOutput) SetState(v string) *UpdateIndexTypeOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateIndexTypeOutput) SetType(v string) *UpdateIndexTypeOutput {
	s.Type = &v
	return s
}

type UpdateViewInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that specify which resources are included in the results
	// of queries made using this view. When you use this view in a Search operation,
	// the filter string is combined with the search's QueryString parameter using
	// a logical AND operator.
	//
	// For information about the supported syntax, see Search query reference for
	// Resource Explorer (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html)
	// in the Amazon Web Services Resource Explorer User Guide.
	//
	// This query string in the context of this operation supports only filter prefixes
	// (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters)
	// with optional operators (https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators).
	// It doesn't support free-form text. For example, the string region:us* service:ec2
	// -tag:stage=prod includes all Amazon EC2 resources in any Amazon Web Services
	// Region that begins with the letters us and is not tagged with a key Stage
	// that has the value prod.
	//
	// Filters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateViewInput's
	// String and GoString methods.
	Filters *SearchFilter `type:"structure" sensitive:"true"`

	// Specifies optional fields that you want included in search results from this
	// view. It is a list of objects that each describe a field to include.
	//
	// The default is an empty list, with no optional fields included in the results.
	IncludedProperties []*IncludedProperty `type:"list"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view that you want to modify.
	//
	// ViewArn is a required field
	ViewArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateViewInput"}
	if s.ViewArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewArn"))
	}
	if s.ViewArn != nil && len(*s.ViewArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ViewArn", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}
	if s.IncludedProperties != nil {
		for i, v := range s.IncludedProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IncludedProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateViewInput) SetFilters(v *SearchFilter) *UpdateViewInput {
	s.Filters = v
	return s
}

// SetIncludedProperties sets the IncludedProperties field's value.
func (s *UpdateViewInput) SetIncludedProperties(v []*IncludedProperty) *UpdateViewInput {
	s.IncludedProperties = v
	return s
}

// SetViewArn sets the ViewArn field's value.
func (s *UpdateViewInput) SetViewArn(v string) *UpdateViewInput {
	s.ViewArn = &v
	return s
}

type UpdateViewOutput struct {
	_ struct{} `type:"structure"`

	// Details about the view that you changed with this operation.
	View *View `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateViewOutput) GoString() string {
	return s.String()
}

// SetView sets the View field's value.
func (s *UpdateViewOutput) SetView(v *View) *UpdateViewOutput {
	s.View = v
	return s
}

// You provided an invalid value for one of the operation's parameters. Check
// the syntax for the operation, and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An array of the request fields that had validation errors.
	FieldList []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that describes a request field with a validation error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The name of the request field that had a validation error.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The validation error caused by the request field.
	//
	// ValidationIssue is a required field
	ValidationIssue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// SetValidationIssue sets the ValidationIssue field's value.
func (s *ValidationExceptionField) SetValidationIssue(v string) *ValidationExceptionField {
	s.ValidationIssue = &v
	return s
}

// A view is a structure that defines a set of filters that provide a view into
// the information in the Amazon Web Services Resource Explorer index. The filters
// specify which information from the index is visible to the users of the view.
// For example, you can specify filters that include only resources that are
// tagged with the key "ENV" and the value "DEVELOPMENT" in the results returned
// by this view. You could also create a second view that includes only resources
// that are tagged with "ENV" and "PRODUCTION".
type View struct {
	_ struct{} `type:"structure"`

	// An array of SearchFilter objects that specify which resources can be included
	// in the results of queries made using this view.
	//
	// Filters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by View's
	// String and GoString methods.
	Filters *SearchFilter `type:"structure" sensitive:"true"`

	// A structure that contains additional information about the view.
	IncludedProperties []*IncludedProperty `type:"list"`

	// The date and time when this view was last modified.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Web Services account that owns this view.
	Owner *string `type:"string"`

	// An Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an Amazon Web Services account, an organization, or an organizational
	// unit (OU) that specifies whether this view includes resources from only the
	// specified Amazon Web Services account, all accounts in the specified organization,
	// or all accounts in the specified OU.
	//
	// If not specified, the value defaults to the Amazon Web Services account used
	// to call this operation.
	Scope *string `type:"string"`

	// The Amazon resource name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the view.
	ViewArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s View) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s View) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *View) SetFilters(v *SearchFilter) *View {
	s.Filters = v
	return s
}

// SetIncludedProperties sets the IncludedProperties field's value.
func (s *View) SetIncludedProperties(v []*IncludedProperty) *View {
	s.IncludedProperties = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *View) SetLastUpdatedAt(v time.Time) *View {
	s.LastUpdatedAt = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *View) SetOwner(v string) *View {
	s.Owner = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *View) SetScope(v string) *View {
	s.Scope = &v
	return s
}

// SetViewArn sets the ViewArn field's value.
func (s *View) SetViewArn(v string) *View {
	s.ViewArn = &v
	return s
}

const (
	// AWSServiceAccessStatusEnabled is a AWSServiceAccessStatus enum value
	AWSServiceAccessStatusEnabled = "ENABLED"

	// AWSServiceAccessStatusDisabled is a AWSServiceAccessStatus enum value
	AWSServiceAccessStatusDisabled = "DISABLED"
)

// AWSServiceAccessStatus_Values returns all elements of the AWSServiceAccessStatus enum
func AWSServiceAccessStatus_Values() []string {
	return []string{
		AWSServiceAccessStatusEnabled,
		AWSServiceAccessStatusDisabled,
	}
}

const (
	// IndexStateCreating is a IndexState enum value
	IndexStateCreating = "CREATING"

	// IndexStateActive is a IndexState enum value
	IndexStateActive = "ACTIVE"

	// IndexStateDeleting is a IndexState enum value
	IndexStateDeleting = "DELETING"

	// IndexStateDeleted is a IndexState enum value
	IndexStateDeleted = "DELETED"

	// IndexStateUpdating is a IndexState enum value
	IndexStateUpdating = "UPDATING"
)

// IndexState_Values returns all elements of the IndexState enum
func IndexState_Values() []string {
	return []string{
		IndexStateCreating,
		IndexStateActive,
		IndexStateDeleting,
		IndexStateDeleted,
		IndexStateUpdating,
	}
}

const (
	// IndexTypeLocal is a IndexType enum value
	IndexTypeLocal = "LOCAL"

	// IndexTypeAggregator is a IndexType enum value
	IndexTypeAggregator = "AGGREGATOR"
)

// IndexType_Values returns all elements of the IndexType enum
func IndexType_Values() []string {
	return []string{
		IndexTypeLocal,
		IndexTypeAggregator,
	}
}
