// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package oamiface provides an interface to enable mocking the CloudWatch Observability Access Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package oamiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/oam"
)

// OAMAPI provides an interface to enable mocking the
// oam.OAM service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// CloudWatch Observability Access Manager.
//	func myFunc(svc oamiface.OAMAPI) bool {
//	    // Make svc.CreateLink request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := oam.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockOAMClient struct {
//	    oamiface.OAMAPI
//	}
//	func (m *mockOAMClient) CreateLink(input *oam.CreateLinkInput) (*oam.CreateLinkOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockOAMClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OAMAPI interface {
	CreateLink(*oam.CreateLinkInput) (*oam.CreateLinkOutput, error)
	CreateLinkWithContext(aws.Context, *oam.CreateLinkInput, ...request.Option) (*oam.CreateLinkOutput, error)
	CreateLinkRequest(*oam.CreateLinkInput) (*request.Request, *oam.CreateLinkOutput)

	CreateSink(*oam.CreateSinkInput) (*oam.CreateSinkOutput, error)
	CreateSinkWithContext(aws.Context, *oam.CreateSinkInput, ...request.Option) (*oam.CreateSinkOutput, error)
	CreateSinkRequest(*oam.CreateSinkInput) (*request.Request, *oam.CreateSinkOutput)

	DeleteLink(*oam.DeleteLinkInput) (*oam.DeleteLinkOutput, error)
	DeleteLinkWithContext(aws.Context, *oam.DeleteLinkInput, ...request.Option) (*oam.DeleteLinkOutput, error)
	DeleteLinkRequest(*oam.DeleteLinkInput) (*request.Request, *oam.DeleteLinkOutput)

	DeleteSink(*oam.DeleteSinkInput) (*oam.DeleteSinkOutput, error)
	DeleteSinkWithContext(aws.Context, *oam.DeleteSinkInput, ...request.Option) (*oam.DeleteSinkOutput, error)
	DeleteSinkRequest(*oam.DeleteSinkInput) (*request.Request, *oam.DeleteSinkOutput)

	GetLink(*oam.GetLinkInput) (*oam.GetLinkOutput, error)
	GetLinkWithContext(aws.Context, *oam.GetLinkInput, ...request.Option) (*oam.GetLinkOutput, error)
	GetLinkRequest(*oam.GetLinkInput) (*request.Request, *oam.GetLinkOutput)

	GetSink(*oam.GetSinkInput) (*oam.GetSinkOutput, error)
	GetSinkWithContext(aws.Context, *oam.GetSinkInput, ...request.Option) (*oam.GetSinkOutput, error)
	GetSinkRequest(*oam.GetSinkInput) (*request.Request, *oam.GetSinkOutput)

	GetSinkPolicy(*oam.GetSinkPolicyInput) (*oam.GetSinkPolicyOutput, error)
	GetSinkPolicyWithContext(aws.Context, *oam.GetSinkPolicyInput, ...request.Option) (*oam.GetSinkPolicyOutput, error)
	GetSinkPolicyRequest(*oam.GetSinkPolicyInput) (*request.Request, *oam.GetSinkPolicyOutput)

	ListAttachedLinks(*oam.ListAttachedLinksInput) (*oam.ListAttachedLinksOutput, error)
	ListAttachedLinksWithContext(aws.Context, *oam.ListAttachedLinksInput, ...request.Option) (*oam.ListAttachedLinksOutput, error)
	ListAttachedLinksRequest(*oam.ListAttachedLinksInput) (*request.Request, *oam.ListAttachedLinksOutput)

	ListAttachedLinksPages(*oam.ListAttachedLinksInput, func(*oam.ListAttachedLinksOutput, bool) bool) error
	ListAttachedLinksPagesWithContext(aws.Context, *oam.ListAttachedLinksInput, func(*oam.ListAttachedLinksOutput, bool) bool, ...request.Option) error

	ListLinks(*oam.ListLinksInput) (*oam.ListLinksOutput, error)
	ListLinksWithContext(aws.Context, *oam.ListLinksInput, ...request.Option) (*oam.ListLinksOutput, error)
	ListLinksRequest(*oam.ListLinksInput) (*request.Request, *oam.ListLinksOutput)

	ListLinksPages(*oam.ListLinksInput, func(*oam.ListLinksOutput, bool) bool) error
	ListLinksPagesWithContext(aws.Context, *oam.ListLinksInput, func(*oam.ListLinksOutput, bool) bool, ...request.Option) error

	ListSinks(*oam.ListSinksInput) (*oam.ListSinksOutput, error)
	ListSinksWithContext(aws.Context, *oam.ListSinksInput, ...request.Option) (*oam.ListSinksOutput, error)
	ListSinksRequest(*oam.ListSinksInput) (*request.Request, *oam.ListSinksOutput)

	ListSinksPages(*oam.ListSinksInput, func(*oam.ListSinksOutput, bool) bool) error
	ListSinksPagesWithContext(aws.Context, *oam.ListSinksInput, func(*oam.ListSinksOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*oam.ListTagsForResourceInput) (*oam.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *oam.ListTagsForResourceInput, ...request.Option) (*oam.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*oam.ListTagsForResourceInput) (*request.Request, *oam.ListTagsForResourceOutput)

	PutSinkPolicy(*oam.PutSinkPolicyInput) (*oam.PutSinkPolicyOutput, error)
	PutSinkPolicyWithContext(aws.Context, *oam.PutSinkPolicyInput, ...request.Option) (*oam.PutSinkPolicyOutput, error)
	PutSinkPolicyRequest(*oam.PutSinkPolicyInput) (*request.Request, *oam.PutSinkPolicyOutput)

	TagResource(*oam.TagResourceInput) (*oam.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *oam.TagResourceInput, ...request.Option) (*oam.TagResourceOutput, error)
	TagResourceRequest(*oam.TagResourceInput) (*request.Request, *oam.TagResourceOutput)

	UntagResource(*oam.UntagResourceInput) (*oam.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *oam.UntagResourceInput, ...request.Option) (*oam.UntagResourceOutput, error)
	UntagResourceRequest(*oam.UntagResourceInput) (*request.Request, *oam.UntagResourceOutput)

	UpdateLink(*oam.UpdateLinkInput) (*oam.UpdateLinkOutput, error)
	UpdateLinkWithContext(aws.Context, *oam.UpdateLinkInput, ...request.Option) (*oam.UpdateLinkOutput, error)
	UpdateLinkRequest(*oam.UpdateLinkInput) (*request.Request, *oam.UpdateLinkOutput)
}

var _ OAMAPI = (*oam.OAM)(nil)
