// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchDescribeEntities = "BatchDescribeEntities"

// BatchDescribeEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDescribeEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDescribeEntities for more information on using the BatchDescribeEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDescribeEntitiesRequest method.
//	req, resp := client.BatchDescribeEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/BatchDescribeEntities
func (c *MarketplaceCatalog) BatchDescribeEntitiesRequest(input *BatchDescribeEntitiesInput) (req *request.Request, output *BatchDescribeEntitiesOutput) {
	op := &request.Operation{
		Name:       opBatchDescribeEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchDescribeEntities",
	}

	if input == nil {
		input = &BatchDescribeEntitiesInput{}
	}

	output = &BatchDescribeEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDescribeEntities API operation for AWS Marketplace Catalog Service.
//
// Returns metadata and content for multiple entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation BatchDescribeEntities for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/BatchDescribeEntities
func (c *MarketplaceCatalog) BatchDescribeEntities(input *BatchDescribeEntitiesInput) (*BatchDescribeEntitiesOutput, error) {
	req, out := c.BatchDescribeEntitiesRequest(input)
	return out, req.Send()
}

// BatchDescribeEntitiesWithContext is the same as BatchDescribeEntities with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDescribeEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) BatchDescribeEntitiesWithContext(ctx aws.Context, input *BatchDescribeEntitiesInput, opts ...request.Option) (*BatchDescribeEntitiesOutput, error) {
	req, out := c.BatchDescribeEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelChangeSet = "CancelChangeSet"

// CancelChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CancelChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelChangeSet for more information on using the CancelChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelChangeSetRequest method.
//	req, resp := client.CancelChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet
func (c *MarketplaceCatalog) CancelChangeSetRequest(input *CancelChangeSetInput) (req *request.Request, output *CancelChangeSetOutput) {
	op := &request.Operation{
		Name:       opCancelChangeSet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/CancelChangeSet",
	}

	if input == nil {
		input = &CancelChangeSetInput{}
	}

	output = &CancelChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelChangeSet API operation for AWS Marketplace Catalog Service.
//
// Used to cancel an open change request. Must be sent before the status of
// the request changes to APPLYING, the final stage of completing your change
// request. You can describe a change during the 60-day request history retention
// period for API calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation CancelChangeSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ResourceInUseException
//     The resource is currently in use.
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet
func (c *MarketplaceCatalog) CancelChangeSet(input *CancelChangeSetInput) (*CancelChangeSetOutput, error) {
	req, out := c.CancelChangeSetRequest(input)
	return out, req.Send()
}

// CancelChangeSetWithContext is the same as CancelChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CancelChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) CancelChangeSetWithContext(ctx aws.Context, input *CancelChangeSetInput, opts ...request.Option) (*CancelChangeSetOutput, error) {
	req, out := c.CancelChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy
func (c *MarketplaceCatalog) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteResourcePolicy",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for AWS Marketplace Catalog Service.
//
// Deletes a resource-based policy on an entity that is identified by its resource
// ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy
func (c *MarketplaceCatalog) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChangeSet for more information on using the DescribeChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChangeSetRequest method.
//	req, resp := client.DescribeChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet
func (c *MarketplaceCatalog) DescribeChangeSetRequest(input *DescribeChangeSetInput) (req *request.Request, output *DescribeChangeSetOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeChangeSet",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output = &DescribeChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSet API operation for AWS Marketplace Catalog Service.
//
// Provides information about a given change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation DescribeChangeSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet
func (c *MarketplaceCatalog) DescribeChangeSet(input *DescribeChangeSetInput) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	return out, req.Send()
}

// DescribeChangeSetWithContext is the same as DescribeChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) DescribeChangeSetWithContext(ctx aws.Context, input *DescribeChangeSetInput, opts ...request.Option) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntity = "DescribeEntity"

// DescribeEntityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntity for more information on using the DescribeEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEntityRequest method.
//	req, resp := client.DescribeEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity
func (c *MarketplaceCatalog) DescribeEntityRequest(input *DescribeEntityInput) (req *request.Request, output *DescribeEntityOutput) {
	op := &request.Operation{
		Name:       opDescribeEntity,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeEntity",
	}

	if input == nil {
		input = &DescribeEntityInput{}
	}

	output = &DescribeEntityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntity API operation for AWS Marketplace Catalog Service.
//
// Returns the metadata and content of the entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation DescribeEntity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotSupportedException
//     Currently, the specified resource is not supported.
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity
func (c *MarketplaceCatalog) DescribeEntity(input *DescribeEntityInput) (*DescribeEntityOutput, error) {
	req, out := c.DescribeEntityRequest(input)
	return out, req.Send()
}

// DescribeEntityWithContext is the same as DescribeEntity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) DescribeEntityWithContext(ctx aws.Context, input *DescribeEntityInput, opts ...request.Option) (*DescribeEntityOutput, error) {
	req, out := c.DescribeEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy
func (c *MarketplaceCatalog) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetResourcePolicy",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS Marketplace Catalog Service.
//
// Gets a resource-based policy of an entity that is identified by its resource
// ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy
func (c *MarketplaceCatalog) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChangeSets for more information on using the ListChangeSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChangeSetsRequest method.
//	req, resp := client.ListChangeSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets
func (c *MarketplaceCatalog) ListChangeSetsRequest(input *ListChangeSetsInput) (req *request.Request, output *ListChangeSetsOutput) {
	op := &request.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/ListChangeSets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output = &ListChangeSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangeSets API operation for AWS Marketplace Catalog Service.
//
// Returns the list of change sets owned by the account being used to make the
// call. You can filter this list by providing any combination of entityId,
// ChangeSetName, and status. If you provide more than one filter, the API operation
// applies a logical AND between the filters.
//
// You can describe a change during the 60-day request history retention period
// for API calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation ListChangeSets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets
func (c *MarketplaceCatalog) ListChangeSets(input *ListChangeSetsInput) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	return out, req.Send()
}

// ListChangeSetsWithContext is the same as ListChangeSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListChangeSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListChangeSetsWithContext(ctx aws.Context, input *ListChangeSetsInput, opts ...request.Option) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChangeSetsPages iterates over the pages of a ListChangeSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChangeSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChangeSets operation.
//	pageNum := 0
//	err := client.ListChangeSetsPages(params,
//	    func(page *marketplacecatalog.ListChangeSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MarketplaceCatalog) ListChangeSetsPages(input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool) error {
	return c.ListChangeSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChangeSetsPagesWithContext same as ListChangeSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListChangeSetsPagesWithContext(ctx aws.Context, input *ListChangeSetsInput, fn func(*ListChangeSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChangeSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChangeSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChangeSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntities = "ListEntities"

// ListEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntities for more information on using the ListEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntitiesRequest method.
//	req, resp := client.ListEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities
func (c *MarketplaceCatalog) ListEntitiesRequest(input *ListEntitiesInput) (req *request.Request, output *ListEntitiesOutput) {
	op := &request.Operation{
		Name:       opListEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/ListEntities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesInput{}
	}

	output = &ListEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntities API operation for AWS Marketplace Catalog Service.
//
// Provides the list of entities of a given type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation ListEntities for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities
func (c *MarketplaceCatalog) ListEntities(input *ListEntitiesInput) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	return out, req.Send()
}

// ListEntitiesWithContext is the same as ListEntities with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListEntitiesWithContext(ctx aws.Context, input *ListEntitiesInput, opts ...request.Option) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesPages iterates over the pages of a ListEntities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntities operation.
//	pageNum := 0
//	err := client.ListEntitiesPages(params,
//	    func(page *marketplacecatalog.ListEntitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MarketplaceCatalog) ListEntitiesPages(input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool) error {
	return c.ListEntitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesPagesWithContext same as ListEntitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListEntitiesPagesWithContext(ctx aws.Context, input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource
func (c *MarketplaceCatalog) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Marketplace Catalog Service.
//
// Lists all tags that have been added to a resource (either an entity (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities)
// or change set (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource
func (c *MarketplaceCatalog) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy
func (c *MarketplaceCatalog) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/PutResourcePolicy",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourcePolicy API operation for AWS Marketplace Catalog Service.
//
// Attaches a resource-based policy to an entity. Examples of an entity include:
// AmiProduct and ContainerProduct.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy
func (c *MarketplaceCatalog) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartChangeSet = "StartChangeSet"

// StartChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the StartChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChangeSet for more information on using the StartChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartChangeSetRequest method.
//	req, resp := client.StartChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet
func (c *MarketplaceCatalog) StartChangeSetRequest(input *StartChangeSetInput) (req *request.Request, output *StartChangeSetOutput) {
	op := &request.Operation{
		Name:       opStartChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/StartChangeSet",
	}

	if input == nil {
		input = &StartChangeSetInput{}
	}

	output = &StartChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChangeSet API operation for AWS Marketplace Catalog Service.
//
// Allows you to request changes for your entities. Within a single ChangeSet,
// you can't start the same change type against the same entity multiple times.
// Additionally, when a ChangeSet is running, all the entities targeted by the
// different changes are locked until the change set has completed (either succeeded,
// cancelled, or failed). If you try to start a change set containing a change
// against an entity that is already locked, you will receive a ResourceInUseException
// error.
//
// For example, you can't start the ChangeSet described in the example (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples)
// later in this topic because it contains two changes to run the same change
// type (AddRevisions) against the same entity (entity-id@1).
//
// For more information about working with change sets, see Working with change
// sets (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets).
// For information about change types for single-AMI products, see Working with
// single-AMI products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products).
// Also, for more information about change types available for container-based
// products, see Working with container products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation StartChangeSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - ResourceInUseException
//     The resource is currently in use.
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
//   - ServiceQuotaExceededException
//     The maximum number of open requests per account has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet
func (c *MarketplaceCatalog) StartChangeSet(input *StartChangeSetInput) (*StartChangeSetOutput, error) {
	req, out := c.StartChangeSetRequest(input)
	return out, req.Send()
}

// StartChangeSetWithContext is the same as StartChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See StartChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) StartChangeSetWithContext(ctx aws.Context, input *StartChangeSetInput, opts ...request.Option) (*StartChangeSetOutput, error) {
	req, out := c.StartChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource
func (c *MarketplaceCatalog) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/TagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Marketplace Catalog Service.
//
// Tags a resource (either an entity (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities)
// or change set (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource
func (c *MarketplaceCatalog) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource
func (c *MarketplaceCatalog) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/UntagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Marketplace Catalog Service.
//
// Removes a tag or list of tags from a resource (either an entity (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities)
// or change set (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Catalog Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource wasn't found.
//
//     HTTP status code: 404
//
//   - InternalServiceException
//     There was an internal service exception.
//
//     HTTP status code: 500
//
//   - AccessDeniedException
//     Access is denied.
//
//     HTTP status code: 403
//
//   - ValidationException
//     An error occurred during validation.
//
//     HTTP status code: 422
//
//   - ThrottlingException
//     Too many requests.
//
//     HTTP status code: 429
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource
func (c *MarketplaceCatalog) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceCatalog) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied.
//
// HTTP status code: 403
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object that allows filtering on entity id of an AMI product.
type AmiProductEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique entity id values to be filtered on.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *AmiProductEntityIdFilter) SetValueList(v []*string) *AmiProductEntityIdFilter {
	s.ValueList = v
	return s
}

// Object containing all the filter fields for AMI products. Client can add
// a maximum of 8 filters in a single ListEntities request.
type AmiProductFilters struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the AMI product.
	EntityId *AmiProductEntityIdFilter `type:"structure"`

	// The last date on which the AMI product was modified.
	LastModifiedDate *AmiProductLastModifiedDateFilter `type:"structure"`

	// The title of the AMI product.
	ProductTitle *AmiProductTitleFilter `type:"structure"`

	// The visibility of the AMI product.
	Visibility *AmiProductVisibilityFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductFilters"}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductTitle != nil {
		if err := s.ProductTitle.Validate(); err != nil {
			invalidParams.AddNested("ProductTitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Visibility != nil {
		if err := s.Visibility.Validate(); err != nil {
			invalidParams.AddNested("Visibility", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *AmiProductFilters) SetEntityId(v *AmiProductEntityIdFilter) *AmiProductFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *AmiProductFilters) SetLastModifiedDate(v *AmiProductLastModifiedDateFilter) *AmiProductFilters {
	s.LastModifiedDate = v
	return s
}

// SetProductTitle sets the ProductTitle field's value.
func (s *AmiProductFilters) SetProductTitle(v *AmiProductTitleFilter) *AmiProductFilters {
	s.ProductTitle = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *AmiProductFilters) SetVisibility(v *AmiProductVisibilityFilter) *AmiProductFilters {
	s.Visibility = v
	return s
}

// Object that allows filtering based on the last modified date of AMI products.
type AmiProductLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Dates between which the AMI product was last modified.
	DateRange *AmiProductLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *AmiProductLastModifiedDateFilter) SetDateRange(v *AmiProductLastModifiedDateFilterDateRange) *AmiProductLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Object that contains date range of the last modified date to be filtered
// on. You can optionally provide a BeforeValue and/or AfterValue. Both are
// inclusive.
type AmiProductLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Date after which the AMI product was last modified.
	AfterValue *string `min:"20" type:"string"`

	// Date before which the AMI product was last modified.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *AmiProductLastModifiedDateFilterDateRange) SetAfterValue(v string) *AmiProductLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *AmiProductLastModifiedDateFilterDateRange) SetBeforeValue(v string) *AmiProductLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Objects that allows sorting on AMI products based on certain fields and sorting
// order.
type AmiProductSort struct {
	_ struct{} `type:"structure"`

	// Field to sort the AMI products by.
	SortBy *string `type:"string" enum:"AmiProductSortBy"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *AmiProductSort) SetSortBy(v string) *AmiProductSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *AmiProductSort) SetSortOrder(v string) *AmiProductSort {
	s.SortOrder = &v
	return s
}

// Object that contains summarized information about an AMI product.
type AmiProductSummary struct {
	_ struct{} `type:"structure"`

	// The title of the AMI product.
	ProductTitle *string `min:"1" type:"string"`

	// The lifecycle of the AMI product.
	Visibility *string `type:"string" enum:"AmiProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductSummary) GoString() string {
	return s.String()
}

// SetProductTitle sets the ProductTitle field's value.
func (s *AmiProductSummary) SetProductTitle(v string) *AmiProductSummary {
	s.ProductTitle = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *AmiProductSummary) SetVisibility(v string) *AmiProductSummary {
	s.Visibility = &v
	return s
}

// Object that allows filtering on product title.
type AmiProductTitleFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique product title values to be filtered on.
	ValueList []*string `min:"1" type:"list"`

	// A string that will be the wildCard input for product tile filter. It matches
	// the provided value as a substring in the actual value.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductTitleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductTitleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductTitleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductTitleFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *AmiProductTitleFilter) SetValueList(v []*string) *AmiProductTitleFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *AmiProductTitleFilter) SetWildCardValue(v string) *AmiProductTitleFilter {
	s.WildCardValue = &v
	return s
}

// Object that allows filtering on the visibility of the product in the AWS
// Marketplace.
type AmiProductVisibilityFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique visibility values to be filtered on.
	ValueList []*string `min:"1" type:"list" enum:"AmiProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductVisibilityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiProductVisibilityFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiProductVisibilityFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiProductVisibilityFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *AmiProductVisibilityFilter) SetValueList(v []*string) *AmiProductVisibilityFilter {
	s.ValueList = v
	return s
}

type BatchDescribeEntitiesInput struct {
	_ struct{} `type:"structure"`

	// List of entity IDs and the catalogs the entities are present in.
	//
	// EntityRequestList is a required field
	EntityRequestList []*EntityRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDescribeEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDescribeEntitiesInput"}
	if s.EntityRequestList == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRequestList"))
	}
	if s.EntityRequestList != nil && len(s.EntityRequestList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityRequestList", 1))
	}
	if s.EntityRequestList != nil {
		for i, v := range s.EntityRequestList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityRequestList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRequestList sets the EntityRequestList field's value.
func (s *BatchDescribeEntitiesInput) SetEntityRequestList(v []*EntityRequest) *BatchDescribeEntitiesInput {
	s.EntityRequestList = v
	return s
}

type BatchDescribeEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// Details about each entity.
	EntityDetails map[string]*EntityDetail `type:"map"`

	// A map of errors returned, with EntityId as the key and errorDetail as the
	// value.
	Errors map[string]*BatchDescribeErrorDetail `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntityDetails sets the EntityDetails field's value.
func (s *BatchDescribeEntitiesOutput) SetEntityDetails(v map[string]*EntityDetail) *BatchDescribeEntitiesOutput {
	s.EntityDetails = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchDescribeEntitiesOutput) SetErrors(v map[string]*BatchDescribeErrorDetail) *BatchDescribeEntitiesOutput {
	s.Errors = v
	return s
}

// An object that contains an error code and error message.
type BatchDescribeErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code returned.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDescribeErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchDescribeErrorDetail) SetErrorCode(v string) *BatchDescribeErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchDescribeErrorDetail) SetErrorMessage(v string) *BatchDescribeErrorDetail {
	s.ErrorMessage = &v
	return s
}

type CancelChangeSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace.
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier of the StartChangeSet request that you want
	// to cancel.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *CancelChangeSetInput) SetCatalog(v string) *CancelChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *CancelChangeSetInput) SetChangeSetId(v string) *CancelChangeSetInput {
	s.ChangeSetId = &v
	return s
}

type CancelChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the change set referenced in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *CancelChangeSetOutput) SetChangeSetArn(v string) *CancelChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *CancelChangeSetOutput) SetChangeSetId(v string) *CancelChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// An object that contains the ChangeType, Details, and Entity.
type Change struct {
	_ struct{} `type:"structure"`

	// Optional name for the change.
	ChangeName *string `min:"1" type:"string"`

	// Change types are single string values that describe your intention for the
	// change. Each change type is unique for each EntityType provided in the change's
	// scope. For more information about change types available for single-AMI products,
	// see Working with single-AMI products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products).
	// Also, for more information about change types available for container-based
	// products, see Working with container products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products).
	//
	// ChangeType is a required field
	ChangeType *string `min:"1" type:"string" required:"true"`

	// This object contains details specific to the change type of the requested
	// change. For more information about change types available for single-AMI
	// products, see Working with single-AMI products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products).
	// Also, for more information about change types available for container-based
	// products, see Working with container products (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products).
	Details *string `min:"2" type:"string"`

	// The entity to be changed.
	//
	// Entity is a required field
	Entity *Entity `type:"structure" required:"true"`

	// The tags associated with the change.
	EntityTags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Change) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Change"}
	if s.ChangeName != nil && len(*s.ChangeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeName", 1))
	}
	if s.ChangeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeType"))
	}
	if s.ChangeType != nil && len(*s.ChangeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeType", 1))
	}
	if s.Details != nil && len(*s.Details) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Details", 2))
	}
	if s.Entity == nil {
		invalidParams.Add(request.NewErrParamRequired("Entity"))
	}
	if s.EntityTags != nil && len(s.EntityTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityTags", 1))
	}
	if s.Entity != nil {
		if err := s.Entity.Validate(); err != nil {
			invalidParams.AddNested("Entity", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityTags != nil {
		for i, v := range s.EntityTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeName sets the ChangeName field's value.
func (s *Change) SetChangeName(v string) *Change {
	s.ChangeName = &v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *Change) SetChangeType(v string) *Change {
	s.ChangeType = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *Change) SetDetails(v string) *Change {
	s.Details = &v
	return s
}

// SetEntity sets the Entity field's value.
func (s *Change) SetEntity(v *Entity) *Change {
	s.Entity = v
	return s
}

// SetEntityTags sets the EntityTags field's value.
func (s *Change) SetEntityTags(v []*Tag) *Change {
	s.EntityTags = v
	return s
}

// A summary of a change set returned in a list of change sets when the ListChangeSets
// action is called.
type ChangeSetSummaryListItem struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for a change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The non-unique name for the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was finished.
	EndTime *string `min:"20" type:"string"`

	// This object is a list of entity IDs (string) that are a part of a change
	// set. The entity ID list is a maximum of 20 entities. It must contain at least
	// one entity.
	EntityIdList []*string `type:"list"`

	// Returned if the change set is in FAILED status. Can be either CLIENT_ERROR,
	// which means that there are issues with the request (see the ErrorDetailList
	// of DescribeChangeSet), or SERVER_FAULT, which means that there is a problem
	// in the system, and you should retry your request.
	FailureCode *string `type:"string" enum:"FailureCode"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was started.
	StartTime *string `min:"20" type:"string"`

	// The current status of the change set.
	Status *string `type:"string" enum:"ChangeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetSummaryListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSetSummaryListItem) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetArn(v string) *ChangeSetSummaryListItem {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetId(v string) *ChangeSetSummaryListItem {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ChangeSetSummaryListItem) SetChangeSetName(v string) *ChangeSetSummaryListItem {
	s.ChangeSetName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ChangeSetSummaryListItem) SetEndTime(v string) *ChangeSetSummaryListItem {
	s.EndTime = &v
	return s
}

// SetEntityIdList sets the EntityIdList field's value.
func (s *ChangeSetSummaryListItem) SetEntityIdList(v []*string) *ChangeSetSummaryListItem {
	s.EntityIdList = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *ChangeSetSummaryListItem) SetFailureCode(v string) *ChangeSetSummaryListItem {
	s.FailureCode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ChangeSetSummaryListItem) SetStartTime(v string) *ChangeSetSummaryListItem {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeSetSummaryListItem) SetStatus(v string) *ChangeSetSummaryListItem {
	s.Status = &v
	return s
}

// This object is a container for common summary information about the change.
// The summary doesn't contain the whole change structure.
type ChangeSummary struct {
	_ struct{} `type:"structure"`

	// Optional name for the change.
	ChangeName *string `min:"1" type:"string"`

	// The type of the change.
	ChangeType *string `min:"1" type:"string"`

	// This object contains details specific to the change type of the requested
	// change.
	Details *string `min:"2" type:"string"`

	// The entity to be changed.
	Entity *Entity `type:"structure"`

	// An array of ErrorDetail objects associated with the change.
	ErrorDetailList []*ErrorDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeSummary) GoString() string {
	return s.String()
}

// SetChangeName sets the ChangeName field's value.
func (s *ChangeSummary) SetChangeName(v string) *ChangeSummary {
	s.ChangeName = &v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *ChangeSummary) SetChangeType(v string) *ChangeSummary {
	s.ChangeType = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ChangeSummary) SetDetails(v string) *ChangeSummary {
	s.Details = &v
	return s
}

// SetEntity sets the Entity field's value.
func (s *ChangeSummary) SetEntity(v *Entity) *ChangeSummary {
	s.Entity = v
	return s
}

// SetErrorDetailList sets the ErrorDetailList field's value.
func (s *ChangeSummary) SetErrorDetailList(v []*ErrorDetail) *ChangeSummary {
	s.ErrorDetailList = v
	return s
}

// Object that allows filtering on entity id of a container product.
type ContainerProductEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique entity id values to be filtered on.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ContainerProductEntityIdFilter) SetValueList(v []*string) *ContainerProductEntityIdFilter {
	s.ValueList = v
	return s
}

// Object containing all the filter fields for container products. Client can
// add a maximum of 8 filters in a single ListEntities request.
type ContainerProductFilters struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the container product.
	EntityId *ContainerProductEntityIdFilter `type:"structure"`

	// The last date on which the container product was modified.
	LastModifiedDate *ContainerProductLastModifiedDateFilter `type:"structure"`

	// The title of the container product.
	ProductTitle *ContainerProductTitleFilter `type:"structure"`

	// The visibility of the container product.
	Visibility *ContainerProductVisibilityFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductFilters"}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductTitle != nil {
		if err := s.ProductTitle.Validate(); err != nil {
			invalidParams.AddNested("ProductTitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Visibility != nil {
		if err := s.Visibility.Validate(); err != nil {
			invalidParams.AddNested("Visibility", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *ContainerProductFilters) SetEntityId(v *ContainerProductEntityIdFilter) *ContainerProductFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ContainerProductFilters) SetLastModifiedDate(v *ContainerProductLastModifiedDateFilter) *ContainerProductFilters {
	s.LastModifiedDate = v
	return s
}

// SetProductTitle sets the ProductTitle field's value.
func (s *ContainerProductFilters) SetProductTitle(v *ContainerProductTitleFilter) *ContainerProductFilters {
	s.ProductTitle = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *ContainerProductFilters) SetVisibility(v *ContainerProductVisibilityFilter) *ContainerProductFilters {
	s.Visibility = v
	return s
}

// Object that allows filtering based on the last modified date of container
// products.
type ContainerProductLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Dates between which the container product was last modified.
	DateRange *ContainerProductLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *ContainerProductLastModifiedDateFilter) SetDateRange(v *ContainerProductLastModifiedDateFilterDateRange) *ContainerProductLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Object that contains date range of the last modified date to be filtered
// on. You can optionally provide a BeforeValue and/or AfterValue. Both are
// inclusive.
type ContainerProductLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Date after which the container product was last modified.
	AfterValue *string `min:"20" type:"string"`

	// Date before which the container product was last modified.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *ContainerProductLastModifiedDateFilterDateRange) SetAfterValue(v string) *ContainerProductLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *ContainerProductLastModifiedDateFilterDateRange) SetBeforeValue(v string) *ContainerProductLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Objects that allows sorting on container products based on certain fields
// and sorting order.
type ContainerProductSort struct {
	_ struct{} `type:"structure"`

	// Field to sort the container products by.
	SortBy *string `type:"string" enum:"ContainerProductSortBy"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *ContainerProductSort) SetSortBy(v string) *ContainerProductSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ContainerProductSort) SetSortOrder(v string) *ContainerProductSort {
	s.SortOrder = &v
	return s
}

// Object that contains summarized information about a container product.
type ContainerProductSummary struct {
	_ struct{} `type:"structure"`

	// The title of the container product.
	ProductTitle *string `min:"1" type:"string"`

	// The lifecycle of the product.
	Visibility *string `type:"string" enum:"ContainerProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductSummary) GoString() string {
	return s.String()
}

// SetProductTitle sets the ProductTitle field's value.
func (s *ContainerProductSummary) SetProductTitle(v string) *ContainerProductSummary {
	s.ProductTitle = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *ContainerProductSummary) SetVisibility(v string) *ContainerProductSummary {
	s.Visibility = &v
	return s
}

// Object that allows filtering on product title.
type ContainerProductTitleFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique product title values to be filtered on.
	ValueList []*string `min:"1" type:"list"`

	// A string that will be the wildCard input for product tile filter. It matches
	// the provided value as a substring in the actual value.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductTitleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductTitleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductTitleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductTitleFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ContainerProductTitleFilter) SetValueList(v []*string) *ContainerProductTitleFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ContainerProductTitleFilter) SetWildCardValue(v string) *ContainerProductTitleFilter {
	s.WildCardValue = &v
	return s
}

// Object that allows filtering on the visibility of the product in the AWS
// Marketplace.
type ContainerProductVisibilityFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique visibility values to be filtered on.
	ValueList []*string `min:"1" type:"list" enum:"ContainerProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductVisibilityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerProductVisibilityFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProductVisibilityFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProductVisibilityFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ContainerProductVisibilityFilter) SetValueList(v []*string) *ContainerProductVisibilityFilter {
	s.ValueList = v
	return s
}

// Object that allows filtering on entity id of a data product.
type DataProductEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique entity id values to be filtered on.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *DataProductEntityIdFilter) SetValueList(v []*string) *DataProductEntityIdFilter {
	s.ValueList = v
	return s
}

// Object containing all the filter fields for data products. Client can add
// a maximum of 8 filters in a single ListEntities request.
type DataProductFilters struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the data product.
	EntityId *DataProductEntityIdFilter `type:"structure"`

	// The last date on which the data product was modified.
	LastModifiedDate *DataProductLastModifiedDateFilter `type:"structure"`

	// The title of the data product.
	ProductTitle *DataProductTitleFilter `type:"structure"`

	// The visibility of the data product.
	Visibility *DataProductVisibilityFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductFilters"}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductTitle != nil {
		if err := s.ProductTitle.Validate(); err != nil {
			invalidParams.AddNested("ProductTitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Visibility != nil {
		if err := s.Visibility.Validate(); err != nil {
			invalidParams.AddNested("Visibility", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DataProductFilters) SetEntityId(v *DataProductEntityIdFilter) *DataProductFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DataProductFilters) SetLastModifiedDate(v *DataProductLastModifiedDateFilter) *DataProductFilters {
	s.LastModifiedDate = v
	return s
}

// SetProductTitle sets the ProductTitle field's value.
func (s *DataProductFilters) SetProductTitle(v *DataProductTitleFilter) *DataProductFilters {
	s.ProductTitle = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *DataProductFilters) SetVisibility(v *DataProductVisibilityFilter) *DataProductFilters {
	s.Visibility = v
	return s
}

// Object that allows filtering based on the last modified date of data products.
type DataProductLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Dates between which the data product was last modified.
	DateRange *DataProductLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *DataProductLastModifiedDateFilter) SetDateRange(v *DataProductLastModifiedDateFilterDateRange) *DataProductLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Object that contains date range of the last modified date to be filtered
// on. You can optionally provide a BeforeValue and/or AfterValue. Both are
// inclusive.
type DataProductLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Date after which the data product was last modified.
	AfterValue *string `min:"20" type:"string"`

	// Date before which the data product was last modified.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *DataProductLastModifiedDateFilterDateRange) SetAfterValue(v string) *DataProductLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *DataProductLastModifiedDateFilterDateRange) SetBeforeValue(v string) *DataProductLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Objects that allows sorting on data products based on certain fields and
// sorting order.
type DataProductSort struct {
	_ struct{} `type:"structure"`

	// Field to sort the data products by.
	SortBy *string `type:"string" enum:"DataProductSortBy"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *DataProductSort) SetSortBy(v string) *DataProductSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DataProductSort) SetSortOrder(v string) *DataProductSort {
	s.SortOrder = &v
	return s
}

// Object that contains summarized information about a data product.
type DataProductSummary struct {
	_ struct{} `type:"structure"`

	// The title of the data product.
	ProductTitle *string `min:"1" type:"string"`

	// The lifecycle of the data product.
	Visibility *string `type:"string" enum:"DataProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductSummary) GoString() string {
	return s.String()
}

// SetProductTitle sets the ProductTitle field's value.
func (s *DataProductSummary) SetProductTitle(v string) *DataProductSummary {
	s.ProductTitle = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *DataProductSummary) SetVisibility(v string) *DataProductSummary {
	s.Visibility = &v
	return s
}

// Object that allows filtering on product title.
type DataProductTitleFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique product title values to be filtered on.
	ValueList []*string `min:"1" type:"list"`

	// A string that will be the wildCard input for product tile filter. It matches
	// the provided value as a substring in the actual value.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductTitleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductTitleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductTitleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductTitleFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *DataProductTitleFilter) SetValueList(v []*string) *DataProductTitleFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *DataProductTitleFilter) SetWildCardValue(v string) *DataProductTitleFilter {
	s.WildCardValue = &v
	return s
}

// Object that allows filtering on the visibility of the product in the AWS
// Marketplace.
type DataProductVisibilityFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique visibility values to be filtered on.
	ValueList []*string `min:"1" type:"list" enum:"DataProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductVisibilityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataProductVisibilityFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataProductVisibilityFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataProductVisibilityFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *DataProductVisibilityFilter) SetValueList(v []*string) *DataProductVisibilityFilter {
	s.ValueList = v
	return s
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the entity resource that is associated
	// with the resource policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DescribeChangeSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier for the StartChangeSet request that you want
	// to describe the details for.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *DescribeChangeSetInput) SetCatalog(v string) *DescribeChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetInput) SetChangeSetId(v string) *DescribeChangeSetInput {
	s.ChangeSetId = &v
	return s
}

type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChangeSummary objects.
	ChangeSet []*ChangeSummary `type:"list"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Required. The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`

	// The optional name provided in the StartChangeSet request. If you do not provide
	// a name, one is set by default.
	ChangeSetName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// transitioned to a terminal state. The change cannot transition to a different
	// state. Null if the request is not in a terminal state.
	EndTime *string `min:"20" type:"string"`

	// Returned if the change set is in FAILED status. Can be either CLIENT_ERROR,
	// which means that there are issues with the request (see the ErrorDetailList),
	// or SERVER_FAULT, which means that there is a problem in the system, and you
	// should retry your request.
	FailureCode *string `type:"string" enum:"FailureCode"`

	// Returned if there is a failure on the change set, but that failure is not
	// related to any of the changes in the request.
	FailureDescription *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// started.
	StartTime *string `min:"20" type:"string"`

	// The status of the change request.
	Status *string `type:"string" enum:"ChangeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSet sets the ChangeSet field's value.
func (s *DescribeChangeSetOutput) SetChangeSet(v []*ChangeSummary) *DescribeChangeSetOutput {
	s.ChangeSet = v
	return s
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *DescribeChangeSetOutput) SetChangeSetArn(v string) *DescribeChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetChangeSetId(v string) *DescribeChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetOutput) SetChangeSetName(v string) *DescribeChangeSetOutput {
	s.ChangeSetName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeChangeSetOutput) SetEndTime(v string) *DescribeChangeSetOutput {
	s.EndTime = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeChangeSetOutput) SetFailureCode(v string) *DescribeChangeSetOutput {
	s.FailureCode = &v
	return s
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *DescribeChangeSetOutput) SetFailureDescription(v string) *DescribeChangeSetOutput {
	s.FailureDescription = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeChangeSetOutput) SetStartTime(v string) *DescribeChangeSetOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetOutput) SetStatus(v string) *DescribeChangeSetOutput {
	s.Status = &v
	return s
}

type DescribeEntityInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique ID of the entity to describe.
	//
	// EntityId is a required field
	EntityId *string `location:"querystring" locationName:"entityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntityInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *DescribeEntityInput) SetCatalog(v string) *DescribeEntityInput {
	s.Catalog = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *DescribeEntityInput) SetEntityId(v string) *DescribeEntityInput {
	s.EntityId = &v
	return s
}

type DescribeEntityOutput struct {
	_ struct{} `type:"structure"`

	// This stringified JSON object includes the details of the entity.
	Details *string `min:"2" type:"string"`

	// The ARN associated to the unique identifier for the entity referenced in
	// this request.
	EntityArn *string `min:"1" type:"string"`

	// The identifier of the entity, in the format of EntityId@RevisionId.
	EntityIdentifier *string `min:"1" type:"string"`

	// The named type of the entity, in the format of EntityType@Version.
	EntityType *string `min:"1" type:"string"`

	// The last modified date of the entity, in ISO 8601 format (2018-02-27T13:45:22Z).
	LastModifiedDate *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *DescribeEntityOutput) SetDetails(v string) *DescribeEntityOutput {
	s.Details = &v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *DescribeEntityOutput) SetEntityArn(v string) *DescribeEntityOutput {
	s.EntityArn = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *DescribeEntityOutput) SetEntityIdentifier(v string) *DescribeEntityOutput {
	s.EntityIdentifier = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *DescribeEntityOutput) SetEntityType(v string) *DescribeEntityOutput {
	s.EntityType = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *DescribeEntityOutput) SetLastModifiedDate(v string) *DescribeEntityOutput {
	s.LastModifiedDate = &v
	return s
}

// An entity contains data that describes your product, its supported features,
// and how it can be used or launched by your customer.
type Entity struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity.
	Identifier *string `min:"1" type:"string"`

	// The type of entity.
	//
	// Type is a required field
	Type *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Entity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Entity"}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *Entity) SetIdentifier(v string) *Entity {
	s.Identifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// An object that contains metadata and details about the entity.
type EntityDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	EntityArn *string `min:"1" type:"string"`

	// The ID of the entity, in the format of EntityId@RevisionId.
	EntityIdentifier *string `min:"1" type:"string"`

	// The entity type of the entity, in the format of EntityType@Version.
	EntityType *string `min:"1" type:"string"`

	// The last time the entity was modified.
	LastModifiedDate *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityDetail) GoString() string {
	return s.String()
}

// SetEntityArn sets the EntityArn field's value.
func (s *EntityDetail) SetEntityArn(v string) *EntityDetail {
	s.EntityArn = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *EntityDetail) SetEntityIdentifier(v string) *EntityDetail {
	s.EntityIdentifier = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *EntityDetail) SetEntityType(v string) *EntityDetail {
	s.EntityType = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EntityDetail) SetLastModifiedDate(v string) *EntityDetail {
	s.LastModifiedDate = &v
	return s
}

// An object that contains entity ID and the catalog in which the entity is
// present.
type EntityRequest struct {
	_ struct{} `type:"structure"`

	// The name of the catalog the entity is present in. The only value at this
	// time is AWSMarketplace.
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRequest"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *EntityRequest) SetCatalog(v string) *EntityRequest {
	s.Catalog = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EntityRequest) SetEntityId(v string) *EntityRequest {
	s.EntityId = &v
	return s
}

// This object is a container for common summary information about the entity.
// The summary doesn't contain the whole entity structure, but it does contain
// information common across all entities.
type EntitySummary struct {
	_ struct{} `type:"structure"`

	// An object that contains summary information about the AMI product.
	AmiProductSummary *AmiProductSummary `type:"structure"`

	// An object that contains summary information about the container product.
	ContainerProductSummary *ContainerProductSummary `type:"structure"`

	// An object that contains summary information about the data product.
	DataProductSummary *DataProductSummary `type:"structure"`

	// The ARN associated with the unique identifier for the entity.
	EntityArn *string `min:"1" type:"string"`

	// The unique identifier for the entity.
	EntityId *string `min:"1" type:"string"`

	// The type of the entity.
	EntityType *string `min:"1" type:"string"`

	// The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
	LastModifiedDate *string `min:"20" type:"string"`

	// The name for the entity. This value is not unique. It is defined by the seller.
	Name *string `min:"1" type:"string"`

	// An object that contains summary information about the offer.
	OfferSummary *OfferSummary `type:"structure"`

	// An object that contains summary information about the Resale Authorization.
	ResaleAuthorizationSummary *ResaleAuthorizationSummary `type:"structure"`

	// An object that contains summary information about the SaaS product.
	SaaSProductSummary *SaaSProductSummary `type:"structure"`

	// The visibility status of the entity to buyers. This value can be Public (everyone
	// can view the entity), Limited (the entity is visible to limited accounts
	// only), or Restricted (the entity was published and then unpublished and only
	// existing buyers can view it).
	Visibility *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitySummary) GoString() string {
	return s.String()
}

// SetAmiProductSummary sets the AmiProductSummary field's value.
func (s *EntitySummary) SetAmiProductSummary(v *AmiProductSummary) *EntitySummary {
	s.AmiProductSummary = v
	return s
}

// SetContainerProductSummary sets the ContainerProductSummary field's value.
func (s *EntitySummary) SetContainerProductSummary(v *ContainerProductSummary) *EntitySummary {
	s.ContainerProductSummary = v
	return s
}

// SetDataProductSummary sets the DataProductSummary field's value.
func (s *EntitySummary) SetDataProductSummary(v *DataProductSummary) *EntitySummary {
	s.DataProductSummary = v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *EntitySummary) SetEntityArn(v string) *EntitySummary {
	s.EntityArn = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EntitySummary) SetEntityId(v string) *EntitySummary {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *EntitySummary) SetEntityType(v string) *EntitySummary {
	s.EntityType = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EntitySummary) SetLastModifiedDate(v string) *EntitySummary {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *EntitySummary) SetName(v string) *EntitySummary {
	s.Name = &v
	return s
}

// SetOfferSummary sets the OfferSummary field's value.
func (s *EntitySummary) SetOfferSummary(v *OfferSummary) *EntitySummary {
	s.OfferSummary = v
	return s
}

// SetResaleAuthorizationSummary sets the ResaleAuthorizationSummary field's value.
func (s *EntitySummary) SetResaleAuthorizationSummary(v *ResaleAuthorizationSummary) *EntitySummary {
	s.ResaleAuthorizationSummary = v
	return s
}

// SetSaaSProductSummary sets the SaaSProductSummary field's value.
func (s *EntitySummary) SetSaaSProductSummary(v *SaaSProductSummary) *EntitySummary {
	s.SaaSProductSummary = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *EntitySummary) SetVisibility(v string) *EntitySummary {
	s.Visibility = &v
	return s
}

// Object containing all the filter fields per entity type.
type EntityTypeFilters struct {
	_ struct{} `type:"structure"`

	// A filter for AMI products.
	AmiProductFilters *AmiProductFilters `type:"structure"`

	// A filter for container products.
	ContainerProductFilters *ContainerProductFilters `type:"structure"`

	// A filter for data products.
	DataProductFilters *DataProductFilters `type:"structure"`

	// A filter for offers.
	OfferFilters *OfferFilters `type:"structure"`

	// A filter for Resale Authorizations.
	ResaleAuthorizationFilters *ResaleAuthorizationFilters `type:"structure"`

	// A filter for SaaS products.
	SaaSProductFilters *SaaSProductFilters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypeFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypeFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityTypeFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityTypeFilters"}
	if s.AmiProductFilters != nil {
		if err := s.AmiProductFilters.Validate(); err != nil {
			invalidParams.AddNested("AmiProductFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainerProductFilters != nil {
		if err := s.ContainerProductFilters.Validate(); err != nil {
			invalidParams.AddNested("ContainerProductFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.DataProductFilters != nil {
		if err := s.DataProductFilters.Validate(); err != nil {
			invalidParams.AddNested("DataProductFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.OfferFilters != nil {
		if err := s.OfferFilters.Validate(); err != nil {
			invalidParams.AddNested("OfferFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.ResaleAuthorizationFilters != nil {
		if err := s.ResaleAuthorizationFilters.Validate(); err != nil {
			invalidParams.AddNested("ResaleAuthorizationFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.SaaSProductFilters != nil {
		if err := s.SaaSProductFilters.Validate(); err != nil {
			invalidParams.AddNested("SaaSProductFilters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiProductFilters sets the AmiProductFilters field's value.
func (s *EntityTypeFilters) SetAmiProductFilters(v *AmiProductFilters) *EntityTypeFilters {
	s.AmiProductFilters = v
	return s
}

// SetContainerProductFilters sets the ContainerProductFilters field's value.
func (s *EntityTypeFilters) SetContainerProductFilters(v *ContainerProductFilters) *EntityTypeFilters {
	s.ContainerProductFilters = v
	return s
}

// SetDataProductFilters sets the DataProductFilters field's value.
func (s *EntityTypeFilters) SetDataProductFilters(v *DataProductFilters) *EntityTypeFilters {
	s.DataProductFilters = v
	return s
}

// SetOfferFilters sets the OfferFilters field's value.
func (s *EntityTypeFilters) SetOfferFilters(v *OfferFilters) *EntityTypeFilters {
	s.OfferFilters = v
	return s
}

// SetResaleAuthorizationFilters sets the ResaleAuthorizationFilters field's value.
func (s *EntityTypeFilters) SetResaleAuthorizationFilters(v *ResaleAuthorizationFilters) *EntityTypeFilters {
	s.ResaleAuthorizationFilters = v
	return s
}

// SetSaaSProductFilters sets the SaaSProductFilters field's value.
func (s *EntityTypeFilters) SetSaaSProductFilters(v *SaaSProductFilters) *EntityTypeFilters {
	s.SaaSProductFilters = v
	return s
}

// Object containing all the sort fields per entity type.
type EntityTypeSort struct {
	_ struct{} `type:"structure"`

	// A sort for AMI products.
	AmiProductSort *AmiProductSort `type:"structure"`

	// A sort for container products.
	ContainerProductSort *ContainerProductSort `type:"structure"`

	// A sort for data products.
	DataProductSort *DataProductSort `type:"structure"`

	// A sort for offers.
	OfferSort *OfferSort `type:"structure"`

	// A sort for Resale Authorizations.
	ResaleAuthorizationSort *ResaleAuthorizationSort `type:"structure"`

	// A sort for SaaS products.
	SaaSProductSort *SaaSProductSort `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypeSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypeSort) GoString() string {
	return s.String()
}

// SetAmiProductSort sets the AmiProductSort field's value.
func (s *EntityTypeSort) SetAmiProductSort(v *AmiProductSort) *EntityTypeSort {
	s.AmiProductSort = v
	return s
}

// SetContainerProductSort sets the ContainerProductSort field's value.
func (s *EntityTypeSort) SetContainerProductSort(v *ContainerProductSort) *EntityTypeSort {
	s.ContainerProductSort = v
	return s
}

// SetDataProductSort sets the DataProductSort field's value.
func (s *EntityTypeSort) SetDataProductSort(v *DataProductSort) *EntityTypeSort {
	s.DataProductSort = v
	return s
}

// SetOfferSort sets the OfferSort field's value.
func (s *EntityTypeSort) SetOfferSort(v *OfferSort) *EntityTypeSort {
	s.OfferSort = v
	return s
}

// SetResaleAuthorizationSort sets the ResaleAuthorizationSort field's value.
func (s *EntityTypeSort) SetResaleAuthorizationSort(v *ResaleAuthorizationSort) *EntityTypeSort {
	s.ResaleAuthorizationSort = v
	return s
}

// SetSaaSProductSort sets the SaaSProductSort field's value.
func (s *EntityTypeSort) SetSaaSProductSort(v *SaaSProductSort) *EntityTypeSort {
	s.SaaSProductSort = v
	return s
}

// Details about the error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code that identifies the type of error.
	ErrorCode *string `min:"1" type:"string"`

	// The message for the error.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// A filter object, used to optionally filter results from calls to the ListEntities
// and ListChangeSets actions.
type Filter struct {
	_ struct{} `type:"structure"`

	// For ListEntities, the supported value for this is an EntityId.
	//
	// For ListChangeSets, the supported values are as follows:
	Name *string `min:"1" type:"string"`

	// ListEntities - This is a list of unique EntityIds.
	//
	// ListChangeSets - The supported filter names and associated ValueLists is
	// as follows:
	//
	//    * ChangeSetName - The supported ValueList is a list of non-unique ChangeSetNames.
	//    These are defined when you call the StartChangeSet action.
	//
	//    * Status - The supported ValueList is a list of statuses for all change
	//    set requests.
	//
	//    * EntityId - The supported ValueList is a list of unique EntityIds.
	//
	//    * BeforeStartTime - The supported ValueList is a list of all change sets
	//    that started before the filter value.
	//
	//    * AfterStartTime - The supported ValueList is a list of all change sets
	//    that started after the filter value.
	//
	//    * BeforeEndTime - The supported ValueList is a list of all change sets
	//    that ended before the filter value.
	//
	//    * AfterEndTime - The supported ValueList is a list of all change sets
	//    that ended after the filter value.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValueList sets the ValueList field's value.
func (s *Filter) SetValueList(v []*string) *Filter {
	s.ValueList = v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the entity resource that is associated
	// with the resource policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePolicyInput) SetResourceArn(v string) *GetResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document to set; formatted in JSON.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v string) *GetResourcePolicyOutput {
	s.Policy = &v
	return s
}

// There was an internal service exception.
//
// HTTP status code: 500
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// An array of filter objects.
	FilterList []*Filter `min:"1" type:"list"`

	// The maximum number of results returned by a single call. This value must
	// be provided in the next call to retrieve the next set of results. By default,
	// this value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `min:"1" type:"string"`

	// An object that contains two attributes, SortBy and SortOrder.
	Sort *Sort `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.FilterList != nil && len(s.FilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.FilterList != nil {
		for i, v := range s.FilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *ListChangeSetsInput) SetCatalog(v string) *ListChangeSetsInput {
	s.Catalog = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *ListChangeSetsInput) SetFilterList(v []*Filter) *ListChangeSetsInput {
	s.FilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChangeSetsInput) SetMaxResults(v int64) *ListChangeSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsInput) SetNextToken(v string) *ListChangeSetsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListChangeSetsInput) SetSort(v *Sort) *ListChangeSetsInput {
	s.Sort = v
	return s
}

type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// Array of ChangeSetSummaryListItem objects.
	ChangeSetSummaryList []*ChangeSetSummaryListItem `type:"list"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SetChangeSetSummaryList sets the ChangeSetSummaryList field's value.
func (s *ListChangeSetsOutput) SetChangeSetSummaryList(v []*ChangeSetSummaryListItem) *ListChangeSetsOutput {
	s.ChangeSetSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsOutput) SetNextToken(v string) *ListChangeSetsOutput {
	s.NextToken = &v
	return s
}

type ListEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// The type of entities to retrieve. Valid values are: AmiProduct, ContainerProduct,
	// DataProduct, SaaSProduct, ProcurementPolicy, Experience, Audience, BrandingSettings,
	// Offer, Seller, ResaleAuthorization.
	//
	// EntityType is a required field
	EntityType *string `min:"1" type:"string" required:"true"`

	// A Union object containing filter shapes for all EntityTypes. Each EntityTypeFilter
	// shape will have filters applicable for that EntityType that can be used to
	// search or filter entities.
	EntityTypeFilters *EntityTypeFilters `type:"structure"`

	// A Union object containing Sort shapes for all EntityTypes. Each EntityTypeSort
	// shape will have SortBy and SortOrder applicable for fields on that EntityType.
	// This can be used to sort the results of the filter query.
	EntityTypeSort *EntityTypeSort `type:"structure"`

	// An array of filter objects. Each filter object contains two attributes, filterName
	// and filterValues.
	FilterList []*Filter `min:"1" type:"list"`

	// Specifies the upper limit of the elements on a single page. If a value isn't
	// provided, the default value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `min:"1" type:"string"`

	// Filters the returned set of entities based on their owner. The default is
	// SELF. To list entities shared with you through AWS Resource Access Manager
	// (AWS RAM), set to SHARED. Entities shared through the AWS Marketplace Catalog
	// API PutResourcePolicy operation can't be discovered through the SHARED parameter.
	OwnershipType *string `type:"string" enum:"OwnershipType"`

	// An object that contains two attributes, SortBy and SortOrder.
	Sort *Sort `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}
	if s.EntityType != nil && len(*s.EntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityType", 1))
	}
	if s.FilterList != nil && len(s.FilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.EntityTypeFilters != nil {
		if err := s.EntityTypeFilters.Validate(); err != nil {
			invalidParams.AddNested("EntityTypeFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.FilterList != nil {
		for i, v := range s.FilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *ListEntitiesInput) SetCatalog(v string) *ListEntitiesInput {
	s.Catalog = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *ListEntitiesInput) SetEntityType(v string) *ListEntitiesInput {
	s.EntityType = &v
	return s
}

// SetEntityTypeFilters sets the EntityTypeFilters field's value.
func (s *ListEntitiesInput) SetEntityTypeFilters(v *EntityTypeFilters) *ListEntitiesInput {
	s.EntityTypeFilters = v
	return s
}

// SetEntityTypeSort sets the EntityTypeSort field's value.
func (s *ListEntitiesInput) SetEntityTypeSort(v *EntityTypeSort) *ListEntitiesInput {
	s.EntityTypeSort = v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *ListEntitiesInput) SetFilterList(v []*Filter) *ListEntitiesInput {
	s.FilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesInput) SetMaxResults(v int64) *ListEntitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesInput) SetNextToken(v string) *ListEntitiesInput {
	s.NextToken = &v
	return s
}

// SetOwnershipType sets the OwnershipType field's value.
func (s *ListEntitiesInput) SetOwnershipType(v string) *ListEntitiesInput {
	s.OwnershipType = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListEntitiesInput) SetSort(v *Sort) *ListEntitiesInput {
	s.Sort = v
	return s
}

type ListEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// Array of EntitySummary objects.
	EntitySummaryList []*EntitySummary `type:"list"`

	// The value of the next token if it exists. Null if there is no more result.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntitySummaryList sets the EntitySummaryList field's value.
func (s *ListEntitiesOutput) SetEntitySummaryList(v []*EntitySummary) *ListEntitiesOutput {
	s.EntitySummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesOutput) SetNextToken(v string) *ListEntitiesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Required. The Amazon Resource Name (ARN) associated with the resource you
	// want to list tags on.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Required. The ARN associated with the resource you want to list tags on.
	ResourceArn *string `min:"1" type:"string"`

	// Required. A list of objects specifying each key name and value. Number of
	// objects allowed: 1-50.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Allows filtering on the AvailabilityEndDate of an offer.
type OfferAvailabilityEndDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the AvailabilityEndDate of an offer with date range as
	// input.
	DateRange *OfferAvailabilityEndDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferAvailabilityEndDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferAvailabilityEndDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferAvailabilityEndDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferAvailabilityEndDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *OfferAvailabilityEndDateFilter) SetDateRange(v *OfferAvailabilityEndDateFilterDateRange) *OfferAvailabilityEndDateFilter {
	s.DateRange = v
	return s
}

// Allows filtering on the AvailabilityEndDate of an offer with date range as
// input.
type OfferAvailabilityEndDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the AvailabilityEndDate of an offer after a date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on the AvailabilityEndDate of an offer before a date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferAvailabilityEndDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferAvailabilityEndDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferAvailabilityEndDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferAvailabilityEndDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *OfferAvailabilityEndDateFilterDateRange) SetAfterValue(v string) *OfferAvailabilityEndDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *OfferAvailabilityEndDateFilterDateRange) SetBeforeValue(v string) *OfferAvailabilityEndDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows filtering on the BuyerAccounts of an offer.
type OfferBuyerAccountsFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the BuyerAccounts of an offer with wild card input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferBuyerAccountsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferBuyerAccountsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferBuyerAccountsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferBuyerAccountsFilter"}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *OfferBuyerAccountsFilter) SetWildCardValue(v string) *OfferBuyerAccountsFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the entity id of an offer.
type OfferEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on entity id of an offer with list input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *OfferEntityIdFilter) SetValueList(v []*string) *OfferEntityIdFilter {
	s.ValueList = v
	return s
}

// A filter for offers entity.
type OfferFilters struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the AvailabilityEndDate of an offer.
	AvailabilityEndDate *OfferAvailabilityEndDateFilter `type:"structure"`

	// Allows filtering on the BuyerAccounts of an offer.
	BuyerAccounts *OfferBuyerAccountsFilter `type:"structure"`

	// Allows filtering on EntityId of an offer.
	EntityId *OfferEntityIdFilter `type:"structure"`

	// Allows filtering on the LastModifiedDate of an offer.
	LastModifiedDate *OfferLastModifiedDateFilter `type:"structure"`

	// Allows filtering on the Name of an offer.
	Name *OfferNameFilter `type:"structure"`

	// Allows filtering on the ProductId of an offer.
	ProductId *OfferProductIdFilter `type:"structure"`

	// Allows filtering on the ReleaseDate of an offer.
	ReleaseDate *OfferReleaseDateFilter `type:"structure"`

	// Allows filtering on the State of an offer.
	State *OfferStateFilter `type:"structure"`

	// Allows filtering on the Targeting of an offer.
	Targeting *OfferTargetingFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferFilters"}
	if s.AvailabilityEndDate != nil {
		if err := s.AvailabilityEndDate.Validate(); err != nil {
			invalidParams.AddNested("AvailabilityEndDate", err.(request.ErrInvalidParams))
		}
	}
	if s.BuyerAccounts != nil {
		if err := s.BuyerAccounts.Validate(); err != nil {
			invalidParams.AddNested("BuyerAccounts", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.Name != nil {
		if err := s.Name.Validate(); err != nil {
			invalidParams.AddNested("Name", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductId != nil {
		if err := s.ProductId.Validate(); err != nil {
			invalidParams.AddNested("ProductId", err.(request.ErrInvalidParams))
		}
	}
	if s.ReleaseDate != nil {
		if err := s.ReleaseDate.Validate(); err != nil {
			invalidParams.AddNested("ReleaseDate", err.(request.ErrInvalidParams))
		}
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(request.ErrInvalidParams))
		}
	}
	if s.Targeting != nil {
		if err := s.Targeting.Validate(); err != nil {
			invalidParams.AddNested("Targeting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityEndDate sets the AvailabilityEndDate field's value.
func (s *OfferFilters) SetAvailabilityEndDate(v *OfferAvailabilityEndDateFilter) *OfferFilters {
	s.AvailabilityEndDate = v
	return s
}

// SetBuyerAccounts sets the BuyerAccounts field's value.
func (s *OfferFilters) SetBuyerAccounts(v *OfferBuyerAccountsFilter) *OfferFilters {
	s.BuyerAccounts = v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *OfferFilters) SetEntityId(v *OfferEntityIdFilter) *OfferFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *OfferFilters) SetLastModifiedDate(v *OfferLastModifiedDateFilter) *OfferFilters {
	s.LastModifiedDate = v
	return s
}

// SetName sets the Name field's value.
func (s *OfferFilters) SetName(v *OfferNameFilter) *OfferFilters {
	s.Name = v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *OfferFilters) SetProductId(v *OfferProductIdFilter) *OfferFilters {
	s.ProductId = v
	return s
}

// SetReleaseDate sets the ReleaseDate field's value.
func (s *OfferFilters) SetReleaseDate(v *OfferReleaseDateFilter) *OfferFilters {
	s.ReleaseDate = v
	return s
}

// SetState sets the State field's value.
func (s *OfferFilters) SetState(v *OfferStateFilter) *OfferFilters {
	s.State = v
	return s
}

// SetTargeting sets the Targeting field's value.
func (s *OfferFilters) SetTargeting(v *OfferTargetingFilter) *OfferFilters {
	s.Targeting = v
	return s
}

// Allows filtering on the LastModifiedDate of an offer.
type OfferLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the LastModifiedDate of an offer with date range as input.
	DateRange *OfferLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *OfferLastModifiedDateFilter) SetDateRange(v *OfferLastModifiedDateFilterDateRange) *OfferLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Allows filtering on the LastModifiedDate of an offer with date range as input.
type OfferLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the LastModifiedDate of an offer after a date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on the LastModifiedDate of an offer before a date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *OfferLastModifiedDateFilterDateRange) SetAfterValue(v string) *OfferLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *OfferLastModifiedDateFilterDateRange) SetBeforeValue(v string) *OfferLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows filtering on the Name of an offer.
type OfferNameFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the Name of an offer with list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the Name of an offer with wild card input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferNameFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferNameFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferNameFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferNameFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *OfferNameFilter) SetValueList(v []*string) *OfferNameFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *OfferNameFilter) SetWildCardValue(v string) *OfferNameFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the ProductId of an offer.
type OfferProductIdFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ProductId of an offer with list input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferProductIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferProductIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferProductIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferProductIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *OfferProductIdFilter) SetValueList(v []*string) *OfferProductIdFilter {
	s.ValueList = v
	return s
}

// Allows filtering on the ReleaseDate of an offer.
type OfferReleaseDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ReleaseDate of an offer with date range as input.
	DateRange *OfferReleaseDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferReleaseDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferReleaseDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferReleaseDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferReleaseDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *OfferReleaseDateFilter) SetDateRange(v *OfferReleaseDateFilterDateRange) *OfferReleaseDateFilter {
	s.DateRange = v
	return s
}

// Allows filtering on the ReleaseDate of an offer with date range as input.
type OfferReleaseDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ReleaseDate of offers after a date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on the ReleaseDate of offers before a date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferReleaseDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferReleaseDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferReleaseDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferReleaseDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *OfferReleaseDateFilterDateRange) SetAfterValue(v string) *OfferReleaseDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *OfferReleaseDateFilterDateRange) SetBeforeValue(v string) *OfferReleaseDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows to sort offers.
type OfferSort struct {
	_ struct{} `type:"structure"`

	// Allows to sort offers.
	SortBy *string `type:"string" enum:"OfferSortBy"`

	// Allows to sort offers.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *OfferSort) SetSortBy(v string) *OfferSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *OfferSort) SetSortOrder(v string) *OfferSort {
	s.SortOrder = &v
	return s
}

// Allows filtering on the State of an offer.
type OfferStateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the State of an offer with list input.
	ValueList []*string `min:"1" type:"list" enum:"OfferStateString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferStateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferStateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferStateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferStateFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *OfferStateFilter) SetValueList(v []*string) *OfferStateFilter {
	s.ValueList = v
	return s
}

// Summarized information about an offer.
type OfferSummary struct {
	_ struct{} `type:"structure"`

	// The availability end date of the offer.
	AvailabilityEndDate *string `min:"20" type:"string"`

	// The buyer accounts in the offer.
	BuyerAccounts []*string `type:"list"`

	// The name of the offer.
	Name *string `min:"1" type:"string"`

	// The product ID of the offer.
	ProductId *string `min:"1" type:"string"`

	// The release date of the offer.
	ReleaseDate *string `min:"20" type:"string"`

	// The status of the offer.
	State *string `type:"string" enum:"OfferStateString"`

	// The targeting in the offer.
	Targeting []*string `type:"list" enum:"OfferTargetingString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferSummary) GoString() string {
	return s.String()
}

// SetAvailabilityEndDate sets the AvailabilityEndDate field's value.
func (s *OfferSummary) SetAvailabilityEndDate(v string) *OfferSummary {
	s.AvailabilityEndDate = &v
	return s
}

// SetBuyerAccounts sets the BuyerAccounts field's value.
func (s *OfferSummary) SetBuyerAccounts(v []*string) *OfferSummary {
	s.BuyerAccounts = v
	return s
}

// SetName sets the Name field's value.
func (s *OfferSummary) SetName(v string) *OfferSummary {
	s.Name = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *OfferSummary) SetProductId(v string) *OfferSummary {
	s.ProductId = &v
	return s
}

// SetReleaseDate sets the ReleaseDate field's value.
func (s *OfferSummary) SetReleaseDate(v string) *OfferSummary {
	s.ReleaseDate = &v
	return s
}

// SetState sets the State field's value.
func (s *OfferSummary) SetState(v string) *OfferSummary {
	s.State = &v
	return s
}

// SetTargeting sets the Targeting field's value.
func (s *OfferSummary) SetTargeting(v []*string) *OfferSummary {
	s.Targeting = v
	return s
}

// Allows filtering on the Targeting of an offer.
type OfferTargetingFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the Targeting of an offer with list input.
	ValueList []*string `min:"1" type:"list" enum:"OfferTargetingString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferTargetingFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OfferTargetingFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OfferTargetingFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OfferTargetingFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *OfferTargetingFilter) SetValueList(v []*string) *OfferTargetingFilter {
	s.ValueList = v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy document to set; formatted in JSON.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the entity resource you want to associate
	// with a resource policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// Allows filtering on AvailabilityEndDate of a ResaleAuthorization.
type ResaleAuthorizationAvailabilityEndDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on AvailabilityEndDate of a ResaleAuthorization with date
	// range as input
	DateRange *ResaleAuthorizationAvailabilityEndDateFilterDateRange `type:"structure"`

	// Allows filtering on AvailabilityEndDate of a ResaleAuthorization with date
	// value as input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationAvailabilityEndDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationAvailabilityEndDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationAvailabilityEndDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationAvailabilityEndDateFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *ResaleAuthorizationAvailabilityEndDateFilter) SetDateRange(v *ResaleAuthorizationAvailabilityEndDateFilterDateRange) *ResaleAuthorizationAvailabilityEndDateFilter {
	s.DateRange = v
	return s
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationAvailabilityEndDateFilter) SetValueList(v []*string) *ResaleAuthorizationAvailabilityEndDateFilter {
	s.ValueList = v
	return s
}

// Allows filtering on AvailabilityEndDate of a ResaleAuthorization with date
// range as input.
type ResaleAuthorizationAvailabilityEndDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on AvailabilityEndDate of a ResaleAuthorization after a
	// date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on AvailabilityEndDate of a ResaleAuthorization before a
	// date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationAvailabilityEndDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationAvailabilityEndDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationAvailabilityEndDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationAvailabilityEndDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *ResaleAuthorizationAvailabilityEndDateFilterDateRange) SetAfterValue(v string) *ResaleAuthorizationAvailabilityEndDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *ResaleAuthorizationAvailabilityEndDateFilterDateRange) SetBeforeValue(v string) *ResaleAuthorizationAvailabilityEndDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows filtering on CreatedDate of a ResaleAuthorization.
type ResaleAuthorizationCreatedDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on CreatedDate of a ResaleAuthorization with date range
	// as input.
	DateRange *ResaleAuthorizationCreatedDateFilterDateRange `type:"structure"`

	// Allows filtering on CreatedDate of a ResaleAuthorization with date value
	// as input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationCreatedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationCreatedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationCreatedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationCreatedDateFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *ResaleAuthorizationCreatedDateFilter) SetDateRange(v *ResaleAuthorizationCreatedDateFilterDateRange) *ResaleAuthorizationCreatedDateFilter {
	s.DateRange = v
	return s
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationCreatedDateFilter) SetValueList(v []*string) *ResaleAuthorizationCreatedDateFilter {
	s.ValueList = v
	return s
}

// Allows filtering on CreatedDate of a ResaleAuthorization with date range
// as input.
type ResaleAuthorizationCreatedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on CreatedDate of a ResaleAuthorization after a date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on CreatedDate of a ResaleAuthorization before a date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationCreatedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationCreatedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationCreatedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationCreatedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *ResaleAuthorizationCreatedDateFilterDateRange) SetAfterValue(v string) *ResaleAuthorizationCreatedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *ResaleAuthorizationCreatedDateFilterDateRange) SetBeforeValue(v string) *ResaleAuthorizationCreatedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows filtering on EntityId of a ResaleAuthorization.
type ResaleAuthorizationEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on EntityId of a ResaleAuthorization with list input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationEntityIdFilter) SetValueList(v []*string) *ResaleAuthorizationEntityIdFilter {
	s.ValueList = v
	return s
}

// A filter for ResaleAuthorization entity.
type ResaleAuthorizationFilters struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the AvailabilityEndDate of a ResaleAuthorization.
	AvailabilityEndDate *ResaleAuthorizationAvailabilityEndDateFilter `type:"structure"`

	// Allows filtering on the CreatedDate of a ResaleAuthorization.
	CreatedDate *ResaleAuthorizationCreatedDateFilter `type:"structure"`

	// Allows filtering on the EntityId of a ResaleAuthorization.
	EntityId *ResaleAuthorizationEntityIdFilter `type:"structure"`

	// Allows filtering on the LastModifiedDate of a ResaleAuthorization.
	LastModifiedDate *ResaleAuthorizationLastModifiedDateFilter `type:"structure"`

	// Allows filtering on the ManufacturerAccountId of a ResaleAuthorization.
	ManufacturerAccountId *ResaleAuthorizationManufacturerAccountIdFilter `type:"structure"`

	// Allows filtering on the ManufacturerLegalName of a ResaleAuthorization.
	ManufacturerLegalName *ResaleAuthorizationManufacturerLegalNameFilter `type:"structure"`

	// Allows filtering on the Name of a ResaleAuthorization.
	Name *ResaleAuthorizationNameFilter `type:"structure"`

	// Allows filtering on the OfferExtendedStatus of a ResaleAuthorization.
	OfferExtendedStatus *ResaleAuthorizationOfferExtendedStatusFilter `type:"structure"`

	// Allows filtering on the ProductId of a ResaleAuthorization.
	ProductId *ResaleAuthorizationProductIdFilter `type:"structure"`

	// Allows filtering on the ProductName of a ResaleAuthorization.
	ProductName *ResaleAuthorizationProductNameFilter `type:"structure"`

	// Allows filtering on the ResellerAccountID of a ResaleAuthorization.
	ResellerAccountID *ResaleAuthorizationResellerAccountIDFilter `type:"structure"`

	// Allows filtering on the ResellerLegalName of a ResaleAuthorization.
	ResellerLegalName *ResaleAuthorizationResellerLegalNameFilter `type:"structure"`

	// Allows filtering on the Status of a ResaleAuthorization.
	Status *ResaleAuthorizationStatusFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationFilters"}
	if s.AvailabilityEndDate != nil {
		if err := s.AvailabilityEndDate.Validate(); err != nil {
			invalidParams.AddNested("AvailabilityEndDate", err.(request.ErrInvalidParams))
		}
	}
	if s.CreatedDate != nil {
		if err := s.CreatedDate.Validate(); err != nil {
			invalidParams.AddNested("CreatedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.ManufacturerAccountId != nil {
		if err := s.ManufacturerAccountId.Validate(); err != nil {
			invalidParams.AddNested("ManufacturerAccountId", err.(request.ErrInvalidParams))
		}
	}
	if s.ManufacturerLegalName != nil {
		if err := s.ManufacturerLegalName.Validate(); err != nil {
			invalidParams.AddNested("ManufacturerLegalName", err.(request.ErrInvalidParams))
		}
	}
	if s.Name != nil {
		if err := s.Name.Validate(); err != nil {
			invalidParams.AddNested("Name", err.(request.ErrInvalidParams))
		}
	}
	if s.OfferExtendedStatus != nil {
		if err := s.OfferExtendedStatus.Validate(); err != nil {
			invalidParams.AddNested("OfferExtendedStatus", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductId != nil {
		if err := s.ProductId.Validate(); err != nil {
			invalidParams.AddNested("ProductId", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductName != nil {
		if err := s.ProductName.Validate(); err != nil {
			invalidParams.AddNested("ProductName", err.(request.ErrInvalidParams))
		}
	}
	if s.ResellerAccountID != nil {
		if err := s.ResellerAccountID.Validate(); err != nil {
			invalidParams.AddNested("ResellerAccountID", err.(request.ErrInvalidParams))
		}
	}
	if s.ResellerLegalName != nil {
		if err := s.ResellerLegalName.Validate(); err != nil {
			invalidParams.AddNested("ResellerLegalName", err.(request.ErrInvalidParams))
		}
	}
	if s.Status != nil {
		if err := s.Status.Validate(); err != nil {
			invalidParams.AddNested("Status", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityEndDate sets the AvailabilityEndDate field's value.
func (s *ResaleAuthorizationFilters) SetAvailabilityEndDate(v *ResaleAuthorizationAvailabilityEndDateFilter) *ResaleAuthorizationFilters {
	s.AvailabilityEndDate = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ResaleAuthorizationFilters) SetCreatedDate(v *ResaleAuthorizationCreatedDateFilter) *ResaleAuthorizationFilters {
	s.CreatedDate = v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *ResaleAuthorizationFilters) SetEntityId(v *ResaleAuthorizationEntityIdFilter) *ResaleAuthorizationFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ResaleAuthorizationFilters) SetLastModifiedDate(v *ResaleAuthorizationLastModifiedDateFilter) *ResaleAuthorizationFilters {
	s.LastModifiedDate = v
	return s
}

// SetManufacturerAccountId sets the ManufacturerAccountId field's value.
func (s *ResaleAuthorizationFilters) SetManufacturerAccountId(v *ResaleAuthorizationManufacturerAccountIdFilter) *ResaleAuthorizationFilters {
	s.ManufacturerAccountId = v
	return s
}

// SetManufacturerLegalName sets the ManufacturerLegalName field's value.
func (s *ResaleAuthorizationFilters) SetManufacturerLegalName(v *ResaleAuthorizationManufacturerLegalNameFilter) *ResaleAuthorizationFilters {
	s.ManufacturerLegalName = v
	return s
}

// SetName sets the Name field's value.
func (s *ResaleAuthorizationFilters) SetName(v *ResaleAuthorizationNameFilter) *ResaleAuthorizationFilters {
	s.Name = v
	return s
}

// SetOfferExtendedStatus sets the OfferExtendedStatus field's value.
func (s *ResaleAuthorizationFilters) SetOfferExtendedStatus(v *ResaleAuthorizationOfferExtendedStatusFilter) *ResaleAuthorizationFilters {
	s.OfferExtendedStatus = v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ResaleAuthorizationFilters) SetProductId(v *ResaleAuthorizationProductIdFilter) *ResaleAuthorizationFilters {
	s.ProductId = v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *ResaleAuthorizationFilters) SetProductName(v *ResaleAuthorizationProductNameFilter) *ResaleAuthorizationFilters {
	s.ProductName = v
	return s
}

// SetResellerAccountID sets the ResellerAccountID field's value.
func (s *ResaleAuthorizationFilters) SetResellerAccountID(v *ResaleAuthorizationResellerAccountIDFilter) *ResaleAuthorizationFilters {
	s.ResellerAccountID = v
	return s
}

// SetResellerLegalName sets the ResellerLegalName field's value.
func (s *ResaleAuthorizationFilters) SetResellerLegalName(v *ResaleAuthorizationResellerLegalNameFilter) *ResaleAuthorizationFilters {
	s.ResellerLegalName = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResaleAuthorizationFilters) SetStatus(v *ResaleAuthorizationStatusFilter) *ResaleAuthorizationFilters {
	s.Status = v
	return s
}

// Allows filtering on the LastModifiedDate of a ResaleAuthorization.
type ResaleAuthorizationLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the LastModifiedDate of a ResaleAuthorization with date
	// range as input.
	DateRange *ResaleAuthorizationLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *ResaleAuthorizationLastModifiedDateFilter) SetDateRange(v *ResaleAuthorizationLastModifiedDateFilterDateRange) *ResaleAuthorizationLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Allows filtering on the LastModifiedDate of a ResaleAuthorization with date
// range as input.
type ResaleAuthorizationLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the LastModifiedDate of a ResaleAuthorization after a
	// date.
	AfterValue *string `min:"20" type:"string"`

	// Allows filtering on the LastModifiedDate of a ResaleAuthorization before
	// a date.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *ResaleAuthorizationLastModifiedDateFilterDateRange) SetAfterValue(v string) *ResaleAuthorizationLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *ResaleAuthorizationLastModifiedDateFilterDateRange) SetBeforeValue(v string) *ResaleAuthorizationLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Allows filtering on the ManufacturerAccountId of a ResaleAuthorization.
type ResaleAuthorizationManufacturerAccountIdFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ManufacturerAccountId of a ResaleAuthorization with
	// list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ManufacturerAccountId of a ResaleAuthorization with
	// wild card input.
	WildCardValue *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationManufacturerAccountIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationManufacturerAccountIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationManufacturerAccountIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationManufacturerAccountIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationManufacturerAccountIdFilter) SetValueList(v []*string) *ResaleAuthorizationManufacturerAccountIdFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationManufacturerAccountIdFilter) SetWildCardValue(v string) *ResaleAuthorizationManufacturerAccountIdFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the ManufacturerLegalName of a ResaleAuthorization.
type ResaleAuthorizationManufacturerLegalNameFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ManufacturerLegalName of a ResaleAuthorization with
	// list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ManufacturerLegalName of a ResaleAuthorization with
	// wild card input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationManufacturerLegalNameFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationManufacturerLegalNameFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationManufacturerLegalNameFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationManufacturerLegalNameFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationManufacturerLegalNameFilter) SetValueList(v []*string) *ResaleAuthorizationManufacturerLegalNameFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationManufacturerLegalNameFilter) SetWildCardValue(v string) *ResaleAuthorizationManufacturerLegalNameFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the Name of a ResaleAuthorization.
type ResaleAuthorizationNameFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the Name of a ResaleAuthorization with list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the Name of a ResaleAuthorization with wild card input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationNameFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationNameFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationNameFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationNameFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationNameFilter) SetValueList(v []*string) *ResaleAuthorizationNameFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationNameFilter) SetWildCardValue(v string) *ResaleAuthorizationNameFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the OfferExtendedStatus of a ResaleAuthorization.
type ResaleAuthorizationOfferExtendedStatusFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the OfferExtendedStatus of a ResaleAuthorization with
	// list input.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationOfferExtendedStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationOfferExtendedStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationOfferExtendedStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationOfferExtendedStatusFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationOfferExtendedStatusFilter) SetValueList(v []*string) *ResaleAuthorizationOfferExtendedStatusFilter {
	s.ValueList = v
	return s
}

// Allows filtering on the ProductId of a ResaleAuthorization.
type ResaleAuthorizationProductIdFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ProductId of a ResaleAuthorization with list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ProductId of a ResaleAuthorization with wild card
	// input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationProductIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationProductIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationProductIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationProductIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationProductIdFilter) SetValueList(v []*string) *ResaleAuthorizationProductIdFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationProductIdFilter) SetWildCardValue(v string) *ResaleAuthorizationProductIdFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the ProductName of a ResaleAuthorization.
type ResaleAuthorizationProductNameFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ProductName of a ResaleAuthorization with list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ProductName of a ResaleAuthorization with wild card
	// input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationProductNameFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationProductNameFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationProductNameFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationProductNameFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationProductNameFilter) SetValueList(v []*string) *ResaleAuthorizationProductNameFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationProductNameFilter) SetWildCardValue(v string) *ResaleAuthorizationProductNameFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the ResellerAccountID of a ResaleAuthorization.
type ResaleAuthorizationResellerAccountIDFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ResellerAccountID of a ResaleAuthorization with list
	// input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ResellerAccountID of a ResaleAuthorization with wild
	// card input.
	WildCardValue *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationResellerAccountIDFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationResellerAccountIDFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationResellerAccountIDFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationResellerAccountIDFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationResellerAccountIDFilter) SetValueList(v []*string) *ResaleAuthorizationResellerAccountIDFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationResellerAccountIDFilter) SetWildCardValue(v string) *ResaleAuthorizationResellerAccountIDFilter {
	s.WildCardValue = &v
	return s
}

// Allows filtering on the ResellerLegalName of a ResaleAuthorization.
type ResaleAuthorizationResellerLegalNameFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the ResellerLegalNameProductName of a ResaleAuthorization
	// with list input.
	ValueList []*string `min:"1" type:"list"`

	// Allows filtering on the ResellerLegalName of a ResaleAuthorization with wild
	// card input.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationResellerLegalNameFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationResellerLegalNameFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationResellerLegalNameFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationResellerLegalNameFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationResellerLegalNameFilter) SetValueList(v []*string) *ResaleAuthorizationResellerLegalNameFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *ResaleAuthorizationResellerLegalNameFilter) SetWildCardValue(v string) *ResaleAuthorizationResellerLegalNameFilter {
	s.WildCardValue = &v
	return s
}

// Allows to sort ResaleAuthorization.
type ResaleAuthorizationSort struct {
	_ struct{} `type:"structure"`

	// Allows to sort ResaleAuthorization.
	SortBy *string `type:"string" enum:"ResaleAuthorizationSortBy"`

	// Allows to sort ResaleAuthorization.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *ResaleAuthorizationSort) SetSortBy(v string) *ResaleAuthorizationSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ResaleAuthorizationSort) SetSortOrder(v string) *ResaleAuthorizationSort {
	s.SortOrder = &v
	return s
}

// Allows filtering on the Status of a ResaleAuthorization.
type ResaleAuthorizationStatusFilter struct {
	_ struct{} `type:"structure"`

	// Allows filtering on the Status of a ResaleAuthorization with list input.
	ValueList []*string `min:"1" type:"list" enum:"ResaleAuthorizationStatusString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResaleAuthorizationStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResaleAuthorizationStatusFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *ResaleAuthorizationStatusFilter) SetValueList(v []*string) *ResaleAuthorizationStatusFilter {
	s.ValueList = v
	return s
}

// Summarized information about a Resale Authorization.
type ResaleAuthorizationSummary struct {
	_ struct{} `type:"structure"`

	// The availability end date of the ResaleAuthorization.
	AvailabilityEndDate *string `min:"20" type:"string"`

	// The created date of the ResaleAuthorization.
	CreatedDate *string `min:"20" type:"string"`

	// The manufacturer account ID of the ResaleAuthorization.
	ManufacturerAccountId *string `min:"12" type:"string"`

	// The manufacturer legal name of the ResaleAuthorization.
	ManufacturerLegalName *string `min:"1" type:"string"`

	// The name of the ResaleAuthorization.
	Name *string `min:"1" type:"string"`

	// The offer extended status of the ResaleAuthorization
	OfferExtendedStatus *string `min:"1" type:"string"`

	// The product ID of the ResaleAuthorization.
	ProductId *string `min:"1" type:"string"`

	// The product name of the ResaleAuthorization.
	ProductName *string `min:"1" type:"string"`

	// The reseller account ID of the ResaleAuthorization.
	ResellerAccountID *string `min:"12" type:"string"`

	// The reseller legal name of the ResaleAuthorization
	ResellerLegalName *string `min:"1" type:"string"`

	// The status of the ResaleAuthorization.
	Status *string `type:"string" enum:"ResaleAuthorizationStatusString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResaleAuthorizationSummary) GoString() string {
	return s.String()
}

// SetAvailabilityEndDate sets the AvailabilityEndDate field's value.
func (s *ResaleAuthorizationSummary) SetAvailabilityEndDate(v string) *ResaleAuthorizationSummary {
	s.AvailabilityEndDate = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ResaleAuthorizationSummary) SetCreatedDate(v string) *ResaleAuthorizationSummary {
	s.CreatedDate = &v
	return s
}

// SetManufacturerAccountId sets the ManufacturerAccountId field's value.
func (s *ResaleAuthorizationSummary) SetManufacturerAccountId(v string) *ResaleAuthorizationSummary {
	s.ManufacturerAccountId = &v
	return s
}

// SetManufacturerLegalName sets the ManufacturerLegalName field's value.
func (s *ResaleAuthorizationSummary) SetManufacturerLegalName(v string) *ResaleAuthorizationSummary {
	s.ManufacturerLegalName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResaleAuthorizationSummary) SetName(v string) *ResaleAuthorizationSummary {
	s.Name = &v
	return s
}

// SetOfferExtendedStatus sets the OfferExtendedStatus field's value.
func (s *ResaleAuthorizationSummary) SetOfferExtendedStatus(v string) *ResaleAuthorizationSummary {
	s.OfferExtendedStatus = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ResaleAuthorizationSummary) SetProductId(v string) *ResaleAuthorizationSummary {
	s.ProductId = &v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *ResaleAuthorizationSummary) SetProductName(v string) *ResaleAuthorizationSummary {
	s.ProductName = &v
	return s
}

// SetResellerAccountID sets the ResellerAccountID field's value.
func (s *ResaleAuthorizationSummary) SetResellerAccountID(v string) *ResaleAuthorizationSummary {
	s.ResellerAccountID = &v
	return s
}

// SetResellerLegalName sets the ResellerLegalName field's value.
func (s *ResaleAuthorizationSummary) SetResellerLegalName(v string) *ResaleAuthorizationSummary {
	s.ResellerLegalName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResaleAuthorizationSummary) SetStatus(v string) *ResaleAuthorizationSummary {
	s.Status = &v
	return s
}

// The resource is currently in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource wasn't found.
//
// HTTP status code: 404
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Currently, the specified resource is not supported.
type ResourceNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotSupportedException) GoString() string {
	return s.String()
}

func newErrorResourceNotSupportedException(v protocol.ResponseMetadata) error {
	return &ResourceNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotSupportedException) Code() string {
	return "ResourceNotSupportedException"
}

// Message returns the exception's message.
func (s *ResourceNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotSupportedException) OrigErr() error {
	return nil
}

func (s *ResourceNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object that allows filtering on entity id of a SaaS product.
type SaaSProductEntityIdFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique entity id values to be filtered on.
	ValueList []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductEntityIdFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductEntityIdFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductEntityIdFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductEntityIdFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *SaaSProductEntityIdFilter) SetValueList(v []*string) *SaaSProductEntityIdFilter {
	s.ValueList = v
	return s
}

// Object containing all the filter fields for SaaS products. Client can add
// a maximum of 8 filters in a single ListEntities request.
type SaaSProductFilters struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the SaaS product.
	EntityId *SaaSProductEntityIdFilter `type:"structure"`

	// The last date on which the SaaS product was modified.
	LastModifiedDate *SaaSProductLastModifiedDateFilter `type:"structure"`

	// The title of the SaaS product.
	ProductTitle *SaaSProductTitleFilter `type:"structure"`

	// The visibility of the SaaS product.
	Visibility *SaaSProductVisibilityFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductFilters"}
	if s.EntityId != nil {
		if err := s.EntityId.Validate(); err != nil {
			invalidParams.AddNested("EntityId", err.(request.ErrInvalidParams))
		}
	}
	if s.LastModifiedDate != nil {
		if err := s.LastModifiedDate.Validate(); err != nil {
			invalidParams.AddNested("LastModifiedDate", err.(request.ErrInvalidParams))
		}
	}
	if s.ProductTitle != nil {
		if err := s.ProductTitle.Validate(); err != nil {
			invalidParams.AddNested("ProductTitle", err.(request.ErrInvalidParams))
		}
	}
	if s.Visibility != nil {
		if err := s.Visibility.Validate(); err != nil {
			invalidParams.AddNested("Visibility", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *SaaSProductFilters) SetEntityId(v *SaaSProductEntityIdFilter) *SaaSProductFilters {
	s.EntityId = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SaaSProductFilters) SetLastModifiedDate(v *SaaSProductLastModifiedDateFilter) *SaaSProductFilters {
	s.LastModifiedDate = v
	return s
}

// SetProductTitle sets the ProductTitle field's value.
func (s *SaaSProductFilters) SetProductTitle(v *SaaSProductTitleFilter) *SaaSProductFilters {
	s.ProductTitle = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *SaaSProductFilters) SetVisibility(v *SaaSProductVisibilityFilter) *SaaSProductFilters {
	s.Visibility = v
	return s
}

// Object that allows filtering based on the last modified date of SaaS products
type SaaSProductLastModifiedDateFilter struct {
	_ struct{} `type:"structure"`

	// Dates between which the SaaS product was last modified.
	DateRange *SaaSProductLastModifiedDateFilterDateRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductLastModifiedDateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductLastModifiedDateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductLastModifiedDateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductLastModifiedDateFilter"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *SaaSProductLastModifiedDateFilter) SetDateRange(v *SaaSProductLastModifiedDateFilterDateRange) *SaaSProductLastModifiedDateFilter {
	s.DateRange = v
	return s
}

// Object that contains date range of the last modified date to be filtered
// on. You can optionally provide a BeforeValue and/or AfterValue. Both are
// inclusive.
type SaaSProductLastModifiedDateFilterDateRange struct {
	_ struct{} `type:"structure"`

	// Date after which the SaaS product was last modified.
	AfterValue *string `min:"20" type:"string"`

	// Date before which the SaaS product was last modified.
	BeforeValue *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductLastModifiedDateFilterDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductLastModifiedDateFilterDateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductLastModifiedDateFilterDateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductLastModifiedDateFilterDateRange"}
	if s.AfterValue != nil && len(*s.AfterValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AfterValue", 20))
	}
	if s.BeforeValue != nil && len(*s.BeforeValue) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BeforeValue", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterValue sets the AfterValue field's value.
func (s *SaaSProductLastModifiedDateFilterDateRange) SetAfterValue(v string) *SaaSProductLastModifiedDateFilterDateRange {
	s.AfterValue = &v
	return s
}

// SetBeforeValue sets the BeforeValue field's value.
func (s *SaaSProductLastModifiedDateFilterDateRange) SetBeforeValue(v string) *SaaSProductLastModifiedDateFilterDateRange {
	s.BeforeValue = &v
	return s
}

// Objects that allows sorting on SaaS products based on certain fields and
// sorting order.
type SaaSProductSort struct {
	_ struct{} `type:"structure"`

	// Field to sort the SaaS products by.
	SortBy *string `type:"string" enum:"SaaSProductSortBy"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *SaaSProductSort) SetSortBy(v string) *SaaSProductSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SaaSProductSort) SetSortOrder(v string) *SaaSProductSort {
	s.SortOrder = &v
	return s
}

// Object that contains summarized information about a SaaS product.
type SaaSProductSummary struct {
	_ struct{} `type:"structure"`

	// The title of the SaaS product.
	ProductTitle *string `min:"1" type:"string"`

	// The lifecycle of the SaaS product.
	Visibility *string `type:"string" enum:"SaaSProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductSummary) GoString() string {
	return s.String()
}

// SetProductTitle sets the ProductTitle field's value.
func (s *SaaSProductSummary) SetProductTitle(v string) *SaaSProductSummary {
	s.ProductTitle = &v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *SaaSProductSummary) SetVisibility(v string) *SaaSProductSummary {
	s.Visibility = &v
	return s
}

// Object that allows filtering on product title.
type SaaSProductTitleFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique product title values to be filtered on.
	ValueList []*string `min:"1" type:"list"`

	// A string that will be the wildCard input for product tile filter. It matches
	// the provided value as a substring in the actual value.
	WildCardValue *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductTitleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductTitleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductTitleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductTitleFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}
	if s.WildCardValue != nil && len(*s.WildCardValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WildCardValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *SaaSProductTitleFilter) SetValueList(v []*string) *SaaSProductTitleFilter {
	s.ValueList = v
	return s
}

// SetWildCardValue sets the WildCardValue field's value.
func (s *SaaSProductTitleFilter) SetWildCardValue(v string) *SaaSProductTitleFilter {
	s.WildCardValue = &v
	return s
}

// Object that allows filtering on the visibility of the product in the AWS
// Marketplace.
type SaaSProductVisibilityFilter struct {
	_ struct{} `type:"structure"`

	// A string array of unique visibility values to be filtered on.
	ValueList []*string `min:"1" type:"list" enum:"SaaSProductVisibilityString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductVisibilityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaaSProductVisibilityFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SaaSProductVisibilityFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SaaSProductVisibilityFilter"}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValueList sets the ValueList field's value.
func (s *SaaSProductVisibilityFilter) SetValueList(v []*string) *SaaSProductVisibilityFilter {
	s.ValueList = v
	return s
}

// The maximum number of open requests per account has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains two attributes, SortBy and SortOrder.
type Sort struct {
	_ struct{} `type:"structure"`

	// For ListEntities, supported attributes include LastModifiedDate (default)
	// and EntityId. In addition to LastModifiedDate and EntityId, each EntityType
	// might support additional fields.
	//
	// For ListChangeSets, supported attributes include StartTime and EndTime.
	SortBy *string `min:"1" type:"string"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSortBy sets the SortBy field's value.
func (s *Sort) SetSortBy(v string) *Sort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Sort) SetSortOrder(v string) *Sort {
	s.SortOrder = &v
	return s
}

type StartChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// Array of change object.
	//
	// ChangeSet is a required field
	ChangeSet []*Change `min:"1" type:"list" required:"true"`

	// Optional case sensitive string of up to 100 ASCII characters. The change
	// set name can be used to filter the list of change sets.
	ChangeSetName *string `min:"1" type:"string"`

	// A list of objects specifying each key name and value for the ChangeSetTags
	// property.
	ChangeSetTags []*Tag `min:"1" type:"list"`

	// A unique token to identify the request to ensure idempotency.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChangeSetInput"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.ChangeSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSet"))
	}
	if s.ChangeSet != nil && len(s.ChangeSet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSet", 1))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ChangeSetTags != nil && len(s.ChangeSetTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetTags", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ChangeSet != nil {
		for i, v := range s.ChangeSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChangeSet", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ChangeSetTags != nil {
		for i, v := range s.ChangeSetTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChangeSetTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *StartChangeSetInput) SetCatalog(v string) *StartChangeSetInput {
	s.Catalog = &v
	return s
}

// SetChangeSet sets the ChangeSet field's value.
func (s *StartChangeSetInput) SetChangeSet(v []*Change) *StartChangeSetInput {
	s.ChangeSet = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *StartChangeSetInput) SetChangeSetName(v string) *StartChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetChangeSetTags sets the ChangeSetTags field's value.
func (s *StartChangeSetInput) SetChangeSetTags(v []*Tag) *StartChangeSetInput {
	s.ChangeSetTags = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartChangeSetInput) SetClientRequestToken(v string) *StartChangeSetInput {
	s.ClientRequestToken = &v
	return s
}

type StartChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated to the unique identifier generated for the request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Unique identifier generated for the request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartChangeSetOutput) GoString() string {
	return s.String()
}

// SetChangeSetArn sets the ChangeSetArn field's value.
func (s *StartChangeSetOutput) SetChangeSetArn(v string) *StartChangeSetOutput {
	s.ChangeSetArn = &v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *StartChangeSetOutput) SetChangeSetId(v string) *StartChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// A list of objects specifying each key name and value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key associated with the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value associated with the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Required. The Amazon Resource Name (ARN) associated with the resource you
	// want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Required. A list of objects specifying each key name and value. Number of
	// objects allowed: 1-50.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Too many requests.
//
// HTTP status code: 429
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Required. The Amazon Resource Name (ARN) associated with the resource you
	// want to remove the tag from.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Required. A list of key names of tags to be removed. Number of strings allowed:
	// 0-256.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An error occurred during validation.
//
// HTTP status code: 422
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AmiProductSortByEntityId is a AmiProductSortBy enum value
	AmiProductSortByEntityId = "EntityId"

	// AmiProductSortByLastModifiedDate is a AmiProductSortBy enum value
	AmiProductSortByLastModifiedDate = "LastModifiedDate"

	// AmiProductSortByProductTitle is a AmiProductSortBy enum value
	AmiProductSortByProductTitle = "ProductTitle"

	// AmiProductSortByVisibility is a AmiProductSortBy enum value
	AmiProductSortByVisibility = "Visibility"
)

// AmiProductSortBy_Values returns all elements of the AmiProductSortBy enum
func AmiProductSortBy_Values() []string {
	return []string{
		AmiProductSortByEntityId,
		AmiProductSortByLastModifiedDate,
		AmiProductSortByProductTitle,
		AmiProductSortByVisibility,
	}
}

const (
	// AmiProductVisibilityStringLimited is a AmiProductVisibilityString enum value
	AmiProductVisibilityStringLimited = "Limited"

	// AmiProductVisibilityStringPublic is a AmiProductVisibilityString enum value
	AmiProductVisibilityStringPublic = "Public"

	// AmiProductVisibilityStringRestricted is a AmiProductVisibilityString enum value
	AmiProductVisibilityStringRestricted = "Restricted"

	// AmiProductVisibilityStringDraft is a AmiProductVisibilityString enum value
	AmiProductVisibilityStringDraft = "Draft"
)

// AmiProductVisibilityString_Values returns all elements of the AmiProductVisibilityString enum
func AmiProductVisibilityString_Values() []string {
	return []string{
		AmiProductVisibilityStringLimited,
		AmiProductVisibilityStringPublic,
		AmiProductVisibilityStringRestricted,
		AmiProductVisibilityStringDraft,
	}
}

const (
	// ChangeStatusPreparing is a ChangeStatus enum value
	ChangeStatusPreparing = "PREPARING"

	// ChangeStatusApplying is a ChangeStatus enum value
	ChangeStatusApplying = "APPLYING"

	// ChangeStatusSucceeded is a ChangeStatus enum value
	ChangeStatusSucceeded = "SUCCEEDED"

	// ChangeStatusCancelled is a ChangeStatus enum value
	ChangeStatusCancelled = "CANCELLED"

	// ChangeStatusFailed is a ChangeStatus enum value
	ChangeStatusFailed = "FAILED"
)

// ChangeStatus_Values returns all elements of the ChangeStatus enum
func ChangeStatus_Values() []string {
	return []string{
		ChangeStatusPreparing,
		ChangeStatusApplying,
		ChangeStatusSucceeded,
		ChangeStatusCancelled,
		ChangeStatusFailed,
	}
}

const (
	// ContainerProductSortByEntityId is a ContainerProductSortBy enum value
	ContainerProductSortByEntityId = "EntityId"

	// ContainerProductSortByLastModifiedDate is a ContainerProductSortBy enum value
	ContainerProductSortByLastModifiedDate = "LastModifiedDate"

	// ContainerProductSortByProductTitle is a ContainerProductSortBy enum value
	ContainerProductSortByProductTitle = "ProductTitle"

	// ContainerProductSortByVisibility is a ContainerProductSortBy enum value
	ContainerProductSortByVisibility = "Visibility"
)

// ContainerProductSortBy_Values returns all elements of the ContainerProductSortBy enum
func ContainerProductSortBy_Values() []string {
	return []string{
		ContainerProductSortByEntityId,
		ContainerProductSortByLastModifiedDate,
		ContainerProductSortByProductTitle,
		ContainerProductSortByVisibility,
	}
}

const (
	// ContainerProductVisibilityStringLimited is a ContainerProductVisibilityString enum value
	ContainerProductVisibilityStringLimited = "Limited"

	// ContainerProductVisibilityStringPublic is a ContainerProductVisibilityString enum value
	ContainerProductVisibilityStringPublic = "Public"

	// ContainerProductVisibilityStringRestricted is a ContainerProductVisibilityString enum value
	ContainerProductVisibilityStringRestricted = "Restricted"

	// ContainerProductVisibilityStringDraft is a ContainerProductVisibilityString enum value
	ContainerProductVisibilityStringDraft = "Draft"
)

// ContainerProductVisibilityString_Values returns all elements of the ContainerProductVisibilityString enum
func ContainerProductVisibilityString_Values() []string {
	return []string{
		ContainerProductVisibilityStringLimited,
		ContainerProductVisibilityStringPublic,
		ContainerProductVisibilityStringRestricted,
		ContainerProductVisibilityStringDraft,
	}
}

const (
	// DataProductSortByEntityId is a DataProductSortBy enum value
	DataProductSortByEntityId = "EntityId"

	// DataProductSortByProductTitle is a DataProductSortBy enum value
	DataProductSortByProductTitle = "ProductTitle"

	// DataProductSortByVisibility is a DataProductSortBy enum value
	DataProductSortByVisibility = "Visibility"

	// DataProductSortByLastModifiedDate is a DataProductSortBy enum value
	DataProductSortByLastModifiedDate = "LastModifiedDate"
)

// DataProductSortBy_Values returns all elements of the DataProductSortBy enum
func DataProductSortBy_Values() []string {
	return []string{
		DataProductSortByEntityId,
		DataProductSortByProductTitle,
		DataProductSortByVisibility,
		DataProductSortByLastModifiedDate,
	}
}

const (
	// DataProductVisibilityStringLimited is a DataProductVisibilityString enum value
	DataProductVisibilityStringLimited = "Limited"

	// DataProductVisibilityStringPublic is a DataProductVisibilityString enum value
	DataProductVisibilityStringPublic = "Public"

	// DataProductVisibilityStringRestricted is a DataProductVisibilityString enum value
	DataProductVisibilityStringRestricted = "Restricted"

	// DataProductVisibilityStringUnavailable is a DataProductVisibilityString enum value
	DataProductVisibilityStringUnavailable = "Unavailable"

	// DataProductVisibilityStringDraft is a DataProductVisibilityString enum value
	DataProductVisibilityStringDraft = "Draft"
)

// DataProductVisibilityString_Values returns all elements of the DataProductVisibilityString enum
func DataProductVisibilityString_Values() []string {
	return []string{
		DataProductVisibilityStringLimited,
		DataProductVisibilityStringPublic,
		DataProductVisibilityStringRestricted,
		DataProductVisibilityStringUnavailable,
		DataProductVisibilityStringDraft,
	}
}

const (
	// FailureCodeClientError is a FailureCode enum value
	FailureCodeClientError = "CLIENT_ERROR"

	// FailureCodeServerFault is a FailureCode enum value
	FailureCodeServerFault = "SERVER_FAULT"
)

// FailureCode_Values returns all elements of the FailureCode enum
func FailureCode_Values() []string {
	return []string{
		FailureCodeClientError,
		FailureCodeServerFault,
	}
}

const (
	// OfferSortByEntityId is a OfferSortBy enum value
	OfferSortByEntityId = "EntityId"

	// OfferSortByName is a OfferSortBy enum value
	OfferSortByName = "Name"

	// OfferSortByProductId is a OfferSortBy enum value
	OfferSortByProductId = "ProductId"

	// OfferSortByReleaseDate is a OfferSortBy enum value
	OfferSortByReleaseDate = "ReleaseDate"

	// OfferSortByAvailabilityEndDate is a OfferSortBy enum value
	OfferSortByAvailabilityEndDate = "AvailabilityEndDate"

	// OfferSortByBuyerAccounts is a OfferSortBy enum value
	OfferSortByBuyerAccounts = "BuyerAccounts"

	// OfferSortByState is a OfferSortBy enum value
	OfferSortByState = "State"

	// OfferSortByTargeting is a OfferSortBy enum value
	OfferSortByTargeting = "Targeting"

	// OfferSortByLastModifiedDate is a OfferSortBy enum value
	OfferSortByLastModifiedDate = "LastModifiedDate"
)

// OfferSortBy_Values returns all elements of the OfferSortBy enum
func OfferSortBy_Values() []string {
	return []string{
		OfferSortByEntityId,
		OfferSortByName,
		OfferSortByProductId,
		OfferSortByReleaseDate,
		OfferSortByAvailabilityEndDate,
		OfferSortByBuyerAccounts,
		OfferSortByState,
		OfferSortByTargeting,
		OfferSortByLastModifiedDate,
	}
}

const (
	// OfferStateStringDraft is a OfferStateString enum value
	OfferStateStringDraft = "Draft"

	// OfferStateStringReleased is a OfferStateString enum value
	OfferStateStringReleased = "Released"
)

// OfferStateString_Values returns all elements of the OfferStateString enum
func OfferStateString_Values() []string {
	return []string{
		OfferStateStringDraft,
		OfferStateStringReleased,
	}
}

const (
	// OfferTargetingStringBuyerAccounts is a OfferTargetingString enum value
	OfferTargetingStringBuyerAccounts = "BuyerAccounts"

	// OfferTargetingStringParticipatingPrograms is a OfferTargetingString enum value
	OfferTargetingStringParticipatingPrograms = "ParticipatingPrograms"

	// OfferTargetingStringCountryCodes is a OfferTargetingString enum value
	OfferTargetingStringCountryCodes = "CountryCodes"

	// OfferTargetingStringNone is a OfferTargetingString enum value
	OfferTargetingStringNone = "None"
)

// OfferTargetingString_Values returns all elements of the OfferTargetingString enum
func OfferTargetingString_Values() []string {
	return []string{
		OfferTargetingStringBuyerAccounts,
		OfferTargetingStringParticipatingPrograms,
		OfferTargetingStringCountryCodes,
		OfferTargetingStringNone,
	}
}

const (
	// OwnershipTypeSelf is a OwnershipType enum value
	OwnershipTypeSelf = "SELF"

	// OwnershipTypeShared is a OwnershipType enum value
	OwnershipTypeShared = "SHARED"
)

// OwnershipType_Values returns all elements of the OwnershipType enum
func OwnershipType_Values() []string {
	return []string{
		OwnershipTypeSelf,
		OwnershipTypeShared,
	}
}

const (
	// ResaleAuthorizationSortByEntityId is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByEntityId = "EntityId"

	// ResaleAuthorizationSortByName is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByName = "Name"

	// ResaleAuthorizationSortByProductId is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByProductId = "ProductId"

	// ResaleAuthorizationSortByProductName is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByProductName = "ProductName"

	// ResaleAuthorizationSortByManufacturerAccountId is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByManufacturerAccountId = "ManufacturerAccountId"

	// ResaleAuthorizationSortByManufacturerLegalName is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByManufacturerLegalName = "ManufacturerLegalName"

	// ResaleAuthorizationSortByResellerAccountId is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByResellerAccountId = "ResellerAccountID"

	// ResaleAuthorizationSortByResellerLegalName is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByResellerLegalName = "ResellerLegalName"

	// ResaleAuthorizationSortByStatus is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByStatus = "Status"

	// ResaleAuthorizationSortByOfferExtendedStatus is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByOfferExtendedStatus = "OfferExtendedStatus"

	// ResaleAuthorizationSortByCreatedDate is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByCreatedDate = "CreatedDate"

	// ResaleAuthorizationSortByAvailabilityEndDate is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByAvailabilityEndDate = "AvailabilityEndDate"

	// ResaleAuthorizationSortByLastModifiedDate is a ResaleAuthorizationSortBy enum value
	ResaleAuthorizationSortByLastModifiedDate = "LastModifiedDate"
)

// ResaleAuthorizationSortBy_Values returns all elements of the ResaleAuthorizationSortBy enum
func ResaleAuthorizationSortBy_Values() []string {
	return []string{
		ResaleAuthorizationSortByEntityId,
		ResaleAuthorizationSortByName,
		ResaleAuthorizationSortByProductId,
		ResaleAuthorizationSortByProductName,
		ResaleAuthorizationSortByManufacturerAccountId,
		ResaleAuthorizationSortByManufacturerLegalName,
		ResaleAuthorizationSortByResellerAccountId,
		ResaleAuthorizationSortByResellerLegalName,
		ResaleAuthorizationSortByStatus,
		ResaleAuthorizationSortByOfferExtendedStatus,
		ResaleAuthorizationSortByCreatedDate,
		ResaleAuthorizationSortByAvailabilityEndDate,
		ResaleAuthorizationSortByLastModifiedDate,
	}
}

const (
	// ResaleAuthorizationStatusStringDraft is a ResaleAuthorizationStatusString enum value
	ResaleAuthorizationStatusStringDraft = "Draft"

	// ResaleAuthorizationStatusStringActive is a ResaleAuthorizationStatusString enum value
	ResaleAuthorizationStatusStringActive = "Active"

	// ResaleAuthorizationStatusStringRestricted is a ResaleAuthorizationStatusString enum value
	ResaleAuthorizationStatusStringRestricted = "Restricted"
)

// ResaleAuthorizationStatusString_Values returns all elements of the ResaleAuthorizationStatusString enum
func ResaleAuthorizationStatusString_Values() []string {
	return []string{
		ResaleAuthorizationStatusStringDraft,
		ResaleAuthorizationStatusStringActive,
		ResaleAuthorizationStatusStringRestricted,
	}
}

const (
	// SaaSProductSortByEntityId is a SaaSProductSortBy enum value
	SaaSProductSortByEntityId = "EntityId"

	// SaaSProductSortByProductTitle is a SaaSProductSortBy enum value
	SaaSProductSortByProductTitle = "ProductTitle"

	// SaaSProductSortByVisibility is a SaaSProductSortBy enum value
	SaaSProductSortByVisibility = "Visibility"

	// SaaSProductSortByLastModifiedDate is a SaaSProductSortBy enum value
	SaaSProductSortByLastModifiedDate = "LastModifiedDate"
)

// SaaSProductSortBy_Values returns all elements of the SaaSProductSortBy enum
func SaaSProductSortBy_Values() []string {
	return []string{
		SaaSProductSortByEntityId,
		SaaSProductSortByProductTitle,
		SaaSProductSortByVisibility,
		SaaSProductSortByLastModifiedDate,
	}
}

const (
	// SaaSProductVisibilityStringLimited is a SaaSProductVisibilityString enum value
	SaaSProductVisibilityStringLimited = "Limited"

	// SaaSProductVisibilityStringPublic is a SaaSProductVisibilityString enum value
	SaaSProductVisibilityStringPublic = "Public"

	// SaaSProductVisibilityStringRestricted is a SaaSProductVisibilityString enum value
	SaaSProductVisibilityStringRestricted = "Restricted"

	// SaaSProductVisibilityStringDraft is a SaaSProductVisibilityString enum value
	SaaSProductVisibilityStringDraft = "Draft"
)

// SaaSProductVisibilityString_Values returns all elements of the SaaSProductVisibilityString enum
func SaaSProductVisibilityString_Values() []string {
	return []string{
		SaaSProductVisibilityStringLimited,
		SaaSProductVisibilityStringPublic,
		SaaSProductVisibilityStringRestricted,
		SaaSProductVisibilityStringDraft,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
