// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplaceagreement

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDescribeAgreement = "DescribeAgreement"

// DescribeAgreementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgreement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgreement for more information on using the DescribeAgreement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAgreementRequest method.
//	req, resp := client.DescribeAgreementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/DescribeAgreement
func (c *MarketplaceAgreement) DescribeAgreementRequest(input *DescribeAgreementInput) (req *request.Request, output *DescribeAgreementOutput) {
	op := &request.Operation{
		Name:       opDescribeAgreement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgreementInput{}
	}

	output = &DescribeAgreementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgreement API operation for AWS Marketplace Agreement Service.
//
// Provides details about an agreement, such as the proposer, acceptor, start
// date, and end date.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Agreement Service's
// API operation DescribeAgreement for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/DescribeAgreement
func (c *MarketplaceAgreement) DescribeAgreement(input *DescribeAgreementInput) (*DescribeAgreementOutput, error) {
	req, out := c.DescribeAgreementRequest(input)
	return out, req.Send()
}

// DescribeAgreementWithContext is the same as DescribeAgreement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgreement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceAgreement) DescribeAgreementWithContext(ctx aws.Context, input *DescribeAgreementInput, opts ...request.Option) (*DescribeAgreementOutput, error) {
	req, out := c.DescribeAgreementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgreementTerms = "GetAgreementTerms"

// GetAgreementTermsRequest generates a "aws/request.Request" representing the
// client's request for the GetAgreementTerms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgreementTerms for more information on using the GetAgreementTerms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgreementTermsRequest method.
//	req, resp := client.GetAgreementTermsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/GetAgreementTerms
func (c *MarketplaceAgreement) GetAgreementTermsRequest(input *GetAgreementTermsInput) (req *request.Request, output *GetAgreementTermsOutput) {
	op := &request.Operation{
		Name:       opGetAgreementTerms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAgreementTermsInput{}
	}

	output = &GetAgreementTermsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgreementTerms API operation for AWS Marketplace Agreement Service.
//
// Obtains details about the terms in an agreement that you participated in
// as proposer or acceptor.
//
// The details include:
//
//   - TermType – The type of term, such as LegalTerm, RenewalTerm, or ConfigurableUpfrontPricingTerm.
//
//   - TermID – The ID of the particular term, which is common between offer
//     and agreement.
//
//   - TermPayload – The key information contained in the term, such as the
//     EULA for LegalTerm or pricing and dimensions for various pricing terms,
//     such as ConfigurableUpfrontPricingTerm or UsageBasedPricingTerm.
//
//   - Configuration – The buyer/acceptor's selection at the time of agreement
//     creation, such as the number of units purchased for a dimension or setting
//     the EnableAutoRenew flag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Agreement Service's
// API operation GetAgreementTerms for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/GetAgreementTerms
func (c *MarketplaceAgreement) GetAgreementTerms(input *GetAgreementTermsInput) (*GetAgreementTermsOutput, error) {
	req, out := c.GetAgreementTermsRequest(input)
	return out, req.Send()
}

// GetAgreementTermsWithContext is the same as GetAgreementTerms with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgreementTerms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceAgreement) GetAgreementTermsWithContext(ctx aws.Context, input *GetAgreementTermsInput, opts ...request.Option) (*GetAgreementTermsOutput, error) {
	req, out := c.GetAgreementTermsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAgreementTermsPages iterates over the pages of a GetAgreementTerms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAgreementTerms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetAgreementTerms operation.
//	pageNum := 0
//	err := client.GetAgreementTermsPages(params,
//	    func(page *marketplaceagreement.GetAgreementTermsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MarketplaceAgreement) GetAgreementTermsPages(input *GetAgreementTermsInput, fn func(*GetAgreementTermsOutput, bool) bool) error {
	return c.GetAgreementTermsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAgreementTermsPagesWithContext same as GetAgreementTermsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceAgreement) GetAgreementTermsPagesWithContext(ctx aws.Context, input *GetAgreementTermsInput, fn func(*GetAgreementTermsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAgreementTermsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAgreementTermsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAgreementTermsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchAgreements = "SearchAgreements"

// SearchAgreementsRequest generates a "aws/request.Request" representing the
// client's request for the SearchAgreements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAgreements for more information on using the SearchAgreements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAgreementsRequest method.
//	req, resp := client.SearchAgreementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/SearchAgreements
func (c *MarketplaceAgreement) SearchAgreementsRequest(input *SearchAgreementsInput) (req *request.Request, output *SearchAgreementsOutput) {
	op := &request.Operation{
		Name:       opSearchAgreements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAgreementsInput{}
	}

	output = &SearchAgreementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAgreements API operation for AWS Marketplace Agreement Service.
//
// Searches across all agreements that a proposer or an acceptor has in AWS
// Marketplace. The search returns a list of agreements with basic agreement
// information.
//
// The following filter combinations are supported:
//
//   - PartyType as Proposer + AgreementType + ResourceIdentifier
//
//   - PartyType as Proposer + AgreementType + OfferId
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId
//
//   - PartyType as Proposer + AgreementType + Status
//
//   - PartyType as Proposer + AgreementType + ResourceIdentifier + Status
//
//   - PartyType as Proposer + AgreementType + OfferId + Status
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + Status
//
//   - PartyType as Proposer + AgreementType + ResourceType + Status
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + ResourceType
//
//   - Status
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + OfferId
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + OfferId
//
//   - Status
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + ResourceIdentifier
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + ResourceIdentifier
//
//   - Status
//
//   - PartyType as Proposer + AgreementType + AcceptorAccountId + ResourceType
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Marketplace Agreement Service's
// API operation SearchAgreements for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/marketplace-agreement-2020-03-01/SearchAgreements
func (c *MarketplaceAgreement) SearchAgreements(input *SearchAgreementsInput) (*SearchAgreementsOutput, error) {
	req, out := c.SearchAgreementsRequest(input)
	return out, req.Send()
}

// SearchAgreementsWithContext is the same as SearchAgreements with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAgreements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceAgreement) SearchAgreementsWithContext(ctx aws.Context, input *SearchAgreementsInput, opts ...request.Option) (*SearchAgreementsOutput, error) {
	req, out := c.SearchAgreementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAgreementsPages iterates over the pages of a SearchAgreements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAgreements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAgreements operation.
//	pageNum := 0
//	err := client.SearchAgreementsPages(params,
//	    func(page *marketplaceagreement.SearchAgreementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MarketplaceAgreement) SearchAgreementsPages(input *SearchAgreementsInput, fn func(*SearchAgreementsOutput, bool) bool) error {
	return c.SearchAgreementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAgreementsPagesWithContext same as SearchAgreementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MarketplaceAgreement) SearchAgreementsPagesWithContext(ctx aws.Context, input *SearchAgreementsInput, fn func(*SearchAgreementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAgreementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAgreementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAgreementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// A subset of terms proposed by the proposer, which have been accepted by the
// acceptor as part of agreement creation.
type AcceptedTerm struct {
	_ struct{} `type:"structure"`

	// Enables you and your customers to move your existing agreements to AWS Marketplace.
	// The customer won't be charged for product usage in AWS Marketplace because
	// they already paid for the product outside of AWS Marketplace.
	ByolPricingTerm *ByolPricingTerm `locationName:"byolPricingTerm" type:"structure"`

	// Defines a prepaid payment model that allows buyers to configure the entitlements
	// they want to purchase and the duration.
	ConfigurableUpfrontPricingTerm *ConfigurableUpfrontPricingTerm `locationName:"configurableUpfrontPricingTerm" type:"structure"`

	// Defines a pre-paid pricing model where the customers are charged a fixed
	// upfront amount.
	FixedUpfrontPricingTerm *FixedUpfrontPricingTerm `locationName:"fixedUpfrontPricingTerm" type:"structure"`

	// Defines a short-term free pricing model where the buyers aren’t charged
	// anything within a specified limit.
	FreeTrialPricingTerm *FreeTrialPricingTerm `locationName:"freeTrialPricingTerm" type:"structure"`

	// Defines the list of text agreements proposed to the acceptors. An example
	// is the end user license agreement (EULA).
	LegalTerm *LegalTerm `locationName:"legalTerm" type:"structure"`

	// Defines an installment-based pricing model where customers are charged a
	// fixed price on different dates during the agreement validity period. This
	// is used most commonly for flexible payment schedule pricing.
	PaymentScheduleTerm *PaymentScheduleTerm `locationName:"paymentScheduleTerm" type:"structure"`

	// Defines a pricing model where customers are charged a fixed recurring price
	// at the end of each billing period.
	RecurringPaymentTerm *RecurringPaymentTerm `locationName:"recurringPaymentTerm" type:"structure"`

	// Defines that on graceful expiration of the agreement (when the agreement
	// ends on its pre-defined end date), a new agreement will be created using
	// the accepted terms on the existing agreement. In other words, the agreement
	// will be renewed. Presence of RenewalTerm in the offer document means that
	// auto-renewal is allowed. Buyers will have the option to accept or decline
	// auto-renewal at the offer acceptance/agreement creation. Buyers can also
	// change this flag from True to False or False to True at anytime during the
	// agreement's lifecycle.
	RenewalTerm *RenewalTerm `locationName:"renewalTerm" type:"structure"`

	// Defines the customer support available for the acceptors when they purchase
	// the software.
	SupportTerm *SupportTerm `locationName:"supportTerm" type:"structure"`

	// Defines a usage-based pricing model (typically, pay-as-you-go pricing), where
	// the customers are charged based on product usage.
	UsageBasedPricingTerm *UsageBasedPricingTerm `locationName:"usageBasedPricingTerm" type:"structure"`

	// Defines the conditions that will keep an agreement created from this offer
	// valid.
	ValidityTerm *ValidityTerm `locationName:"validityTerm" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptedTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptedTerm) GoString() string {
	return s.String()
}

// SetByolPricingTerm sets the ByolPricingTerm field's value.
func (s *AcceptedTerm) SetByolPricingTerm(v *ByolPricingTerm) *AcceptedTerm {
	s.ByolPricingTerm = v
	return s
}

// SetConfigurableUpfrontPricingTerm sets the ConfigurableUpfrontPricingTerm field's value.
func (s *AcceptedTerm) SetConfigurableUpfrontPricingTerm(v *ConfigurableUpfrontPricingTerm) *AcceptedTerm {
	s.ConfigurableUpfrontPricingTerm = v
	return s
}

// SetFixedUpfrontPricingTerm sets the FixedUpfrontPricingTerm field's value.
func (s *AcceptedTerm) SetFixedUpfrontPricingTerm(v *FixedUpfrontPricingTerm) *AcceptedTerm {
	s.FixedUpfrontPricingTerm = v
	return s
}

// SetFreeTrialPricingTerm sets the FreeTrialPricingTerm field's value.
func (s *AcceptedTerm) SetFreeTrialPricingTerm(v *FreeTrialPricingTerm) *AcceptedTerm {
	s.FreeTrialPricingTerm = v
	return s
}

// SetLegalTerm sets the LegalTerm field's value.
func (s *AcceptedTerm) SetLegalTerm(v *LegalTerm) *AcceptedTerm {
	s.LegalTerm = v
	return s
}

// SetPaymentScheduleTerm sets the PaymentScheduleTerm field's value.
func (s *AcceptedTerm) SetPaymentScheduleTerm(v *PaymentScheduleTerm) *AcceptedTerm {
	s.PaymentScheduleTerm = v
	return s
}

// SetRecurringPaymentTerm sets the RecurringPaymentTerm field's value.
func (s *AcceptedTerm) SetRecurringPaymentTerm(v *RecurringPaymentTerm) *AcceptedTerm {
	s.RecurringPaymentTerm = v
	return s
}

// SetRenewalTerm sets the RenewalTerm field's value.
func (s *AcceptedTerm) SetRenewalTerm(v *RenewalTerm) *AcceptedTerm {
	s.RenewalTerm = v
	return s
}

// SetSupportTerm sets the SupportTerm field's value.
func (s *AcceptedTerm) SetSupportTerm(v *SupportTerm) *AcceptedTerm {
	s.SupportTerm = v
	return s
}

// SetUsageBasedPricingTerm sets the UsageBasedPricingTerm field's value.
func (s *AcceptedTerm) SetUsageBasedPricingTerm(v *UsageBasedPricingTerm) *AcceptedTerm {
	s.UsageBasedPricingTerm = v
	return s
}

// SetValidityTerm sets the ValidityTerm field's value.
func (s *AcceptedTerm) SetValidityTerm(v *ValidityTerm) *AcceptedTerm {
	s.ValidityTerm = v
	return s
}

// The details of the party accepting the agreement terms. This is commonly
// the buyer for PurchaseAgreement.
type Acceptor struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the acceptor.
	AccountId *string `locationName:"accountId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Acceptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Acceptor) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Acceptor) SetAccountId(v string) *Acceptor {
	s.AccountId = &v
	return s
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The unique identifier for the error.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary of the agreement, including top-level attributes (for example,
// the agreement ID, version, proposer, and acceptor).
type AgreementViewSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the agreement was accepted.
	AcceptanceTime *time.Time `locationName:"acceptanceTime" type:"timestamp"`

	// Details of the party accepting the agreement terms. This is commonly the
	// buyer for PurchaseAgreement.
	Acceptor *Acceptor `locationName:"acceptor" type:"structure"`

	// The unique identifier of the agreement.
	AgreementId *string `locationName:"agreementId" min:"1" type:"string"`

	// The type of agreement. Values are PurchaseAgreement or VendorInsightsAgreement.
	AgreementType *string `locationName:"agreementType" min:"1" type:"string"`

	// The date and time when the agreement ends. The field is null for pay-as-you-go
	// agreements, which don’t have end dates.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// A summary of the proposal
	ProposalSummary *ProposalSummary `locationName:"proposalSummary" type:"structure"`

	// Details of the party proposing the agreement terms, most commonly the seller
	// for PurchaseAgreement.
	Proposer *Proposer `locationName:"proposer" type:"structure"`

	// The date and time when the agreement starts.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The current status of the agreement.
	Status *string `locationName:"status" type:"string" enum:"AgreementStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgreementViewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgreementViewSummary) GoString() string {
	return s.String()
}

// SetAcceptanceTime sets the AcceptanceTime field's value.
func (s *AgreementViewSummary) SetAcceptanceTime(v time.Time) *AgreementViewSummary {
	s.AcceptanceTime = &v
	return s
}

// SetAcceptor sets the Acceptor field's value.
func (s *AgreementViewSummary) SetAcceptor(v *Acceptor) *AgreementViewSummary {
	s.Acceptor = v
	return s
}

// SetAgreementId sets the AgreementId field's value.
func (s *AgreementViewSummary) SetAgreementId(v string) *AgreementViewSummary {
	s.AgreementId = &v
	return s
}

// SetAgreementType sets the AgreementType field's value.
func (s *AgreementViewSummary) SetAgreementType(v string) *AgreementViewSummary {
	s.AgreementType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AgreementViewSummary) SetEndTime(v time.Time) *AgreementViewSummary {
	s.EndTime = &v
	return s
}

// SetProposalSummary sets the ProposalSummary field's value.
func (s *AgreementViewSummary) SetProposalSummary(v *ProposalSummary) *AgreementViewSummary {
	s.ProposalSummary = v
	return s
}

// SetProposer sets the Proposer field's value.
func (s *AgreementViewSummary) SetProposer(v *Proposer) *AgreementViewSummary {
	s.Proposer = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AgreementViewSummary) SetStartTime(v time.Time) *AgreementViewSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AgreementViewSummary) SetStatus(v string) *AgreementViewSummary {
	s.Status = &v
	return s
}

// Enables you and your customers to move your existing agreements to AWS Marketplace.
// The customer won't be charged for product usage in AWS Marketplace because
// they already paid for the product outside of AWS Marketplace.
type ByolPricingTerm struct {
	_ struct{} `type:"structure"`

	// Type of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByolPricingTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ByolPricingTerm) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *ByolPricingTerm) SetType(v string) *ByolPricingTerm {
	s.Type = &v
	return s
}

// Defines a prepaid payment model that allows buyers to configure the entitlements
// they want to purchase and the duration.
type ConfigurableUpfrontPricingTerm struct {
	_ struct{} `type:"structure"`

	// Additional parameters specified by the acceptor while accepting the term.
	Configuration *ConfigurableUpfrontPricingTermConfiguration `locationName:"configuration" type:"structure"`

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`

	// A rate card defines the per unit rates for product dimensions.
	RateCards []*ConfigurableUpfrontRateCardItem `locationName:"rateCards" type:"list"`

	// Category of selector.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontPricingTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontPricingTerm) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ConfigurableUpfrontPricingTerm) SetConfiguration(v *ConfigurableUpfrontPricingTermConfiguration) *ConfigurableUpfrontPricingTerm {
	s.Configuration = v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ConfigurableUpfrontPricingTerm) SetCurrencyCode(v string) *ConfigurableUpfrontPricingTerm {
	s.CurrencyCode = &v
	return s
}

// SetRateCards sets the RateCards field's value.
func (s *ConfigurableUpfrontPricingTerm) SetRateCards(v []*ConfigurableUpfrontRateCardItem) *ConfigurableUpfrontPricingTerm {
	s.RateCards = v
	return s
}

// SetType sets the Type field's value.
func (s *ConfigurableUpfrontPricingTerm) SetType(v string) *ConfigurableUpfrontPricingTerm {
	s.Type = &v
	return s
}

// Defines a prepaid payment model that allows buyers to configure the entitlements
// they want to purchase and the duration.
type ConfigurableUpfrontPricingTermConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the dimensions that the acceptor has purchased from the overall set
	// of dimensions presented in the rate card.
	//
	// Dimensions is a required field
	Dimensions []*Dimension `locationName:"dimensions" min:"1" type:"list" required:"true"`

	// Defines the length of time for which the particular pricing/dimension is
	// being purchased by the acceptor.
	//
	// SelectorValue is a required field
	SelectorValue *string `locationName:"selectorValue" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontPricingTermConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontPricingTermConfiguration) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *ConfigurableUpfrontPricingTermConfiguration) SetDimensions(v []*Dimension) *ConfigurableUpfrontPricingTermConfiguration {
	s.Dimensions = v
	return s
}

// SetSelectorValue sets the SelectorValue field's value.
func (s *ConfigurableUpfrontPricingTermConfiguration) SetSelectorValue(v string) *ConfigurableUpfrontPricingTermConfiguration {
	s.SelectorValue = &v
	return s
}

// Within the prepaid payment model defined under ConfigurableUpfrontPricingTerm,
// the RateCardItem defines all the various rate cards (including pricing and
// dimensions) that have been proposed.
type ConfigurableUpfrontRateCardItem struct {
	_ struct{} `type:"structure"`

	// Defines limits on how the term can be configured by acceptors.
	Constraints *Constraints `locationName:"constraints" type:"structure"`

	// Defines the per unit rates for product dimensions.
	RateCard []*RateCardItem `locationName:"rateCard" type:"list"`

	// Differentiates between the mutually exclusive rate cards in the same pricing
	// term to be selected by the buyer.
	Selector *Selector `locationName:"selector" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontRateCardItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableUpfrontRateCardItem) GoString() string {
	return s.String()
}

// SetConstraints sets the Constraints field's value.
func (s *ConfigurableUpfrontRateCardItem) SetConstraints(v *Constraints) *ConfigurableUpfrontRateCardItem {
	s.Constraints = v
	return s
}

// SetRateCard sets the RateCard field's value.
func (s *ConfigurableUpfrontRateCardItem) SetRateCard(v []*RateCardItem) *ConfigurableUpfrontRateCardItem {
	s.RateCard = v
	return s
}

// SetSelector sets the Selector field's value.
func (s *ConfigurableUpfrontRateCardItem) SetSelector(v *Selector) *ConfigurableUpfrontRateCardItem {
	s.Selector = v
	return s
}

// Defines limits on how the term can be configured by acceptors.
type Constraints struct {
	_ struct{} `type:"structure"`

	// Determines if buyers are allowed to select multiple dimensions in the rate
	// card. The possible values are Allowed and Disallowed. The default value is
	// Allowed.
	MultipleDimensionSelection *string `locationName:"multipleDimensionSelection" min:"1" type:"string"`

	// Determines if acceptors are allowed to configure quantity for each dimension
	// in rate card. The possible values are Allowed and Disallowed. The default
	// value is Allowed.
	QuantityConfiguration *string `locationName:"quantityConfiguration" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Constraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Constraints) GoString() string {
	return s.String()
}

// SetMultipleDimensionSelection sets the MultipleDimensionSelection field's value.
func (s *Constraints) SetMultipleDimensionSelection(v string) *Constraints {
	s.MultipleDimensionSelection = &v
	return s
}

// SetQuantityConfiguration sets the QuantityConfiguration field's value.
func (s *Constraints) SetQuantityConfiguration(v string) *Constraints {
	s.QuantityConfiguration = &v
	return s
}

type DescribeAgreementInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agreement.
	//
	// AgreementId is a required field
	AgreementId *string `locationName:"agreementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgreementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgreementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgreementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAgreementInput"}
	if s.AgreementId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgreementId"))
	}
	if s.AgreementId != nil && len(*s.AgreementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgreementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgreementId sets the AgreementId field's value.
func (s *DescribeAgreementInput) SetAgreementId(v string) *DescribeAgreementInput {
	s.AgreementId = &v
	return s
}

type DescribeAgreementOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the offer was accepted or the agreement was created.
	//
	// AcceptanceTime and StartTime can differ for future dated agreements (FDAs).
	AcceptanceTime *time.Time `locationName:"acceptanceTime" type:"timestamp"`

	// The details of the party accepting the agreement terms. This is commonly
	// the buyer for PurchaseAgreement.
	Acceptor *Acceptor `locationName:"acceptor" type:"structure"`

	// The unique identifier of the agreement.
	AgreementId *string `locationName:"agreementId" min:"1" type:"string"`

	// The type of agreement. Values are PurchaseAgreement or VendorInsightsAgreement.
	AgreementType *string `locationName:"agreementType" min:"1" type:"string"`

	// The date and time when the agreement ends. The field is null for pay-as-you-go
	// agreements, which don’t have end dates.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The estimated cost of the agreement.
	EstimatedCharges *EstimatedCharges `locationName:"estimatedCharges" type:"structure"`

	// A summary of the proposal received from the proposer.
	ProposalSummary *ProposalSummary `locationName:"proposalSummary" type:"structure"`

	// The details of the party proposing the agreement terms. This is commonly
	// the seller for PurchaseAgreement.
	Proposer *Proposer `locationName:"proposer" type:"structure"`

	// The date and time when the agreement starts.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The current status of the agreement.
	//
	// Statuses include:
	//
	//    * ACTIVE – The terms of the agreement are active.
	//
	//    * ARCHIVED – The agreement ended without a specified reason.
	//
	//    * CANCELLED – The acceptor ended the agreement before the defined end
	//    date.
	//
	//    * EXPIRED – The agreement ended on the defined end date.
	//
	//    * RENEWED – The agreement was renewed into a new agreement (for example,
	//    an auto-renewal).
	//
	//    * REPLACED – The agreement was replaced using an agreement replacement
	//    offer.
	//
	//    * ROLLED_BACK (Only applicable to inactive agreement revisions) – The
	//    agreement revision has been rolled back because of an error. An earlier
	//    revision is now active.
	//
	//    * SUPERCEDED (Only applicable to inactive agreement revisions) – The
	//    agreement revision is no longer active and another agreement revision
	//    is now active.
	//
	//    * TERMINATED – The agreement ended before the defined end date because
	//    of an AWS termination (for example, a payment failure).
	Status *string `locationName:"status" type:"string" enum:"AgreementStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgreementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAgreementOutput) GoString() string {
	return s.String()
}

// SetAcceptanceTime sets the AcceptanceTime field's value.
func (s *DescribeAgreementOutput) SetAcceptanceTime(v time.Time) *DescribeAgreementOutput {
	s.AcceptanceTime = &v
	return s
}

// SetAcceptor sets the Acceptor field's value.
func (s *DescribeAgreementOutput) SetAcceptor(v *Acceptor) *DescribeAgreementOutput {
	s.Acceptor = v
	return s
}

// SetAgreementId sets the AgreementId field's value.
func (s *DescribeAgreementOutput) SetAgreementId(v string) *DescribeAgreementOutput {
	s.AgreementId = &v
	return s
}

// SetAgreementType sets the AgreementType field's value.
func (s *DescribeAgreementOutput) SetAgreementType(v string) *DescribeAgreementOutput {
	s.AgreementType = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeAgreementOutput) SetEndTime(v time.Time) *DescribeAgreementOutput {
	s.EndTime = &v
	return s
}

// SetEstimatedCharges sets the EstimatedCharges field's value.
func (s *DescribeAgreementOutput) SetEstimatedCharges(v *EstimatedCharges) *DescribeAgreementOutput {
	s.EstimatedCharges = v
	return s
}

// SetProposalSummary sets the ProposalSummary field's value.
func (s *DescribeAgreementOutput) SetProposalSummary(v *ProposalSummary) *DescribeAgreementOutput {
	s.ProposalSummary = v
	return s
}

// SetProposer sets the Proposer field's value.
func (s *DescribeAgreementOutput) SetProposer(v *Proposer) *DescribeAgreementOutput {
	s.Proposer = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeAgreementOutput) SetStartTime(v time.Time) *DescribeAgreementOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAgreementOutput) SetStatus(v string) *DescribeAgreementOutput {
	s.Status = &v
	return s
}

// Defines the dimensions that the acceptor has purchased from the overall set
// of dimensions presented in the rate card.
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of key value of the dimension.
	//
	// DimensionKey is a required field
	DimensionKey *string `locationName:"dimensionKey" min:"1" type:"string" required:"true"`

	// The number of units of the dimension the acceptor has purchased.
	//
	// For Agreements with ConfigurableUpfrontPricingTerm, the RateCard section
	// will define the prices and dimensions defined by the seller (proposer), whereas
	// the Configuration section will define the actual dimensions, prices, and
	// units the buyer has chosen to accept.
	//
	// DimensionValue is a required field
	DimensionValue *int64 `locationName:"dimensionValue" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dimension) GoString() string {
	return s.String()
}

// SetDimensionKey sets the DimensionKey field's value.
func (s *Dimension) SetDimensionKey(v string) *Dimension {
	s.DimensionKey = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *Dimension) SetDimensionValue(v int64) *Dimension {
	s.DimensionValue = &v
	return s
}

// Includes the list of references to legal resources proposed by the proposer
// to the acceptor. Each DocumentItem refers to an individual reference.
type DocumentItem struct {
	_ struct{} `type:"structure"`

	// Category of the document. Document types include:
	//
	//    * CustomEula – A custom EULA provided by you as seller. A URL for a
	//    EULA stored in an accessible Amazon S3 bucket is required for this document
	//    type.
	//
	//    * CustomDsa – A custom Data Subscription Agreement (DSA) provided by
	//    you as seller. A URL for a DSA stored in an accessible Amazon S3 bucket
	//    is required for this document type.
	//
	//    * StandardEula – The Standard Contract for AWS Marketplace (SCMP). For
	//    more information about SCMP, see the AWS Marketplace Seller Guide. You
	//    don’t provide a URL for this type because it’s managed by AWS Marketplace.
	//
	//    * StandardDsa – DSA for AWS Marketplace. For more information about
	//    the DSA, see the AWS Data Exchange User Guide. You don’t provide a URL
	//    for this type because it’s managed by AWS Marketplace.
	Type *string `locationName:"type" min:"1" type:"string"`

	// A URL to the legal document for buyers to read. Required when Type is CustomEula.
	Url *string `locationName:"url" min:"1" type:"string"`

	// Version of standard contracts provided by AWS Marketplace. Required when
	// Type is StandardEula or StandardDsa.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentItem) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *DocumentItem) SetType(v string) *DocumentItem {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DocumentItem) SetUrl(v string) *DocumentItem {
	s.Url = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DocumentItem) SetVersion(v string) *DocumentItem {
	s.Version = &v
	return s
}

// Estimated cost of the agreement.
type EstimatedCharges struct {
	_ struct{} `type:"structure"`

	// The total known amount customer has to pay across the lifecycle of the agreement.
	//
	// This is the total contract value if accepted terms contain ConfigurableUpfrontPricingTerm
	// or FixedUpfrontPricingTerm. In the case of pure contract pricing, this will
	// be the total value of the contract. In the case of contracts with consumption
	// pricing, this will only include the committed value and not include any overages
	// that occur.
	//
	// If the accepted terms contain PaymentScheduleTerm, it will be the total payment
	// schedule amount. This occurs when flexible payment schedule is used, and
	// is the sum of all invoice charges in the payment schedule.
	//
	// In case a customer has amended an agreement, by purchasing more units of
	// any dimension, this will include both the original cost as well as the added
	// cost incurred due to addition of new units.
	//
	// This is 0 if the accepted terms contain UsageBasedPricingTerm without ConfigurableUpfrontPricingTerm
	// or RecurringPaymentTerm. This occurs for usage-based pricing (such as SaaS
	// metered or AMI/container hourly or monthly), because the exact usage is not
	// known upfront.
	AgreementValue *string `locationName:"agreementValue" min:"1" type:"string"`

	// Defines the currency code for the charge.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimatedCharges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstimatedCharges) GoString() string {
	return s.String()
}

// SetAgreementValue sets the AgreementValue field's value.
func (s *EstimatedCharges) SetAgreementValue(v string) *EstimatedCharges {
	s.AgreementValue = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *EstimatedCharges) SetCurrencyCode(v string) *EstimatedCharges {
	s.CurrencyCode = &v
	return s
}

// The filter name and value pair that is used to return a more specific list
// of results. Filters can be used to match a set of resources by various criteria,
// such as offerId or productId.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The filter value.
	Values []*string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Defines a prepaid pricing model where the customers are charged a fixed upfront
// amount.
type FixedUpfrontPricingTerm struct {
	_ struct{} `type:"structure"`

	// Defines the currency for the prices mentioned in this term.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`

	// Contract duration for the terms.
	Duration *string `locationName:"duration" min:"1" type:"string"`

	// Entitlements granted to the acceptor of fixed upfront as part of agreement
	// execution.
	Grants []*GrantItem `locationName:"grants" type:"list"`

	// Fixed amount to be charged to the customer when this term is accepted.
	Price *string `locationName:"price" min:"1" type:"string"`

	// Category of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedUpfrontPricingTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedUpfrontPricingTerm) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *FixedUpfrontPricingTerm) SetCurrencyCode(v string) *FixedUpfrontPricingTerm {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *FixedUpfrontPricingTerm) SetDuration(v string) *FixedUpfrontPricingTerm {
	s.Duration = &v
	return s
}

// SetGrants sets the Grants field's value.
func (s *FixedUpfrontPricingTerm) SetGrants(v []*GrantItem) *FixedUpfrontPricingTerm {
	s.Grants = v
	return s
}

// SetPrice sets the Price field's value.
func (s *FixedUpfrontPricingTerm) SetPrice(v string) *FixedUpfrontPricingTerm {
	s.Price = &v
	return s
}

// SetType sets the Type field's value.
func (s *FixedUpfrontPricingTerm) SetType(v string) *FixedUpfrontPricingTerm {
	s.Type = &v
	return s
}

// Defines a short-term free pricing model where the buyers aren’t charged
// anything within a specified limit.
type FreeTrialPricingTerm struct {
	_ struct{} `type:"structure"`

	// Duration of the free trial period (5–31 days).
	Duration *string `locationName:"duration" min:"1" type:"string"`

	// Entitlements granted to the acceptor of a free trial as part of an agreement
	// execution.
	Grants []*GrantItem `locationName:"grants" type:"list"`

	// Category of the term.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialPricingTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTrialPricingTerm) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *FreeTrialPricingTerm) SetDuration(v string) *FreeTrialPricingTerm {
	s.Duration = &v
	return s
}

// SetGrants sets the Grants field's value.
func (s *FreeTrialPricingTerm) SetGrants(v []*GrantItem) *FreeTrialPricingTerm {
	s.Grants = v
	return s
}

// SetType sets the Type field's value.
func (s *FreeTrialPricingTerm) SetType(v string) *FreeTrialPricingTerm {
	s.Type = &v
	return s
}

type GetAgreementTermsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agreement.
	//
	// AgreementId is a required field
	AgreementId *string `locationName:"agreementId" min:"1" type:"string" required:"true"`

	// The maximum number of agreements to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start pagination
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgreementTermsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgreementTermsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgreementTermsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgreementTermsInput"}
	if s.AgreementId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgreementId"))
	}
	if s.AgreementId != nil && len(*s.AgreementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgreementId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgreementId sets the AgreementId field's value.
func (s *GetAgreementTermsInput) SetAgreementId(v string) *GetAgreementTermsInput {
	s.AgreementId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAgreementTermsInput) SetMaxResults(v int64) *GetAgreementTermsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAgreementTermsInput) SetNextToken(v string) *GetAgreementTermsInput {
	s.NextToken = &v
	return s
}

type GetAgreementTermsOutput struct {
	_ struct{} `type:"structure"`

	// A subset of terms proposed by the proposer that have been accepted by the
	// acceptor as part of the agreement creation.
	AcceptedTerms []*AcceptedTerm `locationName:"acceptedTerms" type:"list"`

	// A token to specify where to start pagination
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgreementTermsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgreementTermsOutput) GoString() string {
	return s.String()
}

// SetAcceptedTerms sets the AcceptedTerms field's value.
func (s *GetAgreementTermsOutput) SetAcceptedTerms(v []*AcceptedTerm) *GetAgreementTermsOutput {
	s.AcceptedTerms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAgreementTermsOutput) SetNextToken(v string) *GetAgreementTermsOutput {
	s.NextToken = &v
	return s
}

// Entitlements granted to the acceptor of fixed upfront as part of agreement
// execution.
type GrantItem struct {
	_ struct{} `type:"structure"`

	// Unique dimension key defined in the product document. Dimensions represent
	// categories of capacity in a product and are specified when the product is
	// listed in AWS Marketplace.
	DimensionKey *string `locationName:"dimensionKey" min:"1" type:"string"`

	// Maximum amount of capacity that the buyer can be entitled to the given dimension
	// of the product. If MaxQuantity is not provided, the buyer will be able to
	// use an unlimited amount of the given dimension.
	MaxQuantity *int64 `locationName:"maxQuantity" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantItem) GoString() string {
	return s.String()
}

// SetDimensionKey sets the DimensionKey field's value.
func (s *GrantItem) SetDimensionKey(v string) *GrantItem {
	s.DimensionKey = &v
	return s
}

// SetMaxQuantity sets the MaxQuantity field's value.
func (s *GrantItem) SetMaxQuantity(v int64) *GrantItem {
	s.MaxQuantity = &v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The unique identifier for the error.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines the list of text agreements proposed to the acceptors. An example
// is the end user license agreement (EULA).
type LegalTerm struct {
	_ struct{} `type:"structure"`

	// List of references to legal resources proposed to the buyers. An example
	// is the EULA.
	Documents []*DocumentItem `locationName:"documents" type:"list"`

	// Category of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegalTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegalTerm) GoString() string {
	return s.String()
}

// SetDocuments sets the Documents field's value.
func (s *LegalTerm) SetDocuments(v []*DocumentItem) *LegalTerm {
	s.Documents = v
	return s
}

// SetType sets the Type field's value.
func (s *LegalTerm) SetType(v string) *LegalTerm {
	s.Type = &v
	return s
}

// Defines an installment-based pricing model where customers are charged a
// fixed price on different dates during the agreement validity period. This
// is used most commonly for flexible payment schedule pricing.
type PaymentScheduleTerm struct {
	_ struct{} `type:"structure"`

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`

	// List of the payment schedule where each element defines one installment of
	// payment. It contains the information necessary for calculating the price.
	Schedule []*ScheduleItem `locationName:"schedule" type:"list"`

	// Type of the term.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PaymentScheduleTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PaymentScheduleTerm) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *PaymentScheduleTerm) SetCurrencyCode(v string) *PaymentScheduleTerm {
	s.CurrencyCode = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *PaymentScheduleTerm) SetSchedule(v []*ScheduleItem) *PaymentScheduleTerm {
	s.Schedule = v
	return s
}

// SetType sets the Type field's value.
func (s *PaymentScheduleTerm) SetType(v string) *PaymentScheduleTerm {
	s.Type = &v
	return s
}

// A summary of the proposal received from the proposer.
type ProposalSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the offer in AWS Marketplace.
	OfferId *string `locationName:"offerId" min:"1" type:"string"`

	// The list of resources involved in the agreement.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProposalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProposalSummary) GoString() string {
	return s.String()
}

// SetOfferId sets the OfferId field's value.
func (s *ProposalSummary) SetOfferId(v string) *ProposalSummary {
	s.OfferId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ProposalSummary) SetResources(v []*Resource) *ProposalSummary {
	s.Resources = v
	return s
}

// Details of the party proposing the agreement terms,. This is commonly the
// seller for PurchaseAgreement.
type Proposer struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the proposer.
	AccountId *string `locationName:"accountId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Proposer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Proposer) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Proposer) SetAccountId(v string) *Proposer {
	s.AccountId = &v
	return s
}

// Defines the per unit rates for each individual product dimension.
type RateCardItem struct {
	_ struct{} `type:"structure"`

	// Dimension for which the given entitlement applies. Dimensions represent categories
	// of capacity in a product and are specified when the product is listed in
	// AWS Marketplace.
	DimensionKey *string `locationName:"dimensionKey" min:"1" type:"string"`

	// Per unit price for the product dimension that’s used for calculating the
	// amount to be charged.
	Price *string `locationName:"price" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RateCardItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RateCardItem) GoString() string {
	return s.String()
}

// SetDimensionKey sets the DimensionKey field's value.
func (s *RateCardItem) SetDimensionKey(v string) *RateCardItem {
	s.DimensionKey = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *RateCardItem) SetPrice(v string) *RateCardItem {
	s.Price = &v
	return s
}

// Defines a pricing model where customers are charged a fixed recurring price
// at the end of each billing period.
type RecurringPaymentTerm struct {
	_ struct{} `type:"structure"`

	// Defines the recurrence at which buyers are charged.
	BillingPeriod *string `locationName:"billingPeriod" min:"1" type:"string"`

	// Defines the currency for the prices mentioned in this term.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`

	// Amount charged to the buyer every billing period.
	Price *string `locationName:"price" min:"1" type:"string"`

	// Type of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringPaymentTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecurringPaymentTerm) GoString() string {
	return s.String()
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *RecurringPaymentTerm) SetBillingPeriod(v string) *RecurringPaymentTerm {
	s.BillingPeriod = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *RecurringPaymentTerm) SetCurrencyCode(v string) *RecurringPaymentTerm {
	s.CurrencyCode = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *RecurringPaymentTerm) SetPrice(v string) *RecurringPaymentTerm {
	s.Price = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecurringPaymentTerm) SetType(v string) *RecurringPaymentTerm {
	s.Type = &v
	return s
}

// Defines that on graceful expiration of the agreement (when the agreement
// ends on its pre-defined end date), a new agreement will be created using
// the accepted terms on the existing agreement. In other words, the agreement
// will be renewed. The presence of RenewalTerm in the offer document means
// that auto-renewal is allowed. Buyers will have the option to accept or decline
// auto-renewal at the offer acceptance/agreement creation. Buyers can also
// change this flag from True to False or False to True at anytime during the
// agreement's lifecycle.
type RenewalTerm struct {
	_ struct{} `type:"structure"`

	// Additional parameters specified by the acceptor while accepting the term.
	Configuration *RenewalTermConfiguration `locationName:"configuration" type:"structure"`

	// Category of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewalTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewalTerm) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *RenewalTerm) SetConfiguration(v *RenewalTermConfiguration) *RenewalTerm {
	s.Configuration = v
	return s
}

// SetType sets the Type field's value.
func (s *RenewalTerm) SetType(v string) *RenewalTerm {
	s.Type = &v
	return s
}

// Additional parameters specified by the acceptor while accepting the term.
type RenewalTermConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines whether the acceptor has chosen to auto-renew the agreement at the
	// end of its lifecycle. Can be set to True or False.
	//
	// EnableAutoRenew is a required field
	EnableAutoRenew *bool `locationName:"enableAutoRenew" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewalTermConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenewalTermConfiguration) GoString() string {
	return s.String()
}

// SetEnableAutoRenew sets the EnableAutoRenew field's value.
func (s *RenewalTermConfiguration) SetEnableAutoRenew(v bool) *RenewalTermConfiguration {
	s.EnableAutoRenew = &v
	return s
}

// The list of resources involved in the agreement.
type Resource struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the resource.
	//
	// We mention the term resource, which is most commonly a product, so a resourceId
	// is also a productId.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Type of the resource, which is the product. Values include SaaSProduct or
	// AmiProduct.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The unique identifier for the error.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`

	// The unique identifier for the resource.
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An individual installment of the payment that includes the date and amount
// of the charge.
type ScheduleItem struct {
	_ struct{} `type:"structure"`

	// The price that the customer would pay on the scheduled date (chargeDate).
	ChargeAmount *string `locationName:"chargeAmount" min:"1" type:"string"`

	// The date that the customer would pay the price defined in this payment schedule
	// term. Invoices are generated on the date provided.
	ChargeDate *time.Time `locationName:"chargeDate" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleItem) GoString() string {
	return s.String()
}

// SetChargeAmount sets the ChargeAmount field's value.
func (s *ScheduleItem) SetChargeAmount(v string) *ScheduleItem {
	s.ChargeAmount = &v
	return s
}

// SetChargeDate sets the ChargeDate field's value.
func (s *ScheduleItem) SetChargeDate(v time.Time) *ScheduleItem {
	s.ChargeDate = &v
	return s
}

type SearchAgreementsInput struct {
	_ struct{} `type:"structure"`

	// The catalog in which the agreement was created.
	Catalog *string `locationName:"catalog" min:"1" type:"string"`

	// The filter name and value pair used to return a specific list of results.
	//
	// The following filters are supported:
	//
	//    * ResourceIdentifier – The unique identifier of the resource.
	//
	//    * ResourceType – Type of the resource, which is the product (AmiProduct,
	//    ContainerProduct, or SaaSProduct).
	//
	//    * PartyType – The party type (either Acceptor or Proposer) of the caller.
	//    For agreements where the caller is the proposer, use the Proposer filter.
	//    For agreements where the caller is the acceptor, use the Acceptor filter.
	//
	//    * AcceptorAccountId – The AWS account ID of the party accepting the
	//    agreement terms.
	//
	//    * OfferId – The unique identifier of the offer in which the terms are
	//    registered in the agreement token.
	//
	//    * Status – The current status of the agreement. Values include ACTIVE,
	//    ARCHIVED, CANCELLED, EXPIRED, RENEWED, REPLACED, and TERMINATED.
	//
	//    * BeforeEndTime – A date used to filter agreements with a date before
	//    the endTime of an agreement.
	//
	//    * AfterEndTime – A date used to filter agreements with a date after
	//    the endTime of an agreement.
	//
	//    * AgreementType – The type of agreement. Values include PurchaseAgreement
	//    or VendorInsightsAgreement.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum number of agreements to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An object that contains the SortBy and SortOrder attributes.
	Sort *Sort `locationName:"sort" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAgreementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAgreementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAgreementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchAgreementsInput"}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *SearchAgreementsInput) SetCatalog(v string) *SearchAgreementsInput {
	s.Catalog = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchAgreementsInput) SetFilters(v []*Filter) *SearchAgreementsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchAgreementsInput) SetMaxResults(v int64) *SearchAgreementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAgreementsInput) SetNextToken(v string) *SearchAgreementsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *SearchAgreementsInput) SetSort(v *Sort) *SearchAgreementsInput {
	s.Sort = v
	return s
}

type SearchAgreementsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of the agreement, including top-level attributes (for example,
	// the agreement ID, version, proposer, and acceptor).
	AgreementViewSummaries []*AgreementViewSummary `locationName:"agreementViewSummaries" type:"list"`

	// The token used for pagination. The field is null if there are no more results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAgreementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchAgreementsOutput) GoString() string {
	return s.String()
}

// SetAgreementViewSummaries sets the AgreementViewSummaries field's value.
func (s *SearchAgreementsOutput) SetAgreementViewSummaries(v []*AgreementViewSummary) *SearchAgreementsOutput {
	s.AgreementViewSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAgreementsOutput) SetNextToken(v string) *SearchAgreementsOutput {
	s.NextToken = &v
	return s
}

// Differentiates between the mutually exclusive rate cards in the same pricing
// term to be selected by the buyer.
type Selector struct {
	_ struct{} `type:"structure"`

	// Category of selector.
	Type *string `locationName:"type" min:"1" type:"string"`

	// Contract duration. This field supports the ISO 8601 format.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Selector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Selector) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *Selector) SetType(v string) *Selector {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Selector) SetValue(v string) *Selector {
	s.Value = &v
	return s
}

// An object that contains the SortBy and SortOrder attributes.
type Sort struct {
	_ struct{} `type:"structure"`

	// The attribute on which the data is grouped, which can be by StartTime and
	// EndTime. The default value is EndTime.
	SortBy *string `locationName:"sortBy" min:"1" type:"string"`

	// The sorting order, which can be ASCENDING or DESCENDING. The default value
	// is DESCENDING.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSortBy sets the SortBy field's value.
func (s *Sort) SetSortBy(v string) *Sort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Sort) SetSortOrder(v string) *Sort {
	s.SortOrder = &v
	return s
}

// Defines the customer support available for the acceptors when they purchase
// the software.
type SupportTerm struct {
	_ struct{} `type:"structure"`

	// Free-text field about the refund policy description that will be shown to
	// customers as is on the website and console.
	RefundPolicy *string `locationName:"refundPolicy" min:"1" type:"string"`

	// Category of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SupportTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SupportTerm) GoString() string {
	return s.String()
}

// SetRefundPolicy sets the RefundPolicy field's value.
func (s *SupportTerm) SetRefundPolicy(v string) *SupportTerm {
	s.RefundPolicy = &v
	return s
}

// SetType sets the Type field's value.
func (s *SupportTerm) SetType(v string) *SupportTerm {
	s.Type = &v
	return s
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The unique identifier for the error.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines a usage-based pricing model (typically, pay-as-you-go pricing), where
// the customers are charged based on product usage.
type UsageBasedPricingTerm struct {
	_ struct{} `type:"structure"`

	// Defines the currency for the prices mentioned in the term.
	CurrencyCode *string `locationName:"currencyCode" min:"3" type:"string"`

	// List of rate cards.
	RateCards []*UsageBasedRateCardItem `locationName:"rateCards" type:"list"`

	// Category of the term.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageBasedPricingTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageBasedPricingTerm) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *UsageBasedPricingTerm) SetCurrencyCode(v string) *UsageBasedPricingTerm {
	s.CurrencyCode = &v
	return s
}

// SetRateCards sets the RateCards field's value.
func (s *UsageBasedPricingTerm) SetRateCards(v []*UsageBasedRateCardItem) *UsageBasedPricingTerm {
	s.RateCards = v
	return s
}

// SetType sets the Type field's value.
func (s *UsageBasedPricingTerm) SetType(v string) *UsageBasedPricingTerm {
	s.Type = &v
	return s
}

// Within the pay-as-you-go model defined under UsageBasedPricingTerm, the UsageBasedRateCardItem
// defines an individual rate for a product dimension.
type UsageBasedRateCardItem struct {
	_ struct{} `type:"structure"`

	// Defines the per unit rates for product dimensions.
	RateCard []*RateCardItem `locationName:"rateCard" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageBasedRateCardItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageBasedRateCardItem) GoString() string {
	return s.String()
}

// SetRateCard sets the RateCard field's value.
func (s *UsageBasedRateCardItem) SetRateCard(v []*RateCardItem) *UsageBasedRateCardItem {
	s.RateCard = v
	return s
}

// The input fails to satisfy the constraints specified by the service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields associated with the error.
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The reason associated with the error.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`

	// The unique identifier associated with the error.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input fails to satisfy the constraints specified by the service.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// See applicable actions.
	//
	// Message is a required field
	Message *string `locationName:"message" min:"1" type:"string" required:"true"`

	// The name of the field associated with the error.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Defines the conditions that will keep an agreement created from this offer
// valid.
type ValidityTerm struct {
	_ struct{} `type:"structure"`

	// Defines the duration that the agreement remains active. If AgreementStartDate
	// isn’t provided, the agreement duration is relative to the agreement signature
	// time. The duration is represented in the ISO_8601 format.
	AgreementDuration *string `locationName:"agreementDuration" min:"1" type:"string"`

	// Defines the date when the agreement ends. The agreement ends at 23:59:59.999
	// UTC on the date provided. If AgreementEndDate isn’t provided, the agreement
	// end date is determined by the validity of individual terms.
	AgreementEndDate *time.Time `locationName:"agreementEndDate" type:"timestamp"`

	// Defines the date when agreement starts. The agreement starts at 00:00:00.000
	// UTC on the date provided. If AgreementStartDate isn’t provided, the agreement
	// start date is determined based on agreement signature time.
	AgreementStartDate *time.Time `locationName:"agreementStartDate" type:"timestamp"`

	// Category of the term being updated.
	Type *string `locationName:"type" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidityTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidityTerm) GoString() string {
	return s.String()
}

// SetAgreementDuration sets the AgreementDuration field's value.
func (s *ValidityTerm) SetAgreementDuration(v string) *ValidityTerm {
	s.AgreementDuration = &v
	return s
}

// SetAgreementEndDate sets the AgreementEndDate field's value.
func (s *ValidityTerm) SetAgreementEndDate(v time.Time) *ValidityTerm {
	s.AgreementEndDate = &v
	return s
}

// SetAgreementStartDate sets the AgreementStartDate field's value.
func (s *ValidityTerm) SetAgreementStartDate(v time.Time) *ValidityTerm {
	s.AgreementStartDate = &v
	return s
}

// SetType sets the Type field's value.
func (s *ValidityTerm) SetType(v string) *ValidityTerm {
	s.Type = &v
	return s
}

const (
	// AgreementStatusActive is a AgreementStatus enum value
	AgreementStatusActive = "ACTIVE"

	// AgreementStatusArchived is a AgreementStatus enum value
	AgreementStatusArchived = "ARCHIVED"

	// AgreementStatusCancelled is a AgreementStatus enum value
	AgreementStatusCancelled = "CANCELLED"

	// AgreementStatusExpired is a AgreementStatus enum value
	AgreementStatusExpired = "EXPIRED"

	// AgreementStatusRenewed is a AgreementStatus enum value
	AgreementStatusRenewed = "RENEWED"

	// AgreementStatusReplaced is a AgreementStatus enum value
	AgreementStatusReplaced = "REPLACED"

	// AgreementStatusRolledBack is a AgreementStatus enum value
	AgreementStatusRolledBack = "ROLLED_BACK"

	// AgreementStatusSuperseded is a AgreementStatus enum value
	AgreementStatusSuperseded = "SUPERSEDED"

	// AgreementStatusTerminated is a AgreementStatus enum value
	AgreementStatusTerminated = "TERMINATED"
)

// AgreementStatus_Values returns all elements of the AgreementStatus enum
func AgreementStatus_Values() []string {
	return []string{
		AgreementStatusActive,
		AgreementStatusArchived,
		AgreementStatusCancelled,
		AgreementStatusExpired,
		AgreementStatusRenewed,
		AgreementStatusReplaced,
		AgreementStatusRolledBack,
		AgreementStatusSuperseded,
		AgreementStatusTerminated,
	}
}

const (
	// ResourceTypeAgreement is a ResourceType enum value
	ResourceTypeAgreement = "Agreement"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAgreement,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// ValidationExceptionReasonInvalidAgreementId is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidAgreementId = "INVALID_AGREEMENT_ID"

	// ValidationExceptionReasonMissingAgreementId is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingAgreementId = "MISSING_AGREEMENT_ID"

	// ValidationExceptionReasonInvalidCatalog is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidCatalog = "INVALID_CATALOG"

	// ValidationExceptionReasonInvalidFilterName is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidFilterName = "INVALID_FILTER_NAME"

	// ValidationExceptionReasonInvalidFilterValues is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidFilterValues = "INVALID_FILTER_VALUES"

	// ValidationExceptionReasonInvalidSortBy is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidSortBy = "INVALID_SORT_BY"

	// ValidationExceptionReasonInvalidSortOrder is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidSortOrder = "INVALID_SORT_ORDER"

	// ValidationExceptionReasonInvalidNextToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidNextToken = "INVALID_NEXT_TOKEN"

	// ValidationExceptionReasonInvalidMaxResults is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidMaxResults = "INVALID_MAX_RESULTS"

	// ValidationExceptionReasonUnsupportedFilters is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnsupportedFilters = "UNSUPPORTED_FILTERS"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonInvalidAgreementId,
		ValidationExceptionReasonMissingAgreementId,
		ValidationExceptionReasonInvalidCatalog,
		ValidationExceptionReasonInvalidFilterName,
		ValidationExceptionReasonInvalidFilterValues,
		ValidationExceptionReasonInvalidSortBy,
		ValidationExceptionReasonInvalidSortOrder,
		ValidationExceptionReasonInvalidNextToken,
		ValidationExceptionReasonInvalidMaxResults,
		ValidationExceptionReasonUnsupportedFilters,
		ValidationExceptionReasonOther,
	}
}
