// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedgrafana

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateLicense = "AssociateLicense"

// AssociateLicenseRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLicense operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLicense for more information on using the AssociateLicense
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateLicenseRequest method.
//	req, resp := client.AssociateLicenseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense
func (c *ManagedGrafana) AssociateLicenseRequest(input *AssociateLicenseInput) (req *request.Request, output *AssociateLicenseOutput) {
	op := &request.Operation{
		Name:       opAssociateLicense,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/licenses/{licenseType}",
	}

	if input == nil {
		input = &AssociateLicenseInput{}
	}

	output = &AssociateLicenseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateLicense API operation for Amazon Managed Grafana.
//
// Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana
// Enterprise incurs additional fees. For more information, see Upgrade a workspace
// to Grafana Enterprise (https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation AssociateLicense for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/AssociateLicense
func (c *ManagedGrafana) AssociateLicense(input *AssociateLicenseInput) (*AssociateLicenseOutput, error) {
	req, out := c.AssociateLicenseRequest(input)
	return out, req.Send()
}

// AssociateLicenseWithContext is the same as AssociateLicense with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLicense for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) AssociateLicenseWithContext(ctx aws.Context, input *AssociateLicenseInput, opts ...request.Option) (*AssociateLicenseOutput, error) {
	req, out := c.AssociateLicenseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspace = "CreateWorkspace"

// CreateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspace for more information on using the CreateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceRequest method.
//	req, resp := client.CreateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace
func (c *ManagedGrafana) CreateWorkspaceRequest(input *CreateWorkspaceInput) (req *request.Request, output *CreateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces",
	}

	if input == nil {
		input = &CreateWorkspaceInput{}
	}

	output = &CreateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspace API operation for Amazon Managed Grafana.
//
// Creates a workspace. In a workspace, you can create Grafana dashboards and
// visualizations to analyze your metrics, logs, and traces. You don't have
// to build, package, or deploy any hardware to run the Grafana server.
//
// Don't use CreateWorkspace to modify an existing workspace. Instead, use UpdateWorkspace
// (https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation CreateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspace
func (c *ManagedGrafana) CreateWorkspace(input *CreateWorkspaceInput) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	return out, req.Send()
}

// CreateWorkspaceWithContext is the same as CreateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) CreateWorkspaceWithContext(ctx aws.Context, input *CreateWorkspaceInput, opts ...request.Option) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaceApiKey = "CreateWorkspaceApiKey"

// CreateWorkspaceApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaceApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaceApiKey for more information on using the CreateWorkspaceApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceApiKeyRequest method.
//	req, resp := client.CreateWorkspaceApiKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspaceApiKey
func (c *ManagedGrafana) CreateWorkspaceApiKeyRequest(input *CreateWorkspaceApiKeyInput) (req *request.Request, output *CreateWorkspaceApiKeyOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaceApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/apikeys",
	}

	if input == nil {
		input = &CreateWorkspaceApiKeyInput{}
	}

	output = &CreateWorkspaceApiKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaceApiKey API operation for Amazon Managed Grafana.
//
// Creates a Grafana API key for the workspace. This key can be used to authenticate
// requests sent to the workspace's HTTP API. See https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html
// (https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html)
// for available APIs and example requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation CreateWorkspaceApiKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/CreateWorkspaceApiKey
func (c *ManagedGrafana) CreateWorkspaceApiKey(input *CreateWorkspaceApiKeyInput) (*CreateWorkspaceApiKeyOutput, error) {
	req, out := c.CreateWorkspaceApiKeyRequest(input)
	return out, req.Send()
}

// CreateWorkspaceApiKeyWithContext is the same as CreateWorkspaceApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaceApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) CreateWorkspaceApiKeyWithContext(ctx aws.Context, input *CreateWorkspaceApiKeyInput, opts ...request.Option) (*CreateWorkspaceApiKeyOutput, error) {
	req, out := c.CreateWorkspaceApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspace = "DeleteWorkspace"

// DeleteWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspace for more information on using the DeleteWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceRequest method.
//	req, resp := client.DeleteWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace
func (c *ManagedGrafana) DeleteWorkspaceRequest(input *DeleteWorkspaceInput) (req *request.Request, output *DeleteWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DeleteWorkspaceInput{}
	}

	output = &DeleteWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkspace API operation for Amazon Managed Grafana.
//
// Deletes an Amazon Managed Grafana workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DeleteWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspace
func (c *ManagedGrafana) DeleteWorkspace(input *DeleteWorkspaceInput) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceWithContext is the same as DeleteWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DeleteWorkspaceWithContext(ctx aws.Context, input *DeleteWorkspaceInput, opts ...request.Option) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceApiKey = "DeleteWorkspaceApiKey"

// DeleteWorkspaceApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceApiKey for more information on using the DeleteWorkspaceApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceApiKeyRequest method.
//	req, resp := client.DeleteWorkspaceApiKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspaceApiKey
func (c *ManagedGrafana) DeleteWorkspaceApiKeyRequest(input *DeleteWorkspaceApiKeyInput) (req *request.Request, output *DeleteWorkspaceApiKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceApiKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/apikeys/{keyName}",
	}

	if input == nil {
		input = &DeleteWorkspaceApiKeyInput{}
	}

	output = &DeleteWorkspaceApiKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkspaceApiKey API operation for Amazon Managed Grafana.
//
// Deletes a Grafana API key for the workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DeleteWorkspaceApiKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DeleteWorkspaceApiKey
func (c *ManagedGrafana) DeleteWorkspaceApiKey(input *DeleteWorkspaceApiKeyInput) (*DeleteWorkspaceApiKeyOutput, error) {
	req, out := c.DeleteWorkspaceApiKeyRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceApiKeyWithContext is the same as DeleteWorkspaceApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DeleteWorkspaceApiKeyWithContext(ctx aws.Context, input *DeleteWorkspaceApiKeyInput, opts ...request.Option) (*DeleteWorkspaceApiKeyOutput, error) {
	req, out := c.DeleteWorkspaceApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspace = "DescribeWorkspace"

// DescribeWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspace for more information on using the DescribeWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceRequest method.
//	req, resp := client.DescribeWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace
func (c *ManagedGrafana) DescribeWorkspaceRequest(input *DescribeWorkspaceInput) (req *request.Request, output *DescribeWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspace,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DescribeWorkspaceInput{}
	}

	output = &DescribeWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspace API operation for Amazon Managed Grafana.
//
// Displays information about one Amazon Managed Grafana workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DescribeWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspace
func (c *ManagedGrafana) DescribeWorkspace(input *DescribeWorkspaceInput) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceWithContext is the same as DescribeWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DescribeWorkspaceWithContext(ctx aws.Context, input *DescribeWorkspaceInput, opts ...request.Option) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceAuthentication = "DescribeWorkspaceAuthentication"

// DescribeWorkspaceAuthenticationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceAuthentication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceAuthentication for more information on using the DescribeWorkspaceAuthentication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceAuthenticationRequest method.
//	req, resp := client.DescribeWorkspaceAuthenticationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication
func (c *ManagedGrafana) DescribeWorkspaceAuthenticationRequest(input *DescribeWorkspaceAuthenticationInput) (req *request.Request, output *DescribeWorkspaceAuthenticationOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceAuthentication,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/authentication",
	}

	if input == nil {
		input = &DescribeWorkspaceAuthenticationInput{}
	}

	output = &DescribeWorkspaceAuthenticationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceAuthentication API operation for Amazon Managed Grafana.
//
// Displays information about the authentication methods used in one Amazon
// Managed Grafana workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DescribeWorkspaceAuthentication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceAuthentication
func (c *ManagedGrafana) DescribeWorkspaceAuthentication(input *DescribeWorkspaceAuthenticationInput) (*DescribeWorkspaceAuthenticationOutput, error) {
	req, out := c.DescribeWorkspaceAuthenticationRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceAuthenticationWithContext is the same as DescribeWorkspaceAuthentication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceAuthentication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DescribeWorkspaceAuthenticationWithContext(ctx aws.Context, input *DescribeWorkspaceAuthenticationInput, opts ...request.Option) (*DescribeWorkspaceAuthenticationOutput, error) {
	req, out := c.DescribeWorkspaceAuthenticationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceConfiguration = "DescribeWorkspaceConfiguration"

// DescribeWorkspaceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceConfiguration for more information on using the DescribeWorkspaceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceConfigurationRequest method.
//	req, resp := client.DescribeWorkspaceConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceConfiguration
func (c *ManagedGrafana) DescribeWorkspaceConfigurationRequest(input *DescribeWorkspaceConfigurationInput) (req *request.Request, output *DescribeWorkspaceConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/configuration",
	}

	if input == nil {
		input = &DescribeWorkspaceConfigurationInput{}
	}

	output = &DescribeWorkspaceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceConfiguration API operation for Amazon Managed Grafana.
//
// Gets the current configuration string for the given workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DescribeWorkspaceConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DescribeWorkspaceConfiguration
func (c *ManagedGrafana) DescribeWorkspaceConfiguration(input *DescribeWorkspaceConfigurationInput) (*DescribeWorkspaceConfigurationOutput, error) {
	req, out := c.DescribeWorkspaceConfigurationRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceConfigurationWithContext is the same as DescribeWorkspaceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DescribeWorkspaceConfigurationWithContext(ctx aws.Context, input *DescribeWorkspaceConfigurationInput, opts ...request.Option) (*DescribeWorkspaceConfigurationOutput, error) {
	req, out := c.DescribeWorkspaceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLicense = "DisassociateLicense"

// DisassociateLicenseRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLicense operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLicense for more information on using the DisassociateLicense
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateLicenseRequest method.
//	req, resp := client.DisassociateLicenseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense
func (c *ManagedGrafana) DisassociateLicenseRequest(input *DisassociateLicenseInput) (req *request.Request, output *DisassociateLicenseOutput) {
	op := &request.Operation{
		Name:       opDisassociateLicense,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/licenses/{licenseType}",
	}

	if input == nil {
		input = &DisassociateLicenseInput{}
	}

	output = &DisassociateLicenseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateLicense API operation for Amazon Managed Grafana.
//
// Removes the Grafana Enterprise license from a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation DisassociateLicense for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/DisassociateLicense
func (c *ManagedGrafana) DisassociateLicense(input *DisassociateLicenseInput) (*DisassociateLicenseOutput, error) {
	req, out := c.DisassociateLicenseRequest(input)
	return out, req.Send()
}

// DisassociateLicenseWithContext is the same as DisassociateLicense with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLicense for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) DisassociateLicenseWithContext(ctx aws.Context, input *DisassociateLicenseInput, opts ...request.Option) (*DisassociateLicenseOutput, error) {
	req, out := c.DisassociateLicenseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionsRequest method.
//	req, resp := client.ListPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions
func (c *ManagedGrafana) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/permissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for Amazon Managed Grafana.
//
// Lists the users and groups who have the Grafana Admin and Editor roles in
// this workspace. If you use this operation without specifying userId or groupId,
// the operation returns the roles of all users and groups. If you specify a
// userId or a groupId, only the roles for that user or group are returned.
// If you do this, you can specify only one userId or one groupId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListPermissions
func (c *ManagedGrafana) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissions operation.
//	pageNum := 0
//	err := client.ListPermissionsPages(params,
//	    func(page *managedgrafana.ListPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedGrafana) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListTagsForResource
func (c *ManagedGrafana) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Managed Grafana.
//
// The ListTagsForResource operation returns the tags that are associated with
// the Amazon Managed Service for Grafana resource specified by the resourceArn.
// Currently, the only resource that can be tagged is a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListTagsForResource
func (c *ManagedGrafana) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVersions = "ListVersions"

// ListVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVersions for more information on using the ListVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVersionsRequest method.
//	req, resp := client.ListVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions
func (c *ManagedGrafana) ListVersionsRequest(input *ListVersionsInput) (req *request.Request, output *ListVersionsOutput) {
	op := &request.Operation{
		Name:       opListVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVersionsInput{}
	}

	output = &ListVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersions API operation for Amazon Managed Grafana.
//
// Lists available versions of Grafana. These are available when calling CreateWorkspace.
// Optionally, include a workspace to list the versions to which it can be upgraded.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation ListVersions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListVersions
func (c *ManagedGrafana) ListVersions(input *ListVersionsInput) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	return out, req.Send()
}

// ListVersionsWithContext is the same as ListVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListVersionsWithContext(ctx aws.Context, input *ListVersionsInput, opts ...request.Option) (*ListVersionsOutput, error) {
	req, out := c.ListVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVersionsPages iterates over the pages of a ListVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVersions operation.
//	pageNum := 0
//	err := client.ListVersionsPages(params,
//	    func(page *managedgrafana.ListVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedGrafana) ListVersionsPages(input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool) error {
	return c.ListVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVersionsPagesWithContext same as ListVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListVersionsPagesWithContext(ctx aws.Context, input *ListVersionsInput, fn func(*ListVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkspaces = "ListWorkspaces"

// ListWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkspaces for more information on using the ListWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkspacesRequest method.
//	req, resp := client.ListWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces
func (c *ManagedGrafana) ListWorkspacesRequest(input *ListWorkspacesInput) (req *request.Request, output *ListWorkspacesOutput) {
	op := &request.Operation{
		Name:       opListWorkspaces,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkspacesInput{}
	}

	output = &ListWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkspaces API operation for Amazon Managed Grafana.
//
// Returns a list of Amazon Managed Grafana workspaces in the account, with
// some information about each workspace. For more complete information about
// one workspace, use DescribeWorkspace (https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation ListWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/ListWorkspaces
func (c *ManagedGrafana) ListWorkspaces(input *ListWorkspacesInput) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	return out, req.Send()
}

// ListWorkspacesWithContext is the same as ListWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListWorkspacesWithContext(ctx aws.Context, input *ListWorkspacesInput, opts ...request.Option) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkspacesPages iterates over the pages of a ListWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkspaces operation.
//	pageNum := 0
//	err := client.ListWorkspacesPages(params,
//	    func(page *managedgrafana.ListWorkspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedGrafana) ListWorkspacesPages(input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool) error {
	return c.ListWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkspacesPagesWithContext same as ListWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) ListWorkspacesPagesWithContext(ctx aws.Context, input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/TagResource
func (c *ManagedGrafana) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Managed Grafana.
//
// The TagResource operation associates tags with an Amazon Managed Grafana
// resource. Currently, the only resource that can be tagged is workspaces.
//
// If you specify a new tag key for the resource, this tag is appended to the
// list of tags associated with the resource. If you specify a tag key that
// is already associated with the resource, the new tag value that you specify
// replaces the previous value for that tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/TagResource
func (c *ManagedGrafana) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UntagResource
func (c *ManagedGrafana) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Managed Grafana.
//
// The UntagResource operation removes the association of the tag with the Amazon
// Managed Grafana resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UntagResource
func (c *ManagedGrafana) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePermissions = "UpdatePermissions"

// UpdatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePermissions for more information on using the UpdatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePermissionsRequest method.
//	req, resp := client.UpdatePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions
func (c *ManagedGrafana) UpdatePermissionsRequest(input *UpdatePermissionsInput) (req *request.Request, output *UpdatePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdatePermissions,
		HTTPMethod: "PATCH",
		HTTPPath:   "/workspaces/{workspaceId}/permissions",
	}

	if input == nil {
		input = &UpdatePermissionsInput{}
	}

	output = &UpdatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePermissions API operation for Amazon Managed Grafana.
//
// Updates which users in a workspace have the Grafana Admin or Editor roles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation UpdatePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdatePermissions
func (c *ManagedGrafana) UpdatePermissions(input *UpdatePermissionsInput) (*UpdatePermissionsOutput, error) {
	req, out := c.UpdatePermissionsRequest(input)
	return out, req.Send()
}

// UpdatePermissionsWithContext is the same as UpdatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) UpdatePermissionsWithContext(ctx aws.Context, input *UpdatePermissionsInput, opts ...request.Option) (*UpdatePermissionsOutput, error) {
	req, out := c.UpdatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspace = "UpdateWorkspace"

// UpdateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspace for more information on using the UpdateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceRequest method.
//	req, resp := client.UpdateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace
func (c *ManagedGrafana) UpdateWorkspaceRequest(input *UpdateWorkspaceInput) (req *request.Request, output *UpdateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspace,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &UpdateWorkspaceInput{}
	}

	output = &UpdateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkspace API operation for Amazon Managed Grafana.
//
// Modifies an existing Amazon Managed Grafana workspace. If you use this operation
// and omit any optional parameters, the existing values of those parameters
// are not changed.
//
// To modify the user authentication methods that the workspace uses, such as
// SAML or IAM Identity Center, use UpdateWorkspaceAuthentication (https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
//
// To modify which users in the workspace have the Admin and Editor Grafana
// roles, use UpdatePermissions (https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation UpdateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspace
func (c *ManagedGrafana) UpdateWorkspace(input *UpdateWorkspaceInput) (*UpdateWorkspaceOutput, error) {
	req, out := c.UpdateWorkspaceRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceWithContext is the same as UpdateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) UpdateWorkspaceWithContext(ctx aws.Context, input *UpdateWorkspaceInput, opts ...request.Option) (*UpdateWorkspaceOutput, error) {
	req, out := c.UpdateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceAuthentication = "UpdateWorkspaceAuthentication"

// UpdateWorkspaceAuthenticationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceAuthentication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceAuthentication for more information on using the UpdateWorkspaceAuthentication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceAuthenticationRequest method.
//	req, resp := client.UpdateWorkspaceAuthenticationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication
func (c *ManagedGrafana) UpdateWorkspaceAuthenticationRequest(input *UpdateWorkspaceAuthenticationInput) (req *request.Request, output *UpdateWorkspaceAuthenticationOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceAuthentication,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/authentication",
	}

	if input == nil {
		input = &UpdateWorkspaceAuthenticationInput{}
	}

	output = &UpdateWorkspaceAuthenticationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkspaceAuthentication API operation for Amazon Managed Grafana.
//
// Use this operation to define the identity provider (IdP) that this workspace
// authenticates users from, using SAML. You can also map SAML assertion attributes
// to workspace user information and define which groups in the assertion attribute
// are to have the Admin and Editor roles in the workspace.
//
// Changes to the authentication method for a workspace may take a few minutes
// to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation UpdateWorkspaceAuthentication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceAuthentication
func (c *ManagedGrafana) UpdateWorkspaceAuthentication(input *UpdateWorkspaceAuthenticationInput) (*UpdateWorkspaceAuthenticationOutput, error) {
	req, out := c.UpdateWorkspaceAuthenticationRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceAuthenticationWithContext is the same as UpdateWorkspaceAuthentication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceAuthentication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) UpdateWorkspaceAuthenticationWithContext(ctx aws.Context, input *UpdateWorkspaceAuthenticationInput, opts ...request.Option) (*UpdateWorkspaceAuthenticationOutput, error) {
	req, out := c.UpdateWorkspaceAuthenticationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceConfiguration = "UpdateWorkspaceConfiguration"

// UpdateWorkspaceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceConfiguration for more information on using the UpdateWorkspaceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceConfigurationRequest method.
//	req, resp := client.UpdateWorkspaceConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceConfiguration
func (c *ManagedGrafana) UpdateWorkspaceConfigurationRequest(input *UpdateWorkspaceConfigurationInput) (req *request.Request, output *UpdateWorkspaceConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/configuration",
	}

	if input == nil {
		input = &UpdateWorkspaceConfigurationInput{}
	}

	output = &UpdateWorkspaceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceConfiguration API operation for Amazon Managed Grafana.
//
// # Updates the configuration string for the given workspace
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Grafana's
// API operation UpdateWorkspaceConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServerException
//     Unexpected error while processing the request. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/grafana-2020-08-18/UpdateWorkspaceConfiguration
func (c *ManagedGrafana) UpdateWorkspaceConfiguration(input *UpdateWorkspaceConfigurationInput) (*UpdateWorkspaceConfigurationOutput, error) {
	req, out := c.UpdateWorkspaceConfigurationRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceConfigurationWithContext is the same as UpdateWorkspaceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedGrafana) UpdateWorkspaceConfigurationWithContext(ctx aws.Context, input *UpdateWorkspaceConfigurationInput, opts ...request.Option) (*UpdateWorkspaceConfigurationOutput, error) {
	req, out := c.UpdateWorkspaceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that defines which attributes in the IdP assertion are to be
// used to define information about the users authenticated by the IdP to use
// the workspace.
type AssertionAttributes struct {
	_ struct{} `type:"structure"`

	// The name of the attribute within the SAML assertion to use as the email names
	// for SAML users.
	Email *string `locationName:"email" min:"1" type:"string"`

	// The name of the attribute within the SAML assertion to use as the user full
	// "friendly" names for user groups.
	Groups *string `locationName:"groups" min:"1" type:"string"`

	// The name of the attribute within the SAML assertion to use as the login names
	// for SAML users.
	Login *string `locationName:"login" min:"1" type:"string"`

	// The name of the attribute within the SAML assertion to use as the user full
	// "friendly" names for SAML users.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The name of the attribute within the SAML assertion to use as the user full
	// "friendly" names for the users' organizations.
	Org *string `locationName:"org" min:"1" type:"string"`

	// The name of the attribute within the SAML assertion to use as the user roles.
	Role *string `locationName:"role" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssertionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssertionAttributes"}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.Groups != nil && len(*s.Groups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Groups", 1))
	}
	if s.Login != nil && len(*s.Login) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Login", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Org != nil && len(*s.Org) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Org", 1))
	}
	if s.Role != nil && len(*s.Role) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *AssertionAttributes) SetEmail(v string) *AssertionAttributes {
	s.Email = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *AssertionAttributes) SetGroups(v string) *AssertionAttributes {
	s.Groups = &v
	return s
}

// SetLogin sets the Login field's value.
func (s *AssertionAttributes) SetLogin(v string) *AssertionAttributes {
	s.Login = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssertionAttributes) SetName(v string) *AssertionAttributes {
	s.Name = &v
	return s
}

// SetOrg sets the Org field's value.
func (s *AssertionAttributes) SetOrg(v string) *AssertionAttributes {
	s.Org = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AssertionAttributes) SetRole(v string) *AssertionAttributes {
	s.Role = &v
	return s
}

type AssociateLicenseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The type of license to associate with the workspace.
	//
	// LicenseType is a required field
	LicenseType *string `location:"uri" locationName:"licenseType" type:"string" required:"true" enum:"LicenseType"`

	// The ID of the workspace to associate the license with.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLicenseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLicenseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLicenseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLicenseInput"}
	if s.LicenseType == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseType"))
	}
	if s.LicenseType != nil && len(*s.LicenseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseType", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseType sets the LicenseType field's value.
func (s *AssociateLicenseInput) SetLicenseType(v string) *AssociateLicenseInput {
	s.LicenseType = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *AssociateLicenseInput) SetWorkspaceId(v string) *AssociateLicenseInput {
	s.WorkspaceId = &v
	return s
}

type AssociateLicenseOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing data about the workspace.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLicenseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLicenseOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *AssociateLicenseOutput) SetWorkspace(v *WorkspaceDescription) *AssociateLicenseOutput {
	s.Workspace = v
	return s
}

// A structure containing information about the user authentication methods
// used by the workspace.
type AuthenticationDescription struct {
	_ struct{} `type:"structure"`

	// A structure containing information about how this workspace works with IAM
	// Identity Center.
	AwsSso *AwsSsoAuthentication `locationName:"awsSso" type:"structure"`

	// Specifies whether this workspace uses IAM Identity Center, SAML, or both
	// methods to authenticate users to use the Grafana console in the Amazon Managed
	// Grafana workspace.
	//
	// Providers is a required field
	Providers []*string `locationName:"providers" type:"list" required:"true" enum:"AuthenticationProviderTypes"`

	// A structure containing information about how this workspace works with SAML,
	// including what attributes within the assertion are to be mapped to user information
	// in the workspace.
	Saml *SamlAuthentication `locationName:"saml" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationDescription) GoString() string {
	return s.String()
}

// SetAwsSso sets the AwsSso field's value.
func (s *AuthenticationDescription) SetAwsSso(v *AwsSsoAuthentication) *AuthenticationDescription {
	s.AwsSso = v
	return s
}

// SetProviders sets the Providers field's value.
func (s *AuthenticationDescription) SetProviders(v []*string) *AuthenticationDescription {
	s.Providers = v
	return s
}

// SetSaml sets the Saml field's value.
func (s *AuthenticationDescription) SetSaml(v *SamlAuthentication) *AuthenticationDescription {
	s.Saml = v
	return s
}

// A structure that describes whether the workspace uses SAML, IAM Identity
// Center, or both methods for user authentication, and whether that authentication
// is fully configured.
type AuthenticationSummary struct {
	_ struct{} `type:"structure"`

	// Specifies whether the workspace uses SAML, IAM Identity Center, or both methods
	// for user authentication.
	//
	// Providers is a required field
	Providers []*string `locationName:"providers" type:"list" required:"true" enum:"AuthenticationProviderTypes"`

	// Specifies whether the workplace's user authentication method is fully configured.
	SamlConfigurationStatus *string `locationName:"samlConfigurationStatus" type:"string" enum:"SamlConfigurationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationSummary) GoString() string {
	return s.String()
}

// SetProviders sets the Providers field's value.
func (s *AuthenticationSummary) SetProviders(v []*string) *AuthenticationSummary {
	s.Providers = v
	return s
}

// SetSamlConfigurationStatus sets the SamlConfigurationStatus field's value.
func (s *AuthenticationSummary) SetSamlConfigurationStatus(v string) *AuthenticationSummary {
	s.SamlConfigurationStatus = &v
	return s
}

// A structure containing information about how this workspace works with IAM
// Identity Center.
type AwsSsoAuthentication struct {
	_ struct{} `type:"structure"`

	// The ID of the IAM Identity Center-managed application that is created by
	// Amazon Managed Grafana.
	SsoClientId *string `locationName:"ssoClientId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsSsoAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsSsoAuthentication) GoString() string {
	return s.String()
}

// SetSsoClientId sets the SsoClientId field's value.
func (s *AwsSsoAuthentication) SetSsoClientId(v string) *AwsSsoAuthentication {
	s.SsoClientId = &v
	return s
}

// A resource was in an inconsistent state during an update or a deletion.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that is associated with the error.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that is associated with the error.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateWorkspaceApiKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the key. Keynames must be unique to the workspace.
	//
	// KeyName is a required field
	KeyName *string `locationName:"keyName" min:"1" type:"string" required:"true"`

	// Specifies the permission level of the key.
	//
	// Valid values: VIEWER|EDITOR|ADMIN
	//
	// KeyRole is a required field
	KeyRole *string `locationName:"keyRole" type:"string" required:"true"`

	// Specifies the time in seconds until the key expires. Keys can be valid for
	// up to 30 days.
	//
	// SecondsToLive is a required field
	SecondsToLive *int64 `locationName:"secondsToLive" min:"1" type:"integer" required:"true"`

	// The ID of the workspace to create an API key.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceApiKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.KeyRole == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyRole"))
	}
	if s.SecondsToLive == nil {
		invalidParams.Add(request.NewErrParamRequired("SecondsToLive"))
	}
	if s.SecondsToLive != nil && *s.SecondsToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SecondsToLive", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *CreateWorkspaceApiKeyInput) SetKeyName(v string) *CreateWorkspaceApiKeyInput {
	s.KeyName = &v
	return s
}

// SetKeyRole sets the KeyRole field's value.
func (s *CreateWorkspaceApiKeyInput) SetKeyRole(v string) *CreateWorkspaceApiKeyInput {
	s.KeyRole = &v
	return s
}

// SetSecondsToLive sets the SecondsToLive field's value.
func (s *CreateWorkspaceApiKeyInput) SetSecondsToLive(v int64) *CreateWorkspaceApiKeyInput {
	s.SecondsToLive = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceApiKeyInput) SetWorkspaceId(v string) *CreateWorkspaceApiKeyInput {
	s.WorkspaceId = &v
	return s
}

type CreateWorkspaceApiKeyOutput struct {
	_ struct{} `type:"structure"`

	// The key token. Use this value as a bearer token to authenticate HTTP requests
	// to the workspace.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceApiKeyOutput's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" sensitive:"true"`

	// The name of the key that was created.
	//
	// KeyName is a required field
	KeyName *string `locationName:"keyName" min:"1" type:"string" required:"true"`

	// The ID of the workspace that the key is valid for.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceApiKeyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *CreateWorkspaceApiKeyOutput) SetKey(v string) *CreateWorkspaceApiKeyOutput {
	s.Key = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateWorkspaceApiKeyOutput) SetKeyName(v string) *CreateWorkspaceApiKeyOutput {
	s.KeyName = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceApiKeyOutput) SetWorkspaceId(v string) *CreateWorkspaceApiKeyOutput {
	s.WorkspaceId = &v
	return s
}

type CreateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the workspace can access Amazon Web Services resources
	// in this Amazon Web Services account only, or whether it can also access Amazon
	// Web Services resources in other accounts in the same organization. If you
	// specify ORGANIZATION, you must specify which organizational units the workspace
	// can access in the workspaceOrganizationalUnits parameter.
	//
	// AccountAccessType is a required field
	AccountAccessType *string `locationName:"accountAccessType" type:"string" required:"true" enum:"AccountAccessType"`

	// Specifies whether this workspace uses SAML 2.0, IAM Identity Center (successor
	// to Single Sign-On), or both to authenticate users for using the Grafana console
	// within a workspace. For more information, see User authentication in Amazon
	// Managed Grafana (https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
	//
	// AuthenticationProviders is a required field
	AuthenticationProviders []*string `locationName:"authenticationProviders" type:"list" required:"true" enum:"AuthenticationProviderTypes"`

	// A unique, case-sensitive, user-provided identifier to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The configuration string for the workspace that you create. For more information
	// about the format and configuration options available, see Working in your
	// Grafana workspace (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
	Configuration *string `locationName:"configuration" min:"2" type:"string"`

	// Specifies the version of Grafana to support in the new workspace.
	//
	// To get a list of supported version, use the ListVersions operation.
	GrafanaVersion *string `locationName:"grafanaVersion" min:"1" type:"string"`

	// Configuration for network access to your workspace.
	//
	// When this is configured, only listed IP addresses and VPC endpoints will
	// be able to access your workspace. Standard Grafana authentication and authorization
	// will still be required.
	//
	// If this is not configured, or is removed, then all IP addresses and VPC endpoints
	// will be allowed. Standard Grafana authentication and authorization will still
	// be required.
	NetworkAccessControl *NetworkAccessConfiguration `locationName:"networkAccessControl" type:"structure"`

	// The name of an IAM role that already exists to use with Organizations to
	// access Amazon Web Services data sources and notification channels in other
	// accounts in an organization.
	//
	// OrganizationRoleName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceInput's
	// String and GoString methods.
	OrganizationRoleName *string `locationName:"organizationRoleName" min:"1" type:"string" sensitive:"true"`

	// When creating a workspace through the Amazon Web Services API, CLI or Amazon
	// Web Services CloudFormation, you must manage IAM roles and provision the
	// permissions that the workspace needs to use Amazon Web Services data sources
	// and notification channels.
	//
	// You must also specify a workspaceRoleArn for a role that you will manage
	// for the workspace to use when accessing those datasources and notification
	// channels.
	//
	// The ability for Amazon Managed Grafana to create and update IAM roles on
	// behalf of the user is supported only in the Amazon Managed Grafana console,
	// where this value may be set to SERVICE_MANAGED.
	//
	// Use only the CUSTOMER_MANAGED permission type when creating a workspace with
	// the API, CLI or Amazon Web Services CloudFormation.
	//
	// For more information, see Amazon Managed Grafana permissions and policies
	// for Amazon Web Services data sources and notification channels (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
	//
	// PermissionType is a required field
	PermissionType *string `locationName:"permissionType" type:"string" required:"true" enum:"PermissionType"`

	// The name of the CloudFormation stack set to use to generate IAM roles to
	// be used for this workspace.
	StackSetName *string `locationName:"stackSetName" type:"string"`

	// The list of tags associated with the workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The configuration settings for an Amazon VPC that contains data sources for
	// your Grafana workspace to connect to.
	//
	// Connecting to a private VPC is not yet available in the Asia Pacific (Seoul)
	// Region (ap-northeast-2).
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`

	// This parameter is for internal use only, and should not be used.
	WorkspaceDataSources []*string `locationName:"workspaceDataSources" type:"list" enum:"DataSourceType"`

	// A description for the workspace. This is used only to help you identify this
	// workspace.
	//
	// Pattern: ^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$
	//
	// WorkspaceDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceInput's
	// String and GoString methods.
	WorkspaceDescription *string `locationName:"workspaceDescription" type:"string" sensitive:"true"`

	// The name for the workspace. It does not have to be unique.
	//
	// WorkspaceName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceInput's
	// String and GoString methods.
	WorkspaceName *string `locationName:"workspaceName" type:"string" sensitive:"true"`

	// Specify the Amazon Web Services notification channels that you plan to use
	// in this workspace. Specifying these data sources here enables Amazon Managed
	// Grafana to create IAM roles and permissions that allow Amazon Managed Grafana
	// to use these channels.
	WorkspaceNotificationDestinations []*string `locationName:"workspaceNotificationDestinations" type:"list" enum:"NotificationDestinationType"`

	// Specifies the organizational units that this workspace is allowed to use
	// data sources from, if this workspace is in an account that is part of an
	// organization.
	//
	// WorkspaceOrganizationalUnits is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceInput's
	// String and GoString methods.
	WorkspaceOrganizationalUnits []*string `locationName:"workspaceOrganizationalUnits" type:"list" sensitive:"true"`

	// Specified the IAM role that grants permissions to the Amazon Web Services
	// resources that the workspace will view data from, including both data sources
	// and notification channels. You are responsible for managing the permissions
	// for this role as new data sources or notification channels are added.
	//
	// WorkspaceRoleArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWorkspaceInput's
	// String and GoString methods.
	WorkspaceRoleArn *string `locationName:"workspaceRoleArn" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceInput"}
	if s.AccountAccessType == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAccessType"))
	}
	if s.AuthenticationProviders == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationProviders"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Configuration", 2))
	}
	if s.GrafanaVersion != nil && len(*s.GrafanaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrafanaVersion", 1))
	}
	if s.OrganizationRoleName != nil && len(*s.OrganizationRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRoleName", 1))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}
	if s.WorkspaceRoleArn != nil && len(*s.WorkspaceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceRoleArn", 1))
	}
	if s.NetworkAccessControl != nil {
		if err := s.NetworkAccessControl.Validate(); err != nil {
			invalidParams.AddNested("NetworkAccessControl", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAccessType sets the AccountAccessType field's value.
func (s *CreateWorkspaceInput) SetAccountAccessType(v string) *CreateWorkspaceInput {
	s.AccountAccessType = &v
	return s
}

// SetAuthenticationProviders sets the AuthenticationProviders field's value.
func (s *CreateWorkspaceInput) SetAuthenticationProviders(v []*string) *CreateWorkspaceInput {
	s.AuthenticationProviders = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkspaceInput) SetClientToken(v string) *CreateWorkspaceInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateWorkspaceInput) SetConfiguration(v string) *CreateWorkspaceInput {
	s.Configuration = &v
	return s
}

// SetGrafanaVersion sets the GrafanaVersion field's value.
func (s *CreateWorkspaceInput) SetGrafanaVersion(v string) *CreateWorkspaceInput {
	s.GrafanaVersion = &v
	return s
}

// SetNetworkAccessControl sets the NetworkAccessControl field's value.
func (s *CreateWorkspaceInput) SetNetworkAccessControl(v *NetworkAccessConfiguration) *CreateWorkspaceInput {
	s.NetworkAccessControl = v
	return s
}

// SetOrganizationRoleName sets the OrganizationRoleName field's value.
func (s *CreateWorkspaceInput) SetOrganizationRoleName(v string) *CreateWorkspaceInput {
	s.OrganizationRoleName = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *CreateWorkspaceInput) SetPermissionType(v string) *CreateWorkspaceInput {
	s.PermissionType = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *CreateWorkspaceInput) SetStackSetName(v string) *CreateWorkspaceInput {
	s.StackSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceInput) SetTags(v map[string]*string) *CreateWorkspaceInput {
	s.Tags = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateWorkspaceInput) SetVpcConfiguration(v *VpcConfiguration) *CreateWorkspaceInput {
	s.VpcConfiguration = v
	return s
}

// SetWorkspaceDataSources sets the WorkspaceDataSources field's value.
func (s *CreateWorkspaceInput) SetWorkspaceDataSources(v []*string) *CreateWorkspaceInput {
	s.WorkspaceDataSources = v
	return s
}

// SetWorkspaceDescription sets the WorkspaceDescription field's value.
func (s *CreateWorkspaceInput) SetWorkspaceDescription(v string) *CreateWorkspaceInput {
	s.WorkspaceDescription = &v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *CreateWorkspaceInput) SetWorkspaceName(v string) *CreateWorkspaceInput {
	s.WorkspaceName = &v
	return s
}

// SetWorkspaceNotificationDestinations sets the WorkspaceNotificationDestinations field's value.
func (s *CreateWorkspaceInput) SetWorkspaceNotificationDestinations(v []*string) *CreateWorkspaceInput {
	s.WorkspaceNotificationDestinations = v
	return s
}

// SetWorkspaceOrganizationalUnits sets the WorkspaceOrganizationalUnits field's value.
func (s *CreateWorkspaceInput) SetWorkspaceOrganizationalUnits(v []*string) *CreateWorkspaceInput {
	s.WorkspaceOrganizationalUnits = v
	return s
}

// SetWorkspaceRoleArn sets the WorkspaceRoleArn field's value.
func (s *CreateWorkspaceInput) SetWorkspaceRoleArn(v string) *CreateWorkspaceInput {
	s.WorkspaceRoleArn = &v
	return s
}

type CreateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing data about the workspace that was created.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *CreateWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *CreateWorkspaceOutput {
	s.Workspace = v
	return s
}

type DeleteWorkspaceApiKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the API key to delete.
	//
	// KeyName is a required field
	KeyName *string `location:"uri" locationName:"keyName" min:"1" type:"string" required:"true"`

	// The ID of the workspace to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceApiKeyInput"}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteWorkspaceApiKeyInput) SetKeyName(v string) *DeleteWorkspaceApiKeyInput {
	s.KeyName = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceApiKeyInput) SetWorkspaceId(v string) *DeleteWorkspaceApiKeyInput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceApiKeyOutput struct {
	_ struct{} `type:"structure"`

	// The name of the key that was deleted.
	//
	// KeyName is a required field
	KeyName *string `locationName:"keyName" min:"1" type:"string" required:"true"`

	// The ID of the workspace where the key was deleted.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceApiKeyOutput) GoString() string {
	return s.String()
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteWorkspaceApiKeyOutput) SetKeyName(v string) *DeleteWorkspaceApiKeyOutput {
	s.KeyName = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceApiKeyOutput) SetWorkspaceId(v string) *DeleteWorkspaceApiKeyOutput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceInput) SetWorkspaceId(v string) *DeleteWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the workspace that was deleted.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *DeleteWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *DeleteWorkspaceOutput {
	s.Workspace = v
	return s
}

type DescribeWorkspaceAuthenticationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to return authentication information about.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAuthenticationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAuthenticationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceAuthenticationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceAuthenticationInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceAuthenticationInput) SetWorkspaceId(v string) *DescribeWorkspaceAuthenticationInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceAuthenticationOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the authentication methods used
	// in the workspace.
	//
	// Authentication is a required field
	Authentication *AuthenticationDescription `locationName:"authentication" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAuthenticationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAuthenticationOutput) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *DescribeWorkspaceAuthenticationOutput) SetAuthentication(v *AuthenticationDescription) *DescribeWorkspaceAuthenticationOutput {
	s.Authentication = v
	return s
}

type DescribeWorkspaceConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to get configuration information for.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceConfigurationInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceConfigurationInput) SetWorkspaceId(v string) *DescribeWorkspaceConfigurationInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration string for the workspace that you requested. For more information
	// about the format and configuration options available, see Working in your
	// Grafana workspace (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
	//
	// Configuration is a required field
	Configuration *string `locationName:"configuration" min:"2" type:"string" required:"true"`

	// The supported Grafana version for the workspace.
	GrafanaVersion *string `locationName:"grafanaVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeWorkspaceConfigurationOutput) SetConfiguration(v string) *DescribeWorkspaceConfigurationOutput {
	s.Configuration = &v
	return s
}

// SetGrafanaVersion sets the GrafanaVersion field's value.
func (s *DescribeWorkspaceConfigurationOutput) SetGrafanaVersion(v string) *DescribeWorkspaceConfigurationOutput {
	s.GrafanaVersion = &v
	return s
}

type DescribeWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to display information about.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceInput) SetWorkspaceId(v string) *DescribeWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the workspace.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *DescribeWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *DescribeWorkspaceOutput {
	s.Workspace = v
	return s
}

type DisassociateLicenseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The type of license to remove from the workspace.
	//
	// LicenseType is a required field
	LicenseType *string `location:"uri" locationName:"licenseType" type:"string" required:"true" enum:"LicenseType"`

	// The ID of the workspace to remove the Grafana Enterprise license from.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLicenseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLicenseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateLicenseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateLicenseInput"}
	if s.LicenseType == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseType"))
	}
	if s.LicenseType != nil && len(*s.LicenseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseType", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseType sets the LicenseType field's value.
func (s *DisassociateLicenseInput) SetLicenseType(v string) *DisassociateLicenseInput {
	s.LicenseType = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DisassociateLicenseInput) SetWorkspaceId(v string) *DisassociateLicenseInput {
	s.WorkspaceId = &v
	return s
}

type DisassociateLicenseOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the workspace.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLicenseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLicenseOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *DisassociateLicenseOutput) SetWorkspace(v *WorkspaceDescription) *DisassociateLicenseOutput {
	s.Workspace = v
	return s
}

// A structure containing the identity provider (IdP) metadata used to integrate
// the identity provider with this workspace. You can specify the metadata either
// by providing a URL to its location in the url parameter, or by specifying
// the full metadata in XML format in the xml parameter. Specifying both will
// cause an error.
type IdpMetadata struct {
	_ struct{} `type:"structure"`

	// The URL of the location containing the IdP metadata.
	Url *string `locationName:"url" min:"1" type:"string"`

	// The full IdP metadata, in XML format.
	Xml *string `locationName:"xml" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdpMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdpMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdpMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdpMetadata"}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUrl sets the Url field's value.
func (s *IdpMetadata) SetUrl(v string) *IdpMetadata {
	s.Url = &v
	return s
}

// SetXml sets the Xml field's value.
func (s *IdpMetadata) SetXml(v string) *IdpMetadata {
	s.Xml = &v
	return s
}

// Unexpected error while processing the request. Retry the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// How long to wait before you retry this operation.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) Limits the results to only the group that matches this ID.
	GroupId *string `location:"querystring" locationName:"groupId" min:"1" type:"string"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You received this
	// token from a previous ListPermissions operation.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// (Optional) Limits the results to only the user that matches this ID.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`

	// (Optional) If you specify SSO_USER, then only the permissions of IAM Identity
	// Center users are returned. If you specify SSO_GROUP, only the permissions
	// of IAM Identity Center groups are returned.
	UserType *string `location:"querystring" locationName:"userType" type:"string" enum:"UserType"`

	// The ID of the workspace to list permissions for. This parameter is required.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListPermissionsInput) SetGroupId(v string) *ListPermissionsInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ListPermissionsInput) SetUserId(v string) *ListPermissionsInput {
	s.UserId = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *ListPermissionsInput) SetUserType(v string) *ListPermissionsInput {
	s.UserType = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListPermissionsInput) SetWorkspaceId(v string) *ListPermissionsInput {
	s.WorkspaceId = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use in a subsequent ListPermissions operation to return the
	// next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The permissions returned by the operation.
	//
	// Permissions is a required field
	Permissions []*PermissionEntry `locationName:"permissions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionsOutput) SetPermissions(v []*PermissionEntry) *ListPermissionsOutput {
	s.Permissions = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource the list of tags are associated with.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags that are associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to include in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use when requesting the next set of results. You receive this
	// token from a previous ListVersions operation.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the workspace to list the available upgrade versions. If not included,
	// lists all versions of Grafana that are supported for CreateWorkspace.
	WorkspaceId *string `location:"querystring" locationName:"workspace-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVersionsInput) SetMaxResults(v int64) *ListVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsInput) SetNextToken(v string) *ListVersionsInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListVersionsInput) SetWorkspaceId(v string) *ListVersionsInput {
	s.WorkspaceId = &v
	return s
}

type ListVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The Grafana versions available to create. If a workspace ID is included in
	// the request, the Grafana versions to which this workspace can be upgraded.
	GrafanaVersions []*string `locationName:"grafanaVersions" type:"list"`

	// The token to use in a subsequent ListVersions operation to return the next
	// set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVersionsOutput) GoString() string {
	return s.String()
}

// SetGrafanaVersions sets the GrafanaVersions field's value.
func (s *ListVersionsOutput) SetGrafanaVersions(v []*string) *ListVersionsOutput {
	s.GrafanaVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVersionsOutput) SetNextToken(v string) *ListVersionsOutput {
	s.NextToken = &v
	return s
}

type ListWorkspacesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of workspaces to include in the results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of workspaces to return. (You receive this token
	// from a previous ListWorkspaces operation.)
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkspacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkspacesInput) SetMaxResults(v int64) *ListWorkspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesInput) SetNextToken(v string) *ListWorkspacesInput {
	s.NextToken = &v
	return s
}

type ListWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of workspaces.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of structures that contain some information about the workspaces
	// in the account.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceSummary `locationName:"workspaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesOutput) SetNextToken(v string) *ListWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *ListWorkspacesOutput) SetWorkspaces(v []*WorkspaceSummary) *ListWorkspacesOutput {
	s.Workspaces = v
	return s
}

// The configuration settings for in-bound network access to your workspace.
//
// When this is configured, only listed IP addresses and VPC endpoints will
// be able to access your workspace. Standard Grafana authentication and authorization
// are still required.
//
// Access is granted to a caller that is in either the IP address list or the
// VPC endpoint list - they do not need to be in both.
//
// If this is not configured, or is removed, then all IP addresses and VPC endpoints
// are allowed. Standard Grafana authentication and authorization are still
// required.
//
// While both prefixListIds and vpceIds are required, you can pass in an empty
// array of strings for either parameter if you do not want to allow any of
// that type.
//
// If both are passed as empty arrays, no traffic is allowed to the workspace,
// because only explicitly allowed connections are accepted.
type NetworkAccessConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of prefix list IDs. A prefix list is a list of CIDR ranges of IP
	// addresses. The IP addresses specified are allowed to access your workspace.
	// If the list is not included in the configuration (passed an empty array)
	// then no IP addresses are allowed to access the workspace. You create a prefix
	// list using the Amazon VPC console.
	//
	// Prefix list IDs have the format pl-1a2b3c4d .
	//
	// For more information about prefix lists, see Group CIDR blocks using managed
	// prefix lists (https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html)in
	// the Amazon Virtual Private Cloud User Guide.
	//
	// PrefixListIds is a required field
	PrefixListIds []*string `locationName:"prefixListIds" type:"list" required:"true"`

	// An array of Amazon VPC endpoint IDs for the workspace. You can create VPC
	// endpoints to your Amazon Managed Grafana workspace for access from within
	// a VPC. If a NetworkAccessConfiguration is specified then only VPC endpoints
	// specified here are allowed to access the workspace. If you pass in an empty
	// array of strings, then no VPCs are allowed to access the workspace.
	//
	// VPC endpoint IDs have the format vpce-1a2b3c4d .
	//
	// For more information about creating an interface VPC endpoint, see Interface
	// VPC endpoints (https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints)
	// in the Amazon Managed Grafana User Guide.
	//
	// The only VPC endpoints that can be specified here are interface VPC endpoints
	// for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace
	// service endpoint). Other VPC endpoints are ignored.
	//
	// VpceIds is a required field
	VpceIds []*string `locationName:"vpceIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkAccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkAccessConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkAccessConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkAccessConfiguration"}
	if s.PrefixListIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PrefixListIds"))
	}
	if s.VpceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefixListIds sets the PrefixListIds field's value.
func (s *NetworkAccessConfiguration) SetPrefixListIds(v []*string) *NetworkAccessConfiguration {
	s.PrefixListIds = v
	return s
}

// SetVpceIds sets the VpceIds field's value.
func (s *NetworkAccessConfiguration) SetVpceIds(v []*string) *NetworkAccessConfiguration {
	s.VpceIds = v
	return s
}

// A structure containing the identity of one user or group and the Admin, Editor,
// or Viewer role that they have.
type PermissionEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the user or group has the Admin, Editor, or Viewer role.
	//
	// Role is a required field
	Role *string `locationName:"role" type:"string" required:"true" enum:"Role"`

	// A structure with the ID of the user or group with this role.
	//
	// User is a required field
	User *User `locationName:"user" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionEntry) GoString() string {
	return s.String()
}

// SetRole sets the Role field's value.
func (s *PermissionEntry) SetRole(v string) *PermissionEntry {
	s.Role = &v
	return s
}

// SetUser sets the User field's value.
func (s *PermissionEntry) SetUser(v *User) *PermissionEntry {
	s.User = v
	return s
}

// The request references a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The value of a parameter in the request caused an error.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that is associated with the error.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that is associated with the error.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This structure defines which groups defined in the SAML assertion attribute
// are to be mapped to the Grafana Admin and Editor roles in the workspace.
// SAML authenticated users not part of Admin or Editor role groups have Viewer
// permission over the workspace.
type RoleValues struct {
	_ struct{} `type:"structure"`

	// A list of groups from the SAML assertion attribute to grant the Grafana Admin
	// role to.
	//
	// Admin is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RoleValues's
	// String and GoString methods.
	Admin []*string `locationName:"admin" type:"list" sensitive:"true"`

	// A list of groups from the SAML assertion attribute to grant the Grafana Editor
	// role to.
	//
	// Editor is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RoleValues's
	// String and GoString methods.
	Editor []*string `locationName:"editor" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoleValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoleValues) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *RoleValues) SetAdmin(v []*string) *RoleValues {
	s.Admin = v
	return s
}

// SetEditor sets the Editor field's value.
func (s *RoleValues) SetEditor(v []*string) *RoleValues {
	s.Editor = v
	return s
}

// A structure containing information about how this workspace works with SAML.
type SamlAuthentication struct {
	_ struct{} `type:"structure"`

	// A structure containing details about how this workspace works with SAML.
	Configuration *SamlConfiguration `locationName:"configuration" type:"structure"`

	// Specifies whether the workspace's SAML configuration is complete.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SamlConfigurationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlAuthentication) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *SamlAuthentication) SetConfiguration(v *SamlConfiguration) *SamlAuthentication {
	s.Configuration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SamlAuthentication) SetStatus(v string) *SamlAuthentication {
	s.Status = &v
	return s
}

// A structure containing information about how this workspace works with SAML.
type SamlConfiguration struct {
	_ struct{} `type:"structure"`

	// Lists which organizations defined in the SAML assertion are allowed to use
	// the Amazon Managed Grafana workspace. If this is empty, all organizations
	// in the assertion attribute have access.
	AllowedOrganizations []*string `locationName:"allowedOrganizations" type:"list"`

	// A structure that defines which attributes in the SAML assertion are to be
	// used to define information about the users authenticated by that IdP to use
	// the workspace.
	AssertionAttributes *AssertionAttributes `locationName:"assertionAttributes" type:"structure"`

	// A structure containing the identity provider (IdP) metadata used to integrate
	// the identity provider with this workspace.
	//
	// IdpMetadata is a required field
	IdpMetadata *IdpMetadata `locationName:"idpMetadata" type:"structure" required:"true"`

	// How long a sign-on session by a SAML user is valid, before the user has to
	// sign on again.
	LoginValidityDuration *int64 `locationName:"loginValidityDuration" type:"integer"`

	// A structure containing arrays that map group names in the SAML assertion
	// to the Grafana Admin and Editor roles in the workspace.
	RoleValues *RoleValues `locationName:"roleValues" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamlConfiguration"}
	if s.IdpMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("IdpMetadata"))
	}
	if s.AssertionAttributes != nil {
		if err := s.AssertionAttributes.Validate(); err != nil {
			invalidParams.AddNested("AssertionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.IdpMetadata != nil {
		if err := s.IdpMetadata.Validate(); err != nil {
			invalidParams.AddNested("IdpMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedOrganizations sets the AllowedOrganizations field's value.
func (s *SamlConfiguration) SetAllowedOrganizations(v []*string) *SamlConfiguration {
	s.AllowedOrganizations = v
	return s
}

// SetAssertionAttributes sets the AssertionAttributes field's value.
func (s *SamlConfiguration) SetAssertionAttributes(v *AssertionAttributes) *SamlConfiguration {
	s.AssertionAttributes = v
	return s
}

// SetIdpMetadata sets the IdpMetadata field's value.
func (s *SamlConfiguration) SetIdpMetadata(v *IdpMetadata) *SamlConfiguration {
	s.IdpMetadata = v
	return s
}

// SetLoginValidityDuration sets the LoginValidityDuration field's value.
func (s *SamlConfiguration) SetLoginValidityDuration(v int64) *SamlConfiguration {
	s.LoginValidityDuration = &v
	return s
}

// SetRoleValues sets the RoleValues field's value.
func (s *SamlConfiguration) SetRoleValues(v *RoleValues) *SamlConfiguration {
	s.RoleValues = v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The ID of the resource that is associated with the error.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that is associated with the error.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The value of a parameter in the request caused an error.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource the tag is associated with.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys and values to associate with the resource. You can associate
	// tag keys only, tags (key and values) only or a combination of tag keys and
	// tags.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied because of request throttling. Retry the request.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the service quota that was exceeded.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The value of a parameter in the request caused an error.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The ID of the service that is associated with the error.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource the tag association is removed from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The key values of the tag to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// A structure containing information about one error encountered while performing
// an UpdatePermissions (https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html)
// operation.
type UpdateError struct {
	_ struct{} `type:"structure"`

	// Specifies which permission update caused the error.
	//
	// CausedBy is a required field
	CausedBy *UpdateInstruction `locationName:"causedBy" type:"structure" required:"true"`

	// The error code.
	//
	// Code is a required field
	Code *int64 `locationName:"code" min:"100" type:"integer" required:"true"`

	// The message for this error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateError) GoString() string {
	return s.String()
}

// SetCausedBy sets the CausedBy field's value.
func (s *UpdateError) SetCausedBy(v *UpdateInstruction) *UpdateError {
	s.CausedBy = v
	return s
}

// SetCode sets the Code field's value.
func (s *UpdateError) SetCode(v int64) *UpdateError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UpdateError) SetMessage(v string) *UpdateError {
	s.Message = &v
	return s
}

// Contains the instructions for one Grafana role permission update in a UpdatePermissions
// (https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html)
// operation.
type UpdateInstruction struct {
	_ struct{} `type:"structure"`

	// Specifies whether this update is to add or revoke role permissions.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"UpdateAction"`

	// The role to add or revoke for the user or the group specified in users.
	//
	// Role is a required field
	Role *string `locationName:"role" type:"string" required:"true" enum:"Role"`

	// A structure that specifies the user or group to add or revoke the role for.
	//
	// Users is a required field
	Users []*User `locationName:"users" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstruction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstruction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstruction"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Users == nil {
		invalidParams.Add(request.NewErrParamRequired("Users"))
	}
	if s.Users != nil {
		for i, v := range s.Users {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Users", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateInstruction) SetAction(v string) *UpdateInstruction {
	s.Action = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateInstruction) SetRole(v string) *UpdateInstruction {
	s.Role = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *UpdateInstruction) SetUsers(v []*User) *UpdateInstruction {
	s.Users = v
	return s
}

type UpdatePermissionsInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the permission updates to make.
	//
	// UpdateInstructionBatch is a required field
	UpdateInstructionBatch []*UpdateInstruction `locationName:"updateInstructionBatch" type:"list" required:"true"`

	// The ID of the workspace to update.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePermissionsInput"}
	if s.UpdateInstructionBatch == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateInstructionBatch"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.UpdateInstructionBatch != nil {
		for i, v := range s.UpdateInstructionBatch {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateInstructionBatch", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUpdateInstructionBatch sets the UpdateInstructionBatch field's value.
func (s *UpdatePermissionsInput) SetUpdateInstructionBatch(v []*UpdateInstruction) *UpdatePermissionsInput {
	s.UpdateInstructionBatch = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdatePermissionsInput) SetWorkspaceId(v string) *UpdatePermissionsInput {
	s.WorkspaceId = &v
	return s
}

type UpdatePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the errors from the operation, if any.
	//
	// Errors is a required field
	Errors []*UpdateError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *UpdatePermissionsOutput) SetErrors(v []*UpdateError) *UpdatePermissionsOutput {
	s.Errors = v
	return s
}

type UpdateWorkspaceAuthenticationInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether this workspace uses SAML 2.0, IAM Identity Center (successor
	// to Single Sign-On), or both to authenticate users for using the Grafana console
	// within a workspace. For more information, see User authentication in Amazon
	// Managed Grafana (https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
	//
	// AuthenticationProviders is a required field
	AuthenticationProviders []*string `locationName:"authenticationProviders" type:"list" required:"true" enum:"AuthenticationProviderTypes"`

	// If the workspace uses SAML, use this structure to map SAML assertion attributes
	// to workspace user information and define which groups in the assertion attribute
	// are to have the Admin and Editor roles in the workspace.
	SamlConfiguration *SamlConfiguration `locationName:"samlConfiguration" type:"structure"`

	// The ID of the workspace to update the authentication for.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAuthenticationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAuthenticationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceAuthenticationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceAuthenticationInput"}
	if s.AuthenticationProviders == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationProviders"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.SamlConfiguration != nil {
		if err := s.SamlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SamlConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationProviders sets the AuthenticationProviders field's value.
func (s *UpdateWorkspaceAuthenticationInput) SetAuthenticationProviders(v []*string) *UpdateWorkspaceAuthenticationInput {
	s.AuthenticationProviders = v
	return s
}

// SetSamlConfiguration sets the SamlConfiguration field's value.
func (s *UpdateWorkspaceAuthenticationInput) SetSamlConfiguration(v *SamlConfiguration) *UpdateWorkspaceAuthenticationInput {
	s.SamlConfiguration = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceAuthenticationInput) SetWorkspaceId(v string) *UpdateWorkspaceAuthenticationInput {
	s.WorkspaceId = &v
	return s
}

type UpdateWorkspaceAuthenticationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that describes the user authentication for this workspace after
	// the update is made.
	//
	// Authentication is a required field
	Authentication *AuthenticationDescription `locationName:"authentication" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAuthenticationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAuthenticationOutput) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *UpdateWorkspaceAuthenticationOutput) SetAuthentication(v *AuthenticationDescription) *UpdateWorkspaceAuthenticationOutput {
	s.Authentication = v
	return s
}

type UpdateWorkspaceConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The new configuration string for the workspace. For more information about
	// the format and configuration options available, see Working in your Grafana
	// workspace (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
	//
	// Configuration is a required field
	Configuration *string `locationName:"configuration" min:"2" type:"string" required:"true"`

	// Specifies the version of Grafana to support in the new workspace.
	//
	// Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade
	// (for example, from 9.4 to 8.4).
	//
	// To know what versions are available to upgrade to for a specific workspace,
	// see the ListVersions operation.
	GrafanaVersion *string `locationName:"grafanaVersion" min:"1" type:"string"`

	// The ID of the workspace to update.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceConfigurationInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Configuration", 2))
	}
	if s.GrafanaVersion != nil && len(*s.GrafanaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrafanaVersion", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateWorkspaceConfigurationInput) SetConfiguration(v string) *UpdateWorkspaceConfigurationInput {
	s.Configuration = &v
	return s
}

// SetGrafanaVersion sets the GrafanaVersion field's value.
func (s *UpdateWorkspaceConfigurationInput) SetGrafanaVersion(v string) *UpdateWorkspaceConfigurationInput {
	s.GrafanaVersion = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceConfigurationInput) SetWorkspaceId(v string) *UpdateWorkspaceConfigurationInput {
	s.WorkspaceId = &v
	return s
}

type UpdateWorkspaceConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the workspace can access Amazon Web Services resources
	// in this Amazon Web Services account only, or whether it can also access Amazon
	// Web Services resources in other accounts in the same organization. If you
	// specify ORGANIZATION, you must specify which organizational units the workspace
	// can access in the workspaceOrganizationalUnits parameter.
	AccountAccessType *string `locationName:"accountAccessType" type:"string" enum:"AccountAccessType"`

	// The configuration settings for network access to your workspace.
	//
	// When this is configured, only listed IP addresses and VPC endpoints will
	// be able to access your workspace. Standard Grafana authentication and authorization
	// will still be required.
	//
	// If this is not configured, or is removed, then all IP addresses and VPC endpoints
	// will be allowed. Standard Grafana authentication and authorization will still
	// be required.
	NetworkAccessControl *NetworkAccessConfiguration `locationName:"networkAccessControl" type:"structure"`

	// The name of an IAM role that already exists to use to access resources through
	// Organizations. This can only be used with a workspace that has the permissionType
	// set to CUSTOMER_MANAGED.
	//
	// OrganizationRoleName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkspaceInput's
	// String and GoString methods.
	OrganizationRoleName *string `locationName:"organizationRoleName" min:"1" type:"string" sensitive:"true"`

	// Use this parameter if you want to change a workspace from SERVICE_MANAGED
	// to CUSTOMER_MANAGED. This allows you to manage the permissions that the workspace
	// uses to access datasources and notification channels. If the workspace is
	// in a member Amazon Web Services account of an organization, and that account
	// is not a delegated administrator account, and you want the workspace to access
	// data sources in other Amazon Web Services accounts in the organization, you
	// must choose CUSTOMER_MANAGED.
	//
	// If you specify this as CUSTOMER_MANAGED, you must also specify a workspaceRoleArn
	// that the workspace will use for accessing Amazon Web Services resources.
	//
	// For more information on the role and permissions needed, see Amazon Managed
	// Grafana permissions and policies for Amazon Web Services data sources and
	// notification channels (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
	//
	// Do not use this to convert a CUSTOMER_MANAGED workspace to SERVICE_MANAGED.
	// Do not include this parameter if you want to leave the workspace as SERVICE_MANAGED.
	//
	// You can convert a CUSTOMER_MANAGED workspace to SERVICE_MANAGED using the
	// Amazon Managed Grafana console. For more information, see Managing permissions
	// for data sources and notification channels (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html).
	PermissionType *string `locationName:"permissionType" type:"string" enum:"PermissionType"`

	// Whether to remove the network access configuration from the workspace.
	//
	// Setting this to true and providing a networkAccessControl to set will return
	// an error.
	//
	// If you remove this configuration by setting this to true, then all IP addresses
	// and VPC endpoints will be allowed. Standard Grafana authentication and authorization
	// will still be required.
	RemoveNetworkAccessConfiguration *bool `locationName:"removeNetworkAccessConfiguration" type:"boolean"`

	// Whether to remove the VPC configuration from the workspace.
	//
	// Setting this to true and providing a vpcConfiguration to set will return
	// an error.
	RemoveVpcConfiguration *bool `locationName:"removeVpcConfiguration" type:"boolean"`

	// The name of the CloudFormation stack set to use to generate IAM roles to
	// be used for this workspace.
	StackSetName *string `locationName:"stackSetName" type:"string"`

	// The configuration settings for an Amazon VPC that contains data sources for
	// your Grafana workspace to connect to.
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`

	// This parameter is for internal use only, and should not be used.
	WorkspaceDataSources []*string `locationName:"workspaceDataSources" type:"list" enum:"DataSourceType"`

	// A description for the workspace. This is used only to help you identify this
	// workspace.
	//
	// WorkspaceDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkspaceInput's
	// String and GoString methods.
	WorkspaceDescription *string `locationName:"workspaceDescription" type:"string" sensitive:"true"`

	// The ID of the workspace to update.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" type:"string" required:"true"`

	// A new name for the workspace to update.
	//
	// WorkspaceName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkspaceInput's
	// String and GoString methods.
	WorkspaceName *string `locationName:"workspaceName" type:"string" sensitive:"true"`

	// Specify the Amazon Web Services notification channels that you plan to use
	// in this workspace. Specifying these data sources here enables Amazon Managed
	// Grafana to create IAM roles and permissions that allow Amazon Managed Grafana
	// to use these channels.
	WorkspaceNotificationDestinations []*string `locationName:"workspaceNotificationDestinations" type:"list" enum:"NotificationDestinationType"`

	// Specifies the organizational units that this workspace is allowed to use
	// data sources from, if this workspace is in an account that is part of an
	// organization.
	//
	// WorkspaceOrganizationalUnits is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkspaceInput's
	// String and GoString methods.
	WorkspaceOrganizationalUnits []*string `locationName:"workspaceOrganizationalUnits" type:"list" sensitive:"true"`

	// Specifies an IAM role that grants permissions to Amazon Web Services resources
	// that the workspace accesses, such as data sources and notification channels.
	// If this workspace has permissionType CUSTOMER_MANAGED, then this role is
	// required.
	//
	// WorkspaceRoleArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWorkspaceInput's
	// String and GoString methods.
	WorkspaceRoleArn *string `locationName:"workspaceRoleArn" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceInput"}
	if s.OrganizationRoleName != nil && len(*s.OrganizationRoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRoleName", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.WorkspaceRoleArn != nil && len(*s.WorkspaceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceRoleArn", 1))
	}
	if s.NetworkAccessControl != nil {
		if err := s.NetworkAccessControl.Validate(); err != nil {
			invalidParams.AddNested("NetworkAccessControl", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAccessType sets the AccountAccessType field's value.
func (s *UpdateWorkspaceInput) SetAccountAccessType(v string) *UpdateWorkspaceInput {
	s.AccountAccessType = &v
	return s
}

// SetNetworkAccessControl sets the NetworkAccessControl field's value.
func (s *UpdateWorkspaceInput) SetNetworkAccessControl(v *NetworkAccessConfiguration) *UpdateWorkspaceInput {
	s.NetworkAccessControl = v
	return s
}

// SetOrganizationRoleName sets the OrganizationRoleName field's value.
func (s *UpdateWorkspaceInput) SetOrganizationRoleName(v string) *UpdateWorkspaceInput {
	s.OrganizationRoleName = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *UpdateWorkspaceInput) SetPermissionType(v string) *UpdateWorkspaceInput {
	s.PermissionType = &v
	return s
}

// SetRemoveNetworkAccessConfiguration sets the RemoveNetworkAccessConfiguration field's value.
func (s *UpdateWorkspaceInput) SetRemoveNetworkAccessConfiguration(v bool) *UpdateWorkspaceInput {
	s.RemoveNetworkAccessConfiguration = &v
	return s
}

// SetRemoveVpcConfiguration sets the RemoveVpcConfiguration field's value.
func (s *UpdateWorkspaceInput) SetRemoveVpcConfiguration(v bool) *UpdateWorkspaceInput {
	s.RemoveVpcConfiguration = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *UpdateWorkspaceInput) SetStackSetName(v string) *UpdateWorkspaceInput {
	s.StackSetName = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *UpdateWorkspaceInput) SetVpcConfiguration(v *VpcConfiguration) *UpdateWorkspaceInput {
	s.VpcConfiguration = v
	return s
}

// SetWorkspaceDataSources sets the WorkspaceDataSources field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceDataSources(v []*string) *UpdateWorkspaceInput {
	s.WorkspaceDataSources = v
	return s
}

// SetWorkspaceDescription sets the WorkspaceDescription field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceDescription(v string) *UpdateWorkspaceInput {
	s.WorkspaceDescription = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceId(v string) *UpdateWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceName(v string) *UpdateWorkspaceInput {
	s.WorkspaceName = &v
	return s
}

// SetWorkspaceNotificationDestinations sets the WorkspaceNotificationDestinations field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceNotificationDestinations(v []*string) *UpdateWorkspaceInput {
	s.WorkspaceNotificationDestinations = v
	return s
}

// SetWorkspaceOrganizationalUnits sets the WorkspaceOrganizationalUnits field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceOrganizationalUnits(v []*string) *UpdateWorkspaceInput {
	s.WorkspaceOrganizationalUnits = v
	return s
}

// SetWorkspaceRoleArn sets the WorkspaceRoleArn field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceRoleArn(v string) *UpdateWorkspaceInput {
	s.WorkspaceRoleArn = &v
	return s
}

type UpdateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing data about the workspace that was created.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *UpdateWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *UpdateWorkspaceOutput {
	s.Workspace = v
	return s
}

// A structure that specifies one user or group in the workspace.
type User struct {
	_ struct{} `type:"structure"`

	// The ID of the user or group.
	//
	// Pattern: ^([0-9a-fA-F]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Specifies whether this is a single user or a group.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"UserType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *User) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "User"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *User) SetType(v string) *User {
	s.Type = &v
	return s
}

// The value of a parameter in the request caused an error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of fields that might be associated with the error.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// A description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The reason that the operation failed.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that contains information about a request parameter that caused
// an error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message describing why this field couldn't be validated.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field that caused the validation error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The configuration settings for an Amazon VPC that contains data sources for
// your Grafana workspace to connect to.
//
// Provided securityGroupIds and subnetIds must be part of the same VPC.
//
// Connecting to a private VPC is not yet available in the Asia Pacific (Seoul)
// Region (ap-northeast-2).
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of Amazon EC2 security group IDs attached to the Amazon VPC for
	// your Grafana workspace to connect. Duplicates not allowed.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana
	// workspace to connect. Duplicates not allowed.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"2" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfiguration) SetSecurityGroupIds(v []*string) *VpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfiguration) SetSubnetIds(v []*string) *VpcConfiguration {
	s.SubnetIds = v
	return s
}

// A structure containing information about an Amazon Managed Grafana workspace
// in your account.
type WorkspaceDescription struct {
	_ struct{} `type:"structure"`

	// Specifies whether the workspace can access Amazon Web Services resources
	// in this Amazon Web Services account only, or whether it can also access Amazon
	// Web Services resources in other accounts in the same organization. If this
	// is ORGANIZATION, the workspaceOrganizationalUnits parameter specifies which
	// organizational units the workspace can access.
	AccountAccessType *string `locationName:"accountAccessType" type:"string" enum:"AccountAccessType"`

	// A structure that describes whether the workspace uses SAML, IAM Identity
	// Center, or both methods for user authentication.
	//
	// Authentication is a required field
	Authentication *AuthenticationSummary `locationName:"authentication" type:"structure" required:"true"`

	// The date that the workspace was created.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" required:"true"`

	// Specifies the Amazon Web Services data sources that have been configured
	// to have IAM roles and permissions created to allow Amazon Managed Grafana
	// to read data from these sources.
	//
	// This list is only used when the workspace was created through the Amazon
	// Web Services console, and the permissionType is SERVICE_MANAGED.
	//
	// DataSources is a required field
	DataSources []*string `locationName:"dataSources" type:"list" required:"true" enum:"DataSourceType"`

	// The user-defined description of the workspace.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceDescription's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The URL that users can use to access the Grafana console in the workspace.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" min:"1" type:"string" required:"true"`

	// Specifies whether this workspace has already fully used its free trial for
	// Grafana Enterprise.
	FreeTrialConsumed *bool `locationName:"freeTrialConsumed" type:"boolean"`

	// If this workspace is currently in the free trial period for Grafana Enterprise,
	// this value specifies when that free trial ends.
	FreeTrialExpiration *time.Time `locationName:"freeTrialExpiration" type:"timestamp"`

	// The version of Grafana supported in this workspace.
	//
	// GrafanaVersion is a required field
	GrafanaVersion *string `locationName:"grafanaVersion" min:"1" type:"string" required:"true"`

	// The unique ID of this workspace.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// If this workspace has a full Grafana Enterprise license, this specifies when
	// the license ends and will need to be renewed.
	LicenseExpiration *time.Time `locationName:"licenseExpiration" type:"timestamp"`

	// Specifies whether this workspace has a full Grafana Enterprise license or
	// a free trial license.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// The most recent date that the workspace was modified.
	//
	// Modified is a required field
	Modified *time.Time `locationName:"modified" type:"timestamp" required:"true"`

	// The name of the workspace.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceDescription's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The configuration settings for network access to your workspace.
	NetworkAccessControl *NetworkAccessConfiguration `locationName:"networkAccessControl" type:"structure"`

	// The Amazon Web Services notification channels that Amazon Managed Grafana
	// can automatically create IAM roles and permissions for, to allow Amazon Managed
	// Grafana to use these channels.
	NotificationDestinations []*string `locationName:"notificationDestinations" type:"list" enum:"NotificationDestinationType"`

	// The name of the IAM role that is used to access resources through Organizations.
	//
	// OrganizationRoleName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceDescription's
	// String and GoString methods.
	OrganizationRoleName *string `locationName:"organizationRoleName" min:"1" type:"string" sensitive:"true"`

	// Specifies the organizational units that this workspace is allowed to use
	// data sources from, if this workspace is in an account that is part of an
	// organization.
	//
	// OrganizationalUnits is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceDescription's
	// String and GoString methods.
	OrganizationalUnits []*string `locationName:"organizationalUnits" type:"list" sensitive:"true"`

	// If this is SERVICE_MANAGED, and the workplace was created through the Amazon
	// Managed Grafana console, then Amazon Managed Grafana automatically creates
	// the IAM roles and provisions the permissions that the workspace needs to
	// use Amazon Web Services data sources and notification channels.
	//
	// If this is CUSTOMER_MANAGED, you must manage those roles and permissions
	// yourself.
	//
	// If you are working with a workspace in a member account of an organization
	// and that account is not a delegated administrator account, and you want the
	// workspace to access data sources in other Amazon Web Services accounts in
	// the organization, this parameter must be set to CUSTOMER_MANAGED.
	//
	// For more information about converting between customer and service managed,
	// see Managing permissions for data sources and notification channels (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html).
	// For more information about the roles and permissions that must be managed
	// for customer managed workspaces, see Amazon Managed Grafana permissions and
	// policies for Amazon Web Services data sources and notification channels (https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
	PermissionType *string `locationName:"permissionType" type:"string" enum:"PermissionType"`

	// The name of the CloudFormation stack set that is used to generate IAM roles
	// to be used for this workspace.
	StackSetName *string `locationName:"stackSetName" type:"string"`

	// The current status of the workspace.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"WorkspaceStatus"`

	// The list of tags associated with the workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The configuration for connecting to data sources in a private VPC (Amazon
	// Virtual Private Cloud).
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`

	// The IAM role that grants permissions to the Amazon Web Services resources
	// that the workspace will view data from. This role must already exist.
	//
	// WorkspaceRoleArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceDescription's
	// String and GoString methods.
	WorkspaceRoleArn *string `locationName:"workspaceRoleArn" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) GoString() string {
	return s.String()
}

// SetAccountAccessType sets the AccountAccessType field's value.
func (s *WorkspaceDescription) SetAccountAccessType(v string) *WorkspaceDescription {
	s.AccountAccessType = &v
	return s
}

// SetAuthentication sets the Authentication field's value.
func (s *WorkspaceDescription) SetAuthentication(v *AuthenticationSummary) *WorkspaceDescription {
	s.Authentication = v
	return s
}

// SetCreated sets the Created field's value.
func (s *WorkspaceDescription) SetCreated(v time.Time) *WorkspaceDescription {
	s.Created = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *WorkspaceDescription) SetDataSources(v []*string) *WorkspaceDescription {
	s.DataSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceDescription) SetDescription(v string) *WorkspaceDescription {
	s.Description = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *WorkspaceDescription) SetEndpoint(v string) *WorkspaceDescription {
	s.Endpoint = &v
	return s
}

// SetFreeTrialConsumed sets the FreeTrialConsumed field's value.
func (s *WorkspaceDescription) SetFreeTrialConsumed(v bool) *WorkspaceDescription {
	s.FreeTrialConsumed = &v
	return s
}

// SetFreeTrialExpiration sets the FreeTrialExpiration field's value.
func (s *WorkspaceDescription) SetFreeTrialExpiration(v time.Time) *WorkspaceDescription {
	s.FreeTrialExpiration = &v
	return s
}

// SetGrafanaVersion sets the GrafanaVersion field's value.
func (s *WorkspaceDescription) SetGrafanaVersion(v string) *WorkspaceDescription {
	s.GrafanaVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *WorkspaceDescription) SetId(v string) *WorkspaceDescription {
	s.Id = &v
	return s
}

// SetLicenseExpiration sets the LicenseExpiration field's value.
func (s *WorkspaceDescription) SetLicenseExpiration(v time.Time) *WorkspaceDescription {
	s.LicenseExpiration = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *WorkspaceDescription) SetLicenseType(v string) *WorkspaceDescription {
	s.LicenseType = &v
	return s
}

// SetModified sets the Modified field's value.
func (s *WorkspaceDescription) SetModified(v time.Time) *WorkspaceDescription {
	s.Modified = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceDescription) SetName(v string) *WorkspaceDescription {
	s.Name = &v
	return s
}

// SetNetworkAccessControl sets the NetworkAccessControl field's value.
func (s *WorkspaceDescription) SetNetworkAccessControl(v *NetworkAccessConfiguration) *WorkspaceDescription {
	s.NetworkAccessControl = v
	return s
}

// SetNotificationDestinations sets the NotificationDestinations field's value.
func (s *WorkspaceDescription) SetNotificationDestinations(v []*string) *WorkspaceDescription {
	s.NotificationDestinations = v
	return s
}

// SetOrganizationRoleName sets the OrganizationRoleName field's value.
func (s *WorkspaceDescription) SetOrganizationRoleName(v string) *WorkspaceDescription {
	s.OrganizationRoleName = &v
	return s
}

// SetOrganizationalUnits sets the OrganizationalUnits field's value.
func (s *WorkspaceDescription) SetOrganizationalUnits(v []*string) *WorkspaceDescription {
	s.OrganizationalUnits = v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *WorkspaceDescription) SetPermissionType(v string) *WorkspaceDescription {
	s.PermissionType = &v
	return s
}

// SetStackSetName sets the StackSetName field's value.
func (s *WorkspaceDescription) SetStackSetName(v string) *WorkspaceDescription {
	s.StackSetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceDescription) SetStatus(v string) *WorkspaceDescription {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceDescription) SetTags(v map[string]*string) *WorkspaceDescription {
	s.Tags = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *WorkspaceDescription) SetVpcConfiguration(v *VpcConfiguration) *WorkspaceDescription {
	s.VpcConfiguration = v
	return s
}

// SetWorkspaceRoleArn sets the WorkspaceRoleArn field's value.
func (s *WorkspaceDescription) SetWorkspaceRoleArn(v string) *WorkspaceDescription {
	s.WorkspaceRoleArn = &v
	return s
}

// A structure that contains some information about one workspace in the account.
type WorkspaceSummary struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the authentication methods used
	// in the workspace.
	//
	// Authentication is a required field
	Authentication *AuthenticationSummary `locationName:"authentication" type:"structure" required:"true"`

	// The date that the workspace was created.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" required:"true"`

	// The customer-entered description of the workspace.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The URL endpoint to use to access the Grafana console in the workspace.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" min:"1" type:"string" required:"true"`

	// The Grafana version that the workspace is running.
	//
	// GrafanaVersion is a required field
	GrafanaVersion *string `locationName:"grafanaVersion" min:"1" type:"string" required:"true"`

	// The unique ID of the workspace.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The most recent date that the workspace was modified.
	//
	// Modified is a required field
	Modified *time.Time `locationName:"modified" type:"timestamp" required:"true"`

	// The name of the workspace.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WorkspaceSummary's
	// String and GoString methods.
	Name *string `locationName:"name" type:"string" sensitive:"true"`

	// The Amazon Web Services notification channels that Amazon Managed Grafana
	// can automatically create IAM roles and permissions for, which allows Amazon
	// Managed Grafana to use these channels.
	NotificationDestinations []*string `locationName:"notificationDestinations" type:"list" enum:"NotificationDestinationType"`

	// The current status of the workspace.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"WorkspaceStatus"`

	// The list of tags associated with the workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) GoString() string {
	return s.String()
}

// SetAuthentication sets the Authentication field's value.
func (s *WorkspaceSummary) SetAuthentication(v *AuthenticationSummary) *WorkspaceSummary {
	s.Authentication = v
	return s
}

// SetCreated sets the Created field's value.
func (s *WorkspaceSummary) SetCreated(v time.Time) *WorkspaceSummary {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceSummary) SetDescription(v string) *WorkspaceSummary {
	s.Description = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *WorkspaceSummary) SetEndpoint(v string) *WorkspaceSummary {
	s.Endpoint = &v
	return s
}

// SetGrafanaVersion sets the GrafanaVersion field's value.
func (s *WorkspaceSummary) SetGrafanaVersion(v string) *WorkspaceSummary {
	s.GrafanaVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *WorkspaceSummary) SetId(v string) *WorkspaceSummary {
	s.Id = &v
	return s
}

// SetModified sets the Modified field's value.
func (s *WorkspaceSummary) SetModified(v time.Time) *WorkspaceSummary {
	s.Modified = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceSummary) SetName(v string) *WorkspaceSummary {
	s.Name = &v
	return s
}

// SetNotificationDestinations sets the NotificationDestinations field's value.
func (s *WorkspaceSummary) SetNotificationDestinations(v []*string) *WorkspaceSummary {
	s.NotificationDestinations = v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceSummary) SetStatus(v string) *WorkspaceSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceSummary) SetTags(v map[string]*string) *WorkspaceSummary {
	s.Tags = v
	return s
}

const (
	// AccountAccessTypeCurrentAccount is a AccountAccessType enum value
	AccountAccessTypeCurrentAccount = "CURRENT_ACCOUNT"

	// AccountAccessTypeOrganization is a AccountAccessType enum value
	AccountAccessTypeOrganization = "ORGANIZATION"
)

// AccountAccessType_Values returns all elements of the AccountAccessType enum
func AccountAccessType_Values() []string {
	return []string{
		AccountAccessTypeCurrentAccount,
		AccountAccessTypeOrganization,
	}
}

const (
	// AuthenticationProviderTypesAwsSso is a AuthenticationProviderTypes enum value
	AuthenticationProviderTypesAwsSso = "AWS_SSO"

	// AuthenticationProviderTypesSaml is a AuthenticationProviderTypes enum value
	AuthenticationProviderTypesSaml = "SAML"
)

// AuthenticationProviderTypes_Values returns all elements of the AuthenticationProviderTypes enum
func AuthenticationProviderTypes_Values() []string {
	return []string{
		AuthenticationProviderTypesAwsSso,
		AuthenticationProviderTypesSaml,
	}
}

const (
	// DataSourceTypeAmazonOpensearchService is a DataSourceType enum value
	DataSourceTypeAmazonOpensearchService = "AMAZON_OPENSEARCH_SERVICE"

	// DataSourceTypeCloudwatch is a DataSourceType enum value
	DataSourceTypeCloudwatch = "CLOUDWATCH"

	// DataSourceTypePrometheus is a DataSourceType enum value
	DataSourceTypePrometheus = "PROMETHEUS"

	// DataSourceTypeXray is a DataSourceType enum value
	DataSourceTypeXray = "XRAY"

	// DataSourceTypeTimestream is a DataSourceType enum value
	DataSourceTypeTimestream = "TIMESTREAM"

	// DataSourceTypeSitewise is a DataSourceType enum value
	DataSourceTypeSitewise = "SITEWISE"

	// DataSourceTypeAthena is a DataSourceType enum value
	DataSourceTypeAthena = "ATHENA"

	// DataSourceTypeRedshift is a DataSourceType enum value
	DataSourceTypeRedshift = "REDSHIFT"

	// DataSourceTypeTwinmaker is a DataSourceType enum value
	DataSourceTypeTwinmaker = "TWINMAKER"
)

// DataSourceType_Values returns all elements of the DataSourceType enum
func DataSourceType_Values() []string {
	return []string{
		DataSourceTypeAmazonOpensearchService,
		DataSourceTypeCloudwatch,
		DataSourceTypePrometheus,
		DataSourceTypeXray,
		DataSourceTypeTimestream,
		DataSourceTypeSitewise,
		DataSourceTypeAthena,
		DataSourceTypeRedshift,
		DataSourceTypeTwinmaker,
	}
}

const (
	// LicenseTypeEnterprise is a LicenseType enum value
	LicenseTypeEnterprise = "ENTERPRISE"

	// LicenseTypeEnterpriseFreeTrial is a LicenseType enum value
	LicenseTypeEnterpriseFreeTrial = "ENTERPRISE_FREE_TRIAL"
)

// LicenseType_Values returns all elements of the LicenseType enum
func LicenseType_Values() []string {
	return []string{
		LicenseTypeEnterprise,
		LicenseTypeEnterpriseFreeTrial,
	}
}

const (
	// NotificationDestinationTypeSns is a NotificationDestinationType enum value
	NotificationDestinationTypeSns = "SNS"
)

// NotificationDestinationType_Values returns all elements of the NotificationDestinationType enum
func NotificationDestinationType_Values() []string {
	return []string{
		NotificationDestinationTypeSns,
	}
}

const (
	// PermissionTypeCustomerManaged is a PermissionType enum value
	PermissionTypeCustomerManaged = "CUSTOMER_MANAGED"

	// PermissionTypeServiceManaged is a PermissionType enum value
	PermissionTypeServiceManaged = "SERVICE_MANAGED"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeCustomerManaged,
		PermissionTypeServiceManaged,
	}
}

const (
	// RoleAdmin is a Role enum value
	RoleAdmin = "ADMIN"

	// RoleEditor is a Role enum value
	RoleEditor = "EDITOR"

	// RoleViewer is a Role enum value
	RoleViewer = "VIEWER"
)

// Role_Values returns all elements of the Role enum
func Role_Values() []string {
	return []string{
		RoleAdmin,
		RoleEditor,
		RoleViewer,
	}
}

const (
	// SamlConfigurationStatusConfigured is a SamlConfigurationStatus enum value
	SamlConfigurationStatusConfigured = "CONFIGURED"

	// SamlConfigurationStatusNotConfigured is a SamlConfigurationStatus enum value
	SamlConfigurationStatusNotConfigured = "NOT_CONFIGURED"
)

// SamlConfigurationStatus_Values returns all elements of the SamlConfigurationStatus enum
func SamlConfigurationStatus_Values() []string {
	return []string{
		SamlConfigurationStatusConfigured,
		SamlConfigurationStatusNotConfigured,
	}
}

const (
	// UpdateActionAdd is a UpdateAction enum value
	UpdateActionAdd = "ADD"

	// UpdateActionRevoke is a UpdateAction enum value
	UpdateActionRevoke = "REVOKE"
)

// UpdateAction_Values returns all elements of the UpdateAction enum
func UpdateAction_Values() []string {
	return []string{
		UpdateActionAdd,
		UpdateActionRevoke,
	}
}

const (
	// UserTypeSsoUser is a UserType enum value
	UserTypeSsoUser = "SSO_USER"

	// UserTypeSsoGroup is a UserType enum value
	UserTypeSsoGroup = "SSO_GROUP"
)

// UserType_Values returns all elements of the UserType enum
func UserType_Values() []string {
	return []string{
		UserTypeSsoUser,
		UserTypeSsoGroup,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

const (
	// WorkspaceStatusActive is a WorkspaceStatus enum value
	WorkspaceStatusActive = "ACTIVE"

	// WorkspaceStatusCreating is a WorkspaceStatus enum value
	WorkspaceStatusCreating = "CREATING"

	// WorkspaceStatusDeleting is a WorkspaceStatus enum value
	WorkspaceStatusDeleting = "DELETING"

	// WorkspaceStatusFailed is a WorkspaceStatus enum value
	WorkspaceStatusFailed = "FAILED"

	// WorkspaceStatusUpdating is a WorkspaceStatus enum value
	WorkspaceStatusUpdating = "UPDATING"

	// WorkspaceStatusUpgrading is a WorkspaceStatus enum value
	WorkspaceStatusUpgrading = "UPGRADING"

	// WorkspaceStatusDeletionFailed is a WorkspaceStatus enum value
	WorkspaceStatusDeletionFailed = "DELETION_FAILED"

	// WorkspaceStatusCreationFailed is a WorkspaceStatus enum value
	WorkspaceStatusCreationFailed = "CREATION_FAILED"

	// WorkspaceStatusUpdateFailed is a WorkspaceStatus enum value
	WorkspaceStatusUpdateFailed = "UPDATE_FAILED"

	// WorkspaceStatusUpgradeFailed is a WorkspaceStatus enum value
	WorkspaceStatusUpgradeFailed = "UPGRADE_FAILED"

	// WorkspaceStatusLicenseRemovalFailed is a WorkspaceStatus enum value
	WorkspaceStatusLicenseRemovalFailed = "LICENSE_REMOVAL_FAILED"

	// WorkspaceStatusVersionUpdating is a WorkspaceStatus enum value
	WorkspaceStatusVersionUpdating = "VERSION_UPDATING"

	// WorkspaceStatusVersionUpdateFailed is a WorkspaceStatus enum value
	WorkspaceStatusVersionUpdateFailed = "VERSION_UPDATE_FAILED"
)

// WorkspaceStatus_Values returns all elements of the WorkspaceStatus enum
func WorkspaceStatus_Values() []string {
	return []string{
		WorkspaceStatusActive,
		WorkspaceStatusCreating,
		WorkspaceStatusDeleting,
		WorkspaceStatusFailed,
		WorkspaceStatusUpdating,
		WorkspaceStatusUpgrading,
		WorkspaceStatusDeletionFailed,
		WorkspaceStatusCreationFailed,
		WorkspaceStatusUpdateFailed,
		WorkspaceStatusUpgradeFailed,
		WorkspaceStatusLicenseRemovalFailed,
		WorkspaceStatusVersionUpdating,
		WorkspaceStatusVersionUpdateFailed,
	}
}
