// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package detective

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptInvitationRequest method.
//	req, resp := client.AcceptInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/AcceptInvitation
func (c *Detective) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "PUT",
		HTTPPath:   "/invitation",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for Amazon Detective.
//
// Accepts an invitation for the member account to contribute data to a behavior
// graph. This operation can only be called by an invited member account.
//
// The request provides the ARN of behavior graph.
//
// The member account status in the graph must be INVITED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/AcceptInvitation
func (c *Detective) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetGraphMemberDatasources = "BatchGetGraphMemberDatasources"

// BatchGetGraphMemberDatasourcesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetGraphMemberDatasources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetGraphMemberDatasources for more information on using the BatchGetGraphMemberDatasources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetGraphMemberDatasourcesRequest method.
//	req, resp := client.BatchGetGraphMemberDatasourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/BatchGetGraphMemberDatasources
func (c *Detective) BatchGetGraphMemberDatasourcesRequest(input *BatchGetGraphMemberDatasourcesInput) (req *request.Request, output *BatchGetGraphMemberDatasourcesOutput) {
	op := &request.Operation{
		Name:       opBatchGetGraphMemberDatasources,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/datasources/get",
	}

	if input == nil {
		input = &BatchGetGraphMemberDatasourcesInput{}
	}

	output = &BatchGetGraphMemberDatasourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetGraphMemberDatasources API operation for Amazon Detective.
//
// Gets data source package information for the behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation BatchGetGraphMemberDatasources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/BatchGetGraphMemberDatasources
func (c *Detective) BatchGetGraphMemberDatasources(input *BatchGetGraphMemberDatasourcesInput) (*BatchGetGraphMemberDatasourcesOutput, error) {
	req, out := c.BatchGetGraphMemberDatasourcesRequest(input)
	return out, req.Send()
}

// BatchGetGraphMemberDatasourcesWithContext is the same as BatchGetGraphMemberDatasources with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetGraphMemberDatasources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) BatchGetGraphMemberDatasourcesWithContext(ctx aws.Context, input *BatchGetGraphMemberDatasourcesInput, opts ...request.Option) (*BatchGetGraphMemberDatasourcesOutput, error) {
	req, out := c.BatchGetGraphMemberDatasourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetMembershipDatasources = "BatchGetMembershipDatasources"

// BatchGetMembershipDatasourcesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetMembershipDatasources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetMembershipDatasources for more information on using the BatchGetMembershipDatasources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetMembershipDatasourcesRequest method.
//	req, resp := client.BatchGetMembershipDatasourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/BatchGetMembershipDatasources
func (c *Detective) BatchGetMembershipDatasourcesRequest(input *BatchGetMembershipDatasourcesInput) (req *request.Request, output *BatchGetMembershipDatasourcesOutput) {
	op := &request.Operation{
		Name:       opBatchGetMembershipDatasources,
		HTTPMethod: "POST",
		HTTPPath:   "/membership/datasources/get",
	}

	if input == nil {
		input = &BatchGetMembershipDatasourcesInput{}
	}

	output = &BatchGetMembershipDatasourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetMembershipDatasources API operation for Amazon Detective.
//
// Gets information on the data source package history for an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation BatchGetMembershipDatasources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/BatchGetMembershipDatasources
func (c *Detective) BatchGetMembershipDatasources(input *BatchGetMembershipDatasourcesInput) (*BatchGetMembershipDatasourcesOutput, error) {
	req, out := c.BatchGetMembershipDatasourcesRequest(input)
	return out, req.Send()
}

// BatchGetMembershipDatasourcesWithContext is the same as BatchGetMembershipDatasources with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetMembershipDatasources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) BatchGetMembershipDatasourcesWithContext(ctx aws.Context, input *BatchGetMembershipDatasourcesInput, opts ...request.Option) (*BatchGetMembershipDatasourcesOutput, error) {
	req, out := c.BatchGetMembershipDatasourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGraph = "CreateGraph"

// CreateGraphRequest generates a "aws/request.Request" representing the
// client's request for the CreateGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGraph for more information on using the CreateGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGraphRequest method.
//	req, resp := client.CreateGraphRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateGraph
func (c *Detective) CreateGraphRequest(input *CreateGraphInput) (req *request.Request, output *CreateGraphOutput) {
	op := &request.Operation{
		Name:       opCreateGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/graph",
	}

	if input == nil {
		input = &CreateGraphInput{}
	}

	output = &CreateGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGraph API operation for Amazon Detective.
//
// Creates a new behavior graph for the calling account, and sets that account
// as the administrator account. This operation is called by the account that
// is enabling Detective.
//
// Before you try to enable Detective, make sure that your account has been
// enrolled in Amazon GuardDuty for at least 48 hours. If you do not meet this
// requirement, you cannot enable Detective. If you do meet the GuardDuty prerequisite,
// then when you make the request to enable Detective, it checks whether your
// data volume is within the Detective quota. If it exceeds the quota, then
// you cannot enable Detective.
//
// The operation also enables Detective for the calling account in the currently
// selected Region. It returns the ARN of the new behavior graph.
//
// CreateGraph triggers a process to create the corresponding data tables for
// the new behavior graph.
//
// An account can only be the administrator account for one behavior graph within
// a Region. If the same account calls CreateGraph with the same administrator
// account, it always returns the same behavior graph ARN. It does not create
// a new behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation CreateGraph for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ServiceQuotaExceededException
//     This request cannot be completed for one of the following reasons.
//
//   - The request would cause the number of member accounts in the behavior
//     graph to exceed the maximum allowed. A behavior graph cannot have more
//     than 1200 member accounts.
//
//   - The request would cause the data rate for the behavior graph to exceed
//     the maximum allowed.
//
//   - Detective is unable to verify the data rate for the member account.
//     This is usually because the member account is not enrolled in Amazon GuardDuty.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateGraph
func (c *Detective) CreateGraph(input *CreateGraphInput) (*CreateGraphOutput, error) {
	req, out := c.CreateGraphRequest(input)
	return out, req.Send()
}

// CreateGraphWithContext is the same as CreateGraph with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) CreateGraphWithContext(ctx aws.Context, input *CreateGraphInput, opts ...request.Option) (*CreateGraphOutput, error) {
	req, out := c.CreateGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMembersRequest method.
//	req, resp := client.CreateMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateMembers
func (c *Detective) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for Amazon Detective.
//
// CreateMembers is used to send invitations to accounts. For the organization
// behavior graph, the Detective administrator account uses CreateMembers to
// enable organization accounts as member accounts.
//
// For invited accounts, CreateMembers sends a request to invite the specified
// Amazon Web Services accounts to be member accounts in the behavior graph.
// This operation can only be called by the administrator account for a behavior
// graph.
//
// CreateMembers verifies the accounts and then invites the verified accounts.
// The administrator can optionally specify to not send invitation emails to
// the member accounts. This would be used when the administrator manages their
// member accounts centrally.
//
// For organization accounts in the organization behavior graph, CreateMembers
// attempts to enable the accounts. The organization accounts do not receive
// invitations.
//
// The request provides the behavior graph ARN and the list of accounts to invite
// or to enable.
//
// The response separates the requested accounts into two lists:
//
//   - The accounts that CreateMembers was able to process. For invited accounts,
//     includes member accounts that are being verified, that have passed verification
//     and are to be invited, and that have failed verification. For organization
//     accounts in the organization behavior graph, includes accounts that can
//     be enabled and that cannot be enabled.
//
//   - The accounts that CreateMembers was unable to process. This list includes
//     accounts that were already invited to be member accounts in the behavior
//     graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ServiceQuotaExceededException
//     This request cannot be completed for one of the following reasons.
//
//   - The request would cause the number of member accounts in the behavior
//     graph to exceed the maximum allowed. A behavior graph cannot have more
//     than 1200 member accounts.
//
//   - The request would cause the data rate for the behavior graph to exceed
//     the maximum allowed.
//
//   - Detective is unable to verify the data rate for the member account.
//     This is usually because the member account is not enrolled in Amazon GuardDuty.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateMembers
func (c *Detective) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGraph = "DeleteGraph"

// DeleteGraphRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGraph for more information on using the DeleteGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGraphRequest method.
//	req, resp := client.DeleteGraphRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteGraph
func (c *Detective) DeleteGraphRequest(input *DeleteGraphInput) (req *request.Request, output *DeleteGraphOutput) {
	op := &request.Operation{
		Name:       opDeleteGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/removal",
	}

	if input == nil {
		input = &DeleteGraphInput{}
	}

	output = &DeleteGraphOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGraph API operation for Amazon Detective.
//
// Disables the specified behavior graph and queues it to be deleted. This operation
// removes the behavior graph from each member account's list of behavior graphs.
//
// DeleteGraph can only be called by the administrator account for a behavior
// graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DeleteGraph for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteGraph
func (c *Detective) DeleteGraph(input *DeleteGraphInput) (*DeleteGraphOutput, error) {
	req, out := c.DeleteGraphRequest(input)
	return out, req.Send()
}

// DeleteGraphWithContext is the same as DeleteGraph with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DeleteGraphWithContext(ctx aws.Context, input *DeleteGraphInput, opts ...request.Option) (*DeleteGraphOutput, error) {
	req, out := c.DeleteGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMembersRequest method.
//	req, resp := client.DeleteMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteMembers
func (c *Detective) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/removal",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for Amazon Detective.
//
// Removes the specified member accounts from the behavior graph. The removed
// accounts no longer contribute data to the behavior graph. This operation
// can only be called by the administrator account for the behavior graph.
//
// For invited accounts, the removed accounts are deleted from the list of accounts
// in the behavior graph. To restore the account, the administrator account
// must send another invitation.
//
// For organization accounts in the organization behavior graph, the Detective
// administrator account can always enable the organization account again. Organization
// accounts that are not enabled as member accounts are not included in the
// ListMembers results for the organization behavior graph.
//
// An administrator account cannot use DeleteMembers to remove their own account
// from the behavior graph. To disable a behavior graph, the administrator account
// uses the DeleteGraph API method.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteMembers
func (c *Detective) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOrganizationConfigurationRequest method.
//	req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DescribeOrganizationConfiguration
func (c *Detective) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/orgs/describeOrganizationConfiguration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for Amazon Detective.
//
// Returns information about the configuration for the organization behavior
// graph. Currently indicates whether to automatically enable new organization
// accounts as member accounts.
//
// Can only be called by the Detective administrator account for the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DescribeOrganizationConfiguration
func (c *Detective) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableOrganizationAdminAccountRequest method.
//	req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisableOrganizationAdminAccount
func (c *Detective) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/orgs/disableAdminAccount",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for Amazon Detective.
//
// Removes the Detective administrator account in the current Region. Deletes
// the organization behavior graph.
//
// Can only be called by the organization management account.
//
// Removing the Detective administrator account does not affect the delegated
// administrator account for Detective in Organizations.
//
// To remove the delegated administrator account in Organizations, use the Organizations
// API. Removing the delegated administrator account also removes the Detective
// administrator account in all Regions, except for Regions where the Detective
// administrator account is the organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisableOrganizationAdminAccount
func (c *Detective) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembership = "DisassociateMembership"

// DisassociateMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembership for more information on using the DisassociateMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMembershipRequest method.
//	req, resp := client.DisassociateMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisassociateMembership
func (c *Detective) DisassociateMembershipRequest(input *DisassociateMembershipInput) (req *request.Request, output *DisassociateMembershipOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/membership/removal",
	}

	if input == nil {
		input = &DisassociateMembershipInput{}
	}

	output = &DisassociateMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembership API operation for Amazon Detective.
//
// Removes the member account from the specified behavior graph. This operation
// can only be called by an invited member account that has the ENABLED status.
//
// DisassociateMembership cannot be called by an organization account in the
// organization behavior graph. For the organization behavior graph, the Detective
// administrator account determines which organization accounts to enable or
// disable as member accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DisassociateMembership for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisassociateMembership
func (c *Detective) DisassociateMembership(input *DisassociateMembershipInput) (*DisassociateMembershipOutput, error) {
	req, out := c.DisassociateMembershipRequest(input)
	return out, req.Send()
}

// DisassociateMembershipWithContext is the same as DisassociateMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DisassociateMembershipWithContext(ctx aws.Context, input *DisassociateMembershipInput, opts ...request.Option) (*DisassociateMembershipOutput, error) {
	req, out := c.DisassociateMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableOrganizationAdminAccountRequest method.
//	req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/EnableOrganizationAdminAccount
func (c *Detective) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/orgs/enableAdminAccount",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for Amazon Detective.
//
// Designates the Detective administrator account for the organization in the
// current Region.
//
// If the account does not have Detective enabled, then enables Detective for
// that account and creates a new behavior graph.
//
// Can only be called by the organization management account.
//
// If the organization has a delegated administrator account in Organizations,
// then the Detective administrator account must be either the delegated administrator
// account or the organization management account.
//
// If the organization does not have a delegated administrator account in Organizations,
// then you can choose any account in the organization. If you choose an account
// other than the organization management account, Detective calls Organizations
// to make that account the delegated administrator account for Detective. The
// organization management account cannot be the delegated administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/EnableOrganizationAdminAccount
func (c *Detective) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvestigation = "GetInvestigation"

// GetInvestigationRequest generates a "aws/request.Request" representing the
// client's request for the GetInvestigation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvestigation for more information on using the GetInvestigation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInvestigationRequest method.
//	req, resp := client.GetInvestigationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetInvestigation
func (c *Detective) GetInvestigationRequest(input *GetInvestigationInput) (req *request.Request, output *GetInvestigationOutput) {
	op := &request.Operation{
		Name:       opGetInvestigation,
		HTTPMethod: "POST",
		HTTPPath:   "/investigations/getInvestigation",
	}

	if input == nil {
		input = &GetInvestigationInput{}
	}

	output = &GetInvestigationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvestigation API operation for Amazon Detective.
//
// Returns the investigation results of an investigation for a behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation GetInvestigation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetInvestigation
func (c *Detective) GetInvestigation(input *GetInvestigationInput) (*GetInvestigationOutput, error) {
	req, out := c.GetInvestigationRequest(input)
	return out, req.Send()
}

// GetInvestigationWithContext is the same as GetInvestigation with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvestigation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) GetInvestigationWithContext(ctx aws.Context, input *GetInvestigationInput, opts ...request.Option) (*GetInvestigationOutput, error) {
	req, out := c.GetInvestigationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMembersRequest method.
//	req, resp := client.GetMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetMembers
func (c *Detective) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for Amazon Detective.
//
// Returns the membership details for specified member accounts for a behavior
// graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetMembers
func (c *Detective) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasourcePackages = "ListDatasourcePackages"

// ListDatasourcePackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasourcePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasourcePackages for more information on using the ListDatasourcePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasourcePackagesRequest method.
//	req, resp := client.ListDatasourcePackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListDatasourcePackages
func (c *Detective) ListDatasourcePackagesRequest(input *ListDatasourcePackagesInput) (req *request.Request, output *ListDatasourcePackagesOutput) {
	op := &request.Operation{
		Name:       opListDatasourcePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/datasources/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasourcePackagesInput{}
	}

	output = &ListDatasourcePackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasourcePackages API operation for Amazon Detective.
//
// Lists data source packages in the behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListDatasourcePackages for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListDatasourcePackages
func (c *Detective) ListDatasourcePackages(input *ListDatasourcePackagesInput) (*ListDatasourcePackagesOutput, error) {
	req, out := c.ListDatasourcePackagesRequest(input)
	return out, req.Send()
}

// ListDatasourcePackagesWithContext is the same as ListDatasourcePackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasourcePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListDatasourcePackagesWithContext(ctx aws.Context, input *ListDatasourcePackagesInput, opts ...request.Option) (*ListDatasourcePackagesOutput, error) {
	req, out := c.ListDatasourcePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasourcePackagesPages iterates over the pages of a ListDatasourcePackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasourcePackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasourcePackages operation.
//	pageNum := 0
//	err := client.ListDatasourcePackagesPages(params,
//	    func(page *detective.ListDatasourcePackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Detective) ListDatasourcePackagesPages(input *ListDatasourcePackagesInput, fn func(*ListDatasourcePackagesOutput, bool) bool) error {
	return c.ListDatasourcePackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasourcePackagesPagesWithContext same as ListDatasourcePackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListDatasourcePackagesPagesWithContext(ctx aws.Context, input *ListDatasourcePackagesInput, fn func(*ListDatasourcePackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasourcePackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasourcePackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasourcePackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGraphs = "ListGraphs"

// ListGraphsRequest generates a "aws/request.Request" representing the
// client's request for the ListGraphs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGraphs for more information on using the ListGraphs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGraphsRequest method.
//	req, resp := client.ListGraphsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListGraphs
func (c *Detective) ListGraphsRequest(input *ListGraphsInput) (req *request.Request, output *ListGraphsOutput) {
	op := &request.Operation{
		Name:       opListGraphs,
		HTTPMethod: "POST",
		HTTPPath:   "/graphs/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGraphsInput{}
	}

	output = &ListGraphsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGraphs API operation for Amazon Detective.
//
// Returns the list of behavior graphs that the calling account is an administrator
// account of. This operation can only be called by an administrator account.
//
// Because an account can currently only be the administrator of one behavior
// graph within a Region, the results always contain a single behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListGraphs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListGraphs
func (c *Detective) ListGraphs(input *ListGraphsInput) (*ListGraphsOutput, error) {
	req, out := c.ListGraphsRequest(input)
	return out, req.Send()
}

// ListGraphsWithContext is the same as ListGraphs with the addition of
// the ability to pass a context and additional request options.
//
// See ListGraphs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListGraphsWithContext(ctx aws.Context, input *ListGraphsInput, opts ...request.Option) (*ListGraphsOutput, error) {
	req, out := c.ListGraphsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGraphsPages iterates over the pages of a ListGraphs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGraphs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGraphs operation.
//	pageNum := 0
//	err := client.ListGraphsPages(params,
//	    func(page *detective.ListGraphsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Detective) ListGraphsPages(input *ListGraphsInput, fn func(*ListGraphsOutput, bool) bool) error {
	return c.ListGraphsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGraphsPagesWithContext same as ListGraphsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListGraphsPagesWithContext(ctx aws.Context, input *ListGraphsInput, fn func(*ListGraphsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGraphsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGraphsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGraphsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIndicators = "ListIndicators"

// ListIndicatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListIndicators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndicators for more information on using the ListIndicators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIndicatorsRequest method.
//	req, resp := client.ListIndicatorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListIndicators
func (c *Detective) ListIndicatorsRequest(input *ListIndicatorsInput) (req *request.Request, output *ListIndicatorsOutput) {
	op := &request.Operation{
		Name:       opListIndicators,
		HTTPMethod: "POST",
		HTTPPath:   "/investigations/listIndicators",
	}

	if input == nil {
		input = &ListIndicatorsInput{}
	}

	output = &ListIndicatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndicators API operation for Amazon Detective.
//
// # Get the indicators from an investigation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListIndicators for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListIndicators
func (c *Detective) ListIndicators(input *ListIndicatorsInput) (*ListIndicatorsOutput, error) {
	req, out := c.ListIndicatorsRequest(input)
	return out, req.Send()
}

// ListIndicatorsWithContext is the same as ListIndicators with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndicators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListIndicatorsWithContext(ctx aws.Context, input *ListIndicatorsInput, opts ...request.Option) (*ListIndicatorsOutput, error) {
	req, out := c.ListIndicatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInvestigations = "ListInvestigations"

// ListInvestigationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvestigations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvestigations for more information on using the ListInvestigations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInvestigationsRequest method.
//	req, resp := client.ListInvestigationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvestigations
func (c *Detective) ListInvestigationsRequest(input *ListInvestigationsInput) (req *request.Request, output *ListInvestigationsOutput) {
	op := &request.Operation{
		Name:       opListInvestigations,
		HTTPMethod: "POST",
		HTTPPath:   "/investigations/listInvestigations",
	}

	if input == nil {
		input = &ListInvestigationsInput{}
	}

	output = &ListInvestigationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvestigations API operation for Amazon Detective.
//
// List all Investigations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListInvestigations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvestigations
func (c *Detective) ListInvestigations(input *ListInvestigationsInput) (*ListInvestigationsOutput, error) {
	req, out := c.ListInvestigationsRequest(input)
	return out, req.Send()
}

// ListInvestigationsWithContext is the same as ListInvestigations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvestigations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListInvestigationsWithContext(ctx aws.Context, input *ListInvestigationsInput, opts ...request.Option) (*ListInvestigationsOutput, error) {
	req, out := c.ListInvestigationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInvitationsRequest method.
//	req, resp := client.ListInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvitations
func (c *Detective) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon Detective.
//
// Retrieves the list of open and accepted behavior graph invitations for the
// member account. This operation can only be called by an invited member account.
//
// Open invitations are invitations that the member account has not responded
// to.
//
// The results do not include behavior graphs for which the member account declined
// the invitation. The results also do not include behavior graphs that the
// member account resigned from or was removed from.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvitations
func (c *Detective) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInvitations operation.
//	pageNum := 0
//	err := client.ListInvitationsPages(params,
//	    func(page *detective.ListInvitationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Detective) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMembersRequest method.
//	req, resp := client.ListMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListMembers
func (c *Detective) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon Detective.
//
// Retrieves the list of member accounts for a behavior graph.
//
// For invited accounts, the results do not include member accounts that were
// removed from the behavior graph.
//
// For the organization behavior graph, the results do not include organization
// accounts that the Detective administrator account has not enabled as member
// accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListMembers
func (c *Detective) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMembers operation.
//	pageNum := 0
//	err := client.ListMembersPages(params,
//	    func(page *detective.ListMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Detective) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationAdminAccountsRequest method.
//	req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListOrganizationAdminAccounts
func (c *Detective) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/orgs/adminAccountslist",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for Amazon Detective.
//
// Returns information about the Detective administrator account for an organization.
// Can only be called by the organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListOrganizationAdminAccounts
func (c *Detective) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//	pageNum := 0
//	err := client.ListOrganizationAdminAccountsPages(params,
//	    func(page *detective.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Detective) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListTagsForResource
func (c *Detective) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Detective.
//
// Returns the tag values that are assigned to a behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListTagsForResource
func (c *Detective) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInvitation = "RejectInvitation"

// RejectInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInvitation for more information on using the RejectInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectInvitationRequest method.
//	req, resp := client.RejectInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/RejectInvitation
func (c *Detective) RejectInvitationRequest(input *RejectInvitationInput) (req *request.Request, output *RejectInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/removal",
	}

	if input == nil {
		input = &RejectInvitationInput{}
	}

	output = &RejectInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectInvitation API operation for Amazon Detective.
//
// Rejects an invitation to contribute the account data to a behavior graph.
// This operation must be called by an invited member account that has the INVITED
// status.
//
// RejectInvitation cannot be called by an organization account in the organization
// behavior graph. In the organization behavior graph, organization accounts
// do not receive an invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation RejectInvitation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/RejectInvitation
func (c *Detective) RejectInvitation(input *RejectInvitationInput) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	return out, req.Send()
}

// RejectInvitationWithContext is the same as RejectInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) RejectInvitationWithContext(ctx aws.Context, input *RejectInvitationInput, opts ...request.Option) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInvestigation = "StartInvestigation"

// StartInvestigationRequest generates a "aws/request.Request" representing the
// client's request for the StartInvestigation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInvestigation for more information on using the StartInvestigation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartInvestigationRequest method.
//	req, resp := client.StartInvestigationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartInvestigation
func (c *Detective) StartInvestigationRequest(input *StartInvestigationInput) (req *request.Request, output *StartInvestigationOutput) {
	op := &request.Operation{
		Name:       opStartInvestigation,
		HTTPMethod: "POST",
		HTTPPath:   "/investigations/startInvestigation",
	}

	if input == nil {
		input = &StartInvestigationInput{}
	}

	output = &StartInvestigationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInvestigation API operation for Amazon Detective.
//
// initiate an investigation on an entity in a graph
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation StartInvestigation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartInvestigation
func (c *Detective) StartInvestigation(input *StartInvestigationInput) (*StartInvestigationOutput, error) {
	req, out := c.StartInvestigationRequest(input)
	return out, req.Send()
}

// StartInvestigationWithContext is the same as StartInvestigation with the addition of
// the ability to pass a context and additional request options.
//
// See StartInvestigation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) StartInvestigationWithContext(ctx aws.Context, input *StartInvestigationInput, opts ...request.Option) (*StartInvestigationOutput, error) {
	req, out := c.StartInvestigationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMonitoringMember = "StartMonitoringMember"

// StartMonitoringMemberRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringMember for more information on using the StartMonitoringMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMonitoringMemberRequest method.
//	req, resp := client.StartMonitoringMemberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartMonitoringMember
func (c *Detective) StartMonitoringMemberRequest(input *StartMonitoringMemberInput) (req *request.Request, output *StartMonitoringMemberOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringMember,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/member/monitoringstate",
	}

	if input == nil {
		input = &StartMonitoringMemberInput{}
	}

	output = &StartMonitoringMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMonitoringMember API operation for Amazon Detective.
//
// Sends a request to enable data ingest for a member account that has a status
// of ACCEPTED_BUT_DISABLED.
//
// For valid member accounts, the status is updated as follows.
//
//   - If Detective enabled the member account, then the new status is ENABLED.
//
//   - If Detective cannot enable the member account, the status remains ACCEPTED_BUT_DISABLED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation StartMonitoringMember for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - ConflictException
//     The request attempted an invalid action.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ServiceQuotaExceededException
//     This request cannot be completed for one of the following reasons.
//
//   - The request would cause the number of member accounts in the behavior
//     graph to exceed the maximum allowed. A behavior graph cannot have more
//     than 1200 member accounts.
//
//   - The request would cause the data rate for the behavior graph to exceed
//     the maximum allowed.
//
//   - Detective is unable to verify the data rate for the member account.
//     This is usually because the member account is not enrolled in Amazon GuardDuty.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartMonitoringMember
func (c *Detective) StartMonitoringMember(input *StartMonitoringMemberInput) (*StartMonitoringMemberOutput, error) {
	req, out := c.StartMonitoringMemberRequest(input)
	return out, req.Send()
}

// StartMonitoringMemberWithContext is the same as StartMonitoringMember with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) StartMonitoringMemberWithContext(ctx aws.Context, input *StartMonitoringMemberInput, opts ...request.Option) (*StartMonitoringMemberOutput, error) {
	req, out := c.StartMonitoringMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/TagResource
func (c *Detective) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Detective.
//
// Applies tag values to a behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/TagResource
func (c *Detective) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UntagResource
func (c *Detective) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Detective.
//
// Removes tags from a behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UntagResource
func (c *Detective) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatasourcePackages = "UpdateDatasourcePackages"

// UpdateDatasourcePackagesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatasourcePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatasourcePackages for more information on using the UpdateDatasourcePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDatasourcePackagesRequest method.
//	req, resp := client.UpdateDatasourcePackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateDatasourcePackages
func (c *Detective) UpdateDatasourcePackagesRequest(input *UpdateDatasourcePackagesInput) (req *request.Request, output *UpdateDatasourcePackagesOutput) {
	op := &request.Operation{
		Name:       opUpdateDatasourcePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/datasources/update",
	}

	if input == nil {
		input = &UpdateDatasourcePackagesInput{}
	}

	output = &UpdateDatasourcePackagesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatasourcePackages API operation for Amazon Detective.
//
// Starts a data source packages for the behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation UpdateDatasourcePackages for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - ServiceQuotaExceededException
//     This request cannot be completed for one of the following reasons.
//
//   - The request would cause the number of member accounts in the behavior
//     graph to exceed the maximum allowed. A behavior graph cannot have more
//     than 1200 member accounts.
//
//   - The request would cause the data rate for the behavior graph to exceed
//     the maximum allowed.
//
//   - Detective is unable to verify the data rate for the member account.
//     This is usually because the member account is not enrolled in Amazon GuardDuty.
//
//   - ValidationException
//     The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateDatasourcePackages
func (c *Detective) UpdateDatasourcePackages(input *UpdateDatasourcePackagesInput) (*UpdateDatasourcePackagesOutput, error) {
	req, out := c.UpdateDatasourcePackagesRequest(input)
	return out, req.Send()
}

// UpdateDatasourcePackagesWithContext is the same as UpdateDatasourcePackages with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatasourcePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) UpdateDatasourcePackagesWithContext(ctx aws.Context, input *UpdateDatasourcePackagesInput, opts ...request.Option) (*UpdateDatasourcePackagesOutput, error) {
	req, out := c.UpdateDatasourcePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInvestigationState = "UpdateInvestigationState"

// UpdateInvestigationStateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInvestigationState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInvestigationState for more information on using the UpdateInvestigationState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInvestigationStateRequest method.
//	req, resp := client.UpdateInvestigationStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateInvestigationState
func (c *Detective) UpdateInvestigationStateRequest(input *UpdateInvestigationStateInput) (req *request.Request, output *UpdateInvestigationStateOutput) {
	op := &request.Operation{
		Name:       opUpdateInvestigationState,
		HTTPMethod: "POST",
		HTTPPath:   "/investigations/updateInvestigationState",
	}

	if input == nil {
		input = &UpdateInvestigationStateInput{}
	}

	output = &UpdateInvestigationStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInvestigationState API operation for Amazon Detective.
//
// Update the state of an investigation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation UpdateInvestigationState for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - ResourceNotFoundException
//     The request refers to a nonexistent resource.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateInvestigationState
func (c *Detective) UpdateInvestigationState(input *UpdateInvestigationStateInput) (*UpdateInvestigationStateOutput, error) {
	req, out := c.UpdateInvestigationStateRequest(input)
	return out, req.Send()
}

// UpdateInvestigationStateWithContext is the same as UpdateInvestigationState with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInvestigationState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) UpdateInvestigationStateWithContext(ctx aws.Context, input *UpdateInvestigationStateInput, opts ...request.Option) (*UpdateInvestigationStateOutput, error) {
	req, out := c.UpdateInvestigationStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOrganizationConfigurationRequest method.
//	req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateOrganizationConfiguration
func (c *Detective) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/orgs/updateOrganizationConfiguration",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for Amazon Detective.
//
// Updates the configuration for the Organizations integration in the current
// Region. Can only be called by the Detective administrator account for the
// organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request issuer does not have permission to access this resource or perform
//     this operation.
//
//   - InternalServerException
//     The request was valid but failed because of a problem with the service.
//
//   - ValidationException
//     The request parameters are invalid.
//
//   - TooManyRequestsException
//     The request cannot be completed because too many other requests are occurring
//     at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/UpdateOrganizationConfiguration
func (c *Detective) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph that the member account is accepting the invitation
	// for.
	//
	// The member account status in the behavior graph must be INVITED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *AcceptInvitationInput) SetGraphArn(v string) *AcceptInvitationInput {
	s.GraphArn = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// The request issuer does not have permission to access this resource or perform
// this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The SDK default error code associated with the access denied exception.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The SDK default explanation of why access was denied.
	ErrorCodeReason *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The error code associated with the access denied exception.
	SubErrorCode *string `type:"string" enum:"ErrorCode"`

	// An explanation of why access was denied.
	SubErrorCodeReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Amazon Web Services account that is the administrator account of or a
// member of a behavior graph.
type Account struct {
	_ struct{} `type:"structure"`

	// The account identifier of the Amazon Web Services account.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The Amazon Web Services account root user email address for the Amazon Web
	// Services account.
	//
	// EmailAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Account's
	// String and GoString methods.
	//
	// EmailAddress is a required field
	EmailAddress *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Account) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Account"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Account) SetEmailAddress(v string) *Account {
	s.EmailAddress = &v
	return s
}

// Information about the Detective administrator account for an organization.
type Administrator struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier of the Detective administrator
	// account for the organization.
	AccountId *string `min:"12" type:"string"`

	// The date and time when the Detective administrator account was enabled. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	DelegationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the organization behavior graph.
	GraphArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Administrator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Administrator) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Administrator) SetAccountId(v string) *Administrator {
	s.AccountId = &v
	return s
}

// SetDelegationTime sets the DelegationTime field's value.
func (s *Administrator) SetDelegationTime(v time.Time) *Administrator {
	s.DelegationTime = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *Administrator) SetGraphArn(v string) *Administrator {
	s.GraphArn = &v
	return s
}

type BatchGetGraphMemberDatasourcesInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services accounts to get data source package information
	// on.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetGraphMemberDatasourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetGraphMemberDatasourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetGraphMemberDatasourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetGraphMemberDatasourcesInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchGetGraphMemberDatasourcesInput) SetAccountIds(v []*string) *BatchGetGraphMemberDatasourcesInput {
	s.AccountIds = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *BatchGetGraphMemberDatasourcesInput) SetGraphArn(v string) *BatchGetGraphMemberDatasourcesInput {
	s.GraphArn = &v
	return s
}

type BatchGetGraphMemberDatasourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details on the status of data source packages for members of the behavior
	// graph.
	MemberDatasources []*MembershipDatasources `type:"list"`

	// Accounts that data source package information could not be retrieved for.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetGraphMemberDatasourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetGraphMemberDatasourcesOutput) GoString() string {
	return s.String()
}

// SetMemberDatasources sets the MemberDatasources field's value.
func (s *BatchGetGraphMemberDatasourcesOutput) SetMemberDatasources(v []*MembershipDatasources) *BatchGetGraphMemberDatasourcesOutput {
	s.MemberDatasources = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *BatchGetGraphMemberDatasourcesOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *BatchGetGraphMemberDatasourcesOutput {
	s.UnprocessedAccounts = v
	return s
}

type BatchGetMembershipDatasourcesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArns is a required field
	GraphArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMembershipDatasourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMembershipDatasourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetMembershipDatasourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetMembershipDatasourcesInput"}
	if s.GraphArns == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArns"))
	}
	if s.GraphArns != nil && len(s.GraphArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GraphArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArns sets the GraphArns field's value.
func (s *BatchGetMembershipDatasourcesInput) SetGraphArns(v []*string) *BatchGetMembershipDatasourcesInput {
	s.GraphArns = v
	return s
}

type BatchGetMembershipDatasourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details on the data source package history for an member of the behavior
	// graph.
	MembershipDatasources []*MembershipDatasources `type:"list"`

	// Graphs that data source package information could not be retrieved for.
	UnprocessedGraphs []*UnprocessedGraph `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMembershipDatasourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetMembershipDatasourcesOutput) GoString() string {
	return s.String()
}

// SetMembershipDatasources sets the MembershipDatasources field's value.
func (s *BatchGetMembershipDatasourcesOutput) SetMembershipDatasources(v []*MembershipDatasources) *BatchGetMembershipDatasourcesOutput {
	s.MembershipDatasources = v
	return s
}

// SetUnprocessedGraphs sets the UnprocessedGraphs field's value.
func (s *BatchGetMembershipDatasourcesOutput) SetUnprocessedGraphs(v []*UnprocessedGraph) *BatchGetMembershipDatasourcesOutput {
	s.UnprocessedGraphs = v
	return s
}

// The request attempted an invalid action.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGraphInput struct {
	_ struct{} `type:"structure"`

	// The tags to assign to the new behavior graph. You can add up to 50 tags.
	// For each tag, you provide the tag key and the tag value. Each tag key can
	// contain up to 128 characters. Each tag value can contain up to 256 characters.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGraphInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *CreateGraphInput) SetTags(v map[string]*string) *CreateGraphInput {
	s.Tags = v
	return s
}

type CreateGraphOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new behavior graph.
	GraphArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGraphOutput) GoString() string {
	return s.String()
}

// SetGraphArn sets the GraphArn field's value.
func (s *CreateGraphOutput) SetGraphArn(v string) *CreateGraphOutput {
	s.GraphArn = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services accounts to invite or to enable. You can
	// invite or enable up to 50 accounts at a time. For each invited account, the
	// account list contains the account identifier and the Amazon Web Services
	// account root user email address. For organization accounts in the organization
	// behavior graph, the email address is not required.
	//
	// Accounts is a required field
	Accounts []*Account `min:"1" type:"list" required:"true"`

	// if set to true, then the invited accounts do not receive email notifications.
	// By default, this is set to false, and the invited accounts receive email
	// notifications.
	//
	// Organization accounts in the organization behavior graph do not receive email
	// notifications.
	DisableEmailNotification *bool `type:"boolean"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// Customized message text to include in the invitation email message to the
	// invited member accounts.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMembersInput's
	// String and GoString methods.
	Message *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembersInput"}
	if s.Accounts == nil {
		invalidParams.Add(request.NewErrParamRequired("Accounts"))
	}
	if s.Accounts != nil && len(s.Accounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Accounts", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Accounts != nil {
		for i, v := range s.Accounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Accounts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *CreateMembersInput) SetAccounts(v []*Account) *CreateMembersInput {
	s.Accounts = v
	return s
}

// SetDisableEmailNotification sets the DisableEmailNotification field's value.
func (s *CreateMembersInput) SetDisableEmailNotification(v bool) *CreateMembersInput {
	s.DisableEmailNotification = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *CreateMembersInput) SetGraphArn(v string) *CreateMembersInput {
	s.GraphArn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CreateMembersInput) SetMessage(v string) *CreateMembersInput {
	s.Message = &v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// The set of member account invitation or enablement requests that Detective
	// was able to process. This includes accounts that are being verified, that
	// failed verification, and that passed verification and are being sent an invitation
	// or are being enabled.
	Members []*MemberDetail `type:"list"`

	// The list of accounts for which Detective was unable to process the invitation
	// or enablement request. For each account, the list provides the reason why
	// the request could not be processed. The list includes accounts that are already
	// member accounts in the behavior graph.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *CreateMembersOutput) SetMembers(v []*MemberDetail) *CreateMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Details about the data source packages ingested by your behavior graph.
type DatasourcePackageIngestDetail struct {
	_ struct{} `type:"structure"`

	// Details on which data source packages are ingested for a member account.
	DatasourcePackageIngestState *string `type:"string" enum:"DatasourcePackageIngestState"`

	// The date a data source package was enabled for this account
	LastIngestStateChange map[string]*TimestampForCollection `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasourcePackageIngestDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasourcePackageIngestDetail) GoString() string {
	return s.String()
}

// SetDatasourcePackageIngestState sets the DatasourcePackageIngestState field's value.
func (s *DatasourcePackageIngestDetail) SetDatasourcePackageIngestState(v string) *DatasourcePackageIngestDetail {
	s.DatasourcePackageIngestState = &v
	return s
}

// SetLastIngestStateChange sets the LastIngestStateChange field's value.
func (s *DatasourcePackageIngestDetail) SetLastIngestStateChange(v map[string]*TimestampForCollection) *DatasourcePackageIngestDetail {
	s.LastIngestStateChange = v
	return s
}

// Information on the usage of a data source package in the behavior graph.
type DatasourcePackageUsageInfo struct {
	_ struct{} `type:"structure"`

	// Total volume of data in bytes per day ingested for a given data source package.
	VolumeUsageInBytes *int64 `type:"long"`

	// The data and time when the member account data volume was last updated. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	VolumeUsageUpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasourcePackageUsageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasourcePackageUsageInfo) GoString() string {
	return s.String()
}

// SetVolumeUsageInBytes sets the VolumeUsageInBytes field's value.
func (s *DatasourcePackageUsageInfo) SetVolumeUsageInBytes(v int64) *DatasourcePackageUsageInfo {
	s.VolumeUsageInBytes = &v
	return s
}

// SetVolumeUsageUpdateTime sets the VolumeUsageUpdateTime field's value.
func (s *DatasourcePackageUsageInfo) SetVolumeUsageUpdateTime(v time.Time) *DatasourcePackageUsageInfo {
	s.VolumeUsageUpdateTime = &v
	return s
}

// Contains details on the time range used to filter data.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A timestamp representing the end date of the time period until when data
	// is filtered , including the end date.
	//
	// EndInclusive is a required field
	EndInclusive *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A timestamp representing the start of the time period from when data is filtered,
	// including the start date.
	//
	// StartInclusive is a required field
	StartInclusive *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateFilter"}
	if s.EndInclusive == nil {
		invalidParams.Add(request.NewErrParamRequired("EndInclusive"))
	}
	if s.StartInclusive == nil {
		invalidParams.Add(request.NewErrParamRequired("StartInclusive"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndInclusive sets the EndInclusive field's value.
func (s *DateFilter) SetEndInclusive(v time.Time) *DateFilter {
	s.EndInclusive = &v
	return s
}

// SetStartInclusive sets the StartInclusive field's value.
func (s *DateFilter) SetStartInclusive(v time.Time) *DateFilter {
	s.StartInclusive = &v
	return s
}

type DeleteGraphInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to disable.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGraphInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *DeleteGraphInput) SetGraphArn(v string) *DeleteGraphInput {
	s.GraphArn = &v
	return s
}

type DeleteGraphOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGraphOutput) GoString() string {
	return s.String()
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account identifiers for the member accounts
	// to remove from the behavior graph. You can remove up to 50 member accounts
	// at a time.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph to remove members from.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *DeleteMembersInput) SetGraphArn(v string) *DeleteMembersInput {
	s.GraphArn = &v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account identifiers for the member accounts
	// that Detective successfully removed from the behavior graph.
	AccountIds []*string `min:"1" type:"list"`

	// The list of member accounts that Detective was not able to remove from the
	// behavior graph. For each member account, provides the reason that the deletion
	// could not be processed.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersOutput) SetAccountIds(v []*string) *DeleteMembersOutput {
	s.AccountIds = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the organization behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationConfigurationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *DescribeOrganizationConfigurationInput) SetGraphArn(v string) *DescribeOrganizationConfigurationInput {
	s.GraphArn = &v
	return s
}

type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to automatically enable new organization accounts as member
	// accounts in the organization behavior graph.
	AutoEnable *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *DescribeOrganizationConfigurationOutput) SetAutoEnable(v bool) *DescribeOrganizationConfigurationOutput {
	s.AutoEnable = &v
	return s
}

type DisableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

type DisableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to remove the member account from.
	//
	// The member account's member status in the behavior graph must be ENABLED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMembershipInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *DisassociateMembershipInput) SetGraphArn(v string) *DisassociateMembershipInput {
	s.GraphArn = &v
	return s
}

type DisassociateMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMembershipOutput) GoString() string {
	return s.String()
}

type EnableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier of the account to designate as
	// the Detective administrator account for the organization.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableOrganizationAdminAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *EnableOrganizationAdminAccountInput) SetAccountId(v string) *EnableOrganizationAdminAccountInput {
	s.AccountId = &v
	return s
}

type EnableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

// Details on the criteria used to define the filter for investigation results.
type FilterCriteria struct {
	_ struct{} `type:"structure"`

	// Filter the investigation results based on when the investigation was created.
	CreatedTime *DateFilter `type:"structure"`

	// Filter the investigation results based on the Amazon Resource Name (ARN)
	// of the entity.
	EntityArn *StringFilter `type:"structure"`

	// Filter the investigation results based on the severity.
	Severity *StringFilter `type:"structure"`

	// Filter the investigation results based on the state.
	State *StringFilter `type:"structure"`

	// Filter the investigation results based on the status.
	Status *StringFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterCriteria"}
	if s.CreatedTime != nil {
		if err := s.CreatedTime.Validate(); err != nil {
			invalidParams.AddNested("CreatedTime", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityArn != nil {
		if err := s.EntityArn.Validate(); err != nil {
			invalidParams.AddNested("EntityArn", err.(request.ErrInvalidParams))
		}
	}
	if s.Severity != nil {
		if err := s.Severity.Validate(); err != nil {
			invalidParams.AddNested("Severity", err.(request.ErrInvalidParams))
		}
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(request.ErrInvalidParams))
		}
	}
	if s.Status != nil {
		if err := s.Status.Validate(); err != nil {
			invalidParams.AddNested("Status", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *FilterCriteria) SetCreatedTime(v *DateFilter) *FilterCriteria {
	s.CreatedTime = v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *FilterCriteria) SetEntityArn(v *StringFilter) *FilterCriteria {
	s.EntityArn = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *FilterCriteria) SetSeverity(v *StringFilter) *FilterCriteria {
	s.Severity = v
	return s
}

// SetState sets the State field's value.
func (s *FilterCriteria) SetState(v *StringFilter) *FilterCriteria {
	s.State = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilterCriteria) SetStatus(v *StringFilter) *FilterCriteria {
	s.Status = v
	return s
}

// Contains information on suspicious IP addresses identified as indicators
// of compromise. This indicator is derived from Amazon Web Services threat
// intelligence.
type FlaggedIpAddressDetail struct {
	_ struct{} `type:"structure"`

	// IP address of the suspicious entity.
	IpAddress *string `type:"string"`

	// Details the reason the IP address was flagged as suspicious.
	Reason *string `type:"string" enum:"Reason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlaggedIpAddressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlaggedIpAddressDetail) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *FlaggedIpAddressDetail) SetIpAddress(v string) *FlaggedIpAddressDetail {
	s.IpAddress = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *FlaggedIpAddressDetail) SetReason(v string) *FlaggedIpAddressDetail {
	s.Reason = &v
	return s
}

type GetInvestigationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The investigation ID of the investigation report.
	//
	// InvestigationId is a required field
	InvestigationId *string `min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvestigationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvestigationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInvestigationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInvestigationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.InvestigationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvestigationId"))
	}
	if s.InvestigationId != nil && len(*s.InvestigationId) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("InvestigationId", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *GetInvestigationInput) SetGraphArn(v string) *GetInvestigationInput {
	s.GraphArn = &v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *GetInvestigationInput) SetInvestigationId(v string) *GetInvestigationInput {
	s.InvestigationId = &v
	return s
}

type GetInvestigationOutput struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time of the investigation report.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
	EntityArn *string `type:"string"`

	// Type of entity. For example, Amazon Web Services accounts, such as IAM user
	// and role.
	EntityType *string `type:"string" enum:"EntityType"`

	// The ARN of the behavior graph.
	GraphArn *string `type:"string"`

	// The investigation ID of the investigation report.
	InvestigationId *string `min:"21" type:"string"`

	// The data and time when the investigation began. The value is an UTC ISO8601
	// formatted string. For example, 2021-08-18T16:35:56.284Z.
	ScopeEndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The start date and time for the scope time set to generate the investigation
	// report.
	ScopeStartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Severity based on the likelihood and impact of the indicators of compromise
	// discovered in the investigation.
	Severity *string `type:"string" enum:"Severity"`

	// The current state of the investigation. An archived investigation indicates
	// you have completed reviewing the investigation.
	State *string `type:"string" enum:"State"`

	// Status based on the completion status of the investigation.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvestigationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInvestigationOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetInvestigationOutput) SetCreatedTime(v time.Time) *GetInvestigationOutput {
	s.CreatedTime = &v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *GetInvestigationOutput) SetEntityArn(v string) *GetInvestigationOutput {
	s.EntityArn = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *GetInvestigationOutput) SetEntityType(v string) *GetInvestigationOutput {
	s.EntityType = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *GetInvestigationOutput) SetGraphArn(v string) *GetInvestigationOutput {
	s.GraphArn = &v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *GetInvestigationOutput) SetInvestigationId(v string) *GetInvestigationOutput {
	s.InvestigationId = &v
	return s
}

// SetScopeEndTime sets the ScopeEndTime field's value.
func (s *GetInvestigationOutput) SetScopeEndTime(v time.Time) *GetInvestigationOutput {
	s.ScopeEndTime = &v
	return s
}

// SetScopeStartTime sets the ScopeStartTime field's value.
func (s *GetInvestigationOutput) SetScopeStartTime(v time.Time) *GetInvestigationOutput {
	s.ScopeStartTime = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *GetInvestigationOutput) SetSeverity(v string) *GetInvestigationOutput {
	s.Severity = &v
	return s
}

// SetState sets the State field's value.
func (s *GetInvestigationOutput) SetState(v string) *GetInvestigationOutput {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetInvestigationOutput) SetStatus(v string) *GetInvestigationOutput {
	s.Status = &v
	return s
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services account identifiers for the member account
	// for which to return member details. You can request details for up to 50
	// member accounts at a time.
	//
	// You cannot use GetMembers to retrieve information about member accounts that
	// were removed from the behavior graph.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph for which to request the member details.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *GetMembersInput) SetGraphArn(v string) *GetMembersInput {
	s.GraphArn = &v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// The member account details that Detective is returning in response to the
	// request.
	MemberDetails []*MemberDetail `type:"list"`

	// The requested member accounts for which Detective was unable to return member
	// details.
	//
	// For each account, provides the reason why the request could not be processed.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMemberDetails sets the MemberDetails field's value.
func (s *GetMembersOutput) SetMemberDetails(v []*MemberDetail) *GetMembersOutput {
	s.MemberDetails = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// A behavior graph in Detective.
type Graph struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	Arn *string `type:"string"`

	// The date and time that the behavior graph was created. The value is an ISO8601
	// formatted string. For example, 2021-08-18T16:35:56.284Z.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Graph) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Graph) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Graph) SetArn(v string) *Graph {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Graph) SetCreatedTime(v time.Time) *Graph {
	s.CreatedTime = &v
	return s
}

// Contains information on unusual and impossible travel in an account.
type ImpossibleTravelDetail struct {
	_ struct{} `type:"structure"`

	// IP address where the resource was last used in the impossible travel.
	EndingIpAddress *string `type:"string"`

	// Location where the resource was last used in the impossible travel.
	EndingLocation *string `type:"string"`

	// Returns the time difference between the first and last timestamp the resource
	// was used.
	HourlyTimeDelta *int64 `type:"integer"`

	// IP address where the resource was first used in the impossible travel
	StartingIpAddress *string `type:"string"`

	// Location where the resource was first used in the impossible travel
	StartingLocation *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImpossibleTravelDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImpossibleTravelDetail) GoString() string {
	return s.String()
}

// SetEndingIpAddress sets the EndingIpAddress field's value.
func (s *ImpossibleTravelDetail) SetEndingIpAddress(v string) *ImpossibleTravelDetail {
	s.EndingIpAddress = &v
	return s
}

// SetEndingLocation sets the EndingLocation field's value.
func (s *ImpossibleTravelDetail) SetEndingLocation(v string) *ImpossibleTravelDetail {
	s.EndingLocation = &v
	return s
}

// SetHourlyTimeDelta sets the HourlyTimeDelta field's value.
func (s *ImpossibleTravelDetail) SetHourlyTimeDelta(v int64) *ImpossibleTravelDetail {
	s.HourlyTimeDelta = &v
	return s
}

// SetStartingIpAddress sets the StartingIpAddress field's value.
func (s *ImpossibleTravelDetail) SetStartingIpAddress(v string) *ImpossibleTravelDetail {
	s.StartingIpAddress = &v
	return s
}

// SetStartingLocation sets the StartingLocation field's value.
func (s *ImpossibleTravelDetail) SetStartingLocation(v string) *ImpossibleTravelDetail {
	s.StartingLocation = &v
	return s
}

// Investigations triages indicators of compromises such as a finding and surfaces
// only the most critical and suspicious issues, so you can focus on high-level
// investigations.
type Indicator struct {
	_ struct{} `type:"structure"`

	// Details about the indicator of compromise.
	IndicatorDetail *IndicatorDetail `type:"structure"`

	// The type of indicator.
	IndicatorType *string `type:"string" enum:"IndicatorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Indicator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Indicator) GoString() string {
	return s.String()
}

// SetIndicatorDetail sets the IndicatorDetail field's value.
func (s *Indicator) SetIndicatorDetail(v *IndicatorDetail) *Indicator {
	s.IndicatorDetail = v
	return s
}

// SetIndicatorType sets the IndicatorType field's value.
func (s *Indicator) SetIndicatorType(v string) *Indicator {
	s.IndicatorType = &v
	return s
}

// Details about the indicators of compromise which are used to determine if
// a resource is involved in a security incident.
type IndicatorDetail struct {
	_ struct{} `type:"structure"`

	// Suspicious IP addresses that are flagged, which indicates critical or severe
	// threats based on threat intelligence by Detective. This indicator is derived
	// from AWS threat intelligence.
	FlaggedIpAddressDetail *FlaggedIpAddressDetail `type:"structure"`

	// Identifies unusual and impossible user activity for an account.
	ImpossibleTravelDetail *ImpossibleTravelDetail `type:"structure"`

	// Contains details about the new Autonomous System Organization (ASO).
	NewAsoDetail *NewAsoDetail `type:"structure"`

	// Contains details about the new geographic location.
	NewGeolocationDetail *NewGeolocationDetail `type:"structure"`

	// Contains details about the new user agent.
	NewUserAgentDetail *NewUserAgentDetail `type:"structure"`

	// Contains details about related findings.
	RelatedFindingDetail *RelatedFindingDetail `type:"structure"`

	// Contains details about related finding groups.
	RelatedFindingGroupDetail *RelatedFindingGroupDetail `type:"structure"`

	// Details about the indicator of compromise.
	TTPsObservedDetail *TTPsObservedDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndicatorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndicatorDetail) GoString() string {
	return s.String()
}

// SetFlaggedIpAddressDetail sets the FlaggedIpAddressDetail field's value.
func (s *IndicatorDetail) SetFlaggedIpAddressDetail(v *FlaggedIpAddressDetail) *IndicatorDetail {
	s.FlaggedIpAddressDetail = v
	return s
}

// SetImpossibleTravelDetail sets the ImpossibleTravelDetail field's value.
func (s *IndicatorDetail) SetImpossibleTravelDetail(v *ImpossibleTravelDetail) *IndicatorDetail {
	s.ImpossibleTravelDetail = v
	return s
}

// SetNewAsoDetail sets the NewAsoDetail field's value.
func (s *IndicatorDetail) SetNewAsoDetail(v *NewAsoDetail) *IndicatorDetail {
	s.NewAsoDetail = v
	return s
}

// SetNewGeolocationDetail sets the NewGeolocationDetail field's value.
func (s *IndicatorDetail) SetNewGeolocationDetail(v *NewGeolocationDetail) *IndicatorDetail {
	s.NewGeolocationDetail = v
	return s
}

// SetNewUserAgentDetail sets the NewUserAgentDetail field's value.
func (s *IndicatorDetail) SetNewUserAgentDetail(v *NewUserAgentDetail) *IndicatorDetail {
	s.NewUserAgentDetail = v
	return s
}

// SetRelatedFindingDetail sets the RelatedFindingDetail field's value.
func (s *IndicatorDetail) SetRelatedFindingDetail(v *RelatedFindingDetail) *IndicatorDetail {
	s.RelatedFindingDetail = v
	return s
}

// SetRelatedFindingGroupDetail sets the RelatedFindingGroupDetail field's value.
func (s *IndicatorDetail) SetRelatedFindingGroupDetail(v *RelatedFindingGroupDetail) *IndicatorDetail {
	s.RelatedFindingGroupDetail = v
	return s
}

// SetTTPsObservedDetail sets the TTPsObservedDetail field's value.
func (s *IndicatorDetail) SetTTPsObservedDetail(v *TTPsObservedDetail) *IndicatorDetail {
	s.TTPsObservedDetail = v
	return s
}

// The request was valid but failed because of a problem with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the investigation related to a potential security event identified
// by Detective
type InvestigationDetail struct {
	_ struct{} `type:"structure"`

	// The UTC time stamp of the creation time of the investigation report.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
	EntityArn *string `type:"string"`

	// Type of entity. For example, Amazon Web Services accounts, such as IAM user
	// and role.
	EntityType *string `type:"string" enum:"EntityType"`

	// The investigation ID of the investigation report.
	InvestigationId *string `min:"21" type:"string"`

	// Severity based on the likelihood and impact of the indicators of compromise
	// discovered in the investigation.
	Severity *string `type:"string" enum:"Severity"`

	// The current state of the investigation. An archived investigation indicates
	// you have completed reviewing the investigation.
	State *string `type:"string" enum:"State"`

	// Status based on the completion status of the investigation.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvestigationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvestigationDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *InvestigationDetail) SetCreatedTime(v time.Time) *InvestigationDetail {
	s.CreatedTime = &v
	return s
}

// SetEntityArn sets the EntityArn field's value.
func (s *InvestigationDetail) SetEntityArn(v string) *InvestigationDetail {
	s.EntityArn = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *InvestigationDetail) SetEntityType(v string) *InvestigationDetail {
	s.EntityType = &v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *InvestigationDetail) SetInvestigationId(v string) *InvestigationDetail {
	s.InvestigationId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *InvestigationDetail) SetSeverity(v string) *InvestigationDetail {
	s.Severity = &v
	return s
}

// SetState sets the State field's value.
func (s *InvestigationDetail) SetState(v string) *InvestigationDetail {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InvestigationDetail) SetStatus(v string) *InvestigationDetail {
	s.Status = &v
	return s
}

type ListDatasourcePackagesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasourcePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasourcePackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasourcePackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasourcePackagesInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListDatasourcePackagesInput) SetGraphArn(v string) *ListDatasourcePackagesInput {
	s.GraphArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasourcePackagesInput) SetMaxResults(v int64) *ListDatasourcePackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasourcePackagesInput) SetNextToken(v string) *ListDatasourcePackagesInput {
	s.NextToken = &v
	return s
}

type ListDatasourcePackagesOutput struct {
	_ struct{} `type:"structure"`

	// Details on the data source packages active in the behavior graph.
	DatasourcePackages map[string]*DatasourcePackageIngestDetail `type:"map"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasourcePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasourcePackagesOutput) GoString() string {
	return s.String()
}

// SetDatasourcePackages sets the DatasourcePackages field's value.
func (s *ListDatasourcePackagesOutput) SetDatasourcePackages(v map[string]*DatasourcePackageIngestDetail) *ListDatasourcePackagesOutput {
	s.DatasourcePackages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasourcePackagesOutput) SetNextToken(v string) *ListDatasourcePackagesOutput {
	s.NextToken = &v
	return s
}

type ListGraphsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of graphs to return at a time. The total must be less
	// than the overall limit on the number of results to return, which is currently
	// 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGraphsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGraphsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGraphsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGraphsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGraphsInput) SetMaxResults(v int64) *ListGraphsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphsInput) SetNextToken(v string) *ListGraphsInput {
	s.NextToken = &v
	return s
}

type ListGraphsOutput struct {
	_ struct{} `type:"structure"`

	// A list of behavior graphs that the account is an administrator account for.
	GraphList []*Graph `type:"list"`

	// If there are more behavior graphs remaining in the results, then this is
	// the pagination token to use to request the next page of behavior graphs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGraphsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGraphsOutput) GoString() string {
	return s.String()
}

// SetGraphList sets the GraphList field's value.
func (s *ListGraphsOutput) SetGraphList(v []*Graph) *ListGraphsOutput {
	s.GraphList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphsOutput) SetNextToken(v string) *ListGraphsOutput {
	s.NextToken = &v
	return s
}

type ListIndicatorsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// See Detective investigations. (https://docs.aws.amazon.com/detective/latest/userguide/detective-investigations.html).
	IndicatorType *string `type:"string" enum:"IndicatorType"`

	// The investigation ID of the investigation report.
	//
	// InvestigationId is a required field
	InvestigationId *string `min:"21" type:"string" required:"true"`

	// List the maximum number of indicators in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return a Validation Exception error.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndicatorsInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.InvestigationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvestigationId"))
	}
	if s.InvestigationId != nil && len(*s.InvestigationId) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("InvestigationId", 21))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListIndicatorsInput) SetGraphArn(v string) *ListIndicatorsInput {
	s.GraphArn = &v
	return s
}

// SetIndicatorType sets the IndicatorType field's value.
func (s *ListIndicatorsInput) SetIndicatorType(v string) *ListIndicatorsInput {
	s.IndicatorType = &v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *ListIndicatorsInput) SetInvestigationId(v string) *ListIndicatorsInput {
	s.InvestigationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndicatorsInput) SetMaxResults(v int64) *ListIndicatorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicatorsInput) SetNextToken(v string) *ListIndicatorsInput {
	s.NextToken = &v
	return s
}

type ListIndicatorsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	GraphArn *string `type:"string"`

	// Indicators of compromise listed based on severity.
	Indicators []*Indicator `type:"list"`

	// The investigation ID of the investigation report.
	InvestigationId *string `min:"21" type:"string"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return a Validation Exception error.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicatorsOutput) GoString() string {
	return s.String()
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListIndicatorsOutput) SetGraphArn(v string) *ListIndicatorsOutput {
	s.GraphArn = &v
	return s
}

// SetIndicators sets the Indicators field's value.
func (s *ListIndicatorsOutput) SetIndicators(v []*Indicator) *ListIndicatorsOutput {
	s.Indicators = v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *ListIndicatorsOutput) SetInvestigationId(v string) *ListIndicatorsOutput {
	s.InvestigationId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicatorsOutput) SetNextToken(v string) *ListIndicatorsOutput {
	s.NextToken = &v
	return s
}

type ListInvestigationsInput struct {
	_ struct{} `type:"structure"`

	// Filter the investigation results based on a criteria.
	FilterCriteria *FilterCriteria `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// List the maximum number of investigations in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return a Validation Exception error.
	NextToken *string `min:"1" type:"string"`

	// Sorts the investigation results based on a criteria.
	SortCriteria *SortCriteria `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvestigationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvestigationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvestigationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvestigationsInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.FilterCriteria != nil {
		if err := s.FilterCriteria.Validate(); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *ListInvestigationsInput) SetFilterCriteria(v *FilterCriteria) *ListInvestigationsInput {
	s.FilterCriteria = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListInvestigationsInput) SetGraphArn(v string) *ListInvestigationsInput {
	s.GraphArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvestigationsInput) SetMaxResults(v int64) *ListInvestigationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvestigationsInput) SetNextToken(v string) *ListInvestigationsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListInvestigationsInput) SetSortCriteria(v *SortCriteria) *ListInvestigationsInput {
	s.SortCriteria = v
	return s
}

type ListInvestigationsOutput struct {
	_ struct{} `type:"structure"`

	// Investigations details lists the summary of uncommon behavior or malicious
	// activity which indicates a compromise.
	InvestigationDetails []*InvestigationDetail `type:"list"`

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token
	// to retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination
	// token will return an HTTP 400 InvalidToken error.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvestigationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvestigationsOutput) GoString() string {
	return s.String()
}

// SetInvestigationDetails sets the InvestigationDetails field's value.
func (s *ListInvestigationsOutput) SetInvestigationDetails(v []*InvestigationDetail) *ListInvestigationsOutput {
	s.InvestigationDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvestigationsOutput) SetNextToken(v string) *ListInvestigationsOutput {
	s.NextToken = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of behavior graph invitations to return in the response.
	// The total must be less than the overall limit on the number of results to
	// return, which is currently 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to retrieve the next page of results, the pagination token that
	// was returned with the previous page of results. The initial request does
	// not include a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of behavior graphs for which the member account has open or accepted
	// invitations.
	Invitations []*MemberDetail `type:"list"`

	// If there are more behavior graphs remaining in the results, then this is
	// the pagination token to use to request the next page of behavior graphs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*MemberDetail) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph for which to retrieve the list of member accounts.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The maximum number of member accounts to include in the response. The total
	// must be less than the overall limit on the number of results to return, which
	// is currently 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to retrieve the next page of member account results, the pagination
	// token that was returned with the previous page of results. The initial request
	// does not include a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListMembersInput) SetGraphArn(v string) *ListMembersInput {
	s.GraphArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of member accounts in the behavior graph.
	//
	// For invited accounts, the results include member accounts that did not pass
	// verification and member accounts that have not yet accepted the invitation
	// to the behavior graph. The results do not include member accounts that were
	// removed from the behavior graph.
	//
	// For the organization behavior graph, the results do not include organization
	// accounts that the Detective administrator account has not enabled as member
	// accounts.
	MemberDetails []*MemberDetail `type:"list"`

	// If there are more member accounts remaining in the results, then use this
	// pagination token to request the next page of member accounts.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMemberDetails sets the MemberDetails field's value.
func (s *ListMembersOutput) SetMemberDetails(v []*MemberDetail) *ListMembersOutput {
	s.MemberDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationAdminAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationAdminAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationAdminAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationAdminAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationAdminAccountsInput) SetMaxResults(v int64) *ListOrganizationAdminAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsInput) SetNextToken(v string) *ListOrganizationAdminAccountsInput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Detective administrator accounts.
	Administrators []*Administrator `type:"list"`

	// If there are more accounts remaining in the results, then this is the pagination
	// token to use to request the next page of accounts.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationAdminAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationAdminAccountsOutput) GoString() string {
	return s.String()
}

// SetAdministrators sets the Administrators field's value.
func (s *ListOrganizationAdminAccountsOutput) SetAdministrators(v []*Administrator) *ListOrganizationAdminAccountsOutput {
	s.Administrators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsOutput) SetNextToken(v string) *ListOrganizationAdminAccountsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the behavior graph for which to retrieve the tag values.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag values that are assigned to the behavior graph. The request returns
	// up to 50 tag values.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Details about a member account in a behavior graph.
type MemberDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier for the member account.
	AccountId *string `min:"12" type:"string"`

	// The Amazon Web Services account identifier of the administrator account for
	// the behavior graph.
	AdministratorId *string `min:"12" type:"string"`

	// The state of a data source package for the behavior graph.
	DatasourcePackageIngestStates map[string]*string `type:"map"`

	// For member accounts with a status of ACCEPTED_BUT_DISABLED, the reason that
	// the member account is not enabled.
	//
	// The reason can have one of the following values:
	//
	//    * VOLUME_TOO_HIGH - Indicates that adding the member account would cause
	//    the data volume for the behavior graph to be too high.
	//
	//    * VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
	//    volume for the member account. This is usually because the member account
	//    is not enrolled in Amazon GuardDuty.
	DisabledReason *string `type:"string" enum:"MemberDisabledReason"`

	// The Amazon Web Services account root user email address for the member account.
	//
	// EmailAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MemberDetail's
	// String and GoString methods.
	EmailAddress *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the behavior graph.
	GraphArn *string `type:"string"`

	// The type of behavior graph membership.
	//
	// For an organization account in the organization behavior graph, the type
	// is ORGANIZATION.
	//
	// For an account that was invited to a behavior graph, the type is INVITATION.
	InvitationType *string `type:"string" enum:"InvitationType"`

	// For invited accounts, the date and time that Detective sent the invitation
	// to the account. The value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	InvitedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Web Services account identifier of the administrator account for
	// the behavior graph.
	//
	// Deprecated: This property is deprecated. Use AdministratorId instead.
	MasterId *string `min:"12" deprecated:"true" type:"string"`

	// The member account data volume as a percentage of the maximum allowed data
	// volume. 0 indicates 0 percent, and 100 indicates 100 percent.
	//
	// Note that this is not the percentage of the behavior graph data volume.
	//
	// For example, the data volume for the behavior graph is 80 GB per day. The
	// maximum data volume is 160 GB per day. If the data volume for the member
	// account is 40 GB per day, then PercentOfGraphUtilization is 25. It represents
	// 25% of the maximum allowed data volume.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage instead.
	PercentOfGraphUtilization *float64 `deprecated:"true" type:"double"`

	// The date and time when the graph utilization percentage was last updated.
	// The value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage instead.
	PercentOfGraphUtilizationUpdatedTime *time.Time `deprecated:"true" type:"timestamp" timestampFormat:"iso8601"`

	// The current membership status of the member account. The status can have
	// one of the following values:
	//
	//    * INVITED - For invited accounts only. Indicates that the member was sent
	//    an invitation but has not yet responded.
	//
	//    * VERIFICATION_IN_PROGRESS - For invited accounts only, indicates that
	//    Detective is verifying that the account identifier and email address provided
	//    for the member account match. If they do match, then Detective sends the
	//    invitation. If the email address and account identifier don't match, then
	//    the member cannot be added to the behavior graph. For organization accounts
	//    in the organization behavior graph, indicates that Detective is verifying
	//    that the account belongs to the organization.
	//
	//    * VERIFICATION_FAILED - For invited accounts only. Indicates that the
	//    account and email address provided for the member account do not match,
	//    and Detective did not send an invitation to the account.
	//
	//    * ENABLED - Indicates that the member account currently contributes data
	//    to the behavior graph. For invited accounts, the member account accepted
	//    the invitation. For organization accounts in the organization behavior
	//    graph, the Detective administrator account enabled the organization account
	//    as a member account.
	//
	//    * ACCEPTED_BUT_DISABLED - The account accepted the invitation, or was
	//    enabled by the Detective administrator account, but is prevented from
	//    contributing data to the behavior graph. DisabledReason provides the reason
	//    why the member account is not enabled.
	//
	// Invited accounts that declined an invitation or that were removed from the
	// behavior graph are not included. In the organization behavior graph, organization
	// accounts that the Detective administrator account did not enable are not
	// included.
	Status *string `type:"string" enum:"MemberStatus"`

	// The date and time that the member account was last updated. The value is
	// an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	UpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Details on the volume of usage for each data source package in a behavior
	// graph.
	VolumeUsageByDatasourcePackage map[string]*DatasourcePackageUsageInfo `type:"map"`

	// The data volume in bytes per day for the member account.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage instead.
	VolumeUsageInBytes *int64 `deprecated:"true" type:"long"`

	// The data and time when the member account data volume was last updated. The
	// value is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	//
	// Deprecated: This property is deprecated. Use VolumeUsageByDatasourcePackage instead.
	VolumeUsageUpdatedTime *time.Time `deprecated:"true" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberDetail) SetAccountId(v string) *MemberDetail {
	s.AccountId = &v
	return s
}

// SetAdministratorId sets the AdministratorId field's value.
func (s *MemberDetail) SetAdministratorId(v string) *MemberDetail {
	s.AdministratorId = &v
	return s
}

// SetDatasourcePackageIngestStates sets the DatasourcePackageIngestStates field's value.
func (s *MemberDetail) SetDatasourcePackageIngestStates(v map[string]*string) *MemberDetail {
	s.DatasourcePackageIngestStates = v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *MemberDetail) SetDisabledReason(v string) *MemberDetail {
	s.DisabledReason = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *MemberDetail) SetEmailAddress(v string) *MemberDetail {
	s.EmailAddress = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *MemberDetail) SetGraphArn(v string) *MemberDetail {
	s.GraphArn = &v
	return s
}

// SetInvitationType sets the InvitationType field's value.
func (s *MemberDetail) SetInvitationType(v string) *MemberDetail {
	s.InvitationType = &v
	return s
}

// SetInvitedTime sets the InvitedTime field's value.
func (s *MemberDetail) SetInvitedTime(v time.Time) *MemberDetail {
	s.InvitedTime = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *MemberDetail) SetMasterId(v string) *MemberDetail {
	s.MasterId = &v
	return s
}

// SetPercentOfGraphUtilization sets the PercentOfGraphUtilization field's value.
func (s *MemberDetail) SetPercentOfGraphUtilization(v float64) *MemberDetail {
	s.PercentOfGraphUtilization = &v
	return s
}

// SetPercentOfGraphUtilizationUpdatedTime sets the PercentOfGraphUtilizationUpdatedTime field's value.
func (s *MemberDetail) SetPercentOfGraphUtilizationUpdatedTime(v time.Time) *MemberDetail {
	s.PercentOfGraphUtilizationUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MemberDetail) SetStatus(v string) *MemberDetail {
	s.Status = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *MemberDetail) SetUpdatedTime(v time.Time) *MemberDetail {
	s.UpdatedTime = &v
	return s
}

// SetVolumeUsageByDatasourcePackage sets the VolumeUsageByDatasourcePackage field's value.
func (s *MemberDetail) SetVolumeUsageByDatasourcePackage(v map[string]*DatasourcePackageUsageInfo) *MemberDetail {
	s.VolumeUsageByDatasourcePackage = v
	return s
}

// SetVolumeUsageInBytes sets the VolumeUsageInBytes field's value.
func (s *MemberDetail) SetVolumeUsageInBytes(v int64) *MemberDetail {
	s.VolumeUsageInBytes = &v
	return s
}

// SetVolumeUsageUpdatedTime sets the VolumeUsageUpdatedTime field's value.
func (s *MemberDetail) SetVolumeUsageUpdatedTime(v time.Time) *MemberDetail {
	s.VolumeUsageUpdatedTime = &v
	return s
}

// Details on data source packages for members of the behavior graph.
type MembershipDatasources struct {
	_ struct{} `type:"structure"`

	// The account identifier of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// Details on when a data source package was added to a behavior graph.
	DatasourcePackageIngestHistory map[string]map[string]*TimestampForCollection `type:"map"`

	// The ARN of the organization behavior graph.
	GraphArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipDatasources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MembershipDatasources) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MembershipDatasources) SetAccountId(v string) *MembershipDatasources {
	s.AccountId = &v
	return s
}

// SetDatasourcePackageIngestHistory sets the DatasourcePackageIngestHistory field's value.
func (s *MembershipDatasources) SetDatasourcePackageIngestHistory(v map[string]map[string]*TimestampForCollection) *MembershipDatasources {
	s.DatasourcePackageIngestHistory = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *MembershipDatasources) SetGraphArn(v string) *MembershipDatasources {
	s.GraphArn = &v
	return s
}

// Details new Autonomous System Organizations (ASOs) used either at the resource
// or account level.
type NewAsoDetail struct {
	_ struct{} `type:"structure"`

	// Details about the new Autonomous System Organization (ASO).
	Aso *string `type:"string"`

	// Checks if the ASO is for new for the entire account.
	IsNewForEntireAccount *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewAsoDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewAsoDetail) GoString() string {
	return s.String()
}

// SetAso sets the Aso field's value.
func (s *NewAsoDetail) SetAso(v string) *NewAsoDetail {
	s.Aso = &v
	return s
}

// SetIsNewForEntireAccount sets the IsNewForEntireAccount field's value.
func (s *NewAsoDetail) SetIsNewForEntireAccount(v bool) *NewAsoDetail {
	s.IsNewForEntireAccount = &v
	return s
}

// Details new geolocations used either at the resource or account level. For
// example, lists an observed geolocation that is an infrequent or unused location
// based on previous user activity.
type NewGeolocationDetail struct {
	_ struct{} `type:"structure"`

	// IP address using which the resource was accessed.
	IpAddress *string `type:"string"`

	// Checks if the gelocation is new for the entire account.
	IsNewForEntireAccount *bool `type:"boolean"`

	// Location where the resource was accessed.
	Location *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewGeolocationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewGeolocationDetail) GoString() string {
	return s.String()
}

// SetIpAddress sets the IpAddress field's value.
func (s *NewGeolocationDetail) SetIpAddress(v string) *NewGeolocationDetail {
	s.IpAddress = &v
	return s
}

// SetIsNewForEntireAccount sets the IsNewForEntireAccount field's value.
func (s *NewGeolocationDetail) SetIsNewForEntireAccount(v bool) *NewGeolocationDetail {
	s.IsNewForEntireAccount = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *NewGeolocationDetail) SetLocation(v string) *NewGeolocationDetail {
	s.Location = &v
	return s
}

// Details new user agents used either at the resource or account level.
type NewUserAgentDetail struct {
	_ struct{} `type:"structure"`

	// Checks if the user agent is new for the entire account.
	IsNewForEntireAccount *bool `type:"boolean"`

	// New user agent which accessed the resource.
	UserAgent *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewUserAgentDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewUserAgentDetail) GoString() string {
	return s.String()
}

// SetIsNewForEntireAccount sets the IsNewForEntireAccount field's value.
func (s *NewUserAgentDetail) SetIsNewForEntireAccount(v bool) *NewUserAgentDetail {
	s.IsNewForEntireAccount = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *NewUserAgentDetail) SetUserAgent(v string) *NewUserAgentDetail {
	s.UserAgent = &v
	return s
}

type RejectInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to reject the invitation to.
	//
	// The member account's current member status in the behavior graph must be
	// INVITED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInvitationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *RejectInvitationInput) SetGraphArn(v string) *RejectInvitationInput {
	s.GraphArn = &v
	return s
}

type RejectInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectInvitationOutput) GoString() string {
	return s.String()
}

// Details related activities associated with a potential security event. Lists
// all distinct categories of evidence that are connected to the resource or
// the finding group.
type RelatedFindingDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the related finding.
	Arn *string `type:"string"`

	// The IP address of the finding.
	IpAddress *string `type:"string"`

	// The type of finding.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedFindingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedFindingDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RelatedFindingDetail) SetArn(v string) *RelatedFindingDetail {
	s.Arn = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *RelatedFindingDetail) SetIpAddress(v string) *RelatedFindingDetail {
	s.IpAddress = &v
	return s
}

// SetType sets the Type field's value.
func (s *RelatedFindingDetail) SetType(v string) *RelatedFindingDetail {
	s.Type = &v
	return s
}

// Details multiple activities as they related to a potential security event.
// Detective uses graph analysis technique that infers relationships between
// findings and entities, and groups them together as a finding group.
type RelatedFindingGroupDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the finding group.
	Id *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedFindingGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedFindingGroupDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *RelatedFindingGroupDetail) SetId(v string) *RelatedFindingGroupDetail {
	s.Id = &v
	return s
}

// The request refers to a nonexistent resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This request cannot be completed for one of the following reasons.
//
//   - The request would cause the number of member accounts in the behavior
//     graph to exceed the maximum allowed. A behavior graph cannot have more
//     than 1200 member accounts.
//
//   - The request would cause the data rate for the behavior graph to exceed
//     the maximum allowed.
//
//   - Detective is unable to verify the data rate for the member account.
//     This is usually because the member account is not enrolled in Amazon GuardDuty.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The type of resource that has exceeded the service quota.
	Resources []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the criteria used for sorting investigations.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// Represents the Field attribute to sort investigations.
	Field *string `type:"string" enum:"Field"`

	// The order by which the sorted findings are displayed.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *SortCriteria) SetField(v string) *SortCriteria {
	s.Field = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortCriteria) SetSortOrder(v string) *SortCriteria {
	s.SortOrder = &v
	return s
}

type StartInvestigationInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
	//
	// EntityArn is a required field
	EntityArn *string `type:"string" required:"true"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The data and time when the investigation began. The value is an UTC ISO8601
	// formatted string. For example, 2021-08-18T16:35:56.284Z.
	//
	// ScopeEndTime is a required field
	ScopeEndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data and time when the investigation began. The value is an UTC ISO8601
	// formatted string. For example, 2021-08-18T16:35:56.284Z.
	//
	// ScopeStartTime is a required field
	ScopeStartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInvestigationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInvestigationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInvestigationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInvestigationInput"}
	if s.EntityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityArn"))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.ScopeEndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeEndTime"))
	}
	if s.ScopeStartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ScopeStartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityArn sets the EntityArn field's value.
func (s *StartInvestigationInput) SetEntityArn(v string) *StartInvestigationInput {
	s.EntityArn = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *StartInvestigationInput) SetGraphArn(v string) *StartInvestigationInput {
	s.GraphArn = &v
	return s
}

// SetScopeEndTime sets the ScopeEndTime field's value.
func (s *StartInvestigationInput) SetScopeEndTime(v time.Time) *StartInvestigationInput {
	s.ScopeEndTime = &v
	return s
}

// SetScopeStartTime sets the ScopeStartTime field's value.
func (s *StartInvestigationInput) SetScopeStartTime(v time.Time) *StartInvestigationInput {
	s.ScopeStartTime = &v
	return s
}

type StartInvestigationOutput struct {
	_ struct{} `type:"structure"`

	// The investigation ID of the investigation report.
	InvestigationId *string `min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInvestigationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInvestigationOutput) GoString() string {
	return s.String()
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *StartInvestigationOutput) SetInvestigationId(v string) *StartInvestigationOutput {
	s.InvestigationId = &v
	return s
}

type StartMonitoringMemberInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the member account to try to enable.
	//
	// The account must be an invited member account with a status of ACCEPTED_BUT_DISABLED.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMonitoringMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMonitoringMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMonitoringMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMonitoringMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *StartMonitoringMemberInput) SetAccountId(v string) *StartMonitoringMemberInput {
	s.AccountId = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *StartMonitoringMemberInput) SetGraphArn(v string) *StartMonitoringMemberInput {
	s.GraphArn = &v
	return s
}

type StartMonitoringMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMonitoringMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMonitoringMemberOutput) GoString() string {
	return s.String()
}

// A string for filtering Detective investigations.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// The string filter value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StringFilter"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *StringFilter) SetValue(v string) *StringFilter {
	s.Value = &v
	return s
}

// Details tactics, techniques, and procedures (TTPs) used in a potential security
// event. Tactics are based on MITRE ATT&CK Matrix for Enterprise (https://attack.mitre.org/matrices/enterprise/).
type TTPsObservedDetail struct {
	_ struct{} `type:"structure"`

	// The total number of failed API requests.
	APIFailureCount *int64 `type:"long"`

	// The name of the API where the TTP was observed.
	APIName *string `type:"string"`

	// The total number of successful API requests.
	APISuccessCount *int64 `type:"long"`

	// The IP address where the TTP was observed.
	IpAddress *string `type:"string"`

	// The procedure used, identified by the investigation.
	Procedure *string `type:"string"`

	// The tactic used, identified by the investigation.
	Tactic *string `type:"string"`

	// The technique used, identified by the investigation.
	Technique *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TTPsObservedDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TTPsObservedDetail) GoString() string {
	return s.String()
}

// SetAPIFailureCount sets the APIFailureCount field's value.
func (s *TTPsObservedDetail) SetAPIFailureCount(v int64) *TTPsObservedDetail {
	s.APIFailureCount = &v
	return s
}

// SetAPIName sets the APIName field's value.
func (s *TTPsObservedDetail) SetAPIName(v string) *TTPsObservedDetail {
	s.APIName = &v
	return s
}

// SetAPISuccessCount sets the APISuccessCount field's value.
func (s *TTPsObservedDetail) SetAPISuccessCount(v int64) *TTPsObservedDetail {
	s.APISuccessCount = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *TTPsObservedDetail) SetIpAddress(v string) *TTPsObservedDetail {
	s.IpAddress = &v
	return s
}

// SetProcedure sets the Procedure field's value.
func (s *TTPsObservedDetail) SetProcedure(v string) *TTPsObservedDetail {
	s.Procedure = &v
	return s
}

// SetTactic sets the Tactic field's value.
func (s *TTPsObservedDetail) SetTactic(v string) *TTPsObservedDetail {
	s.Tactic = &v
	return s
}

// SetTechnique sets the Technique field's value.
func (s *TTPsObservedDetail) SetTechnique(v string) *TTPsObservedDetail {
	s.Technique = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to assign the tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to assign to the behavior graph. You can add up to 50 tags. For
	// each tag, you provide the tag key and the tag value. Each tag key can contain
	// up to 128 characters. Each tag value can contain up to 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details on when data collection began for a source package.
type TimestampForCollection struct {
	_ struct{} `type:"structure"`

	// The data and time when data collection began for a source package. The value
	// is an ISO8601 formatted string. For example, 2021-08-18T16:35:56.284Z.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampForCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestampForCollection) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *TimestampForCollection) SetTimestamp(v time.Time) *TimestampForCollection {
	s.Timestamp = &v
	return s
}

// The request cannot be completed because too many other requests are occurring
// at the same time.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A member account that was included in a request but for which the request
// could not be processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account identifier of the member account that was
	// not processed.
	AccountId *string `min:"12" type:"string"`

	// The reason that the member account request could not be processed.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UnprocessedAccount) SetAccountId(v string) *UnprocessedAccount {
	s.AccountId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UnprocessedAccount) SetReason(v string) *UnprocessedAccount {
	s.Reason = &v
	return s
}

// Behavior graphs that could not be processed in the request.
type UnprocessedGraph struct {
	_ struct{} `type:"structure"`

	// The ARN of the organization behavior graph.
	GraphArn *string `type:"string"`

	// The reason data source package information could not be processed for a behavior
	// graph.
	Reason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedGraph) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedGraph) GoString() string {
	return s.String()
}

// SetGraphArn sets the GraphArn field's value.
func (s *UnprocessedGraph) SetGraphArn(v string) *UnprocessedGraph {
	s.GraphArn = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UnprocessedGraph) SetReason(v string) *UnprocessedGraph {
	s.Reason = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the behavior graph to remove the tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tag keys of the tags to remove from the behavior graph. You can remove
	// up to 50 tags at a time.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatasourcePackagesInput struct {
	_ struct{} `type:"structure"`

	// The data source package start for the behavior graph.
	//
	// DatasourcePackages is a required field
	DatasourcePackages []*string `min:"1" type:"list" required:"true" enum:"DatasourcePackage"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasourcePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasourcePackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasourcePackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasourcePackagesInput"}
	if s.DatasourcePackages == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasourcePackages"))
	}
	if s.DatasourcePackages != nil && len(s.DatasourcePackages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasourcePackages", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasourcePackages sets the DatasourcePackages field's value.
func (s *UpdateDatasourcePackagesInput) SetDatasourcePackages(v []*string) *UpdateDatasourcePackagesInput {
	s.DatasourcePackages = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *UpdateDatasourcePackagesInput) SetGraphArn(v string) *UpdateDatasourcePackagesInput {
	s.GraphArn = &v
	return s
}

type UpdateDatasourcePackagesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasourcePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasourcePackagesOutput) GoString() string {
	return s.String()
}

type UpdateInvestigationStateInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The investigation ID of the investigation report.
	//
	// InvestigationId is a required field
	InvestigationId *string `min:"21" type:"string" required:"true"`

	// The current state of the investigation. An archived investigation indicates
	// you have completed reviewing the investigation.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInvestigationStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInvestigationStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInvestigationStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInvestigationStateInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.InvestigationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvestigationId"))
	}
	if s.InvestigationId != nil && len(*s.InvestigationId) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("InvestigationId", 21))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *UpdateInvestigationStateInput) SetGraphArn(v string) *UpdateInvestigationStateInput {
	s.GraphArn = &v
	return s
}

// SetInvestigationId sets the InvestigationId field's value.
func (s *UpdateInvestigationStateInput) SetInvestigationId(v string) *UpdateInvestigationStateInput {
	s.InvestigationId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateInvestigationStateInput) SetState(v string) *UpdateInvestigationStateInput {
	s.State = &v
	return s
}

type UpdateInvestigationStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInvestigationStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInvestigationStateOutput) GoString() string {
	return s.String()
}

type UpdateOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to automatically enable new organization accounts as member
	// accounts in the organization behavior graph.
	AutoEnable *bool `type:"boolean"`

	// The ARN of the organization behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationConfigurationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationInput) SetAutoEnable(v bool) *UpdateOrganizationConfigurationInput {
	s.AutoEnable = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *UpdateOrganizationConfigurationInput) SetGraphArn(v string) *UpdateOrganizationConfigurationInput {
	s.GraphArn = &v
	return s
}

type UpdateOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// The request parameters are invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code associated with the validation failure.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// An explanation of why validation failed.
	ErrorCodeReason *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DatasourcePackageDetectiveCore is a DatasourcePackage enum value
	DatasourcePackageDetectiveCore = "DETECTIVE_CORE"

	// DatasourcePackageEksAudit is a DatasourcePackage enum value
	DatasourcePackageEksAudit = "EKS_AUDIT"

	// DatasourcePackageAsffSecurityhubFinding is a DatasourcePackage enum value
	DatasourcePackageAsffSecurityhubFinding = "ASFF_SECURITYHUB_FINDING"
)

// DatasourcePackage_Values returns all elements of the DatasourcePackage enum
func DatasourcePackage_Values() []string {
	return []string{
		DatasourcePackageDetectiveCore,
		DatasourcePackageEksAudit,
		DatasourcePackageAsffSecurityhubFinding,
	}
}

const (
	// DatasourcePackageIngestStateStarted is a DatasourcePackageIngestState enum value
	DatasourcePackageIngestStateStarted = "STARTED"

	// DatasourcePackageIngestStateStopped is a DatasourcePackageIngestState enum value
	DatasourcePackageIngestStateStopped = "STOPPED"

	// DatasourcePackageIngestStateDisabled is a DatasourcePackageIngestState enum value
	DatasourcePackageIngestStateDisabled = "DISABLED"
)

// DatasourcePackageIngestState_Values returns all elements of the DatasourcePackageIngestState enum
func DatasourcePackageIngestState_Values() []string {
	return []string{
		DatasourcePackageIngestStateStarted,
		DatasourcePackageIngestStateStopped,
		DatasourcePackageIngestStateDisabled,
	}
}

const (
	// EntityTypeIamRole is a EntityType enum value
	EntityTypeIamRole = "IAM_ROLE"

	// EntityTypeIamUser is a EntityType enum value
	EntityTypeIamUser = "IAM_USER"
)

// EntityType_Values returns all elements of the EntityType enum
func EntityType_Values() []string {
	return []string{
		EntityTypeIamRole,
		EntityTypeIamUser,
	}
}

const (
	// ErrorCodeInvalidGraphArn is a ErrorCode enum value
	ErrorCodeInvalidGraphArn = "INVALID_GRAPH_ARN"

	// ErrorCodeInvalidRequestBody is a ErrorCode enum value
	ErrorCodeInvalidRequestBody = "INVALID_REQUEST_BODY"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "INTERNAL_ERROR"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeInvalidGraphArn,
		ErrorCodeInvalidRequestBody,
		ErrorCodeInternalError,
	}
}

const (
	// FieldSeverity is a Field enum value
	FieldSeverity = "SEVERITY"

	// FieldStatus is a Field enum value
	FieldStatus = "STATUS"

	// FieldCreatedTime is a Field enum value
	FieldCreatedTime = "CREATED_TIME"
)

// Field_Values returns all elements of the Field enum
func Field_Values() []string {
	return []string{
		FieldSeverity,
		FieldStatus,
		FieldCreatedTime,
	}
}

const (
	// IndicatorTypeTtpObserved is a IndicatorType enum value
	IndicatorTypeTtpObserved = "TTP_OBSERVED"

	// IndicatorTypeImpossibleTravel is a IndicatorType enum value
	IndicatorTypeImpossibleTravel = "IMPOSSIBLE_TRAVEL"

	// IndicatorTypeFlaggedIpAddress is a IndicatorType enum value
	IndicatorTypeFlaggedIpAddress = "FLAGGED_IP_ADDRESS"

	// IndicatorTypeNewGeolocation is a IndicatorType enum value
	IndicatorTypeNewGeolocation = "NEW_GEOLOCATION"

	// IndicatorTypeNewAso is a IndicatorType enum value
	IndicatorTypeNewAso = "NEW_ASO"

	// IndicatorTypeNewUserAgent is a IndicatorType enum value
	IndicatorTypeNewUserAgent = "NEW_USER_AGENT"

	// IndicatorTypeRelatedFinding is a IndicatorType enum value
	IndicatorTypeRelatedFinding = "RELATED_FINDING"

	// IndicatorTypeRelatedFindingGroup is a IndicatorType enum value
	IndicatorTypeRelatedFindingGroup = "RELATED_FINDING_GROUP"
)

// IndicatorType_Values returns all elements of the IndicatorType enum
func IndicatorType_Values() []string {
	return []string{
		IndicatorTypeTtpObserved,
		IndicatorTypeImpossibleTravel,
		IndicatorTypeFlaggedIpAddress,
		IndicatorTypeNewGeolocation,
		IndicatorTypeNewAso,
		IndicatorTypeNewUserAgent,
		IndicatorTypeRelatedFinding,
		IndicatorTypeRelatedFindingGroup,
	}
}

const (
	// InvitationTypeInvitation is a InvitationType enum value
	InvitationTypeInvitation = "INVITATION"

	// InvitationTypeOrganization is a InvitationType enum value
	InvitationTypeOrganization = "ORGANIZATION"
)

// InvitationType_Values returns all elements of the InvitationType enum
func InvitationType_Values() []string {
	return []string{
		InvitationTypeInvitation,
		InvitationTypeOrganization,
	}
}

const (
	// MemberDisabledReasonVolumeTooHigh is a MemberDisabledReason enum value
	MemberDisabledReasonVolumeTooHigh = "VOLUME_TOO_HIGH"

	// MemberDisabledReasonVolumeUnknown is a MemberDisabledReason enum value
	MemberDisabledReasonVolumeUnknown = "VOLUME_UNKNOWN"
)

// MemberDisabledReason_Values returns all elements of the MemberDisabledReason enum
func MemberDisabledReason_Values() []string {
	return []string{
		MemberDisabledReasonVolumeTooHigh,
		MemberDisabledReasonVolumeUnknown,
	}
}

const (
	// MemberStatusInvited is a MemberStatus enum value
	MemberStatusInvited = "INVITED"

	// MemberStatusVerificationInProgress is a MemberStatus enum value
	MemberStatusVerificationInProgress = "VERIFICATION_IN_PROGRESS"

	// MemberStatusVerificationFailed is a MemberStatus enum value
	MemberStatusVerificationFailed = "VERIFICATION_FAILED"

	// MemberStatusEnabled is a MemberStatus enum value
	MemberStatusEnabled = "ENABLED"

	// MemberStatusAcceptedButDisabled is a MemberStatus enum value
	MemberStatusAcceptedButDisabled = "ACCEPTED_BUT_DISABLED"
)

// MemberStatus_Values returns all elements of the MemberStatus enum
func MemberStatus_Values() []string {
	return []string{
		MemberStatusInvited,
		MemberStatusVerificationInProgress,
		MemberStatusVerificationFailed,
		MemberStatusEnabled,
		MemberStatusAcceptedButDisabled,
	}
}

const (
	// ReasonAwsThreatIntelligence is a Reason enum value
	ReasonAwsThreatIntelligence = "AWS_THREAT_INTELLIGENCE"
)

// Reason_Values returns all elements of the Reason enum
func Reason_Values() []string {
	return []string{
		ReasonAwsThreatIntelligence,
	}
}

const (
	// SeverityInformational is a Severity enum value
	SeverityInformational = "INFORMATIONAL"

	// SeverityLow is a Severity enum value
	SeverityLow = "LOW"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "MEDIUM"

	// SeverityHigh is a Severity enum value
	SeverityHigh = "HIGH"

	// SeverityCritical is a Severity enum value
	SeverityCritical = "CRITICAL"
)

// Severity_Values returns all elements of the Severity enum
func Severity_Values() []string {
	return []string{
		SeverityInformational,
		SeverityLow,
		SeverityMedium,
		SeverityHigh,
		SeverityCritical,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// StateActive is a State enum value
	StateActive = "ACTIVE"

	// StateArchived is a State enum value
	StateArchived = "ARCHIVED"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateActive,
		StateArchived,
	}
}

const (
	// StatusRunning is a Status enum value
	StatusRunning = "RUNNING"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"

	// StatusSuccessful is a Status enum value
	StatusSuccessful = "SUCCESSFUL"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusRunning,
		StatusFailed,
		StatusSuccessful,
	}
}
