// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opActivateEventSource = "ActivateEventSource"

// ActivateEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the ActivateEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateEventSource for more information on using the ActivateEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateEventSourceRequest method.
//	req, resp := client.ActivateEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ActivateEventSource
func (c *EventBridge) ActivateEventSourceRequest(input *ActivateEventSourceInput) (req *request.Request, output *ActivateEventSourceOutput) {
	op := &request.Operation{
		Name:       opActivateEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateEventSourceInput{}
	}

	output = &ActivateEventSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ActivateEventSource API operation for Amazon EventBridge.
//
// Activates a partner event source that has been deactivated. Once activated,
// your matching event bus will start receiving events from the event source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ActivateEventSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - InvalidStateException
//     The specified state is not a valid state for an event source.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ActivateEventSource
func (c *EventBridge) ActivateEventSource(input *ActivateEventSourceInput) (*ActivateEventSourceOutput, error) {
	req, out := c.ActivateEventSourceRequest(input)
	return out, req.Send()
}

// ActivateEventSourceWithContext is the same as ActivateEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ActivateEventSourceWithContext(ctx aws.Context, input *ActivateEventSourceInput, opts ...request.Option) (*ActivateEventSourceOutput, error) {
	req, out := c.ActivateEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelReplay = "CancelReplay"

// CancelReplayRequest generates a "aws/request.Request" representing the
// client's request for the CancelReplay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelReplay for more information on using the CancelReplay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelReplayRequest method.
//	req, resp := client.CancelReplayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CancelReplay
func (c *EventBridge) CancelReplayRequest(input *CancelReplayInput) (req *request.Request, output *CancelReplayOutput) {
	op := &request.Operation{
		Name:       opCancelReplay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReplayInput{}
	}

	output = &CancelReplayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReplay API operation for Amazon EventBridge.
//
// Cancels the specified replay.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CancelReplay for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - IllegalStatusException
//     An error occurred because a replay can be canceled only when the state is
//     Running or Starting.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CancelReplay
func (c *EventBridge) CancelReplay(input *CancelReplayInput) (*CancelReplayOutput, error) {
	req, out := c.CancelReplayRequest(input)
	return out, req.Send()
}

// CancelReplayWithContext is the same as CancelReplay with the addition of
// the ability to pass a context and additional request options.
//
// See CancelReplay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CancelReplayWithContext(ctx aws.Context, input *CancelReplayInput, opts ...request.Option) (*CancelReplayOutput, error) {
	req, out := c.CancelReplayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApiDestination = "CreateApiDestination"

// CreateApiDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApiDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApiDestination for more information on using the CreateApiDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApiDestinationRequest method.
//	req, resp := client.CreateApiDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateApiDestination
func (c *EventBridge) CreateApiDestinationRequest(input *CreateApiDestinationInput) (req *request.Request, output *CreateApiDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateApiDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApiDestinationInput{}
	}

	output = &CreateApiDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApiDestination API operation for Amazon EventBridge.
//
// Creates an API destination, which is an HTTP invocation endpoint configured
// as a target for events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreateApiDestination for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateApiDestination
func (c *EventBridge) CreateApiDestination(input *CreateApiDestinationInput) (*CreateApiDestinationOutput, error) {
	req, out := c.CreateApiDestinationRequest(input)
	return out, req.Send()
}

// CreateApiDestinationWithContext is the same as CreateApiDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApiDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreateApiDestinationWithContext(ctx aws.Context, input *CreateApiDestinationInput, opts ...request.Option) (*CreateApiDestinationOutput, error) {
	req, out := c.CreateApiDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateArchive = "CreateArchive"

// CreateArchiveRequest generates a "aws/request.Request" representing the
// client's request for the CreateArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateArchive for more information on using the CreateArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateArchiveRequest method.
//	req, resp := client.CreateArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateArchive
func (c *EventBridge) CreateArchiveRequest(input *CreateArchiveInput) (req *request.Request, output *CreateArchiveOutput) {
	op := &request.Operation{
		Name:       opCreateArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateArchiveInput{}
	}

	output = &CreateArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateArchive API operation for Amazon EventBridge.
//
// Creates an archive of events with the specified settings. When you create
// an archive, incoming events might not immediately start being sent to the
// archive. Allow a short period of time for changes to take effect. If you
// do not specify a pattern to filter events sent to the archive, all events
// are sent to the archive except replayed events. Replayed events are not sent
// to an archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreateArchive for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InvalidEventPatternException
//     The event pattern is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateArchive
func (c *EventBridge) CreateArchive(input *CreateArchiveInput) (*CreateArchiveOutput, error) {
	req, out := c.CreateArchiveRequest(input)
	return out, req.Send()
}

// CreateArchiveWithContext is the same as CreateArchive with the addition of
// the ability to pass a context and additional request options.
//
// See CreateArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreateArchiveWithContext(ctx aws.Context, input *CreateArchiveInput, opts ...request.Option) (*CreateArchiveOutput, error) {
	req, out := c.CreateArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectionRequest method.
//	req, resp := client.CreateConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateConnection
func (c *EventBridge) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *CreateConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &CreateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for Amazon EventBridge.
//
// Creates a connection. A connection defines the authorization type and credentials
// to use for authorization with an API destination HTTP endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreateConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateConnection
func (c *EventBridge) CreateConnection(input *CreateConnectionInput) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointRequest method.
//	req, resp := client.CreateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEndpoint
func (c *EventBridge) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon EventBridge.
//
// Creates a global endpoint. Global endpoints improve your application's availability
// by making it regional-fault tolerant. To do this, you define a primary and
// secondary Region with event buses in each Region. You also create a Amazon
// Route 53 health check that will tell EventBridge to route events to the secondary
// Region when an "unhealthy" state is encountered and events will be routed
// back to the primary Region when the health check reports a "healthy" state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEndpoint
func (c *EventBridge) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventBus = "CreateEventBus"

// CreateEventBusRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventBus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventBus for more information on using the CreateEventBus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventBusRequest method.
//	req, resp := client.CreateEventBusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEventBus
func (c *EventBridge) CreateEventBusRequest(input *CreateEventBusInput) (req *request.Request, output *CreateEventBusOutput) {
	op := &request.Operation{
		Name:       opCreateEventBus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventBusInput{}
	}

	output = &CreateEventBusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventBus API operation for Amazon EventBridge.
//
// Creates a new event bus within your account. This can be a custom event bus
// which you can use to receive events from your custom applications and services,
// or it can be a partner event bus which can be matched to a partner event
// source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreateEventBus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InvalidStateException
//     The specified state is not a valid state for an event source.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreateEventBus
func (c *EventBridge) CreateEventBus(input *CreateEventBusInput) (*CreateEventBusOutput, error) {
	req, out := c.CreateEventBusRequest(input)
	return out, req.Send()
}

// CreateEventBusWithContext is the same as CreateEventBus with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventBus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreateEventBusWithContext(ctx aws.Context, input *CreateEventBusInput, opts ...request.Option) (*CreateEventBusOutput, error) {
	req, out := c.CreateEventBusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartnerEventSource = "CreatePartnerEventSource"

// CreatePartnerEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartnerEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartnerEventSource for more information on using the CreatePartnerEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePartnerEventSourceRequest method.
//	req, resp := client.CreatePartnerEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreatePartnerEventSource
func (c *EventBridge) CreatePartnerEventSourceRequest(input *CreatePartnerEventSourceInput) (req *request.Request, output *CreatePartnerEventSourceOutput) {
	op := &request.Operation{
		Name:       opCreatePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartnerEventSourceInput{}
	}

	output = &CreatePartnerEventSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePartnerEventSource API operation for Amazon EventBridge.
//
// Called by an SaaS partner to create a partner event source. This operation
// is not used by Amazon Web Services customers.
//
// Each partner event source can be used by one Amazon Web Services account
// to create a matching partner event bus in that Amazon Web Services account.
// A SaaS partner must create one partner event source for each Amazon Web Services
// account that wants to receive those event types.
//
// A partner event source creates events based on resources within the SaaS
// partner's service or application.
//
// An Amazon Web Services account that creates a partner event bus that matches
// the partner event source can use that event bus to receive events from the
// partner, and then process them using Amazon Web Services Events rules and
// targets.
//
// Partner event source names follow this format:
//
// partner_name/event_namespace/event_name
//
// partner_name is determined during partner registration and identifies the
// partner to Amazon Web Services customers. event_namespace is determined by
// the partner and is a way for the partner to categorize their events. event_name
// is determined by the partner, and should uniquely identify an event-generating
// resource within the partner system. The combination of event_namespace and
// event_name should help Amazon Web Services customers decide whether to create
// an event bus to receive these events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation CreatePartnerEventSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/CreatePartnerEventSource
func (c *EventBridge) CreatePartnerEventSource(input *CreatePartnerEventSourceInput) (*CreatePartnerEventSourceOutput, error) {
	req, out := c.CreatePartnerEventSourceRequest(input)
	return out, req.Send()
}

// CreatePartnerEventSourceWithContext is the same as CreatePartnerEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartnerEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) CreatePartnerEventSourceWithContext(ctx aws.Context, input *CreatePartnerEventSourceInput, opts ...request.Option) (*CreatePartnerEventSourceOutput, error) {
	req, out := c.CreatePartnerEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateEventSource = "DeactivateEventSource"

// DeactivateEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateEventSource for more information on using the DeactivateEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateEventSourceRequest method.
//	req, resp := client.DeactivateEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeactivateEventSource
func (c *EventBridge) DeactivateEventSourceRequest(input *DeactivateEventSourceInput) (req *request.Request, output *DeactivateEventSourceOutput) {
	op := &request.Operation{
		Name:       opDeactivateEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateEventSourceInput{}
	}

	output = &DeactivateEventSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateEventSource API operation for Amazon EventBridge.
//
// You can use this operation to temporarily stop receiving events from the
// specified partner event source. The matching event bus is not deleted.
//
// When you deactivate a partner event source, the source goes into PENDING
// state. If it remains in PENDING state for more than two weeks, it is deleted.
//
// To activate a deactivated partner event source, use ActivateEventSource (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeactivateEventSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - InvalidStateException
//     The specified state is not a valid state for an event source.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeactivateEventSource
func (c *EventBridge) DeactivateEventSource(input *DeactivateEventSourceInput) (*DeactivateEventSourceOutput, error) {
	req, out := c.DeactivateEventSourceRequest(input)
	return out, req.Send()
}

// DeactivateEventSourceWithContext is the same as DeactivateEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeactivateEventSourceWithContext(ctx aws.Context, input *DeactivateEventSourceInput, opts ...request.Option) (*DeactivateEventSourceOutput, error) {
	req, out := c.DeactivateEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeauthorizeConnection = "DeauthorizeConnection"

// DeauthorizeConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeauthorizeConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeauthorizeConnection for more information on using the DeauthorizeConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeauthorizeConnectionRequest method.
//	req, resp := client.DeauthorizeConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeauthorizeConnection
func (c *EventBridge) DeauthorizeConnectionRequest(input *DeauthorizeConnectionInput) (req *request.Request, output *DeauthorizeConnectionOutput) {
	op := &request.Operation{
		Name:       opDeauthorizeConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeauthorizeConnectionInput{}
	}

	output = &DeauthorizeConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeauthorizeConnection API operation for Amazon EventBridge.
//
// Removes all authorization parameters from the connection. This lets you remove
// the secret from the connection so you can reuse it without having to create
// a new connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeauthorizeConnection for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeauthorizeConnection
func (c *EventBridge) DeauthorizeConnection(input *DeauthorizeConnectionInput) (*DeauthorizeConnectionOutput, error) {
	req, out := c.DeauthorizeConnectionRequest(input)
	return out, req.Send()
}

// DeauthorizeConnectionWithContext is the same as DeauthorizeConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeauthorizeConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeauthorizeConnectionWithContext(ctx aws.Context, input *DeauthorizeConnectionInput, opts ...request.Option) (*DeauthorizeConnectionOutput, error) {
	req, out := c.DeauthorizeConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApiDestination = "DeleteApiDestination"

// DeleteApiDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApiDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApiDestination for more information on using the DeleteApiDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApiDestinationRequest method.
//	req, resp := client.DeleteApiDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteApiDestination
func (c *EventBridge) DeleteApiDestinationRequest(input *DeleteApiDestinationInput) (req *request.Request, output *DeleteApiDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteApiDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApiDestinationInput{}
	}

	output = &DeleteApiDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApiDestination API operation for Amazon EventBridge.
//
// Deletes the specified API destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteApiDestination for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteApiDestination
func (c *EventBridge) DeleteApiDestination(input *DeleteApiDestinationInput) (*DeleteApiDestinationOutput, error) {
	req, out := c.DeleteApiDestinationRequest(input)
	return out, req.Send()
}

// DeleteApiDestinationWithContext is the same as DeleteApiDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApiDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteApiDestinationWithContext(ctx aws.Context, input *DeleteApiDestinationInput, opts ...request.Option) (*DeleteApiDestinationOutput, error) {
	req, out := c.DeleteApiDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArchive = "DeleteArchive"

// DeleteArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArchive for more information on using the DeleteArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteArchiveRequest method.
//	req, resp := client.DeleteArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteArchive
func (c *EventBridge) DeleteArchiveRequest(input *DeleteArchiveInput) (req *request.Request, output *DeleteArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteArchiveInput{}
	}

	output = &DeleteArchiveOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteArchive API operation for Amazon EventBridge.
//
// Deletes the specified archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteArchive for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteArchive
func (c *EventBridge) DeleteArchive(input *DeleteArchiveInput) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	return out, req.Send()
}

// DeleteArchiveWithContext is the same as DeleteArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteArchiveWithContext(ctx aws.Context, input *DeleteArchiveInput, opts ...request.Option) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectionRequest method.
//	req, resp := client.DeleteConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteConnection
func (c *EventBridge) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for Amazon EventBridge.
//
// Deletes a connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteConnection
func (c *EventBridge) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointRequest method.
//	req, resp := client.DeleteEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEndpoint
func (c *EventBridge) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon EventBridge.
//
// Delete an existing global endpoint. For more information about global endpoints,
// see Making applications Regional-fault tolerant with global endpoints and
// event replication (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html)
// in the Amazon EventBridge User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEndpoint
func (c *EventBridge) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventBus = "DeleteEventBus"

// DeleteEventBusRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventBus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventBus for more information on using the DeleteEventBus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventBusRequest method.
//	req, resp := client.DeleteEventBusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEventBus
func (c *EventBridge) DeleteEventBusRequest(input *DeleteEventBusInput) (req *request.Request, output *DeleteEventBusOutput) {
	op := &request.Operation{
		Name:       opDeleteEventBus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventBusInput{}
	}

	output = &DeleteEventBusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventBus API operation for Amazon EventBridge.
//
// Deletes the specified custom event bus or partner event bus. All rules associated
// with this event bus need to be deleted. You can't delete your account's default
// event bus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteEventBus for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteEventBus
func (c *EventBridge) DeleteEventBus(input *DeleteEventBusInput) (*DeleteEventBusOutput, error) {
	req, out := c.DeleteEventBusRequest(input)
	return out, req.Send()
}

// DeleteEventBusWithContext is the same as DeleteEventBus with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventBus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteEventBusWithContext(ctx aws.Context, input *DeleteEventBusInput, opts ...request.Option) (*DeleteEventBusOutput, error) {
	req, out := c.DeleteEventBusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePartnerEventSource = "DeletePartnerEventSource"

// DeletePartnerEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeletePartnerEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePartnerEventSource for more information on using the DeletePartnerEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePartnerEventSourceRequest method.
//	req, resp := client.DeletePartnerEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeletePartnerEventSource
func (c *EventBridge) DeletePartnerEventSourceRequest(input *DeletePartnerEventSourceInput) (req *request.Request, output *DeletePartnerEventSourceOutput) {
	op := &request.Operation{
		Name:       opDeletePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartnerEventSourceInput{}
	}

	output = &DeletePartnerEventSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePartnerEventSource API operation for Amazon EventBridge.
//
// This operation is used by SaaS partners to delete a partner event source.
// This operation is not used by Amazon Web Services customers.
//
// When you delete an event source, the status of the corresponding partner
// event bus in the Amazon Web Services customer account becomes DELETED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeletePartnerEventSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeletePartnerEventSource
func (c *EventBridge) DeletePartnerEventSource(input *DeletePartnerEventSourceInput) (*DeletePartnerEventSourceOutput, error) {
	req, out := c.DeletePartnerEventSourceRequest(input)
	return out, req.Send()
}

// DeletePartnerEventSourceWithContext is the same as DeletePartnerEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePartnerEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeletePartnerEventSourceWithContext(ctx aws.Context, input *DeletePartnerEventSourceInput, opts ...request.Option) (*DeletePartnerEventSourceOutput, error) {
	req, out := c.DeletePartnerEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleRequest method.
//	req, resp := client.DeleteRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteRule
func (c *EventBridge) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon EventBridge.
//
// Deletes the specified rule.
//
// Before you can delete the rule, you must remove all targets, using RemoveTargets
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html).
//
// When you delete a rule, incoming events might continue to match to the deleted
// rule. Allow a short period of time for changes to take effect.
//
// If you call delete rule multiple times for the same rule, all calls will
// succeed. When you call delete rule for a non-existent custom eventbus, ResourceNotFoundException
// is returned.
//
// Managed rules are rules created and managed by another Amazon Web Services
// service on your behalf. These rules are created by those other Amazon Web
// Services services to support functionality in those services. You can delete
// these rules using the Force option, but you should do so only if you are
// sure the other service is not still using that rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeleteRule
func (c *EventBridge) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApiDestination = "DescribeApiDestination"

// DescribeApiDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApiDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApiDestination for more information on using the DescribeApiDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApiDestinationRequest method.
//	req, resp := client.DescribeApiDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeApiDestination
func (c *EventBridge) DescribeApiDestinationRequest(input *DescribeApiDestinationInput) (req *request.Request, output *DescribeApiDestinationOutput) {
	op := &request.Operation{
		Name:       opDescribeApiDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApiDestinationInput{}
	}

	output = &DescribeApiDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApiDestination API operation for Amazon EventBridge.
//
// Retrieves details about an API destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeApiDestination for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeApiDestination
func (c *EventBridge) DescribeApiDestination(input *DescribeApiDestinationInput) (*DescribeApiDestinationOutput, error) {
	req, out := c.DescribeApiDestinationRequest(input)
	return out, req.Send()
}

// DescribeApiDestinationWithContext is the same as DescribeApiDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApiDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeApiDestinationWithContext(ctx aws.Context, input *DescribeApiDestinationInput, opts ...request.Option) (*DescribeApiDestinationOutput, error) {
	req, out := c.DescribeApiDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeArchive = "DescribeArchive"

// DescribeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DescribeArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeArchive for more information on using the DescribeArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeArchiveRequest method.
//	req, resp := client.DescribeArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeArchive
func (c *EventBridge) DescribeArchiveRequest(input *DescribeArchiveInput) (req *request.Request, output *DescribeArchiveOutput) {
	op := &request.Operation{
		Name:       opDescribeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeArchiveInput{}
	}

	output = &DescribeArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeArchive API operation for Amazon EventBridge.
//
// Retrieves details about an archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeArchive for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeArchive
func (c *EventBridge) DescribeArchive(input *DescribeArchiveInput) (*DescribeArchiveOutput, error) {
	req, out := c.DescribeArchiveRequest(input)
	return out, req.Send()
}

// DescribeArchiveWithContext is the same as DescribeArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeArchiveWithContext(ctx aws.Context, input *DescribeArchiveInput, opts ...request.Option) (*DescribeArchiveOutput, error) {
	req, out := c.DescribeArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnection = "DescribeConnection"

// DescribeConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnection for more information on using the DescribeConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConnectionRequest method.
//	req, resp := client.DescribeConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeConnection
func (c *EventBridge) DescribeConnectionRequest(input *DescribeConnectionInput) (req *request.Request, output *DescribeConnectionOutput) {
	op := &request.Operation{
		Name:       opDescribeConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionInput{}
	}

	output = &DescribeConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnection API operation for Amazon EventBridge.
//
// Retrieves details about a connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeConnection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeConnection
func (c *EventBridge) DescribeConnection(input *DescribeConnectionInput) (*DescribeConnectionOutput, error) {
	req, out := c.DescribeConnectionRequest(input)
	return out, req.Send()
}

// DescribeConnectionWithContext is the same as DescribeConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeConnectionWithContext(ctx aws.Context, input *DescribeConnectionInput, opts ...request.Option) (*DescribeConnectionOutput, error) {
	req, out := c.DescribeConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointRequest method.
//	req, resp := client.DescribeEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEndpoint
func (c *EventBridge) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon EventBridge.
//
// Get the information about an existing global endpoint. For more information
// about global endpoints, see Making applications Regional-fault tolerant with
// global endpoints and event replication (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html)
// in the Amazon EventBridge User Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEndpoint
func (c *EventBridge) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventBus = "DescribeEventBus"

// DescribeEventBusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventBus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventBus for more information on using the DescribeEventBus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventBusRequest method.
//	req, resp := client.DescribeEventBusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventBus
func (c *EventBridge) DescribeEventBusRequest(input *DescribeEventBusInput) (req *request.Request, output *DescribeEventBusOutput) {
	op := &request.Operation{
		Name:       opDescribeEventBus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventBusInput{}
	}

	output = &DescribeEventBusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventBus API operation for Amazon EventBridge.
//
// Displays details about an event bus in your account. This can include the
// external Amazon Web Services accounts that are permitted to write events
// to your default event bus, and the associated policy. For custom event buses
// and partner event buses, it displays the name, ARN, policy, state, and creation
// time.
//
// To enable your account to receive events from other accounts on its default
// event bus, use PutPermission (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
//
// For more information about partner event buses, see CreateEventBus (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeEventBus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventBus
func (c *EventBridge) DescribeEventBus(input *DescribeEventBusInput) (*DescribeEventBusOutput, error) {
	req, out := c.DescribeEventBusRequest(input)
	return out, req.Send()
}

// DescribeEventBusWithContext is the same as DescribeEventBus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventBus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeEventBusWithContext(ctx aws.Context, input *DescribeEventBusInput, opts ...request.Option) (*DescribeEventBusOutput, error) {
	req, out := c.DescribeEventBusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSource = "DescribeEventSource"

// DescribeEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSource for more information on using the DescribeEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventSourceRequest method.
//	req, resp := client.DescribeEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventSource
func (c *EventBridge) DescribeEventSourceRequest(input *DescribeEventSourceInput) (req *request.Request, output *DescribeEventSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventSourceInput{}
	}

	output = &DescribeEventSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSource API operation for Amazon EventBridge.
//
// This operation lists details about a partner event source that is shared
// with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeEventSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeEventSource
func (c *EventBridge) DescribeEventSource(input *DescribeEventSourceInput) (*DescribeEventSourceOutput, error) {
	req, out := c.DescribeEventSourceRequest(input)
	return out, req.Send()
}

// DescribeEventSourceWithContext is the same as DescribeEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeEventSourceWithContext(ctx aws.Context, input *DescribeEventSourceInput, opts ...request.Option) (*DescribeEventSourceOutput, error) {
	req, out := c.DescribeEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePartnerEventSource = "DescribePartnerEventSource"

// DescribePartnerEventSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribePartnerEventSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePartnerEventSource for more information on using the DescribePartnerEventSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePartnerEventSourceRequest method.
//	req, resp := client.DescribePartnerEventSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribePartnerEventSource
func (c *EventBridge) DescribePartnerEventSourceRequest(input *DescribePartnerEventSourceInput) (req *request.Request, output *DescribePartnerEventSourceOutput) {
	op := &request.Operation{
		Name:       opDescribePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePartnerEventSourceInput{}
	}

	output = &DescribePartnerEventSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePartnerEventSource API operation for Amazon EventBridge.
//
// An SaaS partner can use this operation to list details about a partner event
// source that they have created. Amazon Web Services customers do not use this
// operation. Instead, Amazon Web Services customers can use DescribeEventSource
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html)
// to see details about a partner event source that is shared with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribePartnerEventSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribePartnerEventSource
func (c *EventBridge) DescribePartnerEventSource(input *DescribePartnerEventSourceInput) (*DescribePartnerEventSourceOutput, error) {
	req, out := c.DescribePartnerEventSourceRequest(input)
	return out, req.Send()
}

// DescribePartnerEventSourceWithContext is the same as DescribePartnerEventSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePartnerEventSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribePartnerEventSourceWithContext(ctx aws.Context, input *DescribePartnerEventSourceInput, opts ...request.Option) (*DescribePartnerEventSourceOutput, error) {
	req, out := c.DescribePartnerEventSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReplay = "DescribeReplay"

// DescribeReplayRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplay for more information on using the DescribeReplay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplayRequest method.
//	req, resp := client.DescribeReplayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeReplay
func (c *EventBridge) DescribeReplayRequest(input *DescribeReplayInput) (req *request.Request, output *DescribeReplayOutput) {
	op := &request.Operation{
		Name:       opDescribeReplay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReplayInput{}
	}

	output = &DescribeReplayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplay API operation for Amazon EventBridge.
//
// Retrieves details about a replay. Use DescribeReplay to determine the progress
// of a running replay. A replay processes events to replay based on the time
// in the event, and replays them using 1 minute intervals. If you use StartReplay
// and specify an EventStartTime and an EventEndTime that covers a 20 minute
// time range, the events are replayed from the first minute of that 20 minute
// range first. Then the events from the second minute are replayed. You can
// use DescribeReplay to determine the progress of a replay. The value returned
// for EventLastReplayedTime indicates the time within the specified time range
// associated with the last event replayed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeReplay for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeReplay
func (c *EventBridge) DescribeReplay(input *DescribeReplayInput) (*DescribeReplayOutput, error) {
	req, out := c.DescribeReplayRequest(input)
	return out, req.Send()
}

// DescribeReplayWithContext is the same as DescribeReplay with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeReplayWithContext(ctx aws.Context, input *DescribeReplayInput, opts ...request.Option) (*DescribeReplayOutput, error) {
	req, out := c.DescribeReplayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRule = "DescribeRule"

// DescribeRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRule for more information on using the DescribeRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRuleRequest method.
//	req, resp := client.DescribeRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeRule
func (c *EventBridge) DescribeRuleRequest(input *DescribeRuleInput) (req *request.Request, output *DescribeRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleInput{}
	}

	output = &DescribeRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRule API operation for Amazon EventBridge.
//
// Describes the specified rule.
//
// DescribeRule does not list the targets of a rule. To see the targets associated
// with a rule, use ListTargetsByRule (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DescribeRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DescribeRule
func (c *EventBridge) DescribeRule(input *DescribeRuleInput) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	return out, req.Send()
}

// DescribeRuleWithContext is the same as DescribeRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DescribeRuleWithContext(ctx aws.Context, input *DescribeRuleInput, opts ...request.Option) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableRule = "DisableRule"

// DisableRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableRule for more information on using the DisableRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableRuleRequest method.
//	req, resp := client.DisableRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DisableRule
func (c *EventBridge) DisableRuleRequest(input *DisableRuleInput) (req *request.Request, output *DisableRuleOutput) {
	op := &request.Operation{
		Name:       opDisableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRuleInput{}
	}

	output = &DisableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableRule API operation for Amazon EventBridge.
//
// Disables the specified rule. A disabled rule won't match any events, and
// won't self-trigger if it has a schedule expression.
//
// When you disable a rule, incoming events might continue to match to the disabled
// rule. Allow a short period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation DisableRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DisableRule
func (c *EventBridge) DisableRule(input *DisableRuleInput) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	return out, req.Send()
}

// DisableRuleWithContext is the same as DisableRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) DisableRuleWithContext(ctx aws.Context, input *DisableRuleInput, opts ...request.Option) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableRule = "EnableRule"

// EnableRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableRule for more information on using the EnableRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableRuleRequest method.
//	req, resp := client.EnableRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/EnableRule
func (c *EventBridge) EnableRuleRequest(input *EnableRuleInput) (req *request.Request, output *EnableRuleOutput) {
	op := &request.Operation{
		Name:       opEnableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRuleInput{}
	}

	output = &EnableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableRule API operation for Amazon EventBridge.
//
// Enables the specified rule. If the rule does not exist, the operation fails.
//
// When you enable a rule, incoming events might not immediately start matching
// to a newly enabled rule. Allow a short period of time for changes to take
// effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation EnableRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/EnableRule
func (c *EventBridge) EnableRule(input *EnableRuleInput) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	return out, req.Send()
}

// EnableRuleWithContext is the same as EnableRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) EnableRuleWithContext(ctx aws.Context, input *EnableRuleInput, opts ...request.Option) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApiDestinations = "ListApiDestinations"

// ListApiDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApiDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApiDestinations for more information on using the ListApiDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApiDestinationsRequest method.
//	req, resp := client.ListApiDestinationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListApiDestinations
func (c *EventBridge) ListApiDestinationsRequest(input *ListApiDestinationsInput) (req *request.Request, output *ListApiDestinationsOutput) {
	op := &request.Operation{
		Name:       opListApiDestinations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApiDestinationsInput{}
	}

	output = &ListApiDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApiDestinations API operation for Amazon EventBridge.
//
// Retrieves a list of API destination in the account in the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListApiDestinations for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListApiDestinations
func (c *EventBridge) ListApiDestinations(input *ListApiDestinationsInput) (*ListApiDestinationsOutput, error) {
	req, out := c.ListApiDestinationsRequest(input)
	return out, req.Send()
}

// ListApiDestinationsWithContext is the same as ListApiDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListApiDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListApiDestinationsWithContext(ctx aws.Context, input *ListApiDestinationsInput, opts ...request.Option) (*ListApiDestinationsOutput, error) {
	req, out := c.ListApiDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListArchives = "ListArchives"

// ListArchivesRequest generates a "aws/request.Request" representing the
// client's request for the ListArchives operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArchives for more information on using the ListArchives
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListArchivesRequest method.
//	req, resp := client.ListArchivesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListArchives
func (c *EventBridge) ListArchivesRequest(input *ListArchivesInput) (req *request.Request, output *ListArchivesOutput) {
	op := &request.Operation{
		Name:       opListArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListArchivesInput{}
	}

	output = &ListArchivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArchives API operation for Amazon EventBridge.
//
// Lists your archives. You can either list all the archives or you can provide
// a prefix to match to the archive names. Filter parameters are exclusive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListArchives for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListArchives
func (c *EventBridge) ListArchives(input *ListArchivesInput) (*ListArchivesOutput, error) {
	req, out := c.ListArchivesRequest(input)
	return out, req.Send()
}

// ListArchivesWithContext is the same as ListArchives with the addition of
// the ability to pass a context and additional request options.
//
// See ListArchives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListArchivesWithContext(ctx aws.Context, input *ListArchivesInput, opts ...request.Option) (*ListArchivesOutput, error) {
	req, out := c.ListArchivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnections = "ListConnections"

// ListConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnections for more information on using the ListConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConnectionsRequest method.
//	req, resp := client.ListConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListConnections
func (c *EventBridge) ListConnectionsRequest(input *ListConnectionsInput) (req *request.Request, output *ListConnectionsOutput) {
	op := &request.Operation{
		Name:       opListConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConnectionsInput{}
	}

	output = &ListConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnections API operation for Amazon EventBridge.
//
// Retrieves a list of connections from the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListConnections for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListConnections
func (c *EventBridge) ListConnections(input *ListConnectionsInput) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	return out, req.Send()
}

// ListConnectionsWithContext is the same as ListConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListConnectionsWithContext(ctx aws.Context, input *ListConnectionsInput, opts ...request.Option) (*ListConnectionsOutput, error) {
	req, out := c.ListConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEndpointsRequest method.
//	req, resp := client.ListEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEndpoints
func (c *EventBridge) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon EventBridge.
//
// List the global endpoints associated with this account. For more information
// about global endpoints, see Making applications Regional-fault tolerant with
// global endpoints and event replication (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html)
// in the Amazon EventBridge User Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListEndpoints for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEndpoints
func (c *EventBridge) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventBuses = "ListEventBuses"

// ListEventBusesRequest generates a "aws/request.Request" representing the
// client's request for the ListEventBuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventBuses for more information on using the ListEventBuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventBusesRequest method.
//	req, resp := client.ListEventBusesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventBuses
func (c *EventBridge) ListEventBusesRequest(input *ListEventBusesInput) (req *request.Request, output *ListEventBusesOutput) {
	op := &request.Operation{
		Name:       opListEventBuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEventBusesInput{}
	}

	output = &ListEventBusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventBuses API operation for Amazon EventBridge.
//
// Lists all the event buses in your account, including the default event bus,
// custom event buses, and partner event buses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListEventBuses for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventBuses
func (c *EventBridge) ListEventBuses(input *ListEventBusesInput) (*ListEventBusesOutput, error) {
	req, out := c.ListEventBusesRequest(input)
	return out, req.Send()
}

// ListEventBusesWithContext is the same as ListEventBuses with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventBuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListEventBusesWithContext(ctx aws.Context, input *ListEventBusesInput, opts ...request.Option) (*ListEventBusesOutput, error) {
	req, out := c.ListEventBusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventSources = "ListEventSources"

// ListEventSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListEventSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventSources for more information on using the ListEventSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventSourcesRequest method.
//	req, resp := client.ListEventSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventSources
func (c *EventBridge) ListEventSourcesRequest(input *ListEventSourcesInput) (req *request.Request, output *ListEventSourcesOutput) {
	op := &request.Operation{
		Name:       opListEventSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEventSourcesInput{}
	}

	output = &ListEventSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventSources API operation for Amazon EventBridge.
//
// You can use this to see all the partner event sources that have been shared
// with your Amazon Web Services account. For more information about partner
// event sources, see CreateEventBus (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListEventSources for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListEventSources
func (c *EventBridge) ListEventSources(input *ListEventSourcesInput) (*ListEventSourcesOutput, error) {
	req, out := c.ListEventSourcesRequest(input)
	return out, req.Send()
}

// ListEventSourcesWithContext is the same as ListEventSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListEventSourcesWithContext(ctx aws.Context, input *ListEventSourcesInput, opts ...request.Option) (*ListEventSourcesOutput, error) {
	req, out := c.ListEventSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPartnerEventSourceAccounts = "ListPartnerEventSourceAccounts"

// ListPartnerEventSourceAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListPartnerEventSourceAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPartnerEventSourceAccounts for more information on using the ListPartnerEventSourceAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPartnerEventSourceAccountsRequest method.
//	req, resp := client.ListPartnerEventSourceAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSourceAccounts
func (c *EventBridge) ListPartnerEventSourceAccountsRequest(input *ListPartnerEventSourceAccountsInput) (req *request.Request, output *ListPartnerEventSourceAccountsOutput) {
	op := &request.Operation{
		Name:       opListPartnerEventSourceAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPartnerEventSourceAccountsInput{}
	}

	output = &ListPartnerEventSourceAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPartnerEventSourceAccounts API operation for Amazon EventBridge.
//
// An SaaS partner can use this operation to display the Amazon Web Services
// account ID that a particular partner event source name is associated with.
// This operation is not used by Amazon Web Services customers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListPartnerEventSourceAccounts for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSourceAccounts
func (c *EventBridge) ListPartnerEventSourceAccounts(input *ListPartnerEventSourceAccountsInput) (*ListPartnerEventSourceAccountsOutput, error) {
	req, out := c.ListPartnerEventSourceAccountsRequest(input)
	return out, req.Send()
}

// ListPartnerEventSourceAccountsWithContext is the same as ListPartnerEventSourceAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPartnerEventSourceAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListPartnerEventSourceAccountsWithContext(ctx aws.Context, input *ListPartnerEventSourceAccountsInput, opts ...request.Option) (*ListPartnerEventSourceAccountsOutput, error) {
	req, out := c.ListPartnerEventSourceAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPartnerEventSources = "ListPartnerEventSources"

// ListPartnerEventSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListPartnerEventSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPartnerEventSources for more information on using the ListPartnerEventSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPartnerEventSourcesRequest method.
//	req, resp := client.ListPartnerEventSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSources
func (c *EventBridge) ListPartnerEventSourcesRequest(input *ListPartnerEventSourcesInput) (req *request.Request, output *ListPartnerEventSourcesOutput) {
	op := &request.Operation{
		Name:       opListPartnerEventSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPartnerEventSourcesInput{}
	}

	output = &ListPartnerEventSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPartnerEventSources API operation for Amazon EventBridge.
//
// An SaaS partner can use this operation to list all the partner event source
// names that they have created. This operation is not used by Amazon Web Services
// customers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListPartnerEventSources for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListPartnerEventSources
func (c *EventBridge) ListPartnerEventSources(input *ListPartnerEventSourcesInput) (*ListPartnerEventSourcesOutput, error) {
	req, out := c.ListPartnerEventSourcesRequest(input)
	return out, req.Send()
}

// ListPartnerEventSourcesWithContext is the same as ListPartnerEventSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListPartnerEventSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListPartnerEventSourcesWithContext(ctx aws.Context, input *ListPartnerEventSourcesInput, opts ...request.Option) (*ListPartnerEventSourcesOutput, error) {
	req, out := c.ListPartnerEventSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReplays = "ListReplays"

// ListReplaysRequest generates a "aws/request.Request" representing the
// client's request for the ListReplays operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReplays for more information on using the ListReplays
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReplaysRequest method.
//	req, resp := client.ListReplaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListReplays
func (c *EventBridge) ListReplaysRequest(input *ListReplaysInput) (req *request.Request, output *ListReplaysOutput) {
	op := &request.Operation{
		Name:       opListReplays,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReplaysInput{}
	}

	output = &ListReplaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReplays API operation for Amazon EventBridge.
//
// Lists your replays. You can either list all the replays or you can provide
// a prefix to match to the replay names. Filter parameters are exclusive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListReplays for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListReplays
func (c *EventBridge) ListReplays(input *ListReplaysInput) (*ListReplaysOutput, error) {
	req, out := c.ListReplaysRequest(input)
	return out, req.Send()
}

// ListReplaysWithContext is the same as ListReplays with the addition of
// the ability to pass a context and additional request options.
//
// See ListReplays for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListReplaysWithContext(ctx aws.Context, input *ListReplaysInput, opts ...request.Option) (*ListReplaysOutput, error) {
	req, out := c.ListReplaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleNamesByTarget = "ListRuleNamesByTarget"

// ListRuleNamesByTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleNamesByTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleNamesByTarget for more information on using the ListRuleNamesByTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRuleNamesByTargetRequest method.
//	req, resp := client.ListRuleNamesByTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRuleNamesByTarget
func (c *EventBridge) ListRuleNamesByTargetRequest(input *ListRuleNamesByTargetInput) (req *request.Request, output *ListRuleNamesByTargetOutput) {
	op := &request.Operation{
		Name:       opListRuleNamesByTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleNamesByTargetInput{}
	}

	output = &ListRuleNamesByTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleNamesByTarget API operation for Amazon EventBridge.
//
// Lists the rules for the specified target. You can see which of the rules
// in Amazon EventBridge can invoke a specific target in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListRuleNamesByTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRuleNamesByTarget
func (c *EventBridge) ListRuleNamesByTarget(input *ListRuleNamesByTargetInput) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	return out, req.Send()
}

// ListRuleNamesByTargetWithContext is the same as ListRuleNamesByTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleNamesByTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListRuleNamesByTargetWithContext(ctx aws.Context, input *ListRuleNamesByTargetInput, opts ...request.Option) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRulesRequest method.
//	req, resp := client.ListRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRules
func (c *EventBridge) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon EventBridge.
//
// Lists your Amazon EventBridge rules. You can either list all the rules or
// you can provide a prefix to match to the rule names.
//
// ListRules does not list the targets of a rule. To see the targets associated
// with a rule, use ListTargetsByRule (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRules
func (c *EventBridge) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTagsForResource
func (c *EventBridge) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon EventBridge.
//
// Displays the tags associated with an EventBridge resource. In EventBridge,
// rules and event buses can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTagsForResource
func (c *EventBridge) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsByRule = "ListTargetsByRule"

// ListTargetsByRuleRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsByRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsByRule for more information on using the ListTargetsByRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetsByRuleRequest method.
//	req, resp := client.ListTargetsByRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTargetsByRule
func (c *EventBridge) ListTargetsByRuleRequest(input *ListTargetsByRuleInput) (req *request.Request, output *ListTargetsByRuleOutput) {
	op := &request.Operation{
		Name:       opListTargetsByRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsByRuleInput{}
	}

	output = &ListTargetsByRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsByRule API operation for Amazon EventBridge.
//
// Lists the targets assigned to the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation ListTargetsByRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListTargetsByRule
func (c *EventBridge) ListTargetsByRule(input *ListTargetsByRuleInput) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	return out, req.Send()
}

// ListTargetsByRuleWithContext is the same as ListTargetsByRule with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsByRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) ListTargetsByRuleWithContext(ctx aws.Context, input *ListTargetsByRuleInput, opts ...request.Option) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvents for more information on using the PutEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEventsRequest method.
//	req, resp := client.PutEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutEvents
func (c *EventBridge) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon EventBridge.
//
// Sends custom events to Amazon EventBridge so that they can be matched to
// rules.
//
// PutEvents will only process nested JSON up to 1100 levels deep.
//
// This AWS SDK does not support calling multi-region endpoints with SigV4a authentication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation PutEvents for usage and error information.
//
// Returned Error Types:
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutEvents
func (c *EventBridge) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	return out, req.Send()
}

// PutEventsWithContext is the same as PutEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) PutEventsWithContext(ctx aws.Context, input *PutEventsInput, opts ...request.Option) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPartnerEvents = "PutPartnerEvents"

// PutPartnerEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutPartnerEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPartnerEvents for more information on using the PutPartnerEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPartnerEventsRequest method.
//	req, resp := client.PutPartnerEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPartnerEvents
func (c *EventBridge) PutPartnerEventsRequest(input *PutPartnerEventsInput) (req *request.Request, output *PutPartnerEventsOutput) {
	op := &request.Operation{
		Name:       opPutPartnerEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPartnerEventsInput{}
	}

	output = &PutPartnerEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPartnerEvents API operation for Amazon EventBridge.
//
// This is used by SaaS partners to write events to a customer's partner event
// bus. Amazon Web Services customers do not use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation PutPartnerEvents for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPartnerEvents
func (c *EventBridge) PutPartnerEvents(input *PutPartnerEventsInput) (*PutPartnerEventsOutput, error) {
	req, out := c.PutPartnerEventsRequest(input)
	return out, req.Send()
}

// PutPartnerEventsWithContext is the same as PutPartnerEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutPartnerEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) PutPartnerEventsWithContext(ctx aws.Context, input *PutPartnerEventsInput, opts ...request.Option) (*PutPartnerEventsOutput, error) {
	req, out := c.PutPartnerEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermission = "PutPermission"

// PutPermissionRequest generates a "aws/request.Request" representing the
// client's request for the PutPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermission for more information on using the PutPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPermissionRequest method.
//	req, resp := client.PutPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPermission
func (c *EventBridge) PutPermissionRequest(input *PutPermissionInput) (req *request.Request, output *PutPermissionOutput) {
	op := &request.Operation{
		Name:       opPutPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPermissionInput{}
	}

	output = &PutPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermission API operation for Amazon EventBridge.
//
// Running PutPermission permits the specified Amazon Web Services account or
// Amazon Web Services organization to put events to the specified event bus.
// Amazon EventBridge (CloudWatch Events) rules in your account are triggered
// by these events arriving to an event bus in your account.
//
// For another account to send events to your account, that external account
// must have an EventBridge rule with your account's event bus as a target.
//
// To enable multiple Amazon Web Services accounts to put events to your event
// bus, run PutPermission once for each of these accounts. Or, if all the accounts
// are members of the same Amazon Web Services organization, you can run PutPermission
// once specifying Principal as "*" and specifying the Amazon Web Services organization
// ID in Condition, to grant permissions to all accounts in that organization.
//
// If you grant permissions using an organization, then accounts in that organization
// must specify a RoleArn with proper permissions when they use PutTarget to
// add your account's event bus as a target. For more information, see Sending
// and Receiving Events Between Amazon Web Services Accounts (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html)
// in the Amazon EventBridge User Guide.
//
// The permission policy on the event bus cannot exceed 10 KB in size.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation PutPermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - PolicyLengthExceededException
//     The event bus policy is too long. For more information, see the limits.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPermission
func (c *EventBridge) PutPermission(input *PutPermissionInput) (*PutPermissionOutput, error) {
	req, out := c.PutPermissionRequest(input)
	return out, req.Send()
}

// PutPermissionWithContext is the same as PutPermission with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) PutPermissionWithContext(ctx aws.Context, input *PutPermissionInput, opts ...request.Option) (*PutPermissionOutput, error) {
	req, out := c.PutPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRule = "PutRule"

// PutRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRule for more information on using the PutRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRuleRequest method.
//	req, resp := client.PutRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutRule
func (c *EventBridge) PutRuleRequest(input *PutRuleInput) (req *request.Request, output *PutRuleOutput) {
	op := &request.Operation{
		Name:       opPutRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRuleInput{}
	}

	output = &PutRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRule API operation for Amazon EventBridge.
//
// Creates or updates the specified rule. Rules are enabled by default, or based
// on value of the state. You can disable a rule using DisableRule (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html).
//
// A single rule watches for events from a single event bus. Events generated
// by Amazon Web Services services go to your account's default event bus. Events
// generated by SaaS partner services or applications go to the matching partner
// event bus. If you have custom applications or services, you can specify whether
// their events go to your default event bus or a custom event bus that you
// have created. For more information, see CreateEventBus (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html).
//
// If you are updating an existing rule, the rule is replaced with what you
// specify in this PutRule command. If you omit arguments in PutRule, the old
// values for those arguments are not kept. Instead, they are replaced with
// null values.
//
// When you create or update a rule, incoming events might not immediately start
// matching to new or updated rules. Allow a short period of time for changes
// to take effect.
//
// A rule must contain at least an EventPattern or ScheduleExpression. Rules
// with EventPatterns are triggered when a matching event is observed. Rules
// with ScheduleExpressions self-trigger based on the given schedule. A rule
// can have both an EventPattern and a ScheduleExpression, in which case the
// rule triggers on matching events as well as on a schedule.
//
// When you initially create a rule, you can optionally assign one or more tags
// to the rule. Tags can help you organize and categorize your resources. You
// can also use them to scope user permissions, by granting a user permission
// to access or change only rules with certain tag values. To use the PutRule
// operation and assign tags, you must have both the events:PutRule and events:TagResource
// permissions.
//
// If you are updating an existing rule, any tags you specify in the PutRule
// operation are ignored. To update the tags of an existing rule, use TagResource
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html)
// and UntagResource (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html).
//
// Most services in Amazon Web Services treat : or / as the same character in
// Amazon Resource Names (ARNs). However, EventBridge uses an exact match in
// event patterns and rules. Be sure to use the correct ARN characters when
// creating event patterns so that they match the ARN syntax in the event you
// want to match.
//
// In EventBridge, it is possible to create rules that lead to infinite loops,
// where a rule is fired repeatedly. For example, a rule might detect that ACLs
// have changed on an S3 bucket, and trigger software to change them to the
// desired state. If the rule is not written carefully, the subsequent change
// to the ACLs fires the rule again, creating an infinite loop.
//
// To prevent this, write the rules so that the triggered actions do not re-fire
// the same rule. For example, your rule could fire only if ACLs are found to
// be in a bad state, instead of after any change.
//
// An infinite loop can quickly cause higher than expected charges. We recommend
// that you use budgeting, which alerts you when charges exceed your specified
// limit. For more information, see Managing Your Costs with Budgets (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation PutRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidEventPatternException
//     The event pattern is not valid.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutRule
func (c *EventBridge) PutRule(input *PutRuleInput) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	return out, req.Send()
}

// PutRuleWithContext is the same as PutRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) PutRuleWithContext(ctx aws.Context, input *PutRuleInput, opts ...request.Option) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTargets = "PutTargets"

// PutTargetsRequest generates a "aws/request.Request" representing the
// client's request for the PutTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTargets for more information on using the PutTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutTargetsRequest method.
//	req, resp := client.PutTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutTargets
func (c *EventBridge) PutTargetsRequest(input *PutTargetsInput) (req *request.Request, output *PutTargetsOutput) {
	op := &request.Operation{
		Name:       opPutTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutTargetsInput{}
	}

	output = &PutTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTargets API operation for Amazon EventBridge.
//
// Adds the specified targets to the specified rule, or updates the targets
// if they are already associated with the rule.
//
// Targets are the resources that are invoked when a rule is triggered.
//
// Each rule can have up to five (5) targets associated with it at one time.
//
// You can configure the following as targets for Events:
//
//   - API destination (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html)
//
//   - API Gateway (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-gateway-target.html)
//
//   - Batch job queue
//
//   - CloudWatch group
//
//   - CodeBuild project
//
//   - CodePipeline
//
//   - EC2 CreateSnapshot API call
//
//   - EC2 Image Builder
//
//   - EC2 RebootInstances API call
//
//   - EC2 StopInstances API call
//
//   - EC2 TerminateInstances API call
//
//   - ECS task
//
//   - Event bus in a different account or Region (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cross-account.html)
//
//   - Event bus in the same account and Region (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-bus-to-bus.html)
//
//   - Firehose delivery stream
//
//   - Glue workflow
//
//   - Incident Manager response plan (https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-creation.html#incident-tracking-auto-eventbridge)
//
//   - Inspector assessment template
//
//   - Kinesis stream
//
//   - Lambda function
//
//   - Redshift cluster
//
//   - Redshift Serverless workgroup
//
//   - SageMaker Pipeline
//
//   - SNS topic
//
//   - SQS queue
//
//   - Step Functions state machine
//
//   - Systems Manager Automation
//
//   - Systems Manager OpsItem
//
//   - Systems Manager Run Command
//
// Creating rules with built-in targets is supported only in the Amazon Web
// Services Management Console. The built-in targets are EC2 CreateSnapshot
// API call, EC2 RebootInstances API call, EC2 StopInstances API call, and EC2
// TerminateInstances API call.
//
// For some target types, PutTargets provides target-specific parameters. If
// the target is a Kinesis data stream, you can optionally specify which shard
// the event goes to by using the KinesisParameters argument. To invoke a command
// on multiple EC2 instances with one rule, you can use the RunCommandParameters
// field.
//
// To be able to make API calls against the resources that you own, Amazon EventBridge
// needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge
// relies on resource-based policies. For EC2 instances, Kinesis Data Streams,
// Step Functions state machines and API Gateway APIs, EventBridge relies on
// IAM roles that you specify in the RoleARN argument in PutTargets. For more
// information, see Authentication and Access Control (https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html)
// in the Amazon EventBridge User Guide.
//
// If another Amazon Web Services account is in the same region and has granted
// you permission (using PutPermission), you can send events to that account.
// Set that account's event bus as a target of the rules in your account. To
// send the matched events to the other account, specify that account's event
// bus as the Arn value when you run PutTargets. If your account sends events
// to another account, your account is charged for each sent event. Each event
// sent to another account is charged as a custom event. The account receiving
// the event is not charged. For more information, see Amazon EventBridge Pricing
// (http://aws.amazon.com/eventbridge/pricing/).
//
// Input, InputPath, and InputTransformer are not available with PutTarget if
// the target is an event bus of a different Amazon Web Services account.
//
// If you are setting the event bus of another account as the target, and that
// account granted permission to your account through an organization instead
// of directly by the account ID, then you must specify a RoleArn with proper
// permissions in the Target structure. For more information, see Sending and
// Receiving Events Between Amazon Web Services Accounts (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html)
// in the Amazon EventBridge User Guide.
//
// For more information about enabling cross-account events, see PutPermission
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html).
//
// Input, InputPath, and InputTransformer are mutually exclusive and optional
// parameters of a target. When a rule is triggered due to a matched event:
//
//   - If none of the following arguments are specified for a target, then
//     the entire event is passed to the target in JSON format (unless the target
//     is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from
//     the event is passed to the target).
//
//   - If Input is specified in the form of valid JSON, then the matched event
//     is overridden with this constant.
//
//   - If InputPath is specified in the form of JSONPath (for example, $.detail),
//     then only the part of the event specified in the path is passed to the
//     target (for example, only the detail part of the event is passed).
//
//   - If InputTransformer is specified, then one or more specified JSONPaths
//     are extracted from the event and used as values in a template that you
//     specify as the input to the target.
//
// When you specify InputPath or InputTransformer, you must use JSON dot notation,
// not bracket notation.
//
// When you add targets to a rule and the associated rule triggers soon after,
// new or updated targets might not be immediately invoked. Allow a short period
// of time for changes to take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation PutTargets for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutTargets
func (c *EventBridge) PutTargets(input *PutTargetsInput) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	return out, req.Send()
}

// PutTargetsWithContext is the same as PutTargets with the addition of
// the ability to pass a context and additional request options.
//
// See PutTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) PutTargetsWithContext(ctx aws.Context, input *PutTargetsInput, opts ...request.Option) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemovePermission for more information on using the RemovePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemovePermissionRequest method.
//	req, resp := client.RemovePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemovePermission
func (c *EventBridge) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for Amazon EventBridge.
//
// Revokes the permission of another Amazon Web Services account to be able
// to put events to the specified event bus. Specify the account to revoke by
// the StatementId value that you associated with the account when you granted
// it permission with PutPermission. You can find the StatementId by using DescribeEventBus
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation RemovePermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - OperationDisabledException
//     The operation you are attempting is not available in this region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemovePermission
func (c *EventBridge) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	return out, req.Send()
}

// RemovePermissionWithContext is the same as RemovePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemovePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) RemovePermissionWithContext(ctx aws.Context, input *RemovePermissionInput, opts ...request.Option) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTargets = "RemoveTargets"

// RemoveTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTargets for more information on using the RemoveTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTargetsRequest method.
//	req, resp := client.RemoveTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemoveTargets
func (c *EventBridge) RemoveTargetsRequest(input *RemoveTargetsInput) (req *request.Request, output *RemoveTargetsOutput) {
	op := &request.Operation{
		Name:       opRemoveTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTargetsInput{}
	}

	output = &RemoveTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTargets API operation for Amazon EventBridge.
//
// Removes the specified targets from the specified rule. When the rule is triggered,
// those targets are no longer be invoked.
//
// A successful execution of RemoveTargets doesn't guarantee all targets are
// removed from the rule, it means that the target(s) listed in the request
// are removed.
//
// When you remove a target, when the associated rule triggers, removed targets
// might continue to be invoked. Allow a short period of time for changes to
// take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation RemoveTargets for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/RemoveTargets
func (c *EventBridge) RemoveTargets(input *RemoveTargetsInput) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	return out, req.Send()
}

// RemoveTargetsWithContext is the same as RemoveTargets with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) RemoveTargetsWithContext(ctx aws.Context, input *RemoveTargetsInput, opts ...request.Option) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplay = "StartReplay"

// StartReplayRequest generates a "aws/request.Request" representing the
// client's request for the StartReplay operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplay for more information on using the StartReplay
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReplayRequest method.
//	req, resp := client.StartReplayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/StartReplay
func (c *EventBridge) StartReplayRequest(input *StartReplayInput) (req *request.Request, output *StartReplayOutput) {
	op := &request.Operation{
		Name:       opStartReplay,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplayInput{}
	}

	output = &StartReplayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplay API operation for Amazon EventBridge.
//
// Starts the specified replay. Events are not necessarily replayed in the exact
// same order that they were added to the archive. A replay processes events
// to replay based on the time in the event, and replays them using 1 minute
// intervals. If you specify an EventStartTime and an EventEndTime that covers
// a 20 minute time range, the events are replayed from the first minute of
// that 20 minute range first. Then the events from the second minute are replayed.
// You can use DescribeReplay to determine the progress of a replay. The value
// returned for EventLastReplayedTime indicates the time within the specified
// time range associated with the last event replayed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation StartReplay for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ResourceAlreadyExistsException
//     The resource you are trying to create already exists.
//
//   - InvalidEventPatternException
//     The event pattern is not valid.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/StartReplay
func (c *EventBridge) StartReplay(input *StartReplayInput) (*StartReplayOutput, error) {
	req, out := c.StartReplayRequest(input)
	return out, req.Send()
}

// StartReplayWithContext is the same as StartReplay with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplay for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) StartReplayWithContext(ctx aws.Context, input *StartReplayInput, opts ...request.Option) (*StartReplayOutput, error) {
	req, out := c.StartReplayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TagResource
func (c *EventBridge) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon EventBridge.
//
// Assigns one or more tags (key-value pairs) to the specified EventBridge resource.
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values. In EventBridge, rules and
// event buses can be tagged.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TagResource
func (c *EventBridge) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestEventPattern = "TestEventPattern"

// TestEventPatternRequest generates a "aws/request.Request" representing the
// client's request for the TestEventPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestEventPattern for more information on using the TestEventPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestEventPatternRequest method.
//	req, resp := client.TestEventPatternRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TestEventPattern
func (c *EventBridge) TestEventPatternRequest(input *TestEventPatternInput) (req *request.Request, output *TestEventPatternOutput) {
	op := &request.Operation{
		Name:       opTestEventPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestEventPatternInput{}
	}

	output = &TestEventPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestEventPattern API operation for Amazon EventBridge.
//
// Tests whether the specified event pattern matches the provided event.
//
// Most services in Amazon Web Services treat : or / as the same character in
// Amazon Resource Names (ARNs). However, EventBridge uses an exact match in
// event patterns and rules. Be sure to use the correct ARN characters when
// creating event patterns so that they match the ARN syntax in the event you
// want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation TestEventPattern for usage and error information.
//
// Returned Error Types:
//
//   - InvalidEventPatternException
//     The event pattern is not valid.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/TestEventPattern
func (c *EventBridge) TestEventPattern(input *TestEventPatternInput) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	return out, req.Send()
}

// TestEventPatternWithContext is the same as TestEventPattern with the addition of
// the ability to pass a context and additional request options.
//
// See TestEventPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) TestEventPatternWithContext(ctx aws.Context, input *TestEventPatternInput, opts ...request.Option) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UntagResource
func (c *EventBridge) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon EventBridge.
//
// Removes one or more tags from the specified EventBridge resource. In Amazon
// EventBridge (CloudWatch Events), rules and event buses can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ManagedRuleException
//     This rule was created by an Amazon Web Services service on behalf of your
//     account. It is managed by that service. If you see this error in response
//     to DeleteRule or RemoveTargets, you can use the Force parameter in those
//     calls to delete the rule or remove targets from the rule. You cannot modify
//     these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
//     TagResource, or UntagResource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UntagResource
func (c *EventBridge) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApiDestination = "UpdateApiDestination"

// UpdateApiDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApiDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApiDestination for more information on using the UpdateApiDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApiDestinationRequest method.
//	req, resp := client.UpdateApiDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateApiDestination
func (c *EventBridge) UpdateApiDestinationRequest(input *UpdateApiDestinationInput) (req *request.Request, output *UpdateApiDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateApiDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApiDestinationInput{}
	}

	output = &UpdateApiDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApiDestination API operation for Amazon EventBridge.
//
// Updates an API destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation UpdateApiDestination for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateApiDestination
func (c *EventBridge) UpdateApiDestination(input *UpdateApiDestinationInput) (*UpdateApiDestinationOutput, error) {
	req, out := c.UpdateApiDestinationRequest(input)
	return out, req.Send()
}

// UpdateApiDestinationWithContext is the same as UpdateApiDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApiDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) UpdateApiDestinationWithContext(ctx aws.Context, input *UpdateApiDestinationInput, opts ...request.Option) (*UpdateApiDestinationOutput, error) {
	req, out := c.UpdateApiDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateArchive = "UpdateArchive"

// UpdateArchiveRequest generates a "aws/request.Request" representing the
// client's request for the UpdateArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateArchive for more information on using the UpdateArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateArchiveRequest method.
//	req, resp := client.UpdateArchiveRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateArchive
func (c *EventBridge) UpdateArchiveRequest(input *UpdateArchiveInput) (req *request.Request, output *UpdateArchiveOutput) {
	op := &request.Operation{
		Name:       opUpdateArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateArchiveInput{}
	}

	output = &UpdateArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateArchive API operation for Amazon EventBridge.
//
// Updates the specified archive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation UpdateArchive for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
//   - InvalidEventPatternException
//     The event pattern is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateArchive
func (c *EventBridge) UpdateArchive(input *UpdateArchiveInput) (*UpdateArchiveOutput, error) {
	req, out := c.UpdateArchiveRequest(input)
	return out, req.Send()
}

// UpdateArchiveWithContext is the same as UpdateArchive with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) UpdateArchiveWithContext(ctx aws.Context, input *UpdateArchiveInput, opts ...request.Option) (*UpdateArchiveOutput, error) {
	req, out := c.UpdateArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnection = "UpdateConnection"

// UpdateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnection for more information on using the UpdateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConnectionRequest method.
//	req, resp := client.UpdateConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateConnection
func (c *EventBridge) UpdateConnectionRequest(input *UpdateConnectionInput) (req *request.Request, output *UpdateConnectionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectionInput{}
	}

	output = &UpdateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnection API operation for Amazon EventBridge.
//
// Updates settings for a connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation UpdateConnection for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - LimitExceededException
//     The request failed because it attempted to create resource beyond the allowed
//     service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateConnection
func (c *EventBridge) UpdateConnection(input *UpdateConnectionInput) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	return out, req.Send()
}

// UpdateConnectionWithContext is the same as UpdateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) UpdateConnectionWithContext(ctx aws.Context, input *UpdateConnectionInput, opts ...request.Option) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEndpointRequest method.
//	req, resp := client.UpdateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEndpoint
func (c *EventBridge) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon EventBridge.
//
// Update an existing endpoint. For more information about global endpoints,
// see Making applications Regional-fault tolerant with global endpoints and
// event replication (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html)
// in the Amazon EventBridge User Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     An entity that you specified does not exist.
//
//   - ConcurrentModificationException
//     There is concurrent modification on a rule, target, archive, or replay.
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/UpdateEndpoint
func (c *EventBridge) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EventBridge) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ActivateEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to activate.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateEventSourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ActivateEventSourceInput) SetName(v string) *ActivateEventSourceInput {
	s.Name = &v
	return s
}

type ActivateEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEventSourceOutput) GoString() string {
	return s.String()
}

// Contains details about an API destination.
type ApiDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the API destination.
	ApiDestinationArn *string `min:"1" type:"string"`

	// The state of the API destination.
	ApiDestinationState *string `type:"string" enum:"ApiDestinationState"`

	// The ARN of the connection specified for the API destination.
	ConnectionArn *string `min:"1" type:"string"`

	// A time stamp for the time that the API destination was created.
	CreationTime *time.Time `type:"timestamp"`

	// The method to use to connect to the HTTP endpoint.
	HttpMethod *string `type:"string" enum:"ApiDestinationHttpMethod"`

	// The URL to the endpoint for the API destination.
	InvocationEndpoint *string `min:"1" type:"string"`

	// The maximum number of invocations per second to send to the HTTP endpoint.
	InvocationRateLimitPerSecond *int64 `min:"1" type:"integer"`

	// A time stamp for the time that the API destination was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the API destination.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiDestination) GoString() string {
	return s.String()
}

// SetApiDestinationArn sets the ApiDestinationArn field's value.
func (s *ApiDestination) SetApiDestinationArn(v string) *ApiDestination {
	s.ApiDestinationArn = &v
	return s
}

// SetApiDestinationState sets the ApiDestinationState field's value.
func (s *ApiDestination) SetApiDestinationState(v string) *ApiDestination {
	s.ApiDestinationState = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *ApiDestination) SetConnectionArn(v string) *ApiDestination {
	s.ConnectionArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ApiDestination) SetCreationTime(v time.Time) *ApiDestination {
	s.CreationTime = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *ApiDestination) SetHttpMethod(v string) *ApiDestination {
	s.HttpMethod = &v
	return s
}

// SetInvocationEndpoint sets the InvocationEndpoint field's value.
func (s *ApiDestination) SetInvocationEndpoint(v string) *ApiDestination {
	s.InvocationEndpoint = &v
	return s
}

// SetInvocationRateLimitPerSecond sets the InvocationRateLimitPerSecond field's value.
func (s *ApiDestination) SetInvocationRateLimitPerSecond(v int64) *ApiDestination {
	s.InvocationRateLimitPerSecond = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ApiDestination) SetLastModifiedTime(v time.Time) *ApiDestination {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApiDestination) SetName(v string) *ApiDestination {
	s.Name = &v
	return s
}

// An Archive object that contains details about an archive.
type Archive struct {
	_ struct{} `type:"structure"`

	// The name of the archive.
	ArchiveName *string `min:"1" type:"string"`

	// The time stamp for the time that the archive was created.
	CreationTime *time.Time `type:"timestamp"`

	// The number of events in the archive.
	EventCount *int64 `type:"long"`

	// The ARN of the event bus associated with the archive. Only events from this
	// event bus are sent to the archive.
	EventSourceArn *string `min:"1" type:"string"`

	// The number of days to retain events in the archive before they are deleted.
	RetentionDays *int64 `type:"integer"`

	// The size of the archive, in bytes.
	SizeBytes *int64 `type:"long"`

	// The current state of the archive.
	State *string `type:"string" enum:"ArchiveState"`

	// A description for the reason that the archive is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Archive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Archive) GoString() string {
	return s.String()
}

// SetArchiveName sets the ArchiveName field's value.
func (s *Archive) SetArchiveName(v string) *Archive {
	s.ArchiveName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Archive) SetCreationTime(v time.Time) *Archive {
	s.CreationTime = &v
	return s
}

// SetEventCount sets the EventCount field's value.
func (s *Archive) SetEventCount(v int64) *Archive {
	s.EventCount = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *Archive) SetEventSourceArn(v string) *Archive {
	s.EventSourceArn = &v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *Archive) SetRetentionDays(v int64) *Archive {
	s.RetentionDays = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *Archive) SetSizeBytes(v int64) *Archive {
	s.SizeBytes = &v
	return s
}

// SetState sets the State field's value.
func (s *Archive) SetState(v string) *Archive {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Archive) SetStateReason(v string) *Archive {
	s.StateReason = &v
	return s
}

// This structure specifies the VPC subnets and security groups for the task,
// and whether a public IP address is to be used. This structure is relevant
// only for ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the task's elastic network interface receives a public
	// IP address. You can specify ENABLED only when LaunchType in EcsParameters
	// is set to FARGATE.
	AssignPublicIp *string `type:"string" enum:"AssignPublicIp"`

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups.
	// If you do not specify a security group, the default security group for the
	// VPC is used.
	SecurityGroups []*string `type:"list"`

	// Specifies the subnets associated with the task. These subnets must all be
	// in the same VPC. You can specify as many as 16 subnets.
	//
	// Subnets is a required field
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsVpcConfiguration"}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsVpcConfiguration) SetAssignPublicIp(v string) *AwsVpcConfiguration {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsVpcConfiguration) SetSecurityGroups(v []*string) *AwsVpcConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsVpcConfiguration) SetSubnets(v []*string) *AwsVpcConfiguration {
	s.Subnets = v
	return s
}

// The array properties for the submitted job, such as the size of the array.
// The array size can be between 2 and 10,000. If you specify array properties
// for a job, it becomes an array job. This parameter is used only if the target
// is an Batch job.
type BatchArrayProperties struct {
	_ struct{} `type:"structure"`

	// The size of the array, if this is an array batch job. Valid values are integers
	// between 2 and 10,000.
	Size *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchArrayProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchArrayProperties) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *BatchArrayProperties) SetSize(v int64) *BatchArrayProperties {
	s.Size = &v
	return s
}

// The custom parameters to be used when the target is an Batch job.
type BatchParameters struct {
	_ struct{} `type:"structure"`

	// The array properties for the submitted job, such as the size of the array.
	// The array size can be between 2 and 10,000. If you specify array properties
	// for a job, it becomes an array job. This parameter is used only if the target
	// is an Batch job.
	ArrayProperties *BatchArrayProperties `type:"structure"`

	// The ARN or name of the job definition to use if the event target is an Batch
	// job. This job definition must already exist.
	//
	// JobDefinition is a required field
	JobDefinition *string `type:"string" required:"true"`

	// The name to use for this execution of the job, if the target is an Batch
	// job.
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`

	// The retry strategy to use for failed jobs, if the target is an Batch job.
	// The retry strategy is the number of times to retry the failed job execution.
	// Valid values are 1–10. When you specify a retry strategy here, it overrides
	// the retry strategy defined in the job definition.
	RetryStrategy *BatchRetryStrategy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchParameters"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *BatchParameters) SetArrayProperties(v *BatchArrayProperties) *BatchParameters {
	s.ArrayProperties = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *BatchParameters) SetJobDefinition(v string) *BatchParameters {
	s.JobDefinition = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchParameters) SetJobName(v string) *BatchParameters {
	s.JobName = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *BatchParameters) SetRetryStrategy(v *BatchRetryStrategy) *BatchParameters {
	s.RetryStrategy = v
	return s
}

// The retry strategy to use for failed jobs, if the target is an Batch job.
// If you specify a retry strategy here, it overrides the retry strategy defined
// in the job definition.
type BatchRetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to attempt to retry, if the job fails. Valid values are
	// 1–10.
	Attempts *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRetryStrategy) GoString() string {
	return s.String()
}

// SetAttempts sets the Attempts field's value.
func (s *BatchRetryStrategy) SetAttempts(v int64) *BatchRetryStrategy {
	s.Attempts = &v
	return s
}

type CancelReplayInput struct {
	_ struct{} `type:"structure"`

	// The name of the replay to cancel.
	//
	// ReplayName is a required field
	ReplayName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelReplayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelReplayInput"}
	if s.ReplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplayName"))
	}
	if s.ReplayName != nil && len(*s.ReplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplayName sets the ReplayName field's value.
func (s *CancelReplayInput) SetReplayName(v string) *CancelReplayInput {
	s.ReplayName = &v
	return s
}

type CancelReplayOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the replay to cancel.
	ReplayArn *string `min:"1" type:"string"`

	// The current state of the replay.
	State *string `type:"string" enum:"ReplayState"`

	// The reason that the replay is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelReplayOutput) GoString() string {
	return s.String()
}

// SetReplayArn sets the ReplayArn field's value.
func (s *CancelReplayOutput) SetReplayArn(v string) *CancelReplayOutput {
	s.ReplayArn = &v
	return s
}

// SetState sets the State field's value.
func (s *CancelReplayOutput) SetState(v string) *CancelReplayOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CancelReplayOutput) SetStateReason(v string) *CancelReplayOutput {
	s.StateReason = &v
	return s
}

// The details of a capacity provider strategy. To learn more, see CapacityProviderStrategyItem
// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html)
// in the Amazon ECS API Reference.
type CapacityProviderStrategyItem struct {
	_ struct{} `type:"structure"`

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0
	// is used.
	Base *int64 `locationName:"base" type:"integer"`

	// The short name of the capacity provider.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" min:"1" type:"string" required:"true"`

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider. The weight
	// value is taken into consideration after the base value, if defined, is satisfied.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityProviderStrategyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityProviderStrategyItem"}
	if s.CapacityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProvider"))
	}
	if s.CapacityProvider != nil && len(*s.CapacityProvider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapacityProvider", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBase sets the Base field's value.
func (s *CapacityProviderStrategyItem) SetBase(v int64) *CapacityProviderStrategyItem {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *CapacityProviderStrategyItem) SetCapacityProvider(v string) *CapacityProviderStrategyItem {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CapacityProviderStrategyItem) SetWeight(v int64) *CapacityProviderStrategyItem {
	s.Weight = &v
	return s
}

// There is concurrent modification on a rule, target, archive, or replay.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A JSON string which you can use to limit the event bus permissions you are
// granting to only accounts that fulfill the condition. Currently, the only
// supported condition is membership in a certain Amazon Web Services organization.
// The string must contain Type, Key, and Value fields. The Value field specifies
// the ID of the Amazon Web Services organization. Following is an example value
// for Condition:
//
// '{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value": "o-1234567890"}'
type Condition struct {
	_ struct{} `type:"structure"`

	// Specifies the key for the condition. Currently the only supported key is
	// aws:PrincipalOrgID.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Specifies the type of condition. Currently the only supported value is StringEquals.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// Specifies the value for the key. Currently, this must be the ID of the organization.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Condition) SetKey(v string) *Condition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *Condition) SetType(v string) *Condition {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Condition) SetValue(v string) *Condition {
	s.Value = &v
	return s
}

// Contains information about a connection.
type Connection struct {
	_ struct{} `type:"structure"`

	// The authorization type specified for the connection.
	//
	// OAUTH tokens are refreshed when a 401 or 407 response is returned.
	AuthorizationType *string `type:"string" enum:"ConnectionAuthorizationType"`

	// The ARN of the connection.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last authorized.
	LastAuthorizedTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the connection.
	Name *string `min:"1" type:"string"`

	// The reason that the connection is in the connection state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *Connection) SetAuthorizationType(v string) *Connection {
	s.AuthorizationType = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *Connection) SetConnectionArn(v string) *Connection {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *Connection) SetConnectionState(v string) *Connection {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Connection) SetCreationTime(v time.Time) *Connection {
	s.CreationTime = &v
	return s
}

// SetLastAuthorizedTime sets the LastAuthorizedTime field's value.
func (s *Connection) SetLastAuthorizedTime(v time.Time) *Connection {
	s.LastAuthorizedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Connection) SetLastModifiedTime(v time.Time) *Connection {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Connection) SetName(v string) *Connection {
	s.Name = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Connection) SetStateReason(v string) *Connection {
	s.StateReason = &v
	return s
}

// Contains the authorization parameters for the connection if API Key is specified
// as the authorization type.
type ConnectionApiKeyAuthResponseParameters struct {
	_ struct{} `type:"structure"`

	// The name of the header to use for the APIKeyValue used for authorization.
	ApiKeyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionApiKeyAuthResponseParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionApiKeyAuthResponseParameters) GoString() string {
	return s.String()
}

// SetApiKeyName sets the ApiKeyName field's value.
func (s *ConnectionApiKeyAuthResponseParameters) SetApiKeyName(v string) *ConnectionApiKeyAuthResponseParameters {
	s.ApiKeyName = &v
	return s
}

// Contains the authorization parameters to use for the connection.
type ConnectionAuthResponseParameters struct {
	_ struct{} `type:"structure"`

	// The API Key parameters to use for authorization.
	ApiKeyAuthParameters *ConnectionApiKeyAuthResponseParameters `type:"structure"`

	// The authorization parameters for Basic authorization.
	BasicAuthParameters *ConnectionBasicAuthResponseParameters `type:"structure"`

	// Additional parameters for the connection that are passed through with every
	// invocation to the HTTP endpoint.
	InvocationHttpParameters *ConnectionHttpParameters `type:"structure"`

	// The OAuth parameters to use for authorization.
	OAuthParameters *ConnectionOAuthResponseParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAuthResponseParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAuthResponseParameters) GoString() string {
	return s.String()
}

// SetApiKeyAuthParameters sets the ApiKeyAuthParameters field's value.
func (s *ConnectionAuthResponseParameters) SetApiKeyAuthParameters(v *ConnectionApiKeyAuthResponseParameters) *ConnectionAuthResponseParameters {
	s.ApiKeyAuthParameters = v
	return s
}

// SetBasicAuthParameters sets the BasicAuthParameters field's value.
func (s *ConnectionAuthResponseParameters) SetBasicAuthParameters(v *ConnectionBasicAuthResponseParameters) *ConnectionAuthResponseParameters {
	s.BasicAuthParameters = v
	return s
}

// SetInvocationHttpParameters sets the InvocationHttpParameters field's value.
func (s *ConnectionAuthResponseParameters) SetInvocationHttpParameters(v *ConnectionHttpParameters) *ConnectionAuthResponseParameters {
	s.InvocationHttpParameters = v
	return s
}

// SetOAuthParameters sets the OAuthParameters field's value.
func (s *ConnectionAuthResponseParameters) SetOAuthParameters(v *ConnectionOAuthResponseParameters) *ConnectionAuthResponseParameters {
	s.OAuthParameters = v
	return s
}

// Contains the authorization parameters for the connection if Basic is specified
// as the authorization type.
type ConnectionBasicAuthResponseParameters struct {
	_ struct{} `type:"structure"`

	// The user name to use for Basic authorization.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionBasicAuthResponseParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionBasicAuthResponseParameters) GoString() string {
	return s.String()
}

// SetUsername sets the Username field's value.
func (s *ConnectionBasicAuthResponseParameters) SetUsername(v string) *ConnectionBasicAuthResponseParameters {
	s.Username = &v
	return s
}

// Additional parameter included in the body. You can include up to 100 additional
// body parameters per request. An event payload cannot exceed 64 KB.
type ConnectionBodyParameter struct {
	_ struct{} `type:"structure"`

	// Specified whether the value is secret.
	IsValueSecret *bool `type:"boolean"`

	// The key for the parameter.
	Key *string `type:"string"`

	// The value associated with the key.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConnectionBodyParameter's
	// String and GoString methods.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionBodyParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionBodyParameter) GoString() string {
	return s.String()
}

// SetIsValueSecret sets the IsValueSecret field's value.
func (s *ConnectionBodyParameter) SetIsValueSecret(v bool) *ConnectionBodyParameter {
	s.IsValueSecret = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ConnectionBodyParameter) SetKey(v string) *ConnectionBodyParameter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConnectionBodyParameter) SetValue(v string) *ConnectionBodyParameter {
	s.Value = &v
	return s
}

// Additional parameter included in the header. You can include up to 100 additional
// header parameters per request. An event payload cannot exceed 64 KB.
type ConnectionHeaderParameter struct {
	_ struct{} `type:"structure"`

	// Specified whether the value is a secret.
	IsValueSecret *bool `type:"boolean"`

	// The key for the parameter.
	Key *string `type:"string"`

	// The value associated with the key.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConnectionHeaderParameter's
	// String and GoString methods.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionHeaderParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionHeaderParameter) GoString() string {
	return s.String()
}

// SetIsValueSecret sets the IsValueSecret field's value.
func (s *ConnectionHeaderParameter) SetIsValueSecret(v bool) *ConnectionHeaderParameter {
	s.IsValueSecret = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ConnectionHeaderParameter) SetKey(v string) *ConnectionHeaderParameter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConnectionHeaderParameter) SetValue(v string) *ConnectionHeaderParameter {
	s.Value = &v
	return s
}

// Contains additional parameters for the connection.
type ConnectionHttpParameters struct {
	_ struct{} `type:"structure"`

	// Contains additional body string parameters for the connection.
	BodyParameters []*ConnectionBodyParameter `type:"list"`

	// Contains additional header parameters for the connection.
	HeaderParameters []*ConnectionHeaderParameter `type:"list"`

	// Contains additional query string parameters for the connection.
	QueryStringParameters []*ConnectionQueryStringParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionHttpParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionHttpParameters) GoString() string {
	return s.String()
}

// SetBodyParameters sets the BodyParameters field's value.
func (s *ConnectionHttpParameters) SetBodyParameters(v []*ConnectionBodyParameter) *ConnectionHttpParameters {
	s.BodyParameters = v
	return s
}

// SetHeaderParameters sets the HeaderParameters field's value.
func (s *ConnectionHttpParameters) SetHeaderParameters(v []*ConnectionHeaderParameter) *ConnectionHttpParameters {
	s.HeaderParameters = v
	return s
}

// SetQueryStringParameters sets the QueryStringParameters field's value.
func (s *ConnectionHttpParameters) SetQueryStringParameters(v []*ConnectionQueryStringParameter) *ConnectionHttpParameters {
	s.QueryStringParameters = v
	return s
}

// Contains the client response parameters for the connection when OAuth is
// specified as the authorization type.
type ConnectionOAuthClientResponseParameters struct {
	_ struct{} `type:"structure"`

	// The client ID associated with the response to the connection request.
	ClientID *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionOAuthClientResponseParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionOAuthClientResponseParameters) GoString() string {
	return s.String()
}

// SetClientID sets the ClientID field's value.
func (s *ConnectionOAuthClientResponseParameters) SetClientID(v string) *ConnectionOAuthClientResponseParameters {
	s.ClientID = &v
	return s
}

// Contains the response parameters when OAuth is specified as the authorization
// type.
type ConnectionOAuthResponseParameters struct {
	_ struct{} `type:"structure"`

	// The URL to the HTTP endpoint that authorized the request.
	AuthorizationEndpoint *string `min:"1" type:"string"`

	// A ConnectionOAuthClientResponseParameters object that contains details about
	// the client parameters returned when OAuth is specified as the authorization
	// type.
	ClientParameters *ConnectionOAuthClientResponseParameters `type:"structure"`

	// The method used to connect to the HTTP endpoint.
	HttpMethod *string `type:"string" enum:"ConnectionOAuthHttpMethod"`

	// The additional HTTP parameters used for the OAuth authorization request.
	OAuthHttpParameters *ConnectionHttpParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionOAuthResponseParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionOAuthResponseParameters) GoString() string {
	return s.String()
}

// SetAuthorizationEndpoint sets the AuthorizationEndpoint field's value.
func (s *ConnectionOAuthResponseParameters) SetAuthorizationEndpoint(v string) *ConnectionOAuthResponseParameters {
	s.AuthorizationEndpoint = &v
	return s
}

// SetClientParameters sets the ClientParameters field's value.
func (s *ConnectionOAuthResponseParameters) SetClientParameters(v *ConnectionOAuthClientResponseParameters) *ConnectionOAuthResponseParameters {
	s.ClientParameters = v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *ConnectionOAuthResponseParameters) SetHttpMethod(v string) *ConnectionOAuthResponseParameters {
	s.HttpMethod = &v
	return s
}

// SetOAuthHttpParameters sets the OAuthHttpParameters field's value.
func (s *ConnectionOAuthResponseParameters) SetOAuthHttpParameters(v *ConnectionHttpParameters) *ConnectionOAuthResponseParameters {
	s.OAuthHttpParameters = v
	return s
}

// Additional query string parameter for the connection. You can include up
// to 100 additional query string parameters per request. Each additional parameter
// counts towards the event payload size, which cannot exceed 64 KB.
type ConnectionQueryStringParameter struct {
	_ struct{} `type:"structure"`

	// Specifies whether the value is secret.
	IsValueSecret *bool `type:"boolean"`

	// The key for a query string parameter.
	Key *string `type:"string"`

	// The value associated with the key for the query string parameter.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConnectionQueryStringParameter's
	// String and GoString methods.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionQueryStringParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionQueryStringParameter) GoString() string {
	return s.String()
}

// SetIsValueSecret sets the IsValueSecret field's value.
func (s *ConnectionQueryStringParameter) SetIsValueSecret(v bool) *ConnectionQueryStringParameter {
	s.IsValueSecret = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ConnectionQueryStringParameter) SetKey(v string) *ConnectionQueryStringParameter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConnectionQueryStringParameter) SetValue(v string) *ConnectionQueryStringParameter {
	s.Value = &v
	return s
}

type CreateApiDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection to use for the API destination. The destination
	// endpoint must support the authorization type specified for the connection.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `min:"1" type:"string" required:"true"`

	// A description for the API destination to create.
	Description *string `type:"string"`

	// The method to use for the request to the HTTP invocation endpoint.
	//
	// HttpMethod is a required field
	HttpMethod *string `type:"string" required:"true" enum:"ApiDestinationHttpMethod"`

	// The URL to the HTTP invocation endpoint for the API destination.
	//
	// InvocationEndpoint is a required field
	InvocationEndpoint *string `min:"1" type:"string" required:"true"`

	// The maximum number of requests per second to send to the HTTP invocation
	// endpoint.
	InvocationRateLimitPerSecond *int64 `min:"1" type:"integer"`

	// The name for the API destination to create.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApiDestinationInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.InvocationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("InvocationEndpoint"))
	}
	if s.InvocationEndpoint != nil && len(*s.InvocationEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationEndpoint", 1))
	}
	if s.InvocationRateLimitPerSecond != nil && *s.InvocationRateLimitPerSecond < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InvocationRateLimitPerSecond", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *CreateApiDestinationInput) SetConnectionArn(v string) *CreateApiDestinationInput {
	s.ConnectionArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApiDestinationInput) SetDescription(v string) *CreateApiDestinationInput {
	s.Description = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *CreateApiDestinationInput) SetHttpMethod(v string) *CreateApiDestinationInput {
	s.HttpMethod = &v
	return s
}

// SetInvocationEndpoint sets the InvocationEndpoint field's value.
func (s *CreateApiDestinationInput) SetInvocationEndpoint(v string) *CreateApiDestinationInput {
	s.InvocationEndpoint = &v
	return s
}

// SetInvocationRateLimitPerSecond sets the InvocationRateLimitPerSecond field's value.
func (s *CreateApiDestinationInput) SetInvocationRateLimitPerSecond(v int64) *CreateApiDestinationInput {
	s.InvocationRateLimitPerSecond = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApiDestinationInput) SetName(v string) *CreateApiDestinationInput {
	s.Name = &v
	return s
}

type CreateApiDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the API destination that was created by the request.
	ApiDestinationArn *string `min:"1" type:"string"`

	// The state of the API destination that was created by the request.
	ApiDestinationState *string `type:"string" enum:"ApiDestinationState"`

	// A time stamp indicating the time that the API destination was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp indicating the time that the API destination was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiDestinationOutput) GoString() string {
	return s.String()
}

// SetApiDestinationArn sets the ApiDestinationArn field's value.
func (s *CreateApiDestinationOutput) SetApiDestinationArn(v string) *CreateApiDestinationOutput {
	s.ApiDestinationArn = &v
	return s
}

// SetApiDestinationState sets the ApiDestinationState field's value.
func (s *CreateApiDestinationOutput) SetApiDestinationState(v string) *CreateApiDestinationOutput {
	s.ApiDestinationState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateApiDestinationOutput) SetCreationTime(v time.Time) *CreateApiDestinationOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateApiDestinationOutput) SetLastModifiedTime(v time.Time) *CreateApiDestinationOutput {
	s.LastModifiedTime = &v
	return s
}

type CreateArchiveInput struct {
	_ struct{} `type:"structure"`

	// The name for the archive to create.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`

	// A description for the archive.
	Description *string `type:"string"`

	// An event pattern to use to filter events sent to the archive.
	EventPattern *string `type:"string"`

	// The ARN of the event bus that sends events to the archive.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `min:"1" type:"string" required:"true"`

	// The number of days to retain events for. Default value is 0. If set to 0,
	// events are retained indefinitely
	RetentionDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateArchiveInput"}
	if s.ArchiveName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveName"))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}
	if s.EventSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceArn"))
	}
	if s.EventSourceArn != nil && len(*s.EventSourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveName sets the ArchiveName field's value.
func (s *CreateArchiveInput) SetArchiveName(v string) *CreateArchiveInput {
	s.ArchiveName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateArchiveInput) SetDescription(v string) *CreateArchiveInput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *CreateArchiveInput) SetEventPattern(v string) *CreateArchiveInput {
	s.EventPattern = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *CreateArchiveInput) SetEventSourceArn(v string) *CreateArchiveInput {
	s.EventSourceArn = &v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *CreateArchiveInput) SetRetentionDays(v int64) *CreateArchiveInput {
	s.RetentionDays = &v
	return s
}

type CreateArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the archive that was created.
	ArchiveArn *string `min:"1" type:"string"`

	// The time at which the archive was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state of the archive that was created.
	State *string `type:"string" enum:"ArchiveState"`

	// The reason that the archive is in the state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateArchiveOutput) GoString() string {
	return s.String()
}

// SetArchiveArn sets the ArchiveArn field's value.
func (s *CreateArchiveOutput) SetArchiveArn(v string) *CreateArchiveOutput {
	s.ArchiveArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateArchiveOutput) SetCreationTime(v time.Time) *CreateArchiveOutput {
	s.CreationTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateArchiveOutput) SetState(v string) *CreateArchiveOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CreateArchiveOutput) SetStateReason(v string) *CreateArchiveOutput {
	s.StateReason = &v
	return s
}

// Contains the API key authorization parameters for the connection.
type CreateConnectionApiKeyAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The name of the API key to use for authorization.
	//
	// ApiKeyName is a required field
	ApiKeyName *string `min:"1" type:"string" required:"true"`

	// The value for the API key to use for authorization.
	//
	// ApiKeyValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateConnectionApiKeyAuthRequestParameters's
	// String and GoString methods.
	//
	// ApiKeyValue is a required field
	ApiKeyValue *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionApiKeyAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionApiKeyAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionApiKeyAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionApiKeyAuthRequestParameters"}
	if s.ApiKeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKeyName"))
	}
	if s.ApiKeyName != nil && len(*s.ApiKeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKeyName", 1))
	}
	if s.ApiKeyValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKeyValue"))
	}
	if s.ApiKeyValue != nil && len(*s.ApiKeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyName sets the ApiKeyName field's value.
func (s *CreateConnectionApiKeyAuthRequestParameters) SetApiKeyName(v string) *CreateConnectionApiKeyAuthRequestParameters {
	s.ApiKeyName = &v
	return s
}

// SetApiKeyValue sets the ApiKeyValue field's value.
func (s *CreateConnectionApiKeyAuthRequestParameters) SetApiKeyValue(v string) *CreateConnectionApiKeyAuthRequestParameters {
	s.ApiKeyValue = &v
	return s
}

// Contains the authorization parameters for the connection.
type CreateConnectionAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// A CreateConnectionApiKeyAuthRequestParameters object that contains the API
	// key authorization parameters to use for the connection.
	ApiKeyAuthParameters *CreateConnectionApiKeyAuthRequestParameters `type:"structure"`

	// A CreateConnectionBasicAuthRequestParameters object that contains the Basic
	// authorization parameters to use for the connection.
	BasicAuthParameters *CreateConnectionBasicAuthRequestParameters `type:"structure"`

	// A ConnectionHttpParameters object that contains the API key authorization
	// parameters to use for the connection. Note that if you include additional
	// parameters for the target of a rule via HttpParameters, including query strings,
	// the parameters added for the connection take precedence.
	InvocationHttpParameters *ConnectionHttpParameters `type:"structure"`

	// A CreateConnectionOAuthRequestParameters object that contains the OAuth authorization
	// parameters to use for the connection.
	OAuthParameters *CreateConnectionOAuthRequestParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionAuthRequestParameters"}
	if s.ApiKeyAuthParameters != nil {
		if err := s.ApiKeyAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("ApiKeyAuthParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.BasicAuthParameters != nil {
		if err := s.BasicAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("BasicAuthParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.OAuthParameters != nil {
		if err := s.OAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("OAuthParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyAuthParameters sets the ApiKeyAuthParameters field's value.
func (s *CreateConnectionAuthRequestParameters) SetApiKeyAuthParameters(v *CreateConnectionApiKeyAuthRequestParameters) *CreateConnectionAuthRequestParameters {
	s.ApiKeyAuthParameters = v
	return s
}

// SetBasicAuthParameters sets the BasicAuthParameters field's value.
func (s *CreateConnectionAuthRequestParameters) SetBasicAuthParameters(v *CreateConnectionBasicAuthRequestParameters) *CreateConnectionAuthRequestParameters {
	s.BasicAuthParameters = v
	return s
}

// SetInvocationHttpParameters sets the InvocationHttpParameters field's value.
func (s *CreateConnectionAuthRequestParameters) SetInvocationHttpParameters(v *ConnectionHttpParameters) *CreateConnectionAuthRequestParameters {
	s.InvocationHttpParameters = v
	return s
}

// SetOAuthParameters sets the OAuthParameters field's value.
func (s *CreateConnectionAuthRequestParameters) SetOAuthParameters(v *CreateConnectionOAuthRequestParameters) *CreateConnectionAuthRequestParameters {
	s.OAuthParameters = v
	return s
}

// Contains the Basic authorization parameters to use for the connection.
type CreateConnectionBasicAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The password associated with the user name to use for Basic authorization.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateConnectionBasicAuthRequestParameters's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user name to use for Basic authorization.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionBasicAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionBasicAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionBasicAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionBasicAuthRequestParameters"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *CreateConnectionBasicAuthRequestParameters) SetPassword(v string) *CreateConnectionBasicAuthRequestParameters {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateConnectionBasicAuthRequestParameters) SetUsername(v string) *CreateConnectionBasicAuthRequestParameters {
	s.Username = &v
	return s
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// A CreateConnectionAuthRequestParameters object that contains the authorization
	// parameters to use to authorize with the endpoint.
	//
	// AuthParameters is a required field
	AuthParameters *CreateConnectionAuthRequestParameters `type:"structure" required:"true"`

	// The type of authorization to use for the connection.
	//
	// OAUTH tokens are refreshed when a 401 or 407 response is returned.
	//
	// AuthorizationType is a required field
	AuthorizationType *string `type:"string" required:"true" enum:"ConnectionAuthorizationType"`

	// A description for the connection to create.
	Description *string `type:"string"`

	// The name for the connection to create.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.AuthParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthParameters"))
	}
	if s.AuthorizationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AuthParameters != nil {
		if err := s.AuthParameters.Validate(); err != nil {
			invalidParams.AddNested("AuthParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *CreateConnectionInput) SetAuthParameters(v *CreateConnectionAuthRequestParameters) *CreateConnectionInput {
	s.AuthParameters = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *CreateConnectionInput) SetAuthorizationType(v string) *CreateConnectionInput {
	s.AuthorizationType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConnectionInput) SetDescription(v string) *CreateConnectionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConnectionInput) SetName(v string) *CreateConnectionInput {
	s.Name = &v
	return s
}

// Contains the Basic authorization parameters to use for the connection.
type CreateConnectionOAuthClientRequestParameters struct {
	_ struct{} `type:"structure"`

	// The client ID to use for OAuth authorization for the connection.
	//
	// ClientID is a required field
	ClientID *string `min:"1" type:"string" required:"true"`

	// The client secret associated with the client ID to use for OAuth authorization
	// for the connection.
	//
	// ClientSecret is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateConnectionOAuthClientRequestParameters's
	// String and GoString methods.
	//
	// ClientSecret is a required field
	ClientSecret *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOAuthClientRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOAuthClientRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionOAuthClientRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionOAuthClientRequestParameters"}
	if s.ClientID == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientID", 1))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}
	if s.ClientSecret != nil && len(*s.ClientSecret) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientSecret", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientID sets the ClientID field's value.
func (s *CreateConnectionOAuthClientRequestParameters) SetClientID(v string) *CreateConnectionOAuthClientRequestParameters {
	s.ClientID = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *CreateConnectionOAuthClientRequestParameters) SetClientSecret(v string) *CreateConnectionOAuthClientRequestParameters {
	s.ClientSecret = &v
	return s
}

// Contains the OAuth authorization parameters to use for the connection.
type CreateConnectionOAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The URL to the authorization endpoint when OAuth is specified as the authorization
	// type.
	//
	// AuthorizationEndpoint is a required field
	AuthorizationEndpoint *string `min:"1" type:"string" required:"true"`

	// A CreateConnectionOAuthClientRequestParameters object that contains the client
	// parameters for OAuth authorization.
	//
	// ClientParameters is a required field
	ClientParameters *CreateConnectionOAuthClientRequestParameters `type:"structure" required:"true"`

	// The method to use for the authorization request.
	//
	// HttpMethod is a required field
	HttpMethod *string `type:"string" required:"true" enum:"ConnectionOAuthHttpMethod"`

	// A ConnectionHttpParameters object that contains details about the additional
	// parameters to use for the connection.
	OAuthHttpParameters *ConnectionHttpParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionOAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionOAuthRequestParameters"}
	if s.AuthorizationEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationEndpoint"))
	}
	if s.AuthorizationEndpoint != nil && len(*s.AuthorizationEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizationEndpoint", 1))
	}
	if s.ClientParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientParameters"))
	}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.ClientParameters != nil {
		if err := s.ClientParameters.Validate(); err != nil {
			invalidParams.AddNested("ClientParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationEndpoint sets the AuthorizationEndpoint field's value.
func (s *CreateConnectionOAuthRequestParameters) SetAuthorizationEndpoint(v string) *CreateConnectionOAuthRequestParameters {
	s.AuthorizationEndpoint = &v
	return s
}

// SetClientParameters sets the ClientParameters field's value.
func (s *CreateConnectionOAuthRequestParameters) SetClientParameters(v *CreateConnectionOAuthClientRequestParameters) *CreateConnectionOAuthRequestParameters {
	s.ClientParameters = v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *CreateConnectionOAuthRequestParameters) SetHttpMethod(v string) *CreateConnectionOAuthRequestParameters {
	s.HttpMethod = &v
	return s
}

// SetOAuthHttpParameters sets the OAuthHttpParameters field's value.
func (s *CreateConnectionOAuthRequestParameters) SetOAuthHttpParameters(v *ConnectionHttpParameters) *CreateConnectionOAuthRequestParameters {
	s.OAuthHttpParameters = v
	return s
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection that was created by the request.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection that was created by the request.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *CreateConnectionOutput) SetConnectionArn(v string) *CreateConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *CreateConnectionOutput) SetConnectionState(v string) *CreateConnectionOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateConnectionOutput) SetCreationTime(v time.Time) *CreateConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateConnectionOutput) SetLastModifiedTime(v time.Time) *CreateConnectionOutput {
	s.LastModifiedTime = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// A description of the global endpoint.
	Description *string `type:"string"`

	// Define the event buses used.
	//
	// The names of the event buses must be identical in each Region.
	//
	// EventBuses is a required field
	EventBuses []*EndpointEventBus `min:"2" type:"list" required:"true"`

	// The name of the global endpoint. For example, "Name":"us-east-2-custom_bus_A-endpoint".
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Enable or disable event replication. The default state is ENABLED which means
	// you must supply a RoleArn. If you don't have a RoleArn or you don't want
	// event replication enabled, set the state to DISABLED.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used for replication.
	RoleArn *string `min:"1" type:"string"`

	// Configure the routing policy, including the health check and secondary Region..
	//
	// RoutingConfig is a required field
	RoutingConfig *RoutingConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EventBuses == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBuses"))
	}
	if s.EventBuses != nil && len(s.EventBuses) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("EventBuses", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.RoutingConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingConfig"))
	}
	if s.EventBuses != nil {
		for i, v := range s.EventBuses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventBuses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RoutingConfig != nil {
		if err := s.RoutingConfig.Validate(); err != nil {
			invalidParams.AddNested("RoutingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEndpointInput) SetDescription(v string) *CreateEndpointInput {
	s.Description = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *CreateEndpointInput) SetEventBuses(v []*EndpointEventBus) *CreateEndpointInput {
	s.EventBuses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEndpointInput) SetName(v string) *CreateEndpointInput {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *CreateEndpointInput) SetReplicationConfig(v *ReplicationConfig) *CreateEndpointInput {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateEndpointInput) SetRoleArn(v string) *CreateEndpointInput {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *CreateEndpointInput) SetRoutingConfig(v *RoutingConfig) *CreateEndpointInput {
	s.RoutingConfig = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the endpoint that was created by this request.
	Arn *string `min:"1" type:"string"`

	// The event buses used by this request.
	EventBuses []*EndpointEventBus `min:"2" type:"list"`

	// The name of the endpoint that was created by this request.
	Name *string `min:"1" type:"string"`

	// Whether event replication was enabled or disabled by this request.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used by event replication for this request.
	RoleArn *string `min:"1" type:"string"`

	// The routing configuration defined by this request.
	RoutingConfig *RoutingConfig `type:"structure"`

	// The state of the endpoint that was created by this request.
	State *string `type:"string" enum:"EndpointState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEndpointOutput) SetArn(v string) *CreateEndpointOutput {
	s.Arn = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *CreateEndpointOutput) SetEventBuses(v []*EndpointEventBus) *CreateEndpointOutput {
	s.EventBuses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEndpointOutput) SetName(v string) *CreateEndpointOutput {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *CreateEndpointOutput) SetReplicationConfig(v *ReplicationConfig) *CreateEndpointOutput {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateEndpointOutput) SetRoleArn(v string) *CreateEndpointOutput {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *CreateEndpointOutput) SetRoutingConfig(v *RoutingConfig) *CreateEndpointOutput {
	s.RoutingConfig = v
	return s
}

// SetState sets the State field's value.
func (s *CreateEndpointOutput) SetState(v string) *CreateEndpointOutput {
	s.State = &v
	return s
}

type CreateEventBusInput struct {
	_ struct{} `type:"structure"`

	// If you are creating a partner event bus, this specifies the partner event
	// source that the new event bus will be matched with.
	EventSourceName *string `min:"1" type:"string"`

	// The name of the new event bus.
	//
	// Custom event bus names can't contain the / character, but you can use the
	// / character in partner event bus names. In addition, for partner event buses,
	// the name must exactly match the name of the partner event source that this
	// event bus is matched to.
	//
	// You can't use the name default for a custom event bus, as this name is already
	// used for your account's default event bus.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Tags to associate with the event bus.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventBusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventBusInput"}
	if s.EventSourceName != nil && len(*s.EventSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceName sets the EventSourceName field's value.
func (s *CreateEventBusInput) SetEventSourceName(v string) *CreateEventBusInput {
	s.EventSourceName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventBusInput) SetName(v string) *CreateEventBusInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventBusInput) SetTags(v []*Tag) *CreateEventBusInput {
	s.Tags = v
	return s
}

type CreateEventBusOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new event bus.
	EventBusArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBusOutput) GoString() string {
	return s.String()
}

// SetEventBusArn sets the EventBusArn field's value.
func (s *CreateEventBusOutput) SetEventBusArn(v string) *CreateEventBusOutput {
	s.EventBusArn = &v
	return s
}

type CreatePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that is permitted to create a matching
	// partner event bus for this partner event source.
	//
	// Account is a required field
	Account *string `min:"12" type:"string" required:"true"`

	// The name of the partner event source. This name must be unique and must be
	// in the format partner_name/event_namespace/event_name . The Amazon Web Services
	// account that wants to use this partner event source must create a partner
	// event bus with a name that matches the name of the partner event source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartnerEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartnerEventSourceInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.Account != nil && len(*s.Account) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Account", 12))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *CreatePartnerEventSourceInput) SetAccount(v string) *CreatePartnerEventSourceInput {
	s.Account = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePartnerEventSourceInput) SetName(v string) *CreatePartnerEventSourceInput {
	s.Name = &v
	return s
}

type CreatePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the partner event source.
	EventSourceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerEventSourceOutput) GoString() string {
	return s.String()
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *CreatePartnerEventSourceOutput) SetEventSourceArn(v string) *CreatePartnerEventSourceOutput {
	s.EventSourceArn = &v
	return s
}

type DeactivateEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to deactivate.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateEventSourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeactivateEventSourceInput) SetName(v string) *DeactivateEventSourceInput {
	s.Name = &v
	return s
}

type DeactivateEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeactivateEventSourceOutput) GoString() string {
	return s.String()
}

// A DeadLetterConfig object that contains information about a dead-letter queue
// configuration.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the SQS queue specified as the target for the dead-letter queue.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeadLetterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeadLetterConfig"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeadLetterConfig) SetArn(v string) *DeadLetterConfig {
	s.Arn = &v
	return s
}

type DeauthorizeConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the connection to remove authorization from.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeauthorizeConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeauthorizeConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeauthorizeConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeauthorizeConnectionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeauthorizeConnectionInput) SetName(v string) *DeauthorizeConnectionInput {
	s.Name = &v
	return s
}

type DeauthorizeConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection that authorization was removed from.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last authorized.
	LastAuthorizedTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeauthorizeConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeauthorizeConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DeauthorizeConnectionOutput) SetConnectionArn(v string) *DeauthorizeConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *DeauthorizeConnectionOutput) SetConnectionState(v string) *DeauthorizeConnectionOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DeauthorizeConnectionOutput) SetCreationTime(v time.Time) *DeauthorizeConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetLastAuthorizedTime sets the LastAuthorizedTime field's value.
func (s *DeauthorizeConnectionOutput) SetLastAuthorizedTime(v time.Time) *DeauthorizeConnectionOutput {
	s.LastAuthorizedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DeauthorizeConnectionOutput) SetLastModifiedTime(v time.Time) *DeauthorizeConnectionOutput {
	s.LastModifiedTime = &v
	return s
}

type DeleteApiDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the destination to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApiDestinationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteApiDestinationInput) SetName(v string) *DeleteApiDestinationInput {
	s.Name = &v
	return s
}

type DeleteApiDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiDestinationOutput) GoString() string {
	return s.String()
}

type DeleteArchiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the archive to delete.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteArchiveInput"}
	if s.ArchiveName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveName"))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveName sets the ArchiveName field's value.
func (s *DeleteArchiveInput) SetArchiveName(v string) *DeleteArchiveInput {
	s.ArchiveName = &v
	return s
}

type DeleteArchiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteArchiveOutput) GoString() string {
	return s.String()
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the connection to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteConnectionInput) SetName(v string) *DeleteConnectionInput {
	s.Name = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection that was deleted.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection before it was deleted.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last authorized before
	// it wa deleted.
	LastAuthorizedTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last modified before it
	// was deleted.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DeleteConnectionOutput) SetConnectionArn(v string) *DeleteConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *DeleteConnectionOutput) SetConnectionState(v string) *DeleteConnectionOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DeleteConnectionOutput) SetCreationTime(v time.Time) *DeleteConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetLastAuthorizedTime sets the LastAuthorizedTime field's value.
func (s *DeleteConnectionOutput) SetLastAuthorizedTime(v time.Time) *DeleteConnectionOutput {
	s.LastAuthorizedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DeleteConnectionOutput) SetLastModifiedTime(v time.Time) *DeleteConnectionOutput {
	s.LastModifiedTime = &v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint you want to delete. For example, "Name":"us-east-2-custom_bus_A-endpoint"..
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEndpointInput) SetName(v string) *DeleteEndpointInput {
	s.Name = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteEventBusInput struct {
	_ struct{} `type:"structure"`

	// The name of the event bus to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventBusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventBusInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEventBusInput) SetName(v string) *DeleteEventBusInput {
	s.Name = &v
	return s
}

type DeleteEventBusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBusOutput) GoString() string {
	return s.String()
}

type DeletePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the Amazon Web Services customer that
	// the event source was created for.
	//
	// Account is a required field
	Account *string `min:"12" type:"string" required:"true"`

	// The name of the event source to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnerEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePartnerEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePartnerEventSourceInput"}
	if s.Account == nil {
		invalidParams.Add(request.NewErrParamRequired("Account"))
	}
	if s.Account != nil && len(*s.Account) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Account", 12))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccount sets the Account field's value.
func (s *DeletePartnerEventSourceInput) SetAccount(v string) *DeletePartnerEventSourceInput {
	s.Account = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeletePartnerEventSourceInput) SetName(v string) *DeletePartnerEventSourceInput {
	s.Name = &v
	return s
}

type DeletePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePartnerEventSourceOutput) GoString() string {
	return s.String()
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// If this is a managed rule, created by an Amazon Web Services service on your
	// behalf, you must specify Force as True to delete the rule. This parameter
	// is ignored for rules that are not managed rules. You can check whether a
	// rule is a managed rule by using DescribeRule or ListRules and checking the
	// ManagedBy field of the response.
	Force *bool `type:"boolean"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *DeleteRuleInput) SetEventBusName(v string) *DeleteRuleInput {
	s.EventBusName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteRuleInput) SetForce(v bool) *DeleteRuleInput {
	s.Force = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteRuleInput) SetName(v string) *DeleteRuleInput {
	s.Name = &v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DescribeApiDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the API destination to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApiDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApiDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApiDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApiDestinationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeApiDestinationInput) SetName(v string) *DescribeApiDestinationInput {
	s.Name = &v
	return s
}

type DescribeApiDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the API destination retrieved.
	ApiDestinationArn *string `min:"1" type:"string"`

	// The state of the API destination retrieved.
	ApiDestinationState *string `type:"string" enum:"ApiDestinationState"`

	// The ARN of the connection specified for the API destination retrieved.
	ConnectionArn *string `min:"1" type:"string"`

	// A time stamp for the time that the API destination was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for the API destination retrieved.
	Description *string `type:"string"`

	// The method to use to connect to the HTTP endpoint.
	HttpMethod *string `type:"string" enum:"ApiDestinationHttpMethod"`

	// The URL to use to connect to the HTTP endpoint.
	InvocationEndpoint *string `min:"1" type:"string"`

	// The maximum number of invocations per second to specified for the API destination.
	// Note that if you set the invocation rate maximum to a value lower the rate
	// necessary to send all events received on to the destination HTTP endpoint,
	// some events may not be delivered within the 24-hour retry window. If you
	// plan to set the rate lower than the rate necessary to deliver all events,
	// consider using a dead-letter queue to catch events that are not delivered
	// within 24 hours.
	InvocationRateLimitPerSecond *int64 `min:"1" type:"integer"`

	// A time stamp for the time that the API destination was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the API destination retrieved.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApiDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApiDestinationOutput) GoString() string {
	return s.String()
}

// SetApiDestinationArn sets the ApiDestinationArn field's value.
func (s *DescribeApiDestinationOutput) SetApiDestinationArn(v string) *DescribeApiDestinationOutput {
	s.ApiDestinationArn = &v
	return s
}

// SetApiDestinationState sets the ApiDestinationState field's value.
func (s *DescribeApiDestinationOutput) SetApiDestinationState(v string) *DescribeApiDestinationOutput {
	s.ApiDestinationState = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DescribeApiDestinationOutput) SetConnectionArn(v string) *DescribeApiDestinationOutput {
	s.ConnectionArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeApiDestinationOutput) SetCreationTime(v time.Time) *DescribeApiDestinationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeApiDestinationOutput) SetDescription(v string) *DescribeApiDestinationOutput {
	s.Description = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *DescribeApiDestinationOutput) SetHttpMethod(v string) *DescribeApiDestinationOutput {
	s.HttpMethod = &v
	return s
}

// SetInvocationEndpoint sets the InvocationEndpoint field's value.
func (s *DescribeApiDestinationOutput) SetInvocationEndpoint(v string) *DescribeApiDestinationOutput {
	s.InvocationEndpoint = &v
	return s
}

// SetInvocationRateLimitPerSecond sets the InvocationRateLimitPerSecond field's value.
func (s *DescribeApiDestinationOutput) SetInvocationRateLimitPerSecond(v int64) *DescribeApiDestinationOutput {
	s.InvocationRateLimitPerSecond = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeApiDestinationOutput) SetLastModifiedTime(v time.Time) *DescribeApiDestinationOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeApiDestinationOutput) SetName(v string) *DescribeApiDestinationOutput {
	s.Name = &v
	return s
}

type DescribeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the archive to retrieve.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeArchiveInput"}
	if s.ArchiveName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveName"))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveName sets the ArchiveName field's value.
func (s *DescribeArchiveInput) SetArchiveName(v string) *DescribeArchiveInput {
	s.ArchiveName = &v
	return s
}

type DescribeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the archive.
	ArchiveArn *string `min:"1" type:"string"`

	// The name of the archive.
	ArchiveName *string `min:"1" type:"string"`

	// The time at which the archive was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the archive.
	Description *string `type:"string"`

	// The number of events in the archive.
	EventCount *int64 `type:"long"`

	// The event pattern used to filter events sent to the archive.
	EventPattern *string `type:"string"`

	// The ARN of the event source associated with the archive.
	EventSourceArn *string `min:"1" type:"string"`

	// The number of days to retain events for in the archive.
	RetentionDays *int64 `type:"integer"`

	// The size of the archive in bytes.
	SizeBytes *int64 `type:"long"`

	// The state of the archive.
	State *string `type:"string" enum:"ArchiveState"`

	// The reason that the archive is in the state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeArchiveOutput) GoString() string {
	return s.String()
}

// SetArchiveArn sets the ArchiveArn field's value.
func (s *DescribeArchiveOutput) SetArchiveArn(v string) *DescribeArchiveOutput {
	s.ArchiveArn = &v
	return s
}

// SetArchiveName sets the ArchiveName field's value.
func (s *DescribeArchiveOutput) SetArchiveName(v string) *DescribeArchiveOutput {
	s.ArchiveName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeArchiveOutput) SetCreationTime(v time.Time) *DescribeArchiveOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeArchiveOutput) SetDescription(v string) *DescribeArchiveOutput {
	s.Description = &v
	return s
}

// SetEventCount sets the EventCount field's value.
func (s *DescribeArchiveOutput) SetEventCount(v int64) *DescribeArchiveOutput {
	s.EventCount = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *DescribeArchiveOutput) SetEventPattern(v string) *DescribeArchiveOutput {
	s.EventPattern = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *DescribeArchiveOutput) SetEventSourceArn(v string) *DescribeArchiveOutput {
	s.EventSourceArn = &v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *DescribeArchiveOutput) SetRetentionDays(v int64) *DescribeArchiveOutput {
	s.RetentionDays = &v
	return s
}

// SetSizeBytes sets the SizeBytes field's value.
func (s *DescribeArchiveOutput) SetSizeBytes(v int64) *DescribeArchiveOutput {
	s.SizeBytes = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeArchiveOutput) SetState(v string) *DescribeArchiveOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *DescribeArchiveOutput) SetStateReason(v string) *DescribeArchiveOutput {
	s.StateReason = &v
	return s
}

type DescribeConnectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the connection to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeConnectionInput) SetName(v string) *DescribeConnectionInput {
	s.Name = &v
	return s
}

type DescribeConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The parameters to use for authorization for the connection.
	AuthParameters *ConnectionAuthResponseParameters `type:"structure"`

	// The type of authorization specified for the connection.
	AuthorizationType *string `type:"string" enum:"ConnectionAuthorizationType"`

	// The ARN of the connection retrieved.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection retrieved.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for the connection retrieved.
	Description *string `type:"string"`

	// A time stamp for the time that the connection was last authorized.
	LastAuthorizedTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the connection retrieved.
	Name *string `min:"1" type:"string"`

	// The ARN of the secret created from the authorization parameters specified
	// for the connection.
	SecretArn *string `min:"20" type:"string"`

	// The reason that the connection is in the current connection state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionOutput) GoString() string {
	return s.String()
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *DescribeConnectionOutput) SetAuthParameters(v *ConnectionAuthResponseParameters) *DescribeConnectionOutput {
	s.AuthParameters = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *DescribeConnectionOutput) SetAuthorizationType(v string) *DescribeConnectionOutput {
	s.AuthorizationType = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *DescribeConnectionOutput) SetConnectionArn(v string) *DescribeConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *DescribeConnectionOutput) SetConnectionState(v string) *DescribeConnectionOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeConnectionOutput) SetCreationTime(v time.Time) *DescribeConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeConnectionOutput) SetDescription(v string) *DescribeConnectionOutput {
	s.Description = &v
	return s
}

// SetLastAuthorizedTime sets the LastAuthorizedTime field's value.
func (s *DescribeConnectionOutput) SetLastAuthorizedTime(v time.Time) *DescribeConnectionOutput {
	s.LastAuthorizedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeConnectionOutput) SetLastModifiedTime(v time.Time) *DescribeConnectionOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeConnectionOutput) SetName(v string) *DescribeConnectionOutput {
	s.Name = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *DescribeConnectionOutput) SetSecretArn(v string) *DescribeConnectionOutput {
	s.SecretArn = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *DescribeConnectionOutput) SetStateReason(v string) *DescribeConnectionOutput {
	s.StateReason = &v
	return s
}

type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The primary Region of the endpoint you want to get information about. For
	// example "HomeRegion": "us-east-1".
	HomeRegion *string `min:"9" type:"string"`

	// The name of the endpoint you want to get information about. For example,
	// "Name":"us-east-2-custom_bus_A-endpoint".
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointInput"}
	if s.HomeRegion != nil && len(*s.HomeRegion) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("HomeRegion", 9))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *DescribeEndpointInput) SetHomeRegion(v string) *DescribeEndpointInput {
	s.HomeRegion = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeEndpointInput) SetName(v string) *DescribeEndpointInput {
	s.Name = &v
	return s
}

type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the endpoint you asked for information about.
	Arn *string `min:"1" type:"string"`

	// The time the endpoint you asked for information about was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the endpoint you asked for information about.
	Description *string `type:"string"`

	// The ID of the endpoint you asked for information about.
	EndpointId *string `min:"1" type:"string"`

	// The URL of the endpoint you asked for information about.
	EndpointUrl *string `min:"1" type:"string"`

	// The event buses being used by the endpoint you asked for information about.
	EventBuses []*EndpointEventBus `min:"2" type:"list"`

	// The last time the endpoint you asked for information about was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the endpoint you asked for information about.
	Name *string `min:"1" type:"string"`

	// Whether replication is enabled or disabled for the endpoint you asked for
	// information about.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used by the endpoint you asked for information about.
	RoleArn *string `min:"1" type:"string"`

	// The routing configuration of the endpoint you asked for information about.
	RoutingConfig *RoutingConfig `type:"structure"`

	// The current state of the endpoint you asked for information about.
	State *string `type:"string" enum:"EndpointState"`

	// The reason the endpoint you asked for information about is in its current
	// state.
	StateReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeEndpointOutput) SetArn(v string) *DescribeEndpointOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEndpointOutput) SetCreationTime(v time.Time) *DescribeEndpointOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeEndpointOutput) SetDescription(v string) *DescribeEndpointOutput {
	s.Description = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DescribeEndpointOutput) SetEndpointId(v string) *DescribeEndpointOutput {
	s.EndpointId = &v
	return s
}

// SetEndpointUrl sets the EndpointUrl field's value.
func (s *DescribeEndpointOutput) SetEndpointUrl(v string) *DescribeEndpointOutput {
	s.EndpointUrl = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *DescribeEndpointOutput) SetEventBuses(v []*EndpointEventBus) *DescribeEndpointOutput {
	s.EventBuses = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeEndpointOutput) SetLastModifiedTime(v time.Time) *DescribeEndpointOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeEndpointOutput) SetName(v string) *DescribeEndpointOutput {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *DescribeEndpointOutput) SetReplicationConfig(v *ReplicationConfig) *DescribeEndpointOutput {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeEndpointOutput) SetRoleArn(v string) *DescribeEndpointOutput {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *DescribeEndpointOutput) SetRoutingConfig(v *RoutingConfig) *DescribeEndpointOutput {
	s.RoutingConfig = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeEndpointOutput) SetState(v string) *DescribeEndpointOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *DescribeEndpointOutput) SetStateReason(v string) *DescribeEndpointOutput {
	s.StateReason = &v
	return s
}

type DescribeEventBusInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus to show details for. If you omit this, the
	// default event bus is displayed.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventBusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventBusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventBusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventBusInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeEventBusInput) SetName(v string) *DescribeEventBusInput {
	s.Name = &v
	return s
}

type DescribeEventBusOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account permitted to write events to
	// the current account.
	Arn *string `type:"string"`

	// The name of the event bus. Currently, this is always default.
	Name *string `type:"string"`

	// The policy that enables the external account to send events to your account.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventBusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventBusOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeEventBusOutput) SetArn(v string) *DescribeEventBusOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeEventBusOutput) SetName(v string) *DescribeEventBusOutput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribeEventBusOutput) SetPolicy(v string) *DescribeEventBusOutput {
	s.Policy = &v
	return s
}

type DescribeEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to display the details of.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeEventSourceInput) SetName(v string) *DescribeEventSourceInput {
	s.Name = &v
	return s
}

type DescribeEventSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the partner event source.
	Arn *string `type:"string"`

	// The name of the SaaS partner that created the event source.
	CreatedBy *string `type:"string"`

	// The date and time that the event source was created.
	CreationTime *time.Time `type:"timestamp"`

	// The date and time that the event source will expire if you do not create
	// a matching event bus.
	ExpirationTime *time.Time `type:"timestamp"`

	// The name of the partner event source.
	Name *string `type:"string"`

	// The state of the event source. If it is ACTIVE, you have already created
	// a matching event bus for this event source, and that event bus is active.
	// If it is PENDING, either you haven't yet created a matching event bus, or
	// that event bus is deactivated. If it is DELETED, you have created a matching
	// event bus, but the event source has since been deleted.
	State *string `type:"string" enum:"EventSourceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeEventSourceOutput) SetArn(v string) *DescribeEventSourceOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeEventSourceOutput) SetCreatedBy(v string) *DescribeEventSourceOutput {
	s.CreatedBy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeEventSourceOutput) SetCreationTime(v time.Time) *DescribeEventSourceOutput {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *DescribeEventSourceOutput) SetExpirationTime(v time.Time) *DescribeEventSourceOutput {
	s.ExpirationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeEventSourceOutput) SetName(v string) *DescribeEventSourceOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeEventSourceOutput) SetState(v string) *DescribeEventSourceOutput {
	s.State = &v
	return s
}

type DescribePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the event source to display.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePartnerEventSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePartnerEventSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePartnerEventSourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribePartnerEventSourceInput) SetName(v string) *DescribePartnerEventSourceInput {
	s.Name = &v
	return s
}

type DescribePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the event source.
	Arn *string `type:"string"`

	// The name of the event source.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePartnerEventSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribePartnerEventSourceOutput) SetArn(v string) *DescribePartnerEventSourceOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribePartnerEventSourceOutput) SetName(v string) *DescribePartnerEventSourceOutput {
	s.Name = &v
	return s
}

type DescribeReplayInput struct {
	_ struct{} `type:"structure"`

	// The name of the replay to retrieve.
	//
	// ReplayName is a required field
	ReplayName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplayInput"}
	if s.ReplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplayName"))
	}
	if s.ReplayName != nil && len(*s.ReplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplayName sets the ReplayName field's value.
func (s *DescribeReplayInput) SetReplayName(v string) *DescribeReplayInput {
	s.ReplayName = &v
	return s
}

type DescribeReplayOutput struct {
	_ struct{} `type:"structure"`

	// The description of the replay.
	Description *string `type:"string"`

	// A ReplayDestination object that contains details about the replay.
	Destination *ReplayDestination `type:"structure"`

	// The time stamp for the last event that was replayed from the archive.
	EventEndTime *time.Time `type:"timestamp"`

	// The time that the event was last replayed.
	EventLastReplayedTime *time.Time `type:"timestamp"`

	// The ARN of the archive events were replayed from.
	EventSourceArn *string `min:"1" type:"string"`

	// The time stamp of the first event that was last replayed from the archive.
	EventStartTime *time.Time `type:"timestamp"`

	// The ARN of the replay.
	ReplayArn *string `min:"1" type:"string"`

	// A time stamp for the time that the replay stopped.
	ReplayEndTime *time.Time `type:"timestamp"`

	// The name of the replay.
	ReplayName *string `min:"1" type:"string"`

	// A time stamp for the time that the replay started.
	ReplayStartTime *time.Time `type:"timestamp"`

	// The current state of the replay.
	State *string `type:"string" enum:"ReplayState"`

	// The reason that the replay is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplayOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeReplayOutput) SetDescription(v string) *DescribeReplayOutput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *DescribeReplayOutput) SetDestination(v *ReplayDestination) *DescribeReplayOutput {
	s.Destination = v
	return s
}

// SetEventEndTime sets the EventEndTime field's value.
func (s *DescribeReplayOutput) SetEventEndTime(v time.Time) *DescribeReplayOutput {
	s.EventEndTime = &v
	return s
}

// SetEventLastReplayedTime sets the EventLastReplayedTime field's value.
func (s *DescribeReplayOutput) SetEventLastReplayedTime(v time.Time) *DescribeReplayOutput {
	s.EventLastReplayedTime = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *DescribeReplayOutput) SetEventSourceArn(v string) *DescribeReplayOutput {
	s.EventSourceArn = &v
	return s
}

// SetEventStartTime sets the EventStartTime field's value.
func (s *DescribeReplayOutput) SetEventStartTime(v time.Time) *DescribeReplayOutput {
	s.EventStartTime = &v
	return s
}

// SetReplayArn sets the ReplayArn field's value.
func (s *DescribeReplayOutput) SetReplayArn(v string) *DescribeReplayOutput {
	s.ReplayArn = &v
	return s
}

// SetReplayEndTime sets the ReplayEndTime field's value.
func (s *DescribeReplayOutput) SetReplayEndTime(v time.Time) *DescribeReplayOutput {
	s.ReplayEndTime = &v
	return s
}

// SetReplayName sets the ReplayName field's value.
func (s *DescribeReplayOutput) SetReplayName(v string) *DescribeReplayOutput {
	s.ReplayName = &v
	return s
}

// SetReplayStartTime sets the ReplayStartTime field's value.
func (s *DescribeReplayOutput) SetReplayStartTime(v time.Time) *DescribeReplayOutput {
	s.ReplayStartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeReplayOutput) SetState(v string) *DescribeReplayOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *DescribeReplayOutput) SetStateReason(v string) *DescribeReplayOutput {
	s.StateReason = &v
	return s
}

type DescribeRuleInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *DescribeRuleInput) SetEventBusName(v string) *DescribeRuleInput {
	s.EventBusName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRuleInput) SetName(v string) *DescribeRuleInput {
	s.Name = &v
	return s
}

type DescribeRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The account ID of the user that created the rule. If you use PutRule to put
	// a rule on an event bus in another account, the other account is the owner
	// of the rule, and the rule ARN includes the account ID for that account. However,
	// the value for CreatedBy is the account ID as the account that created the
	// rule in the other account.
	CreatedBy *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The name of the event bus associated with the rule.
	EventBusName *string `min:"1" type:"string"`

	// The event pattern. For more information, see Events and Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	EventPattern *string `type:"string"`

	// If this is a managed rule, created by an Amazon Web Services service on your
	// behalf, this field displays the principal name of the Amazon Web Services
	// service that created the rule.
	ManagedBy *string `min:"1" type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Specifies whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRuleOutput) SetArn(v string) *DescribeRuleOutput {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeRuleOutput) SetCreatedBy(v string) *DescribeRuleOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRuleOutput) SetDescription(v string) *DescribeRuleOutput {
	s.Description = &v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *DescribeRuleOutput) SetEventBusName(v string) *DescribeRuleOutput {
	s.EventBusName = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *DescribeRuleOutput) SetEventPattern(v string) *DescribeRuleOutput {
	s.EventPattern = &v
	return s
}

// SetManagedBy sets the ManagedBy field's value.
func (s *DescribeRuleOutput) SetManagedBy(v string) *DescribeRuleOutput {
	s.ManagedBy = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRuleOutput) SetName(v string) *DescribeRuleOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeRuleOutput) SetRoleArn(v string) *DescribeRuleOutput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *DescribeRuleOutput) SetScheduleExpression(v string) *DescribeRuleOutput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeRuleOutput) SetState(v string) *DescribeRuleOutput {
	s.State = &v
	return s
}

type DisableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *DisableRuleInput) SetEventBusName(v string) *DisableRuleInput {
	s.EventBusName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DisableRuleInput) SetName(v string) *DisableRuleInput {
	s.Name = &v
	return s
}

type DisableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableRuleOutput) GoString() string {
	return s.String()
}

// The custom parameters to be used when the target is an Amazon ECS task.
type EcsParameters struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the task.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must
	// be omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `type:"list"`

	// Specifies whether to enable Amazon ECS managed tags for the task. For more
	// information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `type:"boolean"`

	// Whether or not to enable the execute command functionality for the containers
	// in this task. If true, this enables execute command functionality on all
	// containers in the task.
	EnableExecuteCommand *bool `type:"boolean"`

	// Specifies an ECS task group for the task. The maximum length is 255 characters.
	Group *string `type:"string"`

	// Specifies the launch type on which your task is running. The launch type
	// that you specify here must match one of the launch type (compatibilities)
	// of the target task. The FARGATE value is supported only in the Regions where
	// Fargate with Amazon ECS is supported. For more information, see Fargate on
	// Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `type:"string" enum:"LaunchType"`

	// Use this structure if the Amazon ECS task uses the awsvpc network mode. This
	// structure specifies the VPC subnets and security groups associated with the
	// task, and whether a public IP address is to be used. This structure is required
	// if LaunchType is FARGATE because the awsvpc mode is required for Fargate
	// tasks.
	//
	// If you specify NetworkConfiguration when the target ECS task does not use
	// the awsvpc network mode, the task fails.
	NetworkConfiguration *NetworkConfiguration `type:"structure"`

	// An array of placement constraint objects to use for the task. You can specify
	// up to 10 constraints per task (including constraints in the task definition
	// and those specified at runtime).
	PlacementConstraints []*PlacementConstraint `type:"list"`

	// The placement strategy objects to use for the task. You can specify a maximum
	// of five strategy rules per task.
	PlacementStrategy []*PlacementStrategy `type:"list"`

	// Specifies the platform version for the task. Specify only the numeric portion
	// of the platform version, such as 1.1.0.
	//
	// This structure is used only if LaunchType is FARGATE. For more information
	// about valid platform versions, see Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `type:"string"`

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags are not propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation,
	// use the TagResource API action.
	PropagateTags *string `type:"string" enum:"PropagateTags"`

	// The reference ID to use for the task.
	ReferenceId *string `type:"string"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. To learn more, see RunTask (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags)
	// in the Amazon ECS API Reference.
	Tags []*Tag `type:"list"`

	// The number of tasks to create based on TaskDefinition. The default is 1.
	TaskCount *int64 `min:"1" type:"integer"`

	// The ARN of the task definition to use if the event target is an Amazon ECS
	// task.
	//
	// TaskDefinitionArn is a required field
	TaskDefinitionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsParameters"}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TaskCount", 1))
	}
	if s.TaskDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinitionArn"))
	}
	if s.TaskDefinitionArn != nil && len(*s.TaskDefinitionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskDefinitionArn", 1))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *EcsParameters) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *EcsParameters {
	s.CapacityProviderStrategy = v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *EcsParameters) SetEnableECSManagedTags(v bool) *EcsParameters {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *EcsParameters) SetEnableExecuteCommand(v bool) *EcsParameters {
	s.EnableExecuteCommand = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *EcsParameters) SetGroup(v string) *EcsParameters {
	s.Group = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *EcsParameters) SetLaunchType(v string) *EcsParameters {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *EcsParameters) SetNetworkConfiguration(v *NetworkConfiguration) *EcsParameters {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *EcsParameters) SetPlacementConstraints(v []*PlacementConstraint) *EcsParameters {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *EcsParameters) SetPlacementStrategy(v []*PlacementStrategy) *EcsParameters {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EcsParameters) SetPlatformVersion(v string) *EcsParameters {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *EcsParameters) SetPropagateTags(v string) *EcsParameters {
	s.PropagateTags = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *EcsParameters) SetReferenceId(v string) *EcsParameters {
	s.ReferenceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EcsParameters) SetTags(v []*Tag) *EcsParameters {
	s.Tags = v
	return s
}

// SetTaskCount sets the TaskCount field's value.
func (s *EcsParameters) SetTaskCount(v int64) *EcsParameters {
	s.TaskCount = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *EcsParameters) SetTaskDefinitionArn(v string) *EcsParameters {
	s.TaskDefinitionArn = &v
	return s
}

type EnableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *EnableRuleInput) SetEventBusName(v string) *EnableRuleInput {
	s.EventBusName = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnableRuleInput) SetName(v string) *EnableRuleInput {
	s.Name = &v
	return s
}

type EnableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableRuleOutput) GoString() string {
	return s.String()
}

// A global endpoint used to improve your application's availability by making
// it regional-fault tolerant. For more information about global endpoints,
// see Making applications Regional-fault tolerant with global endpoints and
// event replication (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html)
// in the Amazon EventBridge User Guide.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The ARN of the endpoint.
	Arn *string `min:"1" type:"string"`

	// The time the endpoint was created.
	CreationTime *time.Time `type:"timestamp"`

	// A description for the endpoint.
	Description *string `type:"string"`

	// The URL subdomain of the endpoint. For example, if the URL for Endpoint is
	// https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
	EndpointId *string `min:"1" type:"string"`

	// The URL of the endpoint.
	EndpointUrl *string `min:"1" type:"string"`

	// The event buses being used by the endpoint.
	EventBuses []*EndpointEventBus `min:"2" type:"list"`

	// The last time the endpoint was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the endpoint.
	Name *string `min:"1" type:"string"`

	// Whether event replication was enabled or disabled for this endpoint. The
	// default state is ENABLED which means you must supply a RoleArn. If you don't
	// have a RoleArn or you don't want event replication enabled, set the state
	// to DISABLED.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used by event replication for the endpoint.
	RoleArn *string `min:"1" type:"string"`

	// The routing configuration of the endpoint.
	RoutingConfig *RoutingConfig `type:"structure"`

	// The current state of the endpoint.
	State *string `type:"string" enum:"EndpointState"`

	// The reason the endpoint is in its current state.
	StateReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Endpoint) SetArn(v string) *Endpoint {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Endpoint) SetCreationTime(v time.Time) *Endpoint {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Endpoint) SetDescription(v string) *Endpoint {
	s.Description = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *Endpoint) SetEndpointId(v string) *Endpoint {
	s.EndpointId = &v
	return s
}

// SetEndpointUrl sets the EndpointUrl field's value.
func (s *Endpoint) SetEndpointUrl(v string) *Endpoint {
	s.EndpointUrl = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *Endpoint) SetEventBuses(v []*EndpointEventBus) *Endpoint {
	s.EventBuses = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Endpoint) SetLastModifiedTime(v time.Time) *Endpoint {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Endpoint) SetName(v string) *Endpoint {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *Endpoint) SetReplicationConfig(v *ReplicationConfig) *Endpoint {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Endpoint) SetRoleArn(v string) *Endpoint {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *Endpoint) SetRoutingConfig(v *RoutingConfig) *Endpoint {
	s.RoutingConfig = v
	return s
}

// SetState sets the State field's value.
func (s *Endpoint) SetState(v string) *Endpoint {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Endpoint) SetStateReason(v string) *Endpoint {
	s.StateReason = &v
	return s
}

// The event buses the endpoint is associated with.
type EndpointEventBus struct {
	_ struct{} `type:"structure"`

	// The ARN of the event bus the endpoint is associated with.
	//
	// EventBusArn is a required field
	EventBusArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointEventBus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointEventBus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointEventBus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointEventBus"}
	if s.EventBusArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBusArn"))
	}
	if s.EventBusArn != nil && len(*s.EventBusArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusArn sets the EventBusArn field's value.
func (s *EndpointEventBus) SetEventBusArn(v string) *EndpointEventBus {
	s.EventBusArn = &v
	return s
}

// An event bus receives events from a source, uses rules to evaluate them,
// applies any configured input transformation, and routes them to the appropriate
// target(s). Your account's default event bus receives events from Amazon Web
// Services services. A custom event bus can receive events from your custom
// applications and services. A partner event bus receives events from an event
// source created by an SaaS partner. These events come from the partners services
// or applications.
type EventBus struct {
	_ struct{} `type:"structure"`

	// The ARN of the event bus.
	Arn *string `type:"string"`

	// The name of the event bus.
	Name *string `type:"string"`

	// The permissions policy of the event bus, describing which other Amazon Web
	// Services accounts can write events to this event bus.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBus) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventBus) SetArn(v string) *EventBus {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventBus) SetName(v string) *EventBus {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *EventBus) SetPolicy(v string) *EventBus {
	s.Policy = &v
	return s
}

// A partner event source is created by an SaaS partner. If a customer creates
// a partner event bus that matches this event source, that Amazon Web Services
// account can receive events from the partner's applications or services.
type EventSource struct {
	_ struct{} `type:"structure"`

	// The ARN of the event source.
	Arn *string `type:"string"`

	// The name of the partner that created the event source.
	CreatedBy *string `type:"string"`

	// The date and time the event source was created.
	CreationTime *time.Time `type:"timestamp"`

	// The date and time that the event source will expire, if the Amazon Web Services
	// account doesn't create a matching event bus for it.
	ExpirationTime *time.Time `type:"timestamp"`

	// The name of the event source.
	Name *string `type:"string"`

	// The state of the event source. If it is ACTIVE, you have already created
	// a matching event bus for this event source, and that event bus is active.
	// If it is PENDING, either you haven't yet created a matching event bus, or
	// that event bus is deactivated. If it is DELETED, you have created a matching
	// event bus, but the event source has since been deleted.
	State *string `type:"string" enum:"EventSourceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventSource) SetArn(v string) *EventSource {
	s.Arn = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *EventSource) SetCreatedBy(v string) *EventSource {
	s.CreatedBy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *EventSource) SetCreationTime(v time.Time) *EventSource {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *EventSource) SetExpirationTime(v time.Time) *EventSource {
	s.ExpirationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventSource) SetName(v string) *EventSource {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *EventSource) SetState(v string) *EventSource {
	s.State = &v
	return s
}

// The failover configuration for an endpoint. This includes what triggers failover
// and what happens when it's triggered.
type FailoverConfig struct {
	_ struct{} `type:"structure"`

	// The main Region of the endpoint.
	//
	// Primary is a required field
	Primary *Primary `type:"structure" required:"true"`

	// The Region that events are routed to when failover is triggered or event
	// replication is enabled.
	//
	// Secondary is a required field
	Secondary *Secondary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailoverConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailoverConfig"}
	if s.Primary == nil {
		invalidParams.Add(request.NewErrParamRequired("Primary"))
	}
	if s.Secondary == nil {
		invalidParams.Add(request.NewErrParamRequired("Secondary"))
	}
	if s.Primary != nil {
		if err := s.Primary.Validate(); err != nil {
			invalidParams.AddNested("Primary", err.(request.ErrInvalidParams))
		}
	}
	if s.Secondary != nil {
		if err := s.Secondary.Validate(); err != nil {
			invalidParams.AddNested("Secondary", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimary sets the Primary field's value.
func (s *FailoverConfig) SetPrimary(v *Primary) *FailoverConfig {
	s.Primary = v
	return s
}

// SetSecondary sets the Secondary field's value.
func (s *FailoverConfig) SetSecondary(v *Secondary) *FailoverConfig {
	s.Secondary = v
	return s
}

// These are custom parameter to be used when the target is an API Gateway APIs
// or EventBridge ApiDestinations. In the latter case, these are merged with
// any InvocationParameters specified on the Connection, with any values from
// the Connection taking precedence.
type HttpParameters struct {
	_ struct{} `type:"structure"`

	// The headers that need to be sent as part of request invoking the API Gateway
	// API or EventBridge ApiDestination.
	HeaderParameters map[string]*string `type:"map"`

	// The path parameter values to be used to populate API Gateway API or EventBridge
	// ApiDestination path wildcards ("*").
	PathParameterValues []*string `type:"list"`

	// The query string keys/values that need to be sent as part of request invoking
	// the API Gateway API or EventBridge ApiDestination.
	QueryStringParameters map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpParameters) GoString() string {
	return s.String()
}

// SetHeaderParameters sets the HeaderParameters field's value.
func (s *HttpParameters) SetHeaderParameters(v map[string]*string) *HttpParameters {
	s.HeaderParameters = v
	return s
}

// SetPathParameterValues sets the PathParameterValues field's value.
func (s *HttpParameters) SetPathParameterValues(v []*string) *HttpParameters {
	s.PathParameterValues = v
	return s
}

// SetQueryStringParameters sets the QueryStringParameters field's value.
func (s *HttpParameters) SetQueryStringParameters(v map[string]*string) *HttpParameters {
	s.QueryStringParameters = v
	return s
}

// An error occurred because a replay can be canceled only when the state is
// Running or Starting.
type IllegalStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IllegalStatusException) GoString() string {
	return s.String()
}

func newErrorIllegalStatusException(v protocol.ResponseMetadata) error {
	return &IllegalStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IllegalStatusException) Code() string {
	return "IllegalStatusException"
}

// Message returns the exception's message.
func (s *IllegalStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IllegalStatusException) OrigErr() error {
	return nil
}

func (s *IllegalStatusException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IllegalStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IllegalStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the parameters needed for you to provide custom input to a target
// based on one or more pieces of data extracted from the event.
type InputTransformer struct {
	_ struct{} `type:"structure"`

	// Map of JSON paths to be extracted from the event. You can then insert these
	// in the template in InputTemplate to produce the output you want to be sent
	// to the target.
	//
	// InputPathsMap is an array key-value pairs, where each value is a valid JSON
	// path. You can have as many as 100 key-value pairs. You must use JSON dot
	// notation, not bracket notation.
	//
	// The keys cannot start with "Amazon Web Services."
	InputPathsMap map[string]*string `type:"map"`

	// Input template where you specify placeholders that will be filled with the
	// values of the keys from InputPathsMap to customize the data sent to the target.
	// Enclose each InputPathsMaps value in brackets: <value>
	//
	// If InputTemplate is a JSON object (surrounded by curly braces), the following
	// restrictions apply:
	//
	//    * The placeholder cannot be used as an object key.
	//
	// The following example shows the syntax for using InputPathsMap and InputTemplate.
	//
	// "InputTransformer":
	//
	// {
	//
	// "InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},
	//
	// "InputTemplate": "<instance> is in state <status>"
	//
	// }
	//
	// To have the InputTemplate include quote marks within a JSON string, escape
	// each quote marks with a slash, as in the following example:
	//
	// "InputTransformer":
	//
	// {
	//
	// "InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},
	//
	// "InputTemplate": "<instance> is in state \"<status>\""
	//
	// }
	//
	// The InputTemplate can also be valid JSON with varibles in quotes or out,
	// as in the following example:
	//
	// "InputTransformer":
	//
	// {
	//
	// "InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},
	//
	// "InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in
	// state \"<status>\""}'
	//
	// }
	//
	// InputTemplate is a required field
	InputTemplate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputTransformer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputTransformer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputTransformer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputTransformer"}
	if s.InputTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("InputTemplate"))
	}
	if s.InputTemplate != nil && len(*s.InputTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputPathsMap sets the InputPathsMap field's value.
func (s *InputTransformer) SetInputPathsMap(v map[string]*string) *InputTransformer {
	s.InputPathsMap = v
	return s
}

// SetInputTemplate sets the InputTemplate field's value.
func (s *InputTransformer) SetInputTemplate(v string) *InputTransformer {
	s.InputTemplate = &v
	return s
}

// This exception occurs due to unexpected causes.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The event pattern is not valid.
type InvalidEventPatternException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventPatternException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEventPatternException) GoString() string {
	return s.String()
}

func newErrorInvalidEventPatternException(v protocol.ResponseMetadata) error {
	return &InvalidEventPatternException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEventPatternException) Code() string {
	return "InvalidEventPatternException"
}

// Message returns the exception's message.
func (s *InvalidEventPatternException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEventPatternException) OrigErr() error {
	return nil
}

func (s *InvalidEventPatternException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEventPatternException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEventPatternException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified state is not a valid state for an event source.
type InvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateException) Code() string {
	return "InvalidStateException"
}

// Message returns the exception's message.
func (s *InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateException) OrigErr() error {
	return nil
}

func (s *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This object enables you to specify a JSON path to extract from the event
// and use as the partition key for the Amazon Kinesis data stream, so that
// you can control the shard to which the event goes. If you do not include
// this parameter, the default is to use the eventId as the partition key.
type KinesisParameters struct {
	_ struct{} `type:"structure"`

	// The JSON path to be extracted from the event and used as the partition key.
	// For more information, see Amazon Kinesis Streams Key Concepts (https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// PartitionKeyPath is a required field
	PartitionKeyPath *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisParameters"}
	if s.PartitionKeyPath == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKeyPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKeyPath sets the PartitionKeyPath field's value.
func (s *KinesisParameters) SetPartitionKeyPath(v string) *KinesisParameters {
	s.PartitionKeyPath = &v
	return s
}

// The request failed because it attempted to create resource beyond the allowed
// service quota.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApiDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection specified for the API destination.
	ConnectionArn *string `min:"1" type:"string"`

	// The maximum number of API destinations to include in the response.
	Limit *int64 `min:"1" type:"integer"`

	// A name prefix to filter results returned. Only API destinations with a name
	// that starts with the prefix are returned.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApiDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApiDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApiDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApiDestinationsInput"}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *ListApiDestinationsInput) SetConnectionArn(v string) *ListApiDestinationsInput {
	s.ConnectionArn = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListApiDestinationsInput) SetLimit(v int64) *ListApiDestinationsInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListApiDestinationsInput) SetNamePrefix(v string) *ListApiDestinationsInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApiDestinationsInput) SetNextToken(v string) *ListApiDestinationsInput {
	s.NextToken = &v
	return s
}

type ListApiDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ApiDestination objects that include information about an API
	// destination.
	ApiDestinations []*ApiDestination `type:"list"`

	// A token you can use in a subsequent request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApiDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApiDestinationsOutput) GoString() string {
	return s.String()
}

// SetApiDestinations sets the ApiDestinations field's value.
func (s *ListApiDestinationsOutput) SetApiDestinations(v []*ApiDestination) *ListApiDestinationsOutput {
	s.ApiDestinations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApiDestinationsOutput) SetNextToken(v string) *ListApiDestinationsOutput {
	s.NextToken = &v
	return s
}

type ListArchivesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the event source associated with the archive.
	EventSourceArn *string `min:"1" type:"string"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// A name prefix to filter the archives returned. Only archives with name that
	// match the prefix are returned.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The state of the archive.
	State *string `type:"string" enum:"ArchiveState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArchivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArchivesInput"}
	if s.EventSourceArn != nil && len(*s.EventSourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceArn", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *ListArchivesInput) SetEventSourceArn(v string) *ListArchivesInput {
	s.EventSourceArn = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListArchivesInput) SetLimit(v int64) *ListArchivesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListArchivesInput) SetNamePrefix(v string) *ListArchivesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchivesInput) SetNextToken(v string) *ListArchivesInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListArchivesInput) SetState(v string) *ListArchivesInput {
	s.State = &v
	return s
}

type ListArchivesOutput struct {
	_ struct{} `type:"structure"`

	// An array of Archive objects that include details about an archive.
	Archives []*Archive `type:"list"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListArchivesOutput) GoString() string {
	return s.String()
}

// SetArchives sets the Archives field's value.
func (s *ListArchivesOutput) SetArchives(v []*Archive) *ListArchivesOutput {
	s.Archives = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArchivesOutput) SetNextToken(v string) *ListArchivesOutput {
	s.NextToken = &v
	return s
}

type ListConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The state of the connection.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The maximum number of connections to return.
	Limit *int64 `min:"1" type:"integer"`

	// A name prefix to filter results returned. Only connections with a name that
	// starts with the prefix are returned.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionState sets the ConnectionState field's value.
func (s *ListConnectionsInput) SetConnectionState(v string) *ListConnectionsInput {
	s.ConnectionState = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListConnectionsInput) SetLimit(v int64) *ListConnectionsInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListConnectionsInput) SetNamePrefix(v string) *ListConnectionsInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsInput) SetNextToken(v string) *ListConnectionsInput {
	s.NextToken = &v
	return s
}

type ListConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of connections objects that include details about the connections.
	Connections []*Connection `type:"list"`

	// A token you can use in a subsequent request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *ListConnectionsOutput) SetConnections(v []*Connection) *ListConnectionsOutput {
	s.Connections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectionsOutput) SetNextToken(v string) *ListConnectionsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The primary Region of the endpoints associated with this account. For example
	// "HomeRegion": "us-east-1".
	HomeRegion *string `min:"9" type:"string"`

	// The maximum number of results returned by the call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A value that will return a subset of the endpoints associated with this account.
	// For example, "NamePrefix": "ABC" will return all endpoints with "ABC" in
	// the name.
	NamePrefix *string `min:"1" type:"string"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.HomeRegion != nil && len(*s.HomeRegion) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("HomeRegion", 9))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *ListEndpointsInput) SetHomeRegion(v string) *ListEndpointsInput {
	s.HomeRegion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListEndpointsInput) SetNamePrefix(v string) *ListEndpointsInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The endpoints returned by the call.
	Endpoints []*Endpoint `type:"list"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointsOutput) SetEndpoints(v []*Endpoint) *ListEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListEventBusesInput struct {
	_ struct{} `type:"structure"`

	// Specifying this limits the number of results returned by this operation.
	// The operation also returns a NextToken which you can use in a subsequent
	// operation to retrieve the next set of results.
	Limit *int64 `min:"1" type:"integer"`

	// Specifying this limits the results to only those event buses with names that
	// start with the specified prefix.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventBusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventBusesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventBusesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventBusesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListEventBusesInput) SetLimit(v int64) *ListEventBusesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListEventBusesInput) SetNamePrefix(v string) *ListEventBusesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventBusesInput) SetNextToken(v string) *ListEventBusesInput {
	s.NextToken = &v
	return s
}

type ListEventBusesOutput struct {
	_ struct{} `type:"structure"`

	// This list of event buses.
	EventBuses []*EventBus `type:"list"`

	// A token you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventBusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventBusesOutput) GoString() string {
	return s.String()
}

// SetEventBuses sets the EventBuses field's value.
func (s *ListEventBusesOutput) SetEventBuses(v []*EventBus) *ListEventBusesOutput {
	s.EventBuses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventBusesOutput) SetNextToken(v string) *ListEventBusesOutput {
	s.NextToken = &v
	return s
}

type ListEventSourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifying this limits the number of results returned by this operation.
	// The operation also returns a NextToken which you can use in a subsequent
	// operation to retrieve the next set of results.
	Limit *int64 `min:"1" type:"integer"`

	// Specifying this limits the results to only those partner event sources with
	// names that start with the specified prefix.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventSourcesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListEventSourcesInput) SetLimit(v int64) *ListEventSourcesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListEventSourcesInput) SetNamePrefix(v string) *ListEventSourcesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventSourcesInput) SetNextToken(v string) *ListEventSourcesInput {
	s.NextToken = &v
	return s
}

type ListEventSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The list of event sources.
	EventSources []*EventSource `type:"list"`

	// A token you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventSourcesOutput) GoString() string {
	return s.String()
}

// SetEventSources sets the EventSources field's value.
func (s *ListEventSourcesOutput) SetEventSources(v []*EventSource) *ListEventSourcesOutput {
	s.EventSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventSourcesOutput) SetNextToken(v string) *ListEventSourcesOutput {
	s.NextToken = &v
	return s
}

type ListPartnerEventSourceAccountsInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to display account information about.
	//
	// EventSourceName is a required field
	EventSourceName *string `min:"1" type:"string" required:"true"`

	// Specifying this limits the number of results returned by this operation.
	// The operation also returns a NextToken which you can use in a subsequent
	// operation to retrieve the next set of results.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to this operation. Specifying this
	// retrieves the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourceAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourceAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartnerEventSourceAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartnerEventSourceAccountsInput"}
	if s.EventSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceName"))
	}
	if s.EventSourceName != nil && len(*s.EventSourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceName sets the EventSourceName field's value.
func (s *ListPartnerEventSourceAccountsInput) SetEventSourceName(v string) *ListPartnerEventSourceAccountsInput {
	s.EventSourceName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListPartnerEventSourceAccountsInput) SetLimit(v int64) *ListPartnerEventSourceAccountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerEventSourceAccountsInput) SetNextToken(v string) *ListPartnerEventSourceAccountsInput {
	s.NextToken = &v
	return s
}

type ListPartnerEventSourceAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A token you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// The list of partner event sources returned by the operation.
	PartnerEventSourceAccounts []*PartnerEventSourceAccount `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourceAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourceAccountsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerEventSourceAccountsOutput) SetNextToken(v string) *ListPartnerEventSourceAccountsOutput {
	s.NextToken = &v
	return s
}

// SetPartnerEventSourceAccounts sets the PartnerEventSourceAccounts field's value.
func (s *ListPartnerEventSourceAccountsOutput) SetPartnerEventSourceAccounts(v []*PartnerEventSourceAccount) *ListPartnerEventSourceAccountsOutput {
	s.PartnerEventSourceAccounts = v
	return s
}

type ListPartnerEventSourcesInput struct {
	_ struct{} `type:"structure"`

	// pecifying this limits the number of results returned by this operation. The
	// operation also returns a NextToken which you can use in a subsequent operation
	// to retrieve the next set of results.
	Limit *int64 `min:"1" type:"integer"`

	// If you specify this, the results are limited to only those partner event
	// sources that start with the string you specify.
	//
	// NamePrefix is a required field
	NamePrefix *string `min:"1" type:"string" required:"true"`

	// The token returned by a previous call to this operation. Specifying this
	// retrieves the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartnerEventSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartnerEventSourcesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("NamePrefix"))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListPartnerEventSourcesInput) SetLimit(v int64) *ListPartnerEventSourcesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListPartnerEventSourcesInput) SetNamePrefix(v string) *ListPartnerEventSourcesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerEventSourcesInput) SetNextToken(v string) *ListPartnerEventSourcesInput {
	s.NextToken = &v
	return s
}

type ListPartnerEventSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A token you can use in a subsequent operation to retrieve the next set of
	// results.
	NextToken *string `min:"1" type:"string"`

	// The list of partner event sources returned by the operation.
	PartnerEventSources []*PartnerEventSource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPartnerEventSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPartnerEventSourcesOutput) SetNextToken(v string) *ListPartnerEventSourcesOutput {
	s.NextToken = &v
	return s
}

// SetPartnerEventSources sets the PartnerEventSources field's value.
func (s *ListPartnerEventSourcesOutput) SetPartnerEventSources(v []*PartnerEventSource) *ListPartnerEventSourcesOutput {
	s.PartnerEventSources = v
	return s
}

type ListReplaysInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the archive from which the events are replayed.
	EventSourceArn *string `min:"1" type:"string"`

	// The maximum number of replays to retrieve.
	Limit *int64 `min:"1" type:"integer"`

	// A name prefix to filter the replays returned. Only replays with name that
	// match the prefix are returned.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The state of the replay.
	State *string `type:"string" enum:"ReplayState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReplaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReplaysInput"}
	if s.EventSourceArn != nil && len(*s.EventSourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceArn", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *ListReplaysInput) SetEventSourceArn(v string) *ListReplaysInput {
	s.EventSourceArn = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListReplaysInput) SetLimit(v int64) *ListReplaysInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListReplaysInput) SetNamePrefix(v string) *ListReplaysInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplaysInput) SetNextToken(v string) *ListReplaysInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListReplaysInput) SetState(v string) *ListReplaysInput {
	s.State = &v
	return s
}

type ListReplaysOutput struct {
	_ struct{} `type:"structure"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// An array of Replay objects that contain information about the replay.
	Replays []*Replay `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplaysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplaysOutput) SetNextToken(v string) *ListReplaysOutput {
	s.NextToken = &v
	return s
}

// SetReplays sets the Replays field's value.
func (s *ListReplaysOutput) SetReplays(v []*Replay) *ListReplaysOutput {
	s.Replays = v
	return s
}

type ListRuleNamesByTargetInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus to list rules for. If you omit this, the
	// default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target resource.
	//
	// TargetArn is a required field
	TargetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleNamesByTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleNamesByTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleNamesByTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleNamesByTargetInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *ListRuleNamesByTargetInput) SetEventBusName(v string) *ListRuleNamesByTargetInput {
	s.EventBusName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListRuleNamesByTargetInput) SetLimit(v int64) *ListRuleNamesByTargetInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetInput) SetNextToken(v string) *ListRuleNamesByTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListRuleNamesByTargetInput) SetTargetArn(v string) *ListRuleNamesByTargetInput {
	s.TargetArn = &v
	return s
}

type ListRuleNamesByTargetOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The names of the rules that can invoke the given target.
	RuleNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleNamesByTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleNamesByTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetOutput) SetNextToken(v string) *ListRuleNamesByTargetOutput {
	s.NextToken = &v
	return s
}

// SetRuleNames sets the RuleNames field's value.
func (s *ListRuleNamesByTargetOutput) SetRuleNames(v []*string) *ListRuleNamesByTargetOutput {
	s.RuleNames = v
	return s
}

type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus to list the rules for. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The prefix matching the rule name.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *ListRulesInput) SetEventBusName(v string) *ListRulesInput {
	s.EventBusName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListRulesInput) SetLimit(v int64) *ListRulesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListRulesInput) SetNamePrefix(v string) *ListRulesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The rules that match the specified criteria.
	Rules []*Rule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*Rule) *ListRulesOutput {
	s.Rules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the EventBridge resource for which you want to view tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tag keys and values associated with the resource you specified
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetsByRuleInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsByRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsByRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsByRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsByRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *ListTargetsByRuleInput) SetEventBusName(v string) *ListTargetsByRuleInput {
	s.EventBusName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsByRuleInput) SetLimit(v int64) *ListTargetsByRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleInput) SetNextToken(v string) *ListTargetsByRuleInput {
	s.NextToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *ListTargetsByRuleInput) SetRule(v string) *ListTargetsByRuleInput {
	s.Rule = &v
	return s
}

type ListTargetsByRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The targets assigned to the rule.
	Targets []*Target `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsByRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetsByRuleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleOutput) SetNextToken(v string) *ListTargetsByRuleOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsByRuleOutput) SetTargets(v []*Target) *ListTargetsByRuleOutput {
	s.Targets = v
	return s
}

// This rule was created by an Amazon Web Services service on behalf of your
// account. It is managed by that service. If you see this error in response
// to DeleteRule or RemoveTargets, you can use the Force parameter in those
// calls to delete the rule or remove targets from the rule. You cannot modify
// these managed rules by using DisableRule, EnableRule, PutTargets, PutRule,
// TagResource, or UntagResource.
type ManagedRuleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManagedRuleException) GoString() string {
	return s.String()
}

func newErrorManagedRuleException(v protocol.ResponseMetadata) error {
	return &ManagedRuleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ManagedRuleException) Code() string {
	return "ManagedRuleException"
}

// Message returns the exception's message.
func (s *ManagedRuleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ManagedRuleException) OrigErr() error {
	return nil
}

func (s *ManagedRuleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ManagedRuleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ManagedRuleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This structure specifies the network configuration for an ECS task.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Use this structure to specify the VPC subnets and security groups for the
	// task, and whether a public IP address is to be used. This structure is relevant
	// only for ECS tasks that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsvpcConfiguration sets the AwsvpcConfiguration field's value.
func (s *NetworkConfiguration) SetAwsvpcConfiguration(v *AwsVpcConfiguration) *NetworkConfiguration {
	s.AwsvpcConfiguration = v
	return s
}

// The operation you are attempting is not available in this region.
type OperationDisabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationDisabledException) GoString() string {
	return s.String()
}

func newErrorOperationDisabledException(v protocol.ResponseMetadata) error {
	return &OperationDisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationDisabledException) Code() string {
	return "OperationDisabledException"
}

// Message returns the exception's message.
func (s *OperationDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationDisabledException) OrigErr() error {
	return nil
}

func (s *OperationDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationDisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationDisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A partner event source is created by an SaaS partner. If a customer creates
// a partner event bus that matches this event source, that Amazon Web Services
// account can receive events from the partner's applications or services.
type PartnerEventSource struct {
	_ struct{} `type:"structure"`

	// The ARN of the partner event source.
	Arn *string `type:"string"`

	// The name of the partner event source.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnerEventSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnerEventSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PartnerEventSource) SetArn(v string) *PartnerEventSource {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PartnerEventSource) SetName(v string) *PartnerEventSource {
	s.Name = &v
	return s
}

// The Amazon Web Services account that a partner event source has been offered
// to.
type PartnerEventSourceAccount struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that the partner event source was offered
	// to.
	Account *string `min:"12" type:"string"`

	// The date and time the event source was created.
	CreationTime *time.Time `type:"timestamp"`

	// The date and time that the event source will expire, if the Amazon Web Services
	// account doesn't create a matching event bus for it.
	ExpirationTime *time.Time `type:"timestamp"`

	// The state of the event source. If it is ACTIVE, you have already created
	// a matching event bus for this event source, and that event bus is active.
	// If it is PENDING, either you haven't yet created a matching event bus, or
	// that event bus is deactivated. If it is DELETED, you have created a matching
	// event bus, but the event source has since been deleted.
	State *string `type:"string" enum:"EventSourceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnerEventSourceAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartnerEventSourceAccount) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *PartnerEventSourceAccount) SetAccount(v string) *PartnerEventSourceAccount {
	s.Account = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *PartnerEventSourceAccount) SetCreationTime(v time.Time) *PartnerEventSourceAccount {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *PartnerEventSourceAccount) SetExpirationTime(v time.Time) *PartnerEventSourceAccount {
	s.ExpirationTime = &v
	return s
}

// SetState sets the State field's value.
func (s *PartnerEventSourceAccount) SetState(v string) *PartnerEventSourceAccount {
	s.State = &v
	return s
}

// An object representing a constraint on task placement. To learn more, see
// Task Placement Constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
type PlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance. To learn
	// more, see Cluster Query Language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. Use distinctInstance to ensure that each task in
	// a particular group is running on a different container instance. Use memberOf
	// to restrict the selection to a group of valid candidates.
	Type *string `locationName:"type" type:"string" enum:"PlacementConstraintType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *PlacementConstraint) SetExpression(v string) *PlacementConstraint {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementConstraint) SetType(v string) *PlacementConstraint {
	s.Type = &v
	return s
}

// The task placement strategy for a task or service. To learn more, see Task
// Placement Strategies (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html)
// in the Amazon Elastic Container Service Service Developer Guide.
type PlacementStrategy struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect),
	// or any platform or custom attribute that is applied to a container instance,
	// such as attribute:ecs.availability-zone. For the binpack placement strategy,
	// valid values are cpu and memory. For the random placement strategy, this
	// field is not used.
	Field *string `locationName:"field" type:"string"`

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least
	// amount of remaining memory (but still enough to run the task).
	Type *string `locationName:"type" type:"string" enum:"PlacementStrategyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *PlacementStrategy) SetField(v string) *PlacementStrategy {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementStrategy) SetType(v string) *PlacementStrategy {
	s.Type = &v
	return s
}

// The event bus policy is too long. For more information, see the limits.
type PolicyLengthExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyLengthExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyLengthExceededException) GoString() string {
	return s.String()
}

func newErrorPolicyLengthExceededException(v protocol.ResponseMetadata) error {
	return &PolicyLengthExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyLengthExceededException) Code() string {
	return "PolicyLengthExceededException"
}

// Message returns the exception's message.
func (s *PolicyLengthExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyLengthExceededException) OrigErr() error {
	return nil
}

func (s *PolicyLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyLengthExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyLengthExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The primary Region of the endpoint.
type Primary struct {
	_ struct{} `type:"structure"`

	// The ARN of the health check used by the endpoint to determine whether failover
	// is triggered.
	//
	// HealthCheck is a required field
	HealthCheck *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Primary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Primary) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Primary) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Primary"}
	if s.HealthCheck == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthCheck"))
	}
	if s.HealthCheck != nil && len(*s.HealthCheck) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheck", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *Primary) SetHealthCheck(v string) *Primary {
	s.HealthCheck = &v
	return s
}

type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The URL subdomain of the endpoint. For example, if the URL for Endpoint is
	// https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
	//
	// When using Java, you must include auth-crt on the class path.
	//
	// This AWS SDK does not support calling multi-region endpoints with SigV4a authentication.
	EndpointId *string `min:"1" type:"string"`

	// The entry that defines an event in your system. You can specify several parameters
	// for the entry such as the source and type of the event, resources associated
	// with the event, and so on.
	//
	// Entries is a required field
	Entries []*PutEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointId sets the EndpointId field's value.
func (s *PutEventsInput) SetEndpointId(v string) *PutEventsInput {
	s.EndpointId = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *PutEventsInput) SetEntries(v []*PutEventsRequestEntry) *PutEventsInput {
	s.Entries = v
	return s
}

type PutEventsOutput struct {
	_ struct{} `type:"structure"`

	// The successfully and unsuccessfully ingested events results. If the ingestion
	// was successful, the entry has the event ID in it. Otherwise, you can use
	// the error code and error message to identify the problem with the entry.
	//
	// For each record, the index of the response element is the same as the index
	// in the request array.
	Entries []*PutEventsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *PutEventsOutput) SetEntries(v []*PutEventsResultEntry) *PutEventsOutput {
	s.Entries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutEventsOutput) SetFailedEntryCount(v int64) *PutEventsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents an event to be submitted.
type PutEventsRequestEntry struct {
	_ struct{} `type:"structure"`

	// A valid JSON object. There is no other schema imposed. The JSON object may
	// contain fields and nested subobjects.
	Detail *string `type:"string"`

	// Free-form string, with a maximum of 128 characters, used to decide what fields
	// to expect in the event detail.
	DetailType *string `type:"string"`

	// The name or ARN of the event bus to receive the event. Only the rules that
	// are associated with this event bus are used to match the event. If you omit
	// this, the default event bus is used.
	//
	// If you're using a global endpoint with a custom bus, you must enter the name,
	// not the ARN, of the event bus in either the primary or secondary Region here
	// and the corresponding event bus in the other Region will be determined based
	// on the endpoint referenced by the EndpointId.
	EventBusName *string `min:"1" type:"string"`

	// Amazon Web Services resources, identified by Amazon Resource Name (ARN),
	// which the event primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The source of the event.
	Source *string `type:"string"`

	// The time stamp of the event, per RFC3339 (https://www.rfc-editor.org/rfc/rfc3339.txt).
	// If no time stamp is provided, the time stamp of the PutEvents (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
	// call is used.
	Time *time.Time `type:"timestamp"`

	// An X-Ray trace header, which is an http header (X-Amzn-Trace-Id) that contains
	// the trace-id associated with the event.
	//
	// To learn more about X-Ray trace headers, see Tracing header (https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader)
	// in the X-Ray Developer Guide.
	TraceHeader *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsRequestEntry"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.TraceHeader != nil && len(*s.TraceHeader) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TraceHeader", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetail sets the Detail field's value.
func (s *PutEventsRequestEntry) SetDetail(v string) *PutEventsRequestEntry {
	s.Detail = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *PutEventsRequestEntry) SetDetailType(v string) *PutEventsRequestEntry {
	s.DetailType = &v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *PutEventsRequestEntry) SetEventBusName(v string) *PutEventsRequestEntry {
	s.EventBusName = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PutEventsRequestEntry) SetResources(v []*string) *PutEventsRequestEntry {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PutEventsRequestEntry) SetSource(v string) *PutEventsRequestEntry {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutEventsRequestEntry) SetTime(v time.Time) *PutEventsRequestEntry {
	s.Time = &v
	return s
}

// SetTraceHeader sets the TraceHeader field's value.
func (s *PutEventsRequestEntry) SetTraceHeader(v string) *PutEventsRequestEntry {
	s.TraceHeader = &v
	return s
}

// Represents an event that failed to be submitted. For information about the
// errors that are common to all actions, see Common Errors (https://docs.aws.amazon.com/eventbridge/latest/APIReference/CommonErrors.html).
type PutEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the event submission failed.
	ErrorCode *string `type:"string"`

	// The error message that explains why the event submission failed.
	ErrorMessage *string `type:"string"`

	// The ID of the event.
	EventId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutEventsResultEntry) SetErrorCode(v string) *PutEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutEventsResultEntry) SetErrorMessage(v string) *PutEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutEventsResultEntry) SetEventId(v string) *PutEventsResultEntry {
	s.EventId = &v
	return s
}

type PutPartnerEventsInput struct {
	_ struct{} `type:"structure"`

	// The list of events to write to the event bus.
	//
	// Entries is a required field
	Entries []*PutPartnerEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPartnerEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPartnerEventsInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *PutPartnerEventsInput) SetEntries(v []*PutPartnerEventsRequestEntry) *PutPartnerEventsInput {
	s.Entries = v
	return s
}

type PutPartnerEventsOutput struct {
	_ struct{} `type:"structure"`

	// The list of events from this operation that were successfully written to
	// the partner event bus.
	Entries []*PutPartnerEventsResultEntry `type:"list"`

	// The number of events from this operation that could not be written to the
	// partner event bus.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *PutPartnerEventsOutput) SetEntries(v []*PutPartnerEventsResultEntry) *PutPartnerEventsOutput {
	s.Entries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutPartnerEventsOutput) SetFailedEntryCount(v int64) *PutPartnerEventsOutput {
	s.FailedEntryCount = &v
	return s
}

// The details about an event generated by an SaaS partner.
type PutPartnerEventsRequestEntry struct {
	_ struct{} `type:"structure"`

	// A valid JSON string. There is no other schema imposed. The JSON string may
	// contain fields and nested subobjects.
	Detail *string `type:"string"`

	// A free-form string, with a maximum of 128 characters, used to decide what
	// fields to expect in the event detail.
	DetailType *string `type:"string"`

	// Amazon Web Services resources, identified by Amazon Resource Name (ARN),
	// which the event primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The event source that is generating the entry.
	Source *string `min:"1" type:"string"`

	// The date and time of the event.
	Time *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPartnerEventsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPartnerEventsRequestEntry"}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetail sets the Detail field's value.
func (s *PutPartnerEventsRequestEntry) SetDetail(v string) *PutPartnerEventsRequestEntry {
	s.Detail = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *PutPartnerEventsRequestEntry) SetDetailType(v string) *PutPartnerEventsRequestEntry {
	s.DetailType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PutPartnerEventsRequestEntry) SetResources(v []*string) *PutPartnerEventsRequestEntry {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PutPartnerEventsRequestEntry) SetSource(v string) *PutPartnerEventsRequestEntry {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutPartnerEventsRequestEntry) SetTime(v time.Time) *PutPartnerEventsRequestEntry {
	s.Time = &v
	return s
}

// Represents an event that a partner tried to generate, but failed.
type PutPartnerEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the event submission failed.
	ErrorCode *string `type:"string"`

	// The error message that explains why the event submission failed.
	ErrorMessage *string `type:"string"`

	// The ID of the event.
	EventId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPartnerEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutPartnerEventsResultEntry) SetErrorCode(v string) *PutPartnerEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutPartnerEventsResultEntry) SetErrorMessage(v string) *PutPartnerEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutPartnerEventsResultEntry) SetEventId(v string) *PutPartnerEventsResultEntry {
	s.EventId = &v
	return s
}

type PutPermissionInput struct {
	_ struct{} `type:"structure"`

	// The action that you are enabling the other account to perform.
	Action *string `min:"1" type:"string"`

	// This parameter enables you to limit the permission to accounts that fulfill
	// a certain condition, such as being a member of a certain Amazon Web Services
	// organization. For more information about Amazon Web Services Organizations,
	// see What Is Amazon Web Services Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
	// in the Amazon Web Services Organizations User Guide.
	//
	// If you specify Condition with an Amazon Web Services organization ID, and
	// specify "*" as the value for Principal, you grant permission to all the accounts
	// in the named organization.
	//
	// The Condition is a JSON string which must contain Type, Key, and Value fields.
	Condition *Condition `type:"structure"`

	// The name of the event bus associated with the rule. If you omit this, the
	// default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// A JSON string that describes the permission policy statement. You can include
	// a Policy parameter in the request instead of using the StatementId, Action,
	// Principal, or Condition parameters.
	Policy *string `type:"string"`

	// The 12-digit Amazon Web Services account ID that you are permitting to put
	// events to your default event bus. Specify "*" to permit any account to put
	// events to your default event bus.
	//
	// If you specify "*" without specifying Condition, avoid creating rules that
	// may match undesirable events. To create more secure rules, make sure that
	// the event pattern for each rule contains an account field with a specific
	// account ID from which to receive events. Rules with an account field do not
	// match any events sent from other accounts.
	Principal *string `min:"1" type:"string"`

	// An identifier string for the external account that you are granting permissions
	// to. If you later want to revoke the permission for this external account,
	// specify this StatementId when you run RemovePermission (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html).
	//
	// Each StatementId must be unique.
	StatementId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPermissionInput"}
	if s.Action != nil && len(*s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Principal != nil && len(*s.Principal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principal", 1))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *PutPermissionInput) SetAction(v string) *PutPermissionInput {
	s.Action = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *PutPermissionInput) SetCondition(v *Condition) *PutPermissionInput {
	s.Condition = v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *PutPermissionInput) SetEventBusName(v string) *PutPermissionInput {
	s.EventBusName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutPermissionInput) SetPolicy(v string) *PutPermissionInput {
	s.Policy = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PutPermissionInput) SetPrincipal(v string) *PutPermissionInput {
	s.Principal = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *PutPermissionInput) SetStatementId(v string) *PutPermissionInput {
	s.StatementId = &v
	return s
}

type PutPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionOutput) GoString() string {
	return s.String()
}

type PutRuleInput struct {
	_ struct{} `type:"structure"`

	// A description of the rule.
	Description *string `type:"string"`

	// The name or ARN of the event bus to associate with this rule. If you omit
	// this, the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The event pattern. For more information, see Amazon EventBridge event patterns
	// (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule that you are creating or updating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	//
	// If you're setting an event bus in another account as the target and that
	// account granted permission to your account through an organization instead
	// of directly by the account ID, you must specify a RoleArn with proper permissions
	// in the Target structure, instead of here in this parameter.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Indicates whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`

	// The list of key-value pairs to associate with the rule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRuleInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutRuleInput) SetDescription(v string) *PutRuleInput {
	s.Description = &v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *PutRuleInput) SetEventBusName(v string) *PutRuleInput {
	s.EventBusName = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *PutRuleInput) SetEventPattern(v string) *PutRuleInput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleInput) SetName(v string) *PutRuleInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutRuleInput) SetRoleArn(v string) *PutRuleInput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *PutRuleInput) SetScheduleExpression(v string) *PutRuleInput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *PutRuleInput) SetState(v string) *PutRuleInput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutRuleInput) SetTags(v []*Tag) *PutRuleInput {
	s.Tags = v
	return s
}

type PutRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleOutput) GoString() string {
	return s.String()
}

// SetRuleArn sets the RuleArn field's value.
func (s *PutRuleOutput) SetRuleArn(v string) *PutRuleOutput {
	s.RuleArn = &v
	return s
}

type PutTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`

	// The targets to update or add to the rule.
	//
	// Targets is a required field
	Targets []*Target `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTargetsInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *PutTargetsInput) SetEventBusName(v string) *PutTargetsInput {
	s.EventBusName = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *PutTargetsInput) SetRule(v string) *PutTargetsInput {
	s.Rule = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *PutTargetsInput) SetTargets(v []*Target) *PutTargetsInput {
	s.Targets = v
	return s
}

type PutTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*PutTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *PutTargetsOutput) SetFailedEntries(v []*PutTargetsResultEntry) *PutTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutTargetsOutput) SetFailedEntryCount(v int64) *PutTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be added to a rule.
type PutTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target addition failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target addition failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutTargetsResultEntry) SetErrorCode(v string) *PutTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutTargetsResultEntry) SetErrorMessage(v string) *PutTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PutTargetsResultEntry) SetTargetId(v string) *PutTargetsResultEntry {
	s.TargetId = &v
	return s
}

// These are custom parameters to be used when the target is a Amazon Redshift
// cluster or Redshift Serverless workgroup to invoke the Amazon Redshift Data
// API ExecuteStatement based on EventBridge events.
type RedshiftDataParameters struct {
	_ struct{} `type:"structure"`

	// The name of the database. Required when authenticating using temporary credentials.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The database user name. Required when authenticating using temporary credentials.
	//
	// Do not provide this parameter when connecting to a Redshift Serverless workgroup.
	DbUser *string `min:"1" type:"string"`

	// The name or ARN of the secret that enables access to the database. Required
	// when authenticating using Amazon Web Services Secrets Manager.
	SecretManagerArn *string `min:"1" type:"string"`

	// The SQL statement text to run.
	//
	// Sql is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDataParameters's
	// String and GoString methods.
	Sql *string `min:"1" type:"string" sensitive:"true"`

	// A list of SQLs.
	//
	// Sqls is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDataParameters's
	// String and GoString methods.
	Sqls []*string `type:"list" sensitive:"true"`

	// The name of the SQL statement. You can name the SQL statement when you create
	// it to identify the query.
	StatementName *string `min:"1" type:"string"`

	// Indicates whether to send an event back to EventBridge after the SQL statement
	// runs.
	WithEvent *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDataParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDataParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDataParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.DbUser != nil && len(*s.DbUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DbUser", 1))
	}
	if s.SecretManagerArn != nil && len(*s.SecretManagerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretManagerArn", 1))
	}
	if s.Sql != nil && len(*s.Sql) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sql", 1))
	}
	if s.StatementName != nil && len(*s.StatementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *RedshiftDataParameters) SetDatabase(v string) *RedshiftDataParameters {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *RedshiftDataParameters) SetDbUser(v string) *RedshiftDataParameters {
	s.DbUser = &v
	return s
}

// SetSecretManagerArn sets the SecretManagerArn field's value.
func (s *RedshiftDataParameters) SetSecretManagerArn(v string) *RedshiftDataParameters {
	s.SecretManagerArn = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *RedshiftDataParameters) SetSql(v string) *RedshiftDataParameters {
	s.Sql = &v
	return s
}

// SetSqls sets the Sqls field's value.
func (s *RedshiftDataParameters) SetSqls(v []*string) *RedshiftDataParameters {
	s.Sqls = v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *RedshiftDataParameters) SetStatementName(v string) *RedshiftDataParameters {
	s.StatementName = &v
	return s
}

// SetWithEvent sets the WithEvent field's value.
func (s *RedshiftDataParameters) SetWithEvent(v bool) *RedshiftDataParameters {
	s.WithEvent = &v
	return s
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the event bus to revoke permissions for. If you omit this, the
	// default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// Specifies whether to remove all permissions.
	RemoveAllPermissions *bool `type:"boolean"`

	// The statement ID corresponding to the account that is no longer allowed to
	// put events to the default event bus.
	StatementId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *RemovePermissionInput) SetEventBusName(v string) *RemovePermissionInput {
	s.EventBusName = &v
	return s
}

// SetRemoveAllPermissions sets the RemoveAllPermissions field's value.
func (s *RemovePermissionInput) SetRemoveAllPermissions(v bool) *RemovePermissionInput {
	s.RemoveAllPermissions = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemovePermissionInput) SetStatementId(v string) *RemovePermissionInput {
	s.StatementId = &v
	return s
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type RemoveTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// If this is a managed rule, created by an Amazon Web Services service on your
	// behalf, you must specify Force as True to remove targets. This parameter
	// is ignored for rules that are not managed rules. You can check whether a
	// rule is a managed rule by using DescribeRule or ListRules and checking the
	// ManagedBy field of the response.
	Force *bool `type:"boolean"`

	// The IDs of the targets to remove from the rule.
	//
	// Ids is a required field
	Ids []*string `min:"1" type:"list" required:"true"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTargetsInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventBusName sets the EventBusName field's value.
func (s *RemoveTargetsInput) SetEventBusName(v string) *RemoveTargetsInput {
	s.EventBusName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *RemoveTargetsInput) SetForce(v bool) *RemoveTargetsInput {
	s.Force = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *RemoveTargetsInput) SetIds(v []*string) *RemoveTargetsInput {
	s.Ids = v
	return s
}

// SetRule sets the Rule field's value.
func (s *RemoveTargetsInput) SetRule(v string) *RemoveTargetsInput {
	s.Rule = &v
	return s
}

type RemoveTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*RemoveTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *RemoveTargetsOutput) SetFailedEntries(v []*RemoveTargetsResultEntry) *RemoveTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *RemoveTargetsOutput) SetFailedEntryCount(v int64) *RemoveTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be removed from a rule.
type RemoveTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target removal failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target removal failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RemoveTargetsResultEntry) SetErrorCode(v string) *RemoveTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RemoveTargetsResultEntry) SetErrorMessage(v string) *RemoveTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *RemoveTargetsResultEntry) SetTargetId(v string) *RemoveTargetsResultEntry {
	s.TargetId = &v
	return s
}

// A Replay object that contains details about a replay.
type Replay struct {
	_ struct{} `type:"structure"`

	// A time stamp for the time to start replaying events. Any event with a creation
	// time prior to the EventEndTime specified is replayed.
	EventEndTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the last event was replayed.
	EventLastReplayedTime *time.Time `type:"timestamp"`

	// The ARN of the archive to replay event from.
	EventSourceArn *string `min:"1" type:"string"`

	// A time stamp for the time to start replaying events. This is determined by
	// the time in the event as described in Time (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time).
	EventStartTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the replay completed.
	ReplayEndTime *time.Time `type:"timestamp"`

	// The name of the replay.
	ReplayName *string `min:"1" type:"string"`

	// A time stamp for the time that the replay started.
	ReplayStartTime *time.Time `type:"timestamp"`

	// The current state of the replay.
	State *string `type:"string" enum:"ReplayState"`

	// A description of why the replay is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Replay) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Replay) GoString() string {
	return s.String()
}

// SetEventEndTime sets the EventEndTime field's value.
func (s *Replay) SetEventEndTime(v time.Time) *Replay {
	s.EventEndTime = &v
	return s
}

// SetEventLastReplayedTime sets the EventLastReplayedTime field's value.
func (s *Replay) SetEventLastReplayedTime(v time.Time) *Replay {
	s.EventLastReplayedTime = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *Replay) SetEventSourceArn(v string) *Replay {
	s.EventSourceArn = &v
	return s
}

// SetEventStartTime sets the EventStartTime field's value.
func (s *Replay) SetEventStartTime(v time.Time) *Replay {
	s.EventStartTime = &v
	return s
}

// SetReplayEndTime sets the ReplayEndTime field's value.
func (s *Replay) SetReplayEndTime(v time.Time) *Replay {
	s.ReplayEndTime = &v
	return s
}

// SetReplayName sets the ReplayName field's value.
func (s *Replay) SetReplayName(v string) *Replay {
	s.ReplayName = &v
	return s
}

// SetReplayStartTime sets the ReplayStartTime field's value.
func (s *Replay) SetReplayStartTime(v time.Time) *Replay {
	s.ReplayStartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Replay) SetState(v string) *Replay {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Replay) SetStateReason(v string) *Replay {
	s.StateReason = &v
	return s
}

// A ReplayDestination object that contains details about a replay.
type ReplayDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the event bus to replay event to. You can replay events only to
	// the event bus specified to create the archive.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// A list of ARNs for rules to replay events to.
	FilterArns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplayDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplayDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplayDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplayDestination"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ReplayDestination) SetArn(v string) *ReplayDestination {
	s.Arn = &v
	return s
}

// SetFilterArns sets the FilterArns field's value.
func (s *ReplayDestination) SetFilterArns(v []*string) *ReplayDestination {
	s.FilterArns = v
	return s
}

// Endpoints can replicate all events to the secondary Region.
type ReplicationConfig struct {
	_ struct{} `type:"structure"`

	// The state of event replication.
	State *string `type:"string" enum:"ReplicationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfig) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *ReplicationConfig) SetState(v string) *ReplicationConfig {
	s.State = &v
	return s
}

// The resource you are trying to create already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An entity that you specified does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A RetryPolicy object that includes information about the retry policy settings.
type RetryPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum amount of time, in seconds, to continue to make retry attempts.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of retry attempts to make before the request fails. Retry
	// attempts continue until either the maximum number of attempts is made or
	// until the duration of the MaximumEventAgeInSeconds is met.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryPolicy"}
	if s.MaximumEventAgeInSeconds != nil && *s.MaximumEventAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumEventAgeInSeconds", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *RetryPolicy) SetMaximumEventAgeInSeconds(v int64) *RetryPolicy {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *RetryPolicy) SetMaximumRetryAttempts(v int64) *RetryPolicy {
	s.MaximumRetryAttempts = &v
	return s
}

// The routing configuration of the endpoint.
type RoutingConfig struct {
	_ struct{} `type:"structure"`

	// The failover configuration for an endpoint. This includes what triggers failover
	// and what happens when it's triggered.
	//
	// FailoverConfig is a required field
	FailoverConfig *FailoverConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoutingConfig"}
	if s.FailoverConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FailoverConfig"))
	}
	if s.FailoverConfig != nil {
		if err := s.FailoverConfig.Validate(); err != nil {
			invalidParams.AddNested("FailoverConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailoverConfig sets the FailoverConfig field's value.
func (s *RoutingConfig) SetFailoverConfig(v *FailoverConfig) *RoutingConfig {
	s.FailoverConfig = v
	return s
}

// Contains information about a rule in Amazon EventBridge.
type Rule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The name or ARN of the event bus associated with the rule. If you omit this,
	// the default event bus is used.
	EventBusName *string `min:"1" type:"string"`

	// The event pattern of the rule. For more information, see Events and Event
	// Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	EventPattern *string `type:"string"`

	// If the rule was created on behalf of your account by an Amazon Web Services
	// service, this field displays the principal name of the service that created
	// the rule.
	ManagedBy *string `min:"1" type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that is used for target invocation.
	//
	// If you're setting an event bus in another account as the target and that
	// account granted permission to your account through an organization instead
	// of directly by the account ID, you must specify a RoleArn with proper permissions
	// in the Target structure, instead of here in this parameter.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	// For more information, see Creating an Amazon EventBridge rule that runs on
	// a schedule (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html).
	ScheduleExpression *string `type:"string"`

	// The state of the rule.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Rule) SetArn(v string) *Rule {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Rule) SetDescription(v string) *Rule {
	s.Description = &v
	return s
}

// SetEventBusName sets the EventBusName field's value.
func (s *Rule) SetEventBusName(v string) *Rule {
	s.EventBusName = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *Rule) SetEventPattern(v string) *Rule {
	s.EventPattern = &v
	return s
}

// SetManagedBy sets the ManagedBy field's value.
func (s *Rule) SetManagedBy(v string) *Rule {
	s.ManagedBy = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Rule) SetRoleArn(v string) *Rule {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Rule) SetScheduleExpression(v string) *Rule {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *Rule) SetState(v string) *Rule {
	s.State = &v
	return s
}

// This parameter contains the criteria (either InstanceIds or a tag) used to
// specify which EC2 instances are to be sent the command.
type RunCommandParameters struct {
	_ struct{} `type:"structure"`

	// Currently, we support including only one RunCommandTarget block, which specifies
	// either an array of InstanceIds or a tag.
	//
	// RunCommandTargets is a required field
	RunCommandTargets []*RunCommandTarget `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunCommandParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunCommandParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandParameters"}
	if s.RunCommandTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("RunCommandTargets"))
	}
	if s.RunCommandTargets != nil && len(s.RunCommandTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunCommandTargets", 1))
	}
	if s.RunCommandTargets != nil {
		for i, v := range s.RunCommandTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RunCommandTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRunCommandTargets sets the RunCommandTargets field's value.
func (s *RunCommandParameters) SetRunCommandTargets(v []*RunCommandTarget) *RunCommandParameters {
	s.RunCommandTargets = v
	return s
}

// Information about the EC2 instances that are to be sent the command, specified
// as key-value pairs. Each RunCommandTarget block can include only one key,
// but this key may specify multiple values.
type RunCommandTarget struct {
	_ struct{} `type:"structure"`

	// Can be either tag: tag-key or InstanceIds.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// If Key is tag: tag-key, Values is a list of tag values. If Key is InstanceIds,
	// Values is a list of Amazon EC2 instance IDs.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunCommandTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunCommandTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandTarget"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *RunCommandTarget) SetKey(v string) *RunCommandTarget {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RunCommandTarget) SetValues(v []*string) *RunCommandTarget {
	s.Values = v
	return s
}

// Name/Value pair of a parameter to start execution of a SageMaker Model Building
// Pipeline.
type SageMakerPipelineParameter struct {
	_ struct{} `type:"structure"`

	// Name of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Value of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerPipelineParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerPipelineParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SageMakerPipelineParameter) SetName(v string) *SageMakerPipelineParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SageMakerPipelineParameter) SetValue(v string) *SageMakerPipelineParameter {
	s.Value = &v
	return s
}

// These are custom parameters to use when the target is a SageMaker Model Building
// Pipeline that starts based on EventBridge events.
type SageMakerPipelineParameters struct {
	_ struct{} `type:"structure"`

	// List of Parameter names and values for SageMaker Model Building Pipeline
	// execution.
	PipelineParameterList []*SageMakerPipelineParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerPipelineParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerPipelineParameters"}
	if s.PipelineParameterList != nil {
		for i, v := range s.PipelineParameterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineParameterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineParameterList sets the PipelineParameterList field's value.
func (s *SageMakerPipelineParameters) SetPipelineParameterList(v []*SageMakerPipelineParameter) *SageMakerPipelineParameters {
	s.PipelineParameterList = v
	return s
}

// The secondary Region that processes events when failover is triggered or
// replication is enabled.
type Secondary struct {
	_ struct{} `type:"structure"`

	// Defines the secondary Region.
	//
	// Route is a required field
	Route *string `min:"9" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secondary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Secondary) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Secondary) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Secondary"}
	if s.Route == nil {
		invalidParams.Add(request.NewErrParamRequired("Route"))
	}
	if s.Route != nil && len(*s.Route) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("Route", 9))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoute sets the Route field's value.
func (s *Secondary) SetRoute(v string) *Secondary {
	s.Route = &v
	return s
}

// This structure includes the custom parameter to be used when the target is
// an SQS FIFO queue.
type SqsParameters struct {
	_ struct{} `type:"structure"`

	// The FIFO message group ID to use as the target.
	MessageGroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsParameters) GoString() string {
	return s.String()
}

// SetMessageGroupId sets the MessageGroupId field's value.
func (s *SqsParameters) SetMessageGroupId(v string) *SqsParameters {
	s.MessageGroupId = &v
	return s
}

type StartReplayInput struct {
	_ struct{} `type:"structure"`

	// A description for the replay to start.
	Description *string `type:"string"`

	// A ReplayDestination object that includes details about the destination for
	// the replay.
	//
	// Destination is a required field
	Destination *ReplayDestination `type:"structure" required:"true"`

	// A time stamp for the time to stop replaying events. Only events that occurred
	// between the EventStartTime and EventEndTime are replayed.
	//
	// EventEndTime is a required field
	EventEndTime *time.Time `type:"timestamp" required:"true"`

	// The ARN of the archive to replay events from.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `min:"1" type:"string" required:"true"`

	// A time stamp for the time to start replaying events. Only events that occurred
	// between the EventStartTime and EventEndTime are replayed.
	//
	// EventStartTime is a required field
	EventStartTime *time.Time `type:"timestamp" required:"true"`

	// The name of the replay to start.
	//
	// ReplayName is a required field
	ReplayName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplayInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.EventEndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EventEndTime"))
	}
	if s.EventSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceArn"))
	}
	if s.EventSourceArn != nil && len(*s.EventSourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventSourceArn", 1))
	}
	if s.EventStartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EventStartTime"))
	}
	if s.ReplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplayName"))
	}
	if s.ReplayName != nil && len(*s.ReplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReplayName", 1))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StartReplayInput) SetDescription(v string) *StartReplayInput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *StartReplayInput) SetDestination(v *ReplayDestination) *StartReplayInput {
	s.Destination = v
	return s
}

// SetEventEndTime sets the EventEndTime field's value.
func (s *StartReplayInput) SetEventEndTime(v time.Time) *StartReplayInput {
	s.EventEndTime = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *StartReplayInput) SetEventSourceArn(v string) *StartReplayInput {
	s.EventSourceArn = &v
	return s
}

// SetEventStartTime sets the EventStartTime field's value.
func (s *StartReplayInput) SetEventStartTime(v time.Time) *StartReplayInput {
	s.EventStartTime = &v
	return s
}

// SetReplayName sets the ReplayName field's value.
func (s *StartReplayInput) SetReplayName(v string) *StartReplayInput {
	s.ReplayName = &v
	return s
}

type StartReplayOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the replay.
	ReplayArn *string `min:"1" type:"string"`

	// The time at which the replay started.
	ReplayStartTime *time.Time `type:"timestamp"`

	// The state of the replay.
	State *string `type:"string" enum:"ReplayState"`

	// The reason that the replay is in the state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplayOutput) GoString() string {
	return s.String()
}

// SetReplayArn sets the ReplayArn field's value.
func (s *StartReplayOutput) SetReplayArn(v string) *StartReplayOutput {
	s.ReplayArn = &v
	return s
}

// SetReplayStartTime sets the ReplayStartTime field's value.
func (s *StartReplayOutput) SetReplayStartTime(v time.Time) *StartReplayOutput {
	s.ReplayStartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StartReplayOutput) SetState(v string) *StartReplayOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *StartReplayOutput) SetStateReason(v string) *StartReplayOutput {
	s.StateReason = &v
	return s
}

// A key-value pair associated with an Amazon Web Services resource. In EventBridge,
// rules and event buses support tagging.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string you can use to assign a value. The combination of tag keys and values
	// can help you organize and categorize your resources.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the EventBridge resource that you're adding tags to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The list of key-value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Targets are the resources to be invoked when a rule is triggered. For a complete
// list of services and resources that can be set as a target, see PutTargets
// (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html).
//
// If you are setting the event bus of another account as the target, and that
// account granted permission to your account through an organization instead
// of directly by the account ID, then you must specify a RoleArn with proper
// permissions in the Target structure. For more information, see Sending and
// Receiving Events Between Amazon Web Services Accounts (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html)
// in the Amazon EventBridge User Guide.
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// If the event target is an Batch job, this contains the job definition, job
	// name, and other parameters. For more information, see Jobs (https://docs.aws.amazon.com/batch/latest/userguide/jobs.html)
	// in the Batch User Guide.
	BatchParameters *BatchParameters `type:"structure"`

	// The DeadLetterConfig that defines the target queue to send dead-letter queue
	// events to.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// Contains the Amazon ECS task definition and task count to be used, if the
	// event target is an Amazon ECS task. For more information about Amazon ECS
	// tasks, see Task Definitions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
	// in the Amazon EC2 Container Service Developer Guide.
	EcsParameters *EcsParameters `type:"structure"`

	// Contains the HTTP parameters to use when the target is a API Gateway endpoint
	// or EventBridge ApiDestination.
	//
	// If you specify an API Gateway API or EventBridge ApiDestination as a target,
	// you can use this parameter to specify headers, path parameters, and query
	// string keys/values as part of your target invoking request. If you're using
	// ApiDestinations, the corresponding Connection can also have these values
	// configured. In case of any conflicting keys, values from the Connection take
	// precedence.
	HttpParameters *HttpParameters `type:"structure"`

	// The ID of the target within the specified rule. Use this ID to reference
	// the target when updating the rule. We recommend using a memorable and unique
	// string.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Valid JSON text passed to the target. In this case, nothing from the event
	// itself is passed to the target. For more information, see The JavaScript
	// Object Notation (JSON) Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	Input *string `type:"string"`

	// The value of the JSONPath that is used for extracting part of the matched
	// event when passing it to the target. You may use JSON dot notation or bracket
	// notation. For more information about JSON paths, see JSONPath (http://goessner.net/articles/JsonPath/).
	InputPath *string `type:"string"`

	// Settings to enable you to provide custom input to a target based on certain
	// event data. You can extract one or more key-value pairs from the event and
	// then use that data to send customized input to the target.
	InputTransformer *InputTransformer `type:"structure"`

	// The custom parameter you can use to control the shard assignment, when the
	// target is a Kinesis data stream. If you do not include this parameter, the
	// default is to use the eventId as the partition key.
	KinesisParameters *KinesisParameters `type:"structure"`

	// Contains the Amazon Redshift Data API parameters to use when the target is
	// a Amazon Redshift cluster.
	//
	// If you specify a Amazon Redshift Cluster as a Target, you can use this to
	// specify parameters to invoke the Amazon Redshift Data API ExecuteStatement
	// based on EventBridge events.
	RedshiftDataParameters *RedshiftDataParameters `type:"structure"`

	// The RetryPolicy object that contains the retry policy configuration to use
	// for the dead-letter queue.
	RetryPolicy *RetryPolicy `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be used for this target
	// when the rule is triggered. If one rule triggers multiple targets, you can
	// use a different IAM role for each target.
	RoleArn *string `min:"1" type:"string"`

	// Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
	RunCommandParameters *RunCommandParameters `type:"structure"`

	// Contains the SageMaker Model Building Pipeline parameters to start execution
	// of a SageMaker Model Building Pipeline.
	//
	// If you specify a SageMaker Model Building Pipeline as a target, you can use
	// this to specify parameters to start a pipeline execution based on EventBridge
	// events.
	SageMakerPipelineParameters *SageMakerPipelineParameters `type:"structure"`

	// Contains the message group ID to use when the target is a FIFO queue.
	//
	// If you specify an SQS FIFO queue as a target, the queue must have content-based
	// deduplication enabled.
	SqsParameters *SqsParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.BatchParameters != nil {
		if err := s.BatchParameters.Validate(); err != nil {
			invalidParams.AddNested("BatchParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsParameters != nil {
		if err := s.EcsParameters.Validate(); err != nil {
			invalidParams.AddNested("EcsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.InputTransformer != nil {
		if err := s.InputTransformer.Validate(); err != nil {
			invalidParams.AddNested("InputTransformer", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisParameters != nil {
		if err := s.KinesisParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDataParameters != nil {
		if err := s.RedshiftDataParameters.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDataParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.RunCommandParameters != nil {
		if err := s.RunCommandParameters.Validate(); err != nil {
			invalidParams.AddNested("RunCommandParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SageMakerPipelineParameters != nil {
		if err := s.SageMakerPipelineParameters.Validate(); err != nil {
			invalidParams.AddNested("SageMakerPipelineParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Target) SetArn(v string) *Target {
	s.Arn = &v
	return s
}

// SetBatchParameters sets the BatchParameters field's value.
func (s *Target) SetBatchParameters(v *BatchParameters) *Target {
	s.BatchParameters = v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *Target) SetDeadLetterConfig(v *DeadLetterConfig) *Target {
	s.DeadLetterConfig = v
	return s
}

// SetEcsParameters sets the EcsParameters field's value.
func (s *Target) SetEcsParameters(v *EcsParameters) *Target {
	s.EcsParameters = v
	return s
}

// SetHttpParameters sets the HttpParameters field's value.
func (s *Target) SetHttpParameters(v *HttpParameters) *Target {
	s.HttpParameters = v
	return s
}

// SetId sets the Id field's value.
func (s *Target) SetId(v string) *Target {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *Target) SetInput(v string) *Target {
	s.Input = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *Target) SetInputPath(v string) *Target {
	s.InputPath = &v
	return s
}

// SetInputTransformer sets the InputTransformer field's value.
func (s *Target) SetInputTransformer(v *InputTransformer) *Target {
	s.InputTransformer = v
	return s
}

// SetKinesisParameters sets the KinesisParameters field's value.
func (s *Target) SetKinesisParameters(v *KinesisParameters) *Target {
	s.KinesisParameters = v
	return s
}

// SetRedshiftDataParameters sets the RedshiftDataParameters field's value.
func (s *Target) SetRedshiftDataParameters(v *RedshiftDataParameters) *Target {
	s.RedshiftDataParameters = v
	return s
}

// SetRetryPolicy sets the RetryPolicy field's value.
func (s *Target) SetRetryPolicy(v *RetryPolicy) *Target {
	s.RetryPolicy = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Target) SetRoleArn(v string) *Target {
	s.RoleArn = &v
	return s
}

// SetRunCommandParameters sets the RunCommandParameters field's value.
func (s *Target) SetRunCommandParameters(v *RunCommandParameters) *Target {
	s.RunCommandParameters = v
	return s
}

// SetSageMakerPipelineParameters sets the SageMakerPipelineParameters field's value.
func (s *Target) SetSageMakerPipelineParameters(v *SageMakerPipelineParameters) *Target {
	s.SageMakerPipelineParameters = v
	return s
}

// SetSqsParameters sets the SqsParameters field's value.
func (s *Target) SetSqsParameters(v *SqsParameters) *Target {
	s.SqsParameters = v
	return s
}

type TestEventPatternInput struct {
	_ struct{} `type:"structure"`

	// The event, in JSON format, to test against the event pattern. The JSON must
	// follow the format specified in Amazon Web Services Events (https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html),
	// and the following fields are mandatory:
	//
	//    * id
	//
	//    * account
	//
	//    * source
	//
	//    * time
	//
	//    * region
	//
	//    * resources
	//
	//    * detail-type
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The event pattern. For more information, see Events and Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	//
	// EventPattern is a required field
	EventPattern *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestEventPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestEventPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestEventPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestEventPatternInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.EventPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("EventPattern"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *TestEventPatternInput) SetEvent(v string) *TestEventPatternInput {
	s.Event = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *TestEventPatternInput) SetEventPattern(v string) *TestEventPatternInput {
	s.EventPattern = &v
	return s
}

type TestEventPatternOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the event matches the event pattern.
	Result *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestEventPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestEventPatternOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *TestEventPatternOutput) SetResult(v bool) *TestEventPatternOutput {
	s.Result = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the EventBridge resource from which you are removing tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApiDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection to use for the API destination.
	ConnectionArn *string `min:"1" type:"string"`

	// The name of the API destination to update.
	Description *string `type:"string"`

	// The method to use for the API destination.
	HttpMethod *string `type:"string" enum:"ApiDestinationHttpMethod"`

	// The URL to the endpoint to use for the API destination.
	InvocationEndpoint *string `min:"1" type:"string"`

	// The maximum number of invocations per second to send to the API destination.
	InvocationRateLimitPerSecond *int64 `min:"1" type:"integer"`

	// The name of the API destination to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApiDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApiDestinationInput"}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}
	if s.InvocationEndpoint != nil && len(*s.InvocationEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationEndpoint", 1))
	}
	if s.InvocationRateLimitPerSecond != nil && *s.InvocationRateLimitPerSecond < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InvocationRateLimitPerSecond", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *UpdateApiDestinationInput) SetConnectionArn(v string) *UpdateApiDestinationInput {
	s.ConnectionArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApiDestinationInput) SetDescription(v string) *UpdateApiDestinationInput {
	s.Description = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateApiDestinationInput) SetHttpMethod(v string) *UpdateApiDestinationInput {
	s.HttpMethod = &v
	return s
}

// SetInvocationEndpoint sets the InvocationEndpoint field's value.
func (s *UpdateApiDestinationInput) SetInvocationEndpoint(v string) *UpdateApiDestinationInput {
	s.InvocationEndpoint = &v
	return s
}

// SetInvocationRateLimitPerSecond sets the InvocationRateLimitPerSecond field's value.
func (s *UpdateApiDestinationInput) SetInvocationRateLimitPerSecond(v int64) *UpdateApiDestinationInput {
	s.InvocationRateLimitPerSecond = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApiDestinationInput) SetName(v string) *UpdateApiDestinationInput {
	s.Name = &v
	return s
}

type UpdateApiDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the API destination that was updated.
	ApiDestinationArn *string `min:"1" type:"string"`

	// The state of the API destination that was updated.
	ApiDestinationState *string `type:"string" enum:"ApiDestinationState"`

	// A time stamp for the time that the API destination was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the API destination was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiDestinationOutput) GoString() string {
	return s.String()
}

// SetApiDestinationArn sets the ApiDestinationArn field's value.
func (s *UpdateApiDestinationOutput) SetApiDestinationArn(v string) *UpdateApiDestinationOutput {
	s.ApiDestinationArn = &v
	return s
}

// SetApiDestinationState sets the ApiDestinationState field's value.
func (s *UpdateApiDestinationOutput) SetApiDestinationState(v string) *UpdateApiDestinationOutput {
	s.ApiDestinationState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateApiDestinationOutput) SetCreationTime(v time.Time) *UpdateApiDestinationOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateApiDestinationOutput) SetLastModifiedTime(v time.Time) *UpdateApiDestinationOutput {
	s.LastModifiedTime = &v
	return s
}

type UpdateArchiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the archive to update.
	//
	// ArchiveName is a required field
	ArchiveName *string `min:"1" type:"string" required:"true"`

	// The description for the archive.
	Description *string `type:"string"`

	// The event pattern to use to filter events sent to the archive.
	EventPattern *string `type:"string"`

	// The number of days to retain events in the archive.
	RetentionDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateArchiveInput"}
	if s.ArchiveName == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveName"))
	}
	if s.ArchiveName != nil && len(*s.ArchiveName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveName sets the ArchiveName field's value.
func (s *UpdateArchiveInput) SetArchiveName(v string) *UpdateArchiveInput {
	s.ArchiveName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateArchiveInput) SetDescription(v string) *UpdateArchiveInput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *UpdateArchiveInput) SetEventPattern(v string) *UpdateArchiveInput {
	s.EventPattern = &v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *UpdateArchiveInput) SetRetentionDays(v int64) *UpdateArchiveInput {
	s.RetentionDays = &v
	return s
}

type UpdateArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the archive.
	ArchiveArn *string `min:"1" type:"string"`

	// The time at which the archive was updated.
	CreationTime *time.Time `type:"timestamp"`

	// The state of the archive.
	State *string `type:"string" enum:"ArchiveState"`

	// The reason that the archive is in the current state.
	StateReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateArchiveOutput) GoString() string {
	return s.String()
}

// SetArchiveArn sets the ArchiveArn field's value.
func (s *UpdateArchiveOutput) SetArchiveArn(v string) *UpdateArchiveOutput {
	s.ArchiveArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateArchiveOutput) SetCreationTime(v time.Time) *UpdateArchiveOutput {
	s.CreationTime = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateArchiveOutput) SetState(v string) *UpdateArchiveOutput {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *UpdateArchiveOutput) SetStateReason(v string) *UpdateArchiveOutput {
	s.StateReason = &v
	return s
}

// Contains the API key authorization parameters to use to update the connection.
type UpdateConnectionApiKeyAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The name of the API key to use for authorization.
	ApiKeyName *string `min:"1" type:"string"`

	// The value associated with teh API key to use for authorization.
	//
	// ApiKeyValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateConnectionApiKeyAuthRequestParameters's
	// String and GoString methods.
	ApiKeyValue *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionApiKeyAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionApiKeyAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionApiKeyAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionApiKeyAuthRequestParameters"}
	if s.ApiKeyName != nil && len(*s.ApiKeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKeyName", 1))
	}
	if s.ApiKeyValue != nil && len(*s.ApiKeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyName sets the ApiKeyName field's value.
func (s *UpdateConnectionApiKeyAuthRequestParameters) SetApiKeyName(v string) *UpdateConnectionApiKeyAuthRequestParameters {
	s.ApiKeyName = &v
	return s
}

// SetApiKeyValue sets the ApiKeyValue field's value.
func (s *UpdateConnectionApiKeyAuthRequestParameters) SetApiKeyValue(v string) *UpdateConnectionApiKeyAuthRequestParameters {
	s.ApiKeyValue = &v
	return s
}

// Contains the additional parameters to use for the connection.
type UpdateConnectionAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// A UpdateConnectionApiKeyAuthRequestParameters object that contains the authorization
	// parameters for API key authorization.
	ApiKeyAuthParameters *UpdateConnectionApiKeyAuthRequestParameters `type:"structure"`

	// A UpdateConnectionBasicAuthRequestParameters object that contains the authorization
	// parameters for Basic authorization.
	BasicAuthParameters *UpdateConnectionBasicAuthRequestParameters `type:"structure"`

	// A ConnectionHttpParameters object that contains the additional parameters
	// to use for the connection.
	InvocationHttpParameters *ConnectionHttpParameters `type:"structure"`

	// A UpdateConnectionOAuthRequestParameters object that contains the authorization
	// parameters for OAuth authorization.
	OAuthParameters *UpdateConnectionOAuthRequestParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionAuthRequestParameters"}
	if s.ApiKeyAuthParameters != nil {
		if err := s.ApiKeyAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("ApiKeyAuthParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.BasicAuthParameters != nil {
		if err := s.BasicAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("BasicAuthParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.OAuthParameters != nil {
		if err := s.OAuthParameters.Validate(); err != nil {
			invalidParams.AddNested("OAuthParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyAuthParameters sets the ApiKeyAuthParameters field's value.
func (s *UpdateConnectionAuthRequestParameters) SetApiKeyAuthParameters(v *UpdateConnectionApiKeyAuthRequestParameters) *UpdateConnectionAuthRequestParameters {
	s.ApiKeyAuthParameters = v
	return s
}

// SetBasicAuthParameters sets the BasicAuthParameters field's value.
func (s *UpdateConnectionAuthRequestParameters) SetBasicAuthParameters(v *UpdateConnectionBasicAuthRequestParameters) *UpdateConnectionAuthRequestParameters {
	s.BasicAuthParameters = v
	return s
}

// SetInvocationHttpParameters sets the InvocationHttpParameters field's value.
func (s *UpdateConnectionAuthRequestParameters) SetInvocationHttpParameters(v *ConnectionHttpParameters) *UpdateConnectionAuthRequestParameters {
	s.InvocationHttpParameters = v
	return s
}

// SetOAuthParameters sets the OAuthParameters field's value.
func (s *UpdateConnectionAuthRequestParameters) SetOAuthParameters(v *UpdateConnectionOAuthRequestParameters) *UpdateConnectionAuthRequestParameters {
	s.OAuthParameters = v
	return s
}

// Contains the Basic authorization parameters for the connection.
type UpdateConnectionBasicAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The password associated with the user name to use for Basic authorization.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateConnectionBasicAuthRequestParameters's
	// String and GoString methods.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The user name to use for Basic authorization.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionBasicAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionBasicAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionBasicAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionBasicAuthRequestParameters"}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *UpdateConnectionBasicAuthRequestParameters) SetPassword(v string) *UpdateConnectionBasicAuthRequestParameters {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UpdateConnectionBasicAuthRequestParameters) SetUsername(v string) *UpdateConnectionBasicAuthRequestParameters {
	s.Username = &v
	return s
}

type UpdateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The authorization parameters to use for the connection.
	AuthParameters *UpdateConnectionAuthRequestParameters `type:"structure"`

	// The type of authorization to use for the connection.
	AuthorizationType *string `type:"string" enum:"ConnectionAuthorizationType"`

	// A description for the connection.
	Description *string `type:"string"`

	// The name of the connection to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AuthParameters != nil {
		if err := s.AuthParameters.Validate(); err != nil {
			invalidParams.AddNested("AuthParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthParameters sets the AuthParameters field's value.
func (s *UpdateConnectionInput) SetAuthParameters(v *UpdateConnectionAuthRequestParameters) *UpdateConnectionInput {
	s.AuthParameters = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *UpdateConnectionInput) SetAuthorizationType(v string) *UpdateConnectionInput {
	s.AuthorizationType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConnectionInput) SetDescription(v string) *UpdateConnectionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConnectionInput) SetName(v string) *UpdateConnectionInput {
	s.Name = &v
	return s
}

// Contains the OAuth authorization parameters to use for the connection.
type UpdateConnectionOAuthClientRequestParameters struct {
	_ struct{} `type:"structure"`

	// The client ID to use for OAuth authorization.
	ClientID *string `min:"1" type:"string"`

	// The client secret assciated with the client ID to use for OAuth authorization.
	//
	// ClientSecret is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateConnectionOAuthClientRequestParameters's
	// String and GoString methods.
	ClientSecret *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOAuthClientRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOAuthClientRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionOAuthClientRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionOAuthClientRequestParameters"}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientID", 1))
	}
	if s.ClientSecret != nil && len(*s.ClientSecret) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientSecret", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientID sets the ClientID field's value.
func (s *UpdateConnectionOAuthClientRequestParameters) SetClientID(v string) *UpdateConnectionOAuthClientRequestParameters {
	s.ClientID = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *UpdateConnectionOAuthClientRequestParameters) SetClientSecret(v string) *UpdateConnectionOAuthClientRequestParameters {
	s.ClientSecret = &v
	return s
}

// Contains the OAuth request parameters to use for the connection.
type UpdateConnectionOAuthRequestParameters struct {
	_ struct{} `type:"structure"`

	// The URL to the authorization endpoint when OAuth is specified as the authorization
	// type.
	AuthorizationEndpoint *string `min:"1" type:"string"`

	// A UpdateConnectionOAuthClientRequestParameters object that contains the client
	// parameters to use for the connection when OAuth is specified as the authorization
	// type.
	ClientParameters *UpdateConnectionOAuthClientRequestParameters `type:"structure"`

	// The method used to connect to the HTTP endpoint.
	HttpMethod *string `type:"string" enum:"ConnectionOAuthHttpMethod"`

	// The additional HTTP parameters used for the OAuth authorization request.
	OAuthHttpParameters *ConnectionHttpParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOAuthRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOAuthRequestParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionOAuthRequestParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionOAuthRequestParameters"}
	if s.AuthorizationEndpoint != nil && len(*s.AuthorizationEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizationEndpoint", 1))
	}
	if s.ClientParameters != nil {
		if err := s.ClientParameters.Validate(); err != nil {
			invalidParams.AddNested("ClientParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationEndpoint sets the AuthorizationEndpoint field's value.
func (s *UpdateConnectionOAuthRequestParameters) SetAuthorizationEndpoint(v string) *UpdateConnectionOAuthRequestParameters {
	s.AuthorizationEndpoint = &v
	return s
}

// SetClientParameters sets the ClientParameters field's value.
func (s *UpdateConnectionOAuthRequestParameters) SetClientParameters(v *UpdateConnectionOAuthClientRequestParameters) *UpdateConnectionOAuthRequestParameters {
	s.ClientParameters = v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateConnectionOAuthRequestParameters) SetHttpMethod(v string) *UpdateConnectionOAuthRequestParameters {
	s.HttpMethod = &v
	return s
}

// SetOAuthHttpParameters sets the OAuthHttpParameters field's value.
func (s *UpdateConnectionOAuthRequestParameters) SetOAuthHttpParameters(v *ConnectionHttpParameters) *UpdateConnectionOAuthRequestParameters {
	s.OAuthHttpParameters = v
	return s
}

type UpdateConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connection that was updated.
	ConnectionArn *string `min:"1" type:"string"`

	// The state of the connection that was updated.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// A time stamp for the time that the connection was created.
	CreationTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last authorized.
	LastAuthorizedTime *time.Time `type:"timestamp"`

	// A time stamp for the time that the connection was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *UpdateConnectionOutput) SetConnectionArn(v string) *UpdateConnectionOutput {
	s.ConnectionArn = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *UpdateConnectionOutput) SetConnectionState(v string) *UpdateConnectionOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateConnectionOutput) SetCreationTime(v time.Time) *UpdateConnectionOutput {
	s.CreationTime = &v
	return s
}

// SetLastAuthorizedTime sets the LastAuthorizedTime field's value.
func (s *UpdateConnectionOutput) SetLastAuthorizedTime(v time.Time) *UpdateConnectionOutput {
	s.LastAuthorizedTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateConnectionOutput) SetLastModifiedTime(v time.Time) *UpdateConnectionOutput {
	s.LastModifiedTime = &v
	return s
}

type UpdateEndpointInput struct {
	_ struct{} `type:"structure"`

	// A description for the endpoint.
	Description *string `type:"string"`

	// Define event buses used for replication.
	EventBuses []*EndpointEventBus `min:"2" type:"list"`

	// The name of the endpoint you want to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Whether event replication was enabled or disabled by this request.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used by event replication for this request.
	RoleArn *string `min:"1" type:"string"`

	// Configure the routing policy, including the health check and secondary Region.
	RoutingConfig *RoutingConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.EventBuses != nil && len(s.EventBuses) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("EventBuses", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.EventBuses != nil {
		for i, v := range s.EventBuses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventBuses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RoutingConfig != nil {
		if err := s.RoutingConfig.Validate(); err != nil {
			invalidParams.AddNested("RoutingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEndpointInput) SetDescription(v string) *UpdateEndpointInput {
	s.Description = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *UpdateEndpointInput) SetEventBuses(v []*EndpointEventBus) *UpdateEndpointInput {
	s.EventBuses = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEndpointInput) SetName(v string) *UpdateEndpointInput {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *UpdateEndpointInput) SetReplicationConfig(v *ReplicationConfig) *UpdateEndpointInput {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEndpointInput) SetRoleArn(v string) *UpdateEndpointInput {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *UpdateEndpointInput) SetRoutingConfig(v *RoutingConfig) *UpdateEndpointInput {
	s.RoutingConfig = v
	return s
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the endpoint you updated in this request.
	Arn *string `min:"1" type:"string"`

	// The ID of the endpoint you updated in this request.
	EndpointId *string `min:"1" type:"string"`

	// The URL of the endpoint you updated in this request.
	EndpointUrl *string `min:"1" type:"string"`

	// The event buses used for replication for the endpoint you updated in this
	// request.
	EventBuses []*EndpointEventBus `min:"2" type:"list"`

	// The name of the endpoint you updated in this request.
	Name *string `min:"1" type:"string"`

	// Whether event replication was enabled or disabled for the endpoint you updated
	// in this request.
	ReplicationConfig *ReplicationConfig `type:"structure"`

	// The ARN of the role used by event replication for the endpoint you updated
	// in this request.
	RoleArn *string `min:"1" type:"string"`

	// The routing configuration you updated in this request.
	RoutingConfig *RoutingConfig `type:"structure"`

	// The state of the endpoint you updated in this request.
	State *string `type:"string" enum:"EndpointState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateEndpointOutput) SetArn(v string) *UpdateEndpointOutput {
	s.Arn = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateEndpointOutput) SetEndpointId(v string) *UpdateEndpointOutput {
	s.EndpointId = &v
	return s
}

// SetEndpointUrl sets the EndpointUrl field's value.
func (s *UpdateEndpointOutput) SetEndpointUrl(v string) *UpdateEndpointOutput {
	s.EndpointUrl = &v
	return s
}

// SetEventBuses sets the EventBuses field's value.
func (s *UpdateEndpointOutput) SetEventBuses(v []*EndpointEventBus) *UpdateEndpointOutput {
	s.EventBuses = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEndpointOutput) SetName(v string) *UpdateEndpointOutput {
	s.Name = &v
	return s
}

// SetReplicationConfig sets the ReplicationConfig field's value.
func (s *UpdateEndpointOutput) SetReplicationConfig(v *ReplicationConfig) *UpdateEndpointOutput {
	s.ReplicationConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEndpointOutput) SetRoleArn(v string) *UpdateEndpointOutput {
	s.RoleArn = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *UpdateEndpointOutput) SetRoutingConfig(v *RoutingConfig) *UpdateEndpointOutput {
	s.RoutingConfig = v
	return s
}

// SetState sets the State field's value.
func (s *UpdateEndpointOutput) SetState(v string) *UpdateEndpointOutput {
	s.State = &v
	return s
}

const (
	// ApiDestinationHttpMethodPost is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodPost = "POST"

	// ApiDestinationHttpMethodGet is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodGet = "GET"

	// ApiDestinationHttpMethodHead is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodHead = "HEAD"

	// ApiDestinationHttpMethodOptions is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodOptions = "OPTIONS"

	// ApiDestinationHttpMethodPut is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodPut = "PUT"

	// ApiDestinationHttpMethodPatch is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodPatch = "PATCH"

	// ApiDestinationHttpMethodDelete is a ApiDestinationHttpMethod enum value
	ApiDestinationHttpMethodDelete = "DELETE"
)

// ApiDestinationHttpMethod_Values returns all elements of the ApiDestinationHttpMethod enum
func ApiDestinationHttpMethod_Values() []string {
	return []string{
		ApiDestinationHttpMethodPost,
		ApiDestinationHttpMethodGet,
		ApiDestinationHttpMethodHead,
		ApiDestinationHttpMethodOptions,
		ApiDestinationHttpMethodPut,
		ApiDestinationHttpMethodPatch,
		ApiDestinationHttpMethodDelete,
	}
}

const (
	// ApiDestinationStateActive is a ApiDestinationState enum value
	ApiDestinationStateActive = "ACTIVE"

	// ApiDestinationStateInactive is a ApiDestinationState enum value
	ApiDestinationStateInactive = "INACTIVE"
)

// ApiDestinationState_Values returns all elements of the ApiDestinationState enum
func ApiDestinationState_Values() []string {
	return []string{
		ApiDestinationStateActive,
		ApiDestinationStateInactive,
	}
}

const (
	// ArchiveStateEnabled is a ArchiveState enum value
	ArchiveStateEnabled = "ENABLED"

	// ArchiveStateDisabled is a ArchiveState enum value
	ArchiveStateDisabled = "DISABLED"

	// ArchiveStateCreating is a ArchiveState enum value
	ArchiveStateCreating = "CREATING"

	// ArchiveStateUpdating is a ArchiveState enum value
	ArchiveStateUpdating = "UPDATING"

	// ArchiveStateCreateFailed is a ArchiveState enum value
	ArchiveStateCreateFailed = "CREATE_FAILED"

	// ArchiveStateUpdateFailed is a ArchiveState enum value
	ArchiveStateUpdateFailed = "UPDATE_FAILED"
)

// ArchiveState_Values returns all elements of the ArchiveState enum
func ArchiveState_Values() []string {
	return []string{
		ArchiveStateEnabled,
		ArchiveStateDisabled,
		ArchiveStateCreating,
		ArchiveStateUpdating,
		ArchiveStateCreateFailed,
		ArchiveStateUpdateFailed,
	}
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

// AssignPublicIp_Values returns all elements of the AssignPublicIp enum
func AssignPublicIp_Values() []string {
	return []string{
		AssignPublicIpEnabled,
		AssignPublicIpDisabled,
	}
}

const (
	// ConnectionAuthorizationTypeBasic is a ConnectionAuthorizationType enum value
	ConnectionAuthorizationTypeBasic = "BASIC"

	// ConnectionAuthorizationTypeOauthClientCredentials is a ConnectionAuthorizationType enum value
	ConnectionAuthorizationTypeOauthClientCredentials = "OAUTH_CLIENT_CREDENTIALS"

	// ConnectionAuthorizationTypeApiKey is a ConnectionAuthorizationType enum value
	ConnectionAuthorizationTypeApiKey = "API_KEY"
)

// ConnectionAuthorizationType_Values returns all elements of the ConnectionAuthorizationType enum
func ConnectionAuthorizationType_Values() []string {
	return []string{
		ConnectionAuthorizationTypeBasic,
		ConnectionAuthorizationTypeOauthClientCredentials,
		ConnectionAuthorizationTypeApiKey,
	}
}

const (
	// ConnectionOAuthHttpMethodGet is a ConnectionOAuthHttpMethod enum value
	ConnectionOAuthHttpMethodGet = "GET"

	// ConnectionOAuthHttpMethodPost is a ConnectionOAuthHttpMethod enum value
	ConnectionOAuthHttpMethodPost = "POST"

	// ConnectionOAuthHttpMethodPut is a ConnectionOAuthHttpMethod enum value
	ConnectionOAuthHttpMethodPut = "PUT"
)

// ConnectionOAuthHttpMethod_Values returns all elements of the ConnectionOAuthHttpMethod enum
func ConnectionOAuthHttpMethod_Values() []string {
	return []string{
		ConnectionOAuthHttpMethodGet,
		ConnectionOAuthHttpMethodPost,
		ConnectionOAuthHttpMethodPut,
	}
}

const (
	// ConnectionStateCreating is a ConnectionState enum value
	ConnectionStateCreating = "CREATING"

	// ConnectionStateUpdating is a ConnectionState enum value
	ConnectionStateUpdating = "UPDATING"

	// ConnectionStateDeleting is a ConnectionState enum value
	ConnectionStateDeleting = "DELETING"

	// ConnectionStateAuthorized is a ConnectionState enum value
	ConnectionStateAuthorized = "AUTHORIZED"

	// ConnectionStateDeauthorized is a ConnectionState enum value
	ConnectionStateDeauthorized = "DEAUTHORIZED"

	// ConnectionStateAuthorizing is a ConnectionState enum value
	ConnectionStateAuthorizing = "AUTHORIZING"

	// ConnectionStateDeauthorizing is a ConnectionState enum value
	ConnectionStateDeauthorizing = "DEAUTHORIZING"
)

// ConnectionState_Values returns all elements of the ConnectionState enum
func ConnectionState_Values() []string {
	return []string{
		ConnectionStateCreating,
		ConnectionStateUpdating,
		ConnectionStateDeleting,
		ConnectionStateAuthorized,
		ConnectionStateDeauthorized,
		ConnectionStateAuthorizing,
		ConnectionStateDeauthorizing,
	}
}

const (
	// EndpointStateActive is a EndpointState enum value
	EndpointStateActive = "ACTIVE"

	// EndpointStateCreating is a EndpointState enum value
	EndpointStateCreating = "CREATING"

	// EndpointStateUpdating is a EndpointState enum value
	EndpointStateUpdating = "UPDATING"

	// EndpointStateDeleting is a EndpointState enum value
	EndpointStateDeleting = "DELETING"

	// EndpointStateCreateFailed is a EndpointState enum value
	EndpointStateCreateFailed = "CREATE_FAILED"

	// EndpointStateUpdateFailed is a EndpointState enum value
	EndpointStateUpdateFailed = "UPDATE_FAILED"

	// EndpointStateDeleteFailed is a EndpointState enum value
	EndpointStateDeleteFailed = "DELETE_FAILED"
)

// EndpointState_Values returns all elements of the EndpointState enum
func EndpointState_Values() []string {
	return []string{
		EndpointStateActive,
		EndpointStateCreating,
		EndpointStateUpdating,
		EndpointStateDeleting,
		EndpointStateCreateFailed,
		EndpointStateUpdateFailed,
		EndpointStateDeleteFailed,
	}
}

const (
	// EventSourceStatePending is a EventSourceState enum value
	EventSourceStatePending = "PENDING"

	// EventSourceStateActive is a EventSourceState enum value
	EventSourceStateActive = "ACTIVE"

	// EventSourceStateDeleted is a EventSourceState enum value
	EventSourceStateDeleted = "DELETED"
)

// EventSourceState_Values returns all elements of the EventSourceState enum
func EventSourceState_Values() []string {
	return []string{
		EventSourceStatePending,
		EventSourceStateActive,
		EventSourceStateDeleted,
	}
}

const (
	// LaunchTypeEc2 is a LaunchType enum value
	LaunchTypeEc2 = "EC2"

	// LaunchTypeFargate is a LaunchType enum value
	LaunchTypeFargate = "FARGATE"

	// LaunchTypeExternal is a LaunchType enum value
	LaunchTypeExternal = "EXTERNAL"
)

// LaunchType_Values returns all elements of the LaunchType enum
func LaunchType_Values() []string {
	return []string{
		LaunchTypeEc2,
		LaunchTypeFargate,
		LaunchTypeExternal,
	}
}

const (
	// PlacementConstraintTypeDistinctInstance is a PlacementConstraintType enum value
	PlacementConstraintTypeDistinctInstance = "distinctInstance"

	// PlacementConstraintTypeMemberOf is a PlacementConstraintType enum value
	PlacementConstraintTypeMemberOf = "memberOf"
)

// PlacementConstraintType_Values returns all elements of the PlacementConstraintType enum
func PlacementConstraintType_Values() []string {
	return []string{
		PlacementConstraintTypeDistinctInstance,
		PlacementConstraintTypeMemberOf,
	}
}

const (
	// PlacementStrategyTypeRandom is a PlacementStrategyType enum value
	PlacementStrategyTypeRandom = "random"

	// PlacementStrategyTypeSpread is a PlacementStrategyType enum value
	PlacementStrategyTypeSpread = "spread"

	// PlacementStrategyTypeBinpack is a PlacementStrategyType enum value
	PlacementStrategyTypeBinpack = "binpack"
)

// PlacementStrategyType_Values returns all elements of the PlacementStrategyType enum
func PlacementStrategyType_Values() []string {
	return []string{
		PlacementStrategyTypeRandom,
		PlacementStrategyTypeSpread,
		PlacementStrategyTypeBinpack,
	}
}

const (
	// PropagateTagsTaskDefinition is a PropagateTags enum value
	PropagateTagsTaskDefinition = "TASK_DEFINITION"
)

// PropagateTags_Values returns all elements of the PropagateTags enum
func PropagateTags_Values() []string {
	return []string{
		PropagateTagsTaskDefinition,
	}
}

const (
	// ReplayStateStarting is a ReplayState enum value
	ReplayStateStarting = "STARTING"

	// ReplayStateRunning is a ReplayState enum value
	ReplayStateRunning = "RUNNING"

	// ReplayStateCancelling is a ReplayState enum value
	ReplayStateCancelling = "CANCELLING"

	// ReplayStateCompleted is a ReplayState enum value
	ReplayStateCompleted = "COMPLETED"

	// ReplayStateCancelled is a ReplayState enum value
	ReplayStateCancelled = "CANCELLED"

	// ReplayStateFailed is a ReplayState enum value
	ReplayStateFailed = "FAILED"
)

// ReplayState_Values returns all elements of the ReplayState enum
func ReplayState_Values() []string {
	return []string{
		ReplayStateStarting,
		ReplayStateRunning,
		ReplayStateCancelling,
		ReplayStateCompleted,
		ReplayStateCancelled,
		ReplayStateFailed,
	}
}

const (
	// ReplicationStateEnabled is a ReplicationState enum value
	ReplicationStateEnabled = "ENABLED"

	// ReplicationStateDisabled is a ReplicationState enum value
	ReplicationStateDisabled = "DISABLED"
)

// ReplicationState_Values returns all elements of the ReplicationState enum
func ReplicationState_Values() []string {
	return []string{
		ReplicationStateEnabled,
		ReplicationStateDisabled,
	}
}

const (
	// RuleStateEnabled is a RuleState enum value
	RuleStateEnabled = "ENABLED"

	// RuleStateDisabled is a RuleState enum value
	RuleStateDisabled = "DISABLED"
)

// RuleState_Values returns all elements of the RuleState enum
func RuleState_Values() []string {
	return []string{
		RuleStateEnabled,
		RuleStateDisabled,
	}
}
