// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package timestreamqueryiface provides an interface to enable mocking the Amazon Timestream Query service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package timestreamqueryiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/timestreamquery"
)

// TimestreamQueryAPI provides an interface to enable mocking the
// timestreamquery.TimestreamQuery service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Timestream Query.
//	func myFunc(svc timestreamqueryiface.TimestreamQueryAPI) bool {
//	    // Make svc.CancelQuery request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := timestreamquery.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockTimestreamQueryClient struct {
//	    timestreamqueryiface.TimestreamQueryAPI
//	}
//	func (m *mockTimestreamQueryClient) CancelQuery(input *timestreamquery.CancelQueryInput) (*timestreamquery.CancelQueryOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockTimestreamQueryClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type TimestreamQueryAPI interface {
	CancelQuery(*timestreamquery.CancelQueryInput) (*timestreamquery.CancelQueryOutput, error)
	CancelQueryWithContext(aws.Context, *timestreamquery.CancelQueryInput, ...request.Option) (*timestreamquery.CancelQueryOutput, error)
	CancelQueryRequest(*timestreamquery.CancelQueryInput) (*request.Request, *timestreamquery.CancelQueryOutput)

	CreateScheduledQuery(*timestreamquery.CreateScheduledQueryInput) (*timestreamquery.CreateScheduledQueryOutput, error)
	CreateScheduledQueryWithContext(aws.Context, *timestreamquery.CreateScheduledQueryInput, ...request.Option) (*timestreamquery.CreateScheduledQueryOutput, error)
	CreateScheduledQueryRequest(*timestreamquery.CreateScheduledQueryInput) (*request.Request, *timestreamquery.CreateScheduledQueryOutput)

	DeleteScheduledQuery(*timestreamquery.DeleteScheduledQueryInput) (*timestreamquery.DeleteScheduledQueryOutput, error)
	DeleteScheduledQueryWithContext(aws.Context, *timestreamquery.DeleteScheduledQueryInput, ...request.Option) (*timestreamquery.DeleteScheduledQueryOutput, error)
	DeleteScheduledQueryRequest(*timestreamquery.DeleteScheduledQueryInput) (*request.Request, *timestreamquery.DeleteScheduledQueryOutput)

	DescribeEndpoints(*timestreamquery.DescribeEndpointsInput) (*timestreamquery.DescribeEndpointsOutput, error)
	DescribeEndpointsWithContext(aws.Context, *timestreamquery.DescribeEndpointsInput, ...request.Option) (*timestreamquery.DescribeEndpointsOutput, error)
	DescribeEndpointsRequest(*timestreamquery.DescribeEndpointsInput) (*request.Request, *timestreamquery.DescribeEndpointsOutput)

	DescribeScheduledQuery(*timestreamquery.DescribeScheduledQueryInput) (*timestreamquery.DescribeScheduledQueryOutput, error)
	DescribeScheduledQueryWithContext(aws.Context, *timestreamquery.DescribeScheduledQueryInput, ...request.Option) (*timestreamquery.DescribeScheduledQueryOutput, error)
	DescribeScheduledQueryRequest(*timestreamquery.DescribeScheduledQueryInput) (*request.Request, *timestreamquery.DescribeScheduledQueryOutput)

	ExecuteScheduledQuery(*timestreamquery.ExecuteScheduledQueryInput) (*timestreamquery.ExecuteScheduledQueryOutput, error)
	ExecuteScheduledQueryWithContext(aws.Context, *timestreamquery.ExecuteScheduledQueryInput, ...request.Option) (*timestreamquery.ExecuteScheduledQueryOutput, error)
	ExecuteScheduledQueryRequest(*timestreamquery.ExecuteScheduledQueryInput) (*request.Request, *timestreamquery.ExecuteScheduledQueryOutput)

	ListScheduledQueries(*timestreamquery.ListScheduledQueriesInput) (*timestreamquery.ListScheduledQueriesOutput, error)
	ListScheduledQueriesWithContext(aws.Context, *timestreamquery.ListScheduledQueriesInput, ...request.Option) (*timestreamquery.ListScheduledQueriesOutput, error)
	ListScheduledQueriesRequest(*timestreamquery.ListScheduledQueriesInput) (*request.Request, *timestreamquery.ListScheduledQueriesOutput)

	ListScheduledQueriesPages(*timestreamquery.ListScheduledQueriesInput, func(*timestreamquery.ListScheduledQueriesOutput, bool) bool) error
	ListScheduledQueriesPagesWithContext(aws.Context, *timestreamquery.ListScheduledQueriesInput, func(*timestreamquery.ListScheduledQueriesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*timestreamquery.ListTagsForResourceInput) (*timestreamquery.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *timestreamquery.ListTagsForResourceInput, ...request.Option) (*timestreamquery.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*timestreamquery.ListTagsForResourceInput) (*request.Request, *timestreamquery.ListTagsForResourceOutput)

	ListTagsForResourcePages(*timestreamquery.ListTagsForResourceInput, func(*timestreamquery.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *timestreamquery.ListTagsForResourceInput, func(*timestreamquery.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	PrepareQuery(*timestreamquery.PrepareQueryInput) (*timestreamquery.PrepareQueryOutput, error)
	PrepareQueryWithContext(aws.Context, *timestreamquery.PrepareQueryInput, ...request.Option) (*timestreamquery.PrepareQueryOutput, error)
	PrepareQueryRequest(*timestreamquery.PrepareQueryInput) (*request.Request, *timestreamquery.PrepareQueryOutput)

	Query(*timestreamquery.QueryInput) (*timestreamquery.QueryOutput, error)
	QueryWithContext(aws.Context, *timestreamquery.QueryInput, ...request.Option) (*timestreamquery.QueryOutput, error)
	QueryRequest(*timestreamquery.QueryInput) (*request.Request, *timestreamquery.QueryOutput)

	QueryPages(*timestreamquery.QueryInput, func(*timestreamquery.QueryOutput, bool) bool) error
	QueryPagesWithContext(aws.Context, *timestreamquery.QueryInput, func(*timestreamquery.QueryOutput, bool) bool, ...request.Option) error

	TagResource(*timestreamquery.TagResourceInput) (*timestreamquery.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *timestreamquery.TagResourceInput, ...request.Option) (*timestreamquery.TagResourceOutput, error)
	TagResourceRequest(*timestreamquery.TagResourceInput) (*request.Request, *timestreamquery.TagResourceOutput)

	UntagResource(*timestreamquery.UntagResourceInput) (*timestreamquery.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *timestreamquery.UntagResourceInput, ...request.Option) (*timestreamquery.UntagResourceOutput, error)
	UntagResourceRequest(*timestreamquery.UntagResourceInput) (*request.Request, *timestreamquery.UntagResourceOutput)

	UpdateScheduledQuery(*timestreamquery.UpdateScheduledQueryInput) (*timestreamquery.UpdateScheduledQueryOutput, error)
	UpdateScheduledQueryWithContext(aws.Context, *timestreamquery.UpdateScheduledQueryInput, ...request.Option) (*timestreamquery.UpdateScheduledQueryOutput, error)
	UpdateScheduledQueryRequest(*timestreamquery.UpdateScheduledQueryInput) (*request.Request, *timestreamquery.UpdateScheduledQueryOutput)
}

var _ TimestreamQueryAPI = (*timestreamquery.TimestreamQuery)(nil)
