// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package scheduler

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSchedule = "CreateSchedule"

// CreateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchedule for more information on using the CreateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateScheduleRequest method.
//	req, resp := client.CreateScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateSchedule
func (c *Scheduler) CreateScheduleRequest(input *CreateScheduleInput) (req *request.Request, output *CreateScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/schedules/{Name}",
	}

	if input == nil {
		input = &CreateScheduleInput{}
	}

	output = &CreateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchedule API operation for Amazon EventBridge Scheduler.
//
// Creates the specified schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation CreateSchedule for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateSchedule
func (c *Scheduler) CreateSchedule(input *CreateScheduleInput) (*CreateScheduleOutput, error) {
	req, out := c.CreateScheduleRequest(input)
	return out, req.Send()
}

// CreateScheduleWithContext is the same as CreateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) CreateScheduleWithContext(ctx aws.Context, input *CreateScheduleInput, opts ...request.Option) (*CreateScheduleOutput, error) {
	req, out := c.CreateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduleGroup = "CreateScheduleGroup"

// CreateScheduleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduleGroup for more information on using the CreateScheduleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateScheduleGroupRequest method.
//	req, resp := client.CreateScheduleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateScheduleGroup
func (c *Scheduler) CreateScheduleGroupRequest(input *CreateScheduleGroupInput) (req *request.Request, output *CreateScheduleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateScheduleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/schedule-groups/{Name}",
	}

	if input == nil {
		input = &CreateScheduleGroupInput{}
	}

	output = &CreateScheduleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScheduleGroup API operation for Amazon EventBridge Scheduler.
//
// Creates the specified schedule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation CreateScheduleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeds a service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/CreateScheduleGroup
func (c *Scheduler) CreateScheduleGroup(input *CreateScheduleGroupInput) (*CreateScheduleGroupOutput, error) {
	req, out := c.CreateScheduleGroupRequest(input)
	return out, req.Send()
}

// CreateScheduleGroupWithContext is the same as CreateScheduleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) CreateScheduleGroupWithContext(ctx aws.Context, input *CreateScheduleGroupInput, opts ...request.Option) (*CreateScheduleGroupOutput, error) {
	req, out := c.CreateScheduleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchedule = "DeleteSchedule"

// DeleteScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchedule for more information on using the DeleteSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScheduleRequest method.
//	req, resp := client.DeleteScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteSchedule
func (c *Scheduler) DeleteScheduleRequest(input *DeleteScheduleInput) (req *request.Request, output *DeleteScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/schedules/{Name}",
	}

	if input == nil {
		input = &DeleteScheduleInput{}
	}

	output = &DeleteScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchedule API operation for Amazon EventBridge Scheduler.
//
// Deletes the specified schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation DeleteSchedule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteSchedule
func (c *Scheduler) DeleteSchedule(input *DeleteScheduleInput) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	return out, req.Send()
}

// DeleteScheduleWithContext is the same as DeleteSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) DeleteScheduleWithContext(ctx aws.Context, input *DeleteScheduleInput, opts ...request.Option) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduleGroup = "DeleteScheduleGroup"

// DeleteScheduleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduleGroup for more information on using the DeleteScheduleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScheduleGroupRequest method.
//	req, resp := client.DeleteScheduleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteScheduleGroup
func (c *Scheduler) DeleteScheduleGroupRequest(input *DeleteScheduleGroupInput) (req *request.Request, output *DeleteScheduleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduleGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/schedule-groups/{Name}",
	}

	if input == nil {
		input = &DeleteScheduleGroupInput{}
	}

	output = &DeleteScheduleGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduleGroup API operation for Amazon EventBridge Scheduler.
//
// Deletes the specified schedule group. Deleting a schedule group results in
// EventBridge Scheduler deleting all schedules associated with the group. When
// you delete a group, it remains in a DELETING state until all of its associated
// schedules are deleted. Schedules associated with the group that are set to
// run while the schedule group is in the process of being deleted might continue
// to invoke their targets until the schedule group and its associated schedules
// are deleted.
//
// This operation is eventually consistent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation DeleteScheduleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/DeleteScheduleGroup
func (c *Scheduler) DeleteScheduleGroup(input *DeleteScheduleGroupInput) (*DeleteScheduleGroupOutput, error) {
	req, out := c.DeleteScheduleGroupRequest(input)
	return out, req.Send()
}

// DeleteScheduleGroupWithContext is the same as DeleteScheduleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) DeleteScheduleGroupWithContext(ctx aws.Context, input *DeleteScheduleGroupInput, opts ...request.Option) (*DeleteScheduleGroupOutput, error) {
	req, out := c.DeleteScheduleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchedule = "GetSchedule"

// GetScheduleRequest generates a "aws/request.Request" representing the
// client's request for the GetSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchedule for more information on using the GetSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetScheduleRequest method.
//	req, resp := client.GetScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetSchedule
func (c *Scheduler) GetScheduleRequest(input *GetScheduleInput) (req *request.Request, output *GetScheduleOutput) {
	op := &request.Operation{
		Name:       opGetSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/schedules/{Name}",
	}

	if input == nil {
		input = &GetScheduleInput{}
	}

	output = &GetScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchedule API operation for Amazon EventBridge Scheduler.
//
// Retrieves the specified schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation GetSchedule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetSchedule
func (c *Scheduler) GetSchedule(input *GetScheduleInput) (*GetScheduleOutput, error) {
	req, out := c.GetScheduleRequest(input)
	return out, req.Send()
}

// GetScheduleWithContext is the same as GetSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) GetScheduleWithContext(ctx aws.Context, input *GetScheduleInput, opts ...request.Option) (*GetScheduleOutput, error) {
	req, out := c.GetScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetScheduleGroup = "GetScheduleGroup"

// GetScheduleGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetScheduleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScheduleGroup for more information on using the GetScheduleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetScheduleGroupRequest method.
//	req, resp := client.GetScheduleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetScheduleGroup
func (c *Scheduler) GetScheduleGroupRequest(input *GetScheduleGroupInput) (req *request.Request, output *GetScheduleGroupOutput) {
	op := &request.Operation{
		Name:       opGetScheduleGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/schedule-groups/{Name}",
	}

	if input == nil {
		input = &GetScheduleGroupInput{}
	}

	output = &GetScheduleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScheduleGroup API operation for Amazon EventBridge Scheduler.
//
// Retrieves the specified schedule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation GetScheduleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/GetScheduleGroup
func (c *Scheduler) GetScheduleGroup(input *GetScheduleGroupInput) (*GetScheduleGroupOutput, error) {
	req, out := c.GetScheduleGroupRequest(input)
	return out, req.Send()
}

// GetScheduleGroupWithContext is the same as GetScheduleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetScheduleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) GetScheduleGroupWithContext(ctx aws.Context, input *GetScheduleGroupInput, opts ...request.Option) (*GetScheduleGroupOutput, error) {
	req, out := c.GetScheduleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListScheduleGroups = "ListScheduleGroups"

// ListScheduleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduleGroups for more information on using the ListScheduleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScheduleGroupsRequest method.
//	req, resp := client.ListScheduleGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups
func (c *Scheduler) ListScheduleGroupsRequest(input *ListScheduleGroupsInput) (req *request.Request, output *ListScheduleGroupsOutput) {
	op := &request.Operation{
		Name:       opListScheduleGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/schedule-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScheduleGroupsInput{}
	}

	output = &ListScheduleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScheduleGroups API operation for Amazon EventBridge Scheduler.
//
// Returns a paginated list of your schedule groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation ListScheduleGroups for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListScheduleGroups
func (c *Scheduler) ListScheduleGroups(input *ListScheduleGroupsInput) (*ListScheduleGroupsOutput, error) {
	req, out := c.ListScheduleGroupsRequest(input)
	return out, req.Send()
}

// ListScheduleGroupsWithContext is the same as ListScheduleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) ListScheduleGroupsWithContext(ctx aws.Context, input *ListScheduleGroupsInput, opts ...request.Option) (*ListScheduleGroupsOutput, error) {
	req, out := c.ListScheduleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScheduleGroupsPages iterates over the pages of a ListScheduleGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScheduleGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScheduleGroups operation.
//	pageNum := 0
//	err := client.ListScheduleGroupsPages(params,
//	    func(page *scheduler.ListScheduleGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Scheduler) ListScheduleGroupsPages(input *ListScheduleGroupsInput, fn func(*ListScheduleGroupsOutput, bool) bool) error {
	return c.ListScheduleGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScheduleGroupsPagesWithContext same as ListScheduleGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) ListScheduleGroupsPagesWithContext(ctx aws.Context, input *ListScheduleGroupsInput, fn func(*ListScheduleGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScheduleGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScheduleGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScheduleGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchedules = "ListSchedules"

// ListSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchedules for more information on using the ListSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchedulesRequest method.
//	req, resp := client.ListSchedulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules
func (c *Scheduler) ListSchedulesRequest(input *ListSchedulesInput) (req *request.Request, output *ListSchedulesOutput) {
	op := &request.Operation{
		Name:       opListSchedules,
		HTTPMethod: "GET",
		HTTPPath:   "/schedules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchedulesInput{}
	}

	output = &ListSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchedules API operation for Amazon EventBridge Scheduler.
//
// Returns a paginated list of your EventBridge Scheduler schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation ListSchedules for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListSchedules
func (c *Scheduler) ListSchedules(input *ListSchedulesInput) (*ListSchedulesOutput, error) {
	req, out := c.ListSchedulesRequest(input)
	return out, req.Send()
}

// ListSchedulesWithContext is the same as ListSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) ListSchedulesWithContext(ctx aws.Context, input *ListSchedulesInput, opts ...request.Option) (*ListSchedulesOutput, error) {
	req, out := c.ListSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchedulesPages iterates over the pages of a ListSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchedules operation.
//	pageNum := 0
//	err := client.ListSchedulesPages(params,
//	    func(page *scheduler.ListSchedulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Scheduler) ListSchedulesPages(input *ListSchedulesInput, fn func(*ListSchedulesOutput, bool) bool) error {
	return c.ListSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchedulesPagesWithContext same as ListSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) ListSchedulesPagesWithContext(ctx aws.Context, input *ListSchedulesInput, fn func(*ListSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListTagsForResource
func (c *Scheduler) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon EventBridge Scheduler.
//
// Lists the tags associated with the Scheduler resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/ListTagsForResource
func (c *Scheduler) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/TagResource
func (c *Scheduler) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon EventBridge Scheduler.
//
// Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler
// resource. You can only assign tags to schedule groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/TagResource
func (c *Scheduler) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UntagResource
func (c *Scheduler) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon EventBridge Scheduler.
//
// Removes one or more tags from the specified EventBridge Scheduler schedule
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UntagResource
func (c *Scheduler) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchedule = "UpdateSchedule"

// UpdateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchedule for more information on using the UpdateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateScheduleRequest method.
//	req, resp := client.UpdateScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UpdateSchedule
func (c *Scheduler) UpdateScheduleRequest(input *UpdateScheduleInput) (req *request.Request, output *UpdateScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/schedules/{Name}",
	}

	if input == nil {
		input = &UpdateScheduleInput{}
	}

	output = &UpdateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchedule API operation for Amazon EventBridge Scheduler.
//
// Updates the specified schedule. When you call UpdateSchedule, EventBridge
// Scheduler uses all values, including empty values, specified in the request
// and overrides the existing schedule. This is by design. This means that if
// you do not set an optional field in your request, that field will be set
// to its system-default value after the update.
//
// Before calling this operation, we recommend that you call the GetSchedule
// API operation and make a note of all optional parameters for your UpdateSchedule
// call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Scheduler's
// API operation UpdateSchedule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - InternalServerException
//     Unexpected error encountered while processing the request.
//
//   - ConflictException
//     Updating or deleting the resource can cause an inconsistent state.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/scheduler-2021-06-30/UpdateSchedule
func (c *Scheduler) UpdateSchedule(input *UpdateScheduleInput) (*UpdateScheduleOutput, error) {
	req, out := c.UpdateScheduleRequest(input)
	return out, req.Send()
}

// UpdateScheduleWithContext is the same as UpdateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Scheduler) UpdateScheduleWithContext(ctx aws.Context, input *UpdateScheduleInput, opts ...request.Option) (*UpdateScheduleOutput, error) {
	req, out := c.UpdateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This structure specifies the VPC subnets and security groups for the task,
// and whether a public IP address is to be used. This structure is relevant
// only for ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the task's elastic network interface receives a public
	// IP address. You can specify ENABLED only when LaunchType in EcsParameters
	// is set to FARGATE.
	AssignPublicIp *string `type:"string" enum:"AssignPublicIp"`

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups.
	// If you do not specify a security group, the default security group for the
	// VPC is used.
	SecurityGroups []*string `min:"1" type:"list"`

	// Specifies the subnets associated with the task. These subnets must all be
	// in the same VPC. You can specify as many as 16 subnets.
	//
	// Subnets is a required field
	Subnets []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsVpcConfiguration"}
	if s.SecurityGroups != nil && len(s.SecurityGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroups", 1))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsVpcConfiguration) SetAssignPublicIp(v string) *AwsVpcConfiguration {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsVpcConfiguration) SetSecurityGroups(v []*string) *AwsVpcConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsVpcConfiguration) SetSubnets(v []*string) *AwsVpcConfiguration {
	s.Subnets = v
	return s
}

// The details of a capacity provider strategy.
type CapacityProviderStrategyItem struct {
	_ struct{} `type:"structure"`

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0
	// is used.
	Base *int64 `locationName:"base" type:"integer"`

	// The short name of the capacity provider.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" min:"1" type:"string" required:"true"`

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider. The weight
	// value is taken into consideration after the base value, if defined, is satisfied.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityProviderStrategyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityProviderStrategyItem"}
	if s.CapacityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProvider"))
	}
	if s.CapacityProvider != nil && len(*s.CapacityProvider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapacityProvider", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBase sets the Base field's value.
func (s *CapacityProviderStrategyItem) SetBase(v int64) *CapacityProviderStrategyItem {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *CapacityProviderStrategyItem) SetCapacityProvider(v string) *CapacityProviderStrategyItem {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CapacityProviderStrategyItem) SetWeight(v int64) *CapacityProviderStrategyItem {
	s.Weight = &v
	return s
}

// Updating or deleting the resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateScheduleGroupInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you do not specify a client token, EventBridge Scheduler
	// uses a randomly generated token for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the schedule group that you are creating.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The list of tags to associate with the schedule group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduleGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateScheduleGroupInput) SetClientToken(v string) *CreateScheduleGroupInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateScheduleGroupInput) SetName(v string) *CreateScheduleGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScheduleGroupInput) SetTags(v []*Tag) *CreateScheduleGroupInput {
	s.Tags = v
	return s
}

type CreateScheduleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule group.
	//
	// ScheduleGroupArn is a required field
	ScheduleGroupArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleGroupOutput) GoString() string {
	return s.String()
}

// SetScheduleGroupArn sets the ScheduleGroupArn field's value.
func (s *CreateScheduleGroupOutput) SetScheduleGroupArn(v string) *CreateScheduleGroupOutput {
	s.ScheduleGroupArn = &v
	return s
}

type CreateScheduleInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you do not specify a client token, EventBridge Scheduler
	// uses a randomly generated token for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description you specify for the schedule.
	Description *string `type:"string"`

	// The date, in UTC, before which the schedule can invoke its target. Depending
	// on the schedule's recurrence expression, invocations might stop on, or before,
	// the EndDate you specify. EventBridge Scheduler ignores EndDate for one-time
	// schedules.
	EndDate *time.Time `type:"timestamp"`

	// Allows you to configure a time window during which EventBridge Scheduler
	// invokes the schedule.
	//
	// FlexibleTimeWindow is a required field
	FlexibleTimeWindow *FlexibleTimeWindow `type:"structure" required:"true"`

	// The name of the schedule group to associate with this schedule. If you omit
	// this, the default schedule group is used.
	GroupName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge
	// Scheduler will use to encrypt and decrypt your data.
	KmsKeyArn *string `min:"1" type:"string"`

	// The name of the schedule that you are creating.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The expression that defines when the schedule runs. The following formats
	// are supported.
	//
	//    * at expression - at(yyyy-mm-ddThh:mm:ss)
	//
	//    * rate expression - rate(unit value)
	//
	//    * cron expression - cron(fields)
	//
	// You can use at expressions to create one-time schedules that invoke a target
	// once, at the time and in the time zone, that you specify. You can use rate
	// and cron expressions to create recurring schedules. Rate-based schedules
	// are useful when you want to invoke a target at regular intervals, such as
	// every 15 minutes or every five days. Cron-based schedules are useful when
	// you want to invoke a target periodically at a specific time, such as at 8:00
	// am (UTC+0) every 1st day of the month.
	//
	// A cron expression consists of six fields separated by white spaces: (minutes
	// hours day_of_month month day_of_week year).
	//
	// A rate expression consists of a value as a positive integer, and a unit with
	// the following options: minute | minutes | hour | hours | day | days
	//
	// For more information and examples, see Schedule types on EventBridge Scheduler
	// (https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html)
	// in the EventBridge Scheduler User Guide.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `min:"1" type:"string" required:"true"`

	// The timezone in which the scheduling expression is evaluated.
	ScheduleExpressionTimezone *string `min:"1" type:"string"`

	// The date, in UTC, after which the schedule can begin invoking its target.
	// Depending on the schedule's recurrence expression, invocations might occur
	// on, or after, the StartDate you specify. EventBridge Scheduler ignores StartDate
	// for one-time schedules.
	StartDate *time.Time `type:"timestamp"`

	// Specifies whether the schedule is enabled or disabled.
	State *string `type:"string" enum:"ScheduleState"`

	// The schedule's target.
	//
	// Target is a required field
	Target *Target `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduleInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FlexibleTimeWindow == nil {
		invalidParams.Add(request.NewErrParamRequired("FlexibleTimeWindow"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.ScheduleExpressionTimezone != nil && len(*s.ScheduleExpressionTimezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpressionTimezone", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.FlexibleTimeWindow != nil {
		if err := s.FlexibleTimeWindow.Validate(); err != nil {
			invalidParams.AddNested("FlexibleTimeWindow", err.(request.ErrInvalidParams))
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateScheduleInput) SetClientToken(v string) *CreateScheduleInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateScheduleInput) SetDescription(v string) *CreateScheduleInput {
	s.Description = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *CreateScheduleInput) SetEndDate(v time.Time) *CreateScheduleInput {
	s.EndDate = &v
	return s
}

// SetFlexibleTimeWindow sets the FlexibleTimeWindow field's value.
func (s *CreateScheduleInput) SetFlexibleTimeWindow(v *FlexibleTimeWindow) *CreateScheduleInput {
	s.FlexibleTimeWindow = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateScheduleInput) SetGroupName(v string) *CreateScheduleInput {
	s.GroupName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateScheduleInput) SetKmsKeyArn(v string) *CreateScheduleInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateScheduleInput) SetName(v string) *CreateScheduleInput {
	s.Name = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *CreateScheduleInput) SetScheduleExpression(v string) *CreateScheduleInput {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *CreateScheduleInput) SetScheduleExpressionTimezone(v string) *CreateScheduleInput {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *CreateScheduleInput) SetStartDate(v time.Time) *CreateScheduleInput {
	s.StartDate = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateScheduleInput) SetState(v string) *CreateScheduleInput {
	s.State = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateScheduleInput) SetTarget(v *Target) *CreateScheduleInput {
	s.Target = v
	return s
}

type CreateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule.
	//
	// ScheduleArn is a required field
	ScheduleArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduleOutput) GoString() string {
	return s.String()
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *CreateScheduleOutput) SetScheduleArn(v string) *CreateScheduleOutput {
	s.ScheduleArn = &v
	return s
}

// An object that contains information about an Amazon SQS queue that EventBridge
// Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge
// Scheduler delivers failed events that could not be successfully delivered
// to a target to the queue.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SQS queue specified as the destination
	// for the dead-letter queue.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeadLetterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeadLetterConfig"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeadLetterConfig) SetArn(v string) *DeadLetterConfig {
	s.Arn = &v
	return s
}

type DeleteScheduleGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you do not specify a client token, EventBridge Scheduler
	// uses a randomly generated token for the request to ensure idempotency.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the schedule group to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduleGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteScheduleGroupInput) SetClientToken(v string) *DeleteScheduleGroupInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteScheduleGroupInput) SetName(v string) *DeleteScheduleGroupInput {
	s.Name = &v
	return s
}

type DeleteScheduleGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleGroupOutput) GoString() string {
	return s.String()
}

type DeleteScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you do not specify a client token, EventBridge Scheduler
	// uses a randomly generated token for the request to ensure idempotency.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the schedule group associated with this schedule. If you omit
	// this, the default schedule group is used.
	GroupName *string `location:"querystring" locationName:"groupName" min:"1" type:"string"`

	// The name of the schedule to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduleInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteScheduleInput) SetClientToken(v string) *DeleteScheduleInput {
	s.ClientToken = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteScheduleInput) SetGroupName(v string) *DeleteScheduleInput {
	s.GroupName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteScheduleInput) SetName(v string) *DeleteScheduleInput {
	s.Name = &v
	return s
}

type DeleteScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) GoString() string {
	return s.String()
}

// The templated target type for the Amazon ECS RunTask (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html)
// API operation.
type EcsParameters struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the task.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `type:"list"`

	// Specifies whether to enable Amazon ECS managed tags for the task. For more
	// information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon ECS Developer Guide.
	EnableECSManagedTags *bool `type:"boolean"`

	// Whether or not to enable the execute command functionality for the containers
	// in this task. If true, this enables execute command functionality on all
	// containers in the task.
	EnableExecuteCommand *bool `type:"boolean"`

	// Specifies an ECS task group for the task. The maximum length is 255 characters.
	Group *string `min:"1" type:"string"`

	// Specifies the launch type on which your task is running. The launch type
	// that you specify here must match one of the launch type (compatibilities)
	// of the target task. The FARGATE value is supported only in the Regions where
	// Fargate with Amazon ECS is supported. For more information, see AWS Fargate
	// on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS_Fargate.html)
	// in the Amazon ECS Developer Guide.
	LaunchType *string `type:"string" enum:"LaunchType"`

	// This structure specifies the network configuration for an ECS task.
	NetworkConfiguration *NetworkConfiguration `type:"structure"`

	// An array of placement constraint objects to use for the task. You can specify
	// up to 10 constraints per task (including constraints in the task definition
	// and those specified at runtime).
	PlacementConstraints []*PlacementConstraint `type:"list"`

	// The task placement strategy for a task or service.
	PlacementStrategy []*PlacementStrategy `type:"list"`

	// Specifies the platform version for the task. Specify only the numeric portion
	// of the platform version, such as 1.1.0.
	PlatformVersion *string `min:"1" type:"string"`

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags are not propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation,
	// use Amazon ECS's TagResource (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html)
	// API action.
	PropagateTags *string `type:"string" enum:"PropagateTags"`

	// The reference ID to use for the task.
	ReferenceId *string `type:"string"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. For more information, see RunTask (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html)
	// in the Amazon ECS API Reference.
	Tags []map[string]*string `type:"list"`

	// The number of tasks to create based on TaskDefinition. The default is 1.
	TaskCount *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the task definition to use if the event
	// target is an Amazon ECS task.
	//
	// TaskDefinitionArn is a required field
	TaskDefinitionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsParameters"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.PlatformVersion != nil && len(*s.PlatformVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlatformVersion", 1))
	}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TaskCount", 1))
	}
	if s.TaskDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinitionArn"))
	}
	if s.TaskDefinitionArn != nil && len(*s.TaskDefinitionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskDefinitionArn", 1))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *EcsParameters) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *EcsParameters {
	s.CapacityProviderStrategy = v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *EcsParameters) SetEnableECSManagedTags(v bool) *EcsParameters {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *EcsParameters) SetEnableExecuteCommand(v bool) *EcsParameters {
	s.EnableExecuteCommand = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *EcsParameters) SetGroup(v string) *EcsParameters {
	s.Group = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *EcsParameters) SetLaunchType(v string) *EcsParameters {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *EcsParameters) SetNetworkConfiguration(v *NetworkConfiguration) *EcsParameters {
	s.NetworkConfiguration = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *EcsParameters) SetPlacementConstraints(v []*PlacementConstraint) *EcsParameters {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *EcsParameters) SetPlacementStrategy(v []*PlacementStrategy) *EcsParameters {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EcsParameters) SetPlatformVersion(v string) *EcsParameters {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *EcsParameters) SetPropagateTags(v string) *EcsParameters {
	s.PropagateTags = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *EcsParameters) SetReferenceId(v string) *EcsParameters {
	s.ReferenceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EcsParameters) SetTags(v []map[string]*string) *EcsParameters {
	s.Tags = v
	return s
}

// SetTaskCount sets the TaskCount field's value.
func (s *EcsParameters) SetTaskCount(v int64) *EcsParameters {
	s.TaskCount = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *EcsParameters) SetTaskDefinitionArn(v string) *EcsParameters {
	s.TaskDefinitionArn = &v
	return s
}

// The templated target type for the EventBridge PutEvents (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
// API operation.
type EventBridgeParameters struct {
	_ struct{} `type:"structure"`

	// A free-form string, with a maximum of 128 characters, used to decide what
	// fields to expect in the event detail.
	//
	// DetailType is a required field
	DetailType *string `min:"1" type:"string" required:"true"`

	// The source of the event.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventBridgeParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventBridgeParameters"}
	if s.DetailType == nil {
		invalidParams.Add(request.NewErrParamRequired("DetailType"))
	}
	if s.DetailType != nil && len(*s.DetailType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetailType", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetailType sets the DetailType field's value.
func (s *EventBridgeParameters) SetDetailType(v string) *EventBridgeParameters {
	s.DetailType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *EventBridgeParameters) SetSource(v string) *EventBridgeParameters {
	s.Source = &v
	return s
}

// Allows you to configure a time window during which EventBridge Scheduler
// invokes the schedule.
type FlexibleTimeWindow struct {
	_ struct{} `type:"structure"`

	// The maximum time window during which a schedule can be invoked.
	MaximumWindowInMinutes *int64 `min:"1" type:"integer"`

	// Determines whether the schedule is invoked within a flexible time window.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"FlexibleTimeWindowMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlexibleTimeWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlexibleTimeWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlexibleTimeWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlexibleTimeWindow"}
	if s.MaximumWindowInMinutes != nil && *s.MaximumWindowInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumWindowInMinutes", 1))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumWindowInMinutes sets the MaximumWindowInMinutes field's value.
func (s *FlexibleTimeWindow) SetMaximumWindowInMinutes(v int64) *FlexibleTimeWindow {
	s.MaximumWindowInMinutes = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *FlexibleTimeWindow) SetMode(v string) *FlexibleTimeWindow {
	s.Mode = &v
	return s
}

type GetScheduleGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schedule group to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScheduleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScheduleGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetScheduleGroupInput) SetName(v string) *GetScheduleGroupInput {
	s.Name = &v
	return s
}

type GetScheduleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule group.
	Arn *string `min:"1" type:"string"`

	// The time at which the schedule group was created.
	CreationDate *time.Time `type:"timestamp"`

	// The time at which the schedule group was last modified.
	LastModificationDate *time.Time `type:"timestamp"`

	// The name of the schedule group.
	Name *string `min:"1" type:"string"`

	// Specifies the state of the schedule group.
	State *string `type:"string" enum:"ScheduleGroupState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetScheduleGroupOutput) SetArn(v string) *GetScheduleGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetScheduleGroupOutput) SetCreationDate(v time.Time) *GetScheduleGroupOutput {
	s.CreationDate = &v
	return s
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *GetScheduleGroupOutput) SetLastModificationDate(v time.Time) *GetScheduleGroupOutput {
	s.LastModificationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetScheduleGroupOutput) SetName(v string) *GetScheduleGroupOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *GetScheduleGroupOutput) SetState(v string) *GetScheduleGroupOutput {
	s.State = &v
	return s
}

type GetScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schedule group associated with this schedule. If you omit
	// this, EventBridge Scheduler assumes that the schedule is associated with
	// the default group.
	GroupName *string `location:"querystring" locationName:"groupName" min:"1" type:"string"`

	// The name of the schedule to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScheduleInput"}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetScheduleInput) SetGroupName(v string) *GetScheduleInput {
	s.GroupName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetScheduleInput) SetName(v string) *GetScheduleInput {
	s.Name = &v
	return s
}

type GetScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule.
	Arn *string `min:"1" type:"string"`

	// The time at which the schedule was created.
	CreationDate *time.Time `type:"timestamp"`

	// The description of the schedule.
	Description *string `type:"string"`

	// The date, in UTC, before which the schedule can invoke its target. Depending
	// on the schedule's recurrence expression, invocations might stop on, or before,
	// the EndDate you specify. EventBridge Scheduler ignores EndDate for one-time
	// schedules.
	EndDate *time.Time `type:"timestamp"`

	// Allows you to configure a time window during which EventBridge Scheduler
	// invokes the schedule.
	FlexibleTimeWindow *FlexibleTimeWindow `type:"structure"`

	// The name of the schedule group associated with this schedule.
	GroupName *string `min:"1" type:"string"`

	// The ARN for a customer managed KMS Key that is be used to encrypt and decrypt
	// your data.
	KmsKeyArn *string `min:"1" type:"string"`

	// The time at which the schedule was last modified.
	LastModificationDate *time.Time `type:"timestamp"`

	// The name of the schedule.
	Name *string `min:"1" type:"string"`

	// The expression that defines when the schedule runs. The following formats
	// are supported.
	//
	//    * at expression - at(yyyy-mm-ddThh:mm:ss)
	//
	//    * rate expression - rate(unit value)
	//
	//    * cron expression - cron(fields)
	//
	// You can use at expressions to create one-time schedules that invoke a target
	// once, at the time and in the time zone, that you specify. You can use rate
	// and cron expressions to create recurring schedules. Rate-based schedules
	// are useful when you want to invoke a target at regular intervals, such as
	// every 15 minutes or every five days. Cron-based schedules are useful when
	// you want to invoke a target periodically at a specific time, such as at 8:00
	// am (UTC+0) every 1st day of the month.
	//
	// A cron expression consists of six fields separated by white spaces: (minutes
	// hours day_of_month month day_of_week year).
	//
	// A rate expression consists of a value as a positive integer, and a unit with
	// the following options: minute | minutes | hour | hours | day | days
	//
	// For more information and examples, see Schedule types on EventBridge Scheduler
	// (https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html)
	// in the EventBridge Scheduler User Guide.
	ScheduleExpression *string `min:"1" type:"string"`

	// The timezone in which the scheduling expression is evaluated.
	ScheduleExpressionTimezone *string `min:"1" type:"string"`

	// The date, in UTC, after which the schedule can begin invoking its target.
	// Depending on the schedule's recurrence expression, invocations might occur
	// on, or after, the StartDate you specify. EventBridge Scheduler ignores StartDate
	// for one-time schedules.
	StartDate *time.Time `type:"timestamp"`

	// Specifies whether the schedule is enabled or disabled.
	State *string `type:"string" enum:"ScheduleState"`

	// The schedule target.
	Target *Target `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetScheduleOutput) SetArn(v string) *GetScheduleOutput {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetScheduleOutput) SetCreationDate(v time.Time) *GetScheduleOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetScheduleOutput) SetDescription(v string) *GetScheduleOutput {
	s.Description = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetScheduleOutput) SetEndDate(v time.Time) *GetScheduleOutput {
	s.EndDate = &v
	return s
}

// SetFlexibleTimeWindow sets the FlexibleTimeWindow field's value.
func (s *GetScheduleOutput) SetFlexibleTimeWindow(v *FlexibleTimeWindow) *GetScheduleOutput {
	s.FlexibleTimeWindow = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetScheduleOutput) SetGroupName(v string) *GetScheduleOutput {
	s.GroupName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GetScheduleOutput) SetKmsKeyArn(v string) *GetScheduleOutput {
	s.KmsKeyArn = &v
	return s
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *GetScheduleOutput) SetLastModificationDate(v time.Time) *GetScheduleOutput {
	s.LastModificationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetScheduleOutput) SetName(v string) *GetScheduleOutput {
	s.Name = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *GetScheduleOutput) SetScheduleExpression(v string) *GetScheduleOutput {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *GetScheduleOutput) SetScheduleExpressionTimezone(v string) *GetScheduleOutput {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetScheduleOutput) SetStartDate(v time.Time) *GetScheduleOutput {
	s.StartDate = &v
	return s
}

// SetState sets the State field's value.
func (s *GetScheduleOutput) SetState(v string) *GetScheduleOutput {
	s.State = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetScheduleOutput) SetTarget(v *Target) *GetScheduleOutput {
	s.Target = v
	return s
}

// Unexpected error encountered while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The templated target type for the Amazon Kinesis PutRecord (kinesis/latest/APIReference/API_PutRecord.html)
// API operation.
type KinesisParameters struct {
	_ struct{} `type:"structure"`

	// Specifies the shard to which EventBridge Scheduler sends the event. For more
	// information, see Amazon Kinesis Data Streams terminology and concepts (https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisParameters"}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}
	if s.PartitionKey != nil && len(*s.PartitionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *KinesisParameters) SetPartitionKey(v string) *KinesisParameters {
	s.PartitionKey = &v
	return s
}

type ListScheduleGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If specified, limits the number of results returned by this operation. The
	// operation also returns a NextToken which you can use in a subsequent operation
	// to retrieve the next set of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The name prefix that you can use to return a filtered list of your schedule
	// groups.
	NamePrefix *string `location:"querystring" locationName:"NamePrefix" min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScheduleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScheduleGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScheduleGroupsInput) SetMaxResults(v int64) *ListScheduleGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListScheduleGroupsInput) SetNamePrefix(v string) *ListScheduleGroupsInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduleGroupsInput) SetNextToken(v string) *ListScheduleGroupsInput {
	s.NextToken = &v
	return s
}

type ListScheduleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If the value
	// is null, there are no more results.
	NextToken *string `min:"1" type:"string"`

	// The schedule groups that match the specified criteria.
	//
	// ScheduleGroups is a required field
	ScheduleGroups []*ScheduleGroupSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduleGroupsOutput) SetNextToken(v string) *ListScheduleGroupsOutput {
	s.NextToken = &v
	return s
}

// SetScheduleGroups sets the ScheduleGroups field's value.
func (s *ListScheduleGroupsOutput) SetScheduleGroups(v []*ScheduleGroupSummary) *ListScheduleGroupsOutput {
	s.ScheduleGroups = v
	return s
}

type ListSchedulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// If specified, only lists the schedules whose associated schedule group matches
	// the given filter.
	GroupName *string `location:"querystring" locationName:"ScheduleGroup" min:"1" type:"string"`

	// If specified, limits the number of results returned by this operation. The
	// operation also returns a NextToken which you can use in a subsequent operation
	// to retrieve the next set of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Schedule name prefix to return the filtered list of resources.
	NamePrefix *string `location:"querystring" locationName:"NamePrefix" min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// If specified, only lists the schedules whose current state matches the given
	// filter.
	State *string `location:"querystring" locationName:"State" type:"string" enum:"ScheduleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchedulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchedulesInput"}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *ListSchedulesInput) SetGroupName(v string) *ListSchedulesInput {
	s.GroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchedulesInput) SetMaxResults(v int64) *ListSchedulesInput {
	s.MaxResults = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListSchedulesInput) SetNamePrefix(v string) *ListSchedulesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulesInput) SetNextToken(v string) *ListSchedulesInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListSchedulesInput) SetState(v string) *ListSchedulesInput {
	s.State = &v
	return s
}

type ListSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If the value
	// is null, there are no more results.
	NextToken *string `min:"1" type:"string"`

	// The schedules that match the specified criteria.
	//
	// Schedules is a required field
	Schedules []*ScheduleSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchedulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchedulesOutput) SetNextToken(v string) *ListSchedulesOutput {
	s.NextToken = &v
	return s
}

// SetSchedules sets the Schedules field's value.
func (s *ListSchedulesOutput) SetSchedules(v []*ScheduleSummary) *ListSchedulesOutput {
	s.Schedules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the EventBridge Scheduler resource for which you want to view
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Specifies the network configuration for an ECS task.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon VPC subnets and security groups for the task, and whether
	// a public IP address is to be used. This structure is relevant only for ECS
	// tasks that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsvpcConfiguration sets the AwsvpcConfiguration field's value.
func (s *NetworkConfiguration) SetAwsvpcConfiguration(v *AwsVpcConfiguration) *NetworkConfiguration {
	s.AwsvpcConfiguration = v
	return s
}

// An object representing a constraint on task placement.
type PlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance. For more
	// information, see Cluster query language (https://docs.aws.amazon.com/latest/developerguide/cluster-query-language.html)
	// in the Amazon ECS Developer Guide.
	Expression *string `locationName:"expression" type:"string"`

	// The type of constraint. Use distinctInstance to ensure that each task in
	// a particular group is running on a different container instance. Use memberOf
	// to restrict the selection to a group of valid candidates.
	Type *string `locationName:"type" type:"string" enum:"PlacementConstraintType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *PlacementConstraint) SetExpression(v string) *PlacementConstraint {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementConstraint) SetType(v string) *PlacementConstraint {
	s.Type = &v
	return s
}

// The task placement strategy for a task or service.
type PlacementStrategy struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or instanceId, which has the same
	// effect), or any platform or custom attribute that is applied to a container
	// instance, such as attribute:ecs.availability-zone. For the binpack placement
	// strategy, valid values are cpu and memory. For the random placement strategy,
	// this field is not used.
	Field *string `locationName:"field" type:"string"`

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least
	// amount of remaining memory (but still enough to run the task).
	Type *string `locationName:"type" type:"string" enum:"PlacementStrategyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *PlacementStrategy) SetField(v string) *PlacementStrategy {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementStrategy) SetType(v string) *PlacementStrategy {
	s.Type = &v
	return s
}

// The request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A RetryPolicy object that includes information about the retry policy settings,
// including the maximum age of an event, and the maximum number of times EventBridge
// Scheduler will try to deliver the event to a target.
type RetryPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum amount of time, in seconds, to continue to make retry attempts.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of retry attempts to make before the request fails. Retry
	// attempts with exponential backoff continue until either the maximum number
	// of attempts is made or until the duration of the MaximumEventAgeInSeconds
	// is reached.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryPolicy"}
	if s.MaximumEventAgeInSeconds != nil && *s.MaximumEventAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumEventAgeInSeconds", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *RetryPolicy) SetMaximumEventAgeInSeconds(v int64) *RetryPolicy {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *RetryPolicy) SetMaximumRetryAttempts(v int64) *RetryPolicy {
	s.MaximumRetryAttempts = &v
	return s
}

// The name and value pair of a parameter to use to start execution of a SageMaker
// Model Building Pipeline.
type SageMakerPipelineParameter struct {
	_ struct{} `type:"structure"`

	// Name of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Value of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerPipelineParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerPipelineParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SageMakerPipelineParameter) SetName(v string) *SageMakerPipelineParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SageMakerPipelineParameter) SetValue(v string) *SageMakerPipelineParameter {
	s.Value = &v
	return s
}

// The templated target type for the Amazon SageMaker StartPipelineExecution
// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html)
// API operation.
type SageMakerPipelineParameters struct {
	_ struct{} `type:"structure"`

	// List of parameter names and values to use when executing the SageMaker Model
	// Building Pipeline.
	PipelineParameterList []*SageMakerPipelineParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerPipelineParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerPipelineParameters"}
	if s.PipelineParameterList != nil {
		for i, v := range s.PipelineParameterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineParameterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineParameterList sets the PipelineParameterList field's value.
func (s *SageMakerPipelineParameters) SetPipelineParameterList(v []*SageMakerPipelineParameter) *SageMakerPipelineParameters {
	s.PipelineParameterList = v
	return s
}

// The details of a schedule group.
type ScheduleGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule group.
	Arn *string `min:"1" type:"string"`

	// The time at which the schedule group was created.
	CreationDate *time.Time `type:"timestamp"`

	// The time at which the schedule group was last modified.
	LastModificationDate *time.Time `type:"timestamp"`

	// The name of the schedule group.
	Name *string `min:"1" type:"string"`

	// Specifies the state of the schedule group.
	State *string `type:"string" enum:"ScheduleGroupState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ScheduleGroupSummary) SetArn(v string) *ScheduleGroupSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ScheduleGroupSummary) SetCreationDate(v time.Time) *ScheduleGroupSummary {
	s.CreationDate = &v
	return s
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *ScheduleGroupSummary) SetLastModificationDate(v time.Time) *ScheduleGroupSummary {
	s.LastModificationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleGroupSummary) SetName(v string) *ScheduleGroupSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduleGroupSummary) SetState(v string) *ScheduleGroupSummary {
	s.State = &v
	return s
}

// The details of a schedule.
type ScheduleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule.
	Arn *string `min:"1" type:"string"`

	// The time at which the schedule was created.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the schedule group associated with this schedule.
	GroupName *string `min:"1" type:"string"`

	// The time at which the schedule was last modified.
	LastModificationDate *time.Time `type:"timestamp"`

	// The name of the schedule.
	Name *string `min:"1" type:"string"`

	// Specifies whether the schedule is enabled or disabled.
	State *string `type:"string" enum:"ScheduleState"`

	// The schedule's target details.
	Target *TargetSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ScheduleSummary) SetArn(v string) *ScheduleSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ScheduleSummary) SetCreationDate(v time.Time) *ScheduleSummary {
	s.CreationDate = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ScheduleSummary) SetGroupName(v string) *ScheduleSummary {
	s.GroupName = &v
	return s
}

// SetLastModificationDate sets the LastModificationDate field's value.
func (s *ScheduleSummary) SetLastModificationDate(v time.Time) *ScheduleSummary {
	s.LastModificationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleSummary) SetName(v string) *ScheduleSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduleSummary) SetState(v string) *ScheduleSummary {
	s.State = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ScheduleSummary) SetTarget(v *TargetSummary) *ScheduleSummary {
	s.Target = v
	return s
}

// The request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The templated target type for the Amazon SQS SendMessage (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html)
// API operation. Contains the message group ID to use when the target is a
// FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue
// must have content-based deduplication enabled. For more information, see
// Using the Amazon SQS message deduplication ID (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
// in the Amazon SQS Developer Guide.
type SqsParameters struct {
	_ struct{} `type:"structure"`

	// The FIFO message group ID to use as the target.
	MessageGroupId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqsParameters"}
	if s.MessageGroupId != nil && len(*s.MessageGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageGroupId sets the MessageGroupId field's value.
func (s *SqsParameters) SetMessageGroupId(v string) *SqsParameters {
	s.MessageGroupId = &v
	return s
}

// Tag to associate with a schedule group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the tag.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule group that you are adding
	// tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to associate with the schedule group.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The schedule's target. EventBridge Scheduler supports templated target that
// invoke common API operations, as well as universal targets that you can customize
// to invoke over 6,000 API operations across more than 270 services. You can
// only specify one templated or universal target for a schedule.
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An object that contains information about an Amazon SQS queue that EventBridge
	// Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge
	// Scheduler delivers failed events that could not be successfully delivered
	// to a target to the queue.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The templated target type for the Amazon ECS RunTask (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html)
	// API operation.
	EcsParameters *EcsParameters `type:"structure"`

	// The templated target type for the EventBridge PutEvents (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
	// API operation.
	EventBridgeParameters *EventBridgeParameters `type:"structure"`

	// The text, or well-formed JSON, passed to the target. If you are configuring
	// a templated Lambda, AWS Step Functions, or Amazon EventBridge target, the
	// input must be a well-formed JSON. For all other target types, a JSON is not
	// required. If you do not specify anything for this field, EventBridge Scheduler
	// delivers a default notification to the target.
	Input *string `min:"1" type:"string"`

	// The templated target type for the Amazon Kinesis PutRecord (kinesis/latest/APIReference/API_PutRecord.html)
	// API operation.
	KinesisParameters *KinesisParameters `type:"structure"`

	// A RetryPolicy object that includes information about the retry policy settings,
	// including the maximum age of an event, and the maximum number of times EventBridge
	// Scheduler will try to deliver the event to a target.
	RetryPolicy *RetryPolicy `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that EventBridge Scheduler
	// will use for this target when the schedule is invoked.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The templated target type for the Amazon SageMaker StartPipelineExecution
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html)
	// API operation.
	SageMakerPipelineParameters *SageMakerPipelineParameters `type:"structure"`

	// The templated target type for the Amazon SQS SendMessage (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html)
	// API operation. Contains the message group ID to use when the target is a
	// FIFO queue. If you specify an Amazon SQS FIFO queue as a target, the queue
	// must have content-based deduplication enabled. For more information, see
	// Using the Amazon SQS message deduplication ID (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
	// in the Amazon SQS Developer Guide.
	SqsParameters *SqsParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Input != nil && len(*s.Input) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Input", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsParameters != nil {
		if err := s.EcsParameters.Validate(); err != nil {
			invalidParams.AddNested("EcsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.EventBridgeParameters != nil {
		if err := s.EventBridgeParameters.Validate(); err != nil {
			invalidParams.AddNested("EventBridgeParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisParameters != nil {
		if err := s.KinesisParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.SageMakerPipelineParameters != nil {
		if err := s.SageMakerPipelineParameters.Validate(); err != nil {
			invalidParams.AddNested("SageMakerPipelineParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SqsParameters != nil {
		if err := s.SqsParameters.Validate(); err != nil {
			invalidParams.AddNested("SqsParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Target) SetArn(v string) *Target {
	s.Arn = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *Target) SetDeadLetterConfig(v *DeadLetterConfig) *Target {
	s.DeadLetterConfig = v
	return s
}

// SetEcsParameters sets the EcsParameters field's value.
func (s *Target) SetEcsParameters(v *EcsParameters) *Target {
	s.EcsParameters = v
	return s
}

// SetEventBridgeParameters sets the EventBridgeParameters field's value.
func (s *Target) SetEventBridgeParameters(v *EventBridgeParameters) *Target {
	s.EventBridgeParameters = v
	return s
}

// SetInput sets the Input field's value.
func (s *Target) SetInput(v string) *Target {
	s.Input = &v
	return s
}

// SetKinesisParameters sets the KinesisParameters field's value.
func (s *Target) SetKinesisParameters(v *KinesisParameters) *Target {
	s.KinesisParameters = v
	return s
}

// SetRetryPolicy sets the RetryPolicy field's value.
func (s *Target) SetRetryPolicy(v *RetryPolicy) *Target {
	s.RetryPolicy = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Target) SetRoleArn(v string) *Target {
	s.RoleArn = &v
	return s
}

// SetSageMakerPipelineParameters sets the SageMakerPipelineParameters field's value.
func (s *Target) SetSageMakerPipelineParameters(v *SageMakerPipelineParameters) *Target {
	s.SageMakerPipelineParameters = v
	return s
}

// SetSqsParameters sets the SqsParameters field's value.
func (s *Target) SetSqsParameters(v *SqsParameters) *Target {
	s.SqsParameters = v
	return s
}

// The details of a target.
type TargetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TargetSummary) SetArn(v string) *TargetSummary {
	s.Arn = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the schedule group from which you are removing
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"TagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateScheduleInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request. If you do not specify a client token, EventBridge Scheduler
	// uses a randomly generated token for the request to ensure idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description you specify for the schedule.
	Description *string `type:"string"`

	// The date, in UTC, before which the schedule can invoke its target. Depending
	// on the schedule's recurrence expression, invocations might stop on, or before,
	// the EndDate you specify. EventBridge Scheduler ignores EndDate for one-time
	// schedules.
	EndDate *time.Time `type:"timestamp"`

	// Allows you to configure a time window during which EventBridge Scheduler
	// invokes the schedule.
	//
	// FlexibleTimeWindow is a required field
	FlexibleTimeWindow *FlexibleTimeWindow `type:"structure" required:"true"`

	// The name of the schedule group with which the schedule is associated. You
	// must provide this value in order for EventBridge Scheduler to find the schedule
	// you want to update. If you omit this value, EventBridge Scheduler assumes
	// the group is associated to the default group.
	GroupName *string `min:"1" type:"string"`

	// The ARN for the customer managed KMS key that that you want EventBridge Scheduler
	// to use to encrypt and decrypt your data.
	KmsKeyArn *string `min:"1" type:"string"`

	// The name of the schedule that you are updating.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The expression that defines when the schedule runs. The following formats
	// are supported.
	//
	//    * at expression - at(yyyy-mm-ddThh:mm:ss)
	//
	//    * rate expression - rate(unit value)
	//
	//    * cron expression - cron(fields)
	//
	// You can use at expressions to create one-time schedules that invoke a target
	// once, at the time and in the time zone, that you specify. You can use rate
	// and cron expressions to create recurring schedules. Rate-based schedules
	// are useful when you want to invoke a target at regular intervals, such as
	// every 15 minutes or every five days. Cron-based schedules are useful when
	// you want to invoke a target periodically at a specific time, such as at 8:00
	// am (UTC+0) every 1st day of the month.
	//
	// A cron expression consists of six fields separated by white spaces: (minutes
	// hours day_of_month month day_of_week year).
	//
	// A rate expression consists of a value as a positive integer, and a unit with
	// the following options: minute | minutes | hour | hours | day | days
	//
	// For more information and examples, see Schedule types on EventBridge Scheduler
	// (https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html)
	// in the EventBridge Scheduler User Guide.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `min:"1" type:"string" required:"true"`

	// The timezone in which the scheduling expression is evaluated.
	ScheduleExpressionTimezone *string `min:"1" type:"string"`

	// The date, in UTC, after which the schedule can begin invoking its target.
	// Depending on the schedule's recurrence expression, invocations might occur
	// on, or after, the StartDate you specify. EventBridge Scheduler ignores StartDate
	// for one-time schedules.
	StartDate *time.Time `type:"timestamp"`

	// Specifies whether the schedule is enabled or disabled.
	State *string `type:"string" enum:"ScheduleState"`

	// The schedule target. You can use this operation to change the target that
	// your schedule invokes.
	//
	// Target is a required field
	Target *Target `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScheduleInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FlexibleTimeWindow == nil {
		invalidParams.Add(request.NewErrParamRequired("FlexibleTimeWindow"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.ScheduleExpressionTimezone != nil && len(*s.ScheduleExpressionTimezone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpressionTimezone", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.FlexibleTimeWindow != nil {
		if err := s.FlexibleTimeWindow.Validate(); err != nil {
			invalidParams.AddNested("FlexibleTimeWindow", err.(request.ErrInvalidParams))
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateScheduleInput) SetClientToken(v string) *UpdateScheduleInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateScheduleInput) SetDescription(v string) *UpdateScheduleInput {
	s.Description = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *UpdateScheduleInput) SetEndDate(v time.Time) *UpdateScheduleInput {
	s.EndDate = &v
	return s
}

// SetFlexibleTimeWindow sets the FlexibleTimeWindow field's value.
func (s *UpdateScheduleInput) SetFlexibleTimeWindow(v *FlexibleTimeWindow) *UpdateScheduleInput {
	s.FlexibleTimeWindow = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateScheduleInput) SetGroupName(v string) *UpdateScheduleInput {
	s.GroupName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *UpdateScheduleInput) SetKmsKeyArn(v string) *UpdateScheduleInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateScheduleInput) SetName(v string) *UpdateScheduleInput {
	s.Name = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *UpdateScheduleInput) SetScheduleExpression(v string) *UpdateScheduleInput {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *UpdateScheduleInput) SetScheduleExpressionTimezone(v string) *UpdateScheduleInput {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *UpdateScheduleInput) SetStartDate(v time.Time) *UpdateScheduleInput {
	s.StartDate = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateScheduleInput) SetState(v string) *UpdateScheduleInput {
	s.State = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *UpdateScheduleInput) SetTarget(v *Target) *UpdateScheduleInput {
	s.Target = v
	return s
}

type UpdateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the schedule that you updated.
	//
	// ScheduleArn is a required field
	ScheduleArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduleOutput) GoString() string {
	return s.String()
}

// SetScheduleArn sets the ScheduleArn field's value.
func (s *UpdateScheduleOutput) SetScheduleArn(v string) *UpdateScheduleOutput {
	s.ScheduleArn = &v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

// AssignPublicIp_Values returns all elements of the AssignPublicIp enum
func AssignPublicIp_Values() []string {
	return []string{
		AssignPublicIpEnabled,
		AssignPublicIpDisabled,
	}
}

const (
	// FlexibleTimeWindowModeOff is a FlexibleTimeWindowMode enum value
	FlexibleTimeWindowModeOff = "OFF"

	// FlexibleTimeWindowModeFlexible is a FlexibleTimeWindowMode enum value
	FlexibleTimeWindowModeFlexible = "FLEXIBLE"
)

// FlexibleTimeWindowMode_Values returns all elements of the FlexibleTimeWindowMode enum
func FlexibleTimeWindowMode_Values() []string {
	return []string{
		FlexibleTimeWindowModeOff,
		FlexibleTimeWindowModeFlexible,
	}
}

const (
	// LaunchTypeEc2 is a LaunchType enum value
	LaunchTypeEc2 = "EC2"

	// LaunchTypeFargate is a LaunchType enum value
	LaunchTypeFargate = "FARGATE"

	// LaunchTypeExternal is a LaunchType enum value
	LaunchTypeExternal = "EXTERNAL"
)

// LaunchType_Values returns all elements of the LaunchType enum
func LaunchType_Values() []string {
	return []string{
		LaunchTypeEc2,
		LaunchTypeFargate,
		LaunchTypeExternal,
	}
}

const (
	// PlacementConstraintTypeDistinctInstance is a PlacementConstraintType enum value
	PlacementConstraintTypeDistinctInstance = "distinctInstance"

	// PlacementConstraintTypeMemberOf is a PlacementConstraintType enum value
	PlacementConstraintTypeMemberOf = "memberOf"
)

// PlacementConstraintType_Values returns all elements of the PlacementConstraintType enum
func PlacementConstraintType_Values() []string {
	return []string{
		PlacementConstraintTypeDistinctInstance,
		PlacementConstraintTypeMemberOf,
	}
}

const (
	// PlacementStrategyTypeRandom is a PlacementStrategyType enum value
	PlacementStrategyTypeRandom = "random"

	// PlacementStrategyTypeSpread is a PlacementStrategyType enum value
	PlacementStrategyTypeSpread = "spread"

	// PlacementStrategyTypeBinpack is a PlacementStrategyType enum value
	PlacementStrategyTypeBinpack = "binpack"
)

// PlacementStrategyType_Values returns all elements of the PlacementStrategyType enum
func PlacementStrategyType_Values() []string {
	return []string{
		PlacementStrategyTypeRandom,
		PlacementStrategyTypeSpread,
		PlacementStrategyTypeBinpack,
	}
}

const (
	// PropagateTagsTaskDefinition is a PropagateTags enum value
	PropagateTagsTaskDefinition = "TASK_DEFINITION"
)

// PropagateTags_Values returns all elements of the PropagateTags enum
func PropagateTags_Values() []string {
	return []string{
		PropagateTagsTaskDefinition,
	}
}

const (
	// ScheduleGroupStateActive is a ScheduleGroupState enum value
	ScheduleGroupStateActive = "ACTIVE"

	// ScheduleGroupStateDeleting is a ScheduleGroupState enum value
	ScheduleGroupStateDeleting = "DELETING"
)

// ScheduleGroupState_Values returns all elements of the ScheduleGroupState enum
func ScheduleGroupState_Values() []string {
	return []string{
		ScheduleGroupStateActive,
		ScheduleGroupStateDeleting,
	}
}

const (
	// ScheduleStateEnabled is a ScheduleState enum value
	ScheduleStateEnabled = "ENABLED"

	// ScheduleStateDisabled is a ScheduleState enum value
	ScheduleStateDisabled = "DISABLED"
)

// ScheduleState_Values returns all elements of the ScheduleState enum
func ScheduleState_Values() []string {
	return []string{
		ScheduleStateEnabled,
		ScheduleStateDisabled,
	}
}
