// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package prometheusservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAlertManagerDefinition = "CreateAlertManagerDefinition"

// CreateAlertManagerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlertManagerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlertManagerDefinition for more information on using the CreateAlertManagerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAlertManagerDefinitionRequest method.
//	req, resp := client.CreateAlertManagerDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateAlertManagerDefinition
func (c *PrometheusService) CreateAlertManagerDefinitionRequest(input *CreateAlertManagerDefinitionInput) (req *request.Request, output *CreateAlertManagerDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateAlertManagerDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/alertmanager/definition",
	}

	if input == nil {
		input = &CreateAlertManagerDefinitionInput{}
	}

	output = &CreateAlertManagerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlertManagerDefinition API operation for Amazon Prometheus Service.
//
// Create an alert manager definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation CreateAlertManagerDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateAlertManagerDefinition
func (c *PrometheusService) CreateAlertManagerDefinition(input *CreateAlertManagerDefinitionInput) (*CreateAlertManagerDefinitionOutput, error) {
	req, out := c.CreateAlertManagerDefinitionRequest(input)
	return out, req.Send()
}

// CreateAlertManagerDefinitionWithContext is the same as CreateAlertManagerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlertManagerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) CreateAlertManagerDefinitionWithContext(ctx aws.Context, input *CreateAlertManagerDefinitionInput, opts ...request.Option) (*CreateAlertManagerDefinitionOutput, error) {
	req, out := c.CreateAlertManagerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggingConfiguration = "CreateLoggingConfiguration"

// CreateLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggingConfiguration for more information on using the CreateLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLoggingConfigurationRequest method.
//	req, resp := client.CreateLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateLoggingConfiguration
func (c *PrometheusService) CreateLoggingConfigurationRequest(input *CreateLoggingConfigurationInput) (req *request.Request, output *CreateLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/logging",
	}

	if input == nil {
		input = &CreateLoggingConfigurationInput{}
	}

	output = &CreateLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggingConfiguration API operation for Amazon Prometheus Service.
//
// Create logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation CreateLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateLoggingConfiguration
func (c *PrometheusService) CreateLoggingConfiguration(input *CreateLoggingConfigurationInput) (*CreateLoggingConfigurationOutput, error) {
	req, out := c.CreateLoggingConfigurationRequest(input)
	return out, req.Send()
}

// CreateLoggingConfigurationWithContext is the same as CreateLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) CreateLoggingConfigurationWithContext(ctx aws.Context, input *CreateLoggingConfigurationInput, opts ...request.Option) (*CreateLoggingConfigurationOutput, error) {
	req, out := c.CreateLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleGroupsNamespace = "CreateRuleGroupsNamespace"

// CreateRuleGroupsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleGroupsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleGroupsNamespace for more information on using the CreateRuleGroupsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleGroupsNamespaceRequest method.
//	req, resp := client.CreateRuleGroupsNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateRuleGroupsNamespace
func (c *PrometheusService) CreateRuleGroupsNamespaceRequest(input *CreateRuleGroupsNamespaceInput) (req *request.Request, output *CreateRuleGroupsNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateRuleGroupsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/rulegroupsnamespaces",
	}

	if input == nil {
		input = &CreateRuleGroupsNamespaceInput{}
	}

	output = &CreateRuleGroupsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleGroupsNamespace API operation for Amazon Prometheus Service.
//
// Create a rule group namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation CreateRuleGroupsNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateRuleGroupsNamespace
func (c *PrometheusService) CreateRuleGroupsNamespace(input *CreateRuleGroupsNamespaceInput) (*CreateRuleGroupsNamespaceOutput, error) {
	req, out := c.CreateRuleGroupsNamespaceRequest(input)
	return out, req.Send()
}

// CreateRuleGroupsNamespaceWithContext is the same as CreateRuleGroupsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleGroupsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) CreateRuleGroupsNamespaceWithContext(ctx aws.Context, input *CreateRuleGroupsNamespaceInput, opts ...request.Option) (*CreateRuleGroupsNamespaceOutput, error) {
	req, out := c.CreateRuleGroupsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspace = "CreateWorkspace"

// CreateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspace for more information on using the CreateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceRequest method.
//	req, resp := client.CreateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace
func (c *PrometheusService) CreateWorkspaceRequest(input *CreateWorkspaceInput) (req *request.Request, output *CreateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces",
	}

	if input == nil {
		input = &CreateWorkspaceInput{}
	}

	output = &CreateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspace API operation for Amazon Prometheus Service.
//
// Creates a new AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation CreateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace
func (c *PrometheusService) CreateWorkspace(input *CreateWorkspaceInput) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	return out, req.Send()
}

// CreateWorkspaceWithContext is the same as CreateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) CreateWorkspaceWithContext(ctx aws.Context, input *CreateWorkspaceInput, opts ...request.Option) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlertManagerDefinition = "DeleteAlertManagerDefinition"

// DeleteAlertManagerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlertManagerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlertManagerDefinition for more information on using the DeleteAlertManagerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAlertManagerDefinitionRequest method.
//	req, resp := client.DeleteAlertManagerDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteAlertManagerDefinition
func (c *PrometheusService) DeleteAlertManagerDefinitionRequest(input *DeleteAlertManagerDefinitionInput) (req *request.Request, output *DeleteAlertManagerDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteAlertManagerDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/alertmanager/definition",
	}

	if input == nil {
		input = &DeleteAlertManagerDefinitionInput{}
	}

	output = &DeleteAlertManagerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlertManagerDefinition API operation for Amazon Prometheus Service.
//
// Deletes an alert manager definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DeleteAlertManagerDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteAlertManagerDefinition
func (c *PrometheusService) DeleteAlertManagerDefinition(input *DeleteAlertManagerDefinitionInput) (*DeleteAlertManagerDefinitionOutput, error) {
	req, out := c.DeleteAlertManagerDefinitionRequest(input)
	return out, req.Send()
}

// DeleteAlertManagerDefinitionWithContext is the same as DeleteAlertManagerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlertManagerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DeleteAlertManagerDefinitionWithContext(ctx aws.Context, input *DeleteAlertManagerDefinitionInput, opts ...request.Option) (*DeleteAlertManagerDefinitionOutput, error) {
	req, out := c.DeleteAlertManagerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggingConfiguration = "DeleteLoggingConfiguration"

// DeleteLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggingConfiguration for more information on using the DeleteLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLoggingConfigurationRequest method.
//	req, resp := client.DeleteLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteLoggingConfiguration
func (c *PrometheusService) DeleteLoggingConfigurationRequest(input *DeleteLoggingConfigurationInput) (req *request.Request, output *DeleteLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/logging",
	}

	if input == nil {
		input = &DeleteLoggingConfigurationInput{}
	}

	output = &DeleteLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggingConfiguration API operation for Amazon Prometheus Service.
//
// Delete logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DeleteLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteLoggingConfiguration
func (c *PrometheusService) DeleteLoggingConfiguration(input *DeleteLoggingConfigurationInput) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLoggingConfigurationWithContext is the same as DeleteLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DeleteLoggingConfigurationWithContext(ctx aws.Context, input *DeleteLoggingConfigurationInput, opts ...request.Option) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleGroupsNamespace = "DeleteRuleGroupsNamespace"

// DeleteRuleGroupsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleGroupsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleGroupsNamespace for more information on using the DeleteRuleGroupsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleGroupsNamespaceRequest method.
//	req, resp := client.DeleteRuleGroupsNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteRuleGroupsNamespace
func (c *PrometheusService) DeleteRuleGroupsNamespaceRequest(input *DeleteRuleGroupsNamespaceInput) (req *request.Request, output *DeleteRuleGroupsNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleGroupsNamespace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
	}

	if input == nil {
		input = &DeleteRuleGroupsNamespaceInput{}
	}

	output = &DeleteRuleGroupsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRuleGroupsNamespace API operation for Amazon Prometheus Service.
//
// Delete a rule groups namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DeleteRuleGroupsNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteRuleGroupsNamespace
func (c *PrometheusService) DeleteRuleGroupsNamespace(input *DeleteRuleGroupsNamespaceInput) (*DeleteRuleGroupsNamespaceOutput, error) {
	req, out := c.DeleteRuleGroupsNamespaceRequest(input)
	return out, req.Send()
}

// DeleteRuleGroupsNamespaceWithContext is the same as DeleteRuleGroupsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleGroupsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DeleteRuleGroupsNamespaceWithContext(ctx aws.Context, input *DeleteRuleGroupsNamespaceInput, opts ...request.Option) (*DeleteRuleGroupsNamespaceOutput, error) {
	req, out := c.DeleteRuleGroupsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspace = "DeleteWorkspace"

// DeleteWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspace for more information on using the DeleteWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceRequest method.
//	req, resp := client.DeleteWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace
func (c *PrometheusService) DeleteWorkspaceRequest(input *DeleteWorkspaceInput) (req *request.Request, output *DeleteWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DeleteWorkspaceInput{}
	}

	output = &DeleteWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspace API operation for Amazon Prometheus Service.
//
// Deletes an AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DeleteWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace
func (c *PrometheusService) DeleteWorkspace(input *DeleteWorkspaceInput) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceWithContext is the same as DeleteWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DeleteWorkspaceWithContext(ctx aws.Context, input *DeleteWorkspaceInput, opts ...request.Option) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlertManagerDefinition = "DescribeAlertManagerDefinition"

// DescribeAlertManagerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlertManagerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlertManagerDefinition for more information on using the DescribeAlertManagerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAlertManagerDefinitionRequest method.
//	req, resp := client.DescribeAlertManagerDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeAlertManagerDefinition
func (c *PrometheusService) DescribeAlertManagerDefinitionRequest(input *DescribeAlertManagerDefinitionInput) (req *request.Request, output *DescribeAlertManagerDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeAlertManagerDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/alertmanager/definition",
	}

	if input == nil {
		input = &DescribeAlertManagerDefinitionInput{}
	}

	output = &DescribeAlertManagerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlertManagerDefinition API operation for Amazon Prometheus Service.
//
// Describes an alert manager definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DescribeAlertManagerDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeAlertManagerDefinition
func (c *PrometheusService) DescribeAlertManagerDefinition(input *DescribeAlertManagerDefinitionInput) (*DescribeAlertManagerDefinitionOutput, error) {
	req, out := c.DescribeAlertManagerDefinitionRequest(input)
	return out, req.Send()
}

// DescribeAlertManagerDefinitionWithContext is the same as DescribeAlertManagerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlertManagerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DescribeAlertManagerDefinitionWithContext(ctx aws.Context, input *DescribeAlertManagerDefinitionInput, opts ...request.Option) (*DescribeAlertManagerDefinitionOutput, error) {
	req, out := c.DescribeAlertManagerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingConfiguration = "DescribeLoggingConfiguration"

// DescribeLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingConfiguration for more information on using the DescribeLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLoggingConfigurationRequest method.
//	req, resp := client.DescribeLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeLoggingConfiguration
func (c *PrometheusService) DescribeLoggingConfigurationRequest(input *DescribeLoggingConfigurationInput) (req *request.Request, output *DescribeLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/logging",
	}

	if input == nil {
		input = &DescribeLoggingConfigurationInput{}
	}

	output = &DescribeLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingConfiguration API operation for Amazon Prometheus Service.
//
// Describes logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DescribeLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeLoggingConfiguration
func (c *PrometheusService) DescribeLoggingConfiguration(input *DescribeLoggingConfigurationInput) (*DescribeLoggingConfigurationOutput, error) {
	req, out := c.DescribeLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DescribeLoggingConfigurationWithContext is the same as DescribeLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DescribeLoggingConfigurationWithContext(ctx aws.Context, input *DescribeLoggingConfigurationInput, opts ...request.Option) (*DescribeLoggingConfigurationOutput, error) {
	req, out := c.DescribeLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuleGroupsNamespace = "DescribeRuleGroupsNamespace"

// DescribeRuleGroupsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuleGroupsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuleGroupsNamespace for more information on using the DescribeRuleGroupsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRuleGroupsNamespaceRequest method.
//	req, resp := client.DescribeRuleGroupsNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeRuleGroupsNamespace
func (c *PrometheusService) DescribeRuleGroupsNamespaceRequest(input *DescribeRuleGroupsNamespaceInput) (req *request.Request, output *DescribeRuleGroupsNamespaceOutput) {
	op := &request.Operation{
		Name:       opDescribeRuleGroupsNamespace,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
	}

	if input == nil {
		input = &DescribeRuleGroupsNamespaceInput{}
	}

	output = &DescribeRuleGroupsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuleGroupsNamespace API operation for Amazon Prometheus Service.
//
// Describe a rule groups namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DescribeRuleGroupsNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeRuleGroupsNamespace
func (c *PrometheusService) DescribeRuleGroupsNamespace(input *DescribeRuleGroupsNamespaceInput) (*DescribeRuleGroupsNamespaceOutput, error) {
	req, out := c.DescribeRuleGroupsNamespaceRequest(input)
	return out, req.Send()
}

// DescribeRuleGroupsNamespaceWithContext is the same as DescribeRuleGroupsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuleGroupsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DescribeRuleGroupsNamespaceWithContext(ctx aws.Context, input *DescribeRuleGroupsNamespaceInput, opts ...request.Option) (*DescribeRuleGroupsNamespaceOutput, error) {
	req, out := c.DescribeRuleGroupsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspace = "DescribeWorkspace"

// DescribeWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspace for more information on using the DescribeWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceRequest method.
//	req, resp := client.DescribeWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace
func (c *PrometheusService) DescribeWorkspaceRequest(input *DescribeWorkspaceInput) (req *request.Request, output *DescribeWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspace,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DescribeWorkspaceInput{}
	}

	output = &DescribeWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspace API operation for Amazon Prometheus Service.
//
// Describes an existing AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DescribeWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace
func (c *PrometheusService) DescribeWorkspace(input *DescribeWorkspaceInput) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceWithContext is the same as DescribeWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DescribeWorkspaceWithContext(ctx aws.Context, input *DescribeWorkspaceInput, opts ...request.Option) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleGroupsNamespaces = "ListRuleGroupsNamespaces"

// ListRuleGroupsNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleGroupsNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleGroupsNamespaces for more information on using the ListRuleGroupsNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRuleGroupsNamespacesRequest method.
//	req, resp := client.ListRuleGroupsNamespacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces
func (c *PrometheusService) ListRuleGroupsNamespacesRequest(input *ListRuleGroupsNamespacesInput) (req *request.Request, output *ListRuleGroupsNamespacesOutput) {
	op := &request.Operation{
		Name:       opListRuleGroupsNamespaces,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/rulegroupsnamespaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRuleGroupsNamespacesInput{}
	}

	output = &ListRuleGroupsNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleGroupsNamespaces API operation for Amazon Prometheus Service.
//
// Lists rule groups namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation ListRuleGroupsNamespaces for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListRuleGroupsNamespaces
func (c *PrometheusService) ListRuleGroupsNamespaces(input *ListRuleGroupsNamespacesInput) (*ListRuleGroupsNamespacesOutput, error) {
	req, out := c.ListRuleGroupsNamespacesRequest(input)
	return out, req.Send()
}

// ListRuleGroupsNamespacesWithContext is the same as ListRuleGroupsNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleGroupsNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListRuleGroupsNamespacesWithContext(ctx aws.Context, input *ListRuleGroupsNamespacesInput, opts ...request.Option) (*ListRuleGroupsNamespacesOutput, error) {
	req, out := c.ListRuleGroupsNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRuleGroupsNamespacesPages iterates over the pages of a ListRuleGroupsNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuleGroupsNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRuleGroupsNamespaces operation.
//	pageNum := 0
//	err := client.ListRuleGroupsNamespacesPages(params,
//	    func(page *prometheusservice.ListRuleGroupsNamespacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrometheusService) ListRuleGroupsNamespacesPages(input *ListRuleGroupsNamespacesInput, fn func(*ListRuleGroupsNamespacesOutput, bool) bool) error {
	return c.ListRuleGroupsNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRuleGroupsNamespacesPagesWithContext same as ListRuleGroupsNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListRuleGroupsNamespacesPagesWithContext(ctx aws.Context, input *ListRuleGroupsNamespacesInput, fn func(*ListRuleGroupsNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRuleGroupsNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRuleGroupsNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRuleGroupsNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource
func (c *PrometheusService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Prometheus Service.
//
// Lists the tags you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource
func (c *PrometheusService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkspaces = "ListWorkspaces"

// ListWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkspaces for more information on using the ListWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkspacesRequest method.
//	req, resp := client.ListWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces
func (c *PrometheusService) ListWorkspacesRequest(input *ListWorkspacesInput) (req *request.Request, output *ListWorkspacesOutput) {
	op := &request.Operation{
		Name:       opListWorkspaces,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkspacesInput{}
	}

	output = &ListWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkspaces API operation for Amazon Prometheus Service.
//
// Lists all AMP workspaces, including workspaces being created or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation ListWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces
func (c *PrometheusService) ListWorkspaces(input *ListWorkspacesInput) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	return out, req.Send()
}

// ListWorkspacesWithContext is the same as ListWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListWorkspacesWithContext(ctx aws.Context, input *ListWorkspacesInput, opts ...request.Option) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkspacesPages iterates over the pages of a ListWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkspaces operation.
//	pageNum := 0
//	err := client.ListWorkspacesPages(params,
//	    func(page *prometheusservice.ListWorkspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *PrometheusService) ListWorkspacesPages(input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool) error {
	return c.ListWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkspacesPagesWithContext same as ListWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListWorkspacesPagesWithContext(ctx aws.Context, input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAlertManagerDefinition = "PutAlertManagerDefinition"

// PutAlertManagerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the PutAlertManagerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAlertManagerDefinition for more information on using the PutAlertManagerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAlertManagerDefinitionRequest method.
//	req, resp := client.PutAlertManagerDefinitionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutAlertManagerDefinition
func (c *PrometheusService) PutAlertManagerDefinitionRequest(input *PutAlertManagerDefinitionInput) (req *request.Request, output *PutAlertManagerDefinitionOutput) {
	op := &request.Operation{
		Name:       opPutAlertManagerDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/alertmanager/definition",
	}

	if input == nil {
		input = &PutAlertManagerDefinitionInput{}
	}

	output = &PutAlertManagerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAlertManagerDefinition API operation for Amazon Prometheus Service.
//
// Update an alert manager definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation PutAlertManagerDefinition for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutAlertManagerDefinition
func (c *PrometheusService) PutAlertManagerDefinition(input *PutAlertManagerDefinitionInput) (*PutAlertManagerDefinitionOutput, error) {
	req, out := c.PutAlertManagerDefinitionRequest(input)
	return out, req.Send()
}

// PutAlertManagerDefinitionWithContext is the same as PutAlertManagerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See PutAlertManagerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) PutAlertManagerDefinitionWithContext(ctx aws.Context, input *PutAlertManagerDefinitionInput, opts ...request.Option) (*PutAlertManagerDefinitionOutput, error) {
	req, out := c.PutAlertManagerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRuleGroupsNamespace = "PutRuleGroupsNamespace"

// PutRuleGroupsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the PutRuleGroupsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRuleGroupsNamespace for more information on using the PutRuleGroupsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRuleGroupsNamespaceRequest method.
//	req, resp := client.PutRuleGroupsNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutRuleGroupsNamespace
func (c *PrometheusService) PutRuleGroupsNamespaceRequest(input *PutRuleGroupsNamespaceInput) (req *request.Request, output *PutRuleGroupsNamespaceOutput) {
	op := &request.Operation{
		Name:       opPutRuleGroupsNamespace,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
	}

	if input == nil {
		input = &PutRuleGroupsNamespaceInput{}
	}

	output = &PutRuleGroupsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRuleGroupsNamespace API operation for Amazon Prometheus Service.
//
// Update a rule groups namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation PutRuleGroupsNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/PutRuleGroupsNamespace
func (c *PrometheusService) PutRuleGroupsNamespace(input *PutRuleGroupsNamespaceInput) (*PutRuleGroupsNamespaceOutput, error) {
	req, out := c.PutRuleGroupsNamespaceRequest(input)
	return out, req.Send()
}

// PutRuleGroupsNamespaceWithContext is the same as PutRuleGroupsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See PutRuleGroupsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) PutRuleGroupsNamespaceWithContext(ctx aws.Context, input *PutRuleGroupsNamespaceInput, opts ...request.Option) (*PutRuleGroupsNamespaceOutput, error) {
	req, out := c.PutRuleGroupsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource
func (c *PrometheusService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Prometheus Service.
//
// Creates tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource
func (c *PrometheusService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource
func (c *PrometheusService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Prometheus Service.
//
// Deletes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource
func (c *PrometheusService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoggingConfiguration = "UpdateLoggingConfiguration"

// UpdateLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoggingConfiguration for more information on using the UpdateLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLoggingConfigurationRequest method.
//	req, resp := client.UpdateLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateLoggingConfiguration
func (c *PrometheusService) UpdateLoggingConfigurationRequest(input *UpdateLoggingConfigurationInput) (req *request.Request, output *UpdateLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/logging",
	}

	if input == nil {
		input = &UpdateLoggingConfigurationInput{}
	}

	output = &UpdateLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoggingConfiguration API operation for Amazon Prometheus Service.
//
// Update logging configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation UpdateLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateLoggingConfiguration
func (c *PrometheusService) UpdateLoggingConfiguration(input *UpdateLoggingConfigurationInput) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLoggingConfigurationWithContext is the same as UpdateLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) UpdateLoggingConfigurationWithContext(ctx aws.Context, input *UpdateLoggingConfigurationInput, opts ...request.Option) (*UpdateLoggingConfigurationOutput, error) {
	req, out := c.UpdateLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceAlias = "UpdateWorkspaceAlias"

// UpdateWorkspaceAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceAlias for more information on using the UpdateWorkspaceAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceAliasRequest method.
//	req, resp := client.UpdateWorkspaceAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias
func (c *PrometheusService) UpdateWorkspaceAliasRequest(input *UpdateWorkspaceAliasInput) (req *request.Request, output *UpdateWorkspaceAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/alias",
	}

	if input == nil {
		input = &UpdateWorkspaceAliasInput{}
	}

	output = &UpdateWorkspaceAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceAlias API operation for Amazon Prometheus Service.
//
// Updates an AMP workspace alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation UpdateWorkspaceAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Request was denied due to request throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     Request references a resource which does not exist.
//
//   - AccessDeniedException
//     User does not have sufficient access to perform this action.
//
//   - InternalServerException
//     Unexpected error during processing of request.
//
//   - ServiceQuotaExceededException
//     Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias
func (c *PrometheusService) UpdateWorkspaceAlias(input *UpdateWorkspaceAliasInput) (*UpdateWorkspaceAliasOutput, error) {
	req, out := c.UpdateWorkspaceAliasRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceAliasWithContext is the same as UpdateWorkspaceAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) UpdateWorkspaceAliasWithContext(ctx aws.Context, input *UpdateWorkspaceAliasInput, opts ...request.Option) (*UpdateWorkspaceAliasOutput, error) {
	req, out := c.UpdateWorkspaceAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the properties of an alert manager definition.
type AlertManagerDefinitionDescription struct {
	_ struct{} `type:"structure"`

	// The time when the alert manager definition was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The alert manager definition.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The time when the alert manager definition was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" required:"true"`

	// The status of alert manager definition.
	//
	// Status is a required field
	Status *AlertManagerDefinitionStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertManagerDefinitionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertManagerDefinitionDescription) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AlertManagerDefinitionDescription) SetCreatedAt(v time.Time) *AlertManagerDefinitionDescription {
	s.CreatedAt = &v
	return s
}

// SetData sets the Data field's value.
func (s *AlertManagerDefinitionDescription) SetData(v []byte) *AlertManagerDefinitionDescription {
	s.Data = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *AlertManagerDefinitionDescription) SetModifiedAt(v time.Time) *AlertManagerDefinitionDescription {
	s.ModifiedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AlertManagerDefinitionDescription) SetStatus(v *AlertManagerDefinitionStatus) *AlertManagerDefinitionDescription {
	s.Status = v
	return s
}

// Represents the status of a definition.
type AlertManagerDefinitionStatus struct {
	_ struct{} `type:"structure"`

	// Status code of this definition.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"AlertManagerDefinitionStatusCode"`

	// The reason for failure if any.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertManagerDefinitionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlertManagerDefinitionStatus) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *AlertManagerDefinitionStatus) SetStatusCode(v string) *AlertManagerDefinitionStatus {
	s.StatusCode = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AlertManagerDefinitionStatus) SetStatusReason(v string) *AlertManagerDefinitionStatus {
	s.StatusReason = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a CreateAlertManagerDefinition operation.
type CreateAlertManagerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The alert manager definition data.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The ID of the workspace in which to create the alert manager definition.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertManagerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertManagerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAlertManagerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAlertManagerDefinitionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAlertManagerDefinitionInput) SetClientToken(v string) *CreateAlertManagerDefinitionInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *CreateAlertManagerDefinitionInput) SetData(v []byte) *CreateAlertManagerDefinitionInput {
	s.Data = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateAlertManagerDefinitionInput) SetWorkspaceId(v string) *CreateAlertManagerDefinitionInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a CreateAlertManagerDefinition operation.
type CreateAlertManagerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The status of alert manager definition.
	//
	// Status is a required field
	Status *AlertManagerDefinitionStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertManagerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAlertManagerDefinitionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CreateAlertManagerDefinitionOutput) SetStatus(v *AlertManagerDefinitionStatus) *CreateAlertManagerDefinitionOutput {
	s.Status = v
	return s
}

// Represents the input of a CreateLoggingConfiguration operation.
type CreateLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the CW log group to which the vended log data will be published.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `locationName:"logGroupArn" type:"string" required:"true"`

	// The ID of the workspace to vend logs to.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoggingConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupArn"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateLoggingConfigurationInput) SetClientToken(v string) *CreateLoggingConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CreateLoggingConfigurationInput) SetLogGroupArn(v string) *CreateLoggingConfigurationInput {
	s.LogGroupArn = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateLoggingConfigurationInput) SetWorkspaceId(v string) *CreateLoggingConfigurationInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a CreateLoggingConfiguration operation.
type CreateLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The status of the logging configuration.
	//
	// Status is a required field
	Status *LoggingConfigurationStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CreateLoggingConfigurationOutput) SetStatus(v *LoggingConfigurationStatus) *CreateLoggingConfigurationOutput {
	s.Status = v
	return s
}

// Represents the input of a CreateRuleGroupsNamespace operation.
type CreateRuleGroupsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The namespace data that define the rule groups.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Optional, user-provided tags for this rule groups namespace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the workspace in which to create the rule group namespace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleGroupsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleGroupsNamespaceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRuleGroupsNamespaceInput) SetClientToken(v string) *CreateRuleGroupsNamespaceInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *CreateRuleGroupsNamespaceInput) SetData(v []byte) *CreateRuleGroupsNamespaceInput {
	s.Data = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleGroupsNamespaceInput) SetName(v string) *CreateRuleGroupsNamespaceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleGroupsNamespaceInput) SetTags(v map[string]*string) *CreateRuleGroupsNamespaceInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateRuleGroupsNamespaceInput) SetWorkspaceId(v string) *CreateRuleGroupsNamespaceInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a CreateRuleGroupsNamespace operation.
type CreateRuleGroupsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this rule groups namespace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of rule groups namespace.
	//
	// Status is a required field
	Status *RuleGroupsNamespaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this rule groups namespace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleGroupsNamespaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRuleGroupsNamespaceOutput) SetArn(v string) *CreateRuleGroupsNamespaceOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleGroupsNamespaceOutput) SetName(v string) *CreateRuleGroupsNamespaceOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateRuleGroupsNamespaceOutput) SetStatus(v *RuleGroupsNamespaceStatus) *CreateRuleGroupsNamespaceOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleGroupsNamespaceOutput) SetTags(v map[string]*string) *CreateRuleGroupsNamespaceOutput {
	s.Tags = v
	return s
}

// Represents the input of a CreateWorkspace operation.
type CreateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// An optional user-assigned alias for this workspace. This alias is for user
	// reference and does not need to be unique.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Optional, user-provided tags for this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateWorkspaceInput) SetAlias(v string) *CreateWorkspaceInput {
	s.Alias = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkspaceInput) SetClientToken(v string) *CreateWorkspaceInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceInput) SetTags(v map[string]*string) *CreateWorkspaceInput {
	s.Tags = v
	return s
}

// Represents the output of a CreateWorkspace operation.
type CreateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the workspace that was just created.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The status of the workspace that was just created (usually CREATING).
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The generated ID of the workspace that was just created.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkspaceOutput) SetArn(v string) *CreateWorkspaceOutput {
	s.Arn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorkspaceOutput) SetStatus(v *WorkspaceStatus) *CreateWorkspaceOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceOutput) SetTags(v map[string]*string) *CreateWorkspaceOutput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceOutput) SetWorkspaceId(v string) *CreateWorkspaceOutput {
	s.WorkspaceId = &v
	return s
}

// Represents the input of a DeleteAlertManagerDefinition operation.
type DeleteAlertManagerDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace in which to delete the alert manager definition.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertManagerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertManagerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlertManagerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAlertManagerDefinitionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAlertManagerDefinitionInput) SetClientToken(v string) *DeleteAlertManagerDefinitionInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteAlertManagerDefinitionInput) SetWorkspaceId(v string) *DeleteAlertManagerDefinitionInput {
	s.WorkspaceId = &v
	return s
}

type DeleteAlertManagerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertManagerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAlertManagerDefinitionOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteLoggingConfiguration operation.
type DeleteLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace to vend logs to.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggingConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteLoggingConfigurationInput) SetClientToken(v string) *DeleteLoggingConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteLoggingConfigurationInput) SetWorkspaceId(v string) *DeleteLoggingConfigurationInput {
	s.WorkspaceId = &v
	return s
}

type DeleteLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteRuleGroupsNamespace operation.
type DeleteRuleGroupsNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the workspace to delete rule group definition.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleGroupsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleGroupsNamespaceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteRuleGroupsNamespaceInput) SetClientToken(v string) *DeleteRuleGroupsNamespaceInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteRuleGroupsNamespaceInput) SetName(v string) *DeleteRuleGroupsNamespaceInput {
	s.Name = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteRuleGroupsNamespaceInput) SetWorkspaceId(v string) *DeleteRuleGroupsNamespaceInput {
	s.WorkspaceId = &v
	return s
}

type DeleteRuleGroupsNamespaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleGroupsNamespaceOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteWorkspace operation.
type DeleteWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteWorkspaceInput) SetClientToken(v string) *DeleteWorkspaceInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceInput) SetWorkspaceId(v string) *DeleteWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeAlertManagerDefinition operation.
type DescribeAlertManagerDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to describe.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertManagerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertManagerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlertManagerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAlertManagerDefinitionInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeAlertManagerDefinitionInput) SetWorkspaceId(v string) *DescribeAlertManagerDefinitionInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a DescribeAlertManagerDefinition operation.
type DescribeAlertManagerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the selected workspace's alert manager definition.
	//
	// AlertManagerDefinition is a required field
	AlertManagerDefinition *AlertManagerDefinitionDescription `locationName:"alertManagerDefinition" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertManagerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAlertManagerDefinitionOutput) GoString() string {
	return s.String()
}

// SetAlertManagerDefinition sets the AlertManagerDefinition field's value.
func (s *DescribeAlertManagerDefinitionOutput) SetAlertManagerDefinition(v *AlertManagerDefinitionDescription) *DescribeAlertManagerDefinitionOutput {
	s.AlertManagerDefinition = v
	return s
}

// Represents the input of a DescribeLoggingConfiguration operation.
type DescribeLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to vend logs to.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoggingConfigurationInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeLoggingConfigurationInput) SetWorkspaceId(v string) *DescribeLoggingConfigurationInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a DescribeLoggingConfiguration operation.
type DescribeLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Metadata object containing information about the logging configuration of
	// a workspace.
	//
	// LoggingConfiguration is a required field
	LoggingConfiguration *LoggingConfigurationMetadata `locationName:"loggingConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *DescribeLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfigurationMetadata) *DescribeLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

// Represents the input of a DescribeRuleGroupsNamespace operation.
type DescribeRuleGroupsNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The rule groups namespace.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the workspace to describe.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleGroupsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleGroupsNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRuleGroupsNamespaceInput) SetName(v string) *DescribeRuleGroupsNamespaceInput {
	s.Name = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeRuleGroupsNamespaceInput) SetWorkspaceId(v string) *DescribeRuleGroupsNamespaceInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a DescribeRuleGroupsNamespace operation.
type DescribeRuleGroupsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The selected rule groups namespace.
	//
	// RuleGroupsNamespace is a required field
	RuleGroupsNamespace *RuleGroupsNamespaceDescription `locationName:"ruleGroupsNamespace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuleGroupsNamespaceOutput) GoString() string {
	return s.String()
}

// SetRuleGroupsNamespace sets the RuleGroupsNamespace field's value.
func (s *DescribeRuleGroupsNamespaceOutput) SetRuleGroupsNamespace(v *RuleGroupsNamespaceDescription) *DescribeRuleGroupsNamespaceOutput {
	s.RuleGroupsNamespace = v
	return s
}

// Represents the input of a DescribeWorkspace operation.
type DescribeWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to describe.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceInput) SetWorkspaceId(v string) *DescribeWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a DescribeWorkspace operation.
type DescribeWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the selected workspace.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *DescribeWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *DescribeWorkspaceOutput {
	s.Workspace = v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a ListRuleGroupsNamespaces operation.
type ListRuleGroupsNamespacesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum results to return in response (default=100, maximum=1000).
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Optional filter for rule groups namespace name. Only the rule groups namespace
	// that begin with this value will be returned.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// Pagination token to request the next page in a paginated list. This token
	// is obtained from the output of the previous ListRuleGroupsNamespaces request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsNamespacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleGroupsNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleGroupsNamespacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRuleGroupsNamespacesInput) SetMaxResults(v int64) *ListRuleGroupsNamespacesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListRuleGroupsNamespacesInput) SetName(v string) *ListRuleGroupsNamespacesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleGroupsNamespacesInput) SetNextToken(v string) *ListRuleGroupsNamespacesInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListRuleGroupsNamespacesInput) SetWorkspaceId(v string) *ListRuleGroupsNamespacesInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a ListRuleGroupsNamespaces operation.
type ListRuleGroupsNamespacesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to use when requesting the next page in this list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of the selected rule groups namespaces.
	//
	// RuleGroupsNamespaces is a required field
	RuleGroupsNamespaces []*RuleGroupsNamespaceSummary `locationName:"ruleGroupsNamespaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsNamespacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRuleGroupsNamespacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleGroupsNamespacesOutput) SetNextToken(v string) *ListRuleGroupsNamespacesOutput {
	s.NextToken = &v
	return s
}

// SetRuleGroupsNamespaces sets the RuleGroupsNamespaces field's value.
func (s *ListRuleGroupsNamespacesOutput) SetRuleGroupsNamespaces(v []*RuleGroupsNamespaceSummary) *ListRuleGroupsNamespacesOutput {
	s.RuleGroupsNamespaces = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Represents the input of a ListWorkspaces operation.
type ListWorkspacesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional filter for workspace alias. Only the workspaces with aliases that
	// begin with this value will be returned.
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string"`

	// Maximum results to return in response (default=100, maximum=1000).
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token to request the next page in a paginated list. This token
	// is obtained from the output of the previous ListWorkspaces request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkspacesInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *ListWorkspacesInput) SetAlias(v string) *ListWorkspacesInput {
	s.Alias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkspacesInput) SetMaxResults(v int64) *ListWorkspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesInput) SetNextToken(v string) *ListWorkspacesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListWorkspaces operation.
type ListWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to use when requesting the next page in this list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing workspaces, including those undergoing creation or deletion.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceSummary `locationName:"workspaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesOutput) SetNextToken(v string) *ListWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *ListWorkspacesOutput) SetWorkspaces(v []*WorkspaceSummary) *ListWorkspacesOutput {
	s.Workspaces = v
	return s
}

// Represents the properties of a logging configuration metadata.
type LoggingConfigurationMetadata struct {
	_ struct{} `type:"structure"`

	// The time when the logging configuration was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The ARN of the CW log group to which the vended log data will be published.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `locationName:"logGroupArn" type:"string" required:"true"`

	// The time when the logging configuration was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" required:"true"`

	// The status of the logging configuration.
	//
	// Status is a required field
	Status *LoggingConfigurationStatus `locationName:"status" type:"structure" required:"true"`

	// The workspace where the logging configuration exists.
	//
	// Workspace is a required field
	Workspace *string `locationName:"workspace" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationMetadata) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LoggingConfigurationMetadata) SetCreatedAt(v time.Time) *LoggingConfigurationMetadata {
	s.CreatedAt = &v
	return s
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *LoggingConfigurationMetadata) SetLogGroupArn(v string) *LoggingConfigurationMetadata {
	s.LogGroupArn = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *LoggingConfigurationMetadata) SetModifiedAt(v time.Time) *LoggingConfigurationMetadata {
	s.ModifiedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LoggingConfigurationMetadata) SetStatus(v *LoggingConfigurationStatus) *LoggingConfigurationMetadata {
	s.Status = v
	return s
}

// SetWorkspace sets the Workspace field's value.
func (s *LoggingConfigurationMetadata) SetWorkspace(v string) *LoggingConfigurationMetadata {
	s.Workspace = &v
	return s
}

// Represents the status of a logging configuration.
type LoggingConfigurationStatus struct {
	_ struct{} `type:"structure"`

	// Status code of the logging configuration.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"LoggingConfigurationStatusCode"`

	// The reason for failure if any.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfigurationStatus) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *LoggingConfigurationStatus) SetStatusCode(v string) *LoggingConfigurationStatus {
	s.StatusCode = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *LoggingConfigurationStatus) SetStatusReason(v string) *LoggingConfigurationStatus {
	s.StatusReason = &v
	return s
}

// Represents the input of a PutAlertManagerDefinition operation.
type PutAlertManagerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The alert manager definition data.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The ID of the workspace in which to update the alert manager definition.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAlertManagerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAlertManagerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAlertManagerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAlertManagerDefinitionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutAlertManagerDefinitionInput) SetClientToken(v string) *PutAlertManagerDefinitionInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *PutAlertManagerDefinitionInput) SetData(v []byte) *PutAlertManagerDefinitionInput {
	s.Data = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *PutAlertManagerDefinitionInput) SetWorkspaceId(v string) *PutAlertManagerDefinitionInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a PutAlertManagerDefinition operation.
type PutAlertManagerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The status of alert manager definition.
	//
	// Status is a required field
	Status *AlertManagerDefinitionStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAlertManagerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAlertManagerDefinitionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *PutAlertManagerDefinitionOutput) SetStatus(v *AlertManagerDefinitionStatus) *PutAlertManagerDefinitionOutput {
	s.Status = v
	return s
}

// Represents the input of a PutRuleGroupsNamespace operation.
type PutRuleGroupsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The namespace data that define the rule groups.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the workspace in which to update the rule group namespace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleGroupsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleGroupsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRuleGroupsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRuleGroupsNamespaceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutRuleGroupsNamespaceInput) SetClientToken(v string) *PutRuleGroupsNamespaceInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *PutRuleGroupsNamespaceInput) SetData(v []byte) *PutRuleGroupsNamespaceInput {
	s.Data = v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleGroupsNamespaceInput) SetName(v string) *PutRuleGroupsNamespaceInput {
	s.Name = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *PutRuleGroupsNamespaceInput) SetWorkspaceId(v string) *PutRuleGroupsNamespaceInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a PutRuleGroupsNamespace operation.
type PutRuleGroupsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this rule groups namespace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of rule groups namespace.
	//
	// Status is a required field
	Status *RuleGroupsNamespaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this rule groups namespace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleGroupsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRuleGroupsNamespaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutRuleGroupsNamespaceOutput) SetArn(v string) *PutRuleGroupsNamespaceOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleGroupsNamespaceOutput) SetName(v string) *PutRuleGroupsNamespaceOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PutRuleGroupsNamespaceOutput) SetStatus(v *RuleGroupsNamespaceStatus) *PutRuleGroupsNamespaceOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutRuleGroupsNamespaceOutput) SetTags(v map[string]*string) *PutRuleGroupsNamespaceOutput {
	s.Tags = v
	return s
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a description of the rule groups namespace.
type RuleGroupsNamespaceDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this rule groups namespace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the rule groups namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The rule groups namespace data.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The time when the rule groups namespace was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of rule groups namespace.
	//
	// Status is a required field
	Status *RuleGroupsNamespaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this rule groups namespace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleGroupsNamespaceDescription) SetArn(v string) *RuleGroupsNamespaceDescription {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RuleGroupsNamespaceDescription) SetCreatedAt(v time.Time) *RuleGroupsNamespaceDescription {
	s.CreatedAt = &v
	return s
}

// SetData sets the Data field's value.
func (s *RuleGroupsNamespaceDescription) SetData(v []byte) *RuleGroupsNamespaceDescription {
	s.Data = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *RuleGroupsNamespaceDescription) SetModifiedAt(v time.Time) *RuleGroupsNamespaceDescription {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroupsNamespaceDescription) SetName(v string) *RuleGroupsNamespaceDescription {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RuleGroupsNamespaceDescription) SetStatus(v *RuleGroupsNamespaceStatus) *RuleGroupsNamespaceDescription {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RuleGroupsNamespaceDescription) SetTags(v map[string]*string) *RuleGroupsNamespaceDescription {
	s.Tags = v
	return s
}

// Represents the status of a namespace.
type RuleGroupsNamespaceStatus struct {
	_ struct{} `type:"structure"`

	// Status code of this namespace.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"RuleGroupsNamespaceStatusCode"`

	// The reason for failure if any.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceStatus) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *RuleGroupsNamespaceStatus) SetStatusCode(v string) *RuleGroupsNamespaceStatus {
	s.StatusCode = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *RuleGroupsNamespaceStatus) SetStatusReason(v string) *RuleGroupsNamespaceStatus {
	s.StatusReason = &v
	return s
}

// Represents a summary of the rule groups namespace.
type RuleGroupsNamespaceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this rule groups namespace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the rule groups namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The time when the rule groups namespace was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" required:"true"`

	// The rule groups namespace name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of rule groups namespace.
	//
	// Status is a required field
	Status *RuleGroupsNamespaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this rule groups namespace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleGroupsNamespaceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleGroupsNamespaceSummary) SetArn(v string) *RuleGroupsNamespaceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RuleGroupsNamespaceSummary) SetCreatedAt(v time.Time) *RuleGroupsNamespaceSummary {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *RuleGroupsNamespaceSummary) SetModifiedAt(v time.Time) *RuleGroupsNamespaceSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroupsNamespaceSummary) SetName(v string) *RuleGroupsNamespaceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RuleGroupsNamespaceSummary) SetStatus(v *RuleGroupsNamespaceStatus) *RuleGroupsNamespaceSummary {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RuleGroupsNamespaceSummary) SetTags(v map[string]*string) *RuleGroupsNamespaceSummary {
	s.Tags = v
	return s
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Service Quotas requirement to identify originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tags assigned to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// Service Quotas requirement to identify originating service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tag keys
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Represents the input of an UpdateLoggingConfiguration operation.
type UpdateLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the CW log group to which the vended log data will be published.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `locationName:"logGroupArn" type:"string" required:"true"`

	// The ID of the workspace to vend logs to.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoggingConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupArn"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateLoggingConfigurationInput) SetClientToken(v string) *UpdateLoggingConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *UpdateLoggingConfigurationInput) SetLogGroupArn(v string) *UpdateLoggingConfigurationInput {
	s.LogGroupArn = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateLoggingConfigurationInput) SetWorkspaceId(v string) *UpdateLoggingConfigurationInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of an UpdateLoggingConfiguration operation.
type UpdateLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The status of the logging configuration.
	//
	// Status is a required field
	Status *LoggingConfigurationStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *UpdateLoggingConfigurationOutput) SetStatus(v *LoggingConfigurationStatus) *UpdateLoggingConfigurationOutput {
	s.Status = v
	return s
}

// Represents the input of an UpdateWorkspaceAlias operation.
type UpdateWorkspaceAliasInput struct {
	_ struct{} `type:"structure"`

	// The new alias of the workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace being updated.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceAliasInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *UpdateWorkspaceAliasInput) SetAlias(v string) *UpdateWorkspaceAliasInput {
	s.Alias = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateWorkspaceAliasInput) SetClientToken(v string) *UpdateWorkspaceAliasInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceAliasInput) SetWorkspaceId(v string) *UpdateWorkspaceAliasInput {
	s.WorkspaceId = &v
	return s
}

type UpdateWorkspaceAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that caused the error, if applicable. If more than one field caused
	// the error, pick one and elaborate in the message.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Message describing why the field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Represents the properties of a workspace.
type WorkspaceDescription struct {
	_ struct{} `type:"structure"`

	// Alias of this workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of this workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the workspace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Prometheus endpoint URI.
	PrometheusEndpoint *string `locationName:"prometheusEndpoint" min:"1" type:"string"`

	// The status of this workspace.
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Unique string identifying this workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDescription) SetAlias(v string) *WorkspaceDescription {
	s.Alias = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *WorkspaceDescription) SetArn(v string) *WorkspaceDescription {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkspaceDescription) SetCreatedAt(v time.Time) *WorkspaceDescription {
	s.CreatedAt = &v
	return s
}

// SetPrometheusEndpoint sets the PrometheusEndpoint field's value.
func (s *WorkspaceDescription) SetPrometheusEndpoint(v string) *WorkspaceDescription {
	s.PrometheusEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceDescription) SetStatus(v *WorkspaceStatus) *WorkspaceDescription {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceDescription) SetTags(v map[string]*string) *WorkspaceDescription {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceDescription) SetWorkspaceId(v string) *WorkspaceDescription {
	s.WorkspaceId = &v
	return s
}

// Represents the status of a workspace.
type WorkspaceStatus struct {
	_ struct{} `type:"structure"`

	// Status code of this workspace.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"WorkspaceStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceStatus) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *WorkspaceStatus) SetStatusCode(v string) *WorkspaceStatus {
	s.StatusCode = &v
	return s
}

// Represents a summary of the properties of a workspace.
type WorkspaceSummary struct {
	_ struct{} `type:"structure"`

	// Alias of this workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The AmazonResourceName of this workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the workspace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The status of this workspace.
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Unique string identifying this workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceSummary) SetAlias(v string) *WorkspaceSummary {
	s.Alias = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *WorkspaceSummary) SetArn(v string) *WorkspaceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkspaceSummary) SetCreatedAt(v time.Time) *WorkspaceSummary {
	s.CreatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceSummary) SetStatus(v *WorkspaceStatus) *WorkspaceSummary {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceSummary) SetTags(v map[string]*string) *WorkspaceSummary {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceSummary) SetWorkspaceId(v string) *WorkspaceSummary {
	s.WorkspaceId = &v
	return s
}

// State of an alert manager definition.
const (
	// AlertManagerDefinitionStatusCodeCreating is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeCreating = "CREATING"

	// AlertManagerDefinitionStatusCodeActive is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeActive = "ACTIVE"

	// AlertManagerDefinitionStatusCodeUpdating is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeUpdating = "UPDATING"

	// AlertManagerDefinitionStatusCodeDeleting is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeDeleting = "DELETING"

	// AlertManagerDefinitionStatusCodeCreationFailed is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeCreationFailed = "CREATION_FAILED"

	// AlertManagerDefinitionStatusCodeUpdateFailed is a AlertManagerDefinitionStatusCode enum value
	AlertManagerDefinitionStatusCodeUpdateFailed = "UPDATE_FAILED"
)

// AlertManagerDefinitionStatusCode_Values returns all elements of the AlertManagerDefinitionStatusCode enum
func AlertManagerDefinitionStatusCode_Values() []string {
	return []string{
		AlertManagerDefinitionStatusCodeCreating,
		AlertManagerDefinitionStatusCodeActive,
		AlertManagerDefinitionStatusCodeUpdating,
		AlertManagerDefinitionStatusCodeDeleting,
		AlertManagerDefinitionStatusCodeCreationFailed,
		AlertManagerDefinitionStatusCodeUpdateFailed,
	}
}

// State of a logging configuration.
const (
	// LoggingConfigurationStatusCodeCreating is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeCreating = "CREATING"

	// LoggingConfigurationStatusCodeActive is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeActive = "ACTIVE"

	// LoggingConfigurationStatusCodeUpdating is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeUpdating = "UPDATING"

	// LoggingConfigurationStatusCodeDeleting is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeDeleting = "DELETING"

	// LoggingConfigurationStatusCodeCreationFailed is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeCreationFailed = "CREATION_FAILED"

	// LoggingConfigurationStatusCodeUpdateFailed is a LoggingConfigurationStatusCode enum value
	LoggingConfigurationStatusCodeUpdateFailed = "UPDATE_FAILED"
)

// LoggingConfigurationStatusCode_Values returns all elements of the LoggingConfigurationStatusCode enum
func LoggingConfigurationStatusCode_Values() []string {
	return []string{
		LoggingConfigurationStatusCodeCreating,
		LoggingConfigurationStatusCodeActive,
		LoggingConfigurationStatusCodeUpdating,
		LoggingConfigurationStatusCodeDeleting,
		LoggingConfigurationStatusCodeCreationFailed,
		LoggingConfigurationStatusCodeUpdateFailed,
	}
}

// State of a namespace.
const (
	// RuleGroupsNamespaceStatusCodeCreating is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeCreating = "CREATING"

	// RuleGroupsNamespaceStatusCodeActive is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeActive = "ACTIVE"

	// RuleGroupsNamespaceStatusCodeUpdating is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeUpdating = "UPDATING"

	// RuleGroupsNamespaceStatusCodeDeleting is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeDeleting = "DELETING"

	// RuleGroupsNamespaceStatusCodeCreationFailed is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeCreationFailed = "CREATION_FAILED"

	// RuleGroupsNamespaceStatusCodeUpdateFailed is a RuleGroupsNamespaceStatusCode enum value
	RuleGroupsNamespaceStatusCodeUpdateFailed = "UPDATE_FAILED"
)

// RuleGroupsNamespaceStatusCode_Values returns all elements of the RuleGroupsNamespaceStatusCode enum
func RuleGroupsNamespaceStatusCode_Values() []string {
	return []string{
		RuleGroupsNamespaceStatusCodeCreating,
		RuleGroupsNamespaceStatusCodeActive,
		RuleGroupsNamespaceStatusCodeUpdating,
		RuleGroupsNamespaceStatusCodeDeleting,
		RuleGroupsNamespaceStatusCodeCreationFailed,
		RuleGroupsNamespaceStatusCodeUpdateFailed,
	}
}

// Possible reasons a request failed validation.
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

// State of a workspace.
const (
	// WorkspaceStatusCodeCreating is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeCreating = "CREATING"

	// WorkspaceStatusCodeActive is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeActive = "ACTIVE"

	// WorkspaceStatusCodeUpdating is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeUpdating = "UPDATING"

	// WorkspaceStatusCodeDeleting is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeDeleting = "DELETING"

	// WorkspaceStatusCodeCreationFailed is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeCreationFailed = "CREATION_FAILED"
)

// WorkspaceStatusCode_Values returns all elements of the WorkspaceStatusCode enum
func WorkspaceStatusCode_Values() []string {
	return []string{
		WorkspaceStatusCodeCreating,
		WorkspaceStatusCodeActive,
		WorkspaceStatusCodeUpdating,
		WorkspaceStatusCodeDeleting,
		WorkspaceStatusCodeCreationFailed,
	}
}
