// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// We recommend that you use the UpdateDomainAssociation API operation to move a
// domain association, as it supports both standard distributions and distribution
// tenants. [AssociateAlias]performs similar checks but only supports standard distributions.
//
// Moves a domain from its current standard distribution or distribution tenant to
// another one.
//
// You must first disable the source distribution (standard distribution or
// distribution tenant) and then separately call this operation to move the domain
// to another target distribution (standard distribution or distribution tenant).
//
// To use this operation, specify the domain and the ID of the target resource
// (standard distribution or distribution tenant). For more information, including
// how to set up the target resource, prerequisites that you must complete, and
// other restrictions, see [Moving an alternate domain name to a different standard distribution or distribution tenant]in the Amazon CloudFront Developer Guide.
//
// [AssociateAlias]: https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_AssociateAlias.html
// [Moving an alternate domain name to a different standard distribution or distribution tenant]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move
func (c *Client) UpdateDomainAssociation(ctx context.Context, params *UpdateDomainAssociationInput, optFns ...func(*Options)) (*UpdateDomainAssociationOutput, error) {
	if params == nil {
		params = &UpdateDomainAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDomainAssociation", params, optFns, c.addOperationUpdateDomainAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDomainAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDomainAssociationInput struct {

	// The domain to update.
	//
	// This member is required.
	Domain *string

	// The target standard distribution or distribution tenant resource for the
	// domain. You can specify either DistributionId or DistributionTenantId , but not
	// both.
	//
	// This member is required.
	TargetResource *types.DistributionResourceId

	// The value of the ETag identifier for the standard distribution or distribution
	// tenant that will be associated with the domain.
	IfMatch *string

	noSmithyDocumentSerde
}

type UpdateDomainAssociationOutput struct {

	// The domain that you're moving.
	Domain *string

	// The current version of the target standard distribution or distribution tenant
	// that was associated with the domain.
	ETag *string

	// The intended destination for the domain.
	ResourceId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDomainAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpUpdateDomainAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpUpdateDomainAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDomainAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDomainAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDomainAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDomainAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDomainAssociation",
	}
}
