// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesRequest
type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TerminateWorkspacesInput"}

	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(aws.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesResult
type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated.
//
//    // Example sending a request using TerminateWorkspacesRequest.
//    req := client.TerminateWorkspacesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *Client) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) TerminateWorkspacesRequest {
	op := &aws.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	req := c.newRequest(op, input, &TerminateWorkspacesOutput{})
	return TerminateWorkspacesRequest{Request: req, Input: input, Copy: c.TerminateWorkspacesRequest}
}

// TerminateWorkspacesRequest is the request type for the
// TerminateWorkspaces API operation.
type TerminateWorkspacesRequest struct {
	*aws.Request
	Input *TerminateWorkspacesInput
	Copy  func(*TerminateWorkspacesInput) TerminateWorkspacesRequest
}

// Send marshals and sends the TerminateWorkspaces API request.
func (r TerminateWorkspacesRequest) Send(ctx context.Context) (*TerminateWorkspacesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TerminateWorkspacesResponse{
		TerminateWorkspacesOutput: r.Request.Data.(*TerminateWorkspacesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TerminateWorkspacesResponse is the response type for the
// TerminateWorkspaces API operation.
type TerminateWorkspacesResponse struct {
	*TerminateWorkspacesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TerminateWorkspaces request.
func (r *TerminateWorkspacesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
