// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImageRequest
type DeleteWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceImageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteWorkspaceImageInput"}

	if s.ImageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImageResult
type DeleteWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteWorkspaceImage = "DeleteWorkspaceImage"

// DeleteWorkspaceImageRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Deletes the specified image from your account. To delete an image, you must
// first delete any bundles that are associated with the image.
//
//    // Example sending a request using DeleteWorkspaceImageRequest.
//    req := client.DeleteWorkspaceImageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *Client) DeleteWorkspaceImageRequest(input *DeleteWorkspaceImageInput) DeleteWorkspaceImageRequest {
	op := &aws.Operation{
		Name:       opDeleteWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceImageInput{}
	}

	req := c.newRequest(op, input, &DeleteWorkspaceImageOutput{})
	return DeleteWorkspaceImageRequest{Request: req, Input: input, Copy: c.DeleteWorkspaceImageRequest}
}

// DeleteWorkspaceImageRequest is the request type for the
// DeleteWorkspaceImage API operation.
type DeleteWorkspaceImageRequest struct {
	*aws.Request
	Input *DeleteWorkspaceImageInput
	Copy  func(*DeleteWorkspaceImageInput) DeleteWorkspaceImageRequest
}

// Send marshals and sends the DeleteWorkspaceImage API request.
func (r DeleteWorkspaceImageRequest) Send(ctx context.Context) (*DeleteWorkspaceImageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteWorkspaceImageResponse{
		DeleteWorkspaceImageOutput: r.Request.Data.(*DeleteWorkspaceImageOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteWorkspaceImageResponse is the response type for the
// DeleteWorkspaceImage API operation.
type DeleteWorkspaceImageResponse struct {
	*DeleteWorkspaceImageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteWorkspaceImage request.
func (r *DeleteWorkspaceImageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
