// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DeleteFileShareInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShareInput
type DeleteFileShareInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share to be deleted.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// If this value is set to true, the operation deletes a file share immediately
	// and aborts all data uploads to AWS. Otherwise, the file share is not deleted
	// until all data is uploaded to AWS. This process aborts the data upload process,
	// and the file share enters the FORCE_DELETING status.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileShareInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileShareInput"}

	if s.FileShareARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("FileShareARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DeleteFileShareOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShareOutput
type DeleteFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteFileShare = "DeleteFileShare"

// DeleteFileShareRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Deletes a file share from a file gateway. This operation is only supported
// for file gateways.
//
//    // Example sending a request using DeleteFileShareRequest.
//    req := client.DeleteFileShareRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare
func (c *Client) DeleteFileShareRequest(input *DeleteFileShareInput) DeleteFileShareRequest {
	op := &aws.Operation{
		Name:       opDeleteFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileShareInput{}
	}

	req := c.newRequest(op, input, &DeleteFileShareOutput{})
	return DeleteFileShareRequest{Request: req, Input: input, Copy: c.DeleteFileShareRequest}
}

// DeleteFileShareRequest is the request type for the
// DeleteFileShare API operation.
type DeleteFileShareRequest struct {
	*aws.Request
	Input *DeleteFileShareInput
	Copy  func(*DeleteFileShareInput) DeleteFileShareRequest
}

// Send marshals and sends the DeleteFileShare API request.
func (r DeleteFileShareRequest) Send(ctx context.Context) (*DeleteFileShareResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFileShareResponse{
		DeleteFileShareOutput: r.Request.Data.(*DeleteFileShareOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFileShareResponse is the response type for the
// DeleteFileShare API operation.
type DeleteFileShareResponse struct {
	*DeleteFileShareOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFileShare request.
func (r *DeleteFileShareResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
