// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroupRequest
type RegisterPatchBaselineForPatchGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to register the patch group with.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The name of the patch group that should be registered with the patch baseline.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterPatchBaselineForPatchGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterPatchBaselineForPatchGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterPatchBaselineForPatchGroupInput"}

	if s.BaselineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("BaselineId", 20))
	}

	if s.PatchGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroupResult
type RegisterPatchBaselineForPatchGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline the patch group was registered with.
	BaselineId *string `min:"20" type:"string"`

	// The name of the patch group registered with the patch baseline.
	PatchGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RegisterPatchBaselineForPatchGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterPatchBaselineForPatchGroup = "RegisterPatchBaselineForPatchGroup"

// RegisterPatchBaselineForPatchGroupRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Registers a patch baseline for a patch group.
//
//    // Example sending a request using RegisterPatchBaselineForPatchGroupRequest.
//    req := client.RegisterPatchBaselineForPatchGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup
func (c *Client) RegisterPatchBaselineForPatchGroupRequest(input *RegisterPatchBaselineForPatchGroupInput) RegisterPatchBaselineForPatchGroupRequest {
	op := &aws.Operation{
		Name:       opRegisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterPatchBaselineForPatchGroupInput{}
	}

	req := c.newRequest(op, input, &RegisterPatchBaselineForPatchGroupOutput{})
	return RegisterPatchBaselineForPatchGroupRequest{Request: req, Input: input, Copy: c.RegisterPatchBaselineForPatchGroupRequest}
}

// RegisterPatchBaselineForPatchGroupRequest is the request type for the
// RegisterPatchBaselineForPatchGroup API operation.
type RegisterPatchBaselineForPatchGroupRequest struct {
	*aws.Request
	Input *RegisterPatchBaselineForPatchGroupInput
	Copy  func(*RegisterPatchBaselineForPatchGroupInput) RegisterPatchBaselineForPatchGroupRequest
}

// Send marshals and sends the RegisterPatchBaselineForPatchGroup API request.
func (r RegisterPatchBaselineForPatchGroupRequest) Send(ctx context.Context) (*RegisterPatchBaselineForPatchGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterPatchBaselineForPatchGroupResponse{
		RegisterPatchBaselineForPatchGroupOutput: r.Request.Data.(*RegisterPatchBaselineForPatchGroupOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterPatchBaselineForPatchGroupResponse is the response type for the
// RegisterPatchBaselineForPatchGroup API operation.
type RegisterPatchBaselineForPatchGroupResponse struct {
	*RegisterPatchBaselineForPatchGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterPatchBaselineForPatchGroup request.
func (r *RegisterPatchBaselineForPatchGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
