// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersRequest
type GetParametersInput struct {
	_ struct{} `type:"structure"`

	// Names of the parameters for which you want to query information.
	//
	// Names is a required field
	Names []string `min:"1" type:"list" required:"true"`

	// Return decrypted secure string value. Return decrypted values for secure
	// string parameters. This flag is ignored for String and StringList parameter
	// types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetParametersInput"}

	if s.Names == nil {
		invalidParams.Add(aws.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersResult
type GetParametersOutput struct {
	_ struct{} `type:"structure"`

	// A list of parameters that are not formatted correctly or do not run when
	// executed.
	InvalidParameters []string `min:"1" type:"list"`

	// A list of details for a parameter.
	Parameters []Parameter `type:"list"`
}

// String returns the string representation
func (s GetParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetParameters = "GetParameters"

// GetParametersRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Get details of a parameter. Don't confuse this API action with the GetParameter
// API action.
//
//    // Example sending a request using GetParametersRequest.
//    req := client.GetParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters
func (c *Client) GetParametersRequest(input *GetParametersInput) GetParametersRequest {
	op := &aws.Operation{
		Name:       opGetParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersInput{}
	}

	req := c.newRequest(op, input, &GetParametersOutput{})
	return GetParametersRequest{Request: req, Input: input, Copy: c.GetParametersRequest}
}

// GetParametersRequest is the request type for the
// GetParameters API operation.
type GetParametersRequest struct {
	*aws.Request
	Input *GetParametersInput
	Copy  func(*GetParametersInput) GetParametersRequest
}

// Send marshals and sends the GetParameters API request.
func (r GetParametersRequest) Send(ctx context.Context) (*GetParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetParametersResponse{
		GetParametersOutput: r.Request.Data.(*GetParametersOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetParametersResponse is the response type for the
// GetParameters API operation.
type GetParametersResponse struct {
	*GetParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetParameters request.
func (r *GetParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
