// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistoryRequest
type GetParameterHistoryInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of a parameter you want to query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Return decrypted values for secure string parameters. This flag is ignored
	// for String and StringList parameter types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParameterHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParameterHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetParameterHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistoryResult
type GetParameterHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// A list of parameters returned by the request.
	Parameters []ParameterHistory `type:"list"`
}

// String returns the string representation
func (s GetParameterHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetParameterHistory = "GetParameterHistory"

// GetParameterHistoryRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Query a list of all parameters used by the AWS account.
//
//    // Example sending a request using GetParameterHistoryRequest.
//    req := client.GetParameterHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory
func (c *Client) GetParameterHistoryRequest(input *GetParameterHistoryInput) GetParameterHistoryRequest {
	op := &aws.Operation{
		Name:       opGetParameterHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetParameterHistoryInput{}
	}

	req := c.newRequest(op, input, &GetParameterHistoryOutput{})
	return GetParameterHistoryRequest{Request: req, Input: input, Copy: c.GetParameterHistoryRequest}
}

// GetParameterHistoryRequest is the request type for the
// GetParameterHistory API operation.
type GetParameterHistoryRequest struct {
	*aws.Request
	Input *GetParameterHistoryInput
	Copy  func(*GetParameterHistoryInput) GetParameterHistoryRequest
}

// Send marshals and sends the GetParameterHistory API request.
func (r GetParameterHistoryRequest) Send(ctx context.Context) (*GetParameterHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetParameterHistoryResponse{
		GetParameterHistoryOutput: r.Request.Data.(*GetParameterHistoryOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetParameterHistoryRequestPaginator returns a paginator for GetParameterHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetParameterHistoryRequest(input)
//   p := ssm.NewGetParameterHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetParameterHistoryPaginator(req GetParameterHistoryRequest) GetParameterHistoryPaginator {
	return GetParameterHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetParameterHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetParameterHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetParameterHistoryPaginator struct {
	aws.Pager
}

func (p *GetParameterHistoryPaginator) CurrentPage() *GetParameterHistoryOutput {
	return p.Pager.CurrentPage().(*GetParameterHistoryOutput)
}

// GetParameterHistoryResponse is the response type for the
// GetParameterHistory API operation.
type GetParameterHistoryResponse struct {
	*GetParameterHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetParameterHistory request.
func (r *GetParameterHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
