// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasksRequest
type DescribeMaintenanceWindowTasksInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to narrow down the scope of the returned tasks. The
	// supported filter keys are WindowTaskId, TaskArn, Priority, and TaskType.
	Filters []MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window whose tasks should be retrieved.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMaintenanceWindowTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}

	if s.WindowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasksResult
type DescribeMaintenanceWindowTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the tasks in the Maintenance Window.
	Tasks []MaintenanceWindowTask `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMaintenanceWindowTasks = "DescribeMaintenanceWindowTasks"

// DescribeMaintenanceWindowTasksRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Lists the tasks in a Maintenance Window.
//
//    // Example sending a request using DescribeMaintenanceWindowTasksRequest.
//    req := client.DescribeMaintenanceWindowTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks
func (c *Client) DescribeMaintenanceWindowTasksRequest(input *DescribeMaintenanceWindowTasksInput) DescribeMaintenanceWindowTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeMaintenanceWindowTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeMaintenanceWindowTasksOutput{})
	return DescribeMaintenanceWindowTasksRequest{Request: req, Input: input, Copy: c.DescribeMaintenanceWindowTasksRequest}
}

// DescribeMaintenanceWindowTasksRequest is the request type for the
// DescribeMaintenanceWindowTasks API operation.
type DescribeMaintenanceWindowTasksRequest struct {
	*aws.Request
	Input *DescribeMaintenanceWindowTasksInput
	Copy  func(*DescribeMaintenanceWindowTasksInput) DescribeMaintenanceWindowTasksRequest
}

// Send marshals and sends the DescribeMaintenanceWindowTasks API request.
func (r DescribeMaintenanceWindowTasksRequest) Send(ctx context.Context) (*DescribeMaintenanceWindowTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMaintenanceWindowTasksResponse{
		DescribeMaintenanceWindowTasksOutput: r.Request.Data.(*DescribeMaintenanceWindowTasksOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMaintenanceWindowTasksResponse is the response type for the
// DescribeMaintenanceWindowTasks API operation.
type DescribeMaintenanceWindowTasksResponse struct {
	*DescribeMaintenanceWindowTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMaintenanceWindowTasks request.
func (r *DescribeMaintenanceWindowTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
