// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopicsInput
type ListTopicsInput struct {
	_ struct{} `type:"structure"`

	// Token returned by the previous ListTopics request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTopicsInput) String() string {
	return awsutil.Prettify(s)
}

// Response for ListTopics action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopicsResponse
type ListTopicsOutput struct {
	_ struct{} `type:"structure"`

	// Token to pass along to the next ListTopics request. This element is returned
	// if there are additional topics to retrieve.
	NextToken *string `type:"string"`

	// A list of topic ARNs.
	Topics []Topic `type:"list"`
}

// String returns the string representation
func (s ListTopicsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTopics = "ListTopics"

// ListTopicsRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Returns a list of the requester's topics. Each call returns a limited list
// of topics, up to 100. If there are more topics, a NextToken is also returned.
// Use the NextToken parameter in a new ListTopics call to get further results.
//
// This action is throttled at 30 transactions per second (TPS).
//
//    // Example sending a request using ListTopicsRequest.
//    req := client.ListTopicsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics
func (c *Client) ListTopicsRequest(input *ListTopicsInput) ListTopicsRequest {
	op := &aws.Operation{
		Name:       opListTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsInput{}
	}

	req := c.newRequest(op, input, &ListTopicsOutput{})
	return ListTopicsRequest{Request: req, Input: input, Copy: c.ListTopicsRequest}
}

// ListTopicsRequest is the request type for the
// ListTopics API operation.
type ListTopicsRequest struct {
	*aws.Request
	Input *ListTopicsInput
	Copy  func(*ListTopicsInput) ListTopicsRequest
}

// Send marshals and sends the ListTopics API request.
func (r ListTopicsRequest) Send(ctx context.Context) (*ListTopicsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTopicsResponse{
		ListTopicsOutput: r.Request.Data.(*ListTopicsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTopicsRequestPaginator returns a paginator for ListTopics.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTopicsRequest(input)
//   p := sns.NewListTopicsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTopicsPaginator(req ListTopicsRequest) ListTopicsPaginator {
	return ListTopicsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTopicsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTopicsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTopicsPaginator struct {
	aws.Pager
}

func (p *ListTopicsPaginator) CurrentPage() *ListTopicsOutput {
	return p.Pager.CurrentPage().(*ListTopicsOutput)
}

// ListTopicsResponse is the response type for the
// ListTopics API operation.
type ListTopicsResponse struct {
	*ListTopicsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTopics request.
func (r *ListTopicsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
