// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddressRequest
type CreateAddressInput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball shipped to.
	//
	// Address is a required field
	Address *Address `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAddressInput"}

	if s.Address == nil {
		invalidParams.Add(aws.NewErrParamRequired("Address"))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddressResult
type CreateAddressOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address. You'll use this ID
	// when you create a job to specify which address you want the Snowball for
	// that job shipped to.
	AddressId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAddress = "CreateAddress"

// CreateAddressRequest returns a request value for making API operation for
// Amazon Import/Export Snowball.
//
// Creates an address for a Snowball to be shipped to. In most regions, addresses
// are validated at the time of creation. The address you provide must be located
// within the serviceable area of your region. If the address is invalid or
// unsupported, then an exception is thrown.
//
//    // Example sending a request using CreateAddressRequest.
//    req := client.CreateAddressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress
func (c *Client) CreateAddressRequest(input *CreateAddressInput) CreateAddressRequest {
	op := &aws.Operation{
		Name:       opCreateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressInput{}
	}

	req := c.newRequest(op, input, &CreateAddressOutput{})
	return CreateAddressRequest{Request: req, Input: input, Copy: c.CreateAddressRequest}
}

// CreateAddressRequest is the request type for the
// CreateAddress API operation.
type CreateAddressRequest struct {
	*aws.Request
	Input *CreateAddressInput
	Copy  func(*CreateAddressInput) CreateAddressRequest
}

// Send marshals and sends the CreateAddress API request.
func (r CreateAddressRequest) Send(ctx context.Context) (*CreateAddressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAddressResponse{
		CreateAddressOutput: r.Request.Data.(*CreateAddressOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAddressResponse is the response type for the
// CreateAddress API operation.
type CreateAddressResponse struct {
	*CreateAddressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAddress request.
func (r *CreateAddressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
