// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfigurationRequest
type DeleteAppLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ID of the application associated with the launch configuration.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s DeleteAppLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfigurationResponse
type DeleteAppLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAppLaunchConfiguration = "DeleteAppLaunchConfiguration"

// DeleteAppLaunchConfigurationRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Deletes existing launch configuration for an application.
//
//    // Example sending a request using DeleteAppLaunchConfigurationRequest.
//    req := client.DeleteAppLaunchConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfiguration
func (c *Client) DeleteAppLaunchConfigurationRequest(input *DeleteAppLaunchConfigurationInput) DeleteAppLaunchConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteAppLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppLaunchConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteAppLaunchConfigurationOutput{})
	return DeleteAppLaunchConfigurationRequest{Request: req, Input: input, Copy: c.DeleteAppLaunchConfigurationRequest}
}

// DeleteAppLaunchConfigurationRequest is the request type for the
// DeleteAppLaunchConfiguration API operation.
type DeleteAppLaunchConfigurationRequest struct {
	*aws.Request
	Input *DeleteAppLaunchConfigurationInput
	Copy  func(*DeleteAppLaunchConfigurationInput) DeleteAppLaunchConfigurationRequest
}

// Send marshals and sends the DeleteAppLaunchConfiguration API request.
func (r DeleteAppLaunchConfigurationRequest) Send(ctx context.Context) (*DeleteAppLaunchConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAppLaunchConfigurationResponse{
		DeleteAppLaunchConfigurationOutput: r.Request.Data.(*DeleteAppLaunchConfigurationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAppLaunchConfigurationResponse is the response type for the
// DeleteAppLaunchConfiguration API operation.
type DeleteAppLaunchConfigurationResponse struct {
	*DeleteAppLaunchConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAppLaunchConfiguration request.
func (r *DeleteAppLaunchConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
