// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// When included in a receipt rule, this action adds a header to the received
// email.
//
// For information about adding a header using a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/AddHeaderAction
type AddHeaderAction struct {
	_ struct{} `type:"structure"`

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// Must be less than 2048 characters, and must not contain newline characters
	// ("\r" or "\n").
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddHeaderAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddHeaderAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddHeaderAction"}

	if s.HeaderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderName"))
	}

	if s.HeaderValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the body of the message. You can specify text, HTML, or both.
// If you use both, then the message should display correctly in the widest
// variety of email clients.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Body
type Body struct {
	_ struct{} `type:"structure"`

	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	Html *Content `type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(aws.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When included in a receipt rule, this action rejects the received email by
// returning a bounce response to the sender and, optionally, publishes a notification
// to Amazon Simple Notification Service (Amazon SNS).
//
// For information about sending a bounce message in response to a received
// email, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BounceAction
type BounceAction struct {
	_ struct{} `type:"structure"`

	// Human-readable text to include in the bounce message.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The email address of the sender of the bounced email. This is the address
	// from which the bounce message will be sent.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The SMTP reply code, as defined by RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// SmtpReplyCode is a required field
	SmtpReplyCode *string `type:"string" required:"true"`

	// The SMTP enhanced status code, as defined by RFC 3463 (https://tools.ietf.org/html/rfc3463).
	StatusCode *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// bounce action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s BounceAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BounceAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BounceAction"}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}

	if s.Sender == nil {
		invalidParams.Add(aws.NewErrParamRequired("Sender"))
	}

	if s.SmtpReplyCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("SmtpReplyCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BouncedRecipientInfo
type BouncedRecipientInfo struct {
	_ struct{} `type:"structure"`

	// The reason for the bounce. You must provide either this parameter or RecipientDsnFields.
	BounceType BounceType `type:"string" enum:"true"`

	// The email address of the recipient of the bounced email.
	//
	// Recipient is a required field
	Recipient *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to receive email for the recipient of the bounced email. For more information
	// about sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	RecipientArn *string `type:"string"`

	// Recipient-related DSN fields, most of which would normally be filled in automatically
	// when provided with a BounceType. You must provide either this parameter or
	// BounceType.
	RecipientDsnFields *RecipientDsnFields `type:"structure"`
}

// String returns the string representation
func (s BouncedRecipientInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BouncedRecipientInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BouncedRecipientInfo"}

	if s.Recipient == nil {
		invalidParams.Add(aws.NewErrParamRequired("Recipient"))
	}
	if s.RecipientDsnFields != nil {
		if err := s.RecipientDsnFields.Validate(); err != nil {
			invalidParams.AddNested("RecipientDsnFields", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An array that contains one or more Destinations, as well as the tags and
// replacement data associated with each of those Destinations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BulkEmailDestination
type BulkEmailDestination struct {
	_ struct{} `type:"structure"`

	// Represents the destination of the message, consisting of To:, CC:, and BCC:
	// fields.
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the local part of
	// a destination email address (the part of the email address that precedes
	// the @ sign) may only contain 7-bit ASCII characters (https://en.wikipedia.org/wiki/Email_address#Local-part).
	// If the domain part of an address (the part after the @ sign) contains non-ASCII
	// characters, they must be encoded using Punycode, as described in RFC3492
	// (https://tools.ietf.org/html/rfc3492.html).
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendBulkTemplatedEmail. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	ReplacementTags []MessageTag `type:"list"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	ReplacementTemplateData *string `type:"string"`
}

// String returns the string representation
func (s BulkEmailDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkEmailDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BulkEmailDestination"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.ReplacementTags != nil {
		for i, v := range s.ReplacementTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplacementTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object that contains the response from the SendBulkTemplatedEmail operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BulkEmailDestinationStatus
type BulkEmailDestinationStatus struct {
	_ struct{} `type:"structure"`

	// A description of an error that prevented a message being sent using the SendBulkTemplatedEmail
	// operation.
	Error *string `type:"string"`

	// The unique message identifier returned from the SendBulkTemplatedEmail operation.
	MessageId *string `type:"string"`

	// The status of a message sent using the SendBulkTemplatedEmail operation.
	//
	// Possible values for this parameter include:
	//
	//    * Success: Amazon SES accepted the message, and will attempt to deliver
	//    it to the recipients.
	//
	//    * MessageRejected: The message was rejected because it contained a virus.
	//
	//    * MailFromDomainNotVerified: The sender's email address or domain was
	//    not verified.
	//
	//    * ConfigurationSetDoesNotExist: The configuration set you specified does
	//    not exist.
	//
	//    * TemplateDoesNotExist: The template you specified does not exist.
	//
	//    * AccountSuspended: Your account has been shut down because of issues
	//    related to your email sending practices.
	//
	//    * AccountThrottled: The number of emails you can send has been reduced
	//    because your account has exceeded its allocated sending limit.
	//
	//    * AccountDailyQuotaExceeded: You have reached or exceeded the maximum
	//    number of emails you can send from your account in a 24-hour period.
	//
	//    * InvalidSendingPoolName: The configuration set you specified refers to
	//    an IP pool that does not exist.
	//
	//    * AccountSendingPaused: Email sending for the Amazon SES account was disabled
	//    using the UpdateAccountSendingEnabled operation.
	//
	//    * ConfigurationSetSendingPaused: Email sending for this configuration
	//    set was disabled using the UpdateConfigurationSetSendingEnabled operation.
	//
	//    * InvalidParameterValue: One or more of the parameters you specified when
	//    calling this operation was invalid. See the error message for additional
	//    information.
	//
	//    * TransientFailure: Amazon SES was unable to process your request because
	//    of a temporary issue.
	//
	//    * Failed: Amazon SES was unable to process your request. See the error
	//    message for additional information.
	Status BulkEmailStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s BulkEmailDestinationStatus) String() string {
	return awsutil.Prettify(s)
}

// Contains information associated with an Amazon CloudWatch event destination
// to which email sending events are published.
//
// Event destinations, such as Amazon CloudWatch, are associated with configuration
// sets, which enable you to publish email sending events. For information about
// using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloudWatchDestination
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// A list of dimensions upon which to categorize your emails when you publish
	// email sending events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchDestination"}

	if s.DimensionConfigurations == nil {
		invalidParams.Add(aws.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the dimension configuration to use when you publish email sending
// events to Amazon CloudWatch.
//
// For information about publishing email sending events to Amazon CloudWatch,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloudWatchDimensionConfiguration
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you do not provide the value of the dimension when you send an email.
	// The default value must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The place where Amazon SES finds the value of a dimension to publish to Amazon
	// CloudWatch. If you want Amazon SES to use the message tags that you specify
	// using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail
	// API, choose messageTag. If you want Amazon SES to use your own email headers,
	// choose emailHeader.
	//
	// DimensionValueSource is a required field
	DimensionValueSource DimensionValueSource `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}

	if s.DefaultDimensionValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultDimensionValue"))
	}

	if s.DimensionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DimensionName"))
	}
	if len(s.DimensionValueSource) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The name of the configuration set.
//
// Configuration sets let you create groups of rules that you can apply to the
// emails you send using Amazon SES. For more information about using configuration
// sets, see Using Amazon SES Configuration Sets (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/using-configuration-sets.html)
// in the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ConfigurationSet
type ConfigurationSet struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set. The name must meet the following requirements:
	//
	//    * Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//    dashes (-).
	//
	//    * Contain 64 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigurationSet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationSet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigurationSet"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents textual data, plus an optional character set specification.
//
// By default, the text must be 7-bit ASCII, due to the constraints of the SMTP
// protocol. If the text must contain any other characters, then you must also
// specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Content
type Content struct {
	_ struct{} `type:"structure"`

	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Content"}

	if s.Data == nil {
		invalidParams.Add(aws.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a custom verification email template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CustomVerificationEmailTemplate
type CustomVerificationEmailTemplate struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation
func (s CustomVerificationEmailTemplate) String() string {
	return awsutil.Prettify(s)
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields.
//
// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
// (https://tools.ietf.org/html/rfc6531). For this reason, the local part of
// a destination email address (the part of the email address that precedes
// the @ sign) may only contain 7-bit ASCII characters (https://en.wikipedia.org/wiki/Email_address#Local-part).
// If the domain part of an address (the part after the @ sign) contains non-ASCII
// characters, they must be encoded using Punycode, as described in RFC3492
// (https://tools.ietf.org/html/rfc3492.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// The BCC: field(s) of the message.
	BccAddresses []string `type:"list"`

	// The CC: field(s) of the message.
	CcAddresses []string `type:"list"`

	// The To: field(s) of the message.
	ToAddresses []string `type:"list"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the event destination that the specified email
// sending events will be published to.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis
// Firehose or Amazon Simple Notification Service (Amazon SNS).
//
// Event destinations are associated with configuration sets, which enable you
// to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose,
// or Amazon Simple Notification Service (Amazon SNS). For information about
// using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/EventDestination
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains the names, default values, and sources of the dimensions
	// associated with an Amazon CloudWatch event destination.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// Sets whether Amazon SES publishes events to this destination when you send
	// an email with the associated configuration set. Set to true to enable publishing
	// to this destination; set to false to prevent publishing to this destination.
	// The default value is false.
	Enabled *bool `type:"boolean"`

	// An object that contains the delivery stream ARN and the IAM role ARN associated
	// with an Amazon Kinesis Firehose event destination.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The type of email sending events to publish to the event destination.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []EventType `type:"list" required:"true"`

	// The name of the event destination. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An object that contains the topic ARN associated with an Amazon Simple Notification
	// Service (Amazon SNS) event destination.
	SNSDestination *SNSDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventDestination"}

	if s.MatchingEventTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("MatchingEventTypes"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(aws.ErrInvalidParams))
		}
	}
	if s.SNSDestination != nil {
		if err := s.SNSDestination.Validate(); err != nil {
			invalidParams.AddNested("SNSDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Additional X-headers to include in the Delivery Status Notification (DSN)
// when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ExtensionField
type ExtensionField struct {
	_ struct{} `type:"structure"`

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the header to add. Must be less than 2048 characters, and must
	// not contain newline characters ("\r" or "\n").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExtensionField) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionField) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExtensionField"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the DKIM attributes of a verified email address or a domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityDkimAttributes
type IdentityDkimAttributes struct {
	_ struct{} `type:"structure"`

	// True if DKIM signing is enabled for email sent from the identity; false otherwise.
	// The default value is true.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you will need to create DNS CNAME records that point to DKIM public
	// keys hosted by Amazon SES. Amazon Web Services will eventually detect that
	// you have updated your DNS records; this detection process may take up to
	// 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DkimTokens []string `type:"list"`

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	//
	// DkimVerificationStatus is a required field
	DkimVerificationStatus VerificationStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s IdentityDkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents the custom MAIL FROM domain attributes of a verified identity
// (email address or domain).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityMailFromDomainAttributes
type IdentityMailFromDomainAttributes struct {
	_ struct{} `type:"structure"`

	// The action that Amazon SES takes if it cannot successfully read the required
	// MX record when you send an email. A value of UseDefaultValue indicates that
	// if Amazon SES cannot read the required MX record, it uses amazonses.com (or
	// a subdomain of that) as the MAIL FROM domain. A value of RejectMessage indicates
	// that if Amazon SES cannot read the required MX record, Amazon SES returns
	// a MailFromDomainNotVerified error and does not send the email.
	//
	// The custom MAIL FROM setup states that result in this behavior are Pending,
	// Failed, and TemporaryFailure.
	//
	// BehaviorOnMXFailure is a required field
	BehaviorOnMXFailure BehaviorOnMXFailure `type:"string" required:"true" enum:"true"`

	// The custom MAIL FROM domain that the identity is configured to use.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The state that indicates whether Amazon SES has successfully read the MX
	// record required for custom MAIL FROM domain setup. If the state is Success,
	// Amazon SES uses the specified custom MAIL FROM domain when the verified identity
	// sends an email. All other states indicate that Amazon SES takes the action
	// described by BehaviorOnMXFailure.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus CustomMailFromStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s IdentityMailFromDomainAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents the notification attributes of an identity, including whether
// an identity has Amazon Simple Notification Service (Amazon SNS) topics set
// for bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityNotificationAttributes
type IdentityNotificationAttributes struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish bounce notifications.
	//
	// BounceTopic is a required field
	BounceTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish complaint notifications.
	//
	// ComplaintTopic is a required field
	ComplaintTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish delivery notifications.
	//
	// DeliveryTopic is a required field
	DeliveryTopic *string `type:"string" required:"true"`

	// Describes whether Amazon SES will forward bounce and complaint notifications
	// as email. true indicates that Amazon SES will forward bounce and complaint
	// notifications as email, while false indicates that bounce and complaint notifications
	// will be published only to the specified bounce and complaint Amazon SNS topics.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Bounce. A value of true specifies that Amazon SES
	// will include headers in bounce notifications, and a value of false specifies
	// that Amazon SES will not include headers in bounce notifications.
	HeadersInBounceNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Complaint. A value of true specifies that Amazon
	// SES will include headers in complaint notifications, and a value of false
	// specifies that Amazon SES will not include headers in complaint notifications.
	HeadersInComplaintNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Delivery. A value of true specifies that Amazon
	// SES will include headers in delivery notifications, and a value of false
	// specifies that Amazon SES will not include headers in delivery notifications.
	HeadersInDeliveryNotificationsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s IdentityNotificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents the verification attributes of a single identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityVerificationAttributes
type IdentityVerificationAttributes struct {
	_ struct{} `type:"structure"`

	// The verification status of the identity: "Pending", "Success", "Failed",
	// or "TemporaryFailure".
	//
	// VerificationStatus is a required field
	VerificationStatus VerificationStatus `type:"string" required:"true" enum:"true"`

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string `type:"string"`
}

// String returns the string representation
func (s IdentityVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// Contains the delivery stream ARN and the IAM role ARN associated with an
// Amazon Kinesis Firehose event destination.
//
// Event destinations, such as Amazon Kinesis Firehose, are associated with
// configuration sets, which enable you to publish email sending events. For
// information about using configuration sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/KinesisFirehoseDestination
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis Firehose stream that email sending events should
	// be published to.
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `type:"string" required:"true"`

	// The ARN of the IAM role under which Amazon SES publishes email sending events
	// to the Amazon Kinesis Firehose stream.
	//
	// IAMRoleARN is a required field
	IAMRoleARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseDestination"}

	if s.DeliveryStreamARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamARN"))
	}

	if s.IAMRoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("IAMRoleARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When included in a receipt rule, this action calls an AWS Lambda function
// and, optionally, publishes a notification to Amazon Simple Notification Service
// (Amazon SNS).
//
// To enable Amazon SES to call your AWS Lambda function or to publish to an
// Amazon SNS topic of another account, Amazon SES must have permission to access
// those resources. For information about giving permissions, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// For information about using AWS Lambda actions in receipt rules, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/LambdaAction
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Lambda function. An example of
	// an AWS Lambda function ARN is arn:aws:lambda:us-west-2:account-id:function:MyFunction.
	// For more information about AWS Lambda, see the AWS Lambda Developer Guide
	// (http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
	//
	// FunctionArn is a required field
	FunctionArn *string `type:"string" required:"true"`

	// The invocation type of the AWS Lambda function. An invocation type of RequestResponse
	// means that the execution of the function will immediately result in a response,
	// and a value of Event means that the function will be invoked asynchronously.
	// The default value is Event. For information about AWS Lambda invocation types,
	// see the AWS Lambda Developer Guide (http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html).
	//
	// There is a 30-second timeout on RequestResponse invocations. You should use
	// Event invocation in most cases. Use RequestResponse only when you want to
	// make a mail flow decision, such as whether to stop the receipt rule or the
	// receipt rule set.
	InvocationType InvocationType `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// Lambda action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaAction"}

	if s.FunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the message to be sent, composed of a subject and a body.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Message
type Message struct {
	_ struct{} `type:"structure"`

	// The message body.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject of the message: A short summary of the content, which will appear
	// in the recipient's inbox.
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Message"}

	if s.Body == nil {
		invalidParams.Add(aws.NewErrParamRequired("Body"))
	}

	if s.Subject == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(aws.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Message-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/MessageDsn
type MessageDsn struct {
	_ struct{} `type:"structure"`

	// When the message was received by the reporting mail transfer agent (MTA),
	// in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt) date-time format.
	ArrivalDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []ExtensionField `type:"list"`

	// The reporting MTA that attempted to deliver the message, formatted as specified
	// in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type; mta-name).
	// The default value is dns; inbound-smtp.[region].amazonaws.com.
	//
	// ReportingMta is a required field
	ReportingMta *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageDsn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageDsn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageDsn"}

	if s.ReportingMta == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportingMta"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the name and value of a tag that you can provide to SendEmail or
// SendRawEmail to apply to an email.
//
// Message tags, which you use with configuration sets, enable you to publish
// email sending events. For information about using configuration sets, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/MessageTag
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the tag. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the tag. The value must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageTag"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the raw data of the message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/RawMessage
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw data of the message. This data needs to base64-encoded if you are
	// accessing Amazon SES directly through the HTTPS interface. If you are accessing
	// Amazon SES using an AWS SDK, the SDK takes care of the base 64-encoding for
	// you. In all cases, the client must ensure that the message format complies
	// with Internet email standards regarding email header fields, MIME types,
	// and MIME encoding.
	//
	// The To:, CC:, and BCC: headers in the raw message can contain a group list.
	//
	// If you are using SendRawEmail with sending authorization, you can include
	// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
	// addresses. For more information, see the documentation for SendRawEmail.
	//
	// Do not include these X-headers in the DKIM signature, because they are removed
	// by Amazon SES before sending the email.
	//
	// For more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RawMessage"}

	if s.Data == nil {
		invalidParams.Add(aws.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An action that Amazon SES can take when it receives an email on behalf of
// one or more email addresses or domains that you own. An instance of this
// data type can represent only one action.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptAction
type ReceiptAction struct {
	_ struct{} `type:"structure"`

	// Adds a header to the received email.
	AddHeaderAction *AddHeaderAction `type:"structure"`

	// Rejects the received email by returning a bounce response to the sender and,
	// optionally, publishes a notification to Amazon Simple Notification Service
	// (Amazon SNS).
	BounceAction *BounceAction `type:"structure"`

	// Calls an AWS Lambda function, and optionally, publishes a notification to
	// Amazon SNS.
	LambdaAction *LambdaAction `type:"structure"`

	// Saves the received message to an Amazon Simple Storage Service (Amazon S3)
	// bucket and, optionally, publishes a notification to Amazon SNS.
	S3Action *S3Action `type:"structure"`

	// Publishes the email content within a notification to Amazon SNS.
	SNSAction *SNSAction `type:"structure"`

	// Terminates the evaluation of the receipt rule set and optionally publishes
	// a notification to Amazon SNS.
	StopAction *StopAction `type:"structure"`

	// Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
	// Amazon SNS.
	WorkmailAction *WorkmailAction `type:"structure"`
}

// String returns the string representation
func (s ReceiptAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReceiptAction"}
	if s.AddHeaderAction != nil {
		if err := s.AddHeaderAction.Validate(); err != nil {
			invalidParams.AddNested("AddHeaderAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.BounceAction != nil {
		if err := s.BounceAction.Validate(); err != nil {
			invalidParams.AddNested("BounceAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaAction != nil {
		if err := s.LambdaAction.Validate(); err != nil {
			invalidParams.AddNested("LambdaAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Action != nil {
		if err := s.S3Action.Validate(); err != nil {
			invalidParams.AddNested("S3Action", err.(aws.ErrInvalidParams))
		}
	}
	if s.SNSAction != nil {
		if err := s.SNSAction.Validate(); err != nil {
			invalidParams.AddNested("SNSAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.StopAction != nil {
		if err := s.StopAction.Validate(); err != nil {
			invalidParams.AddNested("StopAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.WorkmailAction != nil {
		if err := s.WorkmailAction.Validate(); err != nil {
			invalidParams.AddNested("WorkmailAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptFilter
type ReceiptFilter struct {
	_ struct{} `type:"structure"`

	// A structure that provides the IP addresses to block or allow, and whether
	// to block or allow incoming mail from them.
	//
	// IpFilter is a required field
	IpFilter *ReceiptIpFilter `type:"structure" required:"true"`

	// The name of the IP address filter. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ReceiptFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReceiptFilter"}

	if s.IpFilter == nil {
		invalidParams.Add(aws.NewErrParamRequired("IpFilter"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.IpFilter != nil {
		if err := s.IpFilter.Validate(); err != nil {
			invalidParams.AddNested("IpFilter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptIpFilter
type ReceiptIpFilter struct {
	_ struct{} `type:"structure"`

	// A single IP address or a range of IP addresses that you want to block or
	// allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example
	// of a single email address is 10.0.0.1. An example of a range of IP addresses
	// is 10.0.0.1/24. For more information about CIDR notation, see RFC 2317 (https://tools.ietf.org/html/rfc2317).
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`

	// Indicates whether to block or allow incoming mail from the specified IP addresses.
	//
	// Policy is a required field
	Policy ReceiptFilterPolicy `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ReceiptIpFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptIpFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReceiptIpFilter"}

	if s.Cidr == nil {
		invalidParams.Add(aws.NewErrParamRequired("Cidr"))
	}
	if len(s.Policy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Receipt rules enable you to specify which actions Amazon SES should take
// when it receives mail on behalf of one or more email addresses or domains
// that you own.
//
// Each receipt rule defines a set of email addresses or domains that it applies
// to. If the email addresses or domains match at least one recipient address
// of the message, Amazon SES executes all of the receipt rule's actions on
// the message.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptRule
type ReceiptRule struct {
	_ struct{} `type:"structure"`

	// An ordered list of actions to perform on messages that match at least one
	// of the recipient email addresses or domains specified in the receipt rule.
	Actions []ReceiptAction `type:"list"`

	// If true, the receipt rule is active. The default value is false.
	Enabled *bool `type:"boolean"`

	// The name of the receipt rule. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The recipient domains and email addresses that the receipt rule applies to.
	// If this field is not specified, this rule will match all recipients under
	// all verified domains.
	Recipients []string `type:"list"`

	// If true, then messages that this receipt rule applies to are scanned for
	// spam and viruses. The default value is false.
	ScanEnabled *bool `type:"boolean"`

	// Specifies whether Amazon SES should require that incoming email is delivered
	// over a connection encrypted with Transport Layer Security (TLS). If this
	// parameter is set to Require, Amazon SES will bounce emails that are not received
	// over TLS. The default is Optional.
	TlsPolicy TlsPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s ReceiptRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReceiptRule"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a receipt rule set.
//
// A receipt rule set is a collection of rules that specify what Amazon SES
// should do with mail it receives on behalf of your account's verified domains.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptRuleSetMetadata
type ReceiptRuleSetMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the receipt rule set was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the receipt rule set. The name must:
	//
	//    * This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
	//    underscores (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ReceiptRuleSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/RecipientDsnFields
type RecipientDsnFields struct {
	_ struct{} `type:"structure"`

	// The action performed by the reporting mail transfer agent (MTA) as a result
	// of its attempt to deliver the message to the recipient address. This is required
	// by RFC 3464 (https://tools.ietf.org/html/rfc3464).
	//
	// Action is a required field
	Action DsnAction `type:"string" required:"true" enum:"true"`

	// An extended explanation of what went wrong; this is usually an SMTP response.
	// See RFC 3463 (https://tools.ietf.org/html/rfc3463) for the correct formatting
	// of this parameter.
	DiagnosticCode *string `type:"string"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []ExtensionField `type:"list"`

	// The email address that the message was ultimately delivered to. This corresponds
	// to the Final-Recipient in the DSN. If not specified, FinalRecipient will
	// be set to the Recipient specified in the BouncedRecipientInfo structure.
	// Either FinalRecipient or the recipient in BouncedRecipientInfo must be a
	// recipient of the original bounced message.
	//
	// Do not prepend the FinalRecipient email address with rfc 822;, as described
	// in RFC 3798 (https://tools.ietf.org/html/rfc3798).
	FinalRecipient *string `type:"string"`

	// The time the final delivery attempt was made, in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt)
	// date-time format.
	LastAttemptDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The MTA to which the remote MTA attempted to deliver the message, formatted
	// as specified in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type;
	// mta-name). This parameter typically applies only to propagating synchronous
	// bounces.
	RemoteMta *string `type:"string"`

	// The status code that indicates what went wrong. This is required by RFC 3464
	// (https://tools.ietf.org/html/rfc3464).
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RecipientDsnFields) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipientDsnFields) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecipientDsnFields"}
	if len(s.Action) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Status == nil {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the reputation settings for a configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReputationOptions
type ReputationOptions struct {
	_ struct{} `type:"structure"`

	// The date and time at which the reputation metrics for the configuration set
	// were last reset. Resetting these metrics is known as a fresh start.
	//
	// When you disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled
	// and later re-enable it, the reputation metrics for the configuration set
	// (but not for the entire Amazon SES account) are reset.
	//
	// If email sending for the configuration set has never been disabled and later
	// re-enabled, the value of this attribute is null.
	LastFreshStart *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Describes whether or not Amazon SES publishes reputation metrics for the
	// configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
	//
	// If the value is true, reputation metrics are published. If the value is false,
	// reputation metrics are not published. The default value is false.
	ReputationMetricsEnabled *bool `type:"boolean"`

	// Describes whether email sending is enabled or disabled for the configuration
	// set. If the value is true, then Amazon SES will send emails that use the
	// configuration set. If the value is false, Amazon SES will not send emails
	// that use the configuration set. The default value is true. You can change
	// this setting using UpdateConfigurationSetSendingEnabled.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReputationOptions) String() string {
	return awsutil.Prettify(s)
}

// When included in a receipt rule, this action saves the received message to
// an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
// a notification to Amazon Simple Notification Service (Amazon SNS).
//
// To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS
// KMS key to encrypt your emails, or publish to an Amazon SNS topic of another
// account, Amazon SES must have permission to access those resources. For information
// about giving permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// When you save your emails to an Amazon S3 bucket, the maximum email size
// (including headers) is 30 MB. Emails larger than that will bounce.
//
// For information about specifying Amazon S3 actions in receipt rules, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/S3Action
type S3Action struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket that incoming email will be saved to.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The customer master key that Amazon SES should use to encrypt your emails
	// before saving them to the Amazon S3 bucket. You can use the default master
	// key or a custom master key you created in AWS KMS as follows:
	//
	//    * To use the default master key, provide an ARN in the form of arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses.
	//    For example, if your AWS account ID is 123456789012 and you want to use
	//    the default master key in the US West (Oregon) region, the ARN of the
	//    default master key would be arn:aws:kms:us-west-2:123456789012:alias/aws/ses.
	//    If you use the default master key, you don't need to perform any extra
	//    steps to give Amazon SES permission to use the key.
	//
	//    * To use a custom master key you created in AWS KMS, provide the ARN of
	//    the master key and ensure that you add a statement to your key's policy
	//    to give Amazon SES permission to use it. For more information about giving
	//    permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
	//
	// For more information about key policies, see the AWS KMS Developer Guide
	// (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html). If
	// you do not specify a master key, Amazon SES will not encrypt your emails.
	//
	// Your mail is encrypted by Amazon SES using the Amazon S3 encryption client
	// before the mail is submitted to Amazon S3 for storage. It is not encrypted
	// using Amazon S3 server-side encryption. This means that you must use the
	// Amazon S3 encryption client to decrypt the email after retrieving it from
	// Amazon S3, as the service has no access to use your AWS KMS keys for decryption.
	// This encryption client is currently available with the AWS SDK for Java (http://aws.amazon.com/sdk-for-java/)
	// and AWS SDK for Ruby (http://aws.amazon.com/sdk-for-ruby/) only. For more
	// information about client-side encryption using AWS KMS master keys, see the
	// Amazon S3 Developer Guide (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
	KmsKeyArn *string `type:"string"`

	// The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory
	// name that enables you to store similar data under the same directory in a
	// bucket.
	ObjectKeyPrefix *string `type:"string"`

	// The ARN of the Amazon SNS topic to notify when the message is saved to the
	// Amazon S3 bucket. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Action"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When included in a receipt rule, this action publishes a notification to
// Amazon Simple Notification Service (Amazon SNS). This action includes a complete
// copy of the email content in the Amazon SNS notifications. Amazon SNS notifications
// for all other actions simply provide information about the email. They do
// not include the email content itself.
//
// If you own the Amazon SNS topic, you don't need to do anything to give Amazon
// SES permission to publish emails to it. However, if you don't own the Amazon
// SNS topic, you need to attach a policy to the topic to give Amazon SES permissions
// to access it. For information about giving permissions, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// You can only publish emails that are 150 KB or less (including the header)
// to Amazon SNS. Larger emails will bounce. If you anticipate emails larger
// than 150 KB, use the S3 action instead.
//
// For information about using a receipt rule to publish an Amazon SNS notification,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SNSAction
type SNSAction struct {
	_ struct{} `type:"structure"`

	// The encoding to use for the email within the Amazon SNS notification. UTF-8
	// is easier to use, but may not preserve all special characters when a message
	// was encoded with a different encoding format. Base64 preserves all special
	// characters. The default value is UTF-8.
	Encoding SNSActionEncoding `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example
	// of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SNSAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SNSAction"}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the topic ARN associated with an Amazon Simple Notification Service
// (Amazon SNS) event destination.
//
// Event destinations, such as Amazon SNS, are associated with configuration
// sets, which enable you to publish email sending events. For information about
// using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SNSDestination
type SNSDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon SNS topic that email sending events will be published
	// to. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicARN is a required field
	TopicARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SNSDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SNSDestination"}

	if s.TopicARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents sending statistics data. Each SendDataPoint contains statistics
// for a 15-minute period of sending activity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendDataPoint
type SendDataPoint struct {
	_ struct{} `type:"structure"`

	// Number of emails that have bounced.
	Bounces *int64 `type:"long"`

	// Number of unwanted emails that were rejected by recipients.
	Complaints *int64 `type:"long"`

	// Number of emails that have been sent.
	DeliveryAttempts *int64 `type:"long"`

	// Number of emails rejected by Amazon SES.
	Rejects *int64 `type:"long"`

	// Time of the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SendDataPoint) String() string {
	return awsutil.Prettify(s)
}

// When included in a receipt rule, this action terminates the evaluation of
// the receipt rule set and, optionally, publishes a notification to Amazon
// Simple Notification Service (Amazon SNS).
//
// For information about setting a stop action in a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/StopAction
type StopAction struct {
	_ struct{} `type:"structure"`

	// The name of the RuleSet that is being stopped.
	//
	// Scope is a required field
	Scope StopScope `type:"string" required:"true" enum:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// stop action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s StopAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopAction"}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The content of the email, composed of a subject line, an HTML part, and a
// text-only part.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Template
type Template struct {
	_ struct{} `type:"structure"`

	// The HTML body of the email.
	HtmlPart *string `type:"string"`

	// The subject line of the email.
	SubjectPart *string `type:"string"`

	// The name of the template. You will refer to this name when you send email
	// using the SendTemplatedEmail or SendBulkTemplatedEmail operations.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The email body that will be visible to recipients whose email clients do
	// not display HTML.
	TextPart *string `type:"string"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Template) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Template"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about an email template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TemplateMetadata
type TemplateMetadata struct {
	_ struct{} `type:"structure"`

	// The time and date the template was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the template.
	Name *string `type:"string"`
}

// String returns the string representation
func (s TemplateMetadata) String() string {
	return awsutil.Prettify(s)
}

// A domain that is used to redirect email recipients to an Amazon SES-operated
// domain. This domain captures open and click events generated by Amazon SES
// emails.
//
// For more information, see Configuring Custom Domains to Handle Open and Click
// Tracking (ses/latest/DeveloperGuide/configure-custom-open-click-domains.html)
// in the Amazon SES Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TrackingOptions
type TrackingOptions struct {
	_ struct{} `type:"structure"`

	// The custom subdomain that will be used to redirect email recipients to the
	// Amazon SES event tracking domain.
	CustomRedirectDomain *string `type:"string"`
}

// String returns the string representation
func (s TrackingOptions) String() string {
	return awsutil.Prettify(s)
}

// When included in a receipt rule, this action calls Amazon WorkMail and, optionally,
// publishes a notification to Amazon Simple Notification Service (Amazon SNS).
// You will typically not use this action directly because Amazon WorkMail adds
// the rule automatically during its setup procedure.
//
// For information using a receipt rule to call Amazon WorkMail, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/WorkmailAction
type WorkmailAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
	// organization ARN is arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7.
	// For information about Amazon WorkMail organizations, see the Amazon WorkMail
	// Administrator Guide (http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html).
	//
	// OrganizationArn is a required field
	OrganizationArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// WorkMail action is called. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s WorkmailAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkmailAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkmailAction"}

	if s.OrganizationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
