// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespaceRequest
type CreatePublicDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreatePublicDnsNamespace
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicDnsNamespaceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePublicDnsNamespaceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespaceResponse
type CreatePublicDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePublicDnsNamespace = "CreatePublicDnsNamespace"

// CreatePublicDnsNamespaceRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Creates a public namespace based on DNS, which will be visible on the internet.
// The namespace defines your service naming scheme. For example, if you name
// your namespace example.com and name your service backend, the resulting DNS
// name for the service will be backend.example.com. For the current limit on
// the number of namespaces that you can create using the same AWS account,
// see AWS Cloud Map Limits (http://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
//    // Example sending a request using CreatePublicDnsNamespaceRequest.
//    req := client.CreatePublicDnsNamespaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace
func (c *Client) CreatePublicDnsNamespaceRequest(input *CreatePublicDnsNamespaceInput) CreatePublicDnsNamespaceRequest {
	op := &aws.Operation{
		Name:       opCreatePublicDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicDnsNamespaceInput{}
	}

	req := c.newRequest(op, input, &CreatePublicDnsNamespaceOutput{})
	return CreatePublicDnsNamespaceRequest{Request: req, Input: input, Copy: c.CreatePublicDnsNamespaceRequest}
}

// CreatePublicDnsNamespaceRequest is the request type for the
// CreatePublicDnsNamespace API operation.
type CreatePublicDnsNamespaceRequest struct {
	*aws.Request
	Input *CreatePublicDnsNamespaceInput
	Copy  func(*CreatePublicDnsNamespaceInput) CreatePublicDnsNamespaceRequest
}

// Send marshals and sends the CreatePublicDnsNamespace API request.
func (r CreatePublicDnsNamespaceRequest) Send(ctx context.Context) (*CreatePublicDnsNamespaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePublicDnsNamespaceResponse{
		CreatePublicDnsNamespaceOutput: r.Request.Data.(*CreatePublicDnsNamespaceOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePublicDnsNamespaceResponse is the response type for the
// CreatePublicDnsNamespace API operation.
type CreatePublicDnsNamespaceResponse struct {
	*CreatePublicDnsNamespaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePublicDnsNamespace request.
func (r *CreatePublicDnsNamespaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
