// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResourceInput
type DisassociateBudgetFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the budget you want to disassociate.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The resource identifier you want to disassociate from. Either a portfolio-id
	// or a product-id.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateBudgetFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateBudgetFromResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateBudgetFromResourceInput"}

	if s.BudgetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BudgetName", 1))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResourceOutput
type DisassociateBudgetFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateBudgetFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateBudgetFromResource = "DisassociateBudgetFromResource"

// DisassociateBudgetFromResourceRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Disassociates the specified budget from the specified resource.
//
//    // Example sending a request using DisassociateBudgetFromResourceRequest.
//    req := client.DisassociateBudgetFromResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource
func (c *Client) DisassociateBudgetFromResourceRequest(input *DisassociateBudgetFromResourceInput) DisassociateBudgetFromResourceRequest {
	op := &aws.Operation{
		Name:       opDisassociateBudgetFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateBudgetFromResourceInput{}
	}

	req := c.newRequest(op, input, &DisassociateBudgetFromResourceOutput{})
	return DisassociateBudgetFromResourceRequest{Request: req, Input: input, Copy: c.DisassociateBudgetFromResourceRequest}
}

// DisassociateBudgetFromResourceRequest is the request type for the
// DisassociateBudgetFromResource API operation.
type DisassociateBudgetFromResourceRequest struct {
	*aws.Request
	Input *DisassociateBudgetFromResourceInput
	Copy  func(*DisassociateBudgetFromResourceInput) DisassociateBudgetFromResourceRequest
}

// Send marshals and sends the DisassociateBudgetFromResource API request.
func (r DisassociateBudgetFromResourceRequest) Send(ctx context.Context) (*DisassociateBudgetFromResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateBudgetFromResourceResponse{
		DisassociateBudgetFromResourceOutput: r.Request.Data.(*DisassociateBudgetFromResourceOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateBudgetFromResourceResponse is the response type for the
// DisassociateBudgetFromResource API operation.
type DisassociateBudgetFromResourceResponse struct {
	*DisassociateBudgetFromResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateBudgetFromResource request.
func (r *DisassociateBudgetFromResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
