// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingRequest
type PutBucketTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Tagging == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "Tagging", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingOutput
type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the tags for a bucket.
//
//    // Example sending a request using PutBucketTaggingRequest.
//    req := client.PutBucketTaggingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *Client) PutBucketTaggingRequest(input *PutBucketTaggingInput) PutBucketTaggingRequest {
	op := &aws.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	req := c.newRequest(op, input, &PutBucketTaggingOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketTaggingRequest{Request: req, Input: input, Copy: c.PutBucketTaggingRequest}
}

// PutBucketTaggingRequest is the request type for the
// PutBucketTagging API operation.
type PutBucketTaggingRequest struct {
	*aws.Request
	Input *PutBucketTaggingInput
	Copy  func(*PutBucketTaggingInput) PutBucketTaggingRequest
}

// Send marshals and sends the PutBucketTagging API request.
func (r PutBucketTaggingRequest) Send(ctx context.Context) (*PutBucketTaggingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketTaggingResponse{
		PutBucketTaggingOutput: r.Request.Data.(*PutBucketTaggingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketTaggingResponse is the response type for the
// PutBucketTagging API operation.
type PutBucketTaggingResponse struct {
	*PutBucketTaggingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketTagging request.
func (r *PutBucketTaggingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
