// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsRequest
type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPartsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *ListPartsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-parts", protocol.Int64Value(v), metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "part-number-marker", protocol.Int64Value(v), metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "uploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsOutput
type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	Owner *Owner `type:"structure"`

	// Part number after which listing begins.
	PartNumberMarker *int64 `type:"integer"`

	Parts []Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

func (s *ListPartsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPartsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.MaxParts != nil {
		v := *s.MaxParts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxParts", protocol.Int64Value(v), metadata)
	}
	if s.NextPartNumberMarker != nil {
		v := *s.NextPartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextPartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.PartNumberMarker != nil {
		v := *s.PartNumberMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumberMarker", protocol.Int64Value(v), metadata)
	}
	if len(s.Parts) > 0 {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	if s.AbortDate != nil {
		v := *s.AbortDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-date", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.AbortRuleId != nil {
		v := *s.AbortRuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-abort-rule-id", protocol.StringValue(v), metadata)
	}
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	return nil
}

const opListParts = "ListParts"

// ListPartsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
//
//    // Example sending a request using ListPartsRequest.
//    req := client.ListPartsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *Client) ListPartsRequest(input *ListPartsInput) ListPartsRequest {
	op := &aws.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req := c.newRequest(op, input, &ListPartsOutput{})
	return ListPartsRequest{Request: req, Input: input, Copy: c.ListPartsRequest}
}

// ListPartsRequest is the request type for the
// ListParts API operation.
type ListPartsRequest struct {
	*aws.Request
	Input *ListPartsInput
	Copy  func(*ListPartsInput) ListPartsRequest
}

// Send marshals and sends the ListParts API request.
func (r ListPartsRequest) Send(ctx context.Context) (*ListPartsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPartsResponse{
		ListPartsOutput: r.Request.Data.(*ListPartsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPartsRequestPaginator returns a paginator for ListParts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPartsRequest(input)
//   p := s3.NewListPartsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPartsPaginator(req ListPartsRequest) ListPartsPaginator {
	return ListPartsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPartsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPartsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPartsPaginator struct {
	aws.Pager
}

func (p *ListPartsPaginator) CurrentPage() *ListPartsOutput {
	return p.Pager.CurrentPage().(*ListPartsOutput)
}

// ListPartsResponse is the response type for the
// ListParts API operation.
type ListPartsResponse struct {
	*ListPartsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListParts request.
func (r *ListPartsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
