// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream processor you want to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamProcessorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStreamProcessorInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteStreamProcessor = "DeleteStreamProcessor"

// DeleteStreamProcessorRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Deletes the stream processor identified by Name. You assign the value for
// Name when you create the stream processor with CreateStreamProcessor. You
// might not be able to use the same name for a stream processor for a few seconds
// after calling DeleteStreamProcessor.
//
//    // Example sending a request using DeleteStreamProcessorRequest.
//    req := client.DeleteStreamProcessorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteStreamProcessorRequest(input *DeleteStreamProcessorInput) DeleteStreamProcessorRequest {
	op := &aws.Operation{
		Name:       opDeleteStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStreamProcessorInput{}
	}

	req := c.newRequest(op, input, &DeleteStreamProcessorOutput{})
	return DeleteStreamProcessorRequest{Request: req, Input: input, Copy: c.DeleteStreamProcessorRequest}
}

// DeleteStreamProcessorRequest is the request type for the
// DeleteStreamProcessor API operation.
type DeleteStreamProcessorRequest struct {
	*aws.Request
	Input *DeleteStreamProcessorInput
	Copy  func(*DeleteStreamProcessorInput) DeleteStreamProcessorRequest
}

// Send marshals and sends the DeleteStreamProcessor API request.
func (r DeleteStreamProcessorRequest) Send(ctx context.Context) (*DeleteStreamProcessorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStreamProcessorResponse{
		DeleteStreamProcessorOutput: r.Request.Data.(*DeleteStreamProcessorOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStreamProcessorResponse is the response type for the
// DeleteStreamProcessor API operation.
type DeleteStreamProcessorResponse struct {
	*DeleteStreamProcessorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStreamProcessor request.
func (r *DeleteStreamProcessorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
