// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootClusterMessage
type RebootClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootClusterInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootClusterResult
type RebootClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RebootClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootCluster = "RebootCluster"

// RebootClusterRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Reboots a cluster. This action is taken as soon as possible. It results in
// a momentary outage to the cluster, during which the cluster status is set
// to rebooting. A cluster event is created when the reboot is completed. Any
// pending cluster modifications (see ModifyCluster) are applied at this reboot.
// For more information about managing clusters, go to Amazon Redshift Clusters
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using RebootClusterRequest.
//    req := client.RebootClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster
func (c *Client) RebootClusterRequest(input *RebootClusterInput) RebootClusterRequest {
	op := &aws.Operation{
		Name:       opRebootCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootClusterInput{}
	}

	req := c.newRequest(op, input, &RebootClusterOutput{})
	return RebootClusterRequest{Request: req, Input: input, Copy: c.RebootClusterRequest}
}

// RebootClusterRequest is the request type for the
// RebootCluster API operation.
type RebootClusterRequest struct {
	*aws.Request
	Input *RebootClusterInput
	Copy  func(*RebootClusterInput) RebootClusterRequest
}

// Send marshals and sends the RebootCluster API request.
func (r RebootClusterRequest) Send(ctx context.Context) (*RebootClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootClusterResponse{
		RebootClusterOutput: r.Request.Data.(*RebootClusterOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootClusterResponse is the response type for the
// RebootCluster API operation.
type RebootClusterResponse struct {
	*RebootClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootCluster request.
func (r *RebootClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
