// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroupMessage
type DeleteClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to be deleted.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSecurityGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterSecurityGroupInput"}

	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroupOutput
type DeleteClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteClusterSecurityGroup = "DeleteClusterSecurityGroup"

// DeleteClusterSecurityGroupRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes an Amazon Redshift security group.
//
// You cannot delete a security group that is associated with any clusters.
// You cannot delete the default security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using DeleteClusterSecurityGroupRequest.
//    req := client.DeleteClusterSecurityGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup
func (c *Client) DeleteClusterSecurityGroupRequest(input *DeleteClusterSecurityGroupInput) DeleteClusterSecurityGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSecurityGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteClusterSecurityGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteClusterSecurityGroupRequest{Request: req, Input: input, Copy: c.DeleteClusterSecurityGroupRequest}
}

// DeleteClusterSecurityGroupRequest is the request type for the
// DeleteClusterSecurityGroup API operation.
type DeleteClusterSecurityGroupRequest struct {
	*aws.Request
	Input *DeleteClusterSecurityGroupInput
	Copy  func(*DeleteClusterSecurityGroupInput) DeleteClusterSecurityGroupRequest
}

// Send marshals and sends the DeleteClusterSecurityGroup API request.
func (r DeleteClusterSecurityGroupRequest) Send(ctx context.Context) (*DeleteClusterSecurityGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClusterSecurityGroupResponse{
		DeleteClusterSecurityGroupOutput: r.Request.Data.(*DeleteClusterSecurityGroupOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClusterSecurityGroupResponse is the response type for the
// DeleteClusterSecurityGroup API operation.
type DeleteClusterSecurityGroupResponse struct {
	*DeleteClusterSecurityGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClusterSecurityGroup request.
func (r *DeleteClusterSecurityGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
