// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsdata

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Column Metadata
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ColumnMetadata
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// Homogenous array base SQL type from java.sql.Types.
	ArrayBaseColumnType *int64 `locationName:"arrayBaseColumnType" type:"integer"`

	// Whether the designated column is automatically numbered
	IsAutoIncrement *bool `locationName:"isAutoIncrement" type:"boolean"`

	// Whether values in the designated column's case matters
	IsCaseSensitive *bool `locationName:"isCaseSensitive" type:"boolean"`

	// Whether values in the designated column is a cash value
	IsCurrency *bool `locationName:"isCurrency" type:"boolean"`

	// Whether values in the designated column are signed numbers
	IsSigned *bool `locationName:"isSigned" type:"boolean"`

	// Usually specified by the SQL AS. If not specified, return column name.
	Label *string `locationName:"label" type:"string"`

	// Name of the column.
	Name *string `locationName:"name" type:"string"`

	// Indicates the nullability of values in the designated column. One of columnNoNulls
	// (0), columnNullable (1), columnNullableUnknown (2)
	Nullable *int64 `locationName:"nullable" type:"integer"`

	// Get the designated column's specified column size.For numeric data, this
	// is the maximum precision. For character data, this is the length in characters.
	// For datetime datatypes, this is the length in characters of the String representation
	// (assuming the maximum allowed precision of the fractional seconds component).
	// For binary data, this is the length in bytes. For the ROWID datatype, this
	// is the length in bytes. 0 is returned for data types where the column size
	// is not applicable.
	Precision *int64 `locationName:"precision" type:"integer"`

	// Designated column's number of digits to right of the decimal point. 0 is
	// returned for data types where the scale is not applicable.
	Scale *int64 `locationName:"scale" type:"integer"`

	// Designated column's table's schema
	SchemaName *string `locationName:"schemaName" type:"string"`

	// Designated column's table name
	TableName *string `locationName:"tableName" type:"string"`

	// SQL type from java.sql.Types.
	Type *int64 `locationName:"type" type:"integer"`

	// Database-specific type name.
	TypeName *string `locationName:"typeName" type:"string"`
}

// String returns the string representation
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ColumnMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArrayBaseColumnType != nil {
		v := *s.ArrayBaseColumnType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arrayBaseColumnType", protocol.Int64Value(v), metadata)
	}
	if s.IsAutoIncrement != nil {
		v := *s.IsAutoIncrement

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isAutoIncrement", protocol.BoolValue(v), metadata)
	}
	if s.IsCaseSensitive != nil {
		v := *s.IsCaseSensitive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isCaseSensitive", protocol.BoolValue(v), metadata)
	}
	if s.IsCurrency != nil {
		v := *s.IsCurrency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isCurrency", protocol.BoolValue(v), metadata)
	}
	if s.IsSigned != nil {
		v := *s.IsSigned

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isSigned", protocol.BoolValue(v), metadata)
	}
	if s.Label != nil {
		v := *s.Label

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "label", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Nullable != nil {
		v := *s.Nullable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nullable", protocol.Int64Value(v), metadata)
	}
	if s.Precision != nil {
		v := *s.Precision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "precision", protocol.Int64Value(v), metadata)
	}
	if s.Scale != nil {
		v := *s.Scale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scale", protocol.Int64Value(v), metadata)
	}
	if s.SchemaName != nil {
		v := *s.SchemaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schemaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.Int64Value(v), metadata)
	}
	if s.TypeName != nil {
		v := *s.TypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "typeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Row or Record
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/Record
type Record struct {
	_ struct{} `type:"structure"`

	// Record
	Values []Value `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Record) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Values) > 0 {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Result Frame
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ResultFrame
type ResultFrame struct {
	_ struct{} `type:"structure"`

	// ResultSet Metadata.
	Records []Record `locationName:"records" type:"list"`

	// ResultSet Metadata.
	ResultSetMetadata *ResultSetMetadata `locationName:"resultSetMetadata" type:"structure"`
}

// String returns the string representation
func (s ResultFrame) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultFrame) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Records) > 0 {
		v := s.Records

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "records", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResultSetMetadata != nil {
		v := s.ResultSetMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resultSetMetadata", v, metadata)
	}
	return nil
}

// List of columns and their types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/ResultSetMetadata
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// Number of columns
	ColumnCount *int64 `locationName:"columnCount" type:"long"`

	// List of columns and their types
	ColumnMetadata []ColumnMetadata `locationName:"columnMetadata" type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResultSetMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnCount != nil {
		v := *s.ColumnCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "columnCount", protocol.Int64Value(v), metadata)
	}
	if len(s.ColumnMetadata) > 0 {
		v := s.ColumnMetadata

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "columnMetadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// SQL statement execution result
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/SqlStatementResult
type SqlStatementResult struct {
	_ struct{} `type:"structure"`

	// Number of rows updated.
	NumberOfRecordsUpdated *int64 `locationName:"numberOfRecordsUpdated" type:"long"`

	// ResultFrame returned by executing the sql statement
	ResultFrame *ResultFrame `locationName:"resultFrame" type:"structure"`
}

// String returns the string representation
func (s SqlStatementResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqlStatementResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfRecordsUpdated != nil {
		v := *s.NumberOfRecordsUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfRecordsUpdated", protocol.Int64Value(v), metadata)
	}
	if s.ResultFrame != nil {
		v := s.ResultFrame

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resultFrame", v, metadata)
	}
	return nil
}

// User Defined Type
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/StructValue
type StructValue struct {
	_ struct{} `type:"structure"`

	// Struct or UDT
	Attributes []Value `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s StructValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StructValue) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Column value
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-data-2018-08-01/Value
type Value struct {
	_ struct{} `type:"structure"`

	// Arbitrarily nested arrays
	ArrayValues []Value `locationName:"arrayValues" type:"list"`

	// Long value
	BigIntValue *int64 `locationName:"bigIntValue" type:"long"`

	// Bit value
	BitValue *bool `locationName:"bitValue" type:"boolean"`

	// Blob value
	//
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// Double value
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// Integer value
	IntValue *int64 `locationName:"intValue" type:"integer"`

	// Is column null
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// Float value
	RealValue *float64 `locationName:"realValue" type:"float"`

	// String value
	StringValue *string `locationName:"stringValue" type:"string"`

	// Struct or UDT
	StructValue *StructValue `locationName:"structValue" type:"structure"`
}

// String returns the string representation
func (s Value) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Value) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ArrayValues) > 0 {
		v := s.ArrayValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "arrayValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BigIntValue != nil {
		v := *s.BigIntValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bigIntValue", protocol.Int64Value(v), metadata)
	}
	if s.BitValue != nil {
		v := *s.BitValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitValue", protocol.BoolValue(v), metadata)
	}
	if s.BlobValue != nil {
		v := s.BlobValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blobValue", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if s.DoubleValue != nil {
		v := *s.DoubleValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "doubleValue", protocol.Float64Value(v), metadata)
	}
	if s.IntValue != nil {
		v := *s.IntValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intValue", protocol.Int64Value(v), metadata)
	}
	if s.IsNull != nil {
		v := *s.IsNull

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isNull", protocol.BoolValue(v), metadata)
	}
	if s.RealValue != nil {
		v := *s.RealValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "realValue", protocol.Float64Value(v), metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StructValue != nil {
		v := s.StructValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "structValue", v, metadata)
	}
	return nil
}
