// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidateRequest
type PhoneNumberValidateInput struct {
	_ struct{} `type:"structure" payload:"NumberValidateRequest"`

	// Phone Number Validate request.
	//
	// NumberValidateRequest is a required field
	NumberValidateRequest *NumberValidateRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumberValidateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PhoneNumberValidateInput"}

	if s.NumberValidateRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberValidateRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberValidateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.NumberValidateRequest != nil {
		v := s.NumberValidateRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "NumberValidateRequest", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidateResponse
type PhoneNumberValidateOutput struct {
	_ struct{} `type:"structure" payload:"NumberValidateResponse"`

	// Phone Number Validate response.
	//
	// NumberValidateResponse is a required field
	NumberValidateResponse *NumberValidateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberValidateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberValidateResponse != nil {
		v := s.NumberValidateResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "NumberValidateResponse", v, metadata)
	}
	return nil
}

const opPhoneNumberValidate = "PhoneNumberValidate"

// PhoneNumberValidateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Returns information about the specified phone number.
//
//    // Example sending a request using PhoneNumberValidateRequest.
//    req := client.PhoneNumberValidateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate
func (c *Client) PhoneNumberValidateRequest(input *PhoneNumberValidateInput) PhoneNumberValidateRequest {
	op := &aws.Operation{
		Name:       opPhoneNumberValidate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/phone/number/validate",
	}

	if input == nil {
		input = &PhoneNumberValidateInput{}
	}

	req := c.newRequest(op, input, &PhoneNumberValidateOutput{})
	return PhoneNumberValidateRequest{Request: req, Input: input, Copy: c.PhoneNumberValidateRequest}
}

// PhoneNumberValidateRequest is the request type for the
// PhoneNumberValidate API operation.
type PhoneNumberValidateRequest struct {
	*aws.Request
	Input *PhoneNumberValidateInput
	Copy  func(*PhoneNumberValidateInput) PhoneNumberValidateRequest
}

// Send marshals and sends the PhoneNumberValidate API request.
func (r PhoneNumberValidateRequest) Send(ctx context.Context) (*PhoneNumberValidateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PhoneNumberValidateResponse{
		PhoneNumberValidateOutput: r.Request.Data.(*PhoneNumberValidateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PhoneNumberValidateResponse is the response type for the
// PhoneNumberValidate API operation.
type PhoneNumberValidateResponse struct {
	*PhoneNumberValidateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PhoneNumberValidate request.
func (r *PhoneNumberValidateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
