// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobsRequest
type GetSegmentImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentImportJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSegmentImportJobsInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.SegmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentImportJobsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "segment-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Token != nil {
		v := *s.Token

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobsResponse
type GetSegmentImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Import job list.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentImportJobsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImportJobsResponse != nil {
		v := s.ImportJobsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ImportJobsResponse", v, metadata)
	}
	return nil
}

const opGetSegmentImportJobs = "GetSegmentImportJobs"

// GetSegmentImportJobsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Returns a list of import jobs for a specific segment.
//
//    // Example sending a request using GetSegmentImportJobsRequest.
//    req := client.GetSegmentImportJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Client) GetSegmentImportJobsRequest(input *GetSegmentImportJobsInput) GetSegmentImportJobsRequest {
	op := &aws.Operation{
		Name:       opGetSegmentImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
	}

	if input == nil {
		input = &GetSegmentImportJobsInput{}
	}

	req := c.newRequest(op, input, &GetSegmentImportJobsOutput{})
	return GetSegmentImportJobsRequest{Request: req, Input: input, Copy: c.GetSegmentImportJobsRequest}
}

// GetSegmentImportJobsRequest is the request type for the
// GetSegmentImportJobs API operation.
type GetSegmentImportJobsRequest struct {
	*aws.Request
	Input *GetSegmentImportJobsInput
	Copy  func(*GetSegmentImportJobsInput) GetSegmentImportJobsRequest
}

// Send marshals and sends the GetSegmentImportJobs API request.
func (r GetSegmentImportJobsRequest) Send(ctx context.Context) (*GetSegmentImportJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSegmentImportJobsResponse{
		GetSegmentImportJobsOutput: r.Request.Data.(*GetSegmentImportJobsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSegmentImportJobsResponse is the response type for the
// GetSegmentImportJobs API operation.
type GetSegmentImportJobsResponse struct {
	*GetSegmentImportJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSegmentImportJobs request.
func (r *GetSegmentImportJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
