// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignRequest
type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCampaignInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.CampaignId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCampaignInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "campaign-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignResponse
type GetCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCampaignOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CampaignResponse != nil {
		v := s.CampaignResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CampaignResponse", v, metadata)
	}
	return nil
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Returns information about a campaign.
//
//    // Example sending a request using GetCampaignRequest.
//    req := client.GetCampaignRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Client) GetCampaignRequest(input *GetCampaignInput) GetCampaignRequest {
	op := &aws.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	req := c.newRequest(op, input, &GetCampaignOutput{})
	return GetCampaignRequest{Request: req, Input: input, Copy: c.GetCampaignRequest}
}

// GetCampaignRequest is the request type for the
// GetCampaign API operation.
type GetCampaignRequest struct {
	*aws.Request
	Input *GetCampaignInput
	Copy  func(*GetCampaignInput) GetCampaignRequest
}

// Send marshals and sends the GetCampaign API request.
func (r GetCampaignRequest) Send(ctx context.Context) (*GetCampaignResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCampaignResponse{
		GetCampaignOutput: r.Request.Data.(*GetCampaignOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCampaignResponse is the response type for the
// GetCampaign API operation.
type GetCampaignResponse struct {
	*GetCampaignOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCampaign request.
func (r *GetCampaignResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
