// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabaseRequest
type RebootRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of your database to reboot.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRelationalDatabaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootRelationalDatabaseInput"}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabaseResult
type RebootRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your reboot relational database request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s RebootRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootRelationalDatabase = "RebootRelationalDatabase"

// RebootRelationalDatabaseRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Restarts a specific database in Amazon Lightsail.
//
// The reboot relational database operation supports tag-based access control
// via resource tags applied to the resource identified by relationalDatabaseName.
// For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using RebootRelationalDatabaseRequest.
//    req := client.RebootRelationalDatabaseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase
func (c *Client) RebootRelationalDatabaseRequest(input *RebootRelationalDatabaseInput) RebootRelationalDatabaseRequest {
	op := &aws.Operation{
		Name:       opRebootRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootRelationalDatabaseInput{}
	}

	req := c.newRequest(op, input, &RebootRelationalDatabaseOutput{})
	return RebootRelationalDatabaseRequest{Request: req, Input: input, Copy: c.RebootRelationalDatabaseRequest}
}

// RebootRelationalDatabaseRequest is the request type for the
// RebootRelationalDatabase API operation.
type RebootRelationalDatabaseRequest struct {
	*aws.Request
	Input *RebootRelationalDatabaseInput
	Copy  func(*RebootRelationalDatabaseInput) RebootRelationalDatabaseRequest
}

// Send marshals and sends the RebootRelationalDatabase API request.
func (r RebootRelationalDatabaseRequest) Send(ctx context.Context) (*RebootRelationalDatabaseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootRelationalDatabaseResponse{
		RebootRelationalDatabaseOutput: r.Request.Data.(*RebootRelationalDatabaseOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootRelationalDatabaseResponse is the response type for the
// RebootRelationalDatabase API operation.
type RebootRelationalDatabaseResponse struct {
	*RebootRelationalDatabaseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootRelationalDatabase request.
func (r *RebootRelationalDatabaseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
