// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificateRequest
type CreateLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// An array of strings listing alternative domains and subdomains for your SSL/TLS
	// certificate. Lightsail will de-dupe the names for you. You can have a maximum
	// of 9 alternative names (in addition to the 1 primary domain). We do not support
	// wildcards (e.g., *.example.com).
	CertificateAlternativeNames []string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name (e.g., example.com) for your SSL/TLS certificate.
	//
	// CertificateDomainName is a required field
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string" required:"true"`

	// The SSL/TLS certificate name.
	//
	// You can have up to 10 certificates in your account at one time. Each Lightsail
	// load balancer can have up to 2 certificates associated with it at one time.
	// There is also an overall limit to the number of certificates that can be
	// issue in a 365-day period. For more information, see Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The load balancer name where you want to create the SSL/TLS certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLoadBalancerTlsCertificateInput"}

	if s.CertificateDomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateDomainName"))
	}

	if s.CertificateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateName"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificateResult
type CreateLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the API operations.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLoadBalancerTlsCertificate = "CreateLoadBalancerTlsCertificate"

// CreateLoadBalancerTlsCertificateRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates a Lightsail load balancer TLS certificate.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// The create load balancer tls certificate operation supports tag-based access
// control via resource tags applied to the resource identified by loadBalancerName.
// For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateLoadBalancerTlsCertificateRequest.
//    req := client.CreateLoadBalancerTlsCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate
func (c *Client) CreateLoadBalancerTlsCertificateRequest(input *CreateLoadBalancerTlsCertificateInput) CreateLoadBalancerTlsCertificateRequest {
	op := &aws.Operation{
		Name:       opCreateLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerTlsCertificateInput{}
	}

	req := c.newRequest(op, input, &CreateLoadBalancerTlsCertificateOutput{})
	return CreateLoadBalancerTlsCertificateRequest{Request: req, Input: input, Copy: c.CreateLoadBalancerTlsCertificateRequest}
}

// CreateLoadBalancerTlsCertificateRequest is the request type for the
// CreateLoadBalancerTlsCertificate API operation.
type CreateLoadBalancerTlsCertificateRequest struct {
	*aws.Request
	Input *CreateLoadBalancerTlsCertificateInput
	Copy  func(*CreateLoadBalancerTlsCertificateInput) CreateLoadBalancerTlsCertificateRequest
}

// Send marshals and sends the CreateLoadBalancerTlsCertificate API request.
func (r CreateLoadBalancerTlsCertificateRequest) Send(ctx context.Context) (*CreateLoadBalancerTlsCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLoadBalancerTlsCertificateResponse{
		CreateLoadBalancerTlsCertificateOutput: r.Request.Data.(*CreateLoadBalancerTlsCertificateOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLoadBalancerTlsCertificateResponse is the response type for the
// CreateLoadBalancerTlsCertificate API operation.
type CreateLoadBalancerTlsCertificateResponse struct {
	*CreateLoadBalancerTlsCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLoadBalancerTlsCertificate request.
func (r *CreateLoadBalancerTlsCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
