// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfigurationRequest
type ListUsageForLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// List of filters to apply.
	Filters []Filter `type:"list"`

	// ARN of the targeted LicenseConfiguration object.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListUsageForLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsageForLicenseConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUsageForLicenseConfigurationInput"}

	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfigurationResponse
type ListUsageForLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An array of LicenseConfigurationUsage objects.
	LicenseConfigurationUsageList []LicenseConfigurationUsage `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListUsageForLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUsageForLicenseConfiguration = "ListUsageForLicenseConfiguration"

// ListUsageForLicenseConfigurationRequest returns a request value for making API operation for
// AWS License Manager.
//
// Lists all license usage records for a license configuration, displaying license
// consumption details by resource at a selected point in time. Use this action
// to audit the current license consumption for any license inventory and configuration.
//
//    // Example sending a request using ListUsageForLicenseConfigurationRequest.
//    req := client.ListUsageForLicenseConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration
func (c *Client) ListUsageForLicenseConfigurationRequest(input *ListUsageForLicenseConfigurationInput) ListUsageForLicenseConfigurationRequest {
	op := &aws.Operation{
		Name:       opListUsageForLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsageForLicenseConfigurationInput{}
	}

	req := c.newRequest(op, input, &ListUsageForLicenseConfigurationOutput{})
	return ListUsageForLicenseConfigurationRequest{Request: req, Input: input, Copy: c.ListUsageForLicenseConfigurationRequest}
}

// ListUsageForLicenseConfigurationRequest is the request type for the
// ListUsageForLicenseConfiguration API operation.
type ListUsageForLicenseConfigurationRequest struct {
	*aws.Request
	Input *ListUsageForLicenseConfigurationInput
	Copy  func(*ListUsageForLicenseConfigurationInput) ListUsageForLicenseConfigurationRequest
}

// Send marshals and sends the ListUsageForLicenseConfiguration API request.
func (r ListUsageForLicenseConfigurationRequest) Send(ctx context.Context) (*ListUsageForLicenseConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUsageForLicenseConfigurationResponse{
		ListUsageForLicenseConfigurationOutput: r.Request.Data.(*ListUsageForLicenseConfigurationOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListUsageForLicenseConfigurationResponse is the response type for the
// ListUsageForLicenseConfiguration API operation.
type ListUsageForLicenseConfigurationResponse struct {
	*ListUsageForLicenseConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUsageForLicenseConfiguration request.
func (r *ListUsageForLicenseConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
